if (window.isWebAssistEnable) {
    Ext.ns("kerio.wm.assist");
    kerio.wm.assist.setModule = function(e, t) {
        kerio.wm.assist.previousModule = kerio.wm.assist.activeModule;
        kerio.wm.assist.activeModule = e;
        kerio.wm.assist.action = t;
    };
    kerio.wm.assist.setActivePanel = function(e) {
        kerio.wm.assist.activePanel = e;
    };
    if (window.k_webAssist.isCallstackSupported) {
        Ext.util.DelayedTask = function(e, t, i) {
            var s, n = this, o = function() {
                clearInterval(s);
                s = null;
                try {
                    e.apply(t, i || []);
                } catch (n) {
                    window.unhandledException(n);
                }
                Ext.EventManager.idleEvent.fire();
            };
            this.delay = function(r, a, l, d) {
                n.cancel();
                e = a || e;
                t = l || t;
                i = d || i;
                s = setInterval(o, r);
            };
            this.cancel = function() {
                if (s) {
                    clearInterval(s);
                    s = null;
                }
            };
        };
        Ext.functionFactory = function() {
            var e, t = Array.prototype.slice.call(arguments);
            if (Ext.isSandboxed) {
                e = t.length;
                if (e > 0) {
                    e--;
                    t[e] = "try {var Ext=window." + Ext.name + ";" + t[e] + "} catch (err) {window.unhandledException(err);}";
                }
            }
            return Function.prototype.constructor.apply(Function.prototype, t);
        };
        Ext.Function.bind = function(e, t, i, s) {
            if (2 === arguments.length) {
                return function() {
                    try {
                        return e.apply(t, arguments);
                    } catch (i) {
                        window.unhandledException(i);
                    }
                };
            }
            var n = e, o = Array.prototype.slice;
            return function() {
                var e = i || arguments;
                if (s === !0) {
                    e = o.call(arguments, 0);
                    e = e.concat(i);
                } else {
                    if ("number" == typeof s) {
                        e = o.call(arguments, 0);
                        Ext.Array.insert(e, s, i);
                    }
                }
                try {
                    return n.apply(t || window, e);
                } catch (r) {
                    window.unhandledException(r);
                }
            };
        };
        Ext.EventManager.createListenerWrap = function(e, t, i, s, n) {
            n = n || {};
            var o, r, a = new RegExp("\\\\", "g"), l = function(d, c) {
                if (!r) {
                    o = [ "if(!" + Ext.name + ") {return;}" ];
                    if (n.buffer || n.delay || n.freezeEvent) {
                        if (n.freezeEvent) {
                            o.push("e = X.EventObject.setEvent(e);");
                        }
                        o.push("e = new X.EventObjectImpl(e, " + (n.freezeEvent ? "true" : "false") + ");");
                    } else {
                        o.push("e = X.EventObject.setEvent(e);");
                    }
                    if (n.delegate) {
                        o.push('var result, t = e.getTarget("' + (n.delegate + "").replace(a, "\\\\") + '", this);');
                        o.push("if(!t) {return;}");
                    } else {
                        o.push("var t = e.target, result;");
                    }
                    if (n.target) {
                        o.push("if(e.target !== options.target) {return;}");
                    }
                    if (n.stopEvent) {
                        o.push("e.stopEvent();");
                    } else {
                        if (n.preventDefault) {
                            o.push("e.preventDefault();");
                        }
                        if (n.stopPropagation) {
                            o.push("e.stopPropagation();");
                        }
                    }
                    if (n.normalized === !1) {
                        o.push("e = e.browserEvent;");
                    }
                    if (n.buffer) {
                        o.push("(wrap.task && clearTimeout(wrap.task));");
                        o.push("wrap.task = setTimeout(function() {");
                    }
                    if (n.delay) {
                        o.push("wrap.tasks = wrap.tasks || [];");
                        o.push("wrap.tasks.push(setTimeout(function() {");
                    }
                    o.push("result = fn.call(scope || dom, e, t, options);");
                    if (n.single) {
                        o.push("evtMgr.removeListener(dom, ename, fn, scope);");
                    }
                    if ("mousemove" !== t && "unload" !== t) {
                        o.push("if (evtMgr.idleEvent.listeners.length) {");
                        o.push("evtMgr.idleEvent.fire();");
                        o.push("}");
                    }
                    if (n.delay) {
                        o.push("}, " + n.delay + "));");
                    }
                    if (n.buffer) {
                        o.push("}, " + n.buffer + ");");
                    }
                    o.push("return result;");
                    r = Ext.cacheableFunctionFactory("e", "options", "fn", "scope", "ename", "dom", "wrap", "args", "X", "evtMgr", o.join("\n"));
                }
                try {
                    return r.call(e, d, n, i, s, t, e, l, c, Ext, Ext.EventManager);
                } catch (h) {
                    window.unhandledException(h);
                }
            };
            return l;
        };
    }
}

window.kerio = window.kerio || {};

kerio.HTMLFilter = function(e) {
    e = e || {};
    this.parser = new window.DOMParser();
    this.serializer = new window.XMLSerializer();
    this.A_CLASS = e.aClass || !1;
    this._style = [];
    this.PREFIX = e.stylePrefix || "mcnt";
    this.MAIL_CLS = "mailto";
    this.CSS_PREFIX = (e.cssPrefix || ".email-body") + " ";
    if (e.alternativeText === !1) {
        this.ALTERNATIVE_TEXT = !1;
    } else {
        this.ALTERNATIVE_TEXT = e.alternativeText === !0 ? k_tr("This image cannot be displayed.", "shared") : e.alternativeText;
    }
};

kerio.HTMLFilter.prototype = {
    BLOK_ELEMENTS: {
        address: 1,
        blockquote: 1,
        center: 1,
        dir: 1,
        div: 1,
        dl: 1,
        fieldset: 1,
        form: 1,
        h1: 1,
        h2: 1,
        h3: 1,
        h4: 1,
        h5: 1,
        h6: 1,
        hr: 1,
        isindex: 1,
        ol: 1,
        li: 1,
        p: 1,
        pre: 1,
        table: 1,
        tr: 1,
        ul: 1
    },
    ALLOWED_ELEMENTS: {
        blockquote: 1,
        center: 1,
        dir: 1,
        div: 1,
        dl: 1,
        fieldset: 1,
        form: 1,
        h1: 1,
        h2: 1,
        h3: 1,
        h4: 1,
        h5: 1,
        h6: 1,
        hr: 1,
        isindex: 1,
        ol: 1,
        p: 1,
        pre: 1,
        table: 1,
        ul: 1,
        a: 1,
        abbr: 1,
        acronym: 1,
        address: 1,
        area: 1,
        b: 1,
        bdo: 1,
        big: 1,
        br: 1,
        caption: 1,
        cite: 1,
        code: 1,
        col: 1,
        colgroup: 1,
        dd: 1,
        dfn: 1,
        em: 1,
        i: 1,
        img: 1,
        label: 1,
        legend: 1,
        li: 1,
        map: 1,
        q: 1,
        small: 1,
        span: 1,
        strong: 1,
        strike: 1,
        s: 1,
        sub: 1,
        sup: 1,
        tbody: 1,
        td: 1,
        tfoot: 1,
        th: 1,
        thead: 1,
        tr: 1,
        tt: 1,
        u: 1,
        font: 1
    },
    ALLOWED_ATTRIBUTES: {
        align: 1,
        alt: 1,
        background: 1,
        bgcolor: 1,
        border: 1,
        "class": 1,
        clear: 1,
        color: 1,
        colspan: 1,
        content: 1,
        face: 1,
        height: 1,
        hspace: 1,
        href: 1,
        "http-equiv": 1,
        id: 1,
        name: 1,
        nowrap: 1,
        rowspan: 1,
        size: 1,
        src: 1,
        extsrc: 1,
        style: 1,
        title: 1,
        type: 1,
        valign: 1,
        vspace: 1,
        width: 1,
        shape: 1,
        target: 1,
        coords: 1,
        usemap: 1
    },
    FALLBACK_POSITION: "static",
    SAFE_POSITIONS: {
        unset: 1,
        inherit: 1,
        initial: 1,
        "static": 1,
        relative: 1
    },
    URL_PATTERN: /^(http|ftp|https|m-files):\/\//i,
    URL_BG_PATTERN: /^url\((['|"]?)(\S+)\1\)/,
    DATA_IMAGE_PATTERN: /^data:image/i,
    REPLACE_PREFIX_PATTERN: /([\D])(\.|#)|(^\.|#)/g,
    REPLACE_PATERN: /,\ /g,
    REPLACE_BODY_PATERN: /^(body)|\s(body)/g,
    _showExternalImg: !1,
    showExternalImg: function(e) {
        this._showExternalImg = e;
    },
    parseHtml: function(e) {
        e = "<!DOCTYPE html>" + e;
        return this.parser.parseFromString(e, "text/html");
    },
    serialize: function(e) {
        return this.serializer.serializeToString(e);
    },
    _isURL: function(e) {
        return this.URL_PATTERN.test(e);
    },
    _isDataImage: function(e) {
        return this.DATA_IMAGE_PATTERN.test(e);
    },
    _replaceAttributUrl: function(e, t) {
        var i = t.value;
        if (this._attachmentsFilter.getInlineAttchPath(i)) {
            t.value = this._attachmentsFilter.getInlineAttchPath(i);
            return !0;
        }
        if (0 === i.toLowerCase().indexOf("cid:")) {
            return !1;
        }
        if (-1 === i.toLowerCase().indexOf("script:")) {
            if (this._showExternalImg || this._isDataImage(i)) {
                return !0;
            }
            if (this._baseURL && !this._isURL(i)) {
                i = this._getUrlFromBase(i);
            }
            e.setAttribute("extsrc", i);
            e.removeAttribute(t.name);
            this._hasExternalImages = !0;
            return !1;
        }
        e.removeAttribute(t.name);
        return !1;
    },
    _getUrlFromBase: function(e) {
        var t, i = this._baseURL || "";
        if ("/" !== i[i.length - 1]) {
            t = i.lastIndexOf("/");
            if (t > i.indexOf("://") + 2) {
                i = i.substring(0, t);
            }
            if (!this._isURL(i)) {
                return e;
            }
        }
        if ("/" === e[0]) {
            i = this._extractBaseUrl(i);
        }
        return i + e;
    },
    _extractBaseUrl: function(e) {
        var t = e.split("/").slice(0, 3);
        return t.join("/");
    },
    _addCssPrefix: function(e) {
        var t, i = e.value.split(/\s+/), s = i.length;
        for (t = 0; s > t; t++) {
            if (i[t] === this.MAIL_CLS) {
                break;
            }
            i[t] = this.PREFIX + i[t];
        }
        e.value = i.join(" ");
    },
    _sanitizeCssValue: function(e) {
        return e.replace(/}.*/, "");
    },
    _filterCssPosition: function(e) {
        if (e && !this.SAFE_POSITIONS[e]) {
            return this.FALLBACK_POSITION;
        }
        return e;
    },
    _filteredStyle: function(e) {
        var t, i, s, n, o, r, a;
        s = e.length;
        this._style = [];
        this._mustAddBodyClass = !1;
        for (t = 0; s > t; t++) {
            n = e[t].sheet;
            if (n) {
                o = n.cssRules;
                for (i = 0; i < o.length; i++) {
                    a = o[i];
                    if (a.style) {
                        a.style.backgroundImage = "";
                    }
                    if (a.selectorText) {
                        if (a.style) {
                            a.style.position = this._filterCssPosition(a.style.position);
                        }
                        r = a.selectorText;
                        r = r.replace(this.REPLACE_PREFIX_PATTERN, "$1$2$3" + this.PREFIX);
                        if (this.REPLACE_BODY_PATERN.test(r)) {
                            r = r.replace(this.REPLACE_BODY_PATERN, ".$1");
                            this._mustAddBodyClass = !0;
                        }
                        r = this.CSS_PREFIX + r.replace(this.REPLACE_PATERN, ", " + this.CSS_PREFIX);
                        this._style.push(a.cssText.replace(a.selectorText, r));
                    }
                }
            }
        }
    },
    getStyles: function() {
        return this._style.length > 0 ? this._style.join("\n") : "";
    },
    hasExternalImages: function() {
        return this._hasExternalImages;
    },
    _removeAllTags: function(e) {
        var t, i, s = e.length;
        for (t = s - 1; t >= 0; t--) {
            i = e[t];
            i.parentNode.removeChild(i);
        }
    },
    transformToPlainText: function(e) {
        var t = [], i = this.parseHtml(e);
        this._removeAllTags(i.getElementsByTagName("style"));
        this._removeAllTags(i.getElementsByTagName("script"));
        this._prepareTextFromChilds(i.body, t);
        return t.reverse().join("");
    },
    _prepareTextFromChilds: function(e, t) {
        var i, s, n = e.childNodes, o = e.tagName.toLowerCase();
        if (n.length > 0) {
            if ("tr" === o) {
                t.push("\n");
            }
            for (i = n.length - 1; i >= 0; i--) {
                s = n[i];
                if (s.nodeType === document.TEXT_NODE) {
                    t.push(this._prepareTextFromNode(s));
                } else {
                    this._prepareTextFromChilds(s, t);
                }
            }
        } else {
            switch (o) {
              case "br":
                t.push("\n");
                break;

              case "hr":
                t.push("\n-------------------------\n");
            }
        }
    },
    _prepareTextFromNode: function(e) {
        var t, i = e.parentNode.tagName.toLowerCase();
        if (this.BLOK_ELEMENTS[i]) {
            t = e.textContent;
            t = "\n" + t + "\n";
        } else {
            if ("a" === i && i.href) {
                t = e.textContent + ":" + i.href;
            } else {
                if ("td" === i) {
                    t = e.textContent + "	";
                } else {
                    t = e.textContent;
                }
            }
        }
        if (t && "" === t.trim()) {
            return "";
        }
        return t;
    },
    _addCls: function(e, t) {
        if (e.classList && e.classList.add) {
            e.classList.add(t);
        } else {
            if (!this.hasCls(e, t)) {
                e.className += " " + t;
            }
        }
    },
    _hasElCls: function(e, t) {
        var i, s;
        if (e.classList && e.classList.contains) {
            return e.classList.contains(t);
        }
        i = e.className.split(" ");
        for (s = 0; s < i.length; s++) {
            if (i[s].toLowerCase() === t.toLowerCase()) {
                return !0;
            }
        }
        return !1;
    },
    removeCls: function(e, t) {
        if (e.classList && e.classList.remove) {
            e.classList.remove(t);
        } else {
            if (this.hasCls(e, t)) {
                var i, s = e.className.split(" "), n = [];
                for (i = 0; i < s.length; i++) {
                    if (s[i].toLowerCase() !== t.toLowerCase()) {
                        n.push(s[i]);
                    }
                }
                e.className = n.join(" ");
            }
        }
    },
    _prepareTable: function(e) {
        var t = e.getAttribute("cellspacing"), i = e.getAttribute("cellpadding");
        if (t && !e.style.borderSpacing) {
            e.style.borderSpacing = parseInt(t, 10);
        }
        if (i) {
            i = parseInt(i, 10);
            if (i > 0) {
                this._convertAttrToInlineStyle(e, "padding", i);
            }
        }
        return e;
    },
    _prepareStyle: function(e, t) {
        var i, s, n = e.style.backgroundImage;
        if ("" !== n && !this._isDataImage(n)) {
            i = this._parseBgUrl(n);
            if (i) {
                s = this._attachmentsFilter.getInlineAttchPath(i);
                if (s) {
                    t = t.replace(i, s);
                    e.setAttribute("style", t);
                } else {
                    if (!this._showExternalImg) {
                        if (this._baseURL && !this._isURL(i)) {
                            i = this._getUrlFromBase(i);
                        }
                        e.setAttribute("extsrc", i);
                        e.style.backgroundImage = "";
                        this._hasExternalImages = !0;
                    }
                }
            }
        }
        e.style.position = this._filterCssPosition(e.style.position);
        return e;
    },
    _parseBgUrl: function(e) {
        var t = this.URL_BG_PATTERN.exec(e);
        if (t) {
            return t[2];
        } else {
            return !1;
        }
    },
    _prepareLink: function(e) {
        var t = e.getAttribute("href");
        if (t) {
            var i = /^\s*javascript:/i, s = /^\s*mailto:/i;
            if (i.test(t)) {
                e.setAttribute("href", t.replace(i, "*Removed*By*KCc*"));
            } else {
                if (s.test(t)) {
                    e.setAttribute("title", k_tr("Send email to %1", "mail", {
                        k_comment: "",
                        k_args: [ t.replace(s, "") ]
                    }));
                    var n = e.getAttribute("class") || "";
                    if (!this._hasElCls(e, this.MAIL_CLS)) {
                        n = this.MAIL_CLS + " " + n;
                    }
                    e.setAttribute("class", n.trim());
                } else {
                    if (this._baseURL) {
                        if (!this._isURL(t)) {
                            e.setAttribute("href", this._getUrlFromBase(t));
                        }
                    }
                }
            }
            if (/\b(?:MSIE|Trident|Edge)\b/i.test(window.navigator.userAgent)) {
                e.setAttribute("href", e.getAttribute("href").replace(/^((?:https?:)?\/\/).*@/i, "$1"));
            }
        }
        e.setAttribute("target", "_blank");
        return e;
    },
    _convertAttrToInlineStyle: function(e, t, i) {
        if (!e.style[t]) {
            e.style[t] = i;
        }
    },
    _prepareBody: function(e) {
        var t, i, s, n = e.attributes;
        for (t = 0; t < n.length; t++) {
            s = n[t].name.toLowerCase();
            i = n[t].value;
            switch (s) {
              case "text":
                this._convertAttrToInlineStyle(e, "color", i);
                break;

              case "leftmargin":
                this._convertAttrToInlineStyle(e, "marginLeft", i);
                break;

              case "rightmargin":
                this._convertAttrToInlineStyle(e, "marginRight", i);
                break;

              case "topmargin":
                this._convertAttrToInlineStyle(e, "marginTop", i);
                break;

              case "bottommargin":
                this._convertAttrToInlineStyle(e, "marginBottom", i);
                break;

              case "link":
                this._style.push(this.CSS_PREFIX + "a {color: " + this._sanitizeCssValue(i) + "}");
                break;

              case "alink":
                this._style.push(this.CSS_PREFIX + "a:active {color: " + this._sanitizeCssValue(i) + "}");
                break;

              case "vlink":
                this._style.push(this.CSS_PREFIX + "a:visible {color: " + this._sanitizeCssValue(i) + "}");
            }
        }
    },
    _prepareAttributes: function(e, t) {
        var i, s, n = {}, o = e.attributes.length;
        for (i = 0; i < e.attributes.length; i++) {
            n[i] = e.attributes[i];
        }
        for (i = 0; o > i; i++) {
            s = n[i].name.toLowerCase();
            if (!this.ALLOWED_ATTRIBUTES[s]) {
                e.removeAttributeNode(n[i]);
            } else {
                switch (s) {
                  case "class":
                  case "id":
                    this._addCssPrefix(n[i]);
                    break;

                  case "style":
                    this._prepareStyle(e, n[i].value);
                    break;

                  case "src":
                    if (!this._replaceAttributUrl(e, n[i])) {
                        if (this.ALTERNATIVE_TEXT && "img" === t && !e.title) {
                            e.title = this.ALTERNATIVE_TEXT;
                            e.setAttribute("data-err-title", !0);
                        }
                    }
                    break;

                  case "background":
                    this._replaceAttributUrl(e, n[i]);
                    break;

                  case "bgcolor":
                    this._convertAttrToInlineStyle(e, "backgroundColor", n[i].value);
                    e.removeAttribute(s);
                    break;

                  case "href":
                    break;

                  default:
                    e.setAttribute(s, Ext.htmlEncode(n[i].value));
                }
            }
        }
    },
    _prepareBodyHTML: function(e) {
        var t, i, s, n;
        this._prepareBody(e);
        this._prepareAttributes(e, "body");
        if (this._mustAddBodyClass) {
            this._addCls(e, "body");
        }
        if (0 === e.attributes.length) {
            return e.innerHTML;
        } else {
            i = e.attributes.length;
            n = [ "<div " ];
            for (t = 0; i > t; t++) {
                s = e.attributes[t];
                n.push(s.name + '="' + s.value + '"');
            }
            n.push(">");
            n.push(e.innerHTML);
            n.push("</div>");
            n = n.join("");
            return n;
        }
    },
    filterHtml: function(e, t) {
        var i, s, n, o, r, a, l, d, c, h, u = this.parseHtml(e);
        this._hasExternalImages = !1;
        if (!u) {
            return !1;
        }
        n = u.getElementsByTagName("body");
        if (t === !1) {
            this._attachmentsFilter = {
                getInlineAttchPath: function() {
                    return !1;
                }
            };
        } else {
            if (t instanceof kerio.AttachmentsFilter) {
                this._attachmentsFilter = t;
            } else {
                return;
            }
        }
        c = u.getElementsByTagName("base")[0];
        if (c) {
            this._baseURL = c.getAttribute("href") || !1;
            if (!this._isURL(this._baseURL)) {
                this._baseURL = !1;
            }
        } else {
            this._baseURL = !1;
        }
        this._filteredStyle(u.getElementsByTagName("style"));
        if (n.length > 0) {
            n = n[0];
            h = n.getElementsByTagName("*");
        } else {
            return "";
        }
        for (i = h.length - 1; i >= 0; i--) {
            a = h[i];
            d = a.tagName.toLowerCase();
            if (this.ALLOWED_ELEMENTS[d]) {
                switch (d) {
                  case "a":
                    this._prepareLink(a);
                    break;

                  case "table":
                    this._prepareTable(a);
                }
                this._prepareAttributes(a, d);
            } else {
                o = a.childNodes;
                l = a.parentNode;
                if ("script" !== d && "style" !== d) {
                    r = o.length;
                    for (s = 0; r > s; s++) {
                        l.insertBefore(o[s].cloneNode(!0), a);
                    }
                }
                l.removeChild(a);
            }
        }
        return this._prepareBodyHTML(n);
    },
    enableExternalImages: function(e) {
        var t, i, s, n, o = this.parseHtml(e), r = o.body.querySelectorAll("[extsrc]");
        for (s = 0, n = r.length; n > s; s++) {
            t = r[s];
            i = t.getAttribute("extsrc");
            if (i) {
                if ("img" === t.tagName.toLowerCase()) {
                    try {
                        t.setAttribute("src", i);
                    } catch (a) {
                        t.setAttribute("src", "error.jpg");
                    }
                } else {
                    if (!t.hasAttribute("style")) {
                        t.setAttribute("style", "");
                    }
                    t.style.backgroundImage = "url(" + i + ")";
                }
                t.removeAttribute("extsrc");
                if (t.getAttribute("data-err-title")) {
                    t.removeAttribute("title");
                    t.removeAttribute("data-err-title");
                }
            }
        }
        return o.body.innerHTML;
    }
};

window.kerio = window.kerio || {};

kerio.AttachmentsFilter = function(e) {
    var t, i = e.attachments, s = i.length;
    this._attachments = [];
    this._inlineAttachmentPaths = {};
    this._inlineAttachment = {};
    this._unusedInlineAttachments = {};
    for (t = 0; s > t; t++) {
        if (this.FILTERED_CONTENT_TYPES[i[t].contentType]) {
            continue;
        }
        if ("" !== i[t].contentId) {
            this._inlineAttachmentPaths["cid:" + i[t].contentId] = i[t].url;
            this._unusedInlineAttachments["cid:" + i[t].contentId] = i[t];
        } else {
            this._attachments.push(i[t]);
        }
    }
    this.mail = e;
};

kerio.AttachmentsFilter.prototype = {
    FILTERED_CONTENT_TYPES: {
        "message/delivery-status": 1,
        "text/rfc822-headers": 1,
        "application/pkcs7-signature": 1,
        "application/x-pkcs7-signature": 1
    },
    getInlineAttchPath: function(e) {
        var t, i = this._unusedInlineAttachments[e];
        if (i) {
            this._inlineAttachment[e] = this._unusedInlineAttachments[e];
            delete this._unusedInlineAttachments[e];
        }
        t = this._inlineAttachmentPaths[e];
        return kerio && kerio.wm && kerio.wm.AppInterface ? kerio && kerio.wm && kerio.wm.AppInterface.getInlineAttachmentPath(t) : t;
    },
    flushChanges: function() {
        var e, t, i;
        this.mail.attachments.splice(0, this.mail.attachments.length);
        e = this._attachments.length;
        for (i = 0; e > i; i++) {
            this.mail.attachments.push(this._attachments[i]);
        }
        for (t in this._unusedInlineAttachments) {
            if (this._unusedInlineAttachments.hasOwnProperty(t)) {
                this.mail.attachments.push(this._unusedInlineAttachments[t]);
            }
        }
        if (!this.mail.inlineAttachments) {
            this.mail.inlineAttachments = [];
        }
        for (t in this._inlineAttachment) {
            if (this._inlineAttachment.hasOwnProperty(t)) {
                this.mail.inlineAttachments.push(this._inlineAttachment[t]);
            }
        }
    }
};

window.kerio = window.kerio || {};

kerio.LinkCreator = function(e) {
    e = e || {};
    this.parser = new window.DOMParser();
    this._span = document.createElement("span");
};

kerio.LinkCreator.prototype = {
    EMAIL_PATTERN: /([a-zA-Z0-9._\-\+\=]+@[a-zA-Z0-9.\-]+\.[a-zA-Z]{2,})/gi,
    URL_PATTERN: new RegExp("((?:(?:(?:(?:http)|(?:https)|(?:ftp)|(?:m-files)):\\/\\/(?:(?:[a-zA-Z0-9][a-zA-Z0-9-:@]*(?:\\.[a-zA-Z0-9][a-zA-Z0-9-]*)*)|(?:[1-9][0-9]{0,2}(\\.[1-9][0-9]{0,2}){3}))))(?::[0-9]+)?(?:(?:\\/(?:[a-Ž0-9\\-\\._~:@!$&\\'\\*\\+,;=]|(?:%[0-9A-F]{2}))*(?:\\((?:[a-Ž0-9\\-\\._~:@!$&\\'\\*\\+,;=]|(?:%[0-9A-F]{2}))*\\))*(?:[a-Ž0-9\\-\\._~:@!$&\\'\\*\\+,;=]|(?:%[0-9A-F]{2}))*)*(?:\\?(?:(?:[a-Ž0-9\\-\\._~:@!$&\\'\\(\\)*+,;=\\/]|(?:%[0-9A-F]{2})))+)?(?:#(?:(?:[a-Ž0-9\\-\\._~:@!$&\\'\\(\\)*+,;=\\/?]|(?:%[0-9A-F]{2})))*)?)?)", "gmi"),
    URL_PATTERN_SHORT: /(\b(www\.[\S]+(\b|$)))/gi,
    encode: function() {
        var e, t, i = [], s = {
            "&": "&amp;",
            ">": "&gt;",
            "<": "&lt;",
            '"': "&quot;"
        };
        for (e in s) {
            if (s.hasOwnProperty(e)) {
                i.push(e);
            }
        }
        t = new RegExp("(" + i.join("|") + ")", "g");
        return function(e) {
            return !e ? e : String(e).replace(t, function(e, t) {
                return s[t];
            });
        };
    }(),
    _prepareChilds: function(e) {
        var t, i, s, n, o = e.childNodes;
        for (t = 0; t < o.length; t++) {
            n = o[t];
            if (n.nodeType === document.TEXT_NODE) {
                i = n.data.replace(/(<|>|")/g, " $1");
                i = this.encode(i);
                s = this.replaceURLs(i);
                s = s.replace(/ (&lt;|&gt;|&quot;)/g, "$1");
                s = this.replaceEmails(s);
                if (i !== s) {
                    t += this._replaceTextNodeHtml(n, s);
                }
            } else {
                if (n.nodeType === document.ELEMENT_NODE && "A" === n.nodeName) {
                    kerio.wm.utils.htmlHelper.decodeNode(n);
                }
            }
        }
    },
    _replaceTextNodeHtml: function(e, t) {
        var i, s, n = e.parentNode;
        this._span.innerHTML = t;
        i = this._span.childNodes;
        s = i.length;
        while (i.length > 1) {
            n.insertBefore(i[0], e);
        }
        n.replaceChild(i[0], e);
        return s - 1;
    },
    replace: function(e) {
        var t, i, s, n;
        if (!e) {
            return e;
        }
        if ("string" == typeof e) {
            i = this.parser.parseFromString(e, "text/html").body;
        } else {
            if ("object" == typeof e && i.tagName) {
                i = e;
            }
        }
        if (!i) {
            return e;
        }
        n = i.querySelectorAll(":not(a)");
        this._prepareChilds(i);
        s = n.length;
        for (t = 0; s > t; t++) {
            this._prepareChilds(n[t]);
        }
        return i.innerHTML;
    },
    replaceShortUrl: function(e) {
        return e.replace(this.URL_PATTERN_SHORT, '<a href="http://$1" title="http://$1" target="_blank">$1</a>');
    },
    replaceURLs: function(e) {
        var t, i, s, n, o = e.replace(this.URL_PATTERN, '<a href="$1" title="$1" target="_blank">$1</a>');
        if (o === e) {
            o = this.replaceShortUrl(o);
        } else {
            i = document.createElement("span");
            i.innerHTML = o;
            n = i.childNodes;
            for (t = 0; t < n.length; t++) {
                s = n[t];
                if (s.nodeType === document.TEXT_NODE) {
                    e = s.data;
                    o = this.replaceShortUrl(e);
                    if (e !== o) {
                        t += this._replaceTextNodeHtml(s, o);
                    }
                }
            }
            o = i.innerHTML;
        }
        return o;
    },
    replaceEmailsPattern: function(e) {
        return e.replace(this.EMAIL_PATTERN, '<a href="mailto:$1" class="mailto">$1</a>');
    },
    replaceEmails: function(e) {
        var t = "<a";
        var i = "</a>";
        var s = e;
        var n = s.indexOf(t);
        var o = -1;
        var r = "";
        var a = "";
        while (-1 !== n) {
            a = s.substring(0, n);
            r += this.replaceEmailsPattern(a);
            s = s.substring(n);
            var o = s.indexOf(i);
            if (-1 === o) {
                return r + s;
            }
            a = s.substring(0, o + i.length);
            r += a;
            s = s.substring(o + i.length);
            n = s.indexOf(t);
        }
        return r + this.replaceEmailsPattern(s);
    }
};

if (Ext.is && !Ext.is.iPad && !Ext.is.iPhone && !Ext.is.Android) {
    window.onscroll = function() {
        window.scrollTo(0, 0);
    };
}

if (Ext.isGecko) {
    Ext.getDoc().on("keydown", function(e) {
        if (e.ESC === e.getKey()) {
            e.preventDefault();
        }
    });
}

if (Ext.isIE8) {
    String.prototype.trim = function() {
        return this.replace(/^\s+|\s+$/g, "");
    };
}

Ext.namespaceFn = Ext.namespaceFn || function(e, t) {
    var i = Ext.namespace(e);
    i = Ext.apply(i, t);
    return i;
};

Ext.namespaceFn("kerio.lib", {
    k_reportError: function(e, t, i, s) {
        if (void 0 === i) {
            i = "N/A";
        }
        if (window.k_webAssist && void 0 !== s) {
            window.k_webAssist.k_callStack = s;
        }
        if (window.onerror) {
            if (t.lastIndexOf(".js") !== t.length - 3) {
                t += ".js";
            }
            t = document.location.protocol + "//" + document.location.host + "/" + t;
            window.onerror(e, t, i);
        } else {
            throw new Error(e + " [" + t + ":" + i + "]");
        }
    },
    k_htmlEncode: function(e) {
        return Ext.htmlEncode(e);
    }
});

Ext.namespaceFn("kerio.wm", {
    notImplemented: function() {
        Ext.Msg.alert("Not yet implemented", "Sorry, functionality is not yet implemented.");
    },
    abstractMethodNotImplemented: function() {}
});

Ext.namespaceFn("kerio.ws", {
    abstractFn: function() {
        kerio.wm.abstractMethodNotImplemented();
    }
});

if (!window.kerio) {
    kerio = {
        lib: {
            k_reportError: window.alert
        }
    };
}

kerio.lib.k_setSupportedLanguages = function(e) {
    if (!kerio.lib._k_settings) {
        kerio.lib._k_settings = {};
    }
    kerio.lib._k_settings._k_supportedLanguages = e;
};

kerio.lib.k_getSupportedLanguages = function() {
    if (kerio.lib._k_settings) {
        return kerio.lib._k_settings._k_supportedLanguages;
    } else {
        return;
    }
};

kerio.lib.k_getCalculatedLanguage = function(e) {
    var t, i, s, n = kerio.lib.k_getSupportedLanguages().join(",");
    for (i = 0, s = e.length; s > i; i++) {
        t = e[i].substring(0, 2);
        if (-1 !== n.indexOf(t)) {
            return e[i];
        }
    }
    return "en";
};

kerio.lib.k_getGrammarCategory = function(e) {
    var t, i, s, n = "singular", o = "dual", r = "plural";
    s = kerio.lib.k_translation.k_currentLanguage || kerio.lib.k_engineConstants.k_CURRENT_LANGUAGE;
    switch (s) {
      case "cs":
      case "sk":
        if (1 === e) {
            return n;
        }
        if (e > 1 && 5 > e) {
            return o;
        }
        break;

      case "fr":
        if (2 > e) {
            return n;
        }
        break;

      case "ru":
        t = e % 10;
        i = e % 100;
        if (1 === t && 11 !== i) {
            return n;
        }
        if (t > 1 && 5 > t && (10 > i || i > 20)) {
            return o;
        }
        break;

      case "pl":
        if (1 === e) {
            return n;
        }
        t = e % 10;
        i = e % 100;
        if (t > 1 && 5 > t && (10 > i || i > 20)) {
            return o;
        }
        break;

      case "hr":
        t = e % 10;
        i = e % 100;
        if (1 === t && 11 !== i) {
            return n;
        }
        if (t > 1 && 5 > t && (12 > i || i > 14)) {
            return o;
        }
        break;

      default:
        if (1 === e) {
            return n;
        }
    }
    return r;
};

kerio.lib.k_tr = function(e, t, i) {
    if ("" === e) {
        return e;
    }
    var s, n, o, r, a, l, d = e, c = "common", h = !1;
    if (void 0 === i) {
        i = {};
    }
    if (void 0 !== i.k_pluralityBy) {
        h = !0;
    }
    if (void 0 === t) {
        t = c;
    }
    if (kerio.lib.k_translation) {
        if (kerio.lib.k_translation[t]) {
            d = kerio.lib.k_translation[t][e];
            if (void 0 === d && c !== t && kerio.lib.k_translation[c]) {
                d = kerio.lib.k_translation[c][e];
            }
            if (void 0 === d) {
                d = kerio.lib._k_createEngPluralText(e);
            }
        } else {
            d = kerio.lib._k_createEngPluralText(e);
        }
    }
    s = !1;
    if ("object" == typeof d) {
        s = !0;
    }
    if (s && !h) {
        kerio.lib.k_reportError("Internal error: Translator error\nenMessage: " + e + "\nContext: " + t + "\n\nNo plurality parameters defined but required!", "translator.js");
        return d.k_singular;
    }
    if (s && h) {
        switch (kerio.lib.k_getGrammarCategory(i.k_pluralityBy)) {
          case "singular":
            if (void 0 !== d.k_singular) {
                d = d.k_singular;
            } else {
                kerio.lib.k_reportError("Internal error: Translator error\nenMessage: " + e + "\nContext: " + t + "\n\nSingular not defined!", "translator.js");
            }
            break;

          case "dual":
            if (void 0 !== d.k_dual) {
                d = d.k_dual;
            } else {
                kerio.lib.k_reportError("Internal error: Translator error\nenMessage: " + e + "\nContext: " + t + "\n\nDual/Paucal not defined!", "translator.js");
            }
            break;

          default:
            if (void 0 !== d.k_plural) {
                d = d.k_plural;
            } else {
                kerio.lib.k_reportError("Internal error: Translator error\nenMessage: " + e + "\nContext: " + t + "\n\nPlural not defined!", "translator.js");
            }
        }
    }
    n = !1;
    if (-1 !== d.toString().indexOf("%")) {
        n = !0;
    }
    o = !1;
    if (void 0 !== i.k_args) {
        o = !0;
    }
    if (n && !o) {
        kerio.lib.k_reportError("Internal error: Translator error\nenMessage: " + e + "\nContext: " + t + "\n\nNo placeholder parameters defined but required!", "translator.js");
        return d;
    }
    if (n && o) {
        r = i.k_args;
        l = r.length;
        for (a = 0; l > a; a++) {
            d = d.replace("%" + (a + 1), "{%" + (a + 1) + "%}");
        }
        for (a = 0; l > a; a++) {
            d = d.replace("{%" + (a + 1) + "%}", !0 === i.k_isSecure ? r[a] : kerio.lib.k_htmlEncode(r[a]));
        }
    }
    return d;
};

kerio.lib._k_createEngPluralText = function(e) {
    var t, i = new RegExp("[^\\[]*(\\[([^\\[\\|\\]]{1,})\\|([^\\]\\|\\[]{1,})\\]).*");
    if (!i.test(e)) {
        return e;
    }
    t = {
        k_singular: e,
        k_plural: e
    };
    kerio.lib._k_compileCompoundText(t, i);
    return {
        k_singular: t.k_singular,
        k_dual: t.k_plural,
        k_plural: t.k_plural
    };
};

kerio.lib._k_compileCompoundText = function(e, t) {
    var i, s;
    if (!t.test(e.k_singular) || !t.test(e.k_plural)) {
        return;
    }
    i = t.exec(e.k_singular);
    s = t.exec(e.k_plural);
    e.k_singular = i[0].replace(i[1], i[2]);
    e.k_plural = s[0].replace(s[1], s[3]);
    kerio.lib._k_compileCompoundText(e, t);
};

kerio.lib.K_TouchController = function(e) {
    var t = e.k_element;
    this.k_callbacks = {
        touchstart: e.k_onTouchStart,
        touchmove: e.k_onTouchMove,
        touchend: e.k_onTouchEnd,
        k_onSingleTap: e.k_onSingleTap,
        k_onDoubleTap: e.k_onDoubleTap,
        k_scope: e.k_scope
    };
    this.k_preventDefault = e.k_preventDefault;
    t.addEventListener("touchstart", this, !1);
    t.addEventListener("touchmove", this, !1);
    t.addEventListener("touchend", this, !1);
};

kerio.lib.K_TouchController.prototype = {
    _k_firstFingerTouched: !1,
    handleEvent: function(e) {
        var t = e.type, i = this.k_callbacks[t];
        switch (t) {
          case "touchstart":
            this.k_onTouchStart(e);
            break;

          case "touchmove":
            this.k_onTouchMove(e);
            break;

          case "touchend":
            this.k_onTouchEnd(e);
        }
        if (i) {
            i.call(this.k_callbacks.k_scope, this.k_status);
        }
        if (!1 !== this.k_preventDefault) {
            e.preventDefault();
        }
    },
    k_onTouchStart: function(e) {
        var t = e.touches[0];
        if (!this._k_firstFingerTouched) {
            this.k_status = {
                k_firstFingerId: t.identifier,
                k_startTime: e.timeStamp,
                k_startX: t.clientX,
                k_startY: t.clientY,
                k_totalOffsetX: 0,
                k_totalOffsetY: 0,
                k_offsetX: 0,
                k_offsetY: 0,
                k_count: 0,
                k_maxFingers: 0,
                k_hostStatus: {},
                k_createExtEventFromTouch: this._k_createExtEventFromTouch
            };
        }
        this._k_updateStatus(e);
        if (!this._k_firstFingerTouched) {
            this.k_status.k_isFirstTouch = !0;
            this._k_firstFingerTouched = !0;
        }
    },
    k_onTouchMove: kerio.lib.k_isAndroidTablet && kerio.lib.k_isChrome ? function(e) {
        e.preventDefault();
        this._k_updateStatus(e);
    } : function(e) {
        this._k_updateStatus(e);
    },
    k_onTouchEnd: function(e) {
        var t, i = this.k_status, s = e.timeStamp - i.k_startTime;
        this._k_updateStatus(e);
        if (0 === e.touches.length) {
            this._k_firstFingerTouched = !1;
            i.k_velocityX = (i.k_currentX - i.k_startX) / s;
            i.k_velocityY = (i.k_currentY - i.k_startY) / s;
            i.k_duration = s;
        }
        if (320 > s) {
            switch (i.k_maxFingers) {
              case 1:
                t = this.k_callbacks.k_onSingleTap;
                break;

              case 2:
                t = this.k_callbacks.k_onDoubleTap;
            }
            if (t) {
                t.call(this.k_callbacks.k_scope, this.k_status);
            }
        }
    },
    _k_updateStatus: function(e) {
        var t, i, s, n = this.k_status;
        for (i = 0, s = e.changedTouches.length; s > i; i++) {
            if (n.k_firstFingerId === e.changedTouches[i].identifier) {
                t = e.changedTouches[i];
                break;
            }
        }
        n.k_isFirstTouch = !1;
        if (t) {
            n.k_totalOffsetX = t.clientX - n.k_startX;
            n.k_totalOffsetY = t.clientY - n.k_startY;
            n.k_offsetX = t.clientX - n.k_currentX;
            n.k_offsetY = t.clientY - n.k_currentY;
            n.k_currentX = t.clientX;
            n.k_currentY = t.clientY;
        }
        n.k_count += 1;
        n.k_fingers = e.touches.length;
        n.k_maxFingers = Math.max(e.touches.length, n.k_maxFingers);
        n.k_event = e;
        n.k_scale = e.scale;
        n.k_rotation = e.rotation;
        n.k_touchCollections = {
            touches: e.touches,
            changedTouches: e.changedTouches,
            targetTouches: e.targetTouches
        };
    },
    _k_createExtEventFromTouch: function(e, t) {
        var i, s = this;
        if (kerio.lib.k_isAndroidTablet) {
            i = Ext.EventObject.setEvent(s.k_event.touches[0]);
        } else {
            i = Ext.EventObject.setEvent(s.k_event);
        }
        i.type = e;
        i.button = 0;
        i.xy = [ s.k_currentX, s.k_currentY ];
        if (t) {
            i.browserEvent = {
                target: document.elementFromPoint(s.k_currentX, s.k_currentY)
            };
        }
        return i;
    }
};

window.k_tr = kerio.lib.k_tr;

kerio.lib.k_translation = kerio.lib.translation;

if (void 0 === window.kerio) {
    window.kerio = {};
}

if (void 0 === kerio.api) {
    kerio.api = {};
}

if (void 0 === kerio.api.consts) {
    kerio.api.consts = {};
}

if (void 0 === kerio.api.enums) {
    kerio.api.enums = {};
}

if (void 0 === kerio.api.structs) {
    kerio.api.structs = {};
}

if (void 0 === kerio.api.type) {
    kerio.api.type = {};
}

kerio.api.type.NamedValue = function() {};

kerio.api.type.NamedValue.prototype = {
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getValue: function() {
        return this.value;
    },
    setValue: function(e) {
        this.value = e;
    }
};

kerio.api.type.NamedValue.fields = {
    ALL_FIELDS: [ "name", "value" ],
    name: "name",
    value: "value"
};

kerio.api.type.NamedMultiValue = function() {};

kerio.api.type.NamedMultiValue.prototype = {
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getValue: function() {
        return this.value;
    },
    setValue: function(e) {
        this.value = e;
    }
};

kerio.api.type.NamedMultiValue.fields = {
    ALL_FIELDS: [ "name", "value" ],
    name: "name",
    value: "value"
};

kerio.api.enums.SortDirection = {
    Asc: "Asc",
    Desc: "Desc"
};

kerio.api.enums.CompareOperator = {
    Eq: "Eq",
    NotEq: "NotEq",
    LessThan: "LessThan",
    GreaterThan: "GreaterThan",
    LessEq: "LessEq",
    GreaterEq: "GreaterEq",
    Like: "Like"
};

kerio.api.enums.LogicalOperator = {
    Or: "Or",
    And: "And"
};

kerio.api.type.SubCondition = function() {};

kerio.api.type.SubCondition.prototype = {
    getFieldName: function() {
        return this.fieldName;
    },
    setFieldName: function(e) {
        this.fieldName = e;
    },
    getComparator: function() {
        return this.comparator;
    },
    setComparator: function(e) {
        this.comparator = e;
    },
    getValue: function() {
        return this.value;
    },
    setValue: function(e) {
        this.value = e;
    }
};

kerio.api.type.SubCondition.fields = {
    ALL_FIELDS: [ "fieldName", "comparator", "value" ],
    fieldName: "fieldName",
    comparator: "comparator",
    value: "value"
};

kerio.api.type.SortOrder = function() {};

kerio.api.type.SortOrder.prototype = {
    getColumnName: function() {
        return this.columnName;
    },
    setColumnName: function(e) {
        this.columnName = e;
    },
    getDirection: function() {
        return this.direction;
    },
    setDirection: function(e) {
        this.direction = e;
    },
    getCaseSensitive: function() {
        return this.caseSensitive;
    },
    setCaseSensitive: function(e) {
        this.caseSensitive = e;
    }
};

kerio.api.type.SortOrder.fields = {
    ALL_FIELDS: [ "columnName", "direction", "caseSensitive" ],
    columnName: "columnName",
    direction: "direction",
    caseSensitive: "caseSensitive"
};

kerio.api.type.SearchQuery = function() {};

kerio.api.type.SearchQuery.prototype = {
    getFields: function() {
        return this.fields;
    },
    setFields: function(e) {
        this.fields = e;
    },
    getConditions: function() {
        kerio.api.applyType(this.conditions, "SubCondition");
        return this.conditions;
    },
    setConditions: function(e) {
        this.conditions = e;
    },
    getCombining: function() {
        return this.combining;
    },
    setCombining: function(e) {
        this.combining = e;
    },
    getStart: function() {
        return this.start;
    },
    setStart: function(e) {
        this.start = e;
    },
    getLimit: function() {
        return this.limit;
    },
    setLimit: function(e) {
        this.limit = e;
    },
    getOrderBy: function() {
        kerio.api.applyType(this.orderBy, "SortOrder");
        return this.orderBy;
    },
    setOrderBy: function(e) {
        this.orderBy = e;
    }
};

kerio.api.type.SearchQuery.fields = {
    ALL_FIELDS: [ "fields", "conditions", "combining", "start", "limit", "orderBy" ],
    fields: "fields",
    conditions: "conditions",
    combining: "combining",
    start: "start",
    limit: "limit",
    orderBy: "orderBy"
};

kerio.api.type.LocalizableMessage = function() {};

kerio.api.type.LocalizableMessage.prototype = {
    getMessage: function() {
        return this.message;
    },
    setMessage: function(e) {
        this.message = e;
    },
    getPositionalParameters: function() {
        return this.positionalParameters;
    },
    setPositionalParameters: function(e) {
        this.positionalParameters = e;
    },
    getPlurality: function() {
        return this.plurality;
    },
    setPlurality: function(e) {
        this.plurality = e;
    }
};

kerio.api.type.LocalizableMessage.fields = {
    ALL_FIELDS: [ "message", "positionalParameters", "plurality" ],
    message: "message",
    positionalParameters: "positionalParameters",
    plurality: "plurality"
};

kerio.api.type.ManipulationError = function() {};

kerio.api.type.ManipulationError.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getErrorMessage: function() {
        kerio.api.applyType(this.errorMessage, "LocalizableMessage");
        return this.errorMessage;
    },
    setErrorMessage: function(e) {
        this.errorMessage = e;
    }
};

kerio.api.type.ManipulationError.fields = {
    ALL_FIELDS: [ "id", "errorMessage" ],
    id: "id",
    errorMessage: "errorMessage"
};

kerio.api.enums.RestrictionKind = {
    Regex: "Regex",
    ByteLength: "ByteLength",
    ForbiddenNameList: "ForbiddenNameList",
    ForbiddenPrefixList: "ForbiddenPrefixList",
    ForbiddenSuffixList: "ForbiddenSuffixList",
    ForbiddenCharacterList: "ForbiddenCharacterList"
};

kerio.api.enums.ItemName = {
    Name: "Name",
    Description: "Description",
    Email: "Email",
    FullName: "FullName",
    TimeItem: "TimeItem",
    DateItem: "DateItem",
    DomainName: "DomainName"
};

kerio.api.enums.ByteUnits = {
    Bytes: "Bytes",
    KiloBytes: "KiloBytes",
    MegaBytes: "MegaBytes",
    GigaBytes: "GigaBytes",
    TeraBytes: "TeraBytes",
    PetaBytes: "PetaBytes"
};

kerio.api.type.ByteValueWithUnits = function() {};

kerio.api.type.ByteValueWithUnits.prototype = {
    getValue: function() {
        return this.value;
    },
    setValue: function(e) {
        this.value = e;
    },
    getUnits: function() {
        return this.units;
    },
    setUnits: function(e) {
        this.units = e;
    }
};

kerio.api.type.ByteValueWithUnits.fields = {
    ALL_FIELDS: [ "value", "units" ],
    value: "value",
    units: "units"
};

kerio.api.type.SizeLimit = function() {};

kerio.api.type.SizeLimit.prototype = {
    getIsActive: function() {
        return this.isActive;
    },
    setIsActive: function(e) {
        this.isActive = e;
    },
    getLimit: function() {
        kerio.api.applyType(this.limit, "ByteValueWithUnits");
        return this.limit;
    },
    setLimit: function(e) {
        this.limit = e;
    }
};

kerio.api.type.SizeLimit.fields = {
    ALL_FIELDS: [ "isActive", "limit" ],
    isActive: "isActive",
    limit: "limit"
};

kerio.api.type.AddResult = function() {};

kerio.api.type.AddResult.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getSuccess: function() {
        return this.success;
    },
    setSuccess: function(e) {
        this.success = e;
    },
    getErrorMessage: function() {
        kerio.api.applyType(this.errorMessage, "LocalizableMessage");
        return this.errorMessage;
    },
    setErrorMessage: function(e) {
        this.errorMessage = e;
    }
};

kerio.api.type.AddResult.fields = {
    ALL_FIELDS: [ "id", "success", "errorMessage" ],
    id: "id",
    success: "success",
    errorMessage: "errorMessage"
};

kerio.api.enums.StoreStatus = {
    StoreStatusClean: "StoreStatusClean",
    StoreStatusModified: "StoreStatusModified",
    StoreStatusNew: "StoreStatusNew"
};

kerio.api.consts.Unlimited = -1;

kerio.api.type.Time = function() {};

kerio.api.type.Time.prototype = {
    getHour: function() {
        return this.hour;
    },
    setHour: function(e) {
        this.hour = e;
    },
    getMin: function() {
        return this.min;
    },
    setMin: function(e) {
        this.min = e;
    }
};

kerio.api.type.Time.fields = {
    ALL_FIELDS: [ "hour", "min" ],
    hour: "hour",
    min: "min"
};

kerio.api.type.Date = function() {};

kerio.api.type.Date.prototype = {
    getYear: function() {
        return this.year;
    },
    setYear: function(e) {
        this.year = e;
    },
    getMonth: function() {
        return this.month;
    },
    setMonth: function(e) {
        this.month = e;
    },
    getDay: function() {
        return this.day;
    },
    setDay: function(e) {
        this.day = e;
    }
};

kerio.api.type.Date.fields = {
    ALL_FIELDS: [ "year", "month", "day" ],
    year: "year",
    month: "month",
    day: "day"
};

kerio.api.type.OptionalString = function() {};

kerio.api.type.OptionalString.prototype = {
    getEnabled: function() {
        return this.enabled;
    },
    setEnabled: function(e) {
        this.enabled = e;
    },
    getValue: function() {
        return this.value;
    },
    setValue: function(e) {
        this.value = e;
    }
};

kerio.api.type.OptionalString.fields = {
    ALL_FIELDS: [ "enabled", "value" ],
    enabled: "enabled",
    value: "value"
};

kerio.api.type.OptionalLong = function() {};

kerio.api.type.OptionalLong.prototype = {
    getEnabled: function() {
        return this.enabled;
    },
    setEnabled: function(e) {
        this.enabled = e;
    },
    getValue: function() {
        return this.value;
    },
    setValue: function(e) {
        this.value = e;
    }
};

kerio.api.type.OptionalLong.fields = {
    ALL_FIELDS: [ "enabled", "value" ],
    enabled: "enabled",
    value: "value"
};

kerio.api.type.OptionalEntity = function() {};

kerio.api.type.OptionalEntity.prototype = {
    getEnabled: function() {
        return this.enabled;
    },
    setEnabled: function(e) {
        this.enabled = e;
    },
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    }
};

kerio.api.type.OptionalEntity.fields = {
    ALL_FIELDS: [ "enabled", "id", "name" ],
    enabled: "enabled",
    id: "id",
    name: "name"
};

kerio.api.type.LocalizableMessageParameters = function() {};

kerio.api.type.LocalizableMessageParameters.prototype = {
    getPositionalParameters: function() {
        return this.positionalParameters;
    },
    setPositionalParameters: function(e) {
        this.positionalParameters = e;
    },
    getPlurality: function() {
        return this.plurality;
    },
    setPlurality: function(e) {
        this.plurality = e;
    }
};

kerio.api.type.LocalizableMessageParameters.fields = {
    ALL_FIELDS: [ "positionalParameters", "plurality" ],
    positionalParameters: "positionalParameters",
    plurality: "plurality"
};

kerio.api.type.Error = function() {};

kerio.api.type.Error.prototype = {
    getInputIndex: function() {
        return this.inputIndex;
    },
    setInputIndex: function(e) {
        this.inputIndex = e;
    },
    getCode: function() {
        return this.code;
    },
    setCode: function(e) {
        this.code = e;
    },
    getMessage: function() {
        return this.message;
    },
    setMessage: function(e) {
        this.message = e;
    },
    getMessageParameters: function() {
        kerio.api.applyType(this.messageParameters, "LocalizableMessageParameters");
        return this.messageParameters;
    },
    setMessageParameters: function(e) {
        this.messageParameters = e;
    }
};

kerio.api.type.Error.fields = {
    ALL_FIELDS: [ "inputIndex", "code", "message", "messageParameters" ],
    inputIndex: "inputIndex",
    code: "code",
    message: "message",
    messageParameters: "messageParameters"
};

kerio.api.type.Download = function() {};

kerio.api.type.Download.prototype = {
    getUrl: function() {
        return this.url;
    },
    setUrl: function(e) {
        this.url = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getLength: function() {
        return this.length;
    },
    setLength: function(e) {
        this.length = e;
    }
};

kerio.api.type.Download.fields = {
    ALL_FIELDS: [ "url", "name", "length" ],
    url: "url",
    name: "name",
    length: "length"
};

kerio.api.type.CreateResult = function() {};

kerio.api.type.CreateResult.prototype = {
    getInputIndex: function() {
        return this.inputIndex;
    },
    setInputIndex: function(e) {
        this.inputIndex = e;
    },
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.type.CreateResult.fields = {
    ALL_FIELDS: [ "inputIndex", "id" ],
    inputIndex: "inputIndex",
    id: "id"
};

kerio.api.type.ApiApplication = function() {};

kerio.api.type.ApiApplication.prototype = {
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getVendor: function() {
        return this.vendor;
    },
    setVendor: function(e) {
        this.vendor = e;
    },
    getVersion: function() {
        return this.version;
    },
    setVersion: function(e) {
        this.version = e;
    }
};

kerio.api.type.ApiApplication.fields = {
    ALL_FIELDS: [ "name", "vendor", "version" ],
    name: "name",
    vendor: "vendor",
    version: "version"
};

kerio.api.type.Credentials = function() {};

kerio.api.type.Credentials.prototype = {
    getUserName: function() {
        return this.userName;
    },
    setUserName: function(e) {
        this.userName = e;
    },
    getPassword: function() {
        return this.password;
    },
    setPassword: function(e) {
        this.password = e;
    }
};

kerio.api.type.Credentials.fields = {
    ALL_FIELDS: [ "userName", "password" ],
    userName: "userName",
    password: "password"
};

kerio.api.enums.BuildType = {
    Alpha: "Alpha",
    Beta: "Beta",
    Rc: "Rc",
    Final: "Final",
    Patch: "Patch"
};

kerio.api.type.ProductVersion = function() {};

kerio.api.type.ProductVersion.prototype = {
    getProductName: function() {
        return this.productName;
    },
    setProductName: function(e) {
        this.productName = e;
    },
    getMajor: function() {
        return this.major;
    },
    setMajor: function(e) {
        this.major = e;
    },
    getMinor: function() {
        return this.minor;
    },
    setMinor: function(e) {
        this.minor = e;
    },
    getRevision: function() {
        return this.revision;
    },
    setRevision: function(e) {
        this.revision = e;
    },
    getBuild: function() {
        return this.build;
    },
    setBuild: function(e) {
        this.build = e;
    },
    getOrder: function() {
        return this.order;
    },
    setOrder: function(e) {
        this.order = e;
    },
    getReleaseType: function() {
        return this.releaseType;
    },
    setReleaseType: function(e) {
        this.releaseType = e;
    },
    getDisplayNumber: function() {
        return this.displayNumber;
    },
    setDisplayNumber: function(e) {
        this.displayNumber = e;
    }
};

kerio.api.type.ProductVersion.fields = {
    ALL_FIELDS: [ "productName", "major", "minor", "revision", "build", "order", "releaseType", "displayNumber" ],
    productName: "productName",
    major: "major",
    minor: "minor",
    revision: "revision",
    build: "build",
    order: "order",
    releaseType: "releaseType",
    displayNumber: "displayNumber"
};

kerio.api.Version = {
    getProductVersion: function(e) {
        return kerio.api.callMethod(this.Def.getProductVersion.name, {}, e, this.Def.getProductVersion.Response);
    },
    getApiVersion: function(e) {
        return kerio.api.callMethod(this.Def.getApiVersion.name, {}, e, this.Def.getApiVersion.Response);
    },
    Def: {
        $name: "Version",
        getProductVersion: {
            name: "Version.getProductVersion",
            Request: function() {},
            Response: {}
        },
        getApiVersion: {
            name: "Version.getApiVersion",
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Version.Def.getProductVersion.Response.prototype = {
    getProductVersion: function() {
        kerio.api.applyType(this.productVersion, "ProductVersion");
        return this.productVersion;
    }
};

kerio.api.Version.Def.getApiVersion.Response.prototype = {
    getApiVersion: function() {
        return this.apiVersion;
    }
};

kerio.api.Version.Def.getProductVersion.Request.prototype = {
    send: function(e) {
        return kerio.api.Version.getProductVersion(e);
    }
};

kerio.api.Version.Def.getApiVersion.Request.prototype = {
    send: function(e) {
        return kerio.api.Version.getApiVersion(e);
    }
};

kerio.api.type.IdEntity = function() {};

kerio.api.type.IdEntity.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    }
};

kerio.api.type.IdEntity.fields = {
    ALL_FIELDS: [ "id", "name" ],
    id: "id",
    name: "name"
};

kerio.api.type.LangDescription = function() {};

kerio.api.type.LangDescription.prototype = {
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getCode: function() {
        return this.code;
    },
    setCode: function(e) {
        this.code = e;
    },
    getShortCode: function() {
        return this.shortCode;
    },
    setShortCode: function(e) {
        this.shortCode = e;
    }
};

kerio.api.type.LangDescription.fields = {
    ALL_FIELDS: [ "name", "code", "shortCode" ],
    name: "name",
    code: "code",
    shortCode: "shortCode"
};

if (!window.kerio.api.enums.contacts) {
    window.kerio.api.enums.contacts = {
        SearchFields: {}
    };
}

kerio.api.type.ABExtension = function() {};

kerio.api.type.ABExtension.prototype = {
    getGroupId: function() {
        return this.groupId;
    },
    setGroupId: function(e) {
        this.groupId = e;
    },
    getLabel: function() {
        return this.label;
    },
    setLabel: function(e) {
        this.label = e;
    }
};

kerio.api.type.ABExtension.fields = {
    ALL_FIELDS: [ "groupId", "label" ],
    groupId: "groupId",
    label: "label"
};

kerio.api.enums.contacts.PostalAddressType = {
    AddressHome: "AddressHome",
    AddressWork: "AddressWork",
    AddressOther: "AddressOther",
    AddressCustom: "AddressCustom"
};

kerio.api.type.PostalAddress = function() {};

kerio.api.type.PostalAddress.prototype = {
    getPreferred: function() {
        return this.preferred;
    },
    setPreferred: function(e) {
        this.preferred = e;
    },
    getPobox: function() {
        return this.pobox;
    },
    setPobox: function(e) {
        this.pobox = e;
    },
    getExtendedAddress: function() {
        return this.extendedAddress;
    },
    setExtendedAddress: function(e) {
        this.extendedAddress = e;
    },
    getStreet: function() {
        return this.street;
    },
    setStreet: function(e) {
        this.street = e;
    },
    getLocality: function() {
        return this.locality;
    },
    setLocality: function(e) {
        this.locality = e;
    },
    getState: function() {
        return this.state;
    },
    setState: function(e) {
        this.state = e;
    },
    getZip: function() {
        return this.zip;
    },
    setZip: function(e) {
        this.zip = e;
    },
    getCountry: function() {
        return this.country;
    },
    setCountry: function(e) {
        this.country = e;
    },
    getLabel: function() {
        return this.label;
    },
    setLabel: function(e) {
        this.label = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getExtension: function() {
        kerio.api.applyType(this.extension, "ABExtension");
        return this.extension;
    },
    setExtension: function(e) {
        this.extension = e;
    }
};

kerio.api.type.PostalAddress.fields = {
    ALL_FIELDS: [ "preferred", "pobox", "extendedAddress", "street", "locality", "state", "zip", "country", "label", "type", "extension" ],
    preferred: "preferred",
    pobox: "pobox",
    extendedAddress: "extendedAddress",
    street: "street",
    locality: "locality",
    state: "state",
    zip: "zip",
    country: "country",
    label: "label",
    type: "type",
    extension: "extension"
};

kerio.api.enums.contacts.EmailAddressType = {
    EmailWork: "EmailWork",
    EmailHome: "EmailHome",
    EmailOther: "EmailOther",
    EmailCustom: "EmailCustom",
    RefContact: "RefContact",
    RefDistributionList: "RefDistributionList"
};

kerio.api.type.EmailAddress = function() {};

kerio.api.type.EmailAddress.prototype = {
    getAddress: function() {
        return this.address;
    },
    setAddress: function(e) {
        this.address = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getPreferred: function() {
        return this.preferred;
    },
    setPreferred: function(e) {
        this.preferred = e;
    },
    getIsValidCertificate: function() {
        return this.isValidCertificate;
    },
    setIsValidCertificate: function(e) {
        this.isValidCertificate = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getRefId: function() {
        return this.refId;
    },
    setRefId: function(e) {
        this.refId = e;
    },
    getExtension: function() {
        kerio.api.applyType(this.extension, "ABExtension");
        return this.extension;
    },
    setExtension: function(e) {
        this.extension = e;
    }
};

kerio.api.type.EmailAddress.fields = {
    ALL_FIELDS: [ "address", "name", "preferred", "isValidCertificate", "type", "refId", "extension" ],
    address: "address",
    name: "name",
    preferred: "preferred",
    isValidCertificate: "isValidCertificate",
    type: "type",
    refId: "refId",
    extension: "extension"
};

kerio.api.enums.contacts.PhoneNumberType = {
    TypeAssistant: "TypeAssistant",
    TypeWorkVoice: "TypeWorkVoice",
    TypeWorkFax: "TypeWorkFax",
    TypeCallback: "TypeCallback",
    TypeCar: "TypeCar",
    TypeCompany: "TypeCompany",
    TypeHomeVoice: "TypeHomeVoice",
    TypeHomeFax: "TypeHomeFax",
    TypeIsdn: "TypeIsdn",
    TypeMobile: "TypeMobile",
    TypeOtherVoice: "TypeOtherVoice",
    TypeOtherFax: "TypeOtherFax",
    TypePager: "TypePager",
    TypePrimary: "TypePrimary",
    TypeRadio: "TypeRadio",
    TypeTelex: "TypeTelex",
    TypeTtyTdd: "TypeTtyTdd",
    TypeCustom: "TypeCustom"
};

kerio.api.type.PhoneNumber = function() {};

kerio.api.type.PhoneNumber.prototype = {
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getNumber: function() {
        return this.number;
    },
    setNumber: function(e) {
        this.number = e;
    },
    getExtension: function() {
        kerio.api.applyType(this.extension, "ABExtension");
        return this.extension;
    },
    setExtension: function(e) {
        this.extension = e;
    }
};

kerio.api.type.PhoneNumber.fields = {
    ALL_FIELDS: [ "type", "number", "extension" ],
    type: "type",
    number: "number",
    extension: "extension"
};

kerio.api.enums.contacts.UrlType = {
    UrlHome: "UrlHome",
    UrlWork: "UrlWork",
    UrlOther: "UrlOther",
    UrlCustom: "UrlCustom"
};

kerio.api.type.Url = function() {};

kerio.api.type.Url.prototype = {
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getUrl: function() {
        return this.url;
    },
    setUrl: function(e) {
        this.url = e;
    },
    getExtension: function() {
        kerio.api.applyType(this.extension, "ABExtension");
        return this.extension;
    },
    setExtension: function(e) {
        this.extension = e;
    }
};

kerio.api.type.Url.fields = {
    ALL_FIELDS: [ "type", "url", "extension" ],
    type: "type",
    url: "url",
    extension: "extension"
};

kerio.api.type.PhotoAttachment = function() {};

kerio.api.type.PhotoAttachment.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getUrl: function() {
        return this.url;
    },
    setUrl: function(e) {
        this.url = e;
    }
};

kerio.api.type.PhotoAttachment.fields = {
    ALL_FIELDS: [ "id", "url" ],
    id: "id",
    url: "url"
};

kerio.api.type.PersonalContact = function() {};

kerio.api.type.PersonalContact.prototype = {
    getCommonName: function() {
        return this.commonName;
    },
    setCommonName: function(e) {
        this.commonName = e;
    },
    getFirstName: function() {
        return this.firstName;
    },
    setFirstName: function(e) {
        this.firstName = e;
    },
    getMiddleName: function() {
        return this.middleName;
    },
    setMiddleName: function(e) {
        this.middleName = e;
    },
    getSurName: function() {
        return this.surName;
    },
    setSurName: function(e) {
        this.surName = e;
    },
    getTitleBefore: function() {
        return this.titleBefore;
    },
    setTitleBefore: function(e) {
        this.titleBefore = e;
    },
    getTitleAfter: function() {
        return this.titleAfter;
    },
    setTitleAfter: function(e) {
        this.titleAfter = e;
    },
    getNickName: function() {
        return this.nickName;
    },
    setNickName: function(e) {
        this.nickName = e;
    },
    getPhoneNumberWorkVoice: function() {
        return this.phoneNumberWorkVoice;
    },
    setPhoneNumberWorkVoice: function(e) {
        this.phoneNumberWorkVoice = e;
    },
    getPhoneNumberMobile: function() {
        return this.phoneNumberMobile;
    },
    setPhoneNumberMobile: function(e) {
        this.phoneNumberMobile = e;
    },
    getPostalAddressWork: function() {
        kerio.api.applyType(this.postalAddressWork, "PostalAddress");
        return this.postalAddressWork;
    },
    setPostalAddressWork: function(e) {
        this.postalAddressWork = e;
    },
    getUrlWork: function() {
        return this.urlWork;
    },
    setUrlWork: function(e) {
        this.urlWork = e;
    },
    getBirthDay: function() {
        return this.birthDay;
    },
    setBirthDay: function(e) {
        this.birthDay = e;
    },
    getAnniversary: function() {
        return this.anniversary;
    },
    setAnniversary: function(e) {
        this.anniversary = e;
    },
    getCompanyName: function() {
        return this.companyName;
    },
    setCompanyName: function(e) {
        this.companyName = e;
    },
    getDepartmentName: function() {
        return this.departmentName;
    },
    setDepartmentName: function(e) {
        this.departmentName = e;
    },
    getProfession: function() {
        return this.profession;
    },
    setProfession: function(e) {
        this.profession = e;
    },
    getManagerName: function() {
        return this.managerName;
    },
    setManagerName: function(e) {
        this.managerName = e;
    },
    getAssistantName: function() {
        return this.assistantName;
    },
    setAssistantName: function(e) {
        this.assistantName = e;
    },
    getComment: function() {
        return this.comment;
    },
    setComment: function(e) {
        this.comment = e;
    },
    getIMAddress: function() {
        return this.IMAddress;
    },
    setIMAddress: function(e) {
        this.IMAddress = e;
    },
    getPhoto: function() {
        kerio.api.applyType(this.photo, "PhotoAttachment");
        return this.photo;
    },
    setPhoto: function(e) {
        this.photo = e;
    },
    getIsReadOnly: function() {
        return this.isReadOnly;
    },
    setIsReadOnly: function(e) {
        this.isReadOnly = e;
    },
    getEmailAddresses: function() {
        kerio.api.applyType(this.emailAddresses, "EmailAddress");
        return this.emailAddresses;
    },
    setEmailAddresses: function(e) {
        this.emailAddresses = e;
    }
};

kerio.api.type.PersonalContact.fields = {
    ALL_FIELDS: [ "commonName", "firstName", "middleName", "surName", "titleBefore", "titleAfter", "nickName", "phoneNumberWorkVoice", "phoneNumberMobile", "postalAddressWork", "urlWork", "birthDay", "anniversary", "companyName", "departmentName", "profession", "managerName", "assistantName", "comment", "IMAddress", "photo", "isReadOnly", "emailAddresses" ],
    commonName: "commonName",
    firstName: "firstName",
    middleName: "middleName",
    surName: "surName",
    titleBefore: "titleBefore",
    titleAfter: "titleAfter",
    nickName: "nickName",
    phoneNumberWorkVoice: "phoneNumberWorkVoice",
    phoneNumberMobile: "phoneNumberMobile",
    postalAddressWork: "postalAddressWork",
    urlWork: "urlWork",
    birthDay: "birthDay",
    anniversary: "anniversary",
    companyName: "companyName",
    departmentName: "departmentName",
    profession: "profession",
    managerName: "managerName",
    assistantName: "assistantName",
    comment: "comment",
    IMAddress: "IMAddress",
    photo: "photo",
    isReadOnly: "isReadOnly",
    emailAddresses: "emailAddresses"
};

if (!window.kerio.api.enums.filters) {
    window.kerio.api.enums.filters = {
        SearchFields: {}
    };
}

kerio.api.enums.filters.FilterConditionType = {
    CtEnvelopeRecipient: "CtEnvelopeRecipient",
    CtEnvelopeSender: "CtEnvelopeSender",
    CtRecipient: "CtRecipient",
    CtSender: "CtSender",
    CtFrom: "CtFrom",
    CtCc: "CtCc",
    CtTo: "CtTo",
    CtSubject: "CtSubject",
    CtAttachment: "CtAttachment",
    CtSize: "CtSize",
    CtSpam: "CtSpam",
    CtAll: "CtAll"
};

kerio.api.enums.filters.FilterComparatorType = {
    CcEqual: "CcEqual",
    CcContain: "CcContain",
    CcNotContain: "CcNotContain",
    CcNotEqual: "CcNotEqual",
    CcUnder: "CcUnder",
    CcOver: "CcOver",
    CcNoComparator: "CcNoComparator"
};

kerio.api.type.FilterCondition = function() {};

kerio.api.type.FilterCondition.prototype = {
    getTestedTarget: function() {
        return this.testedTarget;
    },
    setTestedTarget: function(e) {
        this.testedTarget = e;
    },
    getComparator: function() {
        return this.comparator;
    },
    setComparator: function(e) {
        this.comparator = e;
    },
    getParameters: function() {
        return this.parameters;
    },
    setParameters: function(e) {
        this.parameters = e;
    }
};

kerio.api.type.FilterCondition.fields = {
    ALL_FIELDS: [ "testedTarget", "comparator", "parameters" ],
    testedTarget: "testedTarget",
    comparator: "comparator",
    parameters: "parameters"
};

kerio.api.enums.filters.FilterActionType = {
    FaAddHeader: "FaAddHeader",
    FaSetHeader: "FaSetHeader",
    FaRemoveHeader: "FaRemoveHeader",
    FaAddRecipient: "FaAddRecipient",
    FaCopyToAddress: "FaCopyToAddress",
    FaReject: "FaReject",
    FaFileInto: "FaFileInto",
    FaRedirect: "FaRedirect",
    FaDiscard: "FaDiscard",
    FaKeep: "FaKeep",
    FaNotify: "FaNotify",
    FaSetReadFlag: "FaSetReadFlag",
    FaAutoReply: "FaAutoReply",
    FaStop: "FaStop"
};

kerio.api.type.FilterAction = function() {};

kerio.api.type.FilterAction.prototype = {
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getParameters: function() {
        return this.parameters;
    },
    setParameters: function(e) {
        this.parameters = e;
    }
};

kerio.api.type.FilterAction.fields = {
    ALL_FIELDS: [ "type", "parameters" ],
    type: "type",
    parameters: "parameters"
};

kerio.api.enums.filters.EvaluationModeType = {
    EmAnyOf: "EmAnyOf",
    EmAllOf: "EmAllOf"
};

kerio.api.Uploads = {
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    removeList: function(e, t) {
        return kerio.api.callMethod(this.Def.removeList.name, e, t, this.Def.removeList.Response);
    },
    Def: {
        $name: "Uploads",
        remove: {
            name: "Uploads.remove",
            input: {
                id: "id"
            },
            Request: function() {}
        },
        removeList: {
            name: "Uploads.removeList",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Uploads.Def.removeList.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Uploads.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Uploads.remove(this, e);
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Uploads.Def.removeList.Request.prototype = {
    send: function(e) {
        return kerio.api.Uploads.removeList(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Downloads = {
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    Def: {
        $name: "Downloads",
        remove: {
            name: "Downloads.remove",
            input: {
                url: "url"
            },
            Request: function() {}
        }
    }
};

kerio.api.Downloads.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Downloads.remove(this, e);
    },
    setUrl: function(e) {
        this.url = e;
    }
};

if (!window.kerio.api.enums.mobile) {
    window.kerio.api.enums.mobile = {
        SearchFields: {}
    };
}

kerio.api.enums.mobile.DeviceStatus = {
    OK: "OK",
    DeviceNotProvisioned: "DeviceNotProvisioned",
    DeviceWipeInitiated: "DeviceWipeInitiated",
    DeviceWipeInProgress: "DeviceWipeInProgress",
    DeviceWipeFinished: "DeviceWipeFinished",
    DeviceConnected: "DeviceConnected",
    DeviceDisconnected: "DeviceDisconnected"
};

kerio.api.enums.mobile.FolderIcon = {
    FIMail: "FIMail",
    FIContact: "FIContact",
    FICalendar: "FICalendar",
    FITodo: "FITodo",
    FIJournal: "FIJournal",
    FINote: "FINote",
    FIInbox: "FIInbox",
    FIDeleted: "FIDeleted"
};

kerio.api.type.SyncFolder = function() {};

kerio.api.type.SyncFolder.prototype = {
    getFolderName: function() {
        return this.folderName;
    },
    setFolderName: function(e) {
        this.folderName = e;
    },
    getFolderTypeIcon: function() {
        return this.folderTypeIcon;
    },
    setFolderTypeIcon: function(e) {
        this.folderTypeIcon = e;
    },
    getLastSyncDate: function() {
        return this.lastSyncDate;
    },
    setLastSyncDate: function(e) {
        this.lastSyncDate = e;
    },
    getLastSyncDateIso: function() {
        return this.lastSyncDateIso;
    },
    setLastSyncDateIso: function(e) {
        this.lastSyncDateIso = e;
    }
};

kerio.api.type.SyncFolder.fields = {
    ALL_FIELDS: [ "folderName", "folderTypeIcon", "lastSyncDate", "lastSyncDateIso" ],
    folderName: "folderName",
    folderTypeIcon: "folderTypeIcon",
    lastSyncDate: "lastSyncDate",
    lastSyncDateIso: "lastSyncDateIso"
};

kerio.api.enums.mobile.SyncMethod = {
    ServerWins: "ServerWins",
    ClientWins: "ClientWins"
};

kerio.api.enums.mobile.ProtocolType = {
    protocolASync: "protocolASync",
    protocolKBC: "protocolKBC"
};

kerio.api.type.MobileDevice = function() {};

kerio.api.type.MobileDevice.prototype = {
    getProtocolType: function() {
        return this.protocolType;
    },
    setProtocolType: function(e) {
        this.protocolType = e;
    },
    getDeviceId: function() {
        return this.deviceId;
    },
    setDeviceId: function(e) {
        this.deviceId = e;
    },
    getProtocolVersion: function() {
        return this.protocolVersion;
    },
    setProtocolVersion: function(e) {
        this.protocolVersion = e;
    },
    getRegistrationDate: function() {
        return this.registrationDate;
    },
    setRegistrationDate: function(e) {
        this.registrationDate = e;
    },
    getRegistrationDateIso: function() {
        return this.registrationDateIso;
    },
    setRegistrationDateIso: function(e) {
        this.registrationDateIso = e;
    },
    getLastSyncDate: function() {
        return this.lastSyncDate;
    },
    setLastSyncDate: function(e) {
        this.lastSyncDate = e;
    },
    getLastSyncDateIso: function() {
        return this.lastSyncDateIso;
    },
    setLastSyncDateIso: function(e) {
        this.lastSyncDateIso = e;
    },
    getFolderList: function() {
        kerio.api.applyType(this.folderList, "SyncFolder");
        return this.folderList;
    },
    setFolderList: function(e) {
        this.folderList = e;
    },
    getStatus: function() {
        return this.status;
    },
    setStatus: function(e) {
        this.status = e;
    },
    getMethod: function() {
        return this.method;
    },
    setMethod: function(e) {
        this.method = e;
    },
    getRemoteHost: function() {
        return this.remoteHost;
    },
    setRemoteHost: function(e) {
        this.remoteHost = e;
    },
    getOs: function() {
        return this.os;
    },
    setOs: function(e) {
        this.os = e;
    },
    getPlatform: function() {
        return this.platform;
    },
    setPlatform: function(e) {
        this.platform = e;
    },
    getDeviceIcon: function() {
        return this.deviceIcon;
    },
    setDeviceIcon: function(e) {
        this.deviceIcon = e;
    }
};

kerio.api.type.MobileDevice.fields = {
    ALL_FIELDS: [ "protocolType", "deviceId", "protocolVersion", "registrationDate", "registrationDateIso", "lastSyncDate", "lastSyncDateIso", "folderList", "status", "method", "remoteHost", "os", "platform", "deviceIcon" ],
    protocolType: "protocolType",
    deviceId: "deviceId",
    protocolVersion: "protocolVersion",
    registrationDate: "registrationDate",
    registrationDateIso: "registrationDateIso",
    lastSyncDate: "lastSyncDate",
    lastSyncDateIso: "lastSyncDateIso",
    folderList: "folderList",
    status: "status",
    method: "method",
    remoteHost: "remoteHost",
    os: "os",
    platform: "platform",
    deviceIcon: "deviceIcon"
};

if (!window.kerio.api.enums.certificates) {
    window.kerio.api.enums.certificates = {
        SearchFields: {}
    };
}

kerio.api.type.Validity = function() {};

kerio.api.type.Validity.prototype = {
    getIsValid: function() {
        return this.isValid;
    },
    setIsValid: function(e) {
        this.isValid = e;
    },
    getError: function() {
        kerio.api.applyType(this.error, "LocalizableMessage");
        return this.error;
    },
    setError: function(e) {
        this.error = e;
    }
};

kerio.api.type.Validity.fields = {
    ALL_FIELDS: [ "isValid", "error" ],
    isValid: "isValid",
    error: "error"
};

kerio.api.type.NameEntry = function() {};

kerio.api.type.NameEntry.prototype = {
    getCommonName: function() {
        return this.commonName;
    },
    setCommonName: function(e) {
        this.commonName = e;
    },
    getOrganizationName: function() {
        return this.organizationName;
    },
    setOrganizationName: function(e) {
        this.organizationName = e;
    },
    getOrganizationalUnitName: function() {
        return this.organizationalUnitName;
    },
    setOrganizationalUnitName: function(e) {
        this.organizationalUnitName = e;
    },
    getLocalityName: function() {
        return this.localityName;
    },
    setLocalityName: function(e) {
        this.localityName = e;
    },
    getCountryName: function() {
        return this.countryName;
    },
    setCountryName: function(e) {
        this.countryName = e;
    },
    getStateOrProvinceName: function() {
        return this.stateOrProvinceName;
    },
    setStateOrProvinceName: function(e) {
        this.stateOrProvinceName = e;
    },
    getEmailAddresses: function() {
        return this.emailAddresses;
    },
    setEmailAddresses: function(e) {
        this.emailAddresses = e;
    }
};

kerio.api.type.NameEntry.fields = {
    ALL_FIELDS: [ "commonName", "organizationName", "organizationalUnitName", "localityName", "countryName", "stateOrProvinceName", "emailAddresses" ],
    commonName: "commonName",
    organizationName: "organizationName",
    organizationalUnitName: "organizationalUnitName",
    localityName: "localityName",
    countryName: "countryName",
    stateOrProvinceName: "stateOrProvinceName",
    emailAddresses: "emailAddresses"
};

kerio.api.type.Certificate = function() {};

kerio.api.type.Certificate.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getSubject: function() {
        kerio.api.applyType(this.subject, "NameEntry");
        return this.subject;
    },
    setSubject: function(e) {
        this.subject = e;
    },
    getIssuer: function() {
        kerio.api.applyType(this.issuer, "NameEntry");
        return this.issuer;
    },
    setIssuer: function(e) {
        this.issuer = e;
    },
    getValidFrom: function() {
        return this.validFrom;
    },
    setValidFrom: function(e) {
        this.validFrom = e;
    },
    getValidTo: function() {
        return this.validTo;
    },
    setValidTo: function(e) {
        this.validTo = e;
    },
    getSerial: function() {
        return this.serial;
    },
    setSerial: function(e) {
        this.serial = e;
    },
    getValidity: function() {
        kerio.api.applyType(this.validity, "Validity");
        return this.validity;
    },
    setValidity: function(e) {
        this.validity = e;
    }
};

kerio.api.type.Certificate.fields = {
    ALL_FIELDS: [ "id", "subject", "issuer", "validFrom", "validTo", "serial", "validity" ],
    id: "id",
    subject: "subject",
    issuer: "issuer",
    validFrom: "validFrom",
    validTo: "validTo",
    serial: "serial",
    validity: "validity"
};

kerio.api.enums.certificates.CertStoreStatus = {
    Uninitialized: "Uninitialized",
    Opened: "Opened",
    Closed: "Closed",
    FailedToOpen: "FailedToOpen"
};

kerio.api.Certificates = {
    init: function(e, t) {
        return kerio.api.callMethod(this.Def.init.name, e, t, this.Def.init.Response);
    },
    open: function(e, t) {
        return kerio.api.callMethod(this.Def.open.name, e, t, this.Def.open.Response);
    },
    close: function(e) {
        return kerio.api.callMethod(this.Def.close.name, {}, e, this.Def.close.Response);
    },
    get: function(e) {
        return kerio.api.callMethod(this.Def.get.name, {}, e, this.Def.get.Response);
    },
    getById: function(e, t) {
        return kerio.api.callMethod(this.Def.getById.name, e, t, this.Def.getById.Response);
    },
    getStatus: function(e) {
        return kerio.api.callMethod(this.Def.getStatus.name, {}, e, this.Def.getStatus.Response);
    },
    toSource: function(e, t) {
        return kerio.api.callMethod(this.Def.toSource.name, e, t, this.Def.toSource.Response);
    },
    openWithOldLoginPassword: function(e, t) {
        return kerio.api.callMethod(this.Def.openWithOldLoginPassword.name, e, t, this.Def.openWithOldLoginPassword.Response);
    },
    openEditWithOldLoginPassword: function(e, t) {
        return kerio.api.callMethod(this.Def.openEditWithOldLoginPassword.name, e, t, this.Def.openEditWithOldLoginPassword.Response);
    },
    reset: function(e, t) {
        return kerio.api.callMethod(this.Def.reset.name, e, t, this.Def.reset.Response);
    },
    openEdit: function(e, t) {
        return kerio.api.callMethod(this.Def.openEdit.name, e, t, this.Def.openEdit.Response);
    },
    closeEdit: function(e) {
        return kerio.api.callMethod(this.Def.closeEdit.name, {}, e, this.Def.closeEdit.Response);
    },
    setPreferred: function(e, t) {
        return kerio.api.callMethod(this.Def.setPreferred.name, e, t, this.Def.setPreferred.Response);
    },
    changePassword: function(e, t) {
        return kerio.api.callMethod(this.Def.changePassword.name, e, t, this.Def.changePassword.Response);
    },
    importPKCS12: function(e, t) {
        return kerio.api.callMethod(this.Def.importPKCS12.name, e, t, this.Def.importPKCS12.Response);
    },
    exportPKCS12: function(e, t) {
        return kerio.api.callMethod(this.Def.exportPKCS12.name, e, t, this.Def.exportPKCS12.Response);
    },
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    Def: {
        $name: "Certificates",
        init: {
            name: "Certificates.init",
            input: {
                password: "password",
                isLoginPassword: "isLoginPassword"
            },
            Request: function() {}
        },
        open: {
            name: "Certificates.open",
            input: {
                password: "password"
            },
            Request: function() {}
        },
        close: {
            name: "Certificates.close",
            Request: function() {}
        },
        get: {
            name: "Certificates.get",
            Request: function() {},
            Response: {}
        },
        getById: {
            name: "Certificates.getById",
            input: {
                id: "id"
            },
            output: {
                certificate: "certificate"
            },
            Request: function() {},
            Response: {}
        },
        getStatus: {
            name: "Certificates.getStatus",
            Request: function() {},
            Response: {}
        },
        toSource: {
            name: "Certificates.toSource",
            input: {
                id: "id"
            },
            output: {
                source: "source"
            },
            Request: function() {},
            Response: {}
        },
        openWithOldLoginPassword: {
            name: "Certificates.openWithOldLoginPassword",
            input: {
                oldPassword: "oldPassword"
            },
            Request: function() {}
        },
        openEditWithOldLoginPassword: {
            name: "Certificates.openEditWithOldLoginPassword",
            input: {
                oldPassword: "oldPassword"
            },
            Request: function() {}
        },
        reset: {
            name: "Certificates.reset",
            input: {
                loginPassword: "loginPassword"
            },
            Request: function() {}
        },
        openEdit: {
            name: "Certificates.openEdit",
            input: {
                password: "password"
            },
            Request: function() {}
        },
        closeEdit: {
            name: "Certificates.closeEdit",
            Request: function() {}
        },
        setPreferred: {
            name: "Certificates.setPreferred",
            input: {
                id: "id"
            },
            Request: function() {}
        },
        changePassword: {
            name: "Certificates.changePassword",
            input: {
                oldPassword: "oldPassword",
                newPassword: "newPassword",
                isLoginPassword: "isLoginPassword"
            },
            Request: function() {}
        },
        importPKCS12: {
            name: "Certificates.importPKCS12",
            input: {
                fileId: "fileId",
                password: "password"
            },
            Request: function() {}
        },
        exportPKCS12: {
            name: "Certificates.exportPKCS12",
            input: {
                newPassword: "newPassword",
                id: "id"
            },
            output: {
                fileDownload: "fileDownload"
            },
            Request: function() {},
            Response: {}
        },
        remove: {
            name: "Certificates.remove",
            input: {
                id: "id"
            },
            Request: function() {}
        }
    }
};

kerio.api.Certificates.Def.get.Response.prototype = {
    getCertificates: function() {
        kerio.api.applyType(this.certificates, "Certificate");
        return this.certificates;
    }
};

kerio.api.Certificates.Def.getById.Response.prototype = {
    getCertificate: function() {
        kerio.api.applyType(this.certificate, "Certificate");
        return this.certificate;
    }
};

kerio.api.Certificates.Def.getStatus.Response.prototype = {
    getStatus: function() {
        return this.status;
    }
};

kerio.api.Certificates.Def.toSource.Response.prototype = {
    getSource: function() {
        return this.source;
    }
};

kerio.api.Certificates.Def.exportPKCS12.Response.prototype = {
    getFileDownload: function() {
        kerio.api.applyType(this.fileDownload, "Download");
        return this.fileDownload;
    }
};

kerio.api.Certificates.Def.init.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.init(this, e);
    },
    setPassword: function(e) {
        this.password = e;
    },
    setIsLoginPassword: function(e) {
        this.isLoginPassword = e;
    }
};

kerio.api.Certificates.Def.open.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.open(this, e);
    },
    setPassword: function(e) {
        this.password = e;
    }
};

kerio.api.Certificates.Def.close.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.close(e);
    }
};

kerio.api.Certificates.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.get(e);
    }
};

kerio.api.Certificates.Def.getById.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.getById(this, e);
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Certificates.Def.getStatus.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.getStatus(e);
    }
};

kerio.api.Certificates.Def.toSource.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.toSource(this, e);
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Certificates.Def.openWithOldLoginPassword.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.openWithOldLoginPassword(this, e);
    },
    setOldPassword: function(e) {
        this.oldPassword = e;
    }
};

kerio.api.Certificates.Def.openEditWithOldLoginPassword.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.openEditWithOldLoginPassword(this, e);
    },
    setOldPassword: function(e) {
        this.oldPassword = e;
    }
};

kerio.api.Certificates.Def.reset.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.reset(this, e);
    },
    setLoginPassword: function(e) {
        this.loginPassword = e;
    }
};

kerio.api.Certificates.Def.openEdit.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.openEdit(this, e);
    },
    setPassword: function(e) {
        this.password = e;
    }
};

kerio.api.Certificates.Def.closeEdit.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.closeEdit(e);
    }
};

kerio.api.Certificates.Def.setPreferred.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.setPreferred(this, e);
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Certificates.Def.changePassword.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.changePassword(this, e);
    },
    setOldPassword: function(e) {
        this.oldPassword = e;
    },
    setNewPassword: function(e) {
        this.newPassword = e;
    },
    setIsLoginPassword: function(e) {
        this.isLoginPassword = e;
    }
};

kerio.api.Certificates.Def.importPKCS12.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.importPKCS12(this, e);
    },
    setFileId: function(e) {
        this.fileId = e;
    },
    setPassword: function(e) {
        this.password = e;
    }
};

kerio.api.Certificates.Def.exportPKCS12.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.exportPKCS12(this, e);
    },
    setNewPassword: function(e) {
        this.newPassword = e;
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Certificates.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Certificates.remove(this, e);
    },
    setId: function(e) {
        this.id = e;
    }
};

if (!window.kerio.api.enums.mails) {
    window.kerio.api.enums.mails = {
        SearchFields: {}
    };
}

kerio.api.type.Email = function() {};

kerio.api.type.Email.prototype = {
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getAddress: function() {
        return this.address;
    },
    setAddress: function(e) {
        this.address = e;
    },
    getContactId: function() {
        return this.contactId;
    },
    setContactId: function(e) {
        this.contactId = e;
    }
};

kerio.api.type.Email.fields = {
    ALL_FIELDS: [ "name", "address", "contactId" ],
    name: "name",
    address: "address",
    contactId: "contactId"
};

kerio.api.type.Attachment = function() {};

kerio.api.type.Attachment.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getUrl: function() {
        return this.url;
    },
    setUrl: function(e) {
        this.url = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getContentType: function() {
        return this.contentType;
    },
    setContentType: function(e) {
        this.contentType = e;
    },
    getContentId: function() {
        return this.contentId;
    },
    setContentId: function(e) {
        this.contentId = e;
    },
    getSize: function() {
        return this.size;
    },
    setSize: function(e) {
        this.size = e;
    }
};

kerio.api.type.Attachment.fields = {
    ALL_FIELDS: [ "id", "url", "name", "contentType", "contentId", "size" ],
    id: "id",
    url: "url",
    name: "name",
    contentType: "contentType",
    contentId: "contentId",
    size: "size"
};

kerio.api.enums.mails.DisplayableContentType = {
    ctTextPlain: "ctTextPlain",
    ctTextHtml: "ctTextHtml"
};

kerio.api.type.DisplayableMimePart = function() {};

kerio.api.type.DisplayableMimePart.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getContentType: function() {
        return this.contentType;
    },
    setContentType: function(e) {
        this.contentType = e;
    },
    getContent: function() {
        return this.content;
    },
    setContent: function(e) {
        this.content = e;
    }
};

kerio.api.type.DisplayableMimePart.fields = {
    ALL_FIELDS: [ "id", "contentType", "content" ],
    id: "id",
    contentType: "contentType",
    content: "content"
};

kerio.api.enums.mails.MimeHeaderType = {
    mhMessageID: "mhMessageID",
    mhInReplayTo: "mhInReplayTo",
    mhResentMessageID: "mhResentMessageID"
};

kerio.api.type.MimeHeader = function() {};

kerio.api.type.MimeHeader.prototype = {
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getValue: function() {
        return this.value;
    },
    setValue: function(e) {
        this.value = e;
    }
};

kerio.api.type.MimeHeader.fields = {
    ALL_FIELDS: [ "type", "value" ],
    type: "type",
    value: "value"
};

kerio.api.type.SignInfo = function() {};

kerio.api.type.SignInfo.prototype = {
    getIsSigned: function() {
        return this.isSigned;
    },
    setIsSigned: function(e) {
        this.isSigned = e;
    },
    getIsValid: function() {
        return this.isValid;
    },
    setIsValid: function(e) {
        this.isValid = e;
    },
    getError: function() {
        kerio.api.applyType(this.error, "LocalizableMessage");
        return this.error;
    },
    setError: function(e) {
        this.error = e;
    },
    getCert: function() {
        kerio.api.applyType(this.cert, "Certificate");
        return this.cert;
    },
    setCert: function(e) {
        this.cert = e;
    }
};

kerio.api.type.SignInfo.fields = {
    ALL_FIELDS: [ "isSigned", "isValid", "error", "cert" ],
    isSigned: "isSigned",
    isValid: "isValid",
    error: "error",
    cert: "cert"
};

kerio.api.enums.mails.DecryptResult = {
    DecryptSuccesful: "DecryptSuccesful",
    DecryptNoKey: "DecryptNoKey",
    DecryptError: "DecryptError"
};

kerio.api.type.EncryptInfo = function() {};

kerio.api.type.EncryptInfo.prototype = {
    getIsEncrypted: function() {
        return this.isEncrypted;
    },
    setIsEncrypted: function(e) {
        this.isEncrypted = e;
    },
    getResult: function() {
        return this.result;
    },
    setResult: function(e) {
        this.result = e;
    },
    getError: function() {
        kerio.api.applyType(this.error, "LocalizableMessage");
        return this.error;
    },
    setError: function(e) {
        this.error = e;
    }
};

kerio.api.type.EncryptInfo.fields = {
    ALL_FIELDS: [ "isEncrypted", "result", "error" ],
    isEncrypted: "isEncrypted",
    result: "result",
    error: "error"
};

kerio.api.enums.mails.SearchFields.QUICKSEARCH = "QUICKSEARCH";

kerio.api.enums.mails.SearchFields.QUICKSEARCHSENT = "QUICKSEARCHSENT";

kerio.api.enums.mails.SearchFields.FULLTEXT = "FULLTEXT";

kerio.api.enums.mails.SearchFields.messageId = "messageId";

kerio.api.enums.mails.SearchFields.body = "body";

kerio.api.enums.mails.SearchFields.subject = "subject";

kerio.api.enums.mails.SearchFields.from = "from";

kerio.api.enums.mails.SearchFields.to = "to";

kerio.api.enums.mails.SearchFields.cc = "cc";

kerio.api.enums.mails.SearchFields.hasAttachment = "hasAttachment";

kerio.api.enums.mails.SearchFields.priority = "priority";

kerio.api.enums.mails.SearchFields.sendDate = "sendDate";

kerio.api.enums.mails.SearchFields.receiveDate = "receiveDate";

kerio.api.enums.mails.SearchFields.size = "size";

kerio.api.enums.mails.SearchFields.modifiedDate = "modifiedDate";

kerio.api.enums.mails.SearchFields.isFlagged = "isFlagged";

kerio.api.enums.mails.SearchFields.isSeen = "isSeen";

kerio.api.type.Mail = function() {};

kerio.api.type.Mail.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getFolderId: function() {
        return this.folderId;
    },
    setFolderId: function(e) {
        this.folderId = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    },
    getFrom: function() {
        kerio.api.applyType(this.from, "Email");
        return this.from;
    },
    setFrom: function(e) {
        this.from = e;
    },
    getSender: function() {
        kerio.api.applyType(this.sender, "Email");
        return this.sender;
    },
    setSender: function(e) {
        this.sender = e;
    },
    getTo: function() {
        kerio.api.applyType(this.to, "Email");
        return this.to;
    },
    setTo: function(e) {
        this.to = e;
    },
    getCc: function() {
        kerio.api.applyType(this.cc, "Email");
        return this.cc;
    },
    setCc: function(e) {
        this.cc = e;
    },
    getBcc: function() {
        kerio.api.applyType(this.bcc, "Email");
        return this.bcc;
    },
    setBcc: function(e) {
        this.bcc = e;
    },
    getSendDate: function() {
        return this.sendDate;
    },
    setSendDate: function(e) {
        this.sendDate = e;
    },
    getReceiveDate: function() {
        return this.receiveDate;
    },
    setReceiveDate: function(e) {
        this.receiveDate = e;
    },
    getModifiedDate: function() {
        return this.modifiedDate;
    },
    setModifiedDate: function(e) {
        this.modifiedDate = e;
    },
    getReplyTo: function() {
        kerio.api.applyType(this.replyTo, "Email");
        return this.replyTo;
    },
    setReplyTo: function(e) {
        this.replyTo = e;
    },
    getNotificationTo: function() {
        kerio.api.applyType(this.notificationTo, "Email");
        return this.notificationTo;
    },
    setNotificationTo: function(e) {
        this.notificationTo = e;
    },
    getSubject: function() {
        return this.subject;
    },
    setSubject: function(e) {
        this.subject = e;
    },
    getPriority: function() {
        return this.priority;
    },
    setPriority: function(e) {
        this.priority = e;
    },
    getSize: function() {
        return this.size;
    },
    setSize: function(e) {
        this.size = e;
    },
    getIsSeen: function() {
        return this.isSeen;
    },
    setIsSeen: function(e) {
        this.isSeen = e;
    },
    getIsAnswered: function() {
        return this.isAnswered;
    },
    setIsAnswered: function(e) {
        this.isAnswered = e;
    },
    getIsFlagged: function() {
        return this.isFlagged;
    },
    setIsFlagged: function(e) {
        this.isFlagged = e;
    },
    getIsForwarded: function() {
        return this.isForwarded;
    },
    setIsForwarded: function(e) {
        this.isForwarded = e;
    },
    getIsJunk: function() {
        return this.isJunk;
    },
    setIsJunk: function(e) {
        this.isJunk = e;
    },
    getIsMDNSent: function() {
        return this.isMDNSent;
    },
    setIsMDNSent: function(e) {
        this.isMDNSent = e;
    },
    getShowExternal: function() {
        return this.showExternal;
    },
    setShowExternal: function(e) {
        this.showExternal = e;
    },
    getRequestDSN: function() {
        return this.requestDSN;
    },
    setRequestDSN: function(e) {
        this.requestDSN = e;
    },
    getHasAttachment: function() {
        return this.hasAttachment;
    },
    setHasAttachment: function(e) {
        this.hasAttachment = e;
    },
    getIsDraft: function() {
        return this.isDraft;
    },
    setIsDraft: function(e) {
        this.isDraft = e;
    },
    getIsReadOnly: function() {
        return this.isReadOnly;
    },
    setIsReadOnly: function(e) {
        this.isReadOnly = e;
    },
    getSignInfo: function() {
        kerio.api.applyType(this.signInfo, "SignInfo");
        return this.signInfo;
    },
    setSignInfo: function(e) {
        this.signInfo = e;
    },
    getEncryptInfo: function() {
        kerio.api.applyType(this.encryptInfo, "EncryptInfo");
        return this.encryptInfo;
    },
    setEncryptInfo: function(e) {
        this.encryptInfo = e;
    },
    getDisplayableParts: function() {
        kerio.api.applyType(this.displayableParts, "DisplayableMimePart");
        return this.displayableParts;
    },
    setDisplayableParts: function(e) {
        this.displayableParts = e;
    },
    getAttachments: function() {
        kerio.api.applyType(this.attachments, "Attachment");
        return this.attachments;
    },
    setAttachments: function(e) {
        this.attachments = e;
    },
    getHeaders: function() {
        kerio.api.applyType(this.headers, "MimeHeader");
        return this.headers;
    },
    setHeaders: function(e) {
        this.headers = e;
    },
    getSend: function() {
        return this.send;
    },
    setSend: function(e) {
        this.send = e;
    },
    getSign: function() {
        return this.sign;
    },
    setSign: function(e) {
        this.sign = e;
    },
    getEncrypt: function() {
        return this.encrypt;
    },
    setEncrypt: function(e) {
        this.encrypt = e;
    }
};

kerio.api.type.Mail.fields = {
    ALL_FIELDS: [ "id", "folderId", "watermark", "from", "sender", "to", "cc", "bcc", "sendDate", "receiveDate", "modifiedDate", "replyTo", "notificationTo", "subject", "priority", "size", "isSeen", "isAnswered", "isFlagged", "isForwarded", "isJunk", "isMDNSent", "showExternal", "requestDSN", "hasAttachment", "isDraft", "isReadOnly", "signInfo", "encryptInfo", "displayableParts", "attachments", "headers", "send", "sign", "encrypt" ],
    id: "id",
    folderId: "folderId",
    watermark: "watermark",
    from: "from",
    sender: "sender",
    to: "to",
    cc: "cc",
    bcc: "bcc",
    sendDate: "sendDate",
    receiveDate: "receiveDate",
    modifiedDate: "modifiedDate",
    replyTo: "replyTo",
    notificationTo: "notificationTo",
    subject: "subject",
    priority: "priority",
    size: "size",
    isSeen: "isSeen",
    isAnswered: "isAnswered",
    isFlagged: "isFlagged",
    isForwarded: "isForwarded",
    isJunk: "isJunk",
    isMDNSent: "isMDNSent",
    showExternal: "showExternal",
    requestDSN: "requestDSN",
    hasAttachment: "hasAttachment",
    isDraft: "isDraft",
    isReadOnly: "isReadOnly",
    signInfo: "signInfo",
    encryptInfo: "encryptInfo",
    displayableParts: "displayableParts",
    attachments: "attachments",
    headers: "headers",
    send: "send",
    sign: "sign",
    encrypt: "encrypt"
};

kerio.api.Mails = {
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    getPageWithId: function(e, t) {
        return kerio.api.callMethod(this.Def.getPageWithId.name, e, t, this.Def.getPageWithId.Response);
    },
    getById: function(e, t) {
        return kerio.api.callMethod(this.Def.getById.name, e, t, this.Def.getById.Response);
    },
    create: function(e, t) {
        return kerio.api.callMethod(this.Def.create.name, e, t, this.Def.create.Response);
    },
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    setAllSeen: function(e, t) {
        return kerio.api.callMethod(this.Def.setAllSeen.name, e, t, this.Def.setAllSeen.Response);
    },
    copy: function(e, t) {
        return kerio.api.callMethod(this.Def.copy.name, e, t, this.Def.copy.Response);
    },
    move: function(e, t) {
        return kerio.api.callMethod(this.Def.move.name, e, t, this.Def.move.Response);
    },
    exportAttachments: function(e, t) {
        return kerio.api.callMethod(this.Def.exportAttachments.name, e, t, this.Def.exportAttachments.Response);
    },
    Def: {
        $name: "Mails",
        get: {
            name: "Mails.get",
            input: {
                folderIds: "folderIds",
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getPageWithId: {
            name: "Mails.getPageWithId",
            input: {
                folderIds: "folderIds",
                query: "query",
                id: "id"
            },
            output: {
                list: "list",
                start: "start",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getById: {
            name: "Mails.getById",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        create: {
            name: "Mails.create",
            input: {
                mails: "mails"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        remove: {
            name: "Mails.remove",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Mails.set",
            input: {
                mails: "mails"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        setAllSeen: {
            name: "Mails.setAllSeen",
            input: {
                folderId: "folderId"
            },
            Request: function() {}
        },
        copy: {
            name: "Mails.copy",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        move: {
            name: "Mails.move",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        exportAttachments: {
            name: "Mails.exportAttachments",
            input: {
                attachmentIds: "attachmentIds"
            },
            output: {
                fileDownload: "fileDownload"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Mails.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Mail");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Mails.Def.getPageWithId.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Mail");
        return this.list;
    },
    getStart: function() {
        return this.start;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Mails.Def.getById.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "Mail");
        return this.result;
    }
};

kerio.api.Mails.Def.create.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Mails.Def.remove.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Mails.Def.set.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "SetResult");
        return this.result;
    }
};

kerio.api.Mails.Def.copy.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Mails.Def.move.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Mails.Def.exportAttachments.Response.prototype = {
    getFileDownload: function() {
        kerio.api.applyType(this.fileDownload, "Download");
        return this.fileDownload;
    }
};

kerio.api.Mails.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.get(this, e);
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Mails.Def.getPageWithId.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.getPageWithId(this, e);
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    },
    setQuery: function(e) {
        this.query = e;
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Mails.Def.getById.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.getById(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Mails.Def.create.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.create(this, e);
    },
    setMails: function(e) {
        this.mails = e;
    }
};

kerio.api.Mails.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.remove(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Mails.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.set(this, e);
    },
    setMails: function(e) {
        this.mails = e;
    }
};

kerio.api.Mails.Def.setAllSeen.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.setAllSeen(this, e);
    },
    setFolderId: function(e) {
        this.folderId = e;
    }
};

kerio.api.Mails.Def.copy.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.copy(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

kerio.api.Mails.Def.move.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.move(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

kerio.api.Mails.Def.exportAttachments.Request.prototype = {
    send: function(e) {
        return kerio.api.Mails.exportAttachments(this, e);
    },
    setAttachmentIds: function(e) {
        this.attachmentIds = e;
    }
};

if (!window.kerio.api.enums.folders) {
    window.kerio.api.enums.folders = {
        SearchFields: {}
    };
}

kerio.api.enums.folders.FolderSubType = {
    FSubNone: "FSubNone",
    FSubInbox: "FSubInbox",
    FSubDrafts: "FSubDrafts",
    FSubSentItems: "FSubSentItems",
    FSubDeletedItems: "FSubDeletedItems",
    FSubJunkEmail: "FSubJunkEmail",
    FSubDefault: "FSubDefault",
    FSubGalResources: "FSubGalResources",
    FSubGalContacts: "FSubGalContacts",
    FakeSubType: "FakeSubType"
};

kerio.api.enums.folders.FolderType = {
    FRoot: "FRoot",
    FMail: "FMail",
    FContact: "FContact",
    FCalendar: "FCalendar",
    FTask: "FTask",
    FNote: "FNote"
};

kerio.api.enums.folders.FolderPlaceType = {
    FPlaceMailbox: "FPlaceMailbox",
    FPlaceResources: "FPlaceResources",
    FPlaceLocations: "FPlaceLocations",
    FPlacePeople: "FPlacePeople",
    FPlacePublic: "FPlacePublic",
    FPlaceArchive: "FPlaceArchive"
};

kerio.api.enums.folders.FolderAccess = {
    FAccessListingOnly: "FAccessListingOnly",
    FAccessReadOnly: "FAccessReadOnly",
    FAccessReadWrite: "FAccessReadWrite",
    FAccessAdmin: "FAccessAdmin"
};

kerio.api.type.FolderPermission = function() {};

kerio.api.type.FolderPermission.prototype = {
    getAccess: function() {
        return this.access;
    },
    setAccess: function(e) {
        this.access = e;
    },
    getPrincipal: function() {
        kerio.api.applyType(this.principal, "Principal");
        return this.principal;
    },
    setPrincipal: function(e) {
        this.principal = e;
    },
    getInherited: function() {
        return this.inherited;
    },
    setInherited: function(e) {
        this.inherited = e;
    },
    getIsDelegatee: function() {
        return this.isDelegatee;
    },
    setIsDelegatee: function(e) {
        this.isDelegatee = e;
    }
};

kerio.api.type.FolderPermission.fields = {
    ALL_FIELDS: [ "access", "principal", "inherited", "isDelegatee" ],
    access: "access",
    principal: "principal",
    inherited: "inherited",
    isDelegatee: "isDelegatee"
};

kerio.api.type.Folder = function() {};

kerio.api.type.Folder.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getParentId: function() {
        return this.parentId;
    },
    setParentId: function(e) {
        this.parentId = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getOwnerName: function() {
        return this.ownerName;
    },
    setOwnerName: function(e) {
        this.ownerName = e;
    },
    getEmailAddress: function() {
        return this.emailAddress;
    },
    setEmailAddress: function(e) {
        this.emailAddress = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getSubType: function() {
        return this.subType;
    },
    setSubType: function(e) {
        this.subType = e;
    },
    getPlaceType: function() {
        return this.placeType;
    },
    setPlaceType: function(e) {
        this.placeType = e;
    },
    getAccess: function() {
        return this.access;
    },
    setAccess: function(e) {
        this.access = e;
    },
    getIsShared: function() {
        return this.isShared;
    },
    setIsShared: function(e) {
        this.isShared = e;
    },
    getIsDelegated: function() {
        return this.isDelegated;
    },
    setIsDelegated: function(e) {
        this.isDelegated = e;
    },
    getNestingLevel: function() {
        return this.nestingLevel;
    },
    setNestingLevel: function(e) {
        this.nestingLevel = e;
    },
    getMessageCount: function() {
        return this.messageCount;
    },
    setMessageCount: function(e) {
        this.messageCount = e;
    },
    getMessageUnread: function() {
        return this.messageUnread;
    },
    setMessageUnread: function(e) {
        this.messageUnread = e;
    },
    getMessageSize: function() {
        return this.messageSize;
    },
    setMessageSize: function(e) {
        this.messageSize = e;
    },
    getChecked: function() {
        return this.checked;
    },
    setChecked: function(e) {
        this.checked = e;
    },
    getColor: function() {
        return this.color;
    },
    setColor: function(e) {
        this.color = e;
    },
    getPublished: function() {
        return this.published;
    },
    setPublished: function(e) {
        this.published = e;
    }
};

kerio.api.type.Folder.fields = {
    ALL_FIELDS: [ "id", "parentId", "name", "ownerName", "emailAddress", "type", "subType", "placeType", "access", "isShared", "isDelegated", "nestingLevel", "messageCount", "messageUnread", "messageSize", "checked", "color", "published" ],
    id: "id",
    parentId: "parentId",
    name: "name",
    ownerName: "ownerName",
    emailAddress: "emailAddress",
    type: "type",
    subType: "subType",
    placeType: "placeType",
    access: "access",
    isShared: "isShared",
    isDelegated: "isDelegated",
    nestingLevel: "nestingLevel",
    messageCount: "messageCount",
    messageUnread: "messageUnread",
    messageSize: "messageSize",
    checked: "checked",
    color: "color",
    published: "published"
};

kerio.api.type.SharedMailbox = function() {};

kerio.api.type.SharedMailbox.prototype = {
    getPrincipal: function() {
        kerio.api.applyType(this.principal, "Principal");
        return this.principal;
    },
    setPrincipal: function(e) {
        this.principal = e;
    },
    getMailboxId: function() {
        return this.mailboxId;
    },
    setMailboxId: function(e) {
        this.mailboxId = e;
    },
    getIsLoaded: function() {
        return this.isLoaded;
    },
    setIsLoaded: function(e) {
        this.isLoaded = e;
    },
    getFolders: function() {
        kerio.api.applyType(this.folders, "Folder");
        return this.folders;
    },
    setFolders: function(e) {
        this.folders = e;
    },
    getSubscribedFolderIds: function() {
        return this.subscribedFolderIds;
    },
    setSubscribedFolderIds: function(e) {
        this.subscribedFolderIds = e;
    }
};

kerio.api.type.SharedMailbox.fields = {
    ALL_FIELDS: [ "principal", "mailboxId", "isLoaded", "folders", "subscribedFolderIds" ],
    principal: "principal",
    mailboxId: "mailboxId",
    isLoaded: "isLoaded",
    folders: "folders",
    subscribedFolderIds: "subscribedFolderIds"
};

kerio.api.Folders = {
    clearToItemId: function(e, t) {
        return kerio.api.callMethod(this.Def.clearToItemId.name, e, t, this.Def.clearToItemId.Response);
    },
    create: function(e, t) {
        return kerio.api.callMethod(this.Def.create.name, e, t, this.Def.create.Response);
    },
    get: function(e) {
        return kerio.api.callMethod(this.Def.get.name, {}, e, this.Def.get.Response);
    },
    getShared: function(e, t) {
        return kerio.api.callMethod(this.Def.getShared.name, e, t, this.Def.getShared.Response);
    },
    getPublic: function(e) {
        return kerio.api.callMethod(this.Def.getPublic.name, {}, e, this.Def.getPublic.Response);
    },
    getSubscribed: function(e) {
        return kerio.api.callMethod(this.Def.getSubscribed.name, {}, e, this.Def.getSubscribed.Response);
    },
    getAutoCompleteContactsFolderId: function(e) {
        return kerio.api.callMethod(this.Def.getAutoCompleteContactsFolderId.name, {}, e, this.Def.getAutoCompleteContactsFolderId.Response);
    },
    getSharedMailboxList: function(e) {
        return kerio.api.callMethod(this.Def.getSharedMailboxList.name, {}, e, this.Def.getSharedMailboxList.Response);
    },
    moveByType: function(e, t) {
        return kerio.api.callMethod(this.Def.moveByType.name, e, t, this.Def.moveByType.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    removeByType: function(e, t) {
        return kerio.api.callMethod(this.Def.removeByType.name, e, t, this.Def.removeByType.Response);
    },
    getPermissions: function(e, t) {
        return kerio.api.callMethod(this.Def.getPermissions.name, e, t, this.Def.getPermissions.Response);
    },
    setPermissions: function(e, t) {
        return kerio.api.callMethod(this.Def.setPermissions.name, e, t, this.Def.setPermissions.Response);
    },
    getSubscriptionList: function(e) {
        return kerio.api.callMethod(this.Def.getSubscriptionList.name, {}, e, this.Def.getSubscriptionList.Response);
    },
    setSubscriptionList: function(e, t) {
        return kerio.api.callMethod(this.Def.setSubscriptionList.name, e, t, this.Def.setSubscriptionList.Response);
    },
    copyAllMessages: function(e, t) {
        return kerio.api.callMethod(this.Def.copyAllMessages.name, e, t, this.Def.copyAllMessages.Response);
    },
    Def: {
        $name: "Folders",
        clearToItemId: {
            name: "Folders.clearToItemId",
            input: {
                itemId: "itemId"
            },
            Request: function() {}
        },
        create: {
            name: "Folders.create",
            input: {
                folders: "folders"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        get: {
            name: "Folders.get",
            Request: function() {},
            Response: {}
        },
        getShared: {
            name: "Folders.getShared",
            input: {
                mailboxId: "mailboxId"
            },
            output: {
                list: "list"
            },
            Request: function() {},
            Response: {}
        },
        getPublic: {
            name: "Folders.getPublic",
            Request: function() {},
            Response: {}
        },
        getSubscribed: {
            name: "Folders.getSubscribed",
            Request: function() {},
            Response: {}
        },
        getAutoCompleteContactsFolderId: {
            name: "Folders.getAutoCompleteContactsFolderId",
            Request: function() {},
            Response: {}
        },
        getSharedMailboxList: {
            name: "Folders.getSharedMailboxList",
            Request: function() {},
            Response: {}
        },
        moveByType: {
            name: "Folders.moveByType",
            input: {
                targetId: "targetId",
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Folders.set",
            input: {
                folders: "folders"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        remove: {
            name: "Folders.remove",
            input: {
                ids: "ids",
                recursive: "recursive"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        removeByType: {
            name: "Folders.removeByType",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        getPermissions: {
            name: "Folders.getPermissions",
            input: {
                folderId: "folderId"
            },
            output: {
                permissions: "permissions"
            },
            Request: function() {},
            Response: {}
        },
        setPermissions: {
            name: "Folders.setPermissions",
            input: {
                permissions: "permissions",
                folderId: "folderId",
                recursive: "recursive"
            },
            Request: function() {}
        },
        getSubscriptionList: {
            name: "Folders.getSubscriptionList",
            Request: function() {},
            Response: {}
        },
        setSubscriptionList: {
            name: "Folders.setSubscriptionList",
            input: {
                folderIds: "folderIds"
            },
            Request: function() {}
        },
        copyAllMessages: {
            name: "Folders.copyAllMessages",
            input: {
                sourceId: "sourceId",
                destId: "destId",
                doMove: "doMove"
            },
            Request: function() {}
        }
    }
};

kerio.api.Folders.Def.create.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Folders.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Folder");
        return this.list;
    }
};

kerio.api.Folders.Def.getShared.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Folder");
        return this.list;
    }
};

kerio.api.Folders.Def.getPublic.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Folder");
        return this.list;
    }
};

kerio.api.Folders.Def.getSubscribed.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "SharedMailbox");
        return this.list;
    }
};

kerio.api.Folders.Def.getAutoCompleteContactsFolderId.Response.prototype = {
    getFolderId: function() {
        return this.folderId;
    }
};

kerio.api.Folders.Def.getSharedMailboxList.Response.prototype = {
    getMailboxes: function() {
        kerio.api.applyType(this.mailboxes, "SharedMailbox");
        return this.mailboxes;
    }
};

kerio.api.Folders.Def.moveByType.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Folders.Def.set.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Folders.Def.remove.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Folders.Def.removeByType.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Folders.Def.getPermissions.Response.prototype = {
    getPermissions: function() {
        kerio.api.applyType(this.permissions, "FolderPermission");
        return this.permissions;
    }
};

kerio.api.Folders.Def.getSubscriptionList.Response.prototype = {
    getFolderIds: function() {
        return this.folderIds;
    }
};

kerio.api.Folders.Def.clearToItemId.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.clearToItemId(this, e);
    },
    setItemId: function(e) {
        this.itemId = e;
    }
};

kerio.api.Folders.Def.create.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.create(this, e);
    },
    setFolders: function(e) {
        this.folders = e;
    }
};

kerio.api.Folders.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.get(e);
    }
};

kerio.api.Folders.Def.getShared.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.getShared(this, e);
    },
    setMailboxId: function(e) {
        this.mailboxId = e;
    }
};

kerio.api.Folders.Def.getPublic.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.getPublic(e);
    }
};

kerio.api.Folders.Def.getSubscribed.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.getSubscribed(e);
    }
};

kerio.api.Folders.Def.getAutoCompleteContactsFolderId.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.getAutoCompleteContactsFolderId(e);
    }
};

kerio.api.Folders.Def.getSharedMailboxList.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.getSharedMailboxList(e);
    }
};

kerio.api.Folders.Def.moveByType.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.moveByType(this, e);
    },
    setTargetId: function(e) {
        this.targetId = e;
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Folders.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.set(this, e);
    },
    setFolders: function(e) {
        this.folders = e;
    }
};

kerio.api.Folders.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.remove(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setRecursive: function(e) {
        this.recursive = e;
    }
};

kerio.api.Folders.Def.removeByType.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.removeByType(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Folders.Def.getPermissions.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.getPermissions(this, e);
    },
    setFolderId: function(e) {
        this.folderId = e;
    }
};

kerio.api.Folders.Def.setPermissions.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.setPermissions(this, e);
    },
    setPermissions: function(e) {
        this.permissions = e;
    },
    setFolderId: function(e) {
        this.folderId = e;
    },
    setRecursive: function(e) {
        this.recursive = e;
    }
};

kerio.api.Folders.Def.getSubscriptionList.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.getSubscriptionList(e);
    }
};

kerio.api.Folders.Def.setSubscriptionList.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.setSubscriptionList(this, e);
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    }
};

kerio.api.Folders.Def.copyAllMessages.Request.prototype = {
    send: function(e) {
        return kerio.api.Folders.copyAllMessages(this, e);
    },
    setSourceId: function(e) {
        this.sourceId = e;
    },
    setDestId: function(e) {
        this.destId = e;
    },
    setDoMove: function(e) {
        this.doMove = e;
    }
};

kerio.api.consts.ErrorCodeParseError = -32700;

kerio.api.consts.ErrorCodeInternalError = -32603;

kerio.api.consts.ErrorCodeInvalidParams = -32602;

kerio.api.consts.ErrorCodeMethodNotFound = -32601;

kerio.api.consts.ErrorCodeInvalidRequest = -32600;

kerio.api.consts.ErrorCodeMultiServerBackendMaintenance = -32003;

kerio.api.consts.ErrorCodeTimedout = -32002;

kerio.api.consts.ErrorCodeSessionExpired = -32001;

kerio.api.consts.ErrorCodeCommunicationFailure = -1;

kerio.api.consts.ErrorCodeRequestEntityTooLarge = 413;

kerio.api.consts.ErrorCodeOperationFailed = 1e3;

kerio.api.consts.ErrorCodeAlreadyExists = 1001;

kerio.api.consts.ErrorCodeNoSuchEntity = 1002;

kerio.api.consts.ErrorCodeNotPermitted = 1003;

kerio.api.consts.ErrorCodeAccessDenied = 1004;

kerio.api.consts.ErrorCodeDangerousOperation = 4e3;

kerio.api.consts.ErrorCodePartialSuccess = 4001;

kerio.api.consts.ErrorCodeChangePswFailed = 4002;

kerio.api.consts.ErrorCodeFolderReindexing = 4100;

kerio.api.consts.ErrorCodeOperationInProgress = 4101;

kerio.api.consts.ErrorCodeQuotaReached = 4102;

kerio.api.consts.ErrorCodeSendingFailed = 4103;

kerio.api.consts.ErrorCodeNoSuchFolder = 4104;

kerio.api.consts.ErrorCodeOperatorSessionExpired = 4105;

kerio.api.consts.ErrorCodeEncryptionFailed = 5e3;

kerio.api.consts.ErrorCodeNotEnoughSpace = 5001;

kerio.api.consts.ErrorCodeDecryptionFailed = 5010;

kerio.api.consts.ErrorCodeNotEnoughSpaceDec = 5011;

kerio.api.consts.ErrorCodeIncorrectPassword = 5012;

kerio.api.consts.ErrorCodeIncPassWait = 5013;

kerio.api.consts.ErrorCodeThreeAttempts = 5014;

kerio.api.consts.ErrorCodeSavePassword = 5022;

kerio.api.consts.ErrorCodeLimitReached = 4106;

kerio.api.enums.PriorityType = {
    Normal: "Normal",
    Low: "Low",
    High: "High"
};

kerio.api.enums.ItemType = {
    itMail: "itMail",
    itCalendar: "itCalendar",
    itContact: "itContact",
    itTask: "itTask",
    itNote: "itNote",
    itCalendarInbox: "itCalendarInbox"
};

kerio.api.type.CreateResult = function() {};

kerio.api.type.CreateResult.prototype = {
    getInputIndex: function() {
        return this.inputIndex;
    },
    setInputIndex: function(e) {
        this.inputIndex = e;
    },
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    }
};

kerio.api.type.CreateResult.fields = {
    ALL_FIELDS: [ "inputIndex", "id", "watermark" ],
    inputIndex: "inputIndex",
    id: "id",
    watermark: "watermark"
};

kerio.api.type.SetResult = function() {};

kerio.api.type.SetResult.prototype = {
    getInputIndex: function() {
        return this.inputIndex;
    },
    setInputIndex: function(e) {
        this.inputIndex = e;
    },
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    }
};

kerio.api.type.SetResult.fields = {
    ALL_FIELDS: [ "inputIndex", "id", "watermark" ],
    inputIndex: "inputIndex",
    id: "id",
    watermark: "watermark"
};

kerio.api.type.Image = function() {};

kerio.api.type.Image.prototype = {
    getUrl: function() {
        return this.url;
    },
    setUrl: function(e) {
        this.url = e;
    },
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.type.Image.fields = {
    ALL_FIELDS: [ "url", "id" ],
    url: "url",
    id: "id"
};

if (!window.kerio.api.enums.session) {
    window.kerio.api.enums.session = {
        SearchFields: {}
    };
}

kerio.api.type.UserInfo = function() {};

kerio.api.type.UserInfo.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getLoginName: function() {
        return this.loginName;
    },
    setLoginName: function(e) {
        this.loginName = e;
    },
    getFullName: function() {
        return this.fullName;
    },
    setFullName: function(e) {
        this.fullName = e;
    },
    getEmails: function() {
        return this.emails;
    },
    setEmails: function(e) {
        this.emails = e;
    },
    getPreferredAddress: function() {
        return this.preferredAddress;
    },
    setPreferredAddress: function(e) {
        this.preferredAddress = e;
    },
    getReplyToAddress: function() {
        return this.replyToAddress;
    },
    setReplyToAddress: function(e) {
        this.replyToAddress = e;
    }
};

kerio.api.type.UserInfo.fields = {
    ALL_FIELDS: [ "id", "loginName", "fullName", "emails", "preferredAddress", "replyToAddress" ],
    id: "id",
    loginName: "loginName",
    fullName: "fullName",
    emails: "emails",
    preferredAddress: "preferredAddress",
    replyToAddress: "replyToAddress"
};

kerio.api.type.OutOfOfficeSettings = function() {};

kerio.api.type.OutOfOfficeSettings.prototype = {
    getIsEnabled: function() {
        return this.isEnabled;
    },
    setIsEnabled: function(e) {
        this.isEnabled = e;
    },
    getText: function() {
        return this.text;
    },
    setText: function(e) {
        this.text = e;
    },
    getIsTimeRangeEnabled: function() {
        return this.isTimeRangeEnabled;
    },
    setIsTimeRangeEnabled: function(e) {
        this.isTimeRangeEnabled = e;
    },
    getTimeRangeStart: function() {
        return this.timeRangeStart;
    },
    setTimeRangeStart: function(e) {
        this.timeRangeStart = e;
    },
    getTimeRangeEnd: function() {
        return this.timeRangeEnd;
    },
    setTimeRangeEnd: function(e) {
        this.timeRangeEnd = e;
    }
};

kerio.api.type.OutOfOfficeSettings.fields = {
    ALL_FIELDS: [ "isEnabled", "text", "isTimeRangeEnabled", "timeRangeStart", "timeRangeEnd" ],
    isEnabled: "isEnabled",
    text: "text",
    isTimeRangeEnabled: "isTimeRangeEnabled",
    timeRangeStart: "timeRangeStart",
    timeRangeEnd: "timeRangeEnd"
};

kerio.api.type.SpamSettings = function() {};

kerio.api.type.SpamSettings.prototype = {
    getIsEnabled: function() {
        return this.isEnabled;
    },
    setIsEnabled: function(e) {
        this.isEnabled = e;
    },
    getWhiteListContacts: function() {
        return this.whiteListContacts;
    },
    setWhiteListContacts: function(e) {
        this.whiteListContacts = e;
    },
    getAutoupdateWhiteList: function() {
        return this.autoupdateWhiteList;
    },
    setAutoupdateWhiteList: function(e) {
        this.autoupdateWhiteList = e;
    },
    getWhiteList: function() {
        return this.whiteList;
    },
    setWhiteList: function(e) {
        this.whiteList = e;
    }
};

kerio.api.type.SpamSettings.fields = {
    ALL_FIELDS: [ "isEnabled", "whiteListContacts", "autoupdateWhiteList", "whiteList" ],
    isEnabled: "isEnabled",
    whiteListContacts: "whiteListContacts",
    autoupdateWhiteList: "autoupdateWhiteList",
    whiteList: "whiteList"
};

kerio.api.type.QuotaInfo = function() {};

kerio.api.type.QuotaInfo.prototype = {
    getMessagesLimit: function() {
        return this.messagesLimit;
    },
    setMessagesLimit: function(e) {
        this.messagesLimit = e;
    },
    getMessagesUsed: function() {
        return this.messagesUsed;
    },
    setMessagesUsed: function(e) {
        this.messagesUsed = e;
    },
    getSpaceLimit: function() {
        return this.spaceLimit;
    },
    setSpaceLimit: function(e) {
        this.spaceLimit = e;
    },
    getSpaceUsed: function() {
        return this.spaceUsed;
    },
    setSpaceUsed: function(e) {
        this.spaceUsed = e;
    },
    getPercentLimitForWarning: function() {
        return this.percentLimitForWarning;
    },
    setPercentLimitForWarning: function(e) {
        this.percentLimitForWarning = e;
    }
};

kerio.api.type.QuotaInfo.fields = {
    ALL_FIELDS: [ "messagesLimit", "messagesUsed", "spaceLimit", "spaceUsed", "percentLimitForWarning" ],
    messagesLimit: "messagesLimit",
    messagesUsed: "messagesUsed",
    spaceLimit: "spaceLimit",
    spaceUsed: "spaceUsed",
    percentLimitForWarning: "percentLimitForWarning"
};

kerio.api.type.PasswordPolicy = function() {};

kerio.api.type.PasswordPolicy.prototype = {
    getIsEnabled: function() {
        return this.isEnabled;
    },
    setIsEnabled: function(e) {
        this.isEnabled = e;
    },
    getMinLength: function() {
        return this.minLength;
    },
    setMinLength: function(e) {
        this.minLength = e;
    }
};

kerio.api.type.PasswordPolicy.fields = {
    ALL_FIELDS: [ "isEnabled", "minLength" ],
    isEnabled: "isEnabled",
    minLength: "minLength"
};

kerio.api.Session = {
    canUserChangePassword: function(e) {
        return kerio.api.callMethod(this.Def.canUserChangePassword.name, {}, e, this.Def.canUserChangePassword.Response);
    },
    getAvailableTimeZones: function(e) {
        return kerio.api.callMethod(this.Def.getAvailableTimeZones.name, {}, e, this.Def.getAvailableTimeZones.Response);
    },
    getAvailableTimeZonesIncludeUnixZones: function(e) {
        return kerio.api.callMethod(this.Def.getAvailableTimeZonesIncludeUnixZones.name, {}, e, this.Def.getAvailableTimeZonesIncludeUnixZones.Response);
    },
    getAvailableLanguages: function(e) {
        return kerio.api.callMethod(this.Def.getAvailableLanguages.name, {}, e, this.Def.getAvailableLanguages.Response);
    },
    getOutOfOffice: function(e) {
        return kerio.api.callMethod(this.Def.getOutOfOffice.name, {}, e, this.Def.getOutOfOffice.Response);
    },
    getQuotaInformation: function(e) {
        return kerio.api.callMethod(this.Def.getQuotaInformation.name, {}, e, this.Def.getQuotaInformation.Response);
    },
    getSettings: function(e, t) {
        return kerio.api.callMethod(this.Def.getSettings.name, e, t, this.Def.getSettings.Response);
    },
    getSpamSettings: function(e) {
        return kerio.api.callMethod(this.Def.getSpamSettings.name, {}, e, this.Def.getSpamSettings.Response);
    },
    getUserVoiceUrl: function(e) {
        return kerio.api.callMethod(this.Def.getUserVoiceUrl.name, {}, e, this.Def.getUserVoiceUrl.Response);
    },
    login: function(e, t) {
        return kerio.api.callMethod(this.Def.login.name, e, t, this.Def.login.Response);
    },
    logout: function(e) {
        return kerio.api.callMethod(this.Def.logout.name, {}, e, this.Def.logout.Response);
    },
    setOutOfOffice: function(e, t) {
        return kerio.api.callMethod(this.Def.setOutOfOffice.name, e, t, this.Def.setOutOfOffice.Response);
    },
    setPassword: function(e, t) {
        return kerio.api.callMethod(this.Def.setPassword.name, e, t, this.Def.setPassword.Response);
    },
    setSettings: function(e, t) {
        return kerio.api.callMethod(this.Def.setSettings.name, e, t, this.Def.setSettings.Response);
    },
    setSpamSettings: function(e, t) {
        return kerio.api.callMethod(this.Def.setSpamSettings.name, e, t, this.Def.setSpamSettings.Response);
    },
    setUserInfo: function(e, t) {
        return kerio.api.callMethod(this.Def.setUserInfo.name, e, t, this.Def.setUserInfo.Response);
    },
    whoAmI: function(e) {
        return kerio.api.callMethod(this.Def.whoAmI.name, {}, e, this.Def.whoAmI.Response);
    },
    getMobileDeviceList: function(e, t) {
        return kerio.api.callMethod(this.Def.getMobileDeviceList.name, e, t, this.Def.getMobileDeviceList.Response);
    },
    removeMobileDevice: function(e, t) {
        return kerio.api.callMethod(this.Def.removeMobileDevice.name, e, t, this.Def.removeMobileDevice.Response);
    },
    wipeMobileDevice: function(e, t) {
        return kerio.api.callMethod(this.Def.wipeMobileDevice.name, e, t, this.Def.wipeMobileDevice.Response);
    },
    cancelWipeMobileDevice: function(e, t) {
        return kerio.api.callMethod(this.Def.cancelWipeMobileDevice.name, e, t, this.Def.cancelWipeMobileDevice.Response);
    },
    getSignatureImageList: function(e) {
        return kerio.api.callMethod(this.Def.getSignatureImageList.name, {}, e, this.Def.getSignatureImageList.Response);
    },
    addSignatureImage: function(e, t) {
        return kerio.api.callMethod(this.Def.addSignatureImage.name, e, t, this.Def.addSignatureImage.Response);
    },
    removeSignatureImage: function(e, t) {
        return kerio.api.callMethod(this.Def.removeSignatureImage.name, e, t, this.Def.removeSignatureImage.Response);
    },
    Def: {
        $name: "Session",
        canUserChangePassword: {
            name: "Session.canUserChangePassword",
            Request: function() {},
            Response: {}
        },
        getAvailableTimeZones: {
            name: "Session.getAvailableTimeZones",
            Request: function() {},
            Response: {}
        },
        getAvailableTimeZonesIncludeUnixZones: {
            name: "Session.getAvailableTimeZonesIncludeUnixZones",
            Request: function() {},
            Response: {}
        },
        getAvailableLanguages: {
            name: "Session.getAvailableLanguages",
            Request: function() {},
            Response: {}
        },
        getOutOfOffice: {
            name: "Session.getOutOfOffice",
            Request: function() {},
            Response: {}
        },
        getQuotaInformation: {
            name: "Session.getQuotaInformation",
            Request: function() {},
            Response: {}
        },
        getSettings: {
            name: "Session.getSettings",
            input: {
                query: "query"
            },
            output: {
                settings: "settings"
            },
            Request: function() {},
            Response: {}
        },
        getSpamSettings: {
            name: "Session.getSpamSettings",
            Request: function() {},
            Response: {}
        },
        getUserVoiceUrl: {
            name: "Session.getUserVoiceUrl",
            Request: function() {},
            Response: {}
        },
        login: {
            name: "Session.login",
            input: {
                userName: "userName",
                password: "password",
                application: "application"
            },
            output: {
                token: "token"
            },
            Request: function() {},
            Response: {}
        },
        logout: {
            name: "Session.logout",
            Request: function() {},
            Response: {}
        },
        setOutOfOffice: {
            name: "Session.setOutOfOffice",
            input: {
                settings: "settings"
            },
            Request: function() {}
        },
        setPassword: {
            name: "Session.setPassword",
            input: {
                currentPassword: "currentPassword",
                newPassword: "newPassword"
            },
            Request: function() {}
        },
        setSettings: {
            name: "Session.setSettings",
            input: {
                settings: "settings"
            },
            Request: function() {}
        },
        setSpamSettings: {
            name: "Session.setSpamSettings",
            input: {
                settings: "settings"
            },
            Request: function() {}
        },
        setUserInfo: {
            name: "Session.setUserInfo",
            input: {
                userDetails: "userDetails"
            },
            Request: function() {}
        },
        whoAmI: {
            name: "Session.whoAmI",
            Request: function() {},
            Response: {}
        },
        getMobileDeviceList: {
            name: "Session.getMobileDeviceList",
            input: {
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        removeMobileDevice: {
            name: "Session.removeMobileDevice",
            input: {
                deviceId: "deviceId"
            },
            Request: function() {}
        },
        wipeMobileDevice: {
            name: "Session.wipeMobileDevice",
            input: {
                deviceId: "deviceId",
                password: "password"
            },
            Request: function() {}
        },
        cancelWipeMobileDevice: {
            name: "Session.cancelWipeMobileDevice",
            input: {
                deviceId: "deviceId"
            },
            Request: function() {}
        },
        getSignatureImageList: {
            name: "Session.getSignatureImageList",
            Request: function() {},
            Response: {}
        },
        addSignatureImage: {
            name: "Session.addSignatureImage",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        removeSignatureImage: {
            name: "Session.removeSignatureImage",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Session.Def.canUserChangePassword.Response.prototype = {
    getIsEligible: function() {
        return this.isEligible;
    }
};

kerio.api.Session.Def.getAvailableTimeZones.Response.prototype = {
    getZones: function() {
        return this.zones;
    }
};

kerio.api.Session.Def.getAvailableTimeZonesIncludeUnixZones.Response.prototype = {
    getZones: function() {
        return this.zones;
    }
};

kerio.api.Session.Def.getAvailableLanguages.Response.prototype = {
    getLanguages: function() {
        kerio.api.applyType(this.languages, "LangDescription");
        return this.languages;
    }
};

kerio.api.Session.Def.getOutOfOffice.Response.prototype = {
    getSettings: function() {
        kerio.api.applyType(this.settings, "OutOfOfficeSettings");
        return this.settings;
    }
};

kerio.api.Session.Def.getQuotaInformation.Response.prototype = {
    getQuotaInfo: function() {
        kerio.api.applyType(this.quotaInfo, "QuotaInfo");
        return this.quotaInfo;
    }
};

kerio.api.Session.Def.getSettings.Response.prototype = {
    getSettings: function() {
        return this.settings;
    }
};

kerio.api.Session.Def.getSpamSettings.Response.prototype = {
    getSettings: function() {
        kerio.api.applyType(this.settings, "SpamSettings");
        return this.settings;
    }
};

kerio.api.Session.Def.getUserVoiceUrl.Response.prototype = {
    getAccessUrl: function() {
        return this.accessUrl;
    }
};

kerio.api.Session.Def.login.Response.prototype = {
    getToken: function() {
        return this.token;
    }
};

kerio.api.Session.Def.logout.Response.prototype = {
    getRedirectUrl: function() {
        return this.redirectUrl;
    }
};

kerio.api.Session.Def.whoAmI.Response.prototype = {
    getUserDetails: function() {
        kerio.api.applyType(this.userDetails, "UserInfo");
        return this.userDetails;
    }
};

kerio.api.Session.Def.getMobileDeviceList.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "MobileDevice");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Session.Def.getSignatureImageList.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Image");
        return this.list;
    }
};

kerio.api.Session.Def.addSignatureImage.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "Image");
        return this.result;
    }
};

kerio.api.Session.Def.removeSignatureImage.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Session.Def.canUserChangePassword.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.canUserChangePassword(e);
    }
};

kerio.api.Session.Def.getAvailableTimeZones.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getAvailableTimeZones(e);
    }
};

kerio.api.Session.Def.getAvailableTimeZonesIncludeUnixZones.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getAvailableTimeZonesIncludeUnixZones(e);
    }
};

kerio.api.Session.Def.getAvailableLanguages.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getAvailableLanguages(e);
    }
};

kerio.api.Session.Def.getOutOfOffice.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getOutOfOffice(e);
    }
};

kerio.api.Session.Def.getQuotaInformation.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getQuotaInformation(e);
    }
};

kerio.api.Session.Def.getSettings.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getSettings(this, e);
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Session.Def.getSpamSettings.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getSpamSettings(e);
    }
};

kerio.api.Session.Def.getUserVoiceUrl.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getUserVoiceUrl(e);
    }
};

kerio.api.Session.Def.login.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.login(this, e);
    },
    setUserName: function(e) {
        this.userName = e;
    },
    setPassword: function(e) {
        this.password = e;
    },
    setApplication: function(e) {
        this.application = e;
    }
};

kerio.api.Session.Def.logout.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.logout(e);
    }
};

kerio.api.Session.Def.setOutOfOffice.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.setOutOfOffice(this, e);
    },
    setSettings: function(e) {
        this.settings = e;
    }
};

kerio.api.Session.Def.setPassword.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.setPassword(this, e);
    },
    setCurrentPassword: function(e) {
        this.currentPassword = e;
    },
    setNewPassword: function(e) {
        this.newPassword = e;
    }
};

kerio.api.Session.Def.setSettings.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.setSettings(this, e);
    },
    setSettings: function(e) {
        this.settings = e;
    }
};

kerio.api.Session.Def.setSpamSettings.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.setSpamSettings(this, e);
    },
    setSettings: function(e) {
        this.settings = e;
    }
};

kerio.api.Session.Def.setUserInfo.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.setUserInfo(this, e);
    },
    setUserDetails: function(e) {
        this.userDetails = e;
    }
};

kerio.api.Session.Def.whoAmI.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.whoAmI(e);
    }
};

kerio.api.Session.Def.getMobileDeviceList.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getMobileDeviceList(this, e);
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Session.Def.removeMobileDevice.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.removeMobileDevice(this, e);
    },
    setDeviceId: function(e) {
        this.deviceId = e;
    }
};

kerio.api.Session.Def.wipeMobileDevice.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.wipeMobileDevice(this, e);
    },
    setDeviceId: function(e) {
        this.deviceId = e;
    },
    setPassword: function(e) {
        this.password = e;
    }
};

kerio.api.Session.Def.cancelWipeMobileDevice.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.cancelWipeMobileDevice(this, e);
    },
    setDeviceId: function(e) {
        this.deviceId = e;
    }
};

kerio.api.Session.Def.getSignatureImageList.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.getSignatureImageList(e);
    }
};

kerio.api.Session.Def.addSignatureImage.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.addSignatureImage(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Session.Def.removeSignatureImage.Request.prototype = {
    send: function(e) {
        return kerio.api.Session.removeSignatureImage(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

if (!window.kerio.api.enums.calendars) {
    window.kerio.api.enums.calendars = {
        SearchFields: {}
    };
}

kerio.api.enums.calendars.FreeBusyStatus = {
    Busy: "Busy",
    Tentative: "Tentative",
    Free: "Free",
    OutOfOffice: "OutOfOffice",
    NotAvailable: "NotAvailable"
};

kerio.api.enums.calendars.EventLabel = {
    None: "None",
    Important: "Important",
    Business: "Business",
    Personal: "Personal",
    Vacation: "Vacation",
    MustAttend: "MustAttend",
    TravelRequired: "TravelRequired",
    NeedsPreparation: "NeedsPreparation",
    BirthDay: "BirthDay",
    Anniversary: "Anniversary",
    PhoneCall: "PhoneCall"
};

kerio.api.enums.calendars.AttendeeRole = {
    RoleOrganizer: "RoleOrganizer",
    RoleRequiredAttendee: "RoleRequiredAttendee",
    RoleOptionalAttendee: "RoleOptionalAttendee",
    RoleRoom: "RoleRoom",
    RoleEquipment: "RoleEquipment"
};

kerio.api.enums.calendars.PartStatus = {
    PartNotResponded: "PartNotResponded",
    PartAccepted: "PartAccepted",
    PartDeclined: "PartDeclined",
    PartDelegated: "PartDelegated",
    PartTentative: "PartTentative"
};

kerio.api.type.PartStatusResponse = function() {};

kerio.api.type.PartStatusResponse.prototype = {
    getStatus: function() {
        return this.status;
    },
    setStatus: function(e) {
        this.status = e;
    },
    getMessage: function() {
        return this.message;
    },
    setMessage: function(e) {
        this.message = e;
    }
};

kerio.api.type.PartStatusResponse.fields = {
    ALL_FIELDS: [ "status", "message" ],
    status: "status",
    message: "message"
};

kerio.api.type.Attendee = function() {};

kerio.api.type.Attendee.prototype = {
    getDisplayName: function() {
        return this.displayName;
    },
    setDisplayName: function(e) {
        this.displayName = e;
    },
    getEmailAddress: function() {
        return this.emailAddress;
    },
    setEmailAddress: function(e) {
        this.emailAddress = e;
    },
    getRole: function() {
        return this.role;
    },
    setRole: function(e) {
        this.role = e;
    },
    getIsNotified: function() {
        return this.isNotified;
    },
    setIsNotified: function(e) {
        this.isNotified = e;
    },
    getPartStatus: function() {
        return this.partStatus;
    },
    setPartStatus: function(e) {
        this.partStatus = e;
    }
};

kerio.api.type.Attendee.fields = {
    ALL_FIELDS: [ "displayName", "emailAddress", "role", "isNotified", "partStatus" ],
    displayName: "displayName",
    emailAddress: "emailAddress",
    role: "role",
    isNotified: "isNotified",
    partStatus: "partStatus"
};

kerio.api.enums.calendars.ReminderType = {
    ReminderRelative: "ReminderRelative",
    ReminderAbsolute: "ReminderAbsolute"
};

kerio.api.type.Reminder = function() {};

kerio.api.type.Reminder.prototype = {
    getIsSet: function() {
        return this.isSet;
    },
    setIsSet: function(e) {
        this.isSet = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getMinutesBeforeStart: function() {
        return this.minutesBeforeStart;
    },
    setMinutesBeforeStart: function(e) {
        this.minutesBeforeStart = e;
    },
    getDate: function() {
        return this.date;
    },
    setDate: function(e) {
        this.date = e;
    }
};

kerio.api.type.Reminder.fields = {
    ALL_FIELDS: [ "isSet", "type", "minutesBeforeStart", "date" ],
    isSet: "isSet",
    type: "type",
    minutesBeforeStart: "minutesBeforeStart",
    date: "date"
};

kerio.api.enums.calendars.FrequencyType = {
    Daily: "Daily",
    Weekly: "Weekly",
    Monthly: "Monthly",
    Yearly: "Yearly"
};

kerio.api.enums.calendars.EndByType = {
    ByRecurrenceNever: "ByRecurrenceNever",
    ByRecurrenceDate: "ByRecurrenceDate"
};

kerio.api.type.EndBy = function() {};

kerio.api.type.EndBy.prototype = {
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getDate: function() {
        return this.date;
    },
    setDate: function(e) {
        this.date = e;
    }
};

kerio.api.type.EndBy.fields = {
    ALL_FIELDS: [ "type", "date" ],
    type: "type",
    date: "date"
};

kerio.api.type.PreciseBy = function() {};

kerio.api.type.PreciseBy.prototype = {
    getByDay: function() {
        return this.byDay;
    },
    setByDay: function(e) {
        this.byDay = e;
    },
    getByMonthDay: function() {
        return this.byMonthDay;
    },
    setByMonthDay: function(e) {
        this.byMonthDay = e;
    },
    getByMonth: function() {
        return this.byMonth;
    },
    setByMonth: function(e) {
        this.byMonth = e;
    },
    getByPosition: function() {
        return this.byPosition;
    },
    setByPosition: function(e) {
        this.byPosition = e;
    },
    getByInterval: function() {
        return this.byInterval;
    },
    setByInterval: function(e) {
        this.byInterval = e;
    }
};

kerio.api.type.PreciseBy.fields = {
    ALL_FIELDS: [ "byDay", "byMonthDay", "byMonth", "byPosition", "byInterval" ],
    byDay: "byDay",
    byMonthDay: "byMonthDay",
    byMonth: "byMonth",
    byPosition: "byPosition",
    byInterval: "byInterval"
};

kerio.api.type.RecurrenceRule = function() {};

kerio.api.type.RecurrenceRule.prototype = {
    getIsSet: function() {
        return this.isSet;
    },
    setIsSet: function(e) {
        this.isSet = e;
    },
    getFrequency: function() {
        return this.frequency;
    },
    setFrequency: function(e) {
        this.frequency = e;
    },
    getEndBy: function() {
        kerio.api.applyType(this.endBy, "EndBy");
        return this.endBy;
    },
    setEndBy: function(e) {
        this.endBy = e;
    },
    getPreciseBy: function() {
        kerio.api.applyType(this.preciseBy, "PreciseBy");
        return this.preciseBy;
    },
    setPreciseBy: function(e) {
        this.preciseBy = e;
    }
};

kerio.api.type.RecurrenceRule.fields = {
    ALL_FIELDS: [ "isSet", "frequency", "endBy", "preciseBy" ],
    isSet: "isSet",
    frequency: "frequency",
    endBy: "endBy",
    preciseBy: "preciseBy"
};

kerio.api.enums.calendars.EventAccess = {
    EAccessCreator: "EAccessCreator",
    EAccessInvitee: "EAccessInvitee",
    EAccessReadOnly: "EAccessReadOnly"
};

if (!window.kerio.api.enums.alarms) {
    window.kerio.api.enums.alarms = {
        SearchFields: {}
    };
}

kerio.api.type.Alarm = function() {};

kerio.api.type.Alarm.prototype = {
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getItemId: function() {
        return this.itemId;
    },
    setItemId: function(e) {
        this.itemId = e;
    },
    getBaseId: function() {
        return this.baseId;
    },
    setBaseId: function(e) {
        this.baseId = e;
    },
    getSummary: function() {
        return this.summary;
    },
    setSummary: function(e) {
        this.summary = e;
    },
    getLocation: function() {
        return this.location;
    },
    setLocation: function(e) {
        this.location = e;
    },
    getStart: function() {
        return this.start;
    },
    setStart: function(e) {
        this.start = e;
    },
    getEnd: function() {
        return this.end;
    },
    setEnd: function(e) {
        this.end = e;
    },
    getDue: function() {
        return this.due;
    },
    setDue: function(e) {
        this.due = e;
    },
    getIsAllDay: function() {
        return this.isAllDay;
    },
    setIsAllDay: function(e) {
        this.isAllDay = e;
    },
    getReminderTime: function() {
        return this.reminderTime;
    },
    setReminderTime: function(e) {
        this.reminderTime = e;
    }
};

kerio.api.type.Alarm.fields = {
    ALL_FIELDS: [ "type", "itemId", "baseId", "summary", "location", "start", "end", "due", "isAllDay", "reminderTime" ],
    type: "type",
    itemId: "itemId",
    baseId: "baseId",
    summary: "summary",
    location: "location",
    start: "start",
    end: "end",
    due: "due",
    isAllDay: "isAllDay",
    reminderTime: "reminderTime"
};

kerio.api.Alarms = {
    dismiss: function(e, t) {
        return kerio.api.callMethod(this.Def.dismiss.name, e, t, this.Def.dismiss.Response);
    },
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    Def: {
        $name: "Alarms",
        dismiss: {
            name: "Alarms.dismiss",
            input: {
                itemIds: "itemIds"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        get: {
            name: "Alarms.get",
            input: {
                since: "since",
                until: "until"
            },
            output: {
                list: "list"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Alarms.set",
            input: {
                nextTime: "nextTime",
                itemIds: "itemIds"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Alarms.Def.dismiss.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Alarms.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Alarm");
        return this.list;
    }
};

kerio.api.Alarms.Def.set.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Alarms.Def.dismiss.Request.prototype = {
    send: function(e) {
        return kerio.api.Alarms.dismiss(this, e);
    },
    setItemIds: function(e) {
        this.itemIds = e;
    }
};

kerio.api.Alarms.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Alarms.get(this, e);
    },
    setSince: function(e) {
        this.since = e;
    },
    setUntil: function(e) {
        this.until = e;
    }
};

kerio.api.Alarms.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Alarms.set(this, e);
    },
    setNextTime: function(e) {
        this.nextTime = e;
    },
    setItemIds: function(e) {
        this.itemIds = e;
    }
};

if (!window.kerio.api.enums.events) {
    window.kerio.api.enums.events = {
        SearchFields: {}
    };
}

kerio.api.type.Attachment = function() {};

kerio.api.type.Attachment.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getUrl: function() {
        return this.url;
    },
    setUrl: function(e) {
        this.url = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getContentType: function() {
        return this.contentType;
    },
    setContentType: function(e) {
        this.contentType = e;
    },
    getContentId: function() {
        return this.contentId;
    },
    setContentId: function(e) {
        this.contentId = e;
    },
    getSize: function() {
        return this.size;
    },
    setSize: function(e) {
        this.size = e;
    }
};

kerio.api.type.Attachment.fields = {
    ALL_FIELDS: [ "id", "url", "name", "contentType", "contentId", "size" ],
    id: "id",
    url: "url",
    name: "name",
    contentType: "contentType",
    contentId: "contentId",
    size: "size"
};

kerio.api.type.Event = function() {};

kerio.api.type.Event.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getFolderId: function() {
        return this.folderId;
    },
    setFolderId: function(e) {
        this.folderId = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    },
    getAccess: function() {
        return this.access;
    },
    setAccess: function(e) {
        this.access = e;
    },
    getSummary: function() {
        return this.summary;
    },
    setSummary: function(e) {
        this.summary = e;
    },
    getLocation: function() {
        return this.location;
    },
    setLocation: function(e) {
        this.location = e;
    },
    getDescription: function() {
        return this.description;
    },
    setDescription: function(e) {
        this.description = e;
    },
    getLabel: function() {
        return this.label;
    },
    setLabel: function(e) {
        this.label = e;
    },
    getCategories: function() {
        return this.categories;
    },
    setCategories: function(e) {
        this.categories = e;
    },
    getStart: function() {
        return this.start;
    },
    setStart: function(e) {
        this.start = e;
    },
    getEnd: function() {
        return this.end;
    },
    setEnd: function(e) {
        this.end = e;
    },
    getTravelMinutes: function() {
        return this.travelMinutes;
    },
    setTravelMinutes: function(e) {
        this.travelMinutes = e;
    },
    getFreeBusy: function() {
        return this.freeBusy;
    },
    setFreeBusy: function(e) {
        this.freeBusy = e;
    },
    getIsPrivate: function() {
        return this.isPrivate;
    },
    setIsPrivate: function(e) {
        this.isPrivate = e;
    },
    getIsAllDay: function() {
        return this.isAllDay;
    },
    setIsAllDay: function(e) {
        this.isAllDay = e;
    },
    getPriority: function() {
        return this.priority;
    },
    setPriority: function(e) {
        this.priority = e;
    },
    getRule: function() {
        kerio.api.applyType(this.rule, "RecurrenceRule");
        return this.rule;
    },
    setRule: function(e) {
        this.rule = e;
    },
    getAttendees: function() {
        kerio.api.applyType(this.attendees, "Attendee");
        return this.attendees;
    },
    setAttendees: function(e) {
        this.attendees = e;
    },
    getReminder: function() {
        kerio.api.applyType(this.reminder, "Reminder");
        return this.reminder;
    },
    setReminder: function(e) {
        this.reminder = e;
    },
    getIsCancelled: function() {
        return this.isCancelled;
    },
    setIsCancelled: function(e) {
        this.isCancelled = e;
    },
    getAttachments: function() {
        kerio.api.applyType(this.attachments, "Attachment");
        return this.attachments;
    },
    setAttachments: function(e) {
        this.attachments = e;
    }
};

kerio.api.type.Event.fields = {
    ALL_FIELDS: [ "id", "folderId", "watermark", "access", "summary", "location", "description", "label", "categories", "start", "end", "travelMinutes", "freeBusy", "isPrivate", "isAllDay", "priority", "rule", "attendees", "reminder", "isCancelled", "attachments" ],
    id: "id",
    folderId: "folderId",
    watermark: "watermark",
    access: "access",
    summary: "summary",
    location: "location",
    description: "description",
    label: "label",
    categories: "categories",
    start: "start",
    end: "end",
    travelMinutes: "travelMinutes",
    freeBusy: "freeBusy",
    isPrivate: "isPrivate",
    isAllDay: "isAllDay",
    priority: "priority",
    rule: "rule",
    attendees: "attendees",
    reminder: "reminder",
    isCancelled: "isCancelled",
    attachments: "attachments"
};

kerio.api.enums.events.EventUpdateType = {
    EUpdateRequest: "EUpdateRequest",
    EUpdateReply: "EUpdateReply",
    EUpdateCancel: "EUpdateCancel"
};

kerio.api.enums.events.EventActionType = {
    EActionCreate: "EActionCreate",
    EActionChangedTime: "EActionChangedTime",
    EActionChangedSummary: "EActionChangedSummary",
    EActionChangedLocation: "EActionChangedLocation",
    EActionChangedDescription: "EActionChangedDescription"
};

kerio.api.type.EventUpdate = function() {};

kerio.api.type.EventUpdate.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getEventId: function() {
        return this.eventId;
    },
    setEventId: function(e) {
        this.eventId = e;
    },
    getEventFolderId: function() {
        return this.eventFolderId;
    },
    setEventFolderId: function(e) {
        this.eventFolderId = e;
    },
    getOccurrenceId: function() {
        return this.occurrenceId;
    },
    setOccurrenceId: function(e) {
        this.occurrenceId = e;
    },
    getIsException: function() {
        return this.isException;
    },
    setIsException: function(e) {
        this.isException = e;
    },
    getSeqNumber: function() {
        return this.seqNumber;
    },
    setSeqNumber: function(e) {
        this.seqNumber = e;
    },
    getIsObsolete: function() {
        return this.isObsolete;
    },
    setIsObsolete: function(e) {
        this.isObsolete = e;
    },
    getDeliveryTime: function() {
        return this.deliveryTime;
    },
    setDeliveryTime: function(e) {
        this.deliveryTime = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getSummary: function() {
        return this.summary;
    },
    setSummary: function(e) {
        this.summary = e;
    },
    getLocation: function() {
        return this.location;
    },
    setLocation: function(e) {
        this.location = e;
    },
    getStart: function() {
        return this.start;
    },
    setStart: function(e) {
        this.start = e;
    },
    getEnd: function() {
        return this.end;
    },
    setEnd: function(e) {
        this.end = e;
    },
    getTotalEnd: function() {
        return this.totalEnd;
    },
    setTotalEnd: function(e) {
        this.totalEnd = e;
    },
    getDescription: function() {
        return this.description;
    },
    setDescription: function(e) {
        this.description = e;
    },
    getAttendee: function() {
        kerio.api.applyType(this.attendee, "Attendee");
        return this.attendee;
    },
    setAttendee: function(e) {
        this.attendee = e;
    },
    getActions: function() {
        kerio.api.applyType(this.actions, "EventActionType");
        return this.actions;
    },
    setActions: function(e) {
        this.actions = e;
    }
};

kerio.api.type.EventUpdate.fields = {
    ALL_FIELDS: [ "id", "eventId", "eventFolderId", "occurrenceId", "isException", "seqNumber", "isObsolete", "deliveryTime", "type", "summary", "location", "start", "end", "totalEnd", "description", "attendee", "actions" ],
    id: "id",
    eventId: "eventId",
    eventFolderId: "eventFolderId",
    occurrenceId: "occurrenceId",
    isException: "isException",
    seqNumber: "seqNumber",
    isObsolete: "isObsolete",
    deliveryTime: "deliveryTime",
    type: "type",
    summary: "summary",
    location: "location",
    start: "start",
    end: "end",
    totalEnd: "totalEnd",
    description: "description",
    attendee: "attendee",
    actions: "actions"
};

kerio.api.enums.events.SearchFields.QUICKSEARCH = "QUICKSEARCH";

kerio.api.enums.events.SearchFields.uid = "uid";

kerio.api.enums.events.SearchFields.summary = "summary";

kerio.api.enums.events.SearchFields.location = "location";

kerio.api.enums.events.SearchFields.start = "start";

kerio.api.enums.events.SearchFields.end = "end";

kerio.api.enums.events.SearchFields.reminder = "reminder";

kerio.api.enums.events.SearchFields.attendees = "attendees";

kerio.api.enums.events.SearchFields.organizer = "organizer";

kerio.api.enums.events.SearchFields.isAllDay = "isAllDay";

kerio.api.enums.events.SearchFields.hasReminder = "hasReminder";

kerio.api.enums.events.SearchFields.rule = "rule";

kerio.api.Events = {
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    getById: function(e, t) {
        return kerio.api.callMethod(this.Def.getById.name, e, t, this.Def.getById.Response);
    },
    getEventUpdates: function(e, t) {
        return kerio.api.callMethod(this.Def.getEventUpdates.name, e, t, this.Def.getEventUpdates.Response);
    },
    getEventUpdateList: function(e) {
        return kerio.api.callMethod(this.Def.getEventUpdateList.name, {}, e, this.Def.getEventUpdateList.Response);
    },
    getSharedEventUpdateList: function(e, t) {
        return kerio.api.callMethod(this.Def.getSharedEventUpdateList.name, e, t, this.Def.getSharedEventUpdateList.Response);
    },
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    removeEventUpdates: function(e, t) {
        return kerio.api.callMethod(this.Def.removeEventUpdates.name, e, t, this.Def.removeEventUpdates.Response);
    },
    copy: function(e, t) {
        return kerio.api.callMethod(this.Def.copy.name, e, t, this.Def.copy.Response);
    },
    create: function(e, t) {
        return kerio.api.callMethod(this.Def.create.name, e, t, this.Def.create.Response);
    },
    createFromAttachment: function(e, t) {
        return kerio.api.callMethod(this.Def.createFromAttachment.name, e, t, this.Def.createFromAttachment.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    move: function(e, t) {
        return kerio.api.callMethod(this.Def.move.name, e, t, this.Def.move.Response);
    },
    Def: {
        $name: "Events",
        get: {
            name: "Events.get",
            input: {
                ids: "ids",
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getById: {
            name: "Events.getById",
            input: {
                id: "id"
            },
            output: {
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        getEventUpdates: {
            name: "Events.getEventUpdates",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors",
                eventUpdates: "eventUpdates"
            },
            Request: function() {},
            Response: {}
        },
        getEventUpdateList: {
            name: "Events.getEventUpdateList",
            Request: function() {},
            Response: {}
        },
        getSharedEventUpdateList: {
            name: "Events.getSharedEventUpdateList",
            input: {
                mailboxIds: "mailboxIds"
            },
            output: {
                errors: "errors",
                eventUpdates: "eventUpdates"
            },
            Request: function() {},
            Response: {}
        },
        remove: {
            name: "Events.remove",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        removeEventUpdates: {
            name: "Events.removeEventUpdates",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        copy: {
            name: "Events.copy",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        create: {
            name: "Events.create",
            input: {
                events: "events"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        createFromAttachment: {
            name: "Events.createFromAttachment",
            input: {
                attachmentId: "attachmentId"
            },
            output: {
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Events.set",
            input: {
                events: "events"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        move: {
            name: "Events.move",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Events.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Event");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Events.Def.getById.Response.prototype = {
    getResult: function() {
        kerio.api.applyType(this.result, "Event");
        return this.result;
    }
};

kerio.api.Events.Def.getEventUpdates.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getEventUpdates: function() {
        kerio.api.applyType(this.eventUpdates, "EventUpdate");
        return this.eventUpdates;
    }
};

kerio.api.Events.Def.getEventUpdateList.Response.prototype = {
    getEventUpdates: function() {
        kerio.api.applyType(this.eventUpdates, "EventUpdate");
        return this.eventUpdates;
    }
};

kerio.api.Events.Def.getSharedEventUpdateList.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getEventUpdates: function() {
        kerio.api.applyType(this.eventUpdates, "EventUpdate");
        return this.eventUpdates;
    }
};

kerio.api.Events.Def.remove.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Events.Def.removeEventUpdates.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Events.Def.copy.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Events.Def.create.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Events.Def.createFromAttachment.Response.prototype = {
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Events.Def.set.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "SetResult");
        return this.result;
    }
};

kerio.api.Events.Def.move.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Events.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.get(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Events.Def.getById.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.getById(this, e);
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Events.Def.getEventUpdates.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.getEventUpdates(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Events.Def.getEventUpdateList.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.getEventUpdateList(e);
    }
};

kerio.api.Events.Def.getSharedEventUpdateList.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.getSharedEventUpdateList(this, e);
    },
    setMailboxIds: function(e) {
        this.mailboxIds = e;
    }
};

kerio.api.Events.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.remove(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Events.Def.removeEventUpdates.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.removeEventUpdates(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Events.Def.copy.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.copy(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

kerio.api.Events.Def.create.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.create(this, e);
    },
    setEvents: function(e) {
        this.events = e;
    }
};

kerio.api.Events.Def.createFromAttachment.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.createFromAttachment(this, e);
    },
    setAttachmentId: function(e) {
        this.attachmentId = e;
    }
};

kerio.api.Events.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.set(this, e);
    },
    setEvents: function(e) {
        this.events = e;
    }
};

kerio.api.Events.Def.move.Request.prototype = {
    send: function(e) {
        return kerio.api.Events.move(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

if (!window.kerio.api.enums.occurrences) {
    window.kerio.api.enums.occurrences = {
        SearchFields: {}
    };
}

kerio.api.type.Attachment = function() {};

kerio.api.type.Attachment.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getUrl: function() {
        return this.url;
    },
    setUrl: function(e) {
        this.url = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getContentType: function() {
        return this.contentType;
    },
    setContentType: function(e) {
        this.contentType = e;
    },
    getContentId: function() {
        return this.contentId;
    },
    setContentId: function(e) {
        this.contentId = e;
    },
    getSize: function() {
        return this.size;
    },
    setSize: function(e) {
        this.size = e;
    }
};

kerio.api.type.Attachment.fields = {
    ALL_FIELDS: [ "id", "url", "name", "contentType", "contentId", "size" ],
    id: "id",
    url: "url",
    name: "name",
    contentType: "contentType",
    contentId: "contentId",
    size: "size"
};

kerio.api.enums.occurrences.ModificationType = {
    modifyAll: "modifyAll",
    modifyThis: "modifyThis",
    modifyAllFollowing: "modifyAllFollowing",
    modifyMasterEvent: "modifyMasterEvent"
};

kerio.api.type.Occurrence = function() {};

kerio.api.type.Occurrence.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getEventId: function() {
        return this.eventId;
    },
    setEventId: function(e) {
        this.eventId = e;
    },
    getFolderId: function() {
        return this.folderId;
    },
    setFolderId: function(e) {
        this.folderId = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    },
    getAccess: function() {
        return this.access;
    },
    setAccess: function(e) {
        this.access = e;
    },
    getSummary: function() {
        return this.summary;
    },
    setSummary: function(e) {
        this.summary = e;
    },
    getLocation: function() {
        return this.location;
    },
    setLocation: function(e) {
        this.location = e;
    },
    getDescription: function() {
        return this.description;
    },
    setDescription: function(e) {
        this.description = e;
    },
    getLabel: function() {
        return this.label;
    },
    setLabel: function(e) {
        this.label = e;
    },
    getCategories: function() {
        return this.categories;
    },
    setCategories: function(e) {
        this.categories = e;
    },
    getStart: function() {
        return this.start;
    },
    setStart: function(e) {
        this.start = e;
    },
    getEnd: function() {
        return this.end;
    },
    setEnd: function(e) {
        this.end = e;
    },
    getTravelMinutes: function() {
        return this.travelMinutes;
    },
    setTravelMinutes: function(e) {
        this.travelMinutes = e;
    },
    getFreeBusy: function() {
        return this.freeBusy;
    },
    setFreeBusy: function(e) {
        this.freeBusy = e;
    },
    getIsPrivate: function() {
        return this.isPrivate;
    },
    setIsPrivate: function(e) {
        this.isPrivate = e;
    },
    getIsAllDay: function() {
        return this.isAllDay;
    },
    setIsAllDay: function(e) {
        this.isAllDay = e;
    },
    getPriority: function() {
        return this.priority;
    },
    setPriority: function(e) {
        this.priority = e;
    },
    getRule: function() {
        kerio.api.applyType(this.rule, "RecurrenceRule");
        return this.rule;
    },
    setRule: function(e) {
        this.rule = e;
    },
    getAttendees: function() {
        kerio.api.applyType(this.attendees, "Attendee");
        return this.attendees;
    },
    setAttendees: function(e) {
        this.attendees = e;
    },
    getReminder: function() {
        kerio.api.applyType(this.reminder, "Reminder");
        return this.reminder;
    },
    setReminder: function(e) {
        this.reminder = e;
    },
    getIsException: function() {
        return this.isException;
    },
    setIsException: function(e) {
        this.isException = e;
    },
    getHasReminder: function() {
        return this.hasReminder;
    },
    setHasReminder: function(e) {
        this.hasReminder = e;
    },
    getIsRecurrent: function() {
        return this.isRecurrent;
    },
    setIsRecurrent: function(e) {
        this.isRecurrent = e;
    },
    getIsCancelled: function() {
        return this.isCancelled;
    },
    setIsCancelled: function(e) {
        this.isCancelled = e;
    },
    getSeqNumber: function() {
        return this.seqNumber;
    },
    setSeqNumber: function(e) {
        this.seqNumber = e;
    },
    getModification: function() {
        return this.modification;
    },
    setModification: function(e) {
        this.modification = e;
    },
    getAttachments: function() {
        kerio.api.applyType(this.attachments, "Attachment");
        return this.attachments;
    },
    setAttachments: function(e) {
        this.attachments = e;
    }
};

kerio.api.type.Occurrence.fields = {
    ALL_FIELDS: [ "id", "eventId", "folderId", "watermark", "access", "summary", "location", "description", "label", "categories", "start", "end", "travelMinutes", "freeBusy", "isPrivate", "isAllDay", "priority", "rule", "attendees", "reminder", "isException", "hasReminder", "isRecurrent", "isCancelled", "seqNumber", "modification", "attachments" ],
    id: "id",
    eventId: "eventId",
    folderId: "folderId",
    watermark: "watermark",
    access: "access",
    summary: "summary",
    location: "location",
    description: "description",
    label: "label",
    categories: "categories",
    start: "start",
    end: "end",
    travelMinutes: "travelMinutes",
    freeBusy: "freeBusy",
    isPrivate: "isPrivate",
    isAllDay: "isAllDay",
    priority: "priority",
    rule: "rule",
    attendees: "attendees",
    reminder: "reminder",
    isException: "isException",
    hasReminder: "hasReminder",
    isRecurrent: "isRecurrent",
    isCancelled: "isCancelled",
    seqNumber: "seqNumber",
    modification: "modification",
    attachments: "attachments"
};

kerio.api.enums.occurrences.SearchFields.QUICKSEARCH = "QUICKSEARCH";

kerio.api.enums.occurrences.SearchFields.uid = "uid";

kerio.api.enums.occurrences.SearchFields.summary = "summary";

kerio.api.enums.occurrences.SearchFields.location = "location";

kerio.api.enums.occurrences.SearchFields.start = "start";

kerio.api.enums.occurrences.SearchFields.end = "end";

kerio.api.enums.occurrences.SearchFields.reminder = "reminder";

kerio.api.enums.occurrences.SearchFields.attendees = "attendees";

kerio.api.enums.occurrences.SearchFields.organizer = "organizer";

kerio.api.enums.occurrences.SearchFields.isAllDay = "isAllDay";

kerio.api.enums.occurrences.SearchFields.hasReminder = "hasReminder";

kerio.api.enums.occurrences.SearchFields.rule = "rule";

kerio.api.enums.occurrences.SearchFields.searchTime = "searchTime";

kerio.api.Occurrences = {
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    getById: function(e, t) {
        return kerio.api.callMethod(this.Def.getById.name, e, t, this.Def.getById.Response);
    },
    getFromAttachment: function(e, t) {
        return kerio.api.callMethod(this.Def.getFromAttachment.name, e, t, this.Def.getFromAttachment.Response);
    },
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    setPartStatus: function(e, t) {
        return kerio.api.callMethod(this.Def.setPartStatus.name, e, t, this.Def.setPartStatus.Response);
    },
    Def: {
        $name: "Occurrences",
        get: {
            name: "Occurrences.get",
            input: {
                folderIds: "folderIds",
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getById: {
            name: "Occurrences.getById",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        getFromAttachment: {
            name: "Occurrences.getFromAttachment",
            input: {
                attachmentId: "attachmentId"
            },
            output: {
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        remove: {
            name: "Occurrences.remove",
            input: {
                occurrences: "occurrences"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Occurrences.set",
            input: {
                occurrences: "occurrences"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        setPartStatus: {
            name: "Occurrences.setPartStatus",
            input: {
                id: "id",
                response: "response"
            },
            Request: function() {}
        }
    }
};

kerio.api.Occurrences.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Occurrence");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Occurrences.Def.getById.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "Occurrence");
        return this.result;
    }
};

kerio.api.Occurrences.Def.getFromAttachment.Response.prototype = {
    getResult: function() {
        kerio.api.applyType(this.result, "Occurrence");
        return this.result;
    }
};

kerio.api.Occurrences.Def.remove.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Occurrences.Def.set.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "SetResult");
        return this.result;
    }
};

kerio.api.Occurrences.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Occurrences.get(this, e);
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Occurrences.Def.getById.Request.prototype = {
    send: function(e) {
        return kerio.api.Occurrences.getById(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Occurrences.Def.getFromAttachment.Request.prototype = {
    send: function(e) {
        return kerio.api.Occurrences.getFromAttachment(this, e);
    },
    setAttachmentId: function(e) {
        this.attachmentId = e;
    }
};

kerio.api.Occurrences.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Occurrences.remove(this, e);
    },
    setOccurrences: function(e) {
        this.occurrences = e;
    }
};

kerio.api.Occurrences.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Occurrences.set(this, e);
    },
    setOccurrences: function(e) {
        this.occurrences = e;
    }
};

kerio.api.Occurrences.Def.setPartStatus.Request.prototype = {
    send: function(e) {
        return kerio.api.Occurrences.setPartStatus(this, e);
    },
    setId: function(e) {
        this.id = e;
    },
    setResponse: function(e) {
        this.response = e;
    }
};

if (!window.kerio.api.enums.contacts) {
    window.kerio.api.enums.contacts = {
        SearchFields: {}
    };
}

kerio.api.enums.contacts.ContactType = {
    ctContact: "ctContact",
    ctDistributionList: "ctDistributionList"
};

kerio.api.type.Contact = function() {};

kerio.api.type.Contact.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getFolderId: function() {
        return this.folderId;
    },
    setFolderId: function(e) {
        this.folderId = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getCommonName: function() {
        return this.commonName;
    },
    setCommonName: function(e) {
        this.commonName = e;
    },
    getFirstName: function() {
        return this.firstName;
    },
    setFirstName: function(e) {
        this.firstName = e;
    },
    getMiddleName: function() {
        return this.middleName;
    },
    setMiddleName: function(e) {
        this.middleName = e;
    },
    getSurName: function() {
        return this.surName;
    },
    setSurName: function(e) {
        this.surName = e;
    },
    getTitleBefore: function() {
        return this.titleBefore;
    },
    setTitleBefore: function(e) {
        this.titleBefore = e;
    },
    getTitleAfter: function() {
        return this.titleAfter;
    },
    setTitleAfter: function(e) {
        this.titleAfter = e;
    },
    getNickName: function() {
        return this.nickName;
    },
    setNickName: function(e) {
        this.nickName = e;
    },
    getPhoneNumbers: function() {
        kerio.api.applyType(this.phoneNumbers, "PhoneNumber");
        return this.phoneNumbers;
    },
    setPhoneNumbers: function(e) {
        this.phoneNumbers = e;
    },
    getEmailAddresses: function() {
        kerio.api.applyType(this.emailAddresses, "EmailAddress");
        return this.emailAddresses;
    },
    setEmailAddresses: function(e) {
        this.emailAddresses = e;
    },
    getPostalAddresses: function() {
        kerio.api.applyType(this.postalAddresses, "PostalAddress");
        return this.postalAddresses;
    },
    setPostalAddresses: function(e) {
        this.postalAddresses = e;
    },
    getUrls: function() {
        kerio.api.applyType(this.urls, "Url");
        return this.urls;
    },
    setUrls: function(e) {
        this.urls = e;
    },
    getBirthDay: function() {
        return this.birthDay;
    },
    setBirthDay: function(e) {
        this.birthDay = e;
    },
    getAnniversary: function() {
        return this.anniversary;
    },
    setAnniversary: function(e) {
        this.anniversary = e;
    },
    getCompanyName: function() {
        return this.companyName;
    },
    setCompanyName: function(e) {
        this.companyName = e;
    },
    getDepartmentName: function() {
        return this.departmentName;
    },
    setDepartmentName: function(e) {
        this.departmentName = e;
    },
    getProfession: function() {
        return this.profession;
    },
    setProfession: function(e) {
        this.profession = e;
    },
    getManagerName: function() {
        return this.managerName;
    },
    setManagerName: function(e) {
        this.managerName = e;
    },
    getAssistantName: function() {
        return this.assistantName;
    },
    setAssistantName: function(e) {
        this.assistantName = e;
    },
    getComment: function() {
        return this.comment;
    },
    setComment: function(e) {
        this.comment = e;
    },
    getIMAddress: function() {
        return this.IMAddress;
    },
    setIMAddress: function(e) {
        this.IMAddress = e;
    },
    getPhoto: function() {
        kerio.api.applyType(this.photo, "PhotoAttachment");
        return this.photo;
    },
    setPhoto: function(e) {
        this.photo = e;
    },
    getCategories: function() {
        return this.categories;
    },
    setCategories: function(e) {
        this.categories = e;
    },
    getCertSourceId: function() {
        return this.certSourceId;
    },
    setCertSourceId: function(e) {
        this.certSourceId = e;
    },
    getIsGalContact: function() {
        return this.isGalContact;
    },
    setIsGalContact: function(e) {
        this.isGalContact = e;
    }
};

kerio.api.type.Contact.fields = {
    ALL_FIELDS: [ "id", "folderId", "watermark", "type", "commonName", "firstName", "middleName", "surName", "titleBefore", "titleAfter", "nickName", "phoneNumbers", "emailAddresses", "postalAddresses", "urls", "birthDay", "anniversary", "companyName", "departmentName", "profession", "managerName", "assistantName", "comment", "IMAddress", "photo", "categories", "certSourceId", "isGalContact" ],
    id: "id",
    folderId: "folderId",
    watermark: "watermark",
    type: "type",
    commonName: "commonName",
    firstName: "firstName",
    middleName: "middleName",
    surName: "surName",
    titleBefore: "titleBefore",
    titleAfter: "titleAfter",
    nickName: "nickName",
    phoneNumbers: "phoneNumbers",
    emailAddresses: "emailAddresses",
    postalAddresses: "postalAddresses",
    urls: "urls",
    birthDay: "birthDay",
    anniversary: "anniversary",
    companyName: "companyName",
    departmentName: "departmentName",
    profession: "profession",
    managerName: "managerName",
    assistantName: "assistantName",
    comment: "comment",
    IMAddress: "IMAddress",
    photo: "photo",
    categories: "categories",
    certSourceId: "certSourceId",
    isGalContact: "isGalContact"
};

kerio.api.enums.contacts.ResourceType = {
    ResourceRoom: "ResourceRoom",
    ResourceEquipment: "ResourceEquipment"
};

kerio.api.type.Resource = function() {};

kerio.api.type.Resource.prototype = {
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getAddress: function() {
        return this.address;
    },
    setAddress: function(e) {
        this.address = e;
    },
    getDescription: function() {
        return this.description;
    },
    setDescription: function(e) {
        this.description = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    }
};

kerio.api.type.Resource.fields = {
    ALL_FIELDS: [ "name", "address", "description", "type" ],
    name: "name",
    address: "address",
    description: "description",
    type: "type"
};

kerio.api.enums.contacts.SearchFields.QUICKSEARCH = "QUICKSEARCH";

kerio.api.enums.contacts.SearchFields.displayName = "displayName";

kerio.api.enums.contacts.SearchFields.firstName = "firstName";

kerio.api.enums.contacts.SearchFields.surName = "surName";

kerio.api.enums.contacts.SearchFields.middleName = "middleName";

kerio.api.enums.contacts.SearchFields.nickName = "nickName";

kerio.api.enums.contacts.SearchFields.company = "company";

kerio.api.enums.contacts.SearchFields.hasEmail = "hasEmail";

kerio.api.enums.contacts.SearchFields.email = "email";

kerio.api.enums.contacts.SearchFields.phone = "phone";

kerio.api.enums.contacts.SearchFields.category = "category";

kerio.api.enums.contacts.SearchFields.homeAddress = "homeAddress";

kerio.api.enums.contacts.SearchFields.otherAddress = "otherAddress";

kerio.api.enums.contacts.SearchFields.guid = "guid";

kerio.api.enums.contacts.SearchFields.uid = "uid";

kerio.api.enums.contacts.SearchFields.isDList = "isDList";

kerio.api.enums.contacts.SearchFields.listMember = "listMember";

kerio.api.enums.contacts.SearchFields.fileAs = "fileAs";

kerio.api.enums.contacts.SearchFields.name = "name";

kerio.api.enums.contacts.SearchFields.address = "address";

kerio.api.enums.contacts.SearchFields.description = "description";

kerio.api.enums.contacts.SearchFields.type = "type";

kerio.api.Contacts = {
    copy: function(e, t) {
        return kerio.api.callMethod(this.Def.copy.name, e, t, this.Def.copy.Response);
    },
    create: function(e, t) {
        return kerio.api.callMethod(this.Def.create.name, e, t, this.Def.create.Response);
    },
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    getFromCache: function(e, t) {
        return kerio.api.callMethod(this.Def.getFromCache.name, e, t, this.Def.getFromCache.Response);
    },
    getById: function(e, t) {
        return kerio.api.callMethod(this.Def.getById.name, e, t, this.Def.getById.Response);
    },
    getByIdFromCache: function(e, t) {
        return kerio.api.callMethod(this.Def.getByIdFromCache.name, e, t, this.Def.getByIdFromCache.Response);
    },
    getFromAttachment: function(e, t) {
        return kerio.api.callMethod(this.Def.getFromAttachment.name, e, t, this.Def.getFromAttachment.Response);
    },
    getResources: function(e, t) {
        return kerio.api.callMethod(this.Def.getResources.name, e, t, this.Def.getResources.Response);
    },
    getCertificate: function(e, t) {
        return kerio.api.callMethod(this.Def.getCertificate.name, e, t, this.Def.getCertificate.Response);
    },
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    move: function(e, t) {
        return kerio.api.callMethod(this.Def.move.name, e, t, this.Def.move.Response);
    },
    getPersonal: function(e) {
        return kerio.api.callMethod(this.Def.getPersonal.name, {}, e, this.Def.getPersonal.Response);
    },
    setPersonal: function(e, t) {
        return kerio.api.callMethod(this.Def.setPersonal.name, e, t, this.Def.setPersonal.Response);
    },
    Def: {
        $name: "Contacts",
        copy: {
            name: "Contacts.copy",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        create: {
            name: "Contacts.create",
            input: {
                contacts: "contacts"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        get: {
            name: "Contacts.get",
            input: {
                folderIds: "folderIds",
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getFromCache: {
            name: "Contacts.getFromCache",
            input: {
                folderIds: "folderIds",
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getById: {
            name: "Contacts.getById",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        getByIdFromCache: {
            name: "Contacts.getByIdFromCache",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        getFromAttachment: {
            name: "Contacts.getFromAttachment",
            input: {
                id: "id"
            },
            output: {
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        getResources: {
            name: "Contacts.getResources",
            input: {
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getCertificate: {
            name: "Contacts.getCertificate",
            input: {
                email: "email",
                id: "id"
            },
            output: {
                cert: "cert"
            },
            Request: function() {},
            Response: {}
        },
        remove: {
            name: "Contacts.remove",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Contacts.set",
            input: {
                contacts: "contacts"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        move: {
            name: "Contacts.move",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        getPersonal: {
            name: "Contacts.getPersonal",
            Request: function() {},
            Response: {}
        },
        setPersonal: {
            name: "Contacts.setPersonal",
            input: {
                contact: "contact"
            },
            Request: function() {}
        }
    }
};

kerio.api.Contacts.Def.copy.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Contacts.Def.create.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Contacts.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Contact");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Contacts.Def.getFromCache.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Contact");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Contacts.Def.getById.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "Contact");
        return this.result;
    }
};

kerio.api.Contacts.Def.getByIdFromCache.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "Contact");
        return this.result;
    }
};

kerio.api.Contacts.Def.getFromAttachment.Response.prototype = {
    getResult: function() {
        kerio.api.applyType(this.result, "Contact");
        return this.result;
    }
};

kerio.api.Contacts.Def.getResources.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Resource");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Contacts.Def.getCertificate.Response.prototype = {
    getCert: function() {
        kerio.api.applyType(this.cert, "Certificate");
        return this.cert;
    }
};

kerio.api.Contacts.Def.remove.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Contacts.Def.set.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "SetResult");
        return this.result;
    }
};

kerio.api.Contacts.Def.move.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Contacts.Def.getPersonal.Response.prototype = {
    getContact: function() {
        kerio.api.applyType(this.contact, "PersonalContact");
        return this.contact;
    }
};

kerio.api.Contacts.Def.copy.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.copy(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

kerio.api.Contacts.Def.create.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.create(this, e);
    },
    setContacts: function(e) {
        this.contacts = e;
    }
};

kerio.api.Contacts.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.get(this, e);
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Contacts.Def.getFromCache.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.getFromCache(this, e);
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Contacts.Def.getById.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.getById(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Contacts.Def.getByIdFromCache.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.getByIdFromCache(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Contacts.Def.getFromAttachment.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.getFromAttachment(this, e);
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Contacts.Def.getResources.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.getResources(this, e);
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Contacts.Def.getCertificate.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.getCertificate(this, e);
    },
    setEmail: function(e) {
        this.email = e;
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Contacts.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.remove(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Contacts.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.set(this, e);
    },
    setContacts: function(e) {
        this.contacts = e;
    }
};

kerio.api.Contacts.Def.move.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.move(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

kerio.api.Contacts.Def.getPersonal.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.getPersonal(e);
    }
};

kerio.api.Contacts.Def.setPersonal.Request.prototype = {
    send: function(e) {
        return kerio.api.Contacts.setPersonal(this, e);
    },
    setContact: function(e) {
        this.contact = e;
    }
};

if (!window.kerio.api.enums.tasks) {
    window.kerio.api.enums.tasks = {
        SearchFields: {}
    };
}

kerio.api.enums.tasks.TaskStatus = {
    tsNotStarted: "tsNotStarted",
    tsCompleted: "tsCompleted",
    tsInProgress: "tsInProgress",
    tsWaiting: "tsWaiting",
    tsDeferred: "tsDeferred"
};

kerio.api.type.Task = function() {};

kerio.api.type.Task.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getFolderId: function() {
        return this.folderId;
    },
    setFolderId: function(e) {
        this.folderId = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    },
    getAccess: function() {
        return this.access;
    },
    setAccess: function(e) {
        this.access = e;
    },
    getSummary: function() {
        return this.summary;
    },
    setSummary: function(e) {
        this.summary = e;
    },
    getLocation: function() {
        return this.location;
    },
    setLocation: function(e) {
        this.location = e;
    },
    getDescription: function() {
        return this.description;
    },
    setDescription: function(e) {
        this.description = e;
    },
    getStatus: function() {
        return this.status;
    },
    setStatus: function(e) {
        this.status = e;
    },
    getStart: function() {
        return this.start;
    },
    setStart: function(e) {
        this.start = e;
    },
    getDue: function() {
        return this.due;
    },
    setDue: function(e) {
        this.due = e;
    },
    getEnd: function() {
        return this.end;
    },
    setEnd: function(e) {
        this.end = e;
    },
    getDone: function() {
        return this.done;
    },
    setDone: function(e) {
        this.done = e;
    },
    getPriority: function() {
        return this.priority;
    },
    setPriority: function(e) {
        this.priority = e;
    },
    getRule: function() {
        kerio.api.applyType(this.rule, "RecurrenceRule");
        return this.rule;
    },
    setRule: function(e) {
        this.rule = e;
    },
    getAttendees: function() {
        kerio.api.applyType(this.attendees, "Attendee");
        return this.attendees;
    },
    setAttendees: function(e) {
        this.attendees = e;
    },
    getReminder: function() {
        kerio.api.applyType(this.reminder, "Reminder");
        return this.reminder;
    },
    setReminder: function(e) {
        this.reminder = e;
    },
    getSortOrder: function() {
        return this.sortOrder;
    },
    setSortOrder: function(e) {
        this.sortOrder = e;
    },
    getIsPrivate: function() {
        return this.isPrivate;
    },
    setIsPrivate: function(e) {
        this.isPrivate = e;
    },
    getIsCancelled: function() {
        return this.isCancelled;
    },
    setIsCancelled: function(e) {
        this.isCancelled = e;
    }
};

kerio.api.type.Task.fields = {
    ALL_FIELDS: [ "id", "folderId", "watermark", "access", "summary", "location", "description", "status", "start", "due", "end", "done", "priority", "rule", "attendees", "reminder", "sortOrder", "isPrivate", "isCancelled" ],
    id: "id",
    folderId: "folderId",
    watermark: "watermark",
    access: "access",
    summary: "summary",
    location: "location",
    description: "description",
    status: "status",
    start: "start",
    due: "due",
    end: "end",
    done: "done",
    priority: "priority",
    rule: "rule",
    attendees: "attendees",
    reminder: "reminder",
    sortOrder: "sortOrder",
    isPrivate: "isPrivate",
    isCancelled: "isCancelled"
};

kerio.api.enums.tasks.SearchFields.messageId = "messageId";

kerio.api.enums.tasks.SearchFields.summary = "summary";

kerio.api.enums.tasks.SearchFields.location = "location";

kerio.api.enums.tasks.SearchFields.due = "due";

kerio.api.enums.tasks.SearchFields.start = "start";

kerio.api.enums.tasks.SearchFields.end = "end";

kerio.api.enums.tasks.SearchFields.reminder = "reminder";

kerio.api.enums.tasks.SearchFields.status = "status";

kerio.api.enums.tasks.SearchFields.rule = "rule";

kerio.api.enums.tasks.SearchFields.attendees = "attendees";

kerio.api.enums.tasks.SearchFields.done = "done";

kerio.api.enums.tasks.SearchFields.priority = "priority";

kerio.api.enums.tasks.SearchFields.receiveDate = "receiveDate";

kerio.api.enums.tasks.SearchFields.modifiedDate = "modifiedDate";

kerio.api.Tasks = {
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    getById: function(e, t) {
        return kerio.api.callMethod(this.Def.getById.name, e, t, this.Def.getById.Response);
    },
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    copy: function(e, t) {
        return kerio.api.callMethod(this.Def.copy.name, e, t, this.Def.copy.Response);
    },
    create: function(e, t) {
        return kerio.api.callMethod(this.Def.create.name, e, t, this.Def.create.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    move: function(e, t) {
        return kerio.api.callMethod(this.Def.move.name, e, t, this.Def.move.Response);
    },
    Def: {
        $name: "Tasks",
        get: {
            name: "Tasks.get",
            input: {
                folderIds: "folderIds",
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getById: {
            name: "Tasks.getById",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        remove: {
            name: "Tasks.remove",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        copy: {
            name: "Tasks.copy",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        create: {
            name: "Tasks.create",
            input: {
                tasks: "tasks"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Tasks.set",
            input: {
                tasks: "tasks"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        move: {
            name: "Tasks.move",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Tasks.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Task");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Tasks.Def.getById.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "Task");
        return this.result;
    }
};

kerio.api.Tasks.Def.remove.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Tasks.Def.copy.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Tasks.Def.create.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Tasks.Def.set.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "SetResult");
        return this.result;
    }
};

kerio.api.Tasks.Def.move.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Tasks.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Tasks.get(this, e);
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Tasks.Def.getById.Request.prototype = {
    send: function(e) {
        return kerio.api.Tasks.getById(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Tasks.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Tasks.remove(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Tasks.Def.copy.Request.prototype = {
    send: function(e) {
        return kerio.api.Tasks.copy(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

kerio.api.Tasks.Def.create.Request.prototype = {
    send: function(e) {
        return kerio.api.Tasks.create(this, e);
    },
    setTasks: function(e) {
        this.tasks = e;
    }
};

kerio.api.Tasks.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Tasks.set(this, e);
    },
    setTasks: function(e) {
        this.tasks = e;
    }
};

kerio.api.Tasks.Def.move.Request.prototype = {
    send: function(e) {
        return kerio.api.Tasks.move(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

if (!window.kerio.api.enums.freebusy) {
    window.kerio.api.enums.freebusy = {
        SearchFields: {}
    };
}

kerio.api.type.FreeBusyInterval = function() {};

kerio.api.type.FreeBusyInterval.prototype = {
    getStatus: function() {
        return this.status;
    },
    setStatus: function(e) {
        this.status = e;
    },
    getStart: function() {
        return this.start;
    },
    setStart: function(e) {
        this.start = e;
    },
    getEnd: function() {
        return this.end;
    },
    setEnd: function(e) {
        this.end = e;
    }
};

kerio.api.type.FreeBusyInterval.fields = {
    ALL_FIELDS: [ "status", "start", "end" ],
    status: "status",
    start: "start",
    end: "end"
};

kerio.api.FreeBusy = {
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    Def: {
        $name: "FreeBusy",
        get: {
            name: "FreeBusy.get",
            input: {
                userAddresses: "userAddresses",
                start: "start",
                end: "end"
            },
            output: {
                list: "list"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.FreeBusy.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "FreeBusyInterval");
        return this.list;
    }
};

kerio.api.FreeBusy.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.FreeBusy.get(this, e);
    },
    setUserAddresses: function(e) {
        this.userAddresses = e;
    },
    setStart: function(e) {
        this.start = e;
    },
    setEnd: function(e) {
        this.end = e;
    }
};

if (!window.kerio.api.enums.changes) {
    window.kerio.api.enums.changes = {
        SearchFields: {}
    };
}

kerio.api.enums.changes.ChangeType = {
    chtCreated: "chtCreated",
    chtCopied: "chtCopied",
    chtDeleted: "chtDeleted",
    chtModified: "chtModified",
    chtMoved: "chtMoved",
    chtNewMail: "chtNewMail",
    chtStatus: "chtStatus",
    chtReadFlagChanged: "chtReadFlagChanged",
    chtModifiedMetadata: "chtModifiedMetadata",
    chtModifiedContent: "chtModifiedContent"
};

kerio.api.enums.changes.ItemType = {
    itMail: "itMail",
    itCalendar: "itCalendar",
    itContact: "itContact",
    itTask: "itTask",
    itNote: "itNote",
    itCalendarInbox: "itCalendarInbox",
    itDelegation: "itDelegation"
};

kerio.api.type.AccountSyncKey = function() {};

kerio.api.type.AccountSyncKey.prototype = {
    getGuid: function() {
        return this.guid;
    },
    setGuid: function(e) {
        this.guid = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    }
};

kerio.api.type.AccountSyncKey.fields = {
    ALL_FIELDS: [ "guid", "watermark" ],
    guid: "guid",
    watermark: "watermark"
};

kerio.api.type.SyncKey = function() {};

kerio.api.type.SyncKey.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getVersion: function() {
        return this.version;
    },
    setVersion: function(e) {
        this.version = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    },
    getPublicFolder: function() {
        return this.publicFolder;
    },
    setPublicFolder: function(e) {
        this.publicFolder = e;
    },
    getAccountSyncKey: function() {
        kerio.api.applyType(this.accountSyncKey, "AccountSyncKey");
        return this.accountSyncKey;
    },
    setAccountSyncKey: function(e) {
        this.accountSyncKey = e;
    }
};

kerio.api.type.SyncKey.fields = {
    ALL_FIELDS: [ "id", "version", "watermark", "publicFolder", "accountSyncKey" ],
    id: "id",
    version: "version",
    watermark: "watermark",
    publicFolder: "publicFolder",
    accountSyncKey: "accountSyncKey"
};

kerio.api.type.Change = function() {};

kerio.api.type.Change.prototype = {
    getIsFolder: function() {
        return this.isFolder;
    },
    setIsFolder: function(e) {
        this.isFolder = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getItemType: function() {
        return this.itemType;
    },
    setItemType: function(e) {
        this.itemType = e;
    },
    getItemId: function() {
        return this.itemId;
    },
    setItemId: function(e) {
        this.itemId = e;
    },
    getParentId: function() {
        return this.parentId;
    },
    setParentId: function(e) {
        this.parentId = e;
    },
    getOrigId: function() {
        return this.origId;
    },
    setOrigId: function(e) {
        this.origId = e;
    },
    getOrigParentId: function() {
        return this.origParentId;
    },
    setOrigParentId: function(e) {
        this.origParentId = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    },
    getMessageUnread: function() {
        return this.messageUnread;
    },
    setMessageUnread: function(e) {
        this.messageUnread = e;
    }
};

kerio.api.type.Change.fields = {
    ALL_FIELDS: [ "isFolder", "type", "itemType", "itemId", "parentId", "origId", "origParentId", "watermark", "messageUnread" ],
    isFolder: "isFolder",
    type: "type",
    itemType: "itemType",
    itemId: "itemId",
    parentId: "parentId",
    origId: "origId",
    origParentId: "origParentId",
    watermark: "watermark",
    messageUnread: "messageUnread"
};

kerio.api.Changes = {
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    getAccount: function(e, t) {
        return kerio.api.callMethod(this.Def.getAccount.name, e, t, this.Def.getAccount.Response);
    },
    killRequest: function(e, t) {
        return kerio.api.callMethod(this.Def.killRequest.name, e, t, this.Def.killRequest.Response);
    },
    getFolder: function(e, t) {
        return kerio.api.callMethod(this.Def.getFolder.name, e, t, this.Def.getFolder.Response);
    },
    getSyncKey: function(e) {
        return kerio.api.callMethod(this.Def.getSyncKey.name, {}, e, this.Def.getSyncKey.Response);
    },
    getAccountSyncKey: function(e, t) {
        return kerio.api.callMethod(this.Def.getAccountSyncKey.name, e, t, this.Def.getAccountSyncKey.Response);
    },
    getFolderSyncKey: function(e, t) {
        return kerio.api.callMethod(this.Def.getFolderSyncKey.name, e, t, this.Def.getFolderSyncKey.Response);
    },
    Def: {
        $name: "Changes",
        get: {
            name: "Changes.get",
            input: {
                lastSyncKey: "lastSyncKey",
                timeout: "timeout"
            },
            output: {
                list: "list",
                syncKey: "syncKey"
            },
            Request: function() {},
            Response: {}
        },
        getAccount: {
            name: "Changes.getAccount",
            input: {
                lastAsyncKey: "lastAsyncKey",
                folderIds: "folderIds"
            },
            output: {
                list: "list",
                asyncKey: "asyncKey"
            },
            Request: function() {},
            Response: {}
        },
        killRequest: {
            name: "Changes.killRequest",
            input: {
                lastSyncKey: "lastSyncKey"
            },
            Request: function() {}
        },
        getFolder: {
            name: "Changes.getFolder",
            input: {
                folderId: "folderId",
                lastSyncKey: "lastSyncKey"
            },
            output: {
                list: "list",
                syncKey: "syncKey"
            },
            Request: function() {},
            Response: {}
        },
        getSyncKey: {
            name: "Changes.getSyncKey",
            Request: function() {},
            Response: {}
        },
        getAccountSyncKey: {
            name: "Changes.getAccountSyncKey",
            input: {
                mailboxId: "mailboxId"
            },
            output: {
                asyncKey: "asyncKey"
            },
            Request: function() {},
            Response: {}
        },
        getFolderSyncKey: {
            name: "Changes.getFolderSyncKey",
            input: {
                folderId: "folderId"
            },
            output: {
                syncKey: "syncKey"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Changes.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Change");
        return this.list;
    },
    getSyncKey: function() {
        kerio.api.applyType(this.syncKey, "SyncKey");
        return this.syncKey;
    }
};

kerio.api.Changes.Def.getAccount.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Change");
        return this.list;
    },
    getAsyncKey: function() {
        kerio.api.applyType(this.asyncKey, "AccountSyncKey");
        return this.asyncKey;
    }
};

kerio.api.Changes.Def.getFolder.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Change");
        return this.list;
    },
    getSyncKey: function() {
        return this.syncKey;
    }
};

kerio.api.Changes.Def.getSyncKey.Response.prototype = {
    getSyncKey: function() {
        kerio.api.applyType(this.syncKey, "SyncKey");
        return this.syncKey;
    }
};

kerio.api.Changes.Def.getAccountSyncKey.Response.prototype = {
    getAsyncKey: function() {
        kerio.api.applyType(this.asyncKey, "AccountSyncKey");
        return this.asyncKey;
    }
};

kerio.api.Changes.Def.getFolderSyncKey.Response.prototype = {
    getSyncKey: function() {
        return this.syncKey;
    }
};

kerio.api.Changes.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Changes.get(this, e);
    },
    setLastSyncKey: function(e) {
        this.lastSyncKey = e;
    },
    setTimeout: function(e) {
        this.timeout = e;
    }
};

kerio.api.Changes.Def.getAccount.Request.prototype = {
    send: function(e) {
        return kerio.api.Changes.getAccount(this, e);
    },
    setLastAsyncKey: function(e) {
        this.lastAsyncKey = e;
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    }
};

kerio.api.Changes.Def.killRequest.Request.prototype = {
    send: function(e) {
        return kerio.api.Changes.killRequest(this, e);
    },
    setLastSyncKey: function(e) {
        this.lastSyncKey = e;
    }
};

kerio.api.Changes.Def.getFolder.Request.prototype = {
    send: function(e) {
        return kerio.api.Changes.getFolder(this, e);
    },
    setFolderId: function(e) {
        this.folderId = e;
    },
    setLastSyncKey: function(e) {
        this.lastSyncKey = e;
    }
};

kerio.api.Changes.Def.getSyncKey.Request.prototype = {
    send: function(e) {
        return kerio.api.Changes.getSyncKey(e);
    }
};

kerio.api.Changes.Def.getAccountSyncKey.Request.prototype = {
    send: function(e) {
        return kerio.api.Changes.getAccountSyncKey(this, e);
    },
    setMailboxId: function(e) {
        this.mailboxId = e;
    }
};

kerio.api.Changes.Def.getFolderSyncKey.Request.prototype = {
    send: function(e) {
        return kerio.api.Changes.getFolderSyncKey(this, e);
    },
    setFolderId: function(e) {
        this.folderId = e;
    }
};

if (!window.kerio.api.enums.notes) {
    window.kerio.api.enums.notes = {
        SearchFields: {}
    };
}

kerio.api.enums.notes.NoteColor = {
    White: "White",
    Yellow: "Yellow",
    Pink: "Pink",
    Green: "Green",
    Blue: "Blue"
};

kerio.api.type.NotePosition = function() {};

kerio.api.type.NotePosition.prototype = {
    getXOffset: function() {
        return this.xOffset;
    },
    setXOffset: function(e) {
        this.xOffset = e;
    },
    getYOffset: function() {
        return this.yOffset;
    },
    setYOffset: function(e) {
        this.yOffset = e;
    },
    getXSize: function() {
        return this.xSize;
    },
    setXSize: function(e) {
        this.xSize = e;
    },
    getYSize: function() {
        return this.ySize;
    },
    setYSize: function(e) {
        this.ySize = e;
    }
};

kerio.api.type.NotePosition.fields = {
    ALL_FIELDS: [ "xOffset", "yOffset", "xSize", "ySize" ],
    xOffset: "xOffset",
    yOffset: "yOffset",
    xSize: "xSize",
    ySize: "ySize"
};

kerio.api.type.Note = function() {};

kerio.api.type.Note.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getFolderId: function() {
        return this.folderId;
    },
    setFolderId: function(e) {
        this.folderId = e;
    },
    getWatermark: function() {
        return this.watermark;
    },
    setWatermark: function(e) {
        this.watermark = e;
    },
    getColor: function() {
        return this.color;
    },
    setColor: function(e) {
        this.color = e;
    },
    getText: function() {
        return this.text;
    },
    setText: function(e) {
        this.text = e;
    },
    getPosition: function() {
        kerio.api.applyType(this.position, "NotePosition");
        return this.position;
    },
    setPosition: function(e) {
        this.position = e;
    },
    getCreateDate: function() {
        return this.createDate;
    },
    setCreateDate: function(e) {
        this.createDate = e;
    },
    getModifyDate: function() {
        return this.modifyDate;
    },
    setModifyDate: function(e) {
        this.modifyDate = e;
    }
};

kerio.api.type.Note.fields = {
    ALL_FIELDS: [ "id", "folderId", "watermark", "color", "text", "position", "createDate", "modifyDate" ],
    id: "id",
    folderId: "folderId",
    watermark: "watermark",
    color: "color",
    text: "text",
    position: "position",
    createDate: "createDate",
    modifyDate: "modifyDate"
};

kerio.api.enums.notes.SearchFields.text = "text";

kerio.api.enums.notes.SearchFields.color = "color";

kerio.api.enums.notes.SearchFields.createDate = "createDate";

kerio.api.enums.notes.SearchFields.modifyDate = "modifyDate";

kerio.api.Notes = {
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    getById: function(e, t) {
        return kerio.api.callMethod(this.Def.getById.name, e, t, this.Def.getById.Response);
    },
    remove: function(e, t) {
        return kerio.api.callMethod(this.Def.remove.name, e, t, this.Def.remove.Response);
    },
    copy: function(e, t) {
        return kerio.api.callMethod(this.Def.copy.name, e, t, this.Def.copy.Response);
    },
    create: function(e, t) {
        return kerio.api.callMethod(this.Def.create.name, e, t, this.Def.create.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    move: function(e, t) {
        return kerio.api.callMethod(this.Def.move.name, e, t, this.Def.move.Response);
    },
    Def: {
        $name: "Notes",
        get: {
            name: "Notes.get",
            input: {
                folderIds: "folderIds",
                query: "query"
            },
            output: {
                list: "list",
                totalItems: "totalItems"
            },
            Request: function() {},
            Response: {}
        },
        getById: {
            name: "Notes.getById",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        remove: {
            name: "Notes.remove",
            input: {
                ids: "ids"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        copy: {
            name: "Notes.copy",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        create: {
            name: "Notes.create",
            input: {
                notes: "notes"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Notes.set",
            input: {
                notes: "notes"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        },
        move: {
            name: "Notes.move",
            input: {
                ids: "ids",
                folder: "folder"
            },
            output: {
                errors: "errors",
                result: "result"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Notes.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Note");
        return this.list;
    },
    getTotalItems: function() {
        return this.totalItems;
    }
};

kerio.api.Notes.Def.getById.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "Note");
        return this.result;
    }
};

kerio.api.Notes.Def.remove.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Notes.Def.copy.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Notes.Def.create.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Notes.Def.set.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "SetResult");
        return this.result;
    }
};

kerio.api.Notes.Def.move.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    },
    getResult: function() {
        kerio.api.applyType(this.result, "CreateResult");
        return this.result;
    }
};

kerio.api.Notes.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Notes.get(this, e);
    },
    setFolderIds: function(e) {
        this.folderIds = e;
    },
    setQuery: function(e) {
        this.query = e;
    }
};

kerio.api.Notes.Def.getById.Request.prototype = {
    send: function(e) {
        return kerio.api.Notes.getById(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Notes.Def.remove.Request.prototype = {
    send: function(e) {
        return kerio.api.Notes.remove(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    }
};

kerio.api.Notes.Def.copy.Request.prototype = {
    send: function(e) {
        return kerio.api.Notes.copy(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

kerio.api.Notes.Def.create.Request.prototype = {
    send: function(e) {
        return kerio.api.Notes.create(this, e);
    },
    setNotes: function(e) {
        this.notes = e;
    }
};

kerio.api.Notes.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Notes.set(this, e);
    },
    setNotes: function(e) {
        this.notes = e;
    }
};

kerio.api.Notes.Def.move.Request.prototype = {
    send: function(e) {
        return kerio.api.Notes.move(this, e);
    },
    setIds: function(e) {
        this.ids = e;
    },
    setFolder: function(e) {
        this.folder = e;
    }
};

if (!window.kerio.api.enums.principals) {
    window.kerio.api.enums.principals = {
        SearchFields: {}
    };
}

kerio.api.enums.principals.PrincipalType = {
    ptUser: "ptUser",
    ptResource: "ptResource",
    ptGroup: "ptGroup",
    ptDomain: "ptDomain",
    ptAnonymous: "ptAnonymous",
    ptAuthUser: "ptAuthUser"
};

kerio.api.type.Principal = function() {};

kerio.api.type.Principal.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getDisplayName: function() {
        return this.displayName;
    },
    setDisplayName: function(e) {
        this.displayName = e;
    },
    getMailAddress: function() {
        return this.mailAddress;
    },
    setMailAddress: function(e) {
        this.mailAddress = e;
    }
};

kerio.api.type.Principal.fields = {
    ALL_FIELDS: [ "id", "type", "displayName", "mailAddress" ],
    id: "id",
    type: "type",
    displayName: "displayName",
    mailAddress: "mailAddress"
};

kerio.api.Principals = {
    get: function(e, t) {
        return kerio.api.callMethod(this.Def.get.name, e, t, this.Def.get.Response);
    },
    getByEmail: function(e, t) {
        return kerio.api.callMethod(this.Def.getByEmail.name, e, t, this.Def.getByEmail.Response);
    },
    Def: {
        $name: "Principals",
        get: {
            name: "Principals.get",
            input: {
                users: "users",
                groups: "groups",
                domains: "domains"
            },
            output: {
                list: "list"
            },
            Request: function() {},
            Response: {}
        },
        getByEmail: {
            name: "Principals.getByEmail",
            input: {
                email: "email"
            },
            output: {
                principal: "principal"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Principals.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Principal");
        return this.list;
    }
};

kerio.api.Principals.Def.getByEmail.Response.prototype = {
    getPrincipal: function() {
        kerio.api.applyType(this.principal, "Principal");
        return this.principal;
    }
};

kerio.api.Principals.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Principals.get(this, e);
    },
    setUsers: function(e) {
        this.users = e;
    },
    setGroups: function(e) {
        this.groups = e;
    },
    setDomains: function(e) {
        this.domains = e;
    }
};

kerio.api.Principals.Def.getByEmail.Request.prototype = {
    send: function(e) {
        return kerio.api.Principals.getByEmail(this, e);
    },
    setEmail: function(e) {
        this.email = e;
    }
};

if (!window.kerio.api.enums.filters) {
    window.kerio.api.enums.filters = {
        SearchFields: {}
    };
}

kerio.api.type.FilterRule = function() {};

kerio.api.type.FilterRule.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getIsEnabled: function() {
        return this.isEnabled;
    },
    setIsEnabled: function(e) {
        this.isEnabled = e;
    },
    getDescription: function() {
        return this.description;
    },
    setDescription: function(e) {
        this.description = e;
    },
    getIsIncomplete: function() {
        return this.isIncomplete;
    },
    setIsIncomplete: function(e) {
        this.isIncomplete = e;
    },
    getConditions: function() {
        kerio.api.applyType(this.conditions, "FilterCondition");
        return this.conditions;
    },
    setConditions: function(e) {
        this.conditions = e;
    },
    getActions: function() {
        kerio.api.applyType(this.actions, "FilterAction");
        return this.actions;
    },
    setActions: function(e) {
        this.actions = e;
    },
    getEvaluationMode: function() {
        return this.evaluationMode;
    },
    setEvaluationMode: function(e) {
        this.evaluationMode = e;
    }
};

kerio.api.type.FilterRule.fields = {
    ALL_FIELDS: [ "id", "isEnabled", "description", "isIncomplete", "conditions", "actions", "evaluationMode" ],
    id: "id",
    isEnabled: "isEnabled",
    description: "description",
    isIncomplete: "isIncomplete",
    conditions: "conditions",
    actions: "actions",
    evaluationMode: "evaluationMode"
};

kerio.api.type.FilterRawRule = function() {};

kerio.api.type.FilterRawRule.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getIsEnabled: function() {
        return this.isEnabled;
    },
    setIsEnabled: function(e) {
        this.isEnabled = e;
    },
    getDescription: function() {
        return this.description;
    },
    setDescription: function(e) {
        this.description = e;
    },
    getScript: function() {
        return this.script;
    },
    setScript: function(e) {
        this.script = e;
    }
};

kerio.api.type.FilterRawRule.fields = {
    ALL_FIELDS: [ "id", "isEnabled", "description", "script" ],
    id: "id",
    isEnabled: "isEnabled",
    description: "description",
    script: "script"
};

kerio.api.Filters = {
    get: function(e) {
        return kerio.api.callMethod(this.Def.get.name, {}, e, this.Def.get.Response);
    },
    getById: function(e, t) {
        return kerio.api.callMethod(this.Def.getById.name, e, t, this.Def.getById.Response);
    },
    generateRule: function(e, t) {
        return kerio.api.callMethod(this.Def.generateRule.name, e, t, this.Def.generateRule.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    setById: function(e, t) {
        return kerio.api.callMethod(this.Def.setById.name, e, t, this.Def.setById.Response);
    },
    Def: {
        $name: "Filters",
        get: {
            name: "Filters.get",
            Request: function() {},
            Response: {}
        },
        getById: {
            name: "Filters.getById",
            input: {
                currentDataStamp: "currentDataStamp",
                id: "id"
            },
            output: {
                rule: "rule"
            },
            Request: function() {},
            Response: {}
        },
        generateRule: {
            name: "Filters.generateRule",
            input: {
                pattern: "pattern"
            },
            output: {
                rule: "rule"
            },
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Filters.set",
            input: {
                currentDataStamp: "currentDataStamp",
                filters: "filters"
            },
            output: {
                newDataStamp: "newDataStamp"
            },
            Request: function() {},
            Response: {}
        },
        setById: {
            name: "Filters.setById",
            input: {
                currentDataStamp: "currentDataStamp",
                rule: "rule"
            },
            output: {
                newDataStamp: "newDataStamp"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Filters.Def.get.Response.prototype = {
    getDataStamp: function() {
        return this.dataStamp;
    },
    getFilters: function() {
        kerio.api.applyType(this.filters, "FilterRule");
        return this.filters;
    }
};

kerio.api.Filters.Def.getById.Response.prototype = {
    getRule: function() {
        kerio.api.applyType(this.rule, "FilterRawRule");
        return this.rule;
    }
};

kerio.api.Filters.Def.generateRule.Response.prototype = {
    getRule: function() {
        kerio.api.applyType(this.rule, "FilterRawRule");
        return this.rule;
    }
};

kerio.api.Filters.Def.set.Response.prototype = {
    getNewDataStamp: function() {
        return this.newDataStamp;
    }
};

kerio.api.Filters.Def.setById.Response.prototype = {
    getNewDataStamp: function() {
        return this.newDataStamp;
    }
};

kerio.api.Filters.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Filters.get(e);
    }
};

kerio.api.Filters.Def.getById.Request.prototype = {
    send: function(e) {
        return kerio.api.Filters.getById(this, e);
    },
    setCurrentDataStamp: function(e) {
        this.currentDataStamp = e;
    },
    setId: function(e) {
        this.id = e;
    }
};

kerio.api.Filters.Def.generateRule.Request.prototype = {
    send: function(e) {
        return kerio.api.Filters.generateRule(this, e);
    },
    setPattern: function(e) {
        this.pattern = e;
    }
};

kerio.api.Filters.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Filters.set(this, e);
    },
    setCurrentDataStamp: function(e) {
        this.currentDataStamp = e;
    },
    setFilters: function(e) {
        this.filters = e;
    }
};

kerio.api.Filters.Def.setById.Request.prototype = {
    send: function(e) {
        return kerio.api.Filters.setById(this, e);
    },
    setCurrentDataStamp: function(e) {
        this.currentDataStamp = e;
    },
    setRule: function(e) {
        this.rule = e;
    }
};

if (!window.kerio.api.enums.delegation) {
    window.kerio.api.enums.delegation = {
        SearchFields: {}
    };
}

kerio.api.type.InboundDelegation = function() {};

kerio.api.type.InboundDelegation.prototype = {
    getPrincipal: function() {
        kerio.api.applyType(this.principal, "Principal");
        return this.principal;
    },
    setPrincipal: function(e) {
        this.principal = e;
    },
    getMailboxId: function() {
        return this.mailboxId;
    },
    setMailboxId: function(e) {
        this.mailboxId = e;
    },
    getAccepted: function() {
        return this.accepted;
    },
    setAccepted: function(e) {
        this.accepted = e;
    }
};

kerio.api.type.InboundDelegation.fields = {
    ALL_FIELDS: [ "principal", "mailboxId", "accepted" ],
    principal: "principal",
    mailboxId: "mailboxId",
    accepted: "accepted"
};

kerio.api.type.OutboundDelagation = function() {};

kerio.api.type.OutboundDelagation.prototype = {
    getPrincipal: function() {
        kerio.api.applyType(this.principal, "Principal");
        return this.principal;
    },
    setPrincipal: function(e) {
        this.principal = e;
    },
    getIsInboxRW: function() {
        return this.isInboxRW;
    },
    setIsInboxRW: function(e) {
        this.isInboxRW = e;
    }
};

kerio.api.type.OutboundDelagation.fields = {
    ALL_FIELDS: [ "principal", "isInboxRW" ],
    principal: "principal",
    isInboxRW: "isInboxRW"
};

kerio.api.Delegation = {
    get: function(e) {
        return kerio.api.callMethod(this.Def.get.name, {}, e, this.Def.get.Response);
    },
    set: function(e, t) {
        return kerio.api.callMethod(this.Def.set.name, e, t, this.Def.set.Response);
    },
    getInbound: function(e) {
        return kerio.api.callMethod(this.Def.getInbound.name, {}, e, this.Def.getInbound.Response);
    },
    setInbound: function(e, t) {
        return kerio.api.callMethod(this.Def.setInbound.name, e, t, this.Def.setInbound.Response);
    },
    Def: {
        $name: "Delegation",
        get: {
            name: "Delegation.get",
            Request: function() {},
            Response: {}
        },
        set: {
            name: "Delegation.set",
            input: {
                list: "list"
            },
            Request: function() {}
        },
        getInbound: {
            name: "Delegation.getInbound",
            Request: function() {},
            Response: {}
        },
        setInbound: {
            name: "Delegation.setInbound",
            input: {
                list: "list"
            },
            Request: function() {}
        }
    }
};

kerio.api.Delegation.Def.get.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "OutboundDelagation");
        return this.list;
    }
};

kerio.api.Delegation.Def.getInbound.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "InboundDelegation");
        return this.list;
    }
};

kerio.api.Delegation.Def.get.Request.prototype = {
    send: function(e) {
        return kerio.api.Delegation.get(e);
    }
};

kerio.api.Delegation.Def.set.Request.prototype = {
    send: function(e) {
        return kerio.api.Delegation.set(this, e);
    },
    setList: function(e) {
        this.list = e;
    }
};

kerio.api.Delegation.Def.getInbound.Request.prototype = {
    send: function(e) {
        return kerio.api.Delegation.getInbound(e);
    }
};

kerio.api.Delegation.Def.setInbound.Request.prototype = {
    send: function(e) {
        return kerio.api.Delegation.setInbound(this, e);
    },
    setList: function(e) {
        this.list = e;
    }
};

if (!window.kerio.api.enums.integration) {
    window.kerio.api.enums.integration = {
        SearchFields: {}
    };
}

kerio.api.type.SyncFolder = function() {};

kerio.api.type.SyncFolder.prototype = {
    getId: function() {
        return this.id;
    },
    setId: function(e) {
        this.id = e;
    },
    getParentId: function() {
        return this.parentId;
    },
    setParentId: function(e) {
        this.parentId = e;
    },
    getName: function() {
        return this.name;
    },
    setName: function(e) {
        this.name = e;
    },
    getType: function() {
        return this.type;
    },
    setType: function(e) {
        this.type = e;
    },
    getSubType: function() {
        return this.subType;
    },
    setSubType: function(e) {
        this.subType = e;
    },
    getPlaceType: function() {
        return this.placeType;
    },
    setPlaceType: function(e) {
        this.placeType = e;
    },
    getNestingLevel: function() {
        return this.nestingLevel;
    },
    setNestingLevel: function(e) {
        this.nestingLevel = e;
    },
    getOwnerName: function() {
        return this.ownerName;
    },
    setOwnerName: function(e) {
        this.ownerName = e;
    },
    getEmailAddress: function() {
        return this.emailAddress;
    },
    setEmailAddress: function(e) {
        this.emailAddress = e;
    },
    getIsSelectable: function() {
        return this.isSelectable;
    },
    setIsSelectable: function(e) {
        this.isSelectable = e;
    },
    getSynchronize: function() {
        return this.synchronize;
    },
    setSynchronize: function(e) {
        this.synchronize = e;
    }
};

kerio.api.type.SyncFolder.fields = {
    ALL_FIELDS: [ "id", "parentId", "name", "type", "subType", "placeType", "nestingLevel", "ownerName", "emailAddress", "isSelectable", "synchronize" ],
    id: "id",
    parentId: "parentId",
    name: "name",
    type: "type",
    subType: "subType",
    placeType: "placeType",
    nestingLevel: "nestingLevel",
    ownerName: "ownerName",
    emailAddress: "emailAddress",
    isSelectable: "isSelectable",
    synchronize: "synchronize"
};

kerio.api.Integration = {
    getASyncFolderList: function(e) {
        return kerio.api.callMethod(this.Def.getASyncFolderList.name, {}, e, this.Def.getASyncFolderList.Response);
    },
    setASyncFolderList: function(e, t) {
        return kerio.api.callMethod(this.Def.setASyncFolderList.name, e, t, this.Def.setASyncFolderList.Response);
    },
    getIPhoneSyncFolderList: function(e) {
        return kerio.api.callMethod(this.Def.getIPhoneSyncFolderList.name, {}, e, this.Def.getIPhoneSyncFolderList.Response);
    },
    setIPhoneSyncFolderList: function(e, t) {
        return kerio.api.callMethod(this.Def.setIPhoneSyncFolderList.name, e, t, this.Def.setIPhoneSyncFolderList.Response);
    },
    Def: {
        $name: "Integration",
        getASyncFolderList: {
            name: "Integration.getASyncFolderList",
            Request: function() {},
            Response: {}
        },
        setASyncFolderList: {
            name: "Integration.setASyncFolderList",
            input: {
                folders: "folders"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        },
        getIPhoneSyncFolderList: {
            name: "Integration.getIPhoneSyncFolderList",
            Request: function() {},
            Response: {}
        },
        setIPhoneSyncFolderList: {
            name: "Integration.setIPhoneSyncFolderList",
            input: {
                folders: "folders"
            },
            output: {
                errors: "errors"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Integration.Def.getASyncFolderList.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "SyncFolder");
        return this.list;
    }
};

kerio.api.Integration.Def.setASyncFolderList.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Integration.Def.getIPhoneSyncFolderList.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "SyncFolder");
        return this.list;
    }
};

kerio.api.Integration.Def.setIPhoneSyncFolderList.Response.prototype = {
    getErrors: function() {
        kerio.api.applyType(this.errors, "Error");
        return this.errors;
    }
};

kerio.api.Integration.Def.getASyncFolderList.Request.prototype = {
    send: function(e) {
        return kerio.api.Integration.getASyncFolderList(e);
    }
};

kerio.api.Integration.Def.setASyncFolderList.Request.prototype = {
    send: function(e) {
        return kerio.api.Integration.setASyncFolderList(this, e);
    },
    setFolders: function(e) {
        this.folders = e;
    }
};

kerio.api.Integration.Def.getIPhoneSyncFolderList.Request.prototype = {
    send: function(e) {
        return kerio.api.Integration.getIPhoneSyncFolderList(e);
    }
};

kerio.api.Integration.Def.setIPhoneSyncFolderList.Request.prototype = {
    send: function(e) {
        return kerio.api.Integration.setIPhoneSyncFolderList(this, e);
    },
    setFolders: function(e) {
        this.folders = e;
    }
};

kerio.api.type.OperatorExtension = function() {};

kerio.api.type.OperatorExtension.prototype = {
    getExtensionId: function() {
        return this.extensionId;
    },
    setExtensionId: function(e) {
        this.extensionId = e;
    },
    getTelNum: function() {
        return this.telNum;
    },
    setTelNum: function(e) {
        this.telNum = e;
    },
    getDescription: function() {
        return this.description;
    },
    setDescription: function(e) {
        this.description = e;
    },
    getIsRegistered: function() {
        return this.isRegistered;
    },
    setIsRegistered: function(e) {
        this.isRegistered = e;
    }
};

kerio.api.type.OperatorExtension.fields = {
    ALL_FIELDS: [ "extensionId", "telNum", "description", "isRegistered" ],
    extensionId: "extensionId",
    telNum: "telNum",
    description: "description",
    isRegistered: "isRegistered"
};

kerio.api.enums.OperatorCallStatus = {
    OcsUnknown: "OcsUnknown",
    OcsPickUp: "OcsPickUp",
    OcsRinging: "OcsRinging",
    OcsConnected: "OcsConnected"
};

kerio.api.CallManager = {
    getExtensions: function(e) {
        return kerio.api.callMethod(this.Def.getExtensions.name, {}, e, this.Def.getExtensions.Response);
    },
    dial: function(e, t) {
        return kerio.api.callMethod(this.Def.dial.name, e, t, this.Def.dial.Response);
    },
    login: function(e, t) {
        return kerio.api.callMethod(this.Def.login.name, e, t, this.Def.login.Response);
    },
    hangup: function(e, t) {
        return kerio.api.callMethod(this.Def.hangup.name, e, t, this.Def.hangup.Response);
    },
    getCallStatus: function(e, t) {
        return kerio.api.callMethod(this.Def.getCallStatus.name, e, t, this.Def.getCallStatus.Response);
    },
    Def: {
        $name: "CallManager",
        getExtensions: {
            name: "CallManager.getExtensions",
            Request: function() {},
            Response: {}
        },
        dial: {
            name: "CallManager.dial",
            input: {
                extensionId: "extensionId",
                phoneNumber: "phoneNumber"
            },
            output: {
                callId: "callId"
            },
            Request: function() {},
            Response: {}
        },
        login: {
            name: "CallManager.login",
            input: {
                userName: "userName",
                password: "password"
            },
            Request: function() {}
        },
        hangup: {
            name: "CallManager.hangup",
            input: {
                callId: "callId"
            },
            Request: function() {}
        },
        getCallStatus: {
            name: "CallManager.getCallStatus",
            input: {
                lastStatus: "lastStatus",
                callId: "callId"
            },
            output: {
                status: "status"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.CallManager.Def.getExtensions.Response.prototype = {
    getExtensions: function() {
        kerio.api.applyType(this.extensions, "OperatorExtension");
        return this.extensions;
    }
};

kerio.api.CallManager.Def.dial.Response.prototype = {
    getCallId: function() {
        return this.callId;
    }
};

kerio.api.CallManager.Def.getCallStatus.Response.prototype = {
    getStatus: function() {
        return this.status;
    }
};

kerio.api.CallManager.Def.getExtensions.Request.prototype = {
    send: function(e) {
        return kerio.api.CallManager.getExtensions(e);
    }
};

kerio.api.CallManager.Def.dial.Request.prototype = {
    send: function(e) {
        return kerio.api.CallManager.dial(this, e);
    },
    setExtensionId: function(e) {
        this.extensionId = e;
    },
    setPhoneNumber: function(e) {
        this.phoneNumber = e;
    }
};

kerio.api.CallManager.Def.login.Request.prototype = {
    send: function(e) {
        return kerio.api.CallManager.login(this, e);
    },
    setUserName: function(e) {
        this.userName = e;
    },
    setPassword: function(e) {
        this.password = e;
    }
};

kerio.api.CallManager.Def.hangup.Request.prototype = {
    send: function(e) {
        return kerio.api.CallManager.hangup(this, e);
    },
    setCallId: function(e) {
        this.callId = e;
    }
};

kerio.api.CallManager.Def.getCallStatus.Request.prototype = {
    send: function(e) {
        return kerio.api.CallManager.getCallStatus(this, e);
    },
    setLastStatus: function(e) {
        this.lastStatus = e;
    },
    setCallId: function(e) {
        this.callId = e;
    }
};

if (!window.kerio.api.enums.im) {
    window.kerio.api.enums.im = {
        SearchFields: {}
    };
}

kerio.api.enums.im.Status = {
    available: "available",
    offline: "offline",
    dnd: "dnd",
    away: "away",
    invisible: "invisible"
};

kerio.api.type.Presence = function() {};

kerio.api.type.Presence.prototype = {
    getContactId: function() {
        return this.contactId;
    },
    setContactId: function(e) {
        this.contactId = e;
    },
    getStatus: function() {
        return this.status;
    },
    setStatus: function(e) {
        this.status = e;
    },
    getText: function() {
        return this.text;
    },
    setText: function(e) {
        this.text = e;
    },
    getDate: function() {
        return this.date;
    },
    setDate: function(e) {
        this.date = e;
    }
};

kerio.api.type.Presence.fields = {
    ALL_FIELDS: [ "contactId", "status", "text", "date" ],
    contactId: "contactId",
    status: "status",
    text: "text",
    date: "date"
};

kerio.api.enums.im.ConversationEvent = {
    Created: "Created",
    Updated: "Updated",
    Delivered: "Delivered",
    Read: "Read"
};

kerio.api.type.Conversation = function() {};

kerio.api.type.Conversation.prototype = {
    getConversationId: function() {
        return this.conversationId;
    },
    setConversationId: function(e) {
        this.conversationId = e;
    },
    getLastActivity: function() {
        return this.lastActivity;
    },
    setLastActivity: function(e) {
        this.lastActivity = e;
    },
    getSentLastDeliveredId: function() {
        return this.sentLastDeliveredId;
    },
    setSentLastDeliveredId: function(e) {
        this.sentLastDeliveredId = e;
    },
    getSentLastReadId: function() {
        return this.sentLastReadId;
    },
    setSentLastReadId: function(e) {
        this.sentLastReadId = e;
    },
    getReceivedLastReadId: function() {
        return this.receivedLastReadId;
    },
    setReceivedLastReadId: function(e) {
        this.receivedLastReadId = e;
    },
    getReceivedUnreadCount: function() {
        return this.receivedUnreadCount;
    },
    setReceivedUnreadCount: function(e) {
        this.receivedUnreadCount = e;
    },
    getContacts: function() {
        return this.contacts;
    },
    setContacts: function(e) {
        this.contacts = e;
    },
    getEvent: function() {
        return this.event;
    },
    setEvent: function(e) {
        this.event = e;
    },
    getMuted: function() {
        return this.muted;
    },
    setMuted: function(e) {
        this.muted = e;
    }
};

kerio.api.type.Conversation.fields = {
    ALL_FIELDS: [ "conversationId", "lastActivity", "sentLastDeliveredId", "sentLastReadId", "receivedLastReadId", "receivedUnreadCount", "contacts", "event", "muted" ],
    conversationId: "conversationId",
    lastActivity: "lastActivity",
    sentLastDeliveredId: "sentLastDeliveredId",
    sentLastReadId: "sentLastReadId",
    receivedLastReadId: "receivedLastReadId",
    receivedUnreadCount: "receivedUnreadCount",
    contacts: "contacts",
    event: "event",
    muted: "muted"
};

kerio.api.enums.im.MessageEvent = {
    active: "active",
    inactive: "inactive"
};

kerio.api.type.Message = function() {};

kerio.api.type.Message.prototype = {
    getMessageId: function() {
        return this.messageId;
    },
    setMessageId: function(e) {
        this.messageId = e;
    },
    getText: function() {
        return this.text;
    },
    setText: function(e) {
        this.text = e;
    },
    getEvent: function() {
        return this.event;
    },
    setEvent: function(e) {
        this.event = e;
    },
    getTo: function() {
        return this.to;
    },
    setTo: function(e) {
        this.to = e;
    },
    getFrom: function() {
        return this.from;
    },
    setFrom: function(e) {
        this.from = e;
    },
    getTime: function() {
        return this.time;
    },
    setTime: function(e) {
        this.time = e;
    }
};

kerio.api.type.Message.fields = {
    ALL_FIELDS: [ "messageId", "text", "event", "to", "from", "time" ],
    messageId: "messageId",
    text: "text",
    event: "event",
    to: "to",
    from: "from",
    time: "time"
};

kerio.api.im = {
    authenticate: function(e, t) {
        return kerio.api.callMethod(this.Def.authenticate.name, e, t, this.Def.authenticate.Response);
    },
    getPresence: function(e, t) {
        return kerio.api.callMethod(this.Def.getPresence.name, e, t, this.Def.getPresence.Response);
    },
    subscribePresence: function(e) {
        return kerio.api.callMethod(this.Def.subscribePresence.name, {}, e, this.Def.subscribePresence.Response);
    },
    setPresence: function(e, t) {
        return kerio.api.callMethod(this.Def.setPresence.name, e, t, this.Def.setPresence.Response);
    },
    createConversation: function(e, t) {
        return kerio.api.callMethod(this.Def.createConversation.name, e, t, this.Def.createConversation.Response);
    },
    subscribeConversations: function(e) {
        return kerio.api.callMethod(this.Def.subscribeConversations.name, {}, e, this.Def.subscribeConversations.Response);
    },
    muteConversation: function(e, t) {
        return kerio.api.callMethod(this.Def.muteConversation.name, e, t, this.Def.muteConversation.Response);
    },
    readConversation: function(e, t) {
        return kerio.api.callMethod(this.Def.readConversation.name, e, t, this.Def.readConversation.Response);
    },
    getMessages: function(e, t) {
        return kerio.api.callMethod(this.Def.getMessages.name, e, t, this.Def.getMessages.Response);
    },
    subscribeMessages: function(e, t) {
        return kerio.api.callMethod(this.Def.subscribeMessages.name, e, t, this.Def.subscribeMessages.Response);
    },
    unsubscribeMessages: function(e, t) {
        return kerio.api.callMethod(this.Def.unsubscribeMessages.name, e, t, this.Def.unsubscribeMessages.Response);
    },
    sendMessage: function(e, t) {
        return kerio.api.callMethod(this.Def.sendMessage.name, e, t, this.Def.sendMessage.Response);
    },
    Def: {
        $name: "im",
        authenticate: {
            name: "im.authenticate",
            input: {
                xtoken: "xtoken"
            },
            Request: function() {}
        },
        getPresence: {
            name: "im.getPresence",
            input: {
                contacts: "contacts"
            },
            output: {
                list: "list"
            },
            Request: function() {},
            Response: {}
        },
        subscribePresence: {
            name: "im.subscribePresence",
            Request: function() {},
            Response: {}
        },
        setPresence: {
            name: "im.setPresence",
            input: {
                status: "status",
                text: "text"
            },
            Request: function() {}
        },
        createConversation: {
            name: "im.createConversation",
            input: {
                contacts: "contacts"
            },
            output: {
                conversation: "conversation"
            },
            Request: function() {},
            Response: {}
        },
        subscribeConversations: {
            name: "im.subscribeConversations",
            Request: function() {},
            Response: {}
        },
        muteConversation: {
            name: "im.muteConversation",
            input: {
                conversationId: "conversationId",
                mute: "mute"
            },
            Request: function() {}
        },
        readConversation: {
            name: "im.readConversation",
            input: {
                conversationId: "conversationId",
                lastReadId: "lastReadId"
            },
            Request: function() {}
        },
        getMessages: {
            name: "im.getMessages",
            input: {
                conversationId: "conversationId",
                currentMessageId: "currentMessageId",
                count: "count"
            },
            output: {
                list: "list"
            },
            Request: function() {},
            Response: {}
        },
        subscribeMessages: {
            name: "im.subscribeMessages",
            input: {
                conversationId: "conversationId",
                currentMessageId: "currentMessageId",
                count: "count"
            },
            output: {
                list: "list"
            },
            Request: function() {},
            Response: {}
        },
        unsubscribeMessages: {
            name: "im.unsubscribeMessages",
            input: {
                conversationId: "conversationId"
            },
            Request: function() {}
        },
        sendMessage: {
            name: "im.sendMessage",
            input: {
                message: "message",
                markAsRead: "markAsRead"
            },
            output: {
                messageId: "messageId",
                time: "time"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.im.Def.getPresence.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Presence");
        return this.list;
    }
};

kerio.api.im.Def.subscribePresence.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Presence");
        return this.list;
    }
};

kerio.api.im.Def.createConversation.Response.prototype = {
    getConversation: function() {
        kerio.api.applyType(this.conversation, "Conversation");
        return this.conversation;
    }
};

kerio.api.im.Def.subscribeConversations.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Conversation");
        return this.list;
    }
};

kerio.api.im.Def.getMessages.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Message");
        return this.list;
    }
};

kerio.api.im.Def.subscribeMessages.Response.prototype = {
    getList: function() {
        kerio.api.applyType(this.list, "Message");
        return this.list;
    }
};

kerio.api.im.Def.sendMessage.Response.prototype = {
    getMessageId: function() {
        return this.messageId;
    },
    getTime: function() {
        return this.time;
    }
};

kerio.api.im.Def.authenticate.Request.prototype = {
    send: function(e) {
        return kerio.api.im.authenticate(this, e);
    },
    setXtoken: function(e) {
        this.xtoken = e;
    }
};

kerio.api.im.Def.getPresence.Request.prototype = {
    send: function(e) {
        return kerio.api.im.getPresence(this, e);
    },
    setContacts: function(e) {
        this.contacts = e;
    }
};

kerio.api.im.Def.subscribePresence.Request.prototype = {
    send: function(e) {
        return kerio.api.im.subscribePresence(e);
    }
};

kerio.api.im.Def.setPresence.Request.prototype = {
    send: function(e) {
        return kerio.api.im.setPresence(this, e);
    },
    setStatus: function(e) {
        this.status = e;
    },
    setText: function(e) {
        this.text = e;
    }
};

kerio.api.im.Def.createConversation.Request.prototype = {
    send: function(e) {
        return kerio.api.im.createConversation(this, e);
    },
    setContacts: function(e) {
        this.contacts = e;
    }
};

kerio.api.im.Def.subscribeConversations.Request.prototype = {
    send: function(e) {
        return kerio.api.im.subscribeConversations(e);
    }
};

kerio.api.im.Def.muteConversation.Request.prototype = {
    send: function(e) {
        return kerio.api.im.muteConversation(this, e);
    },
    setConversationId: function(e) {
        this.conversationId = e;
    },
    setMute: function(e) {
        this.mute = e;
    }
};

kerio.api.im.Def.readConversation.Request.prototype = {
    send: function(e) {
        return kerio.api.im.readConversation(this, e);
    },
    setConversationId: function(e) {
        this.conversationId = e;
    },
    setLastReadId: function(e) {
        this.lastReadId = e;
    }
};

kerio.api.im.Def.getMessages.Request.prototype = {
    send: function(e) {
        return kerio.api.im.getMessages(this, e);
    },
    setConversationId: function(e) {
        this.conversationId = e;
    },
    setCurrentMessageId: function(e) {
        this.currentMessageId = e;
    },
    setCount: function(e) {
        this.count = e;
    }
};

kerio.api.im.Def.subscribeMessages.Request.prototype = {
    send: function(e) {
        return kerio.api.im.subscribeMessages(this, e);
    },
    setConversationId: function(e) {
        this.conversationId = e;
    },
    setCurrentMessageId: function(e) {
        this.currentMessageId = e;
    },
    setCount: function(e) {
        this.count = e;
    }
};

kerio.api.im.Def.unsubscribeMessages.Request.prototype = {
    send: function(e) {
        return kerio.api.im.unsubscribeMessages(this, e);
    },
    setConversationId: function(e) {
        this.conversationId = e;
    }
};

kerio.api.im.Def.sendMessage.Request.prototype = {
    send: function(e) {
        return kerio.api.im.sendMessage(this, e);
    },
    setMessage: function(e) {
        this.message = e;
    },
    setMarkAsRead: function(e) {
        this.markAsRead = e;
    }
};

if (!window.kerio.api.enums.clients) {
    window.kerio.api.enums.clients = {
        SearchFields: {}
    };
}

kerio.api.type.ClientVersion = function() {};

kerio.api.type.ClientVersion.prototype = {
    getMajor: function() {
        return this.major;
    },
    setMajor: function(e) {
        this.major = e;
    },
    getMinor: function() {
        return this.minor;
    },
    setMinor: function(e) {
        this.minor = e;
    },
    getRevision: function() {
        return this.revision;
    },
    setRevision: function(e) {
        this.revision = e;
    },
    getBuild: function() {
        return this.build;
    },
    setBuild: function(e) {
        this.build = e;
    }
};

kerio.api.type.ClientVersion.fields = {
    ALL_FIELDS: [ "major", "minor", "revision", "build" ],
    major: "major",
    minor: "minor",
    revision: "revision",
    build: "build"
};

kerio.api.Clients = {
    getMinimalClientVersion: function(e, t) {
        return kerio.api.callMethod(this.Def.getMinimalClientVersion.name, e, t, this.Def.getMinimalClientVersion.Response);
    },
    Def: {
        $name: "Clients",
        getMinimalClientVersion: {
            name: "Clients.getMinimalClientVersion",
            input: {
                clientName: "clientName"
            },
            output: {
                clientVersion: "clientVersion"
            },
            Request: function() {},
            Response: {}
        }
    }
};

kerio.api.Clients.Def.getMinimalClientVersion.Response.prototype = {
    getClientVersion: function() {
        kerio.api.applyType(this.clientVersion, "ClientVersion");
        return this.clientVersion;
    }
};

kerio.api.Clients.Def.getMinimalClientVersion.Request.prototype = {
    send: function(e) {
        return kerio.api.Clients.getMinimalClientVersion(this, e);
    },
    setClientName: function(e) {
        this.clientName = e;
    }
};

kerio.api.type.SearchQuery.prototype.condition = function(e, t, i) {
    if (void 0 === this.conditions) {
        this.conditions = [];
    }
    var s = new kerio.api.type.SubCondition();
    s.setFieldName(e);
    s.setComparator(t);
    s.setValue(i);
    this.conditions[this.conditions.length] = s;
    return this;
};

kerio.api.type.SearchQuery.prototype.eq = function(e, t) {
    return this.condition(e, "Eq", t);
};

kerio.api.type.SearchQuery.prototype.notEq = function(e, t) {
    return this.condition(e, "NotEq", t);
};

kerio.api.type.SearchQuery.prototype.lessThan = function(e, t) {
    return this.condition(e, "LessThan", t);
};

kerio.api.type.SearchQuery.prototype.greaterThan = function(e, t) {
    return this.condition(e, "GreaterThan", t);
};

kerio.api.type.SearchQuery.prototype.lessEq = function(e, t) {
    return this.condition(e, "LessEq", t);
};

kerio.api.type.SearchQuery.prototype.greaterEq = function(e, t) {
    return this.condition(e, "GreaterEq", t);
};

kerio.api.type.SearchQuery.prototype.like = function(e, t) {
    return this.condition(e, "Like", t);
};

kerio.api.type.SearchQuery.prototype.asc = function(e) {
    if (void 0 === this.orderBy) {
        this.orderBy = [];
    }
    var t = new kerio.api.type.SortOrder();
    t.setColumnName(e);
    t.setDirection(kerio.api.enums.SortDirection.Asc);
    this.orderBy[this.orderBy.length] = t;
    return this;
};

kerio.api.type.SearchQuery.prototype.desc = function(e) {
    if (void 0 === this.orderBy) {
        this.orderBy = [];
    }
    var t = new kerio.api.type.SortOrder();
    t.setColumnName(e);
    t.setDirection(kerio.api.enums.SortDirection.Desc);
    this.orderBy[this.orderBy.length] = t;
    return this;
};

kerio.api.type.Change.prototype.getFolderType = function() {
    if (-1 !== this.itemId.indexOf("/mail/")) {
        return kerio.api.enums.folders.FolderType.FMail;
    } else {
        if (-1 !== this.itemId.indexOf("/event/") || -1 !== this.itemId.indexOf("/occurrence/")) {
            return kerio.api.enums.folders.FolderType.FCalendar;
        } else {
            if (-1 !== this.itemId.indexOf("/contact/")) {
                return kerio.api.enums.folders.FolderType.FContact;
            } else {
                if (-1 !== this.itemId.indexOf("/task/")) {
                    return kerio.api.enums.folders.FolderType.FTask;
                } else {
                    if (-1 !== this.itemId.indexOf("/note/")) {
                        return kerio.api.enums.folders.FolderType.FNote;
                    } else {
                        return;
                    }
                }
            }
        }
    }
};

kerio.api.type.Change.prototype.setItemId = function(e) {
    this.itemId = e;
    if (-1 !== this.itemId.indexOf("/mail/")) {
        this.itemType = kerio.api.enums.changes.ItemType.itMail;
    } else {
        if (-1 !== this.itemId.indexOf("/event/") || -1 !== this.itemId.indexOf("/occurrence/")) {
            this.itemType = kerio.api.enums.changes.ItemType.itCalendar;
        } else {
            if (-1 !== this.itemId.indexOf("/contact/")) {
                this.itemType = kerio.api.enums.changes.ItemType.itContact;
            } else {
                if (-1 !== this.itemId.indexOf("/task/")) {
                    this.itemType = kerio.api.enums.changes.ItemType.itTask;
                } else {
                    if (-1 !== this.itemId.indexOf("/note/")) {
                        this.itemType = kerio.api.enums.changes.ItemType.itNote;
                    } else {
                        this.itemType = void 0;
                    }
                }
            }
        }
    }
};

if (!window.kerio) {
    window.kerio = {};
}

if (!kerio.api) {
    kerio.api = {};
}

kerio.api.settings = function() {
    if (kerio.api.settings && kerio.api.settings._isInitialized) {
        return kerio.api.settings;
    }
    var e = kerio.api.settings && kerio.api.settings.HOST_NAME || "", t = window.document.location && window.document.location.protocol && 0 === window.document.location.protocol.indexOf("https") || !1, i = window.document.location && window.document.location.host || "", s = {};
    while (e.length > 0 && "/" === e[e.length - 1]) {
        e = e.substring(0, e.length - 1);
    }
    if (e.length > 0) {
        var n = e.match(/http[s]?:\/\/(.[^\/]*)/);
        if (n && n.length > 1) {
            i = n[1];
            t = 0 === e.indexOf("https");
        }
    }
    s.HOST_NAME = e;
    s.WS_PATH = t && "wss://" + i + "/webmail/ws/im" || "ws://" + i + "/webmail/ws/im";
    s.API_PATH = s.HOST_NAME + "/webmail/api/jsonrpc/";
    s.FILE_UPLOAD_PATH = s.API_PATH + "upload";
    s.ATTACHMENT_UPLOAD_PATH = s.API_PATH + "attachment-upload";
    s._isInitialized = !0;
    return s;
}();

if (void 0 === kerio.api.socketImpl) {
    kerio.api.socketImpl = {};
}

window.onbeforeunload = function() {
    kerio.api.socketImpl._doDisconnect();
};

kerio.api.socketImpl._updateLog = function() {};

kerio.api.socketImpl.Const = {
    CONNECTING: 0,
    OPEN: 1,
    CLOSING: 2,
    CLOSED: 3
};

kerio.api.socketImpl._requestCounter = 1;

kerio.api.socketImpl._callbackQueue = {};

kerio.api.socketImpl._activeSubscriptionsIds = {};

kerio.api.socketImpl._requestQueue = [];

kerio.api.socketImpl._reconnectInterval = 5e3;

kerio.api.socketImpl._debugLog = [];

kerio.api.socketImpl._debugSocketId = 1;

kerio.api.socketImpl._debugAllSockets = [];

kerio.api.socketImpl.onDisconnect = function() {};

kerio.api.socketImpl.onConnect = function() {};

kerio.api.socketImpl._hasSomeSuccessfulInit = void 0;

kerio.api.socketImpl.safariSecureWebSocketCallback = function() {};

kerio.api.socketImpl.callMethod = function(e, t, i, s) {
    var n, o, r = kerio.api.socketImpl, a = r._requestCounter++;
    if (!r.webSocket) {
        r._init(window.location.href.indexOf("debugWebSocket=true") >= 0);
    }
    o = {
        jsonrpc: "2.0",
        id: a,
        method: e,
        params: t
    };
    n = e.indexOf(".subscribe") >= 0;
    r._callbackQueue[a] = {
        jsonData: o,
        timeout: i.timeout || 12e4,
        settings: i,
        scope: this,
        callback: kerio.api.impl.callMethodCallback,
        id: a,
        isSubscriptionCallback: n
    };
    if (n) {
        r._activeSubscriptionsIds[e.replace(".subscribe", ".unsubscribe")] = a;
    }
    if (r.isReady()) {
        r._doSend(Ext.JSON.encode(o));
    } else {
        r._requestQueue.push(o);
    }
    return r._callbackQueue[a];
};

kerio.api.socketImpl._init = function(e) {
    var t = kerio.api.socketImpl, i = kerio.api.settings.WS_PATH;
    t.enableDebugSocket = e;
    if (void 0 !== t.onBeforeInit) {
        t.onBeforeInit();
    }
    if (t.webSocket) {
        t._debugMsg("trying to open WebSocket, but some is still active -> exit");
        return;
    }
    if (e) {
        t.webSocket = new WebSocket("ws://localhost:8081");
        t._debugMsg("opened at ws://localhost:8081");
    } else {
        t.webSocket = new WebSocket(i);
        t._debugMsg("opened at " + i);
    }
    t.webSocket.socketId = t._debugSocketId++;
    t._debug && t._debugAllSockets.push(t.webSocket);
    t.webSocket.onopen = Ext.bind(t._onOpen, this);
    t.webSocket.onclose = Ext.bind(t._onClose, this);
    t.webSocket.onmessage = Ext.bind(t._onMessage, this);
    t.webSocket.onerror = Ext.bind(t._onError, this);
    if (t.webSocket.readyState === t.Const.CLOSED) {
        t._debugMsg("WebSocket closed during creation!");
        delete t.webSocket;
    }
};

kerio.api.socketImpl.isReady = function() {
    var e = kerio.api.socketImpl;
    return e.webSocket && e.webSocket.readyState === e.Const.OPEN;
};

kerio.api.socketImpl._onOpen = function(e) {
    var t, i, s = kerio.api.socketImpl;
    if (!s.isReady()) {
        console.warn("WebSocket open handler called, but it is not ready yet", e, s.webSocket);
        return;
    }
    if (kerio.api.socketImpl._isOpened) {
        s._debugMsg("open handler called again -> canceling");
        return;
    }
    kerio.api.socketImpl._isOpened = !0;
    s._debugMsg("CONNECTED: ", e);
    Ext.defer(function() {
        if (!s.webSocket) {
            s._debugMsg("Socket is already closed - connect wont be performed");
            return;
        }
        s._hasSomeSuccessfulInit = !0;
        s.onConnect(e);
        for (t = 0; t < s._requestQueue.length; t++) {
            i = s._requestQueue[t];
            s._doSend(Ext.JSON.encode(i));
        }
        s._requestQueue = [];
    }, 1);
};

kerio.api.socketImpl._onClose = function(e) {
    var t, i, s = kerio.api.socketImpl;
    s._debugMsg("CLOSED: ", e);
    for (t in s._callbackQueue) {
        if (s._callbackQueue.hasOwnProperty(t)) {
            i = s._callbackQueue[t].settings;
            i.failure && i.failure.apply(i.scope, [ {}, {} ]);
        }
    }
    s._callbackQueue = {};
    s._requestQueue = [];
    s._activeSubscriptionsIds = {};
    delete s.webSocket;
    delete kerio.api.socketImpl._isOpened;
    s._debugMsg("callback queue cleared");
    s.onDisconnect(e);
    s._deferReconnect();
    if (!s._hasSomeSuccessfulInit) {
        s._hasSomeSuccessfulInit = !1;
    }
    s.safariSecureWebSocketCallback();
};

kerio.api.socketImpl._deferReconnect = function() {
    var e = kerio.api.socketImpl;
    e._debugMsg("reconnect: defering reconnect");
    if (e.webSocket) {
        e._debugMsg("reconnect: already connected -> exiting", e.webSocket);
        return;
    }
    window.setTimeout(function() {
        e._debugMsg("reconnect: connecting...", e.webSocket);
        if (kerio.api.impl.Ajax.isSessionExpired) {
            e._debugMsg("reconnect: do not reconnect -> session has expired");
        } else {
            if (!e.webSocket) {
                e._init(e.enableDebugSocket);
            }
        }
        e._deferReconnect();
    }, e._reconnectInterval);
};

kerio.api.socketImpl._onMessageDebug = function(e) {
    var t = kerio.api.socketImpl;
    t._updateLog("IN: " + e.data);
};

kerio.api.socketImpl._onMessage = function(e) {
    var t, i = kerio.api.socketImpl, s = Ext.JSON.decode(e.data), n = s.id, o = s.result, r = i._callbackQueue[n], a = r && r.scope, l = s.error;
    if (!r) {
        console.error("WebSocket callback error: cannot find callback with ID " + n + ", check callbacks in progress: ", i._callbackQueue);
        return;
    }
    kerio.api.socketImpl._onMessageDebug.apply(kerio.api.socketImpl._onMessageDebug, arguments);
    !i._callbackQueue[n].isSubscriptionCallback && delete i._callbackQueue[n];
    if (r && r.jsonData.method.indexOf(".unsubscribe") >= 0) {
        t = i._activeSubscriptionsIds[r.jsonData.method];
        if (t) {
            delete i._callbackQueue[t];
            delete i._activeSubscriptionsIds[r.jsonData.method];
        } else {
            if (r.jsonData.method.indexOf(".unsubscribe") >= 0) {
                i._debugMsg("ERROR: ", "subscription error: callback pairing for " + r.jsonData.method + "is not defined", i._activeSubscriptionsIds, i._callbackQueue);
            }
        }
    }
    i._debugMsg("RECIEVED: ", e, e.data);
    if (!l) {
        Ext.callback(r.settings.success, a, [ o, r ]);
    } else {
        l.method = r && r.jsonData.method;
        l.requestData = r && r.jsonData;
        Ext.callback(r.settings.failure, a, [ l, r ]);
        if (!r.settings.failure && !r.settings.callback) {
            console.error("Server error: " + l.message, l);
        }
    }
    Ext.callback(r.settings.callback, a, [ s, r ]);
};

kerio.api.socketImpl._onError = function(e) {
    var t = kerio.api.socketImpl;
    t._debugMsg("ERROR: ", e);
};

kerio.api.socketImpl._doSend = function(e) {
    var t = kerio.api.socketImpl;
    t._waitForConnection(function() {
        if (!t.webSocket) {
            t._debugMsg("Socket is already closed - sent wont be performed");
            return;
        }
        t._updateLog("OUT: " + e);
        t._debugMsg("SENT: ", e);
        t.webSocket.send(e);
    });
};

kerio.api.socketImpl._waitForConnection = function(e) {
    var t = kerio.api.socketImpl;
    if (t.isReady()) {
        e();
    } else {
        t._debugMsg("Socket is not ready yed - defering");
        window.setTimeout(function() {
            t._waitForConnection(e, 5);
        }, 5);
    }
};

kerio.api.socketImpl._doDisconnect = function() {
    var e = kerio.api.socketImpl;
    e._debugMsg("Closing connection");
    if (e.webSocket) {
        e.webSocket.close();
        delete e.webSocket;
    }
};

kerio.api.socketImpl._debugMsg = function() {
    if (kerio.api.socketImpl._debug) {
        var e = [].splice.call(arguments, 0);
        if (e.length && "string" == typeof e[0]) {
            e[0] = "WebSockket: " + e[0];
        } else {
            e.unshift("WebSocket: ");
        }
        console.log.apply(console, e);
    }
};

if (void 0 === kerio.api.impl) {
    kerio.api.impl = {};
}

kerio.api.impl.Ajax = {
    loggedOut: !1,
    requestCounter: 1,
    _contentTypeRegExp: new RegExp("^application/json-rpc(;.*)?$"),
    TOKEN_COOKIE_NAME: "TOKEN_CONNECT_WEBMAIL",
    SESSION_COOKIE_NAME: "SESSION_CONNECT_WEBMAIL",
    IGNORE_MODIFIED_TIMEOUT: 200,
    _watermarks: {},
    request: function(e) {
        e = this._buildRequestCfg(e);
        if (e) {
            return this._sendRequest(e);
        }
    },
    _sendRequest: function(e) {
        return e.isFileUpload ? kerio.wm.utils.AjaxUpload.request(e) : Ext.Ajax.request(e);
    },
    _buildRequestCfg: function(e) {
        var t, i, s, n, o, r;
        if (this.loggedOut && (!e.jsonData || e.jsonData.method !== kerio.api.Session.Def.login.name)) {
            return !1;
        }
        if (kerio.api.impl.Ajax.isSessionExpired && e.jsonData && e.jsonData.method !== kerio.api.Session.Def.login.name) {
            s = {
                statusText: "OK",
                status: 200,
                decoded: {
                    jsonrpc: e.jsonData.jsonrpc,
                    id: e.jsonData.id,
                    error: {
                        code: kerio.api.consts.ErrorCodeSessionExpired,
                        message: k_tr("Session expired", "common")
                    }
                }
            };
            s = Ext.Ajax._extendResponse(s);
            if (e.operation) {
                n = e.scope;
                if (n instanceof Ext.data.proxy.Proxy) {
                    n.fireEvent("exception", n, s, e.operation);
                }
            } else {
                Ext.Function.defer(this._callCustomCallback, 1, this, [ "failure", e, s ]);
            }
            return null;
        }
        if (e.jsonData && e.jsonData.method === kerio.api.Session.Def.logout.name) {
            this.loggedOut = !0;
        }
        if (e.jsonData && e.jsonData.id) {
            e.jsonData.id = this.requestCounter++;
        }
        if (!e.isFileUpload) {
            if (this._isGetByIdMethod(e.jsonData.method) && this._changedItems && new Date() - this._changedItems.time <= this.IGNORE_MODIFIED_TIMEOUT) {
                o = e.jsonData.params.ids || [ e.jsonData.params.id ];
                i = this._changedItems.items;
                for (r = 0; r < o.length; r++) {
                    if (i.hasOwnProperty(o[r])) {
                        t = !0;
                        break;
                    }
                }
            }
        }
        e.scope = {
            callback: e.callback,
            scope: e.scope
        };
        if (t) {
            e.scope.changedItems = {
                items: i,
                inputIds: o
            };
        }
        e.callback = this._requestCallback;
        return e;
    },
    _requestCallback: function(e, t, i) {
        var s, n, o, r, a, l = kerio.api.impl.Ajax, d = kerio.api.impl.sessionExpired, c = !1;
        if (!t && i.request.aborted) {
            l._callCustomCallback("abort", e, i);
            return;
        }
        if ("POST" === e.method) {
            c = !t && i.status > 12e3 && i.status <= 12157;
            c = c || Ext.isSafari && 200 === i.status && "" === i.responseText;
        }
        if (i.timedout || 0 === i.status || c) {
            l._createErrorResponse(e, i, i.timedout ? kerio.api.consts.ErrorCodeTimedout : kerio.api.consts.ErrorCodeCommunicationFailure);
        } else {
            if ("POST" === e.method) {
                if (l._checkContentType(i)) {
                    l._decodeResponse(i);
                } else {
                    return;
                }
            }
        }
        if (e.jsonData && e.jsonData.method === kerio.api.Session.Def.login.name) {
            l.loggedOut = !1;
        }
        if (l.loggedOut) {
            if (d && e.jsonData && e.jsonData.method === kerio.api.Session.Def.logout.name) {
                d.callback.call(d.scope || this, !0, i, e);
            }
            return;
        }
        if (i.hasErrors()) {
            if (i.hasErrors(kerio.api.consts.ErrorCodeSessionExpired)) {
                kerio.api.impl.Ajax.isSessionExpired = !0;
                if (d) {
                    if (d.callback.call(d.scope || this, !1, i, e)) {
                        return;
                    }
                }
            }
            if (i.hasErrors(kerio.api.consts.ErrorCodeQuotaReached)) {
                s = Ext.ComponentQuery.query("#quotaWarning");
                if (s.length > 0) {
                    s[0].fireEvent("updateQuota");
                }
            }
            if (i.hasErrors(kerio.api.consts.ErrorCodeNoSuchEntity) && this.changedItems) {
                n = i.decoded && (i.decoded.error || i.decoded.result.errors);
                o = this.changedItems.items;
                r = this.changedItems.inputIds;
                if (n) {
                    if (!Ext.isArray(n)) {
                        n = [ n ];
                    }
                    for (a = 0; a < n.length; a++) {
                        if (o.hasOwnProperty(r[n[a].inputIndex])) {
                            i.stopErrorProcessing();
                            break;
                        }
                    }
                }
            }
        } else {
            if (e.jsonData) {
                if (e.jsonData.method === kerio.api.Session.Def.login.name) {
                    kerio.api.impl.Ajax.isSessionExpired = !1;
                } else {
                    if (e.jsonData.method === kerio.api.Changes.Def.get.name) {
                        l._filterChanges(i);
                    } else {
                        if (l._isSetOrCreateMethod(e.jsonData.method)) {
                            l._storeWatermarks(i);
                        }
                    }
                }
            }
        }
        if (this.callback === kerio.api.impl.callMethodCallback) {
            if (!1 === l._handleResponseError(e, i)) {
                l._callCustomCallback("success", e, i);
            }
            l._callCustomCallback("callback", e, i);
        } else {
            this.callback.apply(this.scope, arguments);
            if (!0 !== i._suppressInternalErrorHandler) {
                l._handleResponseError(e, i);
            }
        }
    },
    _filterChanges: function(e) {
        var t, i, s, n, o = this._watermarks, r = {}, a = 0, l = {};
        if (!e.hasErrors()) {
            t = [];
            i = e.decoded.result.list;
            for (n = 0; n < i.length; n++) {
                s = i[n];
                if (!o.hasOwnProperty(s[kerio.api.type.Change.fields.watermark])) {
                    t.push(s);
                    if (!1 === s[kerio.api.type.Change.fields.isFolder] && this._isModifiedChangeType(s)) {
                        r[s[kerio.api.type.Change.fields.itemId]] = 1;
                        a++;
                    }
                } else {
                    l[s[kerio.api.type.Change.fields.watermark]] = 1;
                }
            }
            if (a) {
                window.clearTimeout(this._timeoutHandler);
                this._changedItems = {
                    time: new Date(),
                    items: r
                };
                this._timeoutHandler = Ext.defer(function() {
                    delete this._changedItems;
                }, this.IGNORE_MODIFIED_TIMEOUT, this);
            }
            if (t.length < i.length) {
                i.splice(0, i.length).push.apply(i, t);
                for (n in l) {
                    if (l.hasOwnProperty(n)) {
                        delete o[n];
                    }
                }
            }
        }
    },
    _isModifiedChangeType: function(e) {
        var t = e[kerio.api.type.Change.fields.type];
        return kerio.api.enums.changes.ChangeType.chtModified === t || kerio.api.enums.changes.ChangeType.chtModifiedMetadata === t || kerio.api.enums.changes.ChangeType.chtReadFlagChanged === t;
    },
    _isSetOrCreateMethod: function(e) {
        return this._isSetMethod(e) || this._isCreateMethod(e);
    },
    _isSetMethod: function(e, t) {
        return this._isMethodType(e, "set", t);
    },
    _isCreateMethod: function(e) {
        return this._isMethodType(e, "create");
    },
    _isMethodType: function(e, t, i) {
        if (!e || !e.split) {
            return !1;
        }
        var s = e.split(".");
        e = s[1];
        return e && 0 === e.indexOf(t) && (void 0 === i || s[0] !== i);
    },
    _isGetByIdMethod: function(e) {
        if (!e || !e.split) {
            return !1;
        }
        if (e === kerio.api.Events.Def.getEventUpdates.name || e === kerio.api.Events.Def.removeEventUpdates.name) {
            return !0;
        }
        e = e.split(".")[1];
        return e && 0 === e.indexOf("getById");
    },
    _createErrorResponse: function(e, t, i) {
        t.decoded = {
            jsonrpc: e.isFileUpload ? "" : e.jsonData.jsonrpc,
            id: e.isFileUpload ? "" : e.jsonData.id,
            error: {
                code: i,
                message: k_tr("Please check your Internet connection", "common"),
                data: {
                    messageParameters: {
                        positionalParameters: [],
                        plurality: 1
                    }
                }
            }
        };
        return t.decoded;
    },
    _checkContentType: function(e) {
        var t, i = e.getResponseHeader("Content-Type") || "", s = e.responseText || "";
        if (!this._contentTypeRegExp.test(i)) {
            if (this._adoptMultiServerError(e)) {
                return !0;
            }
            t = this._isOurResponse(e);
            if (0 === i.indexOf("text/html") || 0 === i.indexOf("text/plain") || "" === i) {
                if (!t) {
                    if (!Ext.getCmp("foreignHtmlDialog")) {
                        Ext.create("kerio.wm.view.ForeignHtmlDialog", e);
                    }
                    return !1;
                }
            }
            s = e.status + " " + s;
            throw new Error("Unexpected Content-Type:" + i + " " + Ext.util.Format.stripTags(s.substring(0, kerio.wm.Constants.WEBASSIST_MESSAGE_LENGTH)));
        }
        return !0;
    },
    _isOurResponse: function(e) {
        var t = e.getResponseHeader("Server") || "";
        return t.indexOf("Kerio Connect") >= 0 || "WebServer" === t;
    },
    _adoptMultiServerError: function(e) {
        var t, i = e.request.options;
        if ("true" === e.getResponseHeader("Multi-Server") && (502 === e.status || 504 === e.status)) {
            t = {
                jsonrpc: i.isFileUpload ? "" : i.jsonData.jsonrpc,
                id: i.isFileUpload ? "" : i.jsonData.id,
                error: {
                    code: kerio.api.consts.ErrorCodeMultiServerBackendMaintenance,
                    message: k_tr("Server is undergoing maintenance. Please try again later.", "common"),
                    data: {
                        messageParameters: {
                            positionalParameters: [],
                            plurality: 1
                        }
                    }
                }
            };
            e.status = 200;
            e.responseText = Ext.encode(t);
            return !0;
        }
        return !1;
    },
    _decodeResponse: function(e) {
        var t, i, s, n = e.responseText;
        i = Ext.decode(n, !0);
        if (!i) {
            if (200 === e.status) {
                t = e.request && e.request.options && e.request.options.jsonData;
                if ("" === n && t && t.method === kerio.api.Changes.Def.get.name) {
                    i = this._createErrorResponse(e.request.options, e, kerio.api.consts.ErrorCodeCommunicationFailure);
                } else {
                    s = Ext.util.Format.stripTags(n.substring(0, this._WEBASSIST_MESSAGE_LENGTH));
                    throw new Error("-32603 Invalid response. " + e.status + " " + s);
                }
            } else {
                throw new Error("Unexpected http status: " + e.status + " " + e.statusText);
            }
        }
        if (void 0 === i.error && void 0 === i.result) {
            s = Ext.util.Format.stripTags(n.substring(0, this._WEBASSIST_MESSAGE_LENGTH));
            throw new Error("-32603 Invalid JSON-RPC2 response. " + s);
        }
        e.decoded = i;
    },
    _storeWatermarks: function(e) {
        if (!e.hasErrors()) {
            this._walkData(e.decoded, this._storeWatermark, this);
        }
    },
    _storeWatermark: function(e, t, i) {
        if (0 !== i) {
            this._watermarks[i] = 1;
        }
    },
    _walkData: function(e, t, i) {
        var s, n, o = kerio.api.type.Change.fields.watermark;
        if (Ext.isArray(e)) {
            for (s = 0; s < e.length; s++) {
                if (e[s].hasOwnProperty(o)) {
                    t.call(i || this, e[s], s, e[s][o]);
                }
                this._walkData(e[s], t, i);
            }
        } else {
            if (Ext.isObject(e)) {
                for (n in e) {
                    if (e.hasOwnProperty(n)) {
                        if (e[n].hasOwnProperty(o)) {
                            t.call(i || this, e[n], n, e[n][o]);
                        }
                        this._walkData(e[n], t, i);
                    }
                }
            }
        }
    },
    _handleResponseError: function(e, t) {
        if (!t.hasErrors()) {
            return !1;
        }
        this._callCustomCallback("failure", e, t);
        if (!0 !== t._suppressInternalErrorHandler) {
            if (-1 !== t.status) {
                this._internalErrorHandler(t.decoded.error || t.decoded.result.errors);
            }
        }
        return !0;
    },
    _internalErrorHandler: function(e) {
        kerio.wm.view.Msg.serverErrors(e);
    },
    _callCustomCallback: function(e, t, i) {
        var s, n, o = t.settings || {}, r = o[e], a = t.isFileUpload ? {} : t.jsonData;
        if (r) {
            n = o.scope || window;
            switch (e) {
              case "success":
                s = i.decoded.result;
                if (void 0 !== o.responseType) {
                    kerio.api.applyType(s, o.responseType, !0);
                }
                break;

              case "failure":
                s = i.decoded.error || i.decoded.result.errors;
                break;

              case "abort":
                s = null;
                break;

              default:
                s = i.decoded;
                if (void 0 !== o.responseType) {
                    kerio.api.applyType(s.result, o.responseType, !0);
                }
            }
            r.call(n, s, {
                method: a.method,
                params: a.params,
                settings: o,
                response: i
            });
        }
    },
    abort: function(e) {
        if (e instanceof Promise) {
            e = e.request;
        }
        Ext.Ajax.abort(e);
    },
    setToken: function(e) {
        var t = kerio.api.impl.Ajax.TOKEN_COOKIE_NAME + "=" + e + ";path=/";
        if (Ext.isSecure) {
            t += "; secure";
        }
        document.cookie = t;
    },
    getToken: function() {
        var e;
        if (!kerio.api.impl.Ajax._tokenCookieRegExp) {
            kerio.api.impl.Ajax._tokenCookieRegExp = new RegExp(kerio.api.impl.Ajax.TOKEN_COOKIE_NAME + "=([a-z0-9\\-]+)", "i");
        }
        e = kerio.api.impl.Ajax._tokenCookieRegExp.exec(document.cookie);
        if (null !== e) {
            e = e[1];
        }
        return e || null;
    }
};

kerio.api.impl.Request = function(e) {
    this.request = e;
};

kerio.api.impl.Request.prototype = {
    abort: function(e) {
        kerio.api.impl.Ajax.abort(this.request);
    }
};

kerio.api.callMethod = function(e, t, i, s) {
    var n, o, r;
    r = function(n, r) {
        i = i || {};
        var a = i.success, l = i.failure, d = i.callback, c = i.scope || window;
        if (!a && !l && !d && i.scope) {}
        i.success = function(e, t) {
            n({
                result: e,
                params: t.params,
                response: t.response,
                settings: t.settings || {}
            });
            Ext.callback(a, c, arguments);
        };
        i.failure = function(e, t) {
            r({
                result: e,
                params: t.params,
                response: t.response,
                settings: t.settings || {}
            });
            Ext.callback(l, c, arguments);
        };
        o = kerio.api.callMethodWithoutPromise(e, t, i, s);
    };
    n = new Promise(r);
    if (Ext.isChrome || Ext.isGecko && !Ext.isIE11) {
        n["catch"](function() {});
    }
    n.request = o;
    return n;
};

kerio.api.callMethodWithoutPromise = function(e, t, i, s) {
    var n, o, r = kerio.api.settings.API_PATH;
    i = i || {};
    if (void 0 !== s) {
        i.responseType = s;
    }
    if (void 0 !== i.onSuccess) {
        i.success = i.onSuccess;
        delete i.onSuccess;
    }
    if (void 0 !== i.onError) {
        i.failure = i.onError;
        delete i.onError;
    }
    if (0 === e.indexOf("im.")) {
        return kerio.api.socketImpl.callMethod.apply(kerio.api.socketImpl, arguments);
    }
    n = Ext.create("Ext.data.Request", {
        url: r,
        method: "POST",
        timeout: i.timeout || 12e4,
        settings: i,
        scope: this,
        headers: {
            Accept: "application/json-rpc",
            "Content-Type": "application/json"
        },
        callback: kerio.api.impl.callMethodCallback
    });
    o = kerio.api.impl.Ajax.getToken();
    if (null !== o) {
        n.headers["X-Token"] = o;
    }
    n.jsonData = {
        jsonrpc: "2.0",
        id: 1,
        method: e,
        params: t
    };
    return new kerio.api.impl.Request(kerio.api.impl.Ajax.request(n));
};

kerio.api.impl.callMethodCallback = function(e, t, i) {
    var s, n, o = e.jsonData.method, r = e.settings, a = {
        method: o,
        params: e.jsonData.params,
        settings: r
    }, l = r.callback, d = r.failure, c = r.abort, h = r.success;
    if (void 0 !== i.decoded) {
        s = i.decoded;
    } else {
        s = Ext.decode(i.responseText, !0);
    }
    if (null === s) {
        t = !1;
    }
    n = r.scope || window;
    kerio.api._callCbHandler(l, n, s, a);
    if (!t) {
        if (i.request.aborted) {
            kerio.api._callCbHandler(c, n, s, a);
        } else {
            kerio.api._callCbHandler(d, n, void 0, a, "Fatal error - bad or no response from server when calling " + o);
        }
    } else {
        if (s.error) {
            kerio.api._callCbHandler(d, n, s.error, a, "Unhandled error from server when calling " + o);
        } else {
            if (s.result.errors && s.result.errors.length > 0) {
                kerio.api._callCbHandler(d, n, s.result.errors, a, "Unhandled error from server when calling " + o);
            } else {
                if (void 0 !== h) {
                    if (void 0 !== r.responseType) {
                        kerio.api.applyType(s.result, r.responseType, !0);
                    }
                    h.call(n, s.result, a);
                }
            }
        }
    }
};

kerio.api.copyMethods = function(e, t) {
    var i;
    for (i in e) {
        if (e.hasOwnProperty(i)) {
            t[i] = e[i];
        }
    }
};

kerio.api.applyType = function(e, t, i) {
    if (void 0 === e) {
        return;
    }
    var s;
    if (e instanceof Array) {
        for (s in e) {
            if (e.hasOwnProperty(s)) {
                kerio.api.applyType(e[s], t);
            }
        }
    } else {
        if (t instanceof Object) {
            if (!i) {}
            kerio.api.copyMethods(t.prototype, e);
        } else {
            if (void 0 !== kerio.api.type[t]) {
                if ("Change" !== t) {}
                kerio.api.copyMethods(kerio.api.type[t].prototype, e);
            } else {
                throw new Error("INTERNAL ERROR: Undefined type " + t);
            }
        }
    }
};

kerio.api._callCbHandler = function(e, t, i, s, n) {
    if (void 0 !== e) {
        e.call(t, i, s);
    } else {
        if (n) {
            throw new Error(n);
        }
    }
};

!function(e) {
    if (e.Promise) {
        return;
    }
    var t = "function" == typeof window.setImmediate && window.setImmediate || function(e) {
        setTimeout(e, 0);
    }, i = Array.isArray || function(e) {
        return "[object Array]" === Object.prototype.toString.call(e);
    };
    function s(e, t) {
        return function() {
            e.apply(t, arguments);
        };
    }
    function n(e, t, i) {
        var s = !1;
        try {
            e(function(e) {
                if (s) {
                    return;
                }
                s = !0;
                t(e);
            }, function(e) {
                if (s) {
                    return;
                }
                s = !0;
                i(e);
            });
        } catch (n) {
            if (s) {
                return;
            }
            s = !0;
            i(n);
        }
    }
    function o(e) {
        var i = this;
        if (null === this._state) {
            this._deferreds.push(e);
            return;
        }
        t(function() {
            var t, s = i._state ? e.onFulfilled : e.onRejected;
            if (null === s) {
                (i._state ? e.resolve : e.reject)(i._value);
                return;
            }
            try {
                t = s(i._value);
            } catch (n) {
                e.reject(n);
                return;
            }
            e.resolve(t);
        });
    }
    function r() {
        for (var e = 0, t = this._deferreds.length; t > e; e++) {
            o.call(this, this._deferreds[e]);
        }
        this._deferreds = null;
    }
    function a(e) {
        this._state = !1;
        this._value = e;
        r.call(this);
    }
    function l(e) {
        try {
            if (e === this) {
                throw new TypeError("A promise cannot be resolved with itself.");
            }
            if (e && ("object" == typeof e || "function" == typeof e)) {
                var t = e.then;
                if ("function" == typeof t) {
                    n(s(t, e), s(l, this), s(a, this));
                    return;
                }
            }
            this._state = !0;
            this._value = e;
            r.call(this);
        } catch (i) {
            a.call(this, i);
        }
    }
    function d(e) {
        if ("object" != typeof this) {
            throw new TypeError("Promises must be constructed via new");
        }
        if ("function" != typeof e) {
            throw new TypeError("not a function");
        }
        this._state = null;
        this._value = null;
        this._deferreds = [];
        n(e, s(l, this), s(a, this));
    }
    function c(e, t, i, s) {
        this.onFulfilled = "function" == typeof e ? e : null;
        this.onRejected = "function" == typeof t ? t : null;
        this.resolve = i;
        this.reject = s;
    }
    d.prototype["catch"] = function(e) {
        return this.then(null, e);
    };
    d.prototype.then = function(e, t) {
        var i = this;
        return new d(function(s, n) {
            o.call(i, new c(e, t, s, n));
        });
    };
    d.all = function() {
        var e = Array.prototype.slice.call(1 === arguments.length && i(arguments[0]) ? arguments[0] : arguments);
        return new d(function(t, i) {
            if (0 === e.length) {
                return t([]);
            }
            var s, n = e.length;
            function o(s, r) {
                try {
                    if (r && ("object" == typeof r || "function" == typeof r)) {
                        var a = r.then;
                        if ("function" == typeof a) {
                            a.call(r, function(e) {
                                o(s, e);
                            }, i);
                            return;
                        }
                    }
                    e[s] = r;
                    if (0 === --n) {
                        t(e);
                    }
                } catch (l) {
                    i(l);
                }
            }
            for (s = 0; s < e.length; s++) {
                o(s, e[s]);
            }
        });
    };
    d.resolve = function(e) {
        if (e && "object" == typeof e && e.constructor === d) {
            return e;
        }
        return new d(function(t) {
            t(e);
        });
    };
    d.reject = function(e) {
        return new d(function(t, i) {
            i(e);
        });
    };
    d.race = function(e) {
        return new d(function(t, i) {
            for (var s = 0, n = e.length; n > s; s++) {
                e[s].then(t, i);
            }
        });
    };
    d._setImmediateFn = function(e) {
        t = e;
    };
    e.Promise = d;
}(this);

Ext.define("kerio.wm.ExtJsFix", {
    singleton: !0,
    constructor: function() {
        Ext.onReady(function() {
            Ext.EventManager.removeResizeListener(Ext.WindowManager._onContainerResize, Ext.WindowManager);
            Ext.EventManager.onWindowResize(Ext.WindowManager._onContainerResize, Ext.WindowManager, {
                delay: 5
            });
        });
        if (Ext.isGecko) {
            !function() {
                var e = new Date(2008, 0, 1, 23, 30, 0, 0), t = e.getTimezoneOffset(), i = +e;
                e.setMinutes(e.getMinutes() + 30);
                if (i >= +e && t === e.getTimezoneOffset()) {
                    Ext.override(Ext.picker.Time, {
                        initDate: [ 2014, 9, 1 ]
                    });
                }
            }();
        }
        Ext.override(Ext.form.field.ComboBox, {
            componentCls: "x-form-combobox"
        });
        Ext.override(Ext.form.field.Trigger, {
            triggerWidth: 30
        });
        Ext.override(Ext.form.field.Date, {
            componentCls: "x-form-combobox"
        });
        Ext.override(Ext.data.Model, {
            join: function() {
                this.stores = this.stores || [];
                return this.callOverridden(arguments);
            },
            _getNewPropertyDescriptors: function() {
                return {
                    __model: {
                        enumerable: !1,
                        configurable: !1,
                        value: this
                    }
                };
            }
        });
        Ext.Element.fly = Ext.Element.fly || Ext.fly;
        Ext.grid.Panel.prototype.collapseGroup = function(e) {
            var t = Ext.get(this.getView().id + "-bd-" + e);
            if (t) {
                this.features[0].collapse(t);
            }
        };
        Ext.grid.Panel.prototype.expandGroup = function(e) {
            var t = Ext.get(this.getView().id + "-bd-" + e);
            if (t) {
                this.features[0].expand(t);
            }
        };
        Ext.override(Ext.grid.feature.Grouping, {
            attachEvents: function() {
                var e = this, t = e.view, i = t.doRemove;
                t.on({
                    scope: e,
                    groupclick: e.onGroupClick,
                    rowfocus: e.onRowFocus
                });
                t.mon(t.store, {
                    scope: e,
                    groupchange: e.onGroupChange,
                    remove: {
                        fn: this.onRemove,
                        buffer: !0
                    },
                    add: e.onAdd,
                    update: e.onUpdate
                });
                if (e.enableGroupingMenu) {
                    e.injectGroupingMenu();
                }
                e.pruneGroupedHeader();
                e.lastGroupField = e.getGroupField();
                e.block();
                e.onGroupChange();
                e.unblock();
                t.doRemove = function(e, t) {
                    if (this.all.elements.length > t && e.internalId === this.all.elements[t].viewRecordId) {
                        i.apply(this, arguments);
                    }
                };
                this._storeEvents = !0;
            },
            enable: function() {
                if (!this._storeEvents) {
                    this.view.mon(this.view.store, {
                        scope: this,
                        groupchange: this.onGroupChange,
                        remove: {
                            fn: this.onRemove,
                            buffer: !0
                        },
                        add: this.onAdd,
                        update: this.onUpdate
                    });
                    this._storeEvents = !0;
                }
                this.callOverridden(arguments);
            },
            disable: function() {
                var e, t, i = this, s = i.view, n = s.store;
                if (this._storeEvents) {
                    s.mun(n, {
                        scope: this,
                        groupchange: this.onGroupChange,
                        remove: this.onRemove,
                        add: this.onAdd,
                        update: this.onUpdate
                    });
                    this._storeEvents = !1;
                }
                t = n.groupers.first();
                if (t) {
                    i.lastGroupIndex = t.sorterFn ? t : t.property;
                    i.block();
                    n.clearGrouping();
                    i.unblock();
                }
                i.callParent();
                e = i.view.headerCt.getMenu().down("#groupToggleMenuItem");
                if (e) {
                    e.setChecked(!1, !0);
                }
                i.refreshIf();
            }
        });
        Ext.override(Ext.menu.Menu, {
            initComponent: function() {
                var e = this.cls;
                this.callOverridden(arguments);
                if (e) {
                    this.addCls(e);
                }
            },
            onClick: function(e) {
                var t, i = this;
                if (i.disabled) {
                    e.stopEvent();
                    return;
                }
                t = "click" === e.type ? i.getItemFromEvent(e) : i.activeItem;
                if (t && t.isMenuItem) {
                    if (!t.menu || !i.ignoreParentClicks) {
                        t.onClick(e);
                    } else {
                        e.stopEvent();
                    }
                }
                if (t && !t.disabled) {
                    i.fireEvent("click", i, t, e);
                }
            },
            onBoxReady: function(e) {
                var t = this, i = Ext.baseCSSPrefix, s = "&#160;";
                t.callSuper(arguments);
                if (t.showSeparator) {
                    t.iconSepEl = t.layout.getRenderTarget().insertFirst({
                        cls: i + "menu-icon-separator",
                        html: s
                    });
                }
                t.focusEl = t.el.createChild({
                    cls: i + "menu-focus",
                    tabIndex: "-1",
                    html: s
                });
                t.mon(t.el, {
                    click: t.onClick,
                    mouseover: t.onMouseOver,
                    scope: t
                });
                t.mouseMonitor = t.el.monitorMouseLeave(100, t.onMouseLeave, t);
                if (t.showSeparator && (!Ext.isStrict && Ext.isIE || Ext.isIE6)) {
                    t.iconSepEl.setHeight(t.el.getHeight());
                }
                t.keyNav = Ext.create("Ext.menu.KeyNav", t);
                t.show();
            },
            showAt: function(e, t, i) {
                var s, n, o, r, a = 0;
                this.callOverridden(arguments);
                if (Ext.isArray(e)) {
                    t = e[1];
                }
                if (this.el && this.getHeight() < 30) {
                    s = Ext.getBody().getHeight();
                    n = this.items.items;
                    o = this.body.getFrameWidth("tb");
                    for (r = n.length - 1; r >= 0; r--) {
                        if (n[r].isVisible()) {
                            a = n[r].el.getTop(!0) + n[r].getHeight();
                            break;
                        }
                    }
                    a = Math.min(a + o, s);
                    this.setHeight(a);
                    if (t + a > s) {
                        this.el.setTop(s - a);
                    }
                }
            },
            beforeShow: function() {
                var e, t, i, s = Ext.menu.Separator;
                e = this.items.filterBy(function(e) {
                    return e.isVisible();
                });
                if (e.length) {
                    t = e.first();
                    for (i = 1; i < e.length; i++) {
                        if (t instanceof s && e.getAt(i) instanceof s) {
                            t.hide();
                        }
                        t = e.getAt(i);
                    }
                    if (e.last() instanceof s) {
                        e.last().hide();
                    }
                }
                return this.callOverridden(arguments);
            }
        });
        Ext.override(Ext.menu.Item, {
            renderTpl: [ '<tpl if="plain">', "{text}", "<tpl else>", '<a id="{id}-itemEl" class="' + Ext.baseCSSPrefix + 'menu-item-link" href="{href}" <tpl if="hrefTarget">target="{hrefTarget}"</tpl> hidefocus="true" unselectable="on">', '<img id="{id}-iconEl" src="{icon}" class="' + Ext.baseCSSPrefix + 'menu-item-icon {iconCls}" />', '<span id="{id}-textEl" class="' + Ext.baseCSSPrefix + 'menu-item-text" <tpl if="arrowCls">style="margin-right: 17px;"</tpl> >{text}</span>', '<tpl if="arrowCls"><img id="{id}-arrowEl" src="{blank}" class="{arrowCls}" /></tpl>', "</a>", "</tpl>" ]
        });
        Ext.override(Ext.Editor, {
            onFieldBlur: function(e, t) {
                var i, s = this;
                if (s.allowBlur === !0 && s.editing && s.selectSameEditor !== !0) {
                    s.completeEdit();
                }
                if (t && t.target && Ext.fly(i = t.getTarget()).focusable()) {
                    i.focus();
                }
            }
        });
        Ext.override(Ext.form.field.Text, {
            initEvents: function() {
                this.callOverridden(arguments);
                this.on("keypress", function() {
                    var e = this;
                    if (e.hasActiveError()) {
                        e.clearInvalid();
                    }
                }, this);
            },
            clearInvalid: function() {
                var e, t = Ext.layout.component.field.Field.tip;
                if (this.hasActiveError() && t && t.isVisible()) {
                    e = t.activeTarget;
                    if (e && e.el === this.getActionEl().dom) {
                        t.hide();
                    }
                }
                return this.callOverridden(arguments);
            }
        });
        Ext.override(Ext.container.Container, {
            handleKeys: !1,
            afterRender: function() {
                var e, t = this.handleKeys, i = [];
                this.callOverridden(arguments);
                if (t) {
                    if (!Ext.isArray(t)) {
                        t = [ Ext.EventObject.ENTER, Ext.EventObject.ESC ];
                    }
                    for (e = 0; e < t.length; e++) {
                        switch (t[e]) {
                          case Ext.EventObject.ENTER:
                            i.push({
                                key: Ext.EventObject.ENTER,
                                ctrl: !1,
                                shift: !1,
                                fn: this._onEnterKey,
                                scope: this
                            });
                            break;

                          case Ext.EventObject.ESC:
                            i.push({
                                key: Ext.EventObject.ESC,
                                ctrl: !1,
                                shift: !1,
                                fn: this._onEscKey,
                                scope: this
                            });
                        }
                    }
                    this._keyMap = new Ext.util.KeyMap(this.getEl(), i);
                }
            },
            _onEnterKey: function(e, t) {
                var i;
                if (this._suppressDefaultAction(t.getTarget())) {
                    return;
                }
                i = this._findActionButton("isDefault");
                if (i) {
                    this._doButtonAction(i, t);
                } else {}
            },
            _onEscKey: function(e, t) {
                var i;
                i = this._findActionButton("isCancel");
                this._doButtonAction(i, t);
            },
            _doButtonAction: function(e, t) {
                if (e) {
                    t.stopEvent();
                    e.fireEvent("click", e, t);
                }
            },
            _findActionButton: function(e) {
                var t, i, s, n = this.query("webmailbutton");
                for (i = 0, s = n.length; s > i; i++) {
                    t = n[i];
                    if (!0 === t[e] && t.isVisible(!0) && !t.isDisabled()) {
                        return t;
                    }
                }
                return null;
            },
            _suppressDefaultAction: function(e) {
                if (Ext.fly(e).hasCls("x-form-file-input") || e.tagName.match(/^textarea$/gi)) {
                    return !0;
                }
                return !1;
            },
            _findAutoFocusEl: function() {
                var e, t, i;
                for (t = 0, e = this.query("textfield"); t < e.length; t++) {
                    i = e[t];
                    if (i.isVisible() && !i.isDisabled()) {
                        if (i instanceof Ext.form.field.File) {
                            return i.fileInputEl;
                        }
                        return i;
                    }
                }
            },
            getFocusEl: function() {
                var e = this.callOverridden(arguments);
                if (e && this.focusEl !== e) {
                    return e;
                }
                return this._findAutoFocusEl() || this.focusEl;
            },
            afterShow: function() {
                var e;
                this.callOverridden(arguments);
                if (this.autoFocus) {
                    e = this._findAutoFocusEl();
                    if (e) {
                        Ext.Function.defer(e.focus, 50, e);
                    }
                }
            },
            _maskDelay: 300,
            _maskCounter: 0,
            _isMasked: !1,
            mask: function(e) {
                this._isMasked = !0;
                this._maskTimerId = Ext.defer(this._maskDelayed, this._maskDelay, this, [ e ]);
            },
            _maskDelayed: function(e) {
                if (this.rendered) {
                    this.getEl().mask(e);
                }
            },
            unmask: function() {
                if (this.rendered && this._isMasked) {
                    this.getEl().unmask();
                }
                window.clearTimeout(this._maskTimerId);
                delete this._maskTimerId;
                this._isMasked = !1;
            }
        });
        Ext.override(Ext.window.MessageBox, {
            closable: !0,
            reconfigure: function(e) {
                e.closable = !1;
                this.callOverridden(arguments);
            }
        });
        Ext.override(Ext.window.Window, {
            closable: !1,
            buttonAlign: "right",
            handleKeys: !0,
            onEsc: Ext.emptyFn
        });
        Ext.override(Ext.view.DragZone, {
            onValidDrop: function(e, t, i) {
                this.callSuper(arguments);
                e.el.focus();
            }
        });
        Ext.LoadMask.override({
            baseMsgCls: Ext.baseCSSPrefix + "mask-text",
            baseCls: Ext.baseCSSPrefix + "loadmask",
            maskMsgCls: Ext.baseCSSPrefix + "mask-msg",
            invisibleMaskCls: Ext.baseCSSPrefix + "invisible-mask",
            maskOnDisable: !1,
            renderTpl: [ '<div class="' + Ext.baseCSSPrefix + 'mask">', '<div class="loadingMask">', '<div class="circleContainer">', '<div class="circle"></div>', "</div>", '<div class="{maskMsgCls} {baseMsgCls} {msgCls} msg"></div>', "</div>", "</div>" ],
            floating: {
                shadow: !1
            },
            delay: 250,
            constructor: function(e, t) {
                var i = this;
                t = t || {};
                if (!1 === t.modal) {
                    this._isModal = !1;
                } else {
                    this._isModal = !0;
                }
                delete this.modal;
                delete t.modal;
                if (e.isComponent) {
                    i.ownerCt = e;
                    i.bindComponent(e);
                } else {
                    i.ownerCt = new Ext.Component({
                        el: Ext.get(e),
                        rendered: !0,
                        componentLayoutCounter: 1
                    });
                    i.container = e;
                }
                i.callSuper([ t ]);
                if (i.store) {
                    i.bindStore(i.store, !0);
                }
                i.renderData = {
                    msgCls: i.msgCls,
                    baseMsgCls: i.baseMsgCls,
                    maskMsgCls: i.maskMsgCls
                };
                i.renderSelectors = {
                    msgEl: "div." + i.baseMsgCls,
                    maskMsgEl: "div." + i.maskMsgCls,
                    maskEl: "div." + Ext.baseCSSPrefix + "mask",
                    maskProgressEl: "div.loadingMask"
                };
            },
            beforeShow: function() {
                var e = this.callOverridden(arguments);
                this.addCls(this.invisibleMaskCls);
                return e;
            },
            onHide: function() {
                var e = this.callOverridden(arguments);
                if (void 0 !== this._timeoutId) {
                    window.clearTimeout(this._timeoutId);
                    delete this._timeoutId;
                }
                return e;
            },
            onShow: function() {
                var e = this, t = e.msgEl;
                e.callSuper(arguments);
                e.loading = !0;
                if (e.useMsg) {
                    t.show().update(e.msg);
                } else {
                    this.maskMsgEl.hide();
                }
            },
            afterShow: function() {
                var e = Ext.WindowManager.front;
                this.callSuper(arguments);
                this.sizeMask();
                if (void 0 === this._timeoutId) {
                    this._timeoutId = Ext.Function.defer(this._showVisibleMask, this.delay, this);
                }
                if (e) {
                    e.toFront();
                }
            },
            _showVisibleMask: function() {
                if (this.el || this.protoEl) {
                    this.removeCls(this.invisibleMaskCls);
                }
                delete this._timeoutId;
            },
            sizeMask: function() {
                if (this.rendered && this.isVisible()) {
                    this.setSize(this.container.getSize());
                    this.alignTo(this.container, "tl-tl");
                    this.maskEl.setSize(this.getSize());
                    this.maskEl.alignTo(this.getEl(), "tl-tl");
                    this.maskProgressEl.center(this.maskEl);
                }
                this.callOverridden(arguments);
            }
        });
        Ext.override(Ext.form.field.Trigger, {
            constructor: function() {
                this.callOverridden(arguments);
                this.addCls("x-form-combobox");
            },
            setReadOnly: function() {
                this.callOverridden(arguments);
                if (this.inputEl && !1 === this.editable) {
                    this.inputEl.dom.readOnly = !0;
                }
            }
        });
        Ext.form.Labelable.prototype.labelAlign = "right";
        Ext.form.Field.prototype.labelAlign = "right";
        Ext.form.FieldContainer.prototype.labelAlign = "right";
        Ext.override(Ext.dd.StatusProxy, {
            dropCopyAllowed: Ext.baseCSSPrefix + "dd-drop-ok-add",
            reset: function(e) {
                var t = this, i = Ext.baseCSSPrefix + "dd-drag-proxy ";
                t.el.replaceCls([ i, t.dropAllowed, t.dropCopyAllowed ], i + t.dropNotAllowed);
                t.dropStatus = t.dropNotAllowed;
                if (e) {
                    t.ghost.update("");
                }
            }
        });
        Ext.override(Ext.view.DragZone, {
            onItemMouseDown: function(e, t, i, s, n) {
                this._updateSelectionOnMouseup = !1;
                delete this._recordToBeSelected;
                if (!this.isLocked() && !this.isPreventDrag(n, t, i, s)) {
                    var o = e.getSelectionModel();
                    this.view.focus();
                    this.handleMouseDown(n);
                    if ("MULTI" === o.selectionMode && !n.ctrlKey && o.isSelected(t)) {
                        if (o.getSelection().length > 1) {
                            this._updateSelectionOnMouseup = !0;
                            this._recordToBeSelected = t;
                        }
                        return !1;
                    }
                }
            },
            onMouseUp: function(e) {
                var t, i, s;
                if (this._updateSelectionOnMouseup) {
                    t = this.view.getSelectionModel();
                    if (e.shiftKey && t.hasSelection()) {
                        i = t.getSelection();
                        s = t.getLastFocused();
                        if (!s || !t.rangeCenter || s !== i[i.length - 1]) {
                            s = i[0];
                        }
                        t.selectRange(s, this._recordToBeSelected);
                    } else {
                        t.select(this._recordToBeSelected);
                    }
                    delete this._updateSelectionOnMouseup;
                }
                delete this._recordToBeSelected;
            },
            onInitDrag: function(e, t) {
                var i = this, s = i.dragData, n = s.view, o = n.getSelectionModel(), r = n.getRecord(s.item);
                if (!this._recordToBeSelected && !o.isSelected(r)) {
                    o.select(r, !0);
                }
                s.records = o.getSelection();
                i.ddel.update(i.getDragText());
                i.proxy.update(i.ddel.dom);
                i.onStartDrag(e, t);
                delete this._updateSelectionOnMouseup;
                return !0;
            }
        });
        Ext.dd.DragDropManager.handleMouseDown = function(e, t) {
            if (Ext.quickTipsActive) {
                Ext.tip.QuickTipManager.ddDisable();
            }
            if (this.dragCurrent) {
                this.handleMouseUp(e);
            }
            this.currentTarget = e.getTarget();
            this.dragCurrent = t;
            var i = t.getEl();
            if (Ext.isIE && i.setCapture) {
                i.setCapture();
            }
            this.startX = e.getPageX();
            this.startY = e.getPageY();
            this.deltaX = this.startX - i.offsetLeft;
            this.deltaY = this.startY - i.offsetTop;
            this.dragThreshMet = !1;
        };
        Ext.Array.pluckSimple = Ext.Array.pluck;
        Ext.Array.pluck = function(e, t) {
            var i, s, n, o, r = function(e, t) {
                if (void 0 === e || null === e) {
                    o[t] = {};
                }
            };
            if (-1 !== t.indexOf(".")) {
                i = t.split(".");
            }
            if (i) {
                for (s = 0, n = i.length; n > s; s++) {
                    t = i[s];
                    o = Ext.Array.pluckSimple(o || e, t);
                    if (s !== i.length - 1) {
                        Ext.Array.each(o, r);
                    }
                }
                return o;
            } else {
                return Ext.Array.pluckSimple(e, t);
            }
        };
        Ext.form.Basic.prototype.getInvalidCount = function() {
            var e = this, t = [];
            Ext.batchLayouts(function() {
                t = this.getFields().filterBy(function(e) {
                    return !e.validate();
                });
            }, e);
            return t.length;
        };
        Ext.override(Ext.dom.Element, {
            syncContent: function(e) {
                e = Ext.getDom(e);
                var t, i, s, n, o, r, a, l = this, d = e.childNodes, c = d.length, h = l.dom, u = h.childNodes, f = u.length;
                o = e.attributes;
                r = o.length;
                for (t = 0; r > t; t++) {
                    a = o[t].name;
                    if ("id" !== a) {
                        h.setAttribute(a, o[t].value);
                    }
                }
                if (c !== f) {
                    h.innerHTML = e.innerHTML;
                    return;
                }
                for (t = 0; c > t; t++) {
                    s = d[t];
                    i = u[t];
                    n = s.nodeType;
                    if (n !== i.nodeType || 1 === n && s.tagName !== i.tagName) {
                        h.innerHTML = e.innerHTML;
                        return;
                    }
                    if (3 === n) {
                        i.data = s.data;
                    } else {
                        if (s.id && i.id !== s.id) {
                            i.id = s.id;
                        }
                        i.style.cssText = s.style.cssText;
                        i.className = s.className;
                        Ext.fly(i).syncContent(s);
                    }
                }
            },
            getAttribute: function(e, t) {
                var i = this.dom;
                if (t) {
                    return i.getAttributeNS(t, e) || i.getAttribute(t + ":" + e);
                }
                return i.getAttribute(e) || i[e] || null;
            }
        });
        Ext.override(Ext.view.Table, {
            onUpdate: function(e, t, i, s) {
                var n, o, r, a, l, d, c, h, u, f, m, p, g, _, k, v, y, w = this, E = w.editingPlugin && w.editingPlugin.editing;
                if (w.viewReady) {
                    n = w.store.indexOf(t);
                    p = w.headerCt.getGridColumns();
                    g = w.overItemCls;
                    k = w.altRowCls;
                    if (p.length && n > -1) {
                        o = w.bufferRender([ t ], n)[0];
                        d = w.all.item(n);
                        if (d) {
                            c = d.dom;
                            v = d.hasCls(g);
                            _ = d.hasCls(k);
                            r = o.attributes;
                            a = r.length;
                            for (m = 0; a > m; m++) {
                                l = r[m].name;
                                if ("id" !== l) {
                                    c.setAttribute(l, r[m].value);
                                }
                            }
                            if (v) {
                                d.addCls(g);
                            }
                            if (_) {
                                d.addCls(k);
                            }
                            h = d.query(w.cellSelector);
                            u = Ext.fly(o).query(w.cellSelector);
                            f = u.length;
                            y = h[0].parentNode;
                            for (m = 0; f > m; m++) {
                                if (w.shouldUpdateCell(p[m], s)) {
                                    if (E) {
                                        Ext.fly(h[m]).syncContent(u[m]);
                                    } else {
                                        y.insertBefore(u[m], h[m]);
                                        y.removeChild(h[m]);
                                    }
                                }
                            }
                            w.selModel.onUpdate(t);
                        }
                        if (d) {
                            w.fireEvent("itemupdate", t, n, d);
                        }
                    }
                }
            }
        });
        Ext.override(Ext.grid.PagingScroller, {
            handleViewScroll: function(e) {
                var t, i, s, n, o = this, r = o.store, a = o.view, l = o.viewSize, d = r.getTotalCount(), c = d - l, h = a.el.dom, u = a.stripeRows ? -2 : -1;
                if (d >= l) {
                    t = o.getFirstVisibleRowIndex(), i = o.getLastVisibleRowIndex(), o.scrollProportion = void 0;
                    if (-1 == e) {
                        if (o.tableStart > 0) {
                            if (void 0 !== t) {
                                if (t < o.tableStart + o.numFromEdge) {
                                    s = Math.max(0, i + o.trailingBufferZone - l);
                                }
                            } else {
                                o.scrollProportion = h.scrollTop / (h.scrollHeight - h.clientHeight);
                                s = Math.max(0, d * o.scrollProportion - l / 2 - o.numFromEdge - (o.leadingBufferZone + o.trailingBufferZone) / 2);
                            }
                        }
                    } else {
                        if (o.tableStart !== c) {
                            if (void 0 !== t) {
                                if (i > o.tableEnd - o.numFromEdge) {
                                    s = Math.max(0, t - o.trailingBufferZone);
                                }
                            } else {
                                o.scrollProportion = h.scrollTop / (h.scrollHeight - h.clientHeight);
                                s = d * o.scrollProportion - l / 2 - o.numFromEdge - (o.leadingBufferZone + o.trailingBufferZone) / 2;
                            }
                        }
                    }
                    if (void 0 !== s) {
                        if (s > c) {
                            s = c & u;
                            n = d - 1;
                        } else {
                            s &= u;
                            n = s + l - 1;
                        }
                        if (r.rangeCached(s, n)) {
                            o.cancelLoad();
                            r.guaranteeRange(s, n);
                        } else {
                            o.attemptLoad(s, n);
                        }
                    }
                }
            },
            onViewRefresh: function() {
                var e, t, i, s, n, o, r = this, a = r.store, l = r.view, d = l.el, c = d.dom, h = l.table.dom;
                if (0 === a.getCount()) {
                    this.onCacheClear();
                }
                if (r._refreshScrollTop && !r.scrollOffset) {
                    r.scrollOffset = r._refreshScrollTop;
                    r.commonRecordIndex = 1;
                }
                if (r.focusOnRefresh) {
                    d.focus();
                    r.focusOnRefresh = !1;
                }
                r.disabled = !0;
                r.stretcher.setHeight(e = r.getScrollHeight());
                o = c.scrollTop;
                r.isScrollRefresh = o > 0;
                if (void 0 !== r.scrollProportion) {
                    r.setTablePosition("absolute");
                    r.setTableTop((r.scrollProportion && r.tableStart > 0 ? e * r.scrollProportion - h.offsetHeight * r.scrollProportion : 0) + "px");
                } else {
                    r.setTablePosition("absolute");
                    r.setTableTop((n = (r.tableStart || 0) * r.rowHeight) + "px");
                    if (r.scrollOffset) {
                        t = l.getNodes();
                        if (t[r.commonRecordIndex]) {
                            i = -d.getOffsetsTo(t[r.commonRecordIndex])[1];
                            s = i - r.scrollOffset;
                            r.position = c.scrollTop += s;
                        }
                    } else {
                        if (n > o || n + h.offsetHeight < o + c.clientHeight) {
                            if (Math.floor(r.position) !== Math.floor(n)) {
                                r.positionFromRefresh = r.position;
                            }
                            r.position = c.scrollTop = n;
                        }
                    }
                }
                r.disabled = !1;
            },
            onViewScroll: function(e, t) {
                var i = this, s = i.view, n = i.position;
                if (void 0 !== i.positionFromRefresh) {
                    n = i.positionFromRefresh;
                    i.positionFromRefresh = void 0;
                }
                i.position = s.el.dom.scrollTop;
                if (i.ignoreNextScrollEvent) {
                    i.ignoreNextScrollEvent = !1;
                    return;
                }
                i._refreshScrollTop = void 0;
                if (!i.disabled) {
                    if (n !== i.position) {
                        i.lastScrollDirection = i.position > n ? 1 : -1;
                        i.handleViewScroll(i.lastScrollDirection);
                    }
                    i.lastScrollDirection = void 0;
                }
            },
            onViewResize: function(e, t, i) {
                var s, n, o, r, a, l = this, d = l.store, c = l.viewSize, h = Math.ceil(i / l.rowHeight) + l.trailingBufferZone + 2 * l.numFromEdge + l.leadingBufferZone, u = c - h, f = c > h && l.getFirstVisibleRowIndex();
                if (f > 0) {
                    s = l.getLastVisibleRowIndex();
                    o = d.last().index;
                    if (u > o - s) {
                        n = Math.max(0, o - u - (s - f));
                    }
                }
                l._refreshScrollTop = void 0;
                a = function() {
                    var e = this.me, t = e.viewSize = this.newViewSize, i = this.scrollDirection || 1;
                    e.store.setViewSize(t);
                    e.tableEnd = e.tableStart + t - 1;
                    e.handleViewScroll(i);
                    e.lastScrollDirection = void 0;
                };
                if (void 0 !== n && n != f) {
                    l.scrollTo(n, !1, a, {
                        me: this,
                        newViewSize: h,
                        scrollDirection: -1
                    });
                    l.ignoreNextScrollEvent = !0;
                    r = l.view && l.view.el && l.view.el.dom.scrollTop;
                    if (r) {
                        l._refreshScrollTop = Math.min(0, (l.tableStart || 0) * l.rowHeight - r);
                    }
                } else {
                    a.call({
                        me: this,
                        newViewSize: h
                    });
                }
            },
            scrollTo: function(e, t, i, s) {
                var n, o, r, a, l = this, d = l.view, c = d.el.dom, h = l.store, u = h.getTotalCount();
                e = Math.min(Math.max(e, 0), u - 1);
                n = Math.max(Math.min(e - (l.leadingBufferZone + l.trailingBufferZone) / 2, u - l.viewSize), 0);
                a = n * l.rowHeight;
                o = n + l.viewSize - 1;
                l.lastScrollDirection = void 0;
                l.disabled = !0;
                h.guaranteeRange(n, o, function() {
                    r = h.pageMap.getRange(e, e)[0];
                    d.table.dom.style.top = a + "px";
                    c.scrollTop = a = Math.min(Math.max(0, a - d.table.getOffsetsTo(d.getNode(r))[1]), c.scrollHeight - c.clientHeight);
                    if (Ext.isIE) {
                        c.scrollTop = a;
                    }
                    l.disabled = !1;
                    if (t) {
                        l.grid.selModel.select(r);
                    }
                    if (i) {
                        i.call(s || l, e, r);
                    }
                });
            },
            getScrollHeight: function() {
                var e, t, i, s = this, n = s.view, o = s.store, r = 0, a = !s.hasOwnProperty("rowHeight") || 0 === s.rowHeight, l = o.getCount(), d = o.getTotalCount();
                if (!l) {
                    return 0;
                }
                if (s.variableRowHeight) {
                    e = n.table.dom;
                    if (a || s.lastTotalCount !== d) {
                        s.initialTableHeight = e.offsetHeight;
                        if (0 === s.initialTableHeight) {
                            if (!s.onViewShow) {
                                i = n.findParentBy(function(e) {
                                    return !e.isVisible();
                                });
                                if (i) {
                                    s.onViewShow = function() {
                                        this.refresh();
                                    };
                                    i.on("show", s.onViewShow, n, {
                                        single: !0
                                    });
                                }
                            }
                            return 0;
                        }
                        s.onViewShow = void 0;
                        s.rowHeight = s.initialTableHeight / l;
                        s.lastTotalCount = d;
                    } else {
                        r = e.offsetHeight - s.initialTableHeight;
                        if (o.getCount() > s.viewSize) {
                            r -= s.rowHeight;
                        }
                    }
                } else {
                    if (a) {
                        t = n.el.down(n.getItemSelector());
                        if (t) {
                            s.rowHeight = t.getHeight(!1, !0);
                        }
                    }
                }
                return Math.floor(d * s.rowHeight) + r;
            }
        });
        Ext.override(Ext.util.Sortable, {
            initSortable: function() {
                var e = this, t = e.sorters;
                e.sorters = new Ext.util.AbstractMixedCollection(!1, function(e) {
                    return e.id || e.property;
                });
                e.sorters.on("add", function(e, t) {
                    if (t && void 0 === t.remoteSort) {
                        t.remoteSort = this.remoteSort;
                    }
                }, e);
                if (t) {
                    e.sorters.addAll(e.decodeSorters(t));
                }
            }
        });
        Ext.override(Ext.AbstractComponent, {
            setPosition: function(e, t, i) {
                var s = this, n = s.beforeSetPosition.apply(s, arguments);
                if (n && s.rendered) {
                    n = s.convertPosition(n);
                    if (n.left !== s.el.getLeft(!0) || n.top !== s.el.getTop(!0)) {
                        if (i) {
                            s.stopAnimation();
                            s.animate(Ext.apply({
                                duration: 1e3,
                                listeners: {
                                    afteranimate: Ext.Function.bind(s.afterSetPosition, s, [ n.left, n.top ])
                                },
                                to: n
                            }, i));
                        } else {
                            if (void 0 !== n.left && void 0 !== n.top) {
                                s.el.setLeftTop(n.left, n.top);
                            } else {
                                if (void 0 !== n.left) {
                                    s.el.setLeft(n.left);
                                } else {
                                    if (void 0 !== n.top) {
                                        s.el.setTop(n.top);
                                    }
                                }
                            }
                            s.afterSetPosition(n.left, n.top);
                        }
                    }
                }
                return s;
            }
        });
        Ext.override(Ext.layout.container.Box, {
            renderTpl: [ "{%var oc,l=values.$comp.layout,oh=l.overflowHandler;", "if (oh.getPrefixConfig!==Ext.emptyFn) {", "if(oc=oh.getPrefixConfig())dh.generateMarkup(oc, out)", "}%}", '<div id="{ownerId}-innerCt" class="{[l.innerCls]} {[oh.getOverflowCls()]}" role="presentation">', '<div id="{ownerId}-targetEl" style="position:absolute;', "{[this.getTargetWidth()]}", "left:0px;top:0px;", 'height:1px">', "{%this.renderBody(out, values)%}", "</div>", "</div>", "{%if (oh.getSuffixConfig!==Ext.emptyFn) {", "if(oc=oh.getSuffixConfig())dh.generateMarkup(oc, out)", "}%}", {
                disableFormats: !0,
                definitions: "var dh=Ext.DomHelper;",
                getTargetWidth: function() {
                    if (Ext.isWebKit || Ext.isIE) {
                        return "width:20000px;";
                    }
                    return "width:100%;";
                }
            } ]
        });
        Ext.override(Ext.data.Connection, {
            onStateChange: function(e) {
                if (e.xhr && 4 === e.xhr.readyState) {
                    this.clearTimeout(e);
                    this.onComplete(e);
                    this.cleanup(e);
                    Ext.EventManager.idleEvent.fire();
                }
            }
        });
        Ext.override(Ext.data.Store, {
            rebuildIndexes: function() {
                if (this.buffered) {
                    return;
                }
                var e, t = this.data.items, i = t.length, s = this.currentPage && this.pageSize ? (this.currentPage - 1) * this.pageSize : 0;
                for (e = 0; i > e; e++) {
                    t[e].index = e + s;
                }
            },
            remove: function(e, t) {
                if (!Ext.isArray(e)) {
                    e = [ e ];
                }
                t = t === !0;
                var i, s, n, o, r = this, a = !1, l = r.snapshot, d = r.data, c = 0, h = e.length, u = [], f = [], m = [];
                if (!h) {
                    return;
                }
                for (;h > c; ++c) {
                    o = e[c];
                    if (l) {
                        l.remove(o);
                    }
                    n = d.indexOf(o);
                    if (n > -1) {
                        u.push({
                            record: o,
                            index: n
                        });
                    }
                }
                u = Ext.Array.sort(u, function(e, t) {
                    var i = e.index, s = t.index;
                    return i === t.index2 ? 0 : s > i ? -1 : 1;
                });
                for (c = 0, h = u.length; h > c; c++) {
                    i = u[c];
                    o = i.record;
                    n = i.index;
                    f.push(o);
                    m.push(n);
                    s = o.phantom !== !0;
                    if (!t && s) {
                        o.removedFrom = n;
                        r.removed.push(o);
                    }
                    o.unjoin(r);
                    n = d.indexOf(o);
                    d.remove(o);
                    a = a || s;
                    r.fireEvent("remove", r, o, n);
                }
                r.rebuildIndexes();
                r.fireEvent("bulkremove", r, f, m);
                r.fireEvent("datachanged", r);
                if (!t && r.autoSync && a && !r.autoSyncSuspended) {
                    r.sync();
                }
            },
            setViewSize: function(e) {
                this.modifyViewOnly = !0;
                var t = this.callOverridden(arguments);
                this.modifyViewOnly = void 0;
                return t;
            }
        });
        Ext.ZIndexManager.prototype.bringToFront = function(e) {
            var t, i, s;
            e = this.get(e);
            if (e !== this.front) {
                t = this.getBy(this._alwaysOnTopFilter, this);
                Ext.Array.remove(this.zIndexStack, e);
                this.zIndexStack.push(e);
                if (t.length) {
                    for (i = 0, s = t.length; s > i; i++) {
                        Ext.Array.remove(this.zIndexStack, t[i]);
                        this.zIndexStack.push(t[i]);
                    }
                }
                this.assignZIndices();
                return !0;
            }
            if (e.modal) {
                this._showModalMask(e);
            }
            return !1;
        };
        Ext.ZIndexManager.prototype._alwaysOnTopFilter = function(e) {
            return e.alwaysOnTop === !0;
        };
        Ext.override(Ext.data.reader.Reader, {
            extractData: function(e) {
                var t, i, s, n = this, o = [], r = n.model, a = e.length;
                if (!r.prototype.getDisplayField) {
                    return this.callOverridden(arguments);
                }
                if (!e.length && Ext.isObject(e)) {
                    e = [ e ];
                    a = 1;
                }
                for (s = 0; a > s; s++) {
                    t = e[s];
                    if (!t.isModel) {
                        i = new r(t, n.getId(t), t);
                        i.phantom = !1;
                        o.push(i);
                        if (n.implicitIncludes) {
                            n.readAssociated(i, t);
                        }
                    } else {
                        o.push(t);
                    }
                }
                return o;
            }
        });
        Ext.override(Ext.Component, {
            _savedScroll: void 0,
            onRender: function() {
                this.callParent(arguments);
                this.getEl().on("scroll", this._saveScroll, this);
            },
            _saveScroll: function() {
                this._savedScroll = this.getEl().getScroll();
                if (!this._afterComponentLayout && this.afterComponentLayout) {
                    this._afterComponentLayout = this.afterComponentLayout;
                    this.afterComponentLayout = function() {
                        this._afterComponentLayout.apply(this, arguments);
                        this._restoreScroll();
                    };
                }
            },
            _restoreScroll: function() {
                if (!this._savedScroll) {
                    return;
                }
                var e, t = this._savedScroll;
                if (!this._ignoreTopScroll && t.top) {
                    e = this.getEl().scrollTo("top", t.top);
                }
                if (t.left) {
                    (e || this.getEl()).scrollTo("left", t.left);
                }
            },
            ignoreTopScroll: function(e) {
                this._ignoreTopScroll = e;
            },
            clearSavedScroll: function() {
                this._savedScroll = void 0;
            }
        });
        Ext.override(Ext.form.field.Time, {
            onListRefresh: function() {
                this.alignPicker();
            }
        });
        Ext.override(Ext.form.field.Date, {
            constructor: function(e) {
                e = e || {};
                if (void 0 === e.startDay) {
                    e.startDay = kerio.wm.LocalesProvider.getFirstWeekDay();
                }
                this.callOverridden(arguments);
            }
        });
        Ext.override(Ext.picker.Date, {
            constructor: function(e) {
                e = e || {};
                if (void 0 === e.startDay) {
                    e.startDay = kerio.wm.LocalesProvider.getFirstWeekDay();
                }
                this.longDayFormat = kerio.wm.LocalesProvider.getDateFullMonthYearFormat();
                return this.callOverridden(arguments);
            }
        });
        Ext.override(Ext.layout.Context, {
            layoutDone: function(e) {
                e.ownerContext = e.ownerContext || this.getCmp(e.owner);
                this.callOverridden(arguments);
            }
        });
        if (Ext.isChrome) {
            Ext.override(Ext.form.field.Base, {
                fieldSubTpl: [ '<input id="{id}" type="{type}" {inputAttrTpl}', ' size="1"', '<tpl if="name"> name="{name}"</tpl>', '<tpl if="value"> value="{[Ext.util.Format.htmlEncode(values.value)]}"</tpl>', '<tpl if="placeholder"> placeholder="{placeholder}"</tpl>', '{%if (values.maxLength !== undefined){%} maxlength="{maxLength}"{%}%}', '<tpl if="readOnly"> readonly="readonly"</tpl>', '<tpl if="disabled"> disabled="disabled"</tpl>', '<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>', '<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>', ' class="{fieldCls} {typeCls} {editableCls}" autocomplete="{autocomplete}"/>', {
                    disableFormats: !0
                } ],
                getSubTplData: function() {
                    var e = this.callParent(arguments) || {};
                    e.autocomplete = "password" === this.inputType ? "new-password" : "off";
                    return e;
                }
            });
        }
    }
});

Ext.define("kerio.wm.TitleManager", {
    singleton: !0,
    pageStateEnum: {
        original: "original",
        unreadCount: "unreadCount",
        about: "about",
        composer: "composer",
        emailPreview: "emailPreview"
    },
    moduleEnum: {
        email: "mail",
        chat: "messages",
        calendar: "calendar",
        contacts: "contacts",
        tasks: "tasks",
        notes: "notes"
    },
    actionEnum: {
        composer: "composer",
        preview: "preview"
    },
    hashEnum: {
        email: "#mail",
        newWinCompose: "#window/mail/compose"
    },
    cache: {},
    constructor: function() {
        this.originalTitle = document.title;
        this.reminderVisible = !1;
        this.module = null;
        this.action = null;
        this.pageState = this.pageStateEnum.original;
        this.titlesHash = {
            original: document.title
        };
    },
    setMailsUnread: function(e) {
        if ("undefined" == typeof this.unreadCount || this.unreadCount !== e) {
            this.unreadCount = e;
            if (this.pageState === this.pageStateEnum.emailPreview) {
                this._setEmailPreviewTitle(!0);
            } else {
                if (this.pageState === this.pageStateEnum.unreadCount) {
                    this._setUnreadCountTitle(!0);
                }
            }
        } else {
            this.unreadCount = e;
        }
        if (!this.reminderVisible) {
            this.hideReminder();
        }
    },
    showReminder: function(e) {
        this.reminderVisible = !0;
        this._setUnreadCountTitle(!1, e);
    },
    hideReminder: function(e) {
        this.reminderVisible = !1;
        this._setUnreadCountTitle(!1);
    },
    restoreTitle: function() {
        if (this.module !== this.moduleEnum.email) {
            if (this.restoreUnreadCountState) {
                this.pageState = this.pageStateEnum.unreadCount;
            } else {
                this.pageState = this.pageStateEnum.original;
            }
        } else {
            if (this.action === this.actionEnum.composer) {
                this.pageState = this.pageStateEnum.composer;
            } else {
                if (this.action === this.actionEnum.preview) {
                    this.pageState = this.pageStateEnum.emailPreview;
                } else {
                    if (this.restoreUnreadCountState) {
                        this.pageState = this.pageStateEnum.unreadCount;
                    } else {
                        this.pageState = this.pageStateEnum.original;
                    }
                }
            }
        }
        this._updateTitle();
    },
    showAbout: function() {
        this.titlesHash[this.pageStateEnum.about] = k_tr("About dialog - About Kerio Connect", "common");
        this.pageState = this.pageStateEnum.about;
        this._updateTitle();
    },
    showNewMessage: function(e) {
        if (this.module !== this.moduleEnum.email) {
            this._setComposerTitle(this._getUnreadCountTitleText() + this.originalTitle);
        } else {
            if (e) {
                this._setComposerTitle(k_tr("Email composer", "common") + (e ? " - " + e : ""));
            } else {
                this._setComposerTitle(k_tr("Email composer - New message", "common"));
            }
        }
    },
    showEmailPreview: function(e) {
        if (this.ignoreEmailPreview) {
            this.ignoreEmailPreview = null;
            return;
        }
        this._setEmailPreviewTitle(!1, e);
    },
    disableComposerState: function() {
        this.pageState = this.lastPageState;
        this.lastPageState = null;
        if (this.pageState === this.pageStateEnum.emailPreview) {
            this.action = this.actionEnum.preview;
        } else {
            this.action = null;
        }
        this.restoreUnreadCountState = this.unreadCount > 0;
        this.restoreTitle();
    },
    pathChanged: function(e, t, i) {
        this.module = e;
        if (e !== this.moduleEnum.email) {
            this.restoreTitle();
        } else {
            if (e === this.moduleEnum.email && i !== this.hashEnum.email) {
                if (i !== this.hashEnum.email && this.action === this.actionEnum.composer) {
                    this.ignoreEmailPreview = !0;
                    this.restoreTitle();
                } else {
                    if (e === this.moduleEnum.email && i === this.hashEnum.newWinCompose) {
                        this.showNewMessage();
                    } else {
                        this.restoreTitle();
                    }
                }
            }
        }
    },
    folderChanged: function() {
        this.action = null;
        this.restoreUnreadCountState = this.unreadCount > 0;
        this.restoreTitle();
    },
    _getUnreadCountTitleText: function() {
        if (this.unreadCount > 0) {
            return "(" + this.unreadCount + ") ";
        }
        return "";
    },
    _setEmailPreviewTitle: function(e, t) {
        if (e === !0) {
            t = this.cache.lastCalledSetEmailPreviewTitleSubject;
        } else {
            this.cache.lastCalledSetEmailPreviewTitleSubject = t;
        }
        this.titlesHash[this.pageStateEnum.emailPreview] = this._getUnreadCountTitleText() + this.originalTitle + (t ? " - " + t : "");
        this.pageState = this.pageStateEnum.emailPreview;
        this._updateTitle();
    },
    _setComposerTitle: function(e) {
        this.action = this.actionEnum.composer;
        this.lastPageState = this.pageState;
        this.titlesHash[this.pageStateEnum.composer] = e;
        this.pageState = this.pageStateEnum.composer;
        this._updateTitle();
    },
    _setUnreadCountTitle: function(e, t) {
        if (e === !0) {
            t = this.cache.lastCalledSetUnreadCountTitleText;
        } else {
            this.cache.lastCalledSetUnreadCountTitleText = t;
        }
        if ("undefined" != typeof t && t) {
            this.titlesHash[this.pageStateEnum.unreadCount] = t;
        } else {
            this.titlesHash[this.pageStateEnum.unreadCount] = this._getUnreadCountTitleText() + this.originalTitle;
        }
        if (this.pageState === this.pageStateEnum.original) {
            this.pageState = this.pageStateEnum.unreadCount;
        } else {
            this.restoreUnreadCountState = !0;
        }
        this._updateTitle();
    },
    _updateTitle: function() {
        if (this.module === this.moduleEnum.chat) {
            document.title = k_tr("Chat", "common") + " - " + this.titlesHash[this.pageState];
        } else {
            if (this.module === this.moduleEnum.calendar) {
                document.title = k_tr("Calendar", "common") + " - " + this.titlesHash[this.pageState];
            } else {
                if (this.module === this.moduleEnum.contacts) {
                    document.title = k_tr("Contacts", "common") + " - " + this.titlesHash[this.pageState];
                } else {
                    if (this.module === this.moduleEnum.tasks) {
                        document.title = k_tr("Tasks", "common") + " - " + this.titlesHash[this.pageState];
                    } else {
                        if (this.module === this.moduleEnum.notes) {
                            document.title = k_tr("Notes", "common") + " - " + this.titlesHash[this.pageState];
                        } else {
                            document.title = this.titlesHash[this.pageState];
                        }
                    }
                }
            }
        }
    }
});

Ext.define("kerio.wm.Constants", {
    singleton: !0,
    constructor: function() {
        var e, t, i;
        this.callParent(arguments);
        if (kerio.engine) {
            this.dateOffset = 60 * (new Date().getTimezoneOffset() + kerio.engine.constants.USER_TIME_ZONE_OFFSET) * 1e3;
            if (kerio.engine.userDetails) {
                i = kerio.engine.userDetails;
                this.userDetails = i;
                this.userEmails = i.emails;
                this.fullName = i.fullName;
                this.loginName = i.loginName;
            } else {}
            if (kerio.engine.certStoreStatus) {
                this.certStoreStatus = kerio.engine.certStoreStatus;
            }
            Ext.apply(this, kerio.engine.constants);
            this.productVersion = kerio.engine.productVersion;
            this.passwordPolicy = kerio.engine.passwordPolicy;
            if (this.THEMES) {
                t = this.THEMES;
                for (e = 0; e < t.length; e++) {
                    this.THEME_PICKER_COLORS.push(t[e].name);
                }
            }
            this.publicTarget = kerio.engine.publicTarget;
        } else {}
        if (Ext.isWindows) {
            this.osName = "Windows";
        } else {
            if (Ext.isMac) {
                this.osName = "Mac";
            } else {
                if (Ext.isLinux) {
                    this.osName = "Linux";
                }
            }
        }
        if (!kerio.engine.constants.IS_NATIVE_HTML_PARSER_ENABLED || Ext.isGecko && !Ext.isIE11 && Ext.firefoxVersion < 17) {
            this.nativeHtmlSupport = !1;
        } else {
            try {
                this.nativeHtmlSupport = Boolean(new window.DOMParser().parseFromString("", "text/html"));
            } catch (s) {
                this.nativeHtmlSupport = !1;
            }
        }
    },
    getMyMail: function() {
        return {
            address: this.userEmails[0],
            name: this.fullName
        };
    },
    oneMinuteMilliseconds: 6e4,
    oneDayMilliseconds: 864e5,
    oneWeekMilliseconds: 6048e5,
    noRecipient: k_tr("(No Recipient)", "mail"),
    noSubject: k_tr("(No Subject)", "mail"),
    baseFolders: {
        inbox: "INBOX",
        deleteItems: "Deleted Items",
        junkEmail: "Junk E-mail",
        sentItems: "Sent Items",
        drafts: "Drafts"
    },
    rootFolders: {
        publicFolders: "Public Folders",
        archiveFolders: "Archive Folders"
    },
    THEME_PICKER_COLORS: [],
    EMPTY_OBJECT: {},
    CALENDAR: "calendar",
    CONTACTS: "contacts",
    MAIL: "mail",
    MESSAGES: "messages",
    TASKS: "tasks",
    NOTES: "notes",
    SETTINGS: "settings",
    CONTACTS_AUTOCOMPLETE: "contactsAutoComplete",
    CALENDAR_DAYVIEW: "dayView",
    CALENDAR_WEEKVIEW: "weekView",
    CALENDAR_MONTHVIEW: "monthView",
    CALENDAR_AGENDAVIEW: "agendaView",
    DEFAULT_MARGIN: 4,
    DEFAULT_BORDER_MARGIN: 8,
    NAVIGATION_BAR_HEIGHT: 50,
    NAVIGATION_BAR_INPUT_HEIGHT: 30,
    URL_PREFIX: "http://",
    URL_PREFIX_REGEXP: /^[a-z\-0-9]+:/i,
    SOURCE_PATH: "/webmail/api/download/source/",
    REQUEST_TIMEOUT: 12e4,
    FILE_UPLOAD_REQUEST_TIMEOUT: 108e5,
    FILTER_CONDITION_DELIMITER: ";",
    FILE_UPLOAD_MSG: k_tr("Uploading your file…", "mail"),
    FILE_UPLOAD_TITLE: k_tr("Please Wait…", "common"),
    WEBASSIST_MESSAGE_LENGTH: 500,
    BASE64_IMAGE_REGEXP: new RegExp("^data:image/.*;base64,", "g"),
    noteColors: {
        White: "FFFFFF",
        Yellow: "F6E12D",
        Pink: "F52C68",
        Green: "59CD39",
        Blue: "2BB0F7"
    },
    calendarCategories: {
        None: {
            color: "#A2E3FC",
            iconClass: "None",
            displayText: k_tr("None", "category")
        },
        Important: {
            color: "#FFA7A4",
            iconClass: "Important",
            displayText: k_tr("Important", "category")
        },
        Business: {
            color: "#7FA8F0",
            iconClass: "Business",
            displayText: k_tr("Business", "category")
        },
        Personal: {
            color: "#8BF195",
            iconClass: "Personal",
            displayText: k_tr("Personal", "category")
        },
        Vacation: {
            color: "#DDDDDD",
            iconClass: "Vacation",
            displayText: k_tr("Vacation", "category")
        },
        MustAttend: {
            color: "#D1A454",
            iconClass: "MustAttend",
            displayText: k_tr("Must Attend", "category")
        },
        TravelRequired: {
            color: "#68F6FB",
            iconClass: "TravelRequired",
            displayText: k_tr("Travel Required", "category")
        },
        NeedsPreparation: {
            color: "#DBD772",
            iconClass: "NeedsPreparation",
            displayText: k_tr("Needs Preparation", "category")
        },
        BirthDay: {
            color: "#BC98ED",
            iconClass: "BirthDay",
            displayText: k_tr("Birthday", "category")
        },
        Anniversary: {
            color: "#7BAEBB",
            iconClass: "Anniversary",
            displayText: k_tr("Anniversary", "category")
        },
        PhoneCall: {
            color: "#FFF664",
            iconClass: "PhoneCall",
            displayText: k_tr("Phone Call", "category")
        }
    },
    calendarFreeBusyStates: {
        Free: k_tr("Free", "calendar"),
        Tentative: k_tr("Tentative", "calendar"),
        Busy: k_tr("Busy", "calendar"),
        OutOfOffice: k_tr("Out of office", "calendar")
    },
    getStyles: function() {
        var e, t = document.querySelectorAll('head>link[rel="stylesheet"], head>style[type="text/css"]'), i = "";
        for (e = 0; e < t.length; e++) {
            i = i.concat(t[e].outerHTML).concat("\n");
        }
        return i;
    },
    filterFieldsMaxLength: 600,
    filterLargeFieldsMaxLength: 4096
}, function() {
    if (this.dateOffset) {
        kerio.wm.getCurrentDate = function() {
            return new Date(+new Date() + kerio.wm.Constants.dateOffset);
        };
    } else {
        kerio.wm.getCurrentDate = function() {
            return new Date();
        };
    }
});

Ext.define("kerio.wm.AppInterface", {
    singleton: !0,
    requires: [ "kerio.wm.Constants" ],
    getCustomLogoUrl: function() {
        return kerio.wm.Constants.CUSTOM_CLIENT_LOGO_URL;
    },
    getThemeFile: function(e) {
        return e + ".css";
    },
    getActualTheme: function() {
        return kerio.wm.SettingsManager.get("webmail.userStyle");
    },
    getBlankPath: function() {
        return "/webmail/blank.html";
    },
    showDesktopNotification: function(e) {
        kerio.wm.DesktopNotification.show(e);
    },
    createNewWindow: function(e, t, i, s) {
        return window.open(e, t, i);
    },
    changeLocation: function(e, t) {
        e.location = t;
    },
    showToasterNotification: function() {
        return kerio.wm.lib.toaster.Toaster.notify.apply(kerio.wm.lib.toaster.Toaster, arguments);
    },
    dispatch: function(e) {},
    getContactPhotoUrl: function(e) {
        return e;
    },
    modifySettingItems: function(e, t) {
        return t;
    },
    setMyStatus: function(e, t) {
        kerio.wm.messages.StatusStore.getInstance().setMyStatus(e, t);
    },
    getMyStatus: function() {
        var e = kerio.wm.messages.StatusStore.getInstance().getMe();
        return e && e.get("status");
    },
    getMailtoTemplate: function(e) {
        return Ext.isArray(e) ? e : [];
    },
    setCustomFieldsToEditor: function(e, t) {},
    getInlineAttachmentPath: function(e) {
        return e;
    },
    openMailPrintWindow: function(e) {
        return this._callDefaultImpl(e);
    },
    openEventPrintWindow: function(e) {
        return this._callDefaultImpl(e);
    },
    openCalendarPrintWindow: function(e) {
        return this._callDefaultImpl(e);
    },
    addAttachment: function(e) {
        return this._callDefaultImpl(e);
    },
    downloadAttachment: function(e) {
        return this._callDefaultImpl(e);
    },
    openAboutDialog: function(e) {
        return this._callDefaultImpl(e);
    },
    settingsManagerSave: function(e) {
        return this._callDefaultImpl(e);
    },
    getDownloadUrl: function(e) {
        return this._callDefaultImpl(e);
    },
    downloadAttachmentArchive: function(e) {
        return this._callDefaultImpl(e);
    },
    previewAttachment: function(e) {
        return this._callDefaultImpl(e);
    },
    setImageUrl: function(e) {
        return e;
    },
    modifySettingsPanelsList: function(e) {
        return e;
    },
    getSoundUrl: function(e) {
        return e;
    },
    modifyMainMenuItems: function(e) {
        return e;
    },
    getIntegrationPath: function(e) {
        return e;
    },
    onPasswordChanged: function(e) {},
    serverErrors: function(e) {
        return this._callDefaultImpl(e);
    },
    onSessionExpired: function(e) {
        return e;
    },
    onLogout: function(e) {
        this._callDefaultImpl(e);
    },
    handleMailKey: function(e, t) {
        return !0;
    },
    closeOnUnload: function() {
        return !1;
    },
    closeCanceled: function() {},
    onComposerClose: function(e) {
        return this._callDefaultImpl(e);
    },
    onReloginDialogGoToLoginPage: function(e) {
        return this._callDefaultImpl(e);
    },
    onReloginRequest: function(e) {
        return this._callDefaultImpl(e);
    },
    onLoginSuccess: function(e) {
        return this._callDefaultImpl(e);
    },
    isHeaderHidden: function(e) {
        return !1;
    },
    showSessionExpiredError: function(e) {
        return !0;
    },
    download: function(e) {
        this._callDefaultImpl(e);
    },
    _callDefaultImpl: function(e) {
        return e.defaultFn.apply(e.scope || this, e.args || []);
    },
    replaceNativeContextMenu: function(e) {
        return !0;
    },
    replaceInlineImagesUrl: function(e) {
        return this._callDefaultImpl(e);
    },
    openLinkFromTooltip: function(e) {
        this._callDefaultImpl(e);
    },
    checkSavedCertStorePassword: function(e) {
        this._callDefaultImpl(e);
    },
    saveCertStorePassword: function(e) {
        return;
    },
    documentClicked: function(e) {},
    showFeedbackWindow: function(e) {
        this._callDefaultImpl(e);
    },
    onUserVoiceUrlSuccess: function(e) {
        this._callDefaultImpl(e);
    },
    onUserVoiceUrlFailure: function(e) {
        this._callDefaultImpl(e);
    },
    getServerWithProtocol: function() {
        return location.protocol + "//" + location.host;
    },
    authenticateWebSocket: function(e) {
        return this._callDefaultImpl(e);
    }
});

Ext.define("kerio.wm.ExtJsFeature", {
    singleton: !0,
    isResponsiveScrollSupported: !1,
    constructor: function() {
        Ext.view.Table.prototype.__onUpdate = Ext.view.Table.prototype.onUpdate;
        Ext.view.Table.prototype.__focusRow = Ext.view.Table.prototype.focusRow;
        Ext.override(Ext.view.Table, {
            constructor: function() {
                this.callOverridden(arguments);
                this._initUIUpdatesCache();
            },
            focusRow: function() {
                var e = this._uiUpdatesCache.focusRow;
                e.args = arguments;
                this._setTimeout(arguments.callee.$name, this._focusRowDelayed);
            },
            onUpdate: function(e, t, i, s) {
                var n, o;
                if (this.viewReady) {
                    n = this._uiUpdatesCache.onUpdate;
                    o = t.getId();
                    if (n.idx.hasOwnProperty(o)) {
                        n.args[n.args.length] = this._mergeUpdateArgs(n.args[n.idx[o]], arguments);
                        n.args[n.idx[o]] = null;
                    } else {
                        n.args[n.args.length] = arguments;
                    }
                    n.idx[o] = n.args.length - 1;
                    this._setTimeout(arguments.callee.$name, this._onUpdateUiDelayed);
                }
            },
            _focusRowDelayed: function() {
                var e = this._uiUpdatesCache.focusRow;
                this.__focusRow.apply(this, e.args);
                this._clearCache("focusRow");
            },
            _onUpdateUiDelayed: function() {
                var e, t = this._uiUpdatesCache.onUpdate, i = t.args, s = new Array(i.length), n = 0;
                for (e = 0; e < i.length; e++) {
                    if (null !== i[e]) {
                        s[n] = i[e];
                        n++;
                    }
                }
                if (this.repaintView(n) && !0 !== this.blockRefresh) {
                    this.onDataRefresh();
                } else {
                    for (e = 0; n > e; e++) {
                        this.__onUpdate.apply(this, s[e]);
                    }
                }
                this._clearCache("onUpdate");
            },
            _initUIUpdatesCache: function() {
                this._uiUpdatesCache = {
                    onUpdate: this._getCacheDef(),
                    focusRow: this._getCacheDef()
                };
            },
            _getCacheDef: function() {
                return {
                    idx: {},
                    args: [],
                    tId: null
                };
            },
            _setTimeout: function(e, t, i) {
                var s = this._uiUpdatesCache[e];
                if (!s.tId) {
                    s.tId = window.setTimeout(Ext.Function.bind(t, this, i || []), 1);
                }
            },
            _clearCache: function(e) {
                var t = this._uiUpdatesCache[e];
                window.clearTimeout(t.tId);
                t.idx = {};
                t.args = [];
                t.tId = null;
            },
            _mergeArray: function() {
                var e, t, i, s, n, o, r = [], a = {}, l = arguments.length, d = 0;
                for (e = 0; l > e; e++) {
                    r = arguments[e];
                    if (!Ext.isArray(r)) {
                        continue;
                    }
                    for (o = 0, n = r.length; n > o; o++) {
                        i = r[o];
                        if (!a[i]) {
                            a[i] = d++;
                        }
                    }
                }
                s = new Array(d);
                for (t in a) {
                    if (a.hasOwnProperty(t)) {
                        d = a[t];
                        s[d] = t;
                    }
                }
                return s;
            },
            _mergeUpdateArgs: function(e, t) {
                t[3] = this._mergeArray(e[3], t[3]);
                return t;
            },
            repaintView: function(e) {
                return e > Math.max(this.getStore().getCount() / 3, 1);
            }
        });
        var e;
        if (Ext.isMac && "MacIntel" === navigator.platform) {
            e = navigator.userAgent.match(/Mac OS X (\d+)[_\.]{1}(\d+)/);
            if (e) {
                if (-1 !== Ext.Version.compare(e[1] + "." + e[2], "10.9")) {
                    this.isResponsiveScrollSupported = !0;
                }
            }
        }
        if (Ext.AbstractComponent) {
            Ext.AbstractComponent.override({
                stateful: !1
            });
            Ext.override(Ext.AbstractComponent, {
                media: void 0,
                autoLabelWidth: !1,
                useCssLayout: !1,
                constructor: function(e) {
                    if (e && e.useCssLayout) {
                        this.shrinkWrap = 0;
                    }
                    this.callOverridden(arguments);
                },
                getComponentLayout: function() {
                    if (!0 === this.useCssLayout) {
                        if (!this.componentLayout || !this.componentLayout.isLayout) {
                            if (Ext.isString(this.componentLayout)) {
                                this.componentLayout = {
                                    type: this.componentLayout
                                };
                            }
                            this.componentLayout = Ext.apply(this.componentLayout || {}, {
                                usesContainerHeight: !1,
                                usesContainerWidth: !1,
                                usesHeight: !1,
                                usesWidth: !1
                            });
                        }
                    }
                    return this.callOverridden(arguments);
                },
                afterRender: function() {
                    this.callOverridden(arguments);
                    if (this.media) {
                        this._initMediaListeners(this.media);
                    }
                    if (this.autoLabelWidth) {
                        this.updateLabelWidth();
                    }
                },
                updateLabelWidth: function() {
                    this.setLabelWidth(this.calcLabelWidth());
                },
                calcLabelWidth: function() {
                    var e = Ext.util.TextMetrics;
                    if (void 0 !== this.fieldLabel && !this.hideLabel) {
                        return e.measure(this.labelEl, this.fieldLabel, !1).width;
                    }
                    return null;
                },
                setLabelWidth: function(e) {
                    this.labelWidth = e;
                    if (this.rendered) {
                        if (this.labelCell) {
                            this.labelCell.set({
                                width: e + this.labelPad
                            });
                        }
                        this.labelEl.setWidth(e);
                    }
                },
                _initMediaListeners: function(e) {
                    var t;
                    if (!window.matchMedia) {
                        return;
                    }
                    for (t in e) {
                        if (e.hasOwnProperty(t)) {
                            this._setMqListener(t);
                        }
                    }
                },
                _setMqListener: function(e, t) {
                    var i, s = this._mqHandlerWrap;
                    i = window.matchMedia(e);
                    t = Ext.Function.bind(s, this, [ e ], !0);
                    this.media[e]._handlerWrap = t;
                    this.media[e]._mql = i;
                    i.addListener(t);
                    t.apply(this, [ i, e ]);
                },
                _removeMqListener: function(e) {
                    this.media[e]._mql.removeListener(this.media[e]._handlerWrap);
                },
                _removeAllMqListeners: function() {
                    var e, t = this.media;
                    for (e in t) {
                        if (t.hasOwnProperty(e)) {
                            this._removeMqListener(e);
                        }
                    }
                },
                _mqHandlerWrap: function(e, t) {
                    this.media[t].fn.apply(this.media[t].scope || this, [ this, t, e.matches, e ]);
                },
                onDestroy: function() {
                    this.callOverridden(arguments);
                    this._removeAllMqListeners();
                }
            });
        }
        Ext.override(Ext.container.AbstractContainer, {
            autoLabelWidth: !1,
            afterRender: function() {
                this.callOverridden(arguments);
                if (this.autoLabelWidth) {
                    this.updateLabelWidth();
                }
            },
            updateLabelWidth: function() {
                var e, t, i = [], s = 0, n = 0, o = this.items;
                for (t = 0; t < o.length; t++) {
                    e = o.getAt(t);
                    n = e.calcLabelWidth();
                    if (null !== n) {
                        if (n > s) {
                            s = n;
                        }
                        i.push(e);
                    }
                }
                this.setLabelWidth(s, i);
            },
            setLabelWidth: function(e, t) {
                var i, s;
                for (s = 0; s < t.length; s++) {
                    i = t[s];
                    i.setLabelWidth(e);
                }
            }
        });
        Ext.override(Ext.util.Floating, {
            constructor: function() {
                this.shadow = !1;
                return this.callOverridden(arguments);
            }
        });
        Ext.override(Ext.data.Connection, {
            createResponse: function(e) {
                var t = this.callOverridden([ e ]);
                return this._extendResponse(t);
            },
            createException: function(e) {
                var t = this.callOverridden([ e ]);
                return this._extendResponse(t);
            },
            _extendResponse: function(e) {
                e.stopErrorProcessing = this._responseStopErrorProcessing;
                e.hasErrors = this._responseHasErrors;
                return e;
            },
            _responseStopErrorProcessing: function() {
                this._suppressInternalErrorHandler = !0;
            },
            _responseHasErrors: function() {
                var e, t, i;
                if (void 0 === this._errorCodes) {
                    this._errorCodes = [];
                    e = this.decoded && (this.decoded.error || this.decoded.result.errors);
                    if (e) {
                        if (!Ext.isArray(e)) {
                            e = [ e ];
                        }
                        for (t = 0, i = e.length; i > t; t++) {
                            this._errorCodes.push(e[t].code);
                        }
                    }
                }
                if (this._errorCodes.length > 0) {
                    if (0 === arguments.length) {
                        return !0;
                    }
                    for (t = 0, i = arguments.length; i > t; t++) {
                        if (-1 !== Ext.Array.indexOf(this._errorCodes, arguments[t])) {
                            return !0;
                        }
                    }
                }
                return !1;
            }
        });
        Ext.override(Ext.panel.Panel, {
            setPosition: function() {
                var e = this.callSuper(arguments);
                this._allowPositionAdjusting();
                return e;
            },
            doComponentLayout: function() {
                var e = this.callSuper(arguments);
                this._adjustPositionToVisibleArea();
                return e;
            },
            _allowPositionAdjusting: function() {
                this._intialAdjusting = !0;
            },
            _adjustPositionToVisibleArea: function() {
                if (!this.floating || !this._intialAdjusting || this._isAdjusting || this instanceof Ext.menu.Menu || this.disablePositionAdjusting) {
                    return;
                }
                this._isAdjusting = !0;
                this._adjustPositionPrivate();
            },
            _adjustPositionPrivate: function() {
                var e, t, i = this.constrainTo || this.constrainToEl || this.el.getScopeParent(), s = Ext.get(i).getViewRegion(), n = this._getPanelRegion(), o = n.getSize(), r = this.constrainToElMargins || {
                    top: 5,
                    right: -5,
                    bottom: -5,
                    left: 5
                };
                s.adjust(r.top, r.right, r.bottom, r.left);
                e = s.getSize();
                t = this._getClippedDiff(n, s);
                if (0 === t.width && 0 === t.height) {
                    this._isAdjusting = !1;
                    return;
                }
                t.height *= -1;
                t.width *= -1;
                n.translateBy({
                    x: t.width,
                    y: t.height
                });
                n.constrainTo(s);
                o.width = Math.min(o.width, e.width);
                o.height = Math.min(o.height, e.height);
                this.setPosition(n.x, n.y);
                if (this._lastPointerAlignCmp) {
                    this.alignPointer(this._lastPointerAlignCmp);
                }
                this._isAdjusting = !1;
            },
            _getClippedDiff: function(e, t) {
                var i, s;
                e = e.copy();
                i = e.getSize();
                e.constrainTo(t);
                s = e.getSize();
                return this._vectorSubstract(i, s);
            },
            _vectorSubstract: function(e, t) {
                return {
                    width: e.width - t.width,
                    height: e.height - t.height
                };
            },
            _getPanelRegion: function() {
                var e = this.getPosition(), t = this.getSize();
                return new Ext.util.Region(e[1], t.width + e[0], t.height + e[1], e[0]);
            }
        });
        Ext.override(Ext.window.Window, {
            _initialWidth: void 0,
            _initialHeight: void 0,
            _lastSize: void 0,
            _userPosition: null,
            _userSize: null,
            outerSpace: 15,
            outerSpaceTreshold: 300,
            resetPosOnShow: !1,
            fitViewport: !1,
            initComponent: function() {
                this.callParent(arguments);
                this._initialWidth = this.width;
                this._initialHeight = this.height;
            },
            afterRender: function() {
                this.callParent(arguments);
                if (this.fitViewport) {
                    if (this.floatParent) {
                        this.floatParent.on("resize", function(e, t, i) {
                            this.constrainToViewport(t, i);
                        }, this);
                    } else {
                        Ext.EventManager.onWindowResize(this.constrainToViewport, this);
                    }
                }
            },
            beforeShow: function() {
                this.callParent(arguments);
                if (this.resetPosOnShow) {
                    this.setWidth(this._initialWidth);
                    this.setHeight(this._initialHeight);
                    this._userPosition = null;
                    this._userSize = null;
                }
                if (this.fitViewport) {
                    this.constrainToViewport(!0);
                }
            },
            initDraggable: function() {
                this.callParent(arguments);
                this.dd && this.dd.on("dragend", function() {
                    this._userPosition = this.getPosition();
                }, this);
            },
            initResizable: function() {
                this.callParent(arguments);
                this.resizer && this.resizer.on("resize", function(e, t, i) {
                    this._userSize = [ t, i ];
                }, this);
            },
            center: function(e) {
                var t = this.el.getAlignToXY(this.contrainTo || this.container, "c-c"), i = this.getPosition(), s = this.getConstrainOffset();
                if ("horizontal" === e) {
                    t[1] = i[1];
                    t[0] += s.l / 2;
                } else {
                    if ("vertical" === e) {
                        t[0] = i[0] + s.y;
                        t[1] += s.t / 2;
                    } else {
                        t[0] += s.l / 2;
                        t[1] += s.t / 2;
                    }
                }
                this.setPagePosition(t);
                return this;
            },
            getConstrainOffset: function() {
                var e, t, i = this.container, s = this.constrainTo;
                if (!i || !s) {
                    return;
                }
                e = i.getBox();
                t = s.getBox();
                return {
                    l: Math.max(0, t.x - e.x),
                    t: Math.max(0, t.y - e.y),
                    r: Math.max(0, e.x + e.width - (t.x + t.width)),
                    b: Math.max(0, e.y + e.height - (t.y + t.height))
                };
            },
            constrainToViewport: function(e, t) {
                if (!this.container && !this.constrainTo) {
                    return;
                }
                var i, s, n, o, r, a, l, d = this.constrainTo || this.container, c = e === !0 ? d.getSize() : {
                    width: e,
                    height: t
                }, h = this.getSize(), u = 2 * this.outerSpace, f = null !== this._userSize;
                if (c.height < this.outerSpaceTreshold || c.width < this.outerSpaceTreshold) {
                    u = 0;
                }
                if (e === !0) {
                    o = h.width;
                    r = h.height + this.getTotalScrollArea();
                } else {
                    i = {
                        width: f ? this._userSize[0] : this._initialWidth,
                        height: f ? this._userSize[1] : this._initialHeight
                    };
                    o = Math.max(h.width, i.width);
                    r = Math.max(h.height, i.height);
                    if (!this._userSize) {
                        r += h.height - r + this.getTotalScrollArea() + 2;
                    }
                }
                if (o > c.width - u) {
                    o = c.width - u;
                }
                if (r > c.height - u) {
                    r = c.height - u;
                }
                s = o !== h.width;
                n = r !== h.height;
                a = Math.min(o, this.minWidth);
                l = Math.min(r, this.minHeight);
                if (s || n) {
                    Ext.apply(this, {
                        minWidth: a,
                        minHeight: l
                    });
                    this.setSize({
                        width: o,
                        height: r
                    });
                }
                if (this._userPosition) {
                    this.setPosition(this._userPosition[0] - d.getLeft(), this._userPosition[1] - d.getTop());
                } else {
                    this.center();
                }
            },
            getTotalScrollArea: function() {
                var e, t, i = Ext.ComponentQuery.query("[autoScroll=true]", this), s = 0;
                for (e = 0, t = i.length; t > e; e++) {
                    if (!i[e].rendered) {
                        continue;
                    }
                    s += Math.max(0, i[e].getEl().dom.scrollHeight - i[e].getHeight());
                }
                return s;
            }
        });
        Ext.override(Ext.toolbar.Toolbar, {
            _isTextBtn: function(e) {
                return e instanceof Ext.button.Button && void 0 === e.iconCls;
            },
            _isDefaultBtn: function(e) {
                return e instanceof Ext.button.Button && !0 === e.isDefault;
            },
            beforeLayout: function() {
                if (this.isVisible(!0) && !0 !== this.vertical) {
                    this._setButtonSeparator();
                }
                return this.callOverridden(arguments);
            },
            _parseMargins: function(e) {
                var t, i, s = {
                    top: 0,
                    right: 0,
                    bottom: 0,
                    left: 0
                }, n = e.getEl();
                if (!(n && e.margins && e instanceof Ext.button.Button)) {
                    return;
                }
                i = n.dom.style;
                i.margin = "";
                t = n.getMargin();
                s.top += t.top;
                s.right += t.right;
                s.bottom += t.bottom;
                s.left += t.left;
                s.height = s.top + s.bottom;
                s.width = s.left + s.right;
                i.marginTop = i.marginRight = i.marginBottom = i.marginLeft = "0";
                e.margins = s;
            },
            _clearCachedLayout: function(e) {
                var t = e.getComponentLayout();
                if (t && t.adjWidth) {
                    delete t.adjWidth;
                }
            },
            _setButtonSeparator: function() {
                var e, t, i, s, n, o = "separator", r = "btnFirstVisible", a = "btnLastVisible", l = "spacer", d = this.getLayout().getVisibleItems();
                function c(e) {
                    return e && e.rendered ? {
                        wasFirst: e.el.hasCls(r),
                        wasLast: e.el.hasCls(a)
                    } : {};
                }
                if (!d.length) {
                    return;
                }
                if (d[0].iconCls) {
                    return;
                }
                for (n = 0; n < d.length - 1; n++) {
                    e = d[n];
                    t = d[n + 1];
                    i = c(e);
                    s = 0 === n && i.wasFirst;
                    e.removeCls([ r, a, l, o ]);
                    if (this._isTextBtn(e) && this._isDefaultBtn(t) || this._isDefaultBtn(e) && this._isTextBtn(t)) {
                        e.addCls(l);
                    } else {
                        if (this._isTextBtn(e) && this._isTextBtn(t) && !this._isDefaultBtn(e)) {
                            e.addCls(o);
                        }
                    }
                    this._parseMargins(e);
                    if (i.wasLast || i.wasFirst && n > 0) {
                        this._clearCachedLayout(e);
                    }
                }
                e = d[0];
                if (this._isTextBtn(e) && !this._isDefaultBtn(e)) {
                    e.addCls(r);
                    if (!s) {
                        this._clearCachedLayout(e);
                    }
                }
                e = d[d.length - 1];
                i = c(e);
                e.removeCls([ r, a, o, l ]);
                this._parseMargins(e);
                if (this._isTextBtn(e) && !this._isDefaultBtn(e)) {
                    e.addCls(a);
                }
                if (i.wasFirst || !i.wasLast) {
                    this._clearCachedLayout(e);
                }
            },
            _setDefaultChangedHandler: function(e) {
                if (e instanceof kerio.wm.view.WebmailButton) {
                    e.on("defaultchanged", function(e) {
                        this._setButtonSeparator(e);
                    }, this);
                }
            },
            _onItemAdded: function(e, t) {
                this._setDefaultChangedHandler(t);
            },
            initComponent: function() {
                var e, t;
                this.callOverridden(arguments);
                if (!0 !== this.vertical) {
                    this.on("add", this._onItemAdded, this);
                    e = this.items;
                    for (t = 0; t < e.getCount(); t++) {
                        this._setDefaultChangedHandler(e.getAt(t));
                    }
                }
            }
        });
        Ext.Date.areSameDays = function(e, t) {
            var i = Ext.Date.clearTime(e, !0), s = Ext.Date.clearTime(t, !0);
            return +i === +s;
        };
        if (this.isResponsiveScrollSupported) {
            Ext.override(Ext.panel.Table, {
                onMouseWheel: function(e) {
                    if (!this.isMouseWheelPatched) {
                        kerio.wm.utils.PointingDevice.registerWheelScroller(this.getView().el, e);
                        this.isMouseWheelPatched = !0;
                    }
                    if (kerio.wm.utils.PointingDevice.isResponsiveScrolling) {
                        this.scrollDelta = Math.min(Math.abs(e.browserEvent.wheelDeltaY), kerio.wm.utils.PointingDevice.maxWheelDelta);
                    } else {
                        this.scrollDelta = Ext.panel.Table.prototype.scrollDelta;
                    }
                    this.callOverridden(arguments);
                }
            });
        }
        Ext.override(Ext.form.field.Text, {
            trimValue: !1,
            processRawValue: function() {
                var e = this.callOverridden(arguments);
                if (this.trimValue && "string" == typeof e) {
                    e = Ext.String.trim(e);
                }
                return e;
            },
            focus: function() {
                if (!1 !== this.fireEvent("beforefocus", this)) {
                    this.callOverridden(arguments);
                }
            }
        });
        Ext.override(Ext.form.field.ComboBox, {
            getValue: function() {
                var e = this.callOverridden(arguments);
                if (this.trimValue && "string" == typeof e) {
                    e = Ext.String.trim(e);
                }
                return e;
            }
        });
        Ext.override(Ext.form.field.Picker, {
            alignPicker: function() {
                var e, t;
                this.callOverridden(arguments);
                if (this.isExpanded && this.matchLongestValueWidth) {
                    e = this.picker;
                    e.addCls("autoWidth");
                    e.minWidth = this.getWidth();
                    t = e.getWidth();
                    e.removeCls("autoWidth");
                    if (t > this.getWidth()) {
                        t += Ext.getScrollbarSize().width;
                    } else {
                        t = this.getWidth();
                    }
                    e.setWidth(t);
                }
            },
            overridePickerSingleSelect: function(e) {
                e.selModel.doSingleSelect = Ext.Function.createInterceptor(e.selModel.doSingleSelect, this._collapseAfterClickOnSelected, e.selModel);
            },
            _collapseAfterClickOnSelected: function(e, t) {
                if (this.isSelected(e) && !t) {
                    this.maybeFireSelectionChange(!t);
                    return !1;
                }
            }
        });
        Ext.override(Ext.Component, {
            constructor: function(e) {
                this.callParent(arguments);
                if (this.controller && "string" == typeof this.controller) {
                    this.controller = Ext.create(this.controller, {
                        view: this
                    });
                }
            }
        });
    }
});

Ext.define("kerio.wm.view.Viewport", {
    extend: "Ext.container.Viewport",
    styles: !0,
    cls: "webmail",
    itemId: "mainView",
    layout: {
        type: "vbox",
        align: "stretch",
        pack: "start"
    },
    defaults: {
        border: !1,
        bodyBorder: !1
    },
    items: [ {
        xtype: "navigationbar"
    }, {
        xtype: "container",
        flex: 1,
        cls: "modules",
        bodyCls: "moduleBody",
        itemId: "modules",
        layout: {
            type: "card",
            deferredRender: !1
        }
    } ],
    constructor: function() {
        if (Ext.isGecko && Ext.firefoxVersion <= 29 && !Ext.isIE11 && Ext.firefoxVersion > 0) {
            Ext.getBody().addCls("ff29p");
        }
        this.callParent(arguments);
        this.insert(0, kerio.wm.lib.toaster.Toaster.getView());
    }
});

Ext.define("kerio.wm.DisableSelection", {
    singleton: !0,
    requires: [ "kerio.wm.AppInterface" ],
    constructor: function() {
        var e = Ext.getDoc();
        if (Ext.isIE) {
            e.on("selectstart", this._allowOrReplaceNativeContextMenu.bind(this));
        }
        e.on("contextmenu", this._allowOrReplaceNativeContextMenu.bind(this));
        e.on("click", function(e) {
            kerio.wm.AppInterface.documentClicked(e);
        });
    },
    _allowNativeContextMenu: function() {
        var e = Ext.EventObject, t = e.getTarget(), i = Ext.get(t), s = "", n = null;
        if (Ext.isIE && (!i || i && i.dom.disabled)) {
            Ext.EventObject.stopEvent(e);
            return !1;
        }
        if (i.findParent(".selectable")) {
            return !0;
        }
        if (t.tagName) {
            s = t.tagName.toLowerCase();
        }
        if ("input" === s || "textarea" === s) {
            n = t.type;
            if (0 !== e.button) {
                if ("radio" === n || "checkbox" === n) {
                    Ext.EventObject.stopEvent(e);
                    return !1;
                }
            }
            return !0;
        }
        Ext.EventObject.stopEvent(e);
        return !1;
    },
    _allowOrReplaceNativeContextMenu: function(e, t) {
        return this._allowNativeContextMenu() && kerio.wm.AppInterface.replaceNativeContextMenu({
            scope: this,
            args: [ e, t ]
        });
    }
});

Ext.define("kerio.wm.view.FloatingPanel", {
    extend: "Ext.panel.Panel",
    alias: "widget.floatingpanel",
    floating: !0,
    constrain: !0,
    focusOnToFront: !0,
    toFrontOnShow: !0,
    preventHeader: !0,
    closeAction: "destroy",
    styles: !0,
    autoScroll: !0,
    baseCls: "floatingPanel",
    autoHide: !0,
    autoHideExceptionSelector: "",
    constrainToEl: null,
    autoFocus: !0,
    alignOrder: [ "bottom", "top", "right", "left" ],
    marginsOrder: [ "top", "right", "bottom", "left" ],
    marginsOrientation: [ "1", "-1", "-1", "1" ],
    alignDef: {
        top: "b-t",
        bottom: "t-b",
        right: "l-r",
        left: "r-l"
    },
    hideMode: "visibility",
    renderTpl: function() {
        return [ '<div id="{id}-pointer" class="{baseCls}-pointer"></div>' ].concat(Ext.panel.Panel.prototype.renderTpl);
    }(),
    statics: {
        instCount: 0,
        alignEl: null
    },
    outerSpace: 15,
    outerSpaceTreshold: 300,
    _align: void 0,
    constructor: function(e) {
        var t, i, s, n = 0;
        if (e) {
            if (e.constrainToEl) {
                e.constrainToEl = e.constrainToEl.el || Ext.get(e.constrainToEl);
            }
            if (e.constrainToElMargins) {
                i = {};
                t = Ext.isNumber(e.constrainToElMargins) ? e.constrainToElMargins : 5;
                if (Ext.isArray(e.constrainToElMargins)) {
                    n = e.constrainToElMargins.length;
                }
                for (s = 0; 4 > s; ++s) {
                    i[this.marginsOrder[s]] = n > s ? e.constrainToElMargins[s] : t * this.marginsOrientation[s];
                }
                e.constrainToElMargins = Ext.apply({}, e.constrainToElMargins, i);
            }
        }
        this.callParent(arguments);
        this.self.instCount = this.self.instCount++ || 1;
        this.on("resize", this._onResize, this);
    },
    initComponent: function() {
        this.callParent(arguments);
        this._initialWidth = this.width;
        this._initialHeight = this.height;
        this.addChildEls("pointer");
    },
    _realignOnResize: function() {
        this.constrainToViewport(!0);
        if (this._alignToEl && this.isVisible()) {
            this.showBy(this._alignToEl, this._align);
        }
    },
    _getRectEl: function() {
        var e = this.self.alignEl;
        if (!e) {
            e = Ext.getBody().createChild({
                tag: "div",
                cls: this.baseCls + "-rectEl"
            });
            e.setVisibilityMode(Ext.Element.VISIBILITY);
            this.self.alignEl = e;
        }
        return e;
    },
    onRender: function() {
        this.callParent(arguments);
        this.focusEl = this.el;
        this._pointerWidth = this.pointer.dom.offsetWidth;
        this._pointerHalfWidth = Math.floor(this._pointerWidth / 2);
    },
    showByRect: function(e, t, i) {
        var s = this._getElByRect(e);
        return this.showBy(s, t, i);
    },
    _getElByRect: function(e) {
        var t = this._getRectEl();
        if (e.getSize && (!e.width || !e.height)) {
            e = Ext.apply(e, e.getSize());
        }
        t.setBox(e);
        return t;
    },
    showBy: function(e, t, i, s, n) {
        var o, r, a, l, d, c, h, u, f, m, p = this, g = !this.rendered;
        if (p.floating && e) {
            if (Ext.isString(e)) {
                e = Ext.get(e);
            }
            e = e.el || Ext.get(e);
            if (s) {
                m = (!0 === s ? e : s.el || Ext.get(s)).id;
            }
            if (m) {
                if (this._lastInvoker) {
                    if (m === this._lastInvoker) {
                        if (!n) {
                            this.close();
                        }
                        return p;
                    } else {
                        this.close();
                    }
                }
                this._additionalAutoHideExceptionSelector = m ? "#" + m : void 0;
            }
            p.renderOffScreen();
            u = p.el.getAlignToXY(e, this.getAlign(t, e), i);
            r = e.getRegion();
            a = u.slice(0);
            if (p.floatParent) {
                f = p.floatParent.getTargetEl().getViewRegion();
                u[0] -= f.x;
                u[1] -= f.y;
            }
            i = i || [ 0, 0 ];
            l = Math.abs(r.top - (a[1] + this.getHeight() - i[1])) < 2;
            d = Math.abs(r.bottom - (a[1] - i[1])) < 2;
            c = Math.abs(r.left - (a[0] + this.getWidth() - i[0])) < 2;
            h = Math.abs(r.right - (a[0] - i[0])) < 2;
            o = this._pointerHalfWidth + 3;
            if (h) {
                this.setPointerPos("left");
                u[0] += o;
            } else {
                if (c) {
                    this.setPointerPos("right");
                    u[0] -= o;
                } else {
                    if (d) {
                        this.setPointerPos("top");
                        u[1] += o;
                    } else {
                        if (l) {
                            this.setPointerPos("bottom");
                            u[1] -= o;
                        }
                    }
                }
            }
            if (!this.disablePositionAdjusting) {
                this._lastAlignArgs = void 0;
            }
            p._showAt(u);
            if (m) {
                this._lastInvoker = m;
            }
            if (g) {
                if (this.constrain) {
                    this.doConstrain();
                }
            }
            this.alignPointer(e);
            if (!this.disablePositionAdjusting) {
                this._lastAlignArgs = Array.prototype.slice.call(arguments);
                this._lastAlignArgs[0] = e.getRegion();
            }
            this._align = t;
            this._alignToEl = e;
            Ext.EventManager.onWindowResize(this._realignOnResize, this);
        }
        return p;
    },
    renderOffScreen: function() {
        if (!this.rendered) {
            this._showAt(-1e3, -1e3);
        }
    },
    doAutoRender: function() {
        var e = this.rendered;
        this.callParent(arguments);
        if (this.rendered !== e) {
            this._isFirstShowAfterRender = !0;
        }
    },
    show: function() {
        var e = this;
        if (this._isFirstShowAfterRender) {
            if (e.fireEvent("beforeshow", e) === !1) {
                return;
            }
            e.beforeShow();
            e.onShow.apply(e, arguments);
            e.afterShow.apply(e, arguments);
            delete this._isFirstShowAfterRender;
            return e;
        }
        return this.callParent(arguments);
    },
    _showAt: function(e) {
        return Ext.panel.Panel.prototype.showAt.apply(this, arguments);
    },
    showAt: function(e) {
        return this.showByRect({
            x: e[0] - 10,
            y: e[1] - 10,
            width: 20,
            height: 20
        });
    },
    _getAutoAlign: function(e) {
        var t, i, s, n = this.getConstrainToRegion(!0), o = this.getEl().getSize(), r = this.alignOrder, a = this.alignDef, l = null;
        i = {
            bottom: {
                top: 0,
                right: n.width,
                bottom: n.height - e.bottom,
                left: 0
            },
            top: {
                top: 0,
                right: n.width,
                bottom: e.y,
                left: 0
            },
            right: {
                top: 0,
                right: n.width - e.y,
                bottom: n.height,
                left: 0
            },
            left: {
                top: 0,
                right: e.x,
                bottom: n.height,
                left: 0
            }
        };
        t = new Ext.util.Region(0, o.width, o.height, 0);
        for (s = 0; s < r.length; s++) {
            if (Ext.util.Region.from(i[r[s]]).contains(t)) {
                l = a[r[s]];
                break;
            }
        }
        if (null === l) {
            l = a[r[0]];
        }
        return l;
    },
    getAlign: function(e, t) {
        if ("auto" === e || !e) {
            return this._getAutoAlign(Ext.fly(t).getBox());
        }
        if (e.indexOf("-") >= 0) {
            return e;
        } else {
            return e.split("").join("-") + "?";
        }
    },
    alignPointer: function(e) {
        var t, i = this.getPointerPos(), s = this.getPointerAlignStyleName(), n = Ext.Element.addUnits, o = {
            top: "",
            left: "",
            bottom: "",
            right: ""
        };
        t = this._pointerHalfWidth;
        switch (i) {
          case "top":
          case "bottom":
            o[i] = n(-t);
            o[s] = n(this.calculatePointerAlign(e));
            break;

          default:
            o[i] = n(-t);
            o[s] = n(this.calculatePointerAlign(e));
        }
        this.pointer.applyStyles(o);
        if (Ext.util.Region.from(this._getElBox(e)).contains(this._getElBox(this.pointer)) || Ext.util.Region.from(this._getElBox(this.getEl())).contains(this._getElBox(e))) {
            this.hidePointer();
        } else {
            this.showPointer();
        }
        this._lastPointerAlignCmp = e;
    },
    getPointerPos: function() {
        return this.position || "left";
    },
    _getElBox: function(e) {
        var t = e.getBox();
        t.left = t.x;
        t.top = t.y;
        return t;
    },
    setPointerPos: function(e) {
        if (this.pointer && this.position) {
            this.pointer.setStyle(this.position, "auto");
        }
        this.position = e;
    },
    getPointerAlignStyleName: function() {
        var e = this.getPointerPos();
        if ("left" === e || "right" === e) {
            return "top";
        } else {
            return "left";
        }
    },
    isPointerLeftOrRight: function() {
        var e = this.getPointerPos();
        return "left" === e || "right" === e;
    },
    isPointerTopOrBottom: function() {
        var e = this.getPointerPos();
        return "top" === e || "bottom" === e;
    },
    calculatePointerAlign: function(e) {
        var t, i, s, n, o = this._pointerWidth, r = this.isPointerTopOrBottom(), a = r ? e.getWidth() : e.getHeight(), l = r ? e.getX() : e.getY(), d = r ? this.getEl().getWidth() : this.getEl().getHeight(), c = r ? this.getEl().getX() : this.getEl().getY();
        t = l - c + Math.floor(a / 2) - Math.floor(o / 2);
        this.pointerPadding = this.pointerPadding || 5;
        i = d - o - this.pointerPadding;
        s = this.pointerPadding;
        if (t > i) {
            n = l - c - Math.floor(o / 2);
            t = i > n ? i : n;
        } else {
            if (s > t) {
                n = l - c + Math.floor(o / 2);
                t = n > i ? i : n;
            }
        }
        return t;
    },
    hidePointer: function() {
        this.setPointerVisible(!1);
    },
    showPointer: function() {
        this.setPointerVisible(!0);
    },
    setPointerVisible: function(e) {
        if (this.pointer) {
            this.pointer.setDisplayed(!1 !== e);
        }
    },
    onShow: function() {
        var e = this.callParent(arguments);
        this._initAutoHide();
        return e;
    },
    onHide: function() {
        var e = this.callParent(arguments);
        this._lastInvoker = void 0;
        this._additionalAutoHideExceptionSelector = void 0;
        this._removeAutoHideHandler();
        return e;
    },
    _initAutoHide: function() {
        if (this.autoHide) {
            var e, t, i, s;
            if (Ext.isArray(this.autoHideExceptionSelector)) {
                e = this.autoHideExceptionSelector;
            } else {
                if (this._additionalAutoHideExceptionSelector && this.autoHideExceptionSelector) {
                    if (0 === this.autoHideExceptionSelector.indexOf(":any(") && this.autoHideExceptionSelector.indexOf(")", 5) === this.autoHideExceptionSelector.length - 1) {
                        i = this.autoHideExceptionSelector.substr(5, this.autoHideExceptionSelector.length - 6);
                        e = i.split("|");
                    }
                } else {
                    t = this.autoHideExceptionSelector;
                }
            }
            if (e) {
                t = [];
                for (s = 0; s < e.length; s++) {
                    t.push(e[s]);
                }
                if (this._additionalAutoHideExceptionSelector) {
                    t.push(this._additionalAutoHideExceptionSelector);
                }
                t = ":any(" + t.join("|") + ")";
            } else {
                if (this.autoHideExceptionSelector) {
                    t = this.autoHideExceptionSelector;
                } else {
                    t = this._additionalAutoHideExceptionSelector;
                }
            }
            this.usedAutoHideExceptionSelector = t || "";
            Ext.getDoc().on("mousedown", this._doAutoHide, this);
        }
    },
    isAutoHideExceptionEl: function(e) {
        var t, i;
        if (this.usedAutoHideExceptionSelector && -1 !== this.usedAutoHideExceptionSelector.indexOf(",")) {
            t = this.usedAutoHideExceptionSelector.split(",");
            for (i = 0; i < t.length; i++) {
                if (e.getTarget(t[i])) {
                    return !0;
                }
            }
            return !1;
        }
        return "" !== this.usedAutoHideExceptionSelector && !!e.getTarget(this.usedAutoHideExceptionSelector);
    },
    _doAutoHide: function(e) {
        if (e.within(this.getEl()) || this.isAutoHideExceptionEl(e) || !this.isAutoHideAllowed()) {
            return;
        }
        this.close();
    },
    isAutoHideAllowed: function() {
        return !0;
    },
    _removeAutoHideHandler: function() {
        if (this.autoHide) {
            Ext.getDoc().un("mousedown", this._doAutoHide, this);
        }
    },
    doConstrain: function(e) {
        if (void 0 === e) {
            this.constrainToRegion = void 0;
            e = this.getConstrainToRegion();
        }
        this.callParent([ e ]);
    },
    _getConstrainToEl: function() {
        return this.constrainToEl || Ext.get(this.getEl().getScopeParent()) || Ext.getBody();
    },
    getConstrainToRegion: function(e) {
        var t, i = this.constrainToRegion;
        if (void 0 === i) {
            i = this._getConstrainToEl().getViewRegion();
            t = this.constrainToElMargins || {
                top: 5,
                right: -5,
                bottom: -5,
                left: 5
            };
            i.adjust(t.top, t.right, t.bottom, t.left);
            this.constrainToRegion = i;
        }
        return e ? Ext.apply(i, i.getSize()) : i;
    },
    onDestroy: function() {
        this.callParent(arguments);
        Ext.EventManager.removeResizeListener(this._realignOnResize, this);
        delete this._alignToEl;
        this.self.instCount--;
        this._lastInvoker = void 0;
        this._additionalAutoHideExceptionSelector = void 0;
        this._removeAutoHideHandler();
        Ext.destroy(this.pointer);
        delete this.pointer;
        if (!this.self.instCount && this.self.alignEl) {
            Ext.destroy(this.self.alignEl);
            delete this.self.alignEl;
        }
    },
    afterComponentLayout: function() {
        if (this._isAfterLayoutRunning) {
            return;
        }
        this._isAfterLayoutRunning = !0;
        var e = this.callParent(arguments), t = this._lastAlignArgs && this._lastAlignArgs[0], i = t && this._getElByRect(t), s = this._lastAlignArgs && this._lastAlignArgs[1], n = this._lastAlignArgs && this._lastAlignArgs[2];
        if (!this._lastAlignArgs) {
            delete this._isAfterLayoutRunning;
            return e;
        }
        if (this._isPointerOutOfPanel()) {
            this.showBy(i, s, n);
            if (this._isPointerOutOfScreen()) {
                s = "l-r" === this.getAlign(s, i) ? "tb" : "lr";
                this.showBy(i, s, n);
            }
        } else {
            if (this._isPointerOutOfScreen()) {
                this.showBy(i, s, n);
            }
        }
        if (this._isPanelOutOfScreen()) {
            this._adjustPositionPrivate();
        }
        delete this._isAfterLayoutRunning;
        return e;
    },
    _onResize: function() {
        if (this._intialAdjusting && this._lastAlignArgs && !this.disablePositionAdjusting) {
            this.constrainToViewport(!0);
            this.showByRect.apply(this, this._lastAlignArgs);
        }
    },
    _isPointerOutOfPanel: function() {
        var e, t, i = this.getPointerPos(), s = this.pointer.getXY(), n = this.el.getViewRegion();
        if ("left" === i || "right" === i) {
            e = n.getOutOfBoundOffsetY(s[1]);
            t = n.getOutOfBoundOffsetY(s[1] + this.pointer.getHeight());
        } else {
            e = n.getOutOfBoundOffsetX(s[0]);
            t = n.getOutOfBoundOffsetX(s[0] + this.pointer.getWidth());
        }
        return 0 !== e || 0 !== t;
    },
    _isRegionOutOfSreen: function(e, t) {
        var i, s = Ext.getBody().getViewRegion(), n = 5;
        s.adjust(n, -n, -n, n);
        i = this._getClippedDiff(e, s);
        if (t) {
            return i;
        }
        return 0 !== i.width || 0 !== i.height;
    },
    _isPointerOutOfScreen: function(e) {
        return this._isRegionOutOfSreen(this.pointer.getViewRegion(), e);
    },
    _isPanelOutOfScreen: function(e) {
        return this._isRegionOutOfSreen(this.el.getViewRegion(), e);
    },
    setConstrainToEl: function(e) {
        this.constrainToRegion = void 0;
        this.constrainToEl = e.el || Ext.get(e);
    },
    updateHeader: function(e) {
        this.callParent(arguments);
        if (!this.header || !this.header.isVisible()) {
            this.addCls("noPanelHeader");
        }
    },
    afterRender: function() {
        this.callParent(arguments);
        this.el.set({
            tabIndex: -1
        });
    },
    constrainToViewport: function(e, t) {
        if (!this.container && !this.constrainTo) {
            return;
        }
        var i, s, n, o, r, a, l = this.constrainTo || this.container, d = e === !0 ? l.getSize() : {
            width: e,
            height: t
        }, c = this.getSize(), h = 2 * this.outerSpace;
        if (d.height < this.outerSpaceTreshold || d.width < this.outerSpaceTreshold) {
            h = 0;
        }
        if (!(e !== !0 || this._initialWidth && this._initialHeight)) {
            n = c.width;
            o = c.height;
        } else {
            n = Math.max(c.width, this._initialWidth);
            o = Math.max(c.height, this._initialHeight);
            o += c.height - o + 2;
        }
        if (n > d.width - h) {
            n = d.width - h;
        }
        if (o > d.height - h) {
            o = d.height - h;
        }
        i = n !== c.width;
        s = o !== c.height;
        r = Math.min(n, this.minWidth);
        a = Math.min(o, this.minHeight);
        if (i || s) {
            Ext.apply(this, {
                minWidth: r,
                minHeight: a
            });
            this.setSize({
                width: n,
                height: o
            });
        }
    }
});

Ext.define("kerio.wm.view.WebmailButton", {
    extend: "Ext.button.Split",
    alias: "widget.webmailbutton",
    styles: !0,
    componentCls: "webmailButton",
    iconCls: void 0,
    iconWidth: 16,
    minWidth: 70,
    menu: void 0,
    toggleGroup: void 0,
    maskOnDisable: !1,
    enableToggle: !1,
    activeCls: "active",
    overCls: "over",
    pressedCls: "pressed",
    focusCls: "focus",
    allowDepress: void 0,
    menuCls: "webmailButtonMenu",
    menuActiveCls: "menuActive",
    lightCls: "light",
    isButton: !0,
    pressed: !1,
    isDefault: !1,
    defaultCls: "default",
    isCancel: !1,
    cancelCls: "cancel",
    isFlat: !1,
    flatCls: "flat",
    height: 30,
    slimHeight: 22,
    fatHeight: 34,
    isSlim: !1,
    arrowAlign: "right",
    isResponsive: !1,
    tooltipType: "title",
    stopPropagation: !0,
    renderTpl: '<em id="{id}-btnWrap" class="{splitCls}"><tpl if="href"><a id="{id}-btnEl" href="{href}" target="{target}"<tpl if="tabIndex"> tabIndex="{tabIndex}"</tpl> role="link"><span id="{id}-btnInnerEl" class="{baseCls}-inner">{text}</span><span id="{id}-btnIconEl" class="{baseCls}-icon"></span></a></tpl><tpl if="!href"><button id="{id}-btnEl" type="{type}" hidefocus="true"<tpl if="tabIndex"> tabIndex="{tabIndex}"</tpl> role="button" autocomplete="off"><span id="{id}-btnInnerEl" class="{baseCls}-inner" style="{innerSpanStyle}">{text}</span><span id="{id}-btnIconEl" class="{baseCls}-icon {iconCls}">&#160;</span></button></tpl><tpl if="hasMenu"><div class="menuArrow {menutTiggerCls}"></div></tpl></em>',
    constructor: function(e) {
        e = e || {};
        if (void 0 === e.text && void 0 === e.width && void 0 !== e.iconCls) {
            e.width = e.iconWidth || this.iconWidth;
        }
        if (e.width) {
            e.minWidth = e.width;
        }
        if (void 0 === e.overflowText && (e.text || e.tooltip)) {
            e.overflowText = e.text || e.tooltip;
        }
        e.split = !0 === e.split;
        this.callParent(arguments);
    },
    initComponent: function() {
        var e, t = this;
        if (void 0 === this.showMenuArrow) {
            this.showMenuArrow = (this.split || this.menu) && void 0 !== this.text;
        }
        if (!this.split && !this.menu) {
            this.addCls("noMenu");
        } else {
            this.isDefault = !1;
        }
        if (t.isResponsive) {
            t.addCls("responsiveBtn");
            t.media = Ext.applyIf(t.media || {}, {
                "(min-width: 1000px)": {
                    fn: this._onMinWidth,
                    scope: t
                }
            });
        }
        if (t.initialConfig.isLight) {
            t.addCls(this.lightCls);
        }
        if (t.initialConfig.isSlim) {
            t.height = t.slimHeight;
        } else {
            if (t.hasCls("secondaryButton")) {
                t.height = t.fatHeight;
            }
        }
        e = t.split;
        t.callParent(arguments);
        if (this.iconCls) {
            this.addCls("withIcon");
        }
        t.split = e;
        if (t.isDefault) {
            this.addCls(this.defaultCls);
        }
        if (t.isCancel) {
            this.addCls(this.cancelCls);
        }
        if (t.isFlat) {
            this.addCls(this.flatCls);
        }
        t.addEvents("press", "beforepress", "unpress", "beforeunpress");
    },
    _onMinWidth: function(e, t, i, s) {
        if (!i) {
            e.addCls("iconOnly");
            e.minWidth = 0;
            e.setWidth(32);
            if (!e.btnEl.dom.title) {
                e.btnEl.dom.title = e.getText() || e.overflowText || "";
            }
        } else {
            e.removeCls("iconOnly");
            e.minWidth = e.initialConfig.minWidth || this.self.prototype.minWidth;
            e.btnEl.dom.title = e.initialConfig.tooltip || "";
            e.setWidth(null);
        }
    },
    setDefault: function(e) {
        this.isDefault = !1 !== e;
        this[this.isDefault ? "addCls" : "removeCls"](this.defaultCls);
        this.fireEvent("defaultchanged", this, this.isDefault);
    },
    setCancel: function(e) {
        this.isCancel = !1 !== e;
        this[this.isCancel ? "addCls" : "removeCls"](this.cancelCls);
    },
    unpress: function() {
        var e = this;
        if (e.pressed) {
            if (!1 !== e.fireEvent("beforeunpress", e)) {
                e.toggle(!1);
                e.fireEvent("unpress", e);
            }
        }
    },
    press: function() {
        var e = this;
        if (!e.pressed) {
            if (!1 !== e.fireEvent("beforepress", e)) {
                e.toggle(!0);
                e.fireEvent("press", e);
            }
        }
    },
    _showMenuArrow: function() {
        return this.showMenuArrow && (!!this.split || !!this.menu);
    },
    getTemplateArgs: function() {
        var e = this.callParent(arguments) || {};
        e.hasMenu = this._showMenuArrow();
        e.menutTiggerCls = this.split ? "split" : "menuBtn";
        return e;
    },
    getSplitCls: function() {
        var e, t = this.split;
        this.split = this._showMenuArrow();
        e = this.callParent(arguments);
        this.split = t;
        return e;
    },
    onClick: function(e, t) {
        if (this.split) {
            this.callParent(arguments);
        } else {
            Ext.button.Button.prototype.onClick.apply(this, arguments);
        }
        if (this.stopPropagation) {
            e.stopPropagation();
        }
    },
    setText: function(e) {
        var t;
        this.setWidth(null);
        t = this.callParent(arguments);
        return t;
    },
    afterRender: function() {
        if (!this.iconCls) {
            this.btnIconEl.hide();
        }
        this.callParent(arguments);
    }
});

Ext.define("kerio.wm.view.MutableMenuItem", {
    extend: "Ext.menu.Item",
    alias: "widget.mutablemenuitem",
    setHref: function(e) {
        this.href = e;
        if (this.itemEl) {
            this.itemEl.set({
                href: e
            });
        }
    }
});

Ext.define("kerio.wm.utils.ItemState", {
    itemState: {},
    previousItemState: {},
    itemStateSettings: {},
    itemStateProperty: "items",
    itemStateDeepAlternatives: [ "menu" ],
    addStateListener: function(e, t) {
        if (!this.itemStateListeners) {
            this.itemStateListeners = [];
        }
        this.itemStateListeners.push({
            fce: e,
            scope: t || this
        });
    },
    setItemState: function(e, t) {
        if (void 0 !== t.visible && (!e.rendered || e.isVisible() !== t.visible)) {
            e.setVisible(t.visible);
        }
        if (void 0 !== t.enabled && (!e.rendered || e.isDisabled() === t.enabled)) {
            e.setDisabled(!t.enabled);
        }
    },
    setSeparatorState: function(e, t) {
        if (!t.sectionVisible) {
            e.setVisible(!1);
        } else {
            if (t.previousSeparator) {
                t.previousSeparator.setVisible(!0);
            }
            t.previousSeparator = e;
            t.sectionVisible = !1;
        }
    },
    setState: function(e) {
        this.previousItemState = this.itemState;
        this.itemState = e;
        this.setItemsState(this[this.itemStateProperty], e);
        if (this.itemStateListeners) {
            var t;
            for (t = 0; t < this.itemStateListeners.length; t++) {
                this.itemStateListeners[t].fce.call(this.itemStateListeners[t].scope, e);
            }
        }
    },
    setItemsState: function(e, t) {
        var i, s, n, o, r, a, l = {
            sectionVisible: !1
        };
        for (s = 0; s < e.length; s++) {
            if (e.getAt) {
                i = e.getAt(s);
            } else {
                i = e[s];
            }
            if ("menuseparator" === i.xtype) {
                this.setSeparatorState(i, l);
            }
            if (i.states) {
                r = !1;
                for (n = 0; n < i.states.length; n++) {
                    r = !0;
                    if (i.states[n].settings) {
                        for (o in t) {
                            if (t.hasOwnProperty(o) && void 0 !== i.states[n].settings[o] && i.states[n].settings[o] !== t[o]) {
                                r = !1;
                                break;
                            }
                        }
                    }
                    if (r) {
                        a = i.states[n].state || this.itemStateSettings.alternativeState;
                        break;
                    }
                }
                if (!r) {
                    a = this.itemStateSettings.defaultState;
                }
                if (a) {
                    l.sectionVisible = l.sectionVisible || a.visible;
                    this.setItemState(i, a);
                }
            }
            if (this.itemStateSettings.deep) {
                if (i[this.itemStateProperty]) {
                    this.setItemsState(i[this.itemStateProperty], t);
                } else {
                    if (this.itemStateDeepAlternatives) {
                        for (n = 0; n < this.itemStateDeepAlternatives.length; n++) {
                            if (i[this.itemStateDeepAlternatives[n]] && i[this.itemStateDeepAlternatives[n]].items) {
                                this.setItemsState(i[this.itemStateDeepAlternatives[n]].items, t);
                            }
                        }
                    }
                }
            }
        }
        if (l.previousSeparator) {
            l.previousSeparator.setVisible(!!l.sectionVisible);
        }
    }
});

Ext.define("kerio.ws.components.imageGallery.AutohideHelper", {
    extend: "Ext.util.Observable",
    constructor: function(e) {
        this.callParent();
        this._delay = e.delay;
        this._mainElement = e.mainElement;
        this._elements = e.elements;
        this._visibility = {};
        this._isAutohidden = !1;
        this._isMouseOver = !1;
        this._isAutoshowingBlocked = !1;
        this._autohideTask = Ext.create("Ext.util.DelayedTask", this._autohide, this);
        this._mainElement.on({
            scope: this,
            mousemove: this._onMouseMove
        });
        this.addEvents([ "visibilityChanged", "mouseOverChanged", "show", "hide" ]);
        this.on({
            scope: this,
            visibilityChanged: this._onVisibilityChanged
        });
    },
    setVisibility: function(e) {
        var t, i, s, n = this._elements, o = this._visibility;
        for (t in n) {
            if (n.hasOwnProperty(t) && e.hasOwnProperty(t)) {
                i = o[t];
                s = e[t];
                o[t] = s;
                if (s !== i) {
                    this.fireEvent("visibilityChanged", t, s);
                }
            }
        }
    },
    forceShow: function() {
        this._showOrHideControls(!0, !1);
        this._autohideTask.delay(this._delay);
    },
    forceAutohide: function() {
        this._autohideTask.delay(this._delay);
    },
    isAutohidden: function() {
        return this._isAutohidden;
    },
    blockAutoshowing: function() {
        this._isAutoshowingBlocked = !0;
    },
    unblockAutoshowing: function() {
        this._isAutoshowingBlocked = !1;
    },
    _onVisibilityChanged: function(e, t) {
        if (!this._isAutohidden) {
            this._elements[e].setVisible(t);
        }
    },
    _onMouseMove: function(e) {
        if (!this._isMousePositionEqual(e.getXY())) {
            this._setMouseOver(e);
            if (!this._isAutoshowingBlocked) {
                if (!this._isMouseOver) {
                    this._autohideTask.delay(this._delay);
                } else {
                    this._autohideTask.cancel();
                }
                if (this._isAutohidden) {
                    this._showOrHideControls(!0, !1);
                }
            }
        }
        this._lastMousePosition = e.getXY();
    },
    _isMousePositionEqual: function(e) {
        var t = this._lastMousePosition;
        if (t) {
            return t[0] === e[0] && t[1] === e[1];
        } else {
            return !1;
        }
    },
    _setMouseOver: function(e) {
        var t, i = this._isMouseOver, s = !1, n = this._elements;
        for (t in n) {
            if (n.hasOwnProperty(t) && e.within(n[t])) {
                s = !0;
                break;
            }
        }
        if (s !== i) {
            this._isMouseOver = s;
            this.fireEvent("mouseOverChanged", s);
        }
    },
    _autohide: function() {
        this._showOrHideControls(!1, !0);
    },
    _showOrHideControls: function(e, t) {
        var i, s, n, o, r = !e;
        if (this._isAutohidden === r) {
            return;
        }
        this._isAutohidden = r;
        i = this._visibility;
        n = this._elements;
        for (o in i) {
            if (i.hasOwnProperty(o)) {
                s = i[o];
                if (n[o].getActiveAnimation()) {
                    n[o].getActiveAnimation().end();
                }
                n[o][e && s ? "show" : "hide"](t);
            }
        }
        this.fireEvent(e ? "show" : "hide");
    }
});

Ext.define("kerio.ws.components.imageGallery.ImageView", {
    extend: "Ext.util.Observable",
    _imageCls: "k-image",
    _loadingCls: "k-loading",
    _errorCls: "k-error",
    _errorTextCls: "k-error-text",
    constructor: function(e) {
        this.callParent();
        this._element = e.element;
        this._isImageLoaded = !1;
        this.addEvents("imageLoaded", "imageError", "imageSizeReceived");
    },
    getOptimalSize: kerio.ws.abstractFn,
    resizeImage: kerio.ws.abstractFn,
    show: function() {
        if (!this._elementsCreated) {
            this._createElements();
            this._elementsCreated = !0;
        }
    },
    setImageUrl: function(e) {
        if (this._image.getAttribute("src") === e && !this.isImageLoaded()) {
            return;
        }
        this._image.dom.removeAttribute("width");
        this._image.dom.removeAttribute("height");
        if (this._image.getAttribute("src") !== e) {
            this._errorMessage.hide();
            this._image.hide();
            this._setLoading(!0);
            this._isImageLoaded = !1;
            this._image.set({
                src: e
            });
        } else {
            this._showImage();
        }
        this._isErrorMessageShown = !1;
    },
    isImageLoaded: function() {
        return this._isImageLoaded;
    },
    setInvalid: function(e) {
        this._isImageLoaded = !0;
        this._image.hide();
        this.setErrorMessage(e);
        this._showErrorMessage();
    },
    setErrorMessage: function(e) {
        this._image.dom.removeAttribute("src");
        this._errorMessageText.setHTML(e);
    },
    isErrorMessageShown: function() {
        return this._isErrorMessageShown;
    },
    _onImageLoaded: function() {
        this._isImageLoaded = !0;
        this.fireEvent("imageLoaded");
        this._showImage();
    },
    _onImageError: function() {
        this._isImageLoaded = !0;
        this.fireEvent("imageError");
        this._showErrorMessage();
    },
    _showErrorMessage: function() {
        this._isErrorMessageShown = !0;
        this._errorMessage.show(!0);
        this._setLoading(!1);
    },
    _showImage: function() {
        var e, t;
        if (!this._image.isVisible()) {
            this._setLoading(!1);
            if (this._image.getActiveAnimation()) {
                this._image.getActiveAnimation().end();
                this._image.hide();
            }
            this._image.show(!0);
        }
        e = this._image.getSize();
        this.fireEvent("imageSizeReceived", e);
        t = this.getOptimalSize(e);
        this.resizeImage(t);
    },
    _setLoading: function(e) {
        this._element[e ? "addCls" : "removeCls"](this._loadingCls);
    },
    hide: function() {
        if (this._image) {
            this._image.hide();
        }
        if (this._errorMessage) {
            this._errorMessage.hide();
        }
    },
    _createElements: function() {
        var e, t, i, s;
        e = this._element;
        t = e.createChild({
            tag: "img",
            cls: this._imageCls + " x-unselectable"
        });
        t.setVisibilityMode(Ext.dom.AbstractElement.DISPLAY);
        t.on({
            scope: this,
            load: this._onImageLoaded,
            error: this._onImageError
        });
        i = e.createChild({
            tag: "div",
            cls: this._errorCls,
            style: {
                display: "none"
            }
        });
        i.setVisibilityMode(Ext.dom.AbstractElement.DISPLAY);
        s = i.createChild({
            tag: "div",
            cls: this._errorTextCls
        });
        this._image = t;
        this._errorMessage = i;
        this._errorMessageText = s;
    },
    destroy: function() {
        this.hide();
        this._elementsCreated = !1;
    }
});

Ext.define("kerio.ws.components.imageGallery.DisplayCache", {
    extend: "Ext.util.Observable",
    constructor: function(e) {
        this.callParent();
        this._preloadCount = e.preloadCount;
        this._view = e.view;
        this.clear();
    },
    clear: function() {
        this._cache = {};
    },
    preload: function(e) {
        var t, i, s, n, o = 0;
        while (o < this._preloadCount && e.hasNext()) {
            t = e.next();
            if (t.isValid) {
                s = this._view.getOptimalSize(t.size);
                if (!this._hasSufficientSize(t.id, s)) {
                    n = this._retrieveAndCacheUrl(t, s);
                    i = new Image();
                    i.src = n;
                }
                o++;
            }
        }
    },
    getUrl: function(e) {
        var t, i, s;
        t = e.id;
        i = this._view.getOptimalSize(e.size);
        if (this._hasSufficientSize(t, i)) {
            s = this._cache[t].url;
        } else {
            s = this._retrieveAndCacheUrl(e, i);
        }
        return s;
    },
    putServerSize: function(e, t) {
        this._put(e, "size", t);
    },
    _retrieveAndCacheUrl: function(e, t) {
        var i = e.getUrl(t);
        this._put(e.id, "url", i);
        this._put(e.id, "size", t);
        return i;
    },
    _hasSufficientSize: function(e, t) {
        var i, s = this._cache[e];
        if (s && s.size) {
            i = s.size;
            if (t.width <= i.width && t.height <= i.height) {
                return !0;
            }
        }
        return !1;
    },
    _put: function(e, t, i) {
        this._cache[e] = this._cache[e] || {};
        this._cache[e][t] = i;
    }
});

Ext.define("kerio.ws.components.imageGallery.data.Iterator", {
    extend: "Ext.util.Observable",
    constructor: function() {
        this.callParent();
        this.addEvents("change");
    },
    current: kerio.ws.abstractFn,
    previous: kerio.ws.abstractFn,
    hasPrevious: kerio.ws.abstractFn,
    next: kerio.ws.abstractFn,
    hasNext: kerio.ws.abstractFn,
    first: kerio.ws.abstractFn,
    last: kerio.ws.abstractFn,
    isFirst: kerio.ws.abstractFn,
    isLast: kerio.ws.abstractFn,
    clone: kerio.ws.abstractFn
});

Ext.define("kerio.ws.components.imageGallery.data.Provider", {
    extend: "Ext.util.Observable",
    constructor: function(e) {
        this.callParent();
        Ext.apply(this, e, {});
        this.addEvents("load", "add", "remove");
    },
    load: kerio.ws.abstractFn,
    getAll: kerio.ws.abstractFn,
    remove: kerio.ws.abstractFn,
    getCount: kerio.ws.abstractFn,
    findByIndex: kerio.ws.abstractFn,
    findById: kerio.ws.abstractFn,
    isEmpty: kerio.ws.abstractFn,
    isPrepared: kerio.ws.abstractFn,
    createIterator: kerio.ws.abstractFn
});

Ext.define("kerio.wm.utils.htmlHelper", {
    singleton: !0,
    decodeNode: function(e) {
        var t, i, s;
        if (e) {
            if (e.attributes) {
                for (t = 0, i = e.attributes.length; i > t; t++) {
                    s = e.attributes[t];
                    if (s.value && "class" !== s.name && "style" !== s.name) {
                        s.value = Ext.htmlDecode(s.value);
                    }
                }
            }
            if (0 == e.childNodes.length && e.textContent) {
                e.textContent = Ext.htmlDecode(e.textContent);
            }
        }
    },
    isInDesktopEnvironment: function() {
        if ("undefined" != typeof window && "object" == typeof window.process && "renderer" === window.process.type) {
            return !0;
        }
        if ("undefined" != typeof process && "object" == typeof process.versions && process.versions.electron) {
            return !0;
        }
        if ("object" == typeof navigator && "string" == typeof navigator.userAgent && navigator.userAgent.indexOf("Electron") >= 0) {
            return !0;
        }
        return !1;
    },
    isDescendantofType: function(e, t) {
        var i = e.parentNode;
        while (null !== i) {
            if (i.nodeName.toLowerCase() === t.toLowerCase()) {
                return !0;
            }
            i = i.parentNode;
        }
        return !1;
    }
});

Ext.define("kerio.wm.lib.view.SingleView", {
    extend: "Ext.view.View",
    requires: [ "kerio.wm.TitleManager" ],
    itemSelector: "*",
    tpl: '<div class="singleView"></div>',
    _model: void 0,
    storeClass: void 0,
    storeConfig: void 0,
    initComponent: function() {
        if (!this.store) {
            this.store = Ext.create(this.storeClass || "Ext.data.ArrayStore", this.storeConfig);
        }
        this.callParent(arguments);
    },
    setModel: function(e) {
        this._model = e;
        if (e) {
            kerio.wm.TitleManager.showEmailPreview(e.get("subject"));
            this.store.loadRecords([ e ]);
        } else {
            kerio.wm.TitleManager.restoreTitle();
            this.store.removeAll();
        }
        window.getSelection().removeAllRanges();
    },
    getModel: function() {
        return this._model;
    }
});

Ext.define("kerio.wm.proxy.PagedLoader", {
    constructor: function(e) {
        this.fn = e.fn;
        this.fnScope = e.fnScope || this;
        this.limit = e.limit || 500;
        this.listProperty = e.listProperty || "list";
        this.totalProperty = e.totalProperty || "totalItems";
        this.fields = e.fields || void 0;
    },
    load: function(e, t) {
        if (this.task && this.task.loading) {
            this.cancel();
        }
        this.task = {
            fn: this.fn,
            fnScope: this.fnScope,
            limit: this.limit,
            listProperty: this.listProperty,
            totalProperty: this.totalProperty,
            fields: this.fields,
            loading: !0,
            currentPage: 0,
            settings: t,
            params: Ext.clone(e),
            doLoad: this._taskFn.doLoad,
            resultsSuccess: this._taskFn.resultsSuccess,
            resultsFailure: this._taskFn.resultsFailure,
            failedChunkRecovery: this._taskFn.failedChunkRecovery
        };
        this.task.doLoad();
    },
    cancel: function() {
        if (this.task) {
            this.task.cancel = !0;
            delete this.task.loading;
        }
    },
    _taskFn: {
        doLoad: function() {
            var e = this.params || {};
            e.query = e.query || {};
            e.query.start = this.currentPage * this.limit;
            e.query.limit = this.limit;
            if (this.fields) {
                e.query.fields = this.fields;
            }
            this.fn.call(this.fnScope, e, {
                success: this.resultsSuccess,
                failure: this.resultsFailure,
                scope: this
            });
        },
        resultsSuccess: function(e) {
            if (this.cancel) {
                return;
            }
            this.totalItems = e[this.totalProperty];
            var t = e[this.listProperty];
            this.result = this.result ? this.result.concat(t) : t;
            this.currentPage++;
            if (this.currentPage * this.limit > this.totalItems) {
                delete this.loading;
                this.settings.success.apply(this.settings.scope || this, [ this.result ]);
                if (this.settings.callback) {
                    this.settings.callback.apply(this.settings.scope || this, [ this.result ]);
                }
            } else {
                this.doLoad();
            }
        },
        resultsFailure: function(e, t) {
            if (this.cancel) {
                return;
            }
            if (this.failedChunkRecovery()) {
                t.response.stopErrorProcessing();
                return;
            }
            delete this.loading;
            if (this.settings.failure) {
                this.settings.failure.apply(this.settings.scope || this, arguments);
            }
            if (this.settings.callback) {
                this.settings.callback.apply(this.settings.scope || this, arguments);
            }
        },
        failedChunkRecovery: function() {
            if (this.lastFailedPage === this.currentPage) {
                return !1;
            }
            this.lastFailedPage = this.currentPage;
            Ext.defer(this.doLoad, 1e3, this);
            return !0;
        }
    }
});

Ext.define("kerio.wm.utils.StateChange", {
    isStateChange: !0,
    _type: null,
    statics: {
        types: {
            certStoreStatusChanged: "certStoreStatusChanged",
            mailChanged: "mailChanged",
            reloginStateChanged: "reloginStateChanged",
            mailPageSize: "mailPageSize",
            showFirstMail: "showFirstMail"
        }
    },
    constructor: function() {
        this.setData({});
    },
    setType: function(e) {
        this._type = e;
    },
    getType: function() {
        return this._type;
    },
    setData: function(e, t) {
        if (t) {
            Ext.apply(this._data, e);
        } else {
            this._data = e;
        }
    },
    getData: function() {
        return this._data;
    },
    get: function(e) {
        return this.getData()[e];
    },
    set: function(e, t) {
        this._data[e] = t;
    }
});

Ext.define("kerio.wm.utils.GuidParser", {
    singleton: !0,
    FOLDER_GUID_PATTERN: new RegExp("^keriostorage://[^/]+/([^/]+/[^/]+/[^/]+)$"),
    ITEM_GUID_PATTERN: new RegExp("^keriostorage://[^/]+/([^/]+)/([^/]+)/([^/]+)/[0-9]+(#[0-9]+)?(/.*$|$)"),
    MAILBOX_GUID_PATTERN: new RegExp("^keriostorage://mailbox/([^/]+)/([^/]+)$"),
    folderIdFromItemId: function(e) {
        var t = this.ITEM_GUID_PATTERN.exec(e);
        if (t && t.length) {
            return "keriostorage://folder/" + t[1] + "/" + t[2] + "/" + t[3];
        }
        return null;
    },
    isItemId: function(e) {
        var t = this.ITEM_GUID_PATTERN.test(e);
        return t;
    },
    getMailFromItemId: function(e) {
        var t = this.ITEM_GUID_PATTERN.exec(e);
        if (t && t.length) {
            return t[2] + "@" + t[1];
        }
        return null;
    },
    isFolderId: function(e) {
        var t = this.FOLDER_GUID_PATTERN.test(e);
        return t;
    },
    getMailFromMailboxId: function(e) {
        var t = this.MAILBOX_GUID_PATTERN.exec(e);
        if (t && t.length) {
            return t[2] + "@" + t[1];
        }
        return null;
    },
    isMailboxId: function(e) {
        var t = this.MAILBOX_GUID_PATTERN.test(e);
        return t;
    }
});

Ext.define("kerio.wm.utils.Latinize", {
    singleton: !0,
    NATIONAL_CHARACTERS: /[\u0041-\u005A\u0061-\u007A\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0\u08A2-\u08AC\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC\d\s]+/g,
    filterWordCharacters: function(e) {
        var t = e.replace(this.NATIONAL_CHARACTERS, "");
        t = (t + "").replace(/[.?*+^$[\]\\(){}|-]/g, "\\$&");
        return e.replace(new RegExp("[" + t + "]+", "g"), "");
    },
    map: {
        "Á": "A",
        "Ă": "A",
        "Ắ": "A",
        "Ặ": "A",
        "Ằ": "A",
        "Ẳ": "A",
        "Ẵ": "A",
        "Ǎ": "A",
        "Â": "A",
        "Ấ": "A",
        "Ậ": "A",
        "Ầ": "A",
        "Ẩ": "A",
        "Ẫ": "A",
        "Ä": "A",
        "Ǟ": "A",
        "Ȧ": "A",
        "Ǡ": "A",
        "Ạ": "A",
        "Ȁ": "A",
        "À": "A",
        "Ả": "A",
        "Ȃ": "A",
        "Ā": "A",
        "Ą": "A",
        "Å": "A",
        "Ǻ": "A",
        "Ḁ": "A",
        "Ⱥ": "A",
        "Ã": "A",
        "Ꜳ": "AA",
        "Æ": "AE",
        "Ǽ": "AE",
        "Ǣ": "AE",
        "Ꜵ": "AO",
        "Ꜷ": "AU",
        "Ꜹ": "AV",
        "Ꜻ": "AV",
        "Ꜽ": "AY",
        "Ḃ": "B",
        "Ḅ": "B",
        "Ɓ": "B",
        "Ḇ": "B",
        "Ƀ": "B",
        "Ƃ": "B",
        "Ć": "C",
        "Č": "C",
        "Ç": "C",
        "Ḉ": "C",
        "Ĉ": "C",
        "Ċ": "C",
        "Ƈ": "C",
        "Ȼ": "C",
        "Ď": "D",
        "Ḑ": "D",
        "Ḓ": "D",
        "Ḋ": "D",
        "Ḍ": "D",
        "Ɗ": "D",
        "Ḏ": "D",
        "ǲ": "D",
        "ǅ": "D",
        "Đ": "D",
        "Ƌ": "D",
        "Ǳ": "DZ",
        "Ǆ": "DZ",
        "É": "E",
        "Ĕ": "E",
        "Ě": "E",
        "Ȩ": "E",
        "Ḝ": "E",
        "Ê": "E",
        "Ế": "E",
        "Ệ": "E",
        "Ề": "E",
        "Ể": "E",
        "Ễ": "E",
        "Ḙ": "E",
        "Ë": "E",
        "Ė": "E",
        "Ẹ": "E",
        "Ȅ": "E",
        "È": "E",
        "Ẻ": "E",
        "Ȇ": "E",
        "Ē": "E",
        "Ḗ": "E",
        "Ḕ": "E",
        "Ę": "E",
        "Ɇ": "E",
        "Ẽ": "E",
        "Ḛ": "E",
        "Ꝫ": "ET",
        "Ḟ": "F",
        "Ƒ": "F",
        "Ǵ": "G",
        "Ğ": "G",
        "Ǧ": "G",
        "Ģ": "G",
        "Ĝ": "G",
        "Ġ": "G",
        "Ɠ": "G",
        "Ḡ": "G",
        "Ǥ": "G",
        "Ḫ": "H",
        "Ȟ": "H",
        "Ḩ": "H",
        "Ĥ": "H",
        "Ⱨ": "H",
        "Ḧ": "H",
        "Ḣ": "H",
        "Ḥ": "H",
        "Ħ": "H",
        "Í": "I",
        "Ĭ": "I",
        "Ǐ": "I",
        "Î": "I",
        "Ï": "I",
        "Ḯ": "I",
        "İ": "I",
        "Ị": "I",
        "Ȉ": "I",
        "Ì": "I",
        "Ỉ": "I",
        "Ȋ": "I",
        "Ī": "I",
        "Į": "I",
        "Ɨ": "I",
        "Ĩ": "I",
        "Ḭ": "I",
        "Ꝺ": "D",
        "Ꝼ": "F",
        "Ᵹ": "G",
        "Ꞃ": "R",
        "Ꞅ": "S",
        "Ꞇ": "T",
        "Ꝭ": "IS",
        "Ĵ": "J",
        "Ɉ": "J",
        "Ḱ": "K",
        "Ǩ": "K",
        "Ķ": "K",
        "Ⱪ": "K",
        "Ꝃ": "K",
        "Ḳ": "K",
        "Ƙ": "K",
        "Ḵ": "K",
        "Ꝁ": "K",
        "Ꝅ": "K",
        "Ĺ": "L",
        "Ƚ": "L",
        "Ľ": "L",
        "Ļ": "L",
        "Ḽ": "L",
        "Ḷ": "L",
        "Ḹ": "L",
        "Ⱡ": "L",
        "Ꝉ": "L",
        "Ḻ": "L",
        "Ŀ": "L",
        "Ɫ": "L",
        "ǈ": "L",
        "Ł": "L",
        "Ǉ": "LJ",
        "Ḿ": "M",
        "Ṁ": "M",
        "Ṃ": "M",
        "Ɱ": "M",
        "Ń": "N",
        "Ň": "N",
        "Ņ": "N",
        "Ṋ": "N",
        "Ṅ": "N",
        "Ṇ": "N",
        "Ǹ": "N",
        "Ɲ": "N",
        "Ṉ": "N",
        "Ƞ": "N",
        "ǋ": "N",
        "Ñ": "N",
        "Ǌ": "NJ",
        "Ó": "O",
        "Ŏ": "O",
        "Ǒ": "O",
        "Ô": "O",
        "Ố": "O",
        "Ộ": "O",
        "Ồ": "O",
        "Ổ": "O",
        "Ỗ": "O",
        "Ö": "O",
        "Ȫ": "O",
        "Ȯ": "O",
        "Ȱ": "O",
        "Ọ": "O",
        "Ő": "O",
        "Ȍ": "O",
        "Ò": "O",
        "Ỏ": "O",
        "Ơ": "O",
        "Ớ": "O",
        "Ợ": "O",
        "Ờ": "O",
        "Ở": "O",
        "Ỡ": "O",
        "Ȏ": "O",
        "Ꝋ": "O",
        "Ꝍ": "O",
        "Ō": "O",
        "Ṓ": "O",
        "Ṑ": "O",
        "Ɵ": "O",
        "Ǫ": "O",
        "Ǭ": "O",
        "Ø": "O",
        "Ǿ": "O",
        "Õ": "O",
        "Ṍ": "O",
        "Ṏ": "O",
        "Ȭ": "O",
        "Ƣ": "OI",
        "Ꝏ": "OO",
        "Ɛ": "E",
        "Ɔ": "O",
        "Ȣ": "OU",
        "Ṕ": "P",
        "Ṗ": "P",
        "Ꝓ": "P",
        "Ƥ": "P",
        "Ꝕ": "P",
        "Ᵽ": "P",
        "Ꝑ": "P",
        "Ꝙ": "Q",
        "Ꝗ": "Q",
        "Ŕ": "R",
        "Ř": "R",
        "Ŗ": "R",
        "Ṙ": "R",
        "Ṛ": "R",
        "Ṝ": "R",
        "Ȑ": "R",
        "Ȓ": "R",
        "Ṟ": "R",
        "Ɍ": "R",
        "Ɽ": "R",
        "Ꜿ": "C",
        "Ǝ": "E",
        "Ś": "S",
        "Ṥ": "S",
        "Š": "S",
        "Ṧ": "S",
        "Ş": "S",
        "Ŝ": "S",
        "Ș": "S",
        "Ṡ": "S",
        "Ṣ": "S",
        "Ṩ": "S",
        "ẞ": "SS",
        "Ť": "T",
        "Ţ": "T",
        "Ṱ": "T",
        "Ț": "T",
        "Ⱦ": "T",
        "Ṫ": "T",
        "Ṭ": "T",
        "Ƭ": "T",
        "Ṯ": "T",
        "Ʈ": "T",
        "Ŧ": "T",
        "Ɐ": "A",
        "Ꞁ": "L",
        "Ɯ": "M",
        "Ʌ": "V",
        "Ꜩ": "TZ",
        "Ú": "U",
        "Ŭ": "U",
        "Ǔ": "U",
        "Û": "U",
        "Ṷ": "U",
        "Ü": "U",
        "Ǘ": "U",
        "Ǚ": "U",
        "Ǜ": "U",
        "Ǖ": "U",
        "Ṳ": "U",
        "Ụ": "U",
        "Ű": "U",
        "Ȕ": "U",
        "Ù": "U",
        "Ủ": "U",
        "Ư": "U",
        "Ứ": "U",
        "Ự": "U",
        "Ừ": "U",
        "Ử": "U",
        "Ữ": "U",
        "Ȗ": "U",
        "Ū": "U",
        "Ṻ": "U",
        "Ų": "U",
        "Ů": "U",
        "Ũ": "U",
        "Ṹ": "U",
        "Ṵ": "U",
        "Ꝟ": "V",
        "Ṿ": "V",
        "Ʋ": "V",
        "Ṽ": "V",
        "Ꝡ": "VY",
        "Ẃ": "W",
        "Ŵ": "W",
        "Ẅ": "W",
        "Ẇ": "W",
        "Ẉ": "W",
        "Ẁ": "W",
        "Ⱳ": "W",
        "Ẍ": "X",
        "Ẋ": "X",
        "Ý": "Y",
        "Ŷ": "Y",
        "Ÿ": "Y",
        "Ẏ": "Y",
        "Ỵ": "Y",
        "Ỳ": "Y",
        "Ƴ": "Y",
        "Ỷ": "Y",
        "Ỿ": "Y",
        "Ȳ": "Y",
        "Ɏ": "Y",
        "Ỹ": "Y",
        "Ź": "Z",
        "Ž": "Z",
        "Ẑ": "Z",
        "Ⱬ": "Z",
        "Ż": "Z",
        "Ẓ": "Z",
        "Ȥ": "Z",
        "Ẕ": "Z",
        "Ƶ": "Z",
        "Ĳ": "IJ",
        "Œ": "OE",
        "ᴀ": "A",
        "ᴁ": "AE",
        "ʙ": "B",
        "ᴃ": "B",
        "ᴄ": "C",
        "ᴅ": "D",
        "ᴇ": "E",
        "ꜰ": "F",
        "ɢ": "G",
        "ʛ": "G",
        "ʜ": "H",
        "ɪ": "I",
        "ʁ": "R",
        "ᴊ": "J",
        "ᴋ": "K",
        "ʟ": "L",
        "ᴌ": "L",
        "ᴍ": "M",
        "ɴ": "N",
        "ᴏ": "O",
        "ɶ": "OE",
        "ᴐ": "O",
        "ᴕ": "OU",
        "ᴘ": "P",
        "ʀ": "R",
        "ᴎ": "N",
        "ᴙ": "R",
        "ꜱ": "S",
        "ᴛ": "T",
        "ⱻ": "E",
        "ᴚ": "R",
        "ᴜ": "U",
        "ᴠ": "V",
        "ᴡ": "W",
        "ʏ": "Y",
        "ᴢ": "Z",
        "á": "a",
        "ă": "a",
        "ắ": "a",
        "ặ": "a",
        "ằ": "a",
        "ẳ": "a",
        "ẵ": "a",
        "ǎ": "a",
        "â": "a",
        "ấ": "a",
        "ậ": "a",
        "ầ": "a",
        "ẩ": "a",
        "ẫ": "a",
        "ä": "a",
        "ǟ": "a",
        "ȧ": "a",
        "ǡ": "a",
        "ạ": "a",
        "ȁ": "a",
        "à": "a",
        "ả": "a",
        "ȃ": "a",
        "ā": "a",
        "ą": "a",
        "ᶏ": "a",
        "ẚ": "a",
        "å": "a",
        "ǻ": "a",
        "ḁ": "a",
        "ⱥ": "a",
        "ã": "a",
        "ꜳ": "aa",
        "æ": "ae",
        "ǽ": "ae",
        "ǣ": "ae",
        "ꜵ": "ao",
        "ꜷ": "au",
        "ꜹ": "av",
        "ꜻ": "av",
        "ꜽ": "ay",
        "ḃ": "b",
        "ḅ": "b",
        "ɓ": "b",
        "ḇ": "b",
        "ᵬ": "b",
        "ᶀ": "b",
        "ƀ": "b",
        "ƃ": "b",
        "ɵ": "o",
        "ć": "c",
        "č": "c",
        "ç": "c",
        "ḉ": "c",
        "ĉ": "c",
        "ɕ": "c",
        "ċ": "c",
        "ƈ": "c",
        "ȼ": "c",
        "ď": "d",
        "ḑ": "d",
        "ḓ": "d",
        "ȡ": "d",
        "ḋ": "d",
        "ḍ": "d",
        "ɗ": "d",
        "ᶑ": "d",
        "ḏ": "d",
        "ᵭ": "d",
        "ᶁ": "d",
        "đ": "d",
        "ɖ": "d",
        "ƌ": "d",
        "ı": "i",
        "ȷ": "j",
        "ɟ": "j",
        "ʄ": "j",
        "ǳ": "dz",
        "ǆ": "dz",
        "é": "e",
        "ĕ": "e",
        "ě": "e",
        "ȩ": "e",
        "ḝ": "e",
        "ê": "e",
        "ế": "e",
        "ệ": "e",
        "ề": "e",
        "ể": "e",
        "ễ": "e",
        "ḙ": "e",
        "ë": "e",
        "ė": "e",
        "ẹ": "e",
        "ȅ": "e",
        "è": "e",
        "ẻ": "e",
        "ȇ": "e",
        "ē": "e",
        "ḗ": "e",
        "ḕ": "e",
        "ⱸ": "e",
        "ę": "e",
        "ᶒ": "e",
        "ɇ": "e",
        "ẽ": "e",
        "ḛ": "e",
        "ꝫ": "et",
        "ḟ": "f",
        "ƒ": "f",
        "ᵮ": "f",
        "ᶂ": "f",
        "ǵ": "g",
        "ğ": "g",
        "ǧ": "g",
        "ģ": "g",
        "ĝ": "g",
        "ġ": "g",
        "ɠ": "g",
        "ḡ": "g",
        "ᶃ": "g",
        "ǥ": "g",
        "ḫ": "h",
        "ȟ": "h",
        "ḩ": "h",
        "ĥ": "h",
        "ⱨ": "h",
        "ḧ": "h",
        "ḣ": "h",
        "ḥ": "h",
        "ɦ": "h",
        "ẖ": "h",
        "ħ": "h",
        "ƕ": "hv",
        "í": "i",
        "ĭ": "i",
        "ǐ": "i",
        "î": "i",
        "ï": "i",
        "ḯ": "i",
        "ị": "i",
        "ȉ": "i",
        "ì": "i",
        "ỉ": "i",
        "ȋ": "i",
        "ī": "i",
        "į": "i",
        "ᶖ": "i",
        "ɨ": "i",
        "ĩ": "i",
        "ḭ": "i",
        "ꝺ": "d",
        "ꝼ": "f",
        "ᵹ": "g",
        "ꞃ": "r",
        "ꞅ": "s",
        "ꞇ": "t",
        "ꝭ": "is",
        "ǰ": "j",
        "ĵ": "j",
        "ʝ": "j",
        "ɉ": "j",
        "ḱ": "k",
        "ǩ": "k",
        "ķ": "k",
        "ⱪ": "k",
        "ꝃ": "k",
        "ḳ": "k",
        "ƙ": "k",
        "ḵ": "k",
        "ᶄ": "k",
        "ꝁ": "k",
        "ꝅ": "k",
        "ĺ": "l",
        "ƚ": "l",
        "ɬ": "l",
        "ľ": "l",
        "ļ": "l",
        "ḽ": "l",
        "ȴ": "l",
        "ḷ": "l",
        "ḹ": "l",
        "ⱡ": "l",
        "ꝉ": "l",
        "ḻ": "l",
        "ŀ": "l",
        "ɫ": "l",
        "ᶅ": "l",
        "ɭ": "l",
        "ł": "l",
        "ǉ": "lj",
        "ſ": "s",
        "ẜ": "s",
        "ẛ": "s",
        "ẝ": "s",
        "ḿ": "m",
        "ṁ": "m",
        "ṃ": "m",
        "ɱ": "m",
        "ᵯ": "m",
        "ᶆ": "m",
        "ń": "n",
        "ň": "n",
        "ņ": "n",
        "ṋ": "n",
        "ȵ": "n",
        "ṅ": "n",
        "ṇ": "n",
        "ǹ": "n",
        "ɲ": "n",
        "ṉ": "n",
        "ƞ": "n",
        "ᵰ": "n",
        "ᶇ": "n",
        "ɳ": "n",
        "ñ": "n",
        "ǌ": "nj",
        "ó": "o",
        "ŏ": "o",
        "ǒ": "o",
        "ô": "o",
        "ố": "o",
        "ộ": "o",
        "ồ": "o",
        "ổ": "o",
        "ỗ": "o",
        "ö": "o",
        "ȫ": "o",
        "ȯ": "o",
        "ȱ": "o",
        "ọ": "o",
        "ő": "o",
        "ȍ": "o",
        "ò": "o",
        "ỏ": "o",
        "ơ": "o",
        "ớ": "o",
        "ợ": "o",
        "ờ": "o",
        "ở": "o",
        "ỡ": "o",
        "ȏ": "o",
        "ꝋ": "o",
        "ꝍ": "o",
        "ⱺ": "o",
        "ō": "o",
        "ṓ": "o",
        "ṑ": "o",
        "ǫ": "o",
        "ǭ": "o",
        "ø": "o",
        "ǿ": "o",
        "õ": "o",
        "ṍ": "o",
        "ṏ": "o",
        "ȭ": "o",
        "ƣ": "oi",
        "ꝏ": "oo",
        "ɛ": "e",
        "ᶓ": "e",
        "ɔ": "o",
        "ᶗ": "o",
        "ȣ": "ou",
        "ṕ": "p",
        "ṗ": "p",
        "ꝓ": "p",
        "ƥ": "p",
        "ᵱ": "p",
        "ᶈ": "p",
        "ꝕ": "p",
        "ᵽ": "p",
        "ꝑ": "p",
        "ꝙ": "q",
        "ʠ": "q",
        "ɋ": "q",
        "ꝗ": "q",
        "ŕ": "r",
        "ř": "r",
        "ŗ": "r",
        "ṙ": "r",
        "ṛ": "r",
        "ṝ": "r",
        "ȑ": "r",
        "ɾ": "r",
        "ᵳ": "r",
        "ȓ": "r",
        "ṟ": "r",
        "ɼ": "r",
        "ᵲ": "r",
        "ᶉ": "r",
        "ɍ": "r",
        "ɽ": "r",
        "ↄ": "c",
        "ꜿ": "c",
        "ɘ": "e",
        "ɿ": "r",
        "ś": "s",
        "ṥ": "s",
        "š": "s",
        "ṧ": "s",
        "ş": "s",
        "ŝ": "s",
        "ș": "s",
        "ṡ": "s",
        "ṣ": "s",
        "ṩ": "s",
        "ʂ": "s",
        "ᵴ": "s",
        "ᶊ": "s",
        "ȿ": "s",
        "ɡ": "g",
        "ß": "ss",
        "ᴑ": "o",
        "ᴓ": "o",
        "ᴝ": "u",
        "ť": "t",
        "ţ": "t",
        "ṱ": "t",
        "ț": "t",
        "ȶ": "t",
        "ẗ": "t",
        "ⱦ": "t",
        "ṫ": "t",
        "ṭ": "t",
        "ƭ": "t",
        "ṯ": "t",
        "ᵵ": "t",
        "ƫ": "t",
        "ʈ": "t",
        "ŧ": "t",
        "ᵺ": "th",
        "ɐ": "a",
        "ᴂ": "ae",
        "ǝ": "e",
        "ᵷ": "g",
        "ɥ": "h",
        "ʮ": "h",
        "ʯ": "h",
        "ᴉ": "i",
        "ʞ": "k",
        "ꞁ": "l",
        "ɯ": "m",
        "ɰ": "m",
        "ᴔ": "oe",
        "ɹ": "r",
        "ɻ": "r",
        "ɺ": "r",
        "ⱹ": "r",
        "ʇ": "t",
        "ʌ": "v",
        "ʍ": "w",
        "ʎ": "y",
        "ꜩ": "tz",
        "ú": "u",
        "ŭ": "u",
        "ǔ": "u",
        "û": "u",
        "ṷ": "u",
        "ü": "u",
        "ǘ": "u",
        "ǚ": "u",
        "ǜ": "u",
        "ǖ": "u",
        "ṳ": "u",
        "ụ": "u",
        "ű": "u",
        "ȕ": "u",
        "ù": "u",
        "ủ": "u",
        "ư": "u",
        "ứ": "u",
        "ự": "u",
        "ừ": "u",
        "ử": "u",
        "ữ": "u",
        "ȗ": "u",
        "ū": "u",
        "ṻ": "u",
        "ų": "u",
        "ᶙ": "u",
        "ů": "u",
        "ũ": "u",
        "ṹ": "u",
        "ṵ": "u",
        "ᵫ": "ue",
        "ꝸ": "um",
        "ⱴ": "v",
        "ꝟ": "v",
        "ṿ": "v",
        "ʋ": "v",
        "ᶌ": "v",
        "ⱱ": "v",
        "ṽ": "v",
        "ꝡ": "vy",
        "ẃ": "w",
        "ŵ": "w",
        "ẅ": "w",
        "ẇ": "w",
        "ẉ": "w",
        "ẁ": "w",
        "ⱳ": "w",
        "ẘ": "w",
        "ẍ": "x",
        "ẋ": "x",
        "ᶍ": "x",
        "ý": "y",
        "ŷ": "y",
        "ÿ": "y",
        "ẏ": "y",
        "ỵ": "y",
        "ỳ": "y",
        "ƴ": "y",
        "ỷ": "y",
        "ỿ": "y",
        "ȳ": "y",
        "ẙ": "y",
        "ɏ": "y",
        "ỹ": "y",
        "ź": "z",
        "ž": "z",
        "ẑ": "z",
        "ʑ": "z",
        "ⱬ": "z",
        "ż": "z",
        "ẓ": "z",
        "ȥ": "z",
        "ẕ": "z",
        "ᵶ": "z",
        "ᶎ": "z",
        "ʐ": "z",
        "ƶ": "z",
        "ɀ": "z",
        "ﬀ": "ff",
        "ﬃ": "ffi",
        "ﬄ": "ffl",
        "ﬁ": "fi",
        "ﬂ": "fl",
        "ĳ": "ij",
        "œ": "oe",
        "ﬆ": "st",
        "ₐ": "a",
        "ₑ": "e",
        "ᵢ": "i",
        "ⱼ": "j",
        "ₒ": "o",
        "ᵣ": "r",
        "ᵤ": "u",
        "ᵥ": "v",
        "ₓ": "x"
    },
    latinize: function(e) {
        return e.replace(/[^A-Za-z0-9\[\] ]/g, function(e) {
            return kerio.wm.utils.Latinize.map[e] || e;
        });
    },
    isLatin: function(e) {
        return e === this.latinize(e);
    },
    isMultibyteString: function(e) {
        var t, i = 0;
        e = String(e);
        for (i = 0; i < e.length; i++) {
            t = e.charCodeAt(i);
            if (t >= 128) {
                return !0;
            }
        }
        return !1;
    }
});

Ext.define("kerio.wm.store.Store", {
    extend: "Ext.data.Store",
    alias: "store.wmstore",
    constructor: function(e) {
        e = e || {};
        var t = e.delayedLoad || this.delayedLoad;
        if (t) {
            this.autoLoad = !1;
            e.autoLoad = !1;
        }
        this.callParent(arguments);
        if (t) {
            Ext.Function.defer(this.doDelayedLoad, t, this);
        }
    },
    doDelayedLoad: function() {
        this.load();
    },
    getFilterById: function(e) {
        return this.filters.getByKey(e);
    },
    setFilters: function(e, t) {
        var i = this;
        i.filters.clear();
        i.filter(e, t);
    },
    filter: function() {
        this.currentPage = 1;
        this.callParent(arguments);
    },
    removeFilterById: function(e) {
        if (void 0 === this.getFilterById(e)) {
            return;
        }
        var t = this, i = t.sortOnFilter && !t.remoteSort;
        t.currentPage = 1;
        t.filters.removeAtKey(e);
        if (t.remoteFilter) {
            t.load();
        } else {
            if (t.isFiltered()) {
                if (t.filters.getCount()) {
                    t.snapshot = t.snapshot || t.data.clone();
                    t.data = t.data.filter(t.filters.items);
                    if (i) {
                        t.sort();
                    }
                    if (!i || t.sorters.length < 1) {
                        t.fireEvent("datachanged", t);
                    }
                } else {
                    t.data = t.snapshot.clone();
                    delete t.snapshot;
                    t.fireEvent("datachanged", t);
                }
            }
        }
    },
    reload: function(e) {
        var t, i = this, s = {
            action: "read",
            filters: i.filters.items,
            sorters: i.getSorters(),
            groupers: i.groupers.items,
            page: i.currentPage,
            start: (i.currentPage - 1) * i.pageSize,
            limit: i.pageSize,
            addRecords: !1
        };
        t = Ext.create("Ext.data.Operation", s);
        if (e || i.fireEvent("beforeload", i, t) !== !1) {
            i.loading = !0;
            i.proxy.read(t, i.onProxyLoad, i);
        }
        return i;
    },
    filterNew: function(e) {
        return e.phantom === !0 && e.isValid() && !e.isSending;
    },
    getRemovedRecords: function() {
        var e, t = this.removed, i = t.length, s = [];
        for (e = 0; i > e; e++) {
            if (!t[e].isSending) {
                s.push(t[e]);
            }
        }
        return s;
    },
    onDestroyRecords: function(e, t, i) {
        var s, n, o, r = this, a = [];
        e = t.records;
        o = e.length;
        if (i) {
            for (n = 0; n < r.removed.length; n++) {
                for (s = 0; o > s; s++) {
                    if (e[s].data.id === r.removed[n].data.id) {
                        a.push(e[s]);
                    }
                }
            }
            for (n = 0; n < a.length; n++) {
                this.removed = Ext.Array.remove(this.removed, a[n]);
            }
        }
    },
    onCreateRecords: function(e, t, i) {
        if (i) {
            var s, n, o, r, a, l, d = this.data, c = this.snapshot, h = e.length, u = t.getResultSet(), f = u && u.records, m = this.autoSync;
            this.autoSync = !1;
            for (s = 0; h > s; ++s) {
                n = f[s];
                o = e[s];
                if (f) {
                    a = Ext.Array.indexOf(d, o);
                    if (a > -1) {
                        l = n.internalId;
                        r = o.internalId;
                        o.internalId = l;
                        d.keys[a] = l;
                        d.map[l] = o;
                        delete d.map[r];
                    }
                    if (c) {
                        a = Ext.Array.indexOf(c, o);
                        if (a > -1) {
                            c.removeAt(a);
                            c.insert(a, n);
                        }
                    }
                    o.phantom = !1;
                    o.join(this);
                    o.dirty = !1;
                }
            }
            this.autoSync = m;
        }
    },
    findRecord: function(e, t, i, s, n, o) {
        if (!o) {
            o = !0;
        }
        return this.callParent([ e, t, i, s, n, o ]);
    },
    find: function(e, t, i, s, n, o) {
        if (!o) {
            o = !0;
        }
        return this.callParent([ e, t, i, s, n, o ]);
    }
});

Ext.define("kerio.wm.utils.MailAddressParser", {
    singleton: !0,
    DOMAIN_REGEX: new RegExp("^(?:[a-zA-Z0-9](?:[-a-zA-Z0-9]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[-a-zA-Z0-9]{0,61}[a-zA-Z0-9])?)*\\.)?[a-zA-Z](?:[-a-zA-Z0-9]{0,61}[a-zA-Z0-9])?$"),
    IP_REGEX: new RegExp("^(?:[01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])(?:\\.(?:[01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])){3}$"),
    MAILBOX_REGEX: new RegExp('^(?:(?:[^\\s()<>@,;:\\\\".\\[\\]\x00-]+)|(?:"(?:(?:[^"\n\\])|(?:\\"[^\n]))*"))(?:\\.(?:[^\\s()<>@,;:\\\\".\\[\\]\x00-]+)|(?:"(?:(?:[^"\n\\])|(?:\\"[^\n]))*"))*$'),
    skipWhitespaces: function(e, t) {
        var i, s = 0;
        while (t < e.length) {
            i = e.charAt(t);
            if ("(" === i) {
                s = 1;
                t++;
                while (s > 0 && t < e.length) {
                    i = e.charAt(t);
                    t++;
                    if ("\\" === i && t < e.length) {
                        t++;
                    } else {
                        if ("(" === i) {
                            s++;
                        } else {
                            if (")" === i) {
                                s--;
                            }
                        }
                    }
                }
                t--;
            } else {
                if (" " !== i) {
                    break;
                }
            }
            t++;
        }
        return t;
    },
    parsePhrase: function(e, t, i) {
        var s, n = "", o = !1, r = !1;
        i = this.skipWhitespaces(e, i);
        while (!0) {
            s = i < e.length ? e.charAt(i++) : !1;
            if ('"' === s) {
                r = !0;
                while (i < e.length) {
                    s = e.charAt(i);
                    i++;
                    if ('"' === s) {
                        break;
                    }
                    if ("\\" === s) {
                        if (i >= e.length) {
                            break;
                        }
                        s = e.charAt(i);
                        i++;
                    }
                    n += s;
                }
            } else {
                if (" " === s || "(" === s) {
                    i--;
                    i = this.skipWhitespaces(e, i);
                    n += " ";
                    o = !0;
                } else {
                    if (!s || -1 !== t.indexOf(s)) {
                        if (n.length > 0 && " " === n[n.length - 1]) {
                            n = n.substring(0, n.length - 1);
                        }
                        break;
                    } else {
                        n += s;
                    }
                }
            }
        }
        if (0 === n.length) {
            n = !1;
        }
        return {
            phrase: n,
            c: s,
            pos: i,
            containSpaces: o,
            containQMarks: r
        };
    },
    parseDomain: function(e, t) {
        var i, s = "", n = 0, o = "";
        t = this.skipWhitespaces(e, t);
        while (!0) {
            i = t < e.length ? e.charAt(t++) : !1;
            if (i !== !1 && 32 < i.charCodeAt(0) && -1 === '()<>@,;:"\\'.indexOf(i)) {
                s += i;
            } else {
                if ("(" === i) {
                    n = 1;
                    while (n && t < e.length) {
                        i = e.charAt(t);
                        t++;
                        if ("(" === i) {
                            n++;
                        } else {
                            if (")" === i) {
                                n--;
                            } else {
                                if ("\\" === i && t < e.length) {
                                    i = e.charAt(t);
                                    t++;
                                }
                            }
                        }
                        if (n > 0) {
                            o += i;
                        }
                    }
                } else {
                    if (" " === i) {
                        var r = /^\s*[<(]/;
                        if (!r.test(e.substr(t))) {
                            break;
                        }
                    } else {
                        if (s.length > 0 && "." === s.charAt(s.length - 1)) {
                            s = s.substring(0, s.length - 1);
                        }
                        break;
                    }
                }
            }
        }
        return {
            c: i,
            pos: t,
            domain: s,
            comment: o
        };
    },
    parseAddressPart: function(e, t, i, s, n) {
        var o, r, a, l, d, c, h, u, f;
        o = this.parsePhrase(e, "@>", t);
        d = o.containQMarks;
        l = o.containSpaces;
        a = o.c;
        r = o.phrase;
        t = o.pos;
        for (c = 0; 1 > c; ++c) {
            if ("@" !== a) {
                h = this.createAddress(s, r, void 0, e.substring(i, t), !0);
                i = t;
                break;
            }
            if (r === !1) {
                t--;
                o = this.skipRoute(e, t);
                a = o.c;
                t = o.pos;
                if (":" !== a) {
                    h = this.createAddress(s, void 0, void 0, e.substring(i, t), !0);
                    i = t;
                    while (t < e.length && ">" !== a) {
                        a = e.charAt(t);
                        t++;
                    }
                    break;
                }
                o = this.parsePhrase(e, "@>", t);
                a = o.c;
                r = o.phrase;
                t = o.pos;
                if ("@" !== a) {
                    h = this.createAddress(s, r, void 0, e.substring(i, t), !0);
                    i = t;
                    break;
                }
            }
            o = this.parseDomain(e, t);
            t = o.pos;
            a = o.c;
            u = o.domain;
            f = !1;
            while (t < e.length && ">" !== a) {
                if (" " !== a) {
                    f = !0;
                }
                if (-1 !== ",;".indexOf(a)) {
                    break;
                } else {
                    if ("\\" === a && t + 1 < e.length) {
                        a = e.charAt(t);
                        t++;
                    }
                }
                a = e.charAt(t);
                t++;
            }
            while (s.length > 0 && -1 !== ";,".indexOf(s.charAt(0))) {
                s = s.substring(1);
            }
            while (t < e.length && -1 !== ";,".indexOf(e.charAt(t))) {
                t++;
                a = t < e.length ? e.charAt(t) : !1;
            }
            f = f || l || d;
            h = this.createAddress(s, r, u, e.substring(i, t), f);
            i = t;
        }
        if (!h.valid && n && n.valid) {
            n.source = h.source;
            h = n;
        }
        return {
            address: h,
            pos: t,
            originalStart: i
        };
    },
    isValidDomain: function(e) {
        if (this.DOMAIN_REGEX.test(e)) {
            return !0;
        }
        var t = /^\[(.*)\]$/;
        if (t.test(e)) {
            e = e.replace(t, "$1");
            return this.IP_REGEX.test(e);
        }
        return !1;
    },
    isValidMailbox: function(e) {
        this.MAILBOX_REGEX.lastIndex = 0;
        return this.MAILBOX_REGEX.test(e);
    },
    createAddress: function(e, t, i, s, n) {
        var o = {};
        if (!n) {
            n = !1;
        }
        while (s.length > 0 && -1 !== ";, ".indexOf(s.charAt(s.length - 1))) {
            s = s.substring(0, s.length - 1);
        }
        while (s.length > 0 && -1 !== ";, ".indexOf(s.charAt(0))) {
            s = s.substring(1);
        }
        o.valid = !n;
        o.source = s;
        o.name = e;
        if (void 0 !== o.name && 0 === o.name.length) {
            o.name = !1;
        }
        o.name = o.name || !1;
        o.mailbox = t;
        if (void 0 === i || "" === i) {
            o.valid = !1;
            o.domain = !1;
            if (!t) {
                o.mailbox = !1;
            }
        } else {
            o.domain = i;
            if (!t) {
                o.valid = !1;
                o.mailbox = !1;
            } else {
                if (o.valid) {
                    o.valid = this.isValidDomain(i) && this.isValidMailbox(t);
                }
            }
        }
        return o;
    },
    skipRoute: function(e, t) {
        var i;
        t = this.skipWhitespaces(e, t);
        while (!0) {
            i = e.charAt(t);
            t++;
            if (" " === i || "(" === i) {
                t--;
                t = this.skipWhitespaces(e, t);
            } else {
                if (!1 === /[A-Za-z0-9\-\[\],@\.]/.test(i)) {
                    break;
                }
            }
        }
        return {
            c: i,
            pos: t
        };
    },
    parseAddresses: function(e) {
        var t, i, s, n, o, r, a, l, d = 0, c = 0, h = " ", u = 0, f = [];
        while (h) {
            n = this.parsePhrase(e, d > 0 ? ",@<;" : ",@<:", u);
            h = n.c;
            t = n.phrase;
            u = n.pos;
            r = n.containSpaces;
            a = n.containQMarks;
            l = void 0;
            switch (h) {
              case !1:
              case ",":
              case ";":
                if (!1 !== t) {
                    f.push(this.createAddress(void 0, t, void 0, e.substring(c, u), !1));
                    c = u;
                }
                if (";" === h) {
                    d = 0;
                }
                break;

              case ":":
                if (!1 !== t) {
                    f.push(this.createAddress(void 0, t, void 0, e.substring(c, u), !1));
                    c = u;
                }
                d++;
                break;

              case "@":
                o = r || " " === e.charAt(u) || a;
                n = this.parseDomain(e, u);
                u = n.pos;
                h = n.c;
                i = n.domain;
                s = n.comment;
                if ("@" === h) {
                    while (u < e.length && -1 === ",;".indexOf(h)) {
                        h = e.charAt(u);
                        u++;
                    }
                    f.push(this.createAddress(s, t, i, e.substring(c, u), !0));
                } else {
                    if ("<" !== h) {
                        f.push(this.createAddress(s, t, i, e.substring(c, u), o));
                    } else {
                        l = this.createAddress(s, t, i, e.substring(c, u), o);
                        if (i) {
                            t += "@" + i;
                        }
                    }
                }
                if (!l) {
                    c = u;
                } else {
                    n = this.parseAddressPart(e, u, c, t, l);
                    u = n.pos;
                    c = n.originalStart;
                    f.push(n.address);
                }
                break;

              case "<":
                n = this.parseAddressPart(e, u, c, t);
                u = n.pos;
                c = n.originalStart;
                f.push(n.address);
            }
        }
        return f;
    },
    isAddressValid: function(e) {
        var t, i, s, n = !1;
        if ("string" == typeof e) {
            t = e.indexOf("@");
            if (-1 !== t) {
                i = e.substring(0, t);
                s = e.substring(t + 1);
                n = this.isValidMailbox(i) && this.isValidDomain(s);
            }
        }
        return n;
    },
    escapeName: function(e) {
        return /[,@<;"]/gm.test(e) ? '"' + e.replace(/"/, '\\"') + '"' : e;
    },
    formatAddress: function(e, t) {
        if (e) {
            return this.escapeName(e) + " <" + t + ">";
        } else {
            return "<" + t + ">";
        }
    }
});

Ext.define("kerio.wm.model.Model", {
    extend: "Ext.data.Model",
    inheritableStatics: {
        DISPLAY_PREFIX: "_display_",
        _displayFieldNames: {}
    },
    getDisplayField: function(e) {
        var t = this.self._displayFieldNames[e];
        if (void 0 === t) {
            t = this.self.DISPLAY_PREFIX + e;
            this.self._displayFieldNames[e] = t;
        }
        return t;
    },
    constructor: function(e, t, i, s) {
        var n, o, r, a, l, d, c = this, h = !(s || !e);
        if (void 0 === t && e && c.idProperty) {
            t = e[this.idProperty];
        }
        c.callParent([ e, t, i, s || {} ]);
        n = c.fields;
        c.__data = c[c.persistenceProperty];
        c[c.persistenceProperty] = {};
        c.self._gettersSetters = c.self._gettersSetters || {};
        c._computedData = {};
        c.self._dependencyTree = c.self._dependencyTree || {};
        c._myDependencyTree = {};
        c._dependencies = [];
        d = this._getNewPropertyDescriptors();
        for (a = 0, l = n.getCount(); l > a; a++) {
            r = n.getAt(a);
            o = r.name;
            if (h && void 0 !== e[o]) {
                c.__data[o] = e[o];
            }
            d[o] = this._getPropertyCfg(r, o);
            if (r.toDisplay) {
                o = this.getDisplayField(o);
                d[o] = this._getPropertyCfg(r, o, !0);
            }
        }
        Object.defineProperties(c.data, d);
    },
    _getPropertyCfg: function(e, t, i) {
        var s, n, o = e.name;
        if (!this.self._gettersSetters.hasOwnProperty(t)) {
            if (i) {
                s = function(e) {
                    this.__model;
                };
                n = function() {
                    return kerio.wm.model.Model.prototype._getDisplayValue.call(this.__model, o);
                };
            } else {
                s = function(e) {
                    kerio.wm.model.Model.prototype._set.call(this.__model, o, e);
                };
                n = e.convert ? function() {
                    return kerio.wm.model.Model.prototype._getConverted.call(this.__model, o);
                } : function() {
                    return kerio.wm.model.Model.prototype._getRaw.call(this.__model, o);
                };
            }
            this.self._gettersSetters[t] = {
                set: s,
                get: n,
                enumerable: !0,
                configurable: !0
            };
        }
        return this.self._gettersSetters[t];
    },
    _getDisplayValue: function(e) {
        var t, i, s = this._computedData;
        if (s.hasOwnProperty(e) && void 0 !== s[e].displayValue) {
            return s[e].displayValue;
        }
        t = this.fields.get(e);
        i = this.fieldEncode(this.data[e], t);
        this._storeValue(e, i, "displayValue");
        return i;
    },
    _getRaw: function(e) {
        var t, i, s = this._dependencies.length;
        if (s) {
            this._dependencies[s - 1][e] = !0;
        }
        i = this.__data[e];
        if (void 0 === i) {
            t = this.fields.get(e);
            if (t.hasOwnProperty("defaultValue")) {
                i = t.defaultValue;
            }
        }
        return i;
    },
    _getConverted: function(e) {
        var t, i, s, n = this.__data, o = this._computedData, r = this._dependencies.length;
        if (r) {
            this._dependencies[r - 1][e] = !0;
        }
        if (o.hasOwnProperty(e) && void 0 !== o[e].computedValue) {
            return o[e].computedValue;
        }
        i = n[e];
        t = this.fields.get(e);
        if (void 0 === i && t.hasOwnProperty("defaultValue")) {
            i = t.defaultValue;
        }
        s = this._startCheckDependencies(t);
        i = t.convert(i, this);
        this._storeDependencies(s);
        this._storeValue(e, i, "computedValue");
        return i;
    },
    _startCheckDependencies: function(e) {
        var t;
        if (!e.persist) {
            t = e.weakDependencies ? !this._myDependencyTree.hasOwnProperty(e.name) : !this.self._dependencyTree.hasOwnProperty(e.name);
        }
        if (t || this._dependencies.length) {
            this._dependencies.push({});
        }
        return t ? e : void 0;
    },
    _storeValue: function(e, t, i) {
        this._computedData[e] = this._computedData[e] || {};
        this._computedData[e][i] = t;
    },
    _storeDependencies: function(e) {
        var t, i, s, n = this._dependencies.pop();
        if (e) {
            t = e.name;
            i = e.weakDependencies ? this._myDependencyTree : this.self._dependencyTree;
            i[t] = {};
            for (s in n) {
                if (n.hasOwnProperty(s)) {
                    i[s] = i[s] || {};
                    i[s][t] = !0;
                }
            }
        }
    },
    _set: function(e, t) {
        this.__data[e] = t;
        this._clearDependencies(e);
    },
    _clearDependencies: function(e, t) {
        var i, s;
        if (!t || this._computedData.hasOwnProperty(e)) {
            delete this._computedData[e];
            i = this.self._dependencyTree[e];
            if (i && i !== {}) {
                for (s in i) {
                    if (i.hasOwnProperty(s)) {
                        this._clearDependencies(s, !0);
                    }
                }
            }
            i = this._myDependencyTree[e];
            if (i) {
                for (s in i) {
                    if (i.hasOwnProperty(s)) {
                        this._clearDependencies(s, !0);
                    }
                }
                delete this._myDependencyTree[e];
            }
        }
    },
    getDisplay: function(e, t) {
        return this.get(t && !t.toDisplay ? e : this.getDisplayField(e));
    },
    destroy: function(e) {
        if (!this.phantom) {
            this.callParent(arguments);
        }
    },
    getDisplayData: function() {
        var e, t, i, s, n = {}, o = this.fields;
        for (s = 0; s < o.length; s++) {
            e = o.getAt(s);
            i = e.name;
            t = this.getDisplay(i, e);
            if (void 0 !== t) {
                n[i] = t;
            }
        }
        return n;
    },
    fieldEncode: function(e, t) {
        if (t && t.noDisplayConversion === !0) {
            return e;
        } else {
            if (t && "function" == typeof t.toDisplay) {
                return t.toDisplay(e);
            }
        }
        if ("string" != typeof e) {
            return this.deepDataEncode(e, 0);
        } else {
            return Ext.htmlEncode(e);
        }
    },
    deepDataEncode: function(e, t) {
        var i, s;
        if (t > 10) {
            return e;
        }
        if ("string" == typeof e) {
            return Ext.htmlEncode(e);
        } else {
            if ("object" == typeof e) {
                if (e instanceof Date) {
                    return e;
                } else {
                    if (e instanceof Array) {
                        s = [];
                        for (i = 0; i < e.length; i++) {
                            s.push(this.deepDataEncode(e[i], t + 1));
                        }
                        return s;
                    } else {
                        s = {};
                        for (i in e) {
                            if (e.hasOwnProperty(i)) {
                                s[i] = this.deepDataEncode(e[i], t + 1);
                            }
                        }
                        return s;
                    }
                }
            } else {
                return e;
            }
        }
    },
    getAssociatedData: function() {
        return {};
    }
});

Ext.define("kerio.wm.model.mail.MailAddressModel", {
    extend: "kerio.wm.model.Model",
    fields: [ "id", "folderId", "type", {
        name: "phoneNumbers",
        defaultValue: [],
        persist: !1
    }, {
        name: "displayName",
        toDisplay: !0
    }, {
        name: "displayAddress",
        toDisplay: !0
    }, {
        name: "mailAddress",
        defaultValue: "",
        persist: !1
    }, "emailAddresses", {
        name: "isAutoCreated",
        defaultValue: !1,
        persist: !1
    }, "value", "name", "searchFields", "sortValue", "photoUrl", "companyName", "comment", "certContactId", "hasValidCertificate", {
        name: "alternativeDisplayNames",
        persist: !1
    } ],
    isDistributionList: function() {
        return "ctDistributionList" === this.get("type");
    },
    isContact: function() {
        return "ctContact" === this.get("type");
    }
});

Ext.define("kerio.wm.utils.Trie", {
    constructor: function(e) {
        this.config = e;
        if (void 0 === e.depth) {
            this.depth = 3;
        } else {
            this.depth = e.depth;
        }
        this.keysAccessFn = e.keysAccessFn;
        if (e.sortAccessFn) {
            this.sortAccessFn = e.sortAccessFn;
            this.sorted = !0;
        } else {
            this.sortAccessFn = function() {
                return "";
            };
            this.config.sortAccessFn = this.sortAccessFn;
            this.sorted = !1;
        }
        this.clear();
    },
    clear: function() {
        this.map = {};
        this.list = [];
        if (this.depth > 0) {
            this.nodes = {};
        }
    },
    add: function(e) {
        var t, i;
        if (!Ext.isArray(e)) {
            e = Array.prototype.slice.apply(arguments);
        }
        for (t = 0; t < e.length; t++) {
            i = e[t];
            this._add(i, this.keysAccessFn(i), this.sortAccessFn(i) || "", i.getId(), 0);
        }
    },
    getById: function(e) {
        var t = this.map[e];
        return t ? t.model : void 0;
    },
    remove: function(e) {
        var t = this.map[e];
        if (t) {
            this._remove(e, t.keys, 0);
            return !0;
        } else {
            return !1;
        }
    },
    find: function(e, t) {
        return this._find(e || "", 0, t);
    },
    _groupKeys: function(e, t) {
        var i, s, n, o = {};
        for (n = 0; n < e.length; n++) {
            i = e[n];
            if (i.length > t) {
                s = i.charAt(t);
                o[s] = o[s] || [];
                o[s].push(i);
            }
        }
        return o;
    },
    _matcherFn: function(e, t) {
        return e === t || e.length > t.length && e.substring(0, t.length) === t;
    },
    _sortComparator: function(e, t) {
        if (e > t) {
            return 1;
        } else {
            if (t > e) {
                return -1;
            } else {
                return 0;
            }
        }
    },
    _binarySearch: function(e, t) {
        var i, s, n = 0, o = e.length - 1;
        while (o >= n) {
            i = Math.floor((n + o) / 2);
            s = this._sortComparator(e[i].sort, t);
            if (0 > s) {
                n = i + 1;
            } else {
                if (s > 0) {
                    o = i - 1;
                } else {
                    while (i + 1 < e.length && e[i + 1].sort === t) {
                        i++;
                    }
                    return i;
                }
            }
        }
        return -n - 1;
    },
    _add: function(e, t, i, s, n) {
        var o, r, a, l = {
            model: e,
            sort: i,
            keys: t
        };
        if (this.map[s]) {
            this.remove(s);
        }
        this.map[s] = l;
        if (this.sorted) {
            a = this._binarySearch(this.list, l.sort);
            if (0 > a) {
                a = -a - 1;
            } else {
                a++;
            }
            if (a === this.list.length) {
                this.list.push(l);
            } else {
                if (0 === a) {
                    this.list.unshift(l);
                } else {
                    this.list.splice(a, 0, l);
                }
            }
        } else {
            this.list.push(l);
        }
        if (this.depth > 0) {
            r = this._groupKeys(t, n);
            for (o in r) {
                if (r.hasOwnProperty(o)) {
                    this.nodes[o] = this.nodes[o] || new kerio.wm.utils.Trie({
                        depth: this.depth - 1,
                        keysAccessFn: this.keysAccessFn,
                        sortAccessFn: this.sortAccessFn
                    });
                    this.nodes[o]._add(e, r[o], l.sort, s, n + 1);
                }
            }
        }
    },
    _remove: function(e, t, i) {
        var s, n, o, r = this.map[e], a = Ext.Array.indexOf(this.list, r);
        delete this.map[e];
        if (-1 !== a) {
            this.list.splice(a, 1);
        }
        if (this.depth > 0) {
            o = this._groupKeys(t, i);
            for (s in o) {
                if (o.hasOwnProperty(s)) {
                    n = this.nodes[s];
                    n._remove(e, o[s], i + 1);
                    if (0 === n.list.length) {
                        delete this.nodes[s];
                    }
                }
            }
        }
    },
    _find: function(e, t, i) {
        var s, n, o, r, a, l, d = Math.min(e.length - t, this.depth);
        if (0 === d) {
            l = [];
            for (n = 0; n < this.list.length; n++) {
                s = this.list[n].keys;
                for (o = 0; o < s.length; o++) {
                    r = s[o];
                    if (this._matcherFn(r, e)) {
                        a = this.list[n].model;
                        if ("function" != typeof i || i(r, a)) {
                            l.push(a);
                            break;
                        }
                    }
                }
            }
            return l;
        } else {
            if (this.depth > 0 && this.nodes[e.charAt(t)]) {
                return this.nodes[e.charAt(t)]._find(e, t + 1, i);
            } else {
                return [];
            }
        }
    }
});

Ext.define("kerio.wm.view.MsgImpl", {
    extend: "Ext.window.MessageBox",
    styles: !0,
    requires: [ "kerio.wm.view.WebmailButton", "kerio.wm.Constants" ],
    minWidth: 320,
    maxWidth: 450,
    alwaysOnTop: !0,
    _comparableProperties: [ "title", "msg", "buttons", "origFn" ],
    focusOnClose: void 0,
    initComponent: function() {
        this._msgStack = [];
        this.handleKeys = [ Ext.EventObject.ENTER ];
        this.callParent(arguments);
        this.bottomTb.layout.shrinkToFit = !1;
        this.bottomTb.setHeight(52);
        delete this.topContainer.style.padding;
        this.bottomTb.layout.pack = "end";
        this._buttonWidthCache = {};
        this.addListener({
            beforehide: function() {
                if (this._autoClose) {
                    this._autoClose.cancel();
                }
            },
            scope: this
        });
    },
    onEsc: function(e, t) {
        t.stopEvent();
        this[this.closeAction]();
    },
    initTools: function() {
        var e = this;
        e.tools = e.tools ? Ext.Array.clone(e.tools) : [];
        if (e.collapsible && !e.hideCollapseTool && e.header !== !1) {
            e.collapseDirection = e.collapseDirection || e.headerPosition || "top";
            e.collapseTool = e.expandTool = e.createComponent({
                xtype: "tool",
                type: "collapse-" + e.collapseDirection,
                expandType: e.getOppositeDirection(e.collapseDirection),
                handler: e.toggleCollapse,
                scope: e
            });
            if (e.collapseFirst) {
                e.tools.unshift(e.collapseTool);
            }
        }
        e.addTools();
        if (e.closable) {
            e.addClsWithUI("closable");
            e.addTool({
                type: "close",
                tooltip: e.closableTooltipText || k_tr("Close", "common"),
                tooltipType: "title",
                handler: Ext.Function.bind(e.close, this, [])
            });
        }
        if (e.collapseTool && !e.collapseFirst) {
            e.tools.push(e.collapseTool);
        }
    },
    makeButton: function(e) {
        var t, i = this.buttonIds[e];
        t = Ext.create("kerio.wm.view.WebmailButton", {
            listeners: {
                click: this.btnCallback,
                scope: this
            },
            itemId: i,
            scope: this,
            text: this.buttonText[i],
            style: "min-width: 70px",
            minWidth: 0,
            buttonText: ""
        });
        return t;
    },
    btnCallback: function(e) {
        var t, i, s = this;
        if (s.cfg.prompt || s.cfg.multiline) {
            if (s.cfg.multiline) {
                i = s.textArea;
            } else {
                i = s.textField;
            }
            t = i.getValue();
            i.reset();
        }
        e.blur();
        s.hide(!0);
        if (this.focusOnClose) {
            this.focusOnClose.focus();
            delete this.focusOnClose;
        }
        s.userCallback(e.itemId, t, s.cfg);
    },
    hide: function(e) {
        this.callParent();
        if (!e) {
            var t, i, s = this;
            if (s.cfg.prompt || s.cfg.multiline) {
                if (s.cfg.multiline) {
                    i = s.textArea;
                } else {
                    i = s.textField;
                }
                t = i.getValue();
                i.reset();
            }
            s.userCallback("close", t, s.cfg);
        }
    },
    show: function(e) {
        e.origFn = e.fn;
        if (void 0 === e.fn) {
            e.fn = this._removeMsgFromStack;
            e.scope = this;
        } else {
            e.fn = this._createSequenceFinally(e.fn, this._removeMsgFromStack, this);
        }
        this._addMsgToStack(e);
        if (1 === this._msgStack.length) {
            this._showMsgFromStack();
        }
    },
    _addMsgToStack: function(e) {
        var t = !0;
        if (this._msgStack.length > 0) {
            t = !this._cfgIsIdentical(e, this._msgStack[this._msgStack.length - 1]);
        }
        if (t && this._msgStack.length < 10) {
            this._msgStack.push(e);
        } else {}
    },
    _cfgIsIdentical: function(e, t) {
        return this._compareCfg(e, t) && this._compareCfg(t, e) && void 0 === e.origFn;
    },
    _compareCfg: function(e, t) {
        var i;
        for (i in e) {
            if (e.hasOwnProperty(i) && Ext.Array.contains(this._comparableProperties, i) && e[i] !== t[i]) {
                return !1;
            }
        }
        return !0;
    },
    _showMsgFromStack: function() {
        var e, t, i, s, n, o, r = this._msgStack;
        if (r.length > 0) {
            s = r[0];
            s.fn = Ext.Function.createSequence(s.fn, this._showMsgFromStack, this);
            t = this._getDefaultButtonId(s);
            for (o = 0, i = this.bottomTb.query("webmailbutton"); o < i.length; o++) {
                n = i[o];
                n.setDefault(n.itemId === t);
            }
            for (n in Ext.Msg.buttonText) {
                if (Ext.Msg.buttonText.hasOwnProperty(n)) {
                    if (s.buttonText && s.buttonText[n]) {
                        this.msgButtons[n].setText(s.buttonText[n]);
                    } else {
                        this.msgButtons[n].setText(Ext.Msg.buttonText[n]);
                    }
                }
            }
            e = Ext.window.MessageBox.prototype.show.call(this, s);
            if (s.validityDuration) {
                this._autoClose = this._autoClose || new Ext.util.DelayedTask();
                this._autoClose.delay(1e3 * s.validityDuration, this._autoCloseTask, this, [ e ]);
            }
        }
    },
    _autoCloseTask: function(e) {
        e.close();
    },
    _getDefaultButtonId: function(e) {
        var t = e.defaultButton || null;
        if (!t) {
            switch (e.buttons) {
              case Ext.MessageBox.OK:
                t = "ok";
                break;

              case Ext.MessageBox.YESNO:
                t = "no";
                break;

              case Ext.MessageBox.OKCANCEL:
                t = "cancel";
                break;

              case Ext.MessageBox.YESNOCANCEL:
                t = "yes";
                break;

              default:
                t = null;
            }
        }
        return t;
    },
    reconfigure: function(e) {
        var t = this._getDefaultButtonId(e);
        this.callParent(arguments);
        if (this.defaultFocus instanceof kerio.wm.view.WebmailButton && this.defaultFocus !== t && t) {
            this.defaultFocus = t;
        }
        if (void 0 !== e.alwaysOnTop) {
            this.alwaysOnTop = e.alwaysOnTop;
        } else {
            this.alwaysOnTop = Ext.getClass(this).prototype.alwaysOnTop;
        }
    },
    _removeMsgFromStack: function() {
        this._msgStack.shift();
    },
    _createSequenceFinally: function(e, t, i) {
        if (!t) {
            return e;
        } else {
            return function() {
                var s;
                try {
                    s = e.apply(this, arguments);
                } finally {
                    t.apply(i || this, arguments);
                }
                return s;
            };
        }
    },
    _getButtonsWidth: function() {
        var e, t, i, s = this.bottomTb.items, n = "", o = 0, r = 0, a = 0;
        for (t = 0, i = s.getCount(); i > t; t++) {
            e = s.getAt(t);
            if (e.isVisible()) {
                n = e.getText();
                o = this._buttonWidthCache[n];
                if (void 0 === o) {
                    o = e.getWidth();
                    this._buttonWidthCache[n] = o;
                }
                a += o;
                r++;
            }
        }
        return a + 6 * (r - 1) + this.bottomTb.getEl().getPadding("lr");
    },
    doAutoSize: function(e) {
        var t, i, s, n = this, o = n.iconComponent, r = n.iconHeight;
        if (!Ext.isDefined(n.frameWidth)) {
            n.frameWidth = n.el.getWidth() - n.body.getWidth();
        }
        o.setHeight(r);
        n.minWidth = n.cfg.minWidth || Ext.getClass(this).prototype.minWidth;
        n.topContainer.doLayout();
        if (Ext.isIE6 || Ext.isIEQuirks) {
            n.textField.setCalculatedSize(9);
            n.textArea.setCalculatedSize(9);
        }
        s = this._getButtonsWidth();
        n.maxWidth = Math.max(s, Ext.getClass(n).prototype.maxWidth);
        t = (n.cfg.width || n.msg.getWidth()) + o.getWidth();
        t = Math.max(t, Ext.util.TextMetrics.measure(n.header.getEl().down(".x-window-header-text"), n.title).width + 15, s) + 50;
        n.setWidth(t + n.frameWidth);
        i = (n.header.rendered ? n.header.getHeight() : 0) + Math.max(n.promptContainer.getHeight(), o.getHeight()) + n.progressBar.getHeight() + (n.bottomTb.rendered ? n.bottomTb.getHeight() : 0) + 35;
        o.setHeight(Math.max(r, n.msg.getHeight()));
        n.setHeight(i + n.frameWidth);
        if (e) {
            n.center();
        }
        return n;
    },
    cantBeDone: function(e, t, i, s) {
        this.show({
            title: e,
            msg: t,
            buttons: kerio.wm.view.Msg.OK,
            fn: i,
            scope: s
        });
    },
    serverErrors: function(e, t, i, s) {
        kerio.wm.AppInterface.serverErrors({
            defaultFn: this._serverErrors,
            scope: this,
            args: arguments
        });
    },
    _serverErrors: function(e, t, i, s) {
        var n, o, r, a = [];
        e = kerio.wm.utils.Utils.normalizeServerErrors(e);
        n = e.length;
        o = e[0].code;
        switch (o) {
          case -1:
          case -32002:
          case -32003:
            this.showError(k_tr("Server is not responding", "common"), e[0].message, t, i, 5);
            return;
        }
        if (n > 4) {
            n = 2;
        }
        for (r = 0; n > r; r++) {
            a.push(kerio.wm.utils.Utils.translateServerError(e[r]));
        }
        if (e.length > 4) {
            n = e.length - 2;
            a.push(k_tr("There [is|are] another %1 error [message|messages]!", "common", {
                k_args: [ n ],
                k_pluralityBy: n
            }));
        }
        a = a.join("<br>");
        if (s) {
            this.showError(s, a, t, i);
        } else {
            this.showServerError(a, t, i);
        }
    },
    showServerError: function(e, t, i) {
        var s = Ext.isObject(e) ? e : {
            msg: e,
            fn: t,
            scope: i
        };
        s.title = k_tr("Server error", "mail");
        this.showError(s);
    },
    showError: function(e, t, i, s, n) {
        var o = Ext.isObject(e) ? e : {};
        e = Ext.isObject(e) ? o.title : e;
        o.title = e;
        this.show(Ext.applyIf(o, {
            msg: t,
            buttons: kerio.wm.view.Msg.OK,
            fn: i,
            cls: "error",
            validityDuration: n || !1,
            scope: s
        }));
    }
});

Ext.define("kerio.wm.utils.ChunkedOperation", {
    singleton: !0,
    MAX_RUN_TIME: 50,
    timeoutFn: function() {
        return window.setImmediate ? function(e, t) {
            var i = this;
            return window.setImmediate.apply(window, [ function() {
                return e.apply(i, arguments);
            } ].concat(t));
        } : function(e, t) {
            var i = this;
            return window.setTimeout(function() {
                return e.apply(i, t);
            }, 0);
        };
    }(),
    run: function(e, t, i, s) {
        var n = e.slice(0);
        this.timeoutFn(function o(e, t, i, s, n, r) {
            var a, l = +new Date(), d = this.MAX_RUN_TIME;
            r = r || 0;
            try {
                while (e.length && +new Date() - l < d) {
                    if (!1 === t.fn.call(t.scope || window, n, e.shift(), r++)) {
                        return;
                    }
                }
                a = e.length;
            } catch (c) {
                if (s) {
                    s.fn.call(s.scope || window, c);
                } else {
                    throw c;
                }
                return;
            }
            if (a) {
                this.timeoutFn(o, [ e, t, i, s, n, r ]);
            } else {
                if (i) {
                    i.fn.call(i.scope || window, n);
                }
            }
        }, [ n, t, i, s, e ]);
    }
});

Ext.define("kerio.wm.messages.DeferedLoad", {
    _deferedLoads: void 0,
    dataReady: void 0,
    loadDefered: function() {
        if (!this._deferedLoads) {
            this._deferedLoads = [];
        }
        if (!this.dataReady) {
            this._deferedLoads.push(Array.prototype.splice.call(arguments, 0));
            return;
        }
        this._processLoad.apply(this, arguments);
    },
    _processLoad: function(e) {
        var t = this;
        Ext.callback(e.callback, e.scope || t, [ t.data.items ]);
    },
    _extStoreLoad: function() {
        var e = this;
        this.dataReady = !0;
        e.loading = !1;
        if (e.hasListeners.load) {
            e.fireEvent("load", e, e.data.items, !0);
        }
        if (e.hasListeners.read) {
            e.fireEvent("read", e, e.data.items, !0);
        }
    },
    onLoaded: function() {
        var e = this;
        return new Promise(function(t, i) {
            e.load({
                callback: Ext.bind(t, e)
            });
            e.loadDefered.apply(e, arguments);
        });
    },
    onAfterLoad: function() {
        var e, t = this._deferedLoads || [];
        this.dataReady = !0;
        this._extStoreLoad();
        for (e = 0; e < t.length; e++) {
            this._processLoad.apply(this, t[e]);
        }
        this._deferedLoads = [];
    }
});

Ext.define("kerio.wm.utils.file.Download", {
    singleton: !0,
    uses: [ "kerio.wm.AppInterface" ],
    download: function(e) {
        kerio.wm.AppInterface.download({
            scope: this,
            defaultFn: function(e) {
                if (e) {
                    var t = "hiddenDownloader", i = document.getElementById(t);
                    if (null === i) {
                        i = document.createElement("iframe");
                        i.id = t;
                        i.style.display = "none";
                        document.body.appendChild(i);
                    }
                    i.src = e;
                }
            },
            args: [ e ]
        });
    }
});

Ext.define("kerio.wm.SettingsManager", {
    singleton: !0,
    requires: [ "kerio.wm.AppInterface", "kerio.wm.Constants" ],
    MAIL_SIGNATURE_KEY: "webmail.mailSignature",
    MAIL_SIGNATURE_IMAGES_KEY: "mailSignatureImages",
    constructor: function() {
        Ext.USE_NATIVE_JSON = !0;
        this._isBase64ImgRe = kerio.wm.Constants.BASE64_IMAGE_REGEXP;
        this._prepareDefaults();
        this.processors = [ {
            prefix: /^webmail/,
            process: this._processSettings
        }, {
            prefix: /^outOfOffice/,
            process: this._processOutOfOffice
        }, {
            prefix: /^userDetails/,
            process: this._processUserDetails
        } ];
    },
    _prepareDefaults: function() {
        if (!window.ParentSettingsJson) {
            if (kerio.engine && kerio.engine.settings && kerio.engine.settings.webmail) {
                var e = {
                    webmail: kerio.engine.settings.webmail,
                    mailSignatureImages: this._preprocessMailSignatureImages(kerio.engine.signatureImageList) || [],
                    userDetails: {
                        preferredAddress: kerio.wm.Constants.userDetails.preferredAddress,
                        replyToAddress: kerio.wm.Constants.userDetails.replyToAddress
                    }
                };
                delete kerio.wm.Constants.userDetails.preferredAddress;
                delete kerio.wm.Constants.userDetails.replyToAddress;
                if (kerio.engine.outOfOffice) {
                    e.outOfOffice = kerio.engine.outOfOffice;
                }
                this._settings = e;
                if (e.webmail.mailSignature) {
                    e.webmail.mailSignature = this._getSignatureToDisplay();
                }
            } else {
                this._defaults = {};
                this._settings = {};
            }
        } else {
            this._settings = Ext.JSON.decode(window.ParentSettingsJson);
        }
        delete kerio.engine;
    },
    load: function(e, t) {
        this._process("load", e, t);
    },
    save: function(e, t) {
        kerio.wm.AppInterface.settingsManagerSave({
            defaultFn: function(e, t) {
                this._process("save", e, t);
            },
            scope: this,
            args: [ e, t ]
        });
    },
    get: function(e) {
        return this._get(e, this._settings);
    },
    _get: function(e, t) {
        var i, s = e.split("."), n = t, o = null;
        for (i = 0; i < s.length; i++) {
            if (n.hasOwnProperty(s[i])) {
                n = n[s[i]];
                o = n;
            } else {
                o = null;
                break;
            }
        }
        return o;
    },
    isIMEnabled: function() {
        return this._settings.webmail.im.enabled && kerio.wm.Constants.IS_INSTANT_MESSAGING_ENABLED;
    },
    _getSignatureToDisplay: function() {
        var e, t, i = this.get(this.MAIL_SIGNATURE_KEY), s = this.get(this.MAIL_SIGNATURE_IMAGES_KEY);
        i = "string" == typeof i ? i.trim() : "";
        this._generateSignatureContentIds();
        for (e = 0, t = s.length; t > e; e++) {
            i = i.replace(new RegExp(s[e].contentId, "g"), s[e].url);
        }
        return i;
    },
    set: function(e, t) {
        var i, s, n, o, r = this._settings;
        s = e.split(".");
        n = s.length;
        for (i = 0; n > i; i++) {
            o = s[i];
            if (!r.hasOwnProperty(o)) {
                r[o] = {};
            }
            if (i === n - 1) {
                r[o] = t;
            } else {
                r = r[o];
            }
        }
    },
    _process: function(e, t, i) {
        var s, n, o, r, a, l = [], d = 0, c = 0;
        for (n = 0; n < t.length; n++) {
            for (s = 0; s < this.processors.length; s++) {
                o = this.processors[s];
                if (o.prefix.test(t[n])) {
                    if (void 0 === l[s]) {
                        l[s] = [];
                        d++;
                    }
                    l[s].push(t[n]);
                    break;
                }
            }
            if (s === this.processors.length) {}
        }
        a = {
            failure: function() {
                d = 0;
                if (i && i.failure) {
                    i.failure.apply(i.scope || window, arguments);
                }
            },
            success: function() {
                var s;
                c++;
                if (c === d) {
                    if ("load" === e) {
                        if (-1 !== Ext.Array.indexOf(t, this.MAIL_SIGNATURE_KEY)) {
                            kerio.api.Session.getSignatureImageList({
                                success: function(e) {
                                    this._settings.mailSignatureImages = this._preprocessMailSignatureImages(e.getList());
                                    this.set(this.MAIL_SIGNATURE_KEY, this._getSignatureToDisplay());
                                    i && i.success && i.success.apply(i.scope || window, this._prepareParamsForLoadCallback(t));
                                },
                                failure: function() {
                                    i && i.failure && i.failure.call(i.scope || window);
                                },
                                scope: this
                            });
                            return;
                        }
                        s = this._prepareParamsForLoadCallback(t);
                    } else {
                        s = [ this ];
                    }
                    if (i && i.success) {
                        i.success.apply(i.scope || window, s);
                    }
                }
            },
            scope: this
        };
        for (s = 0; s < l.length; s++) {
            r = l[s];
            if (void 0 !== r) {
                o = this.processors[s];
                o.process[e].call(this, r, a);
            }
        }
    },
    _preprocessMailSignatureImages: function(e) {
        if (e) {
            e.forEach(function(e) {
                e.url = kerio.wm.AppInterface.getInlineAttachmentPath(e.url);
            });
        }
        return e;
    },
    _prepareParamsForLoadCallback: function(e) {
        var t, i = e.length, s = [];
        for (t = 0; i > t; t++) {
            s.push(this.get(e[t]));
        }
        return s;
    },
    _extractKeysTree: function(e) {
        var t, i;
        if ("object" == typeof e && null !== e && !Ext.isArray(e)) {
            i = {};
            for (t in e) {
                if (e.hasOwnProperty(t)) {
                    i[t] = this._extractKeysTree(e[t]);
                }
            }
            return i;
        } else {
            return !0;
        }
    },
    _clone: function(e) {
        var t, i, s, n, o = this._settings, r = o, a = {}, l = a, d = null;
        i = e.split(".");
        s = i.length;
        for (t = 0; s > t; t++) {
            n = i[t];
            if (r.hasOwnProperty(n)) {
                r = r[n];
            } else {
                l = null;
                break;
            }
            if (t === s - 1) {
                l[n] = Ext.clone(r);
            } else {
                l[n] = {};
                l = l[n];
            }
        }
        if (null !== l) {
            d = a;
        }
        return d;
    },
    _getMailSignatureForSave: function(e) {
        var t, i, s, n = this.get(this.MAIL_SIGNATURE_IMAGES_KEY), o = [], r = [];
        for (i = 0, s = n.length; s > i; i++) {
            t = new RegExp(Ext.String.escapeRegex(n[i].url), "g");
            if (!this._isNewImageInSignature(n[i]) && !t.test(e)) {
                o.push(n[i].id);
            } else {
                e = e.replace(t, n[i].contentId);
                r.push(n[i]);
            }
        }
        return e;
    },
    _isNewImageInSignature: function(e) {
        return !!e.isNew;
    },
    _generateSignatureContentIds: function() {
        var e, t = this.get(this.MAIL_SIGNATURE_IMAGES_KEY);
        for (e = 0; e < t.length; e++) {
            this._setSignatureImageContentId(t[e]);
        }
    },
    _setSignatureImageContentId: function(e) {
        var t = e.id.split("/");
        e.contentId = t[t.length - 1];
    },
    _saveSignatureImages: function(e) {
        var t, i, s, n, o = this.get(this.MAIL_SIGNATURE_KEY), r = this.get(this.MAIL_SIGNATURE_IMAGES_KEY), a = [], l = [];
        if (!e) {
            return Promise.resolve();
        }
        for (n = 0; n < r.length; n++) {
            s = new RegExp(Ext.String.escapeRegex(r[n].url), "g");
            if (!this._isNewImageInSignature(r[n]) && !s.test(o)) {
                a.push(r[n].id);
            } else {
                if (this._isNewImageInSignature(r[n]) && s.test(o)) {
                    l.push(r[n].id);
                }
            }
        }
        t = a.length ? kerio.api.Session.removeSignatureImage({
            ids: a
        }) : Promise.resolve({
            result: {
                result: []
            },
            params: {
                ids: []
            }
        });
        i = l.length ? kerio.api.Session.addSignatureImage({
            ids: l
        }) : Promise.resolve({
            result: {
                result: []
            },
            params: {
                ids: []
            }
        });
        return Promise.all([ t, i ]).then(function(e) {
            var t, i, s, n = this.get(this.MAIL_SIGNATURE_IMAGES_KEY), o = this.get(this.MAIL_SIGNATURE_KEY), r = this._preprocessMailSignatureImages(e[1].result.result), a = e[1].params.ids, l = e[0].params.ids;
            for (i = 0; i < l.length; i++) {
                for (s = 0; s < n.length; s++) {
                    if (n[s].id === l[i]) {
                        n.splice(s, 1);
                    }
                }
            }
            for (i = 0; i < a.length; i++) {
                for (s = 0; s < n.length; s++) {
                    if (n[s].id === a[i]) {
                        t = new RegExp(Ext.String.escapeRegex(n[s].url), "g");
                        o = o.replace(t, r[i].url);
                        n[s] = r[i];
                        this._setSignatureImageContentId(n[s]);
                    }
                }
            }
            this.set(this.MAIL_SIGNATURE_KEY, o);
        }.bind(this));
    },
    _getSignatureForSave: function() {
        var e, t, i = this.get(this.MAIL_SIGNATURE_IMAGES_KEY), s = this.get(this.MAIL_SIGNATURE_KEY);
        for (e = 0; e < i.length; e++) {
            t = new RegExp(Ext.String.escapeRegex(i[e].url), "g");
            s = s.replace(t, i[e].contentId);
        }
        return s;
    },
    _processSettings: {
        load: function(e, t) {
            var i, s = this, n = [];
            for (i = 0; i < e.length; i++) {
                n.push(e[i].split("."));
            }
            kerio.api.Session.getSettings({
                query: n
            }, {
                success: function(e) {
                    s._settings = Ext.Object.merge(s._settings, e.settings);
                    t.success.call(t.scope || window);
                },
                failure: function() {
                    t.failure.apply(t.scope || window, arguments);
                }
            });
        },
        save: function(e, t) {
            var i, s, n = null, o = !1;
            for (i = 0; i < e.length; i++) {
                s = this._clone(e[i]);
                if (e[i] === this.MAIL_SIGNATURE_KEY) {
                    o = !0;
                }
                if (null !== s) {
                    n = Ext.merge({}, n, s);
                }
            }
            if (null === n) {
                t.failure.call(t.scope || window);
                return;
            }
            this._saveSignatureImages(o).then(function() {
                if (void 0 !== n.webmail.mailSignature) {
                    n.webmail.mailSignature = this._getSignatureForSave();
                }
                kerio.api.Session.setSettings({
                    settings: n
                }, {
                    success: function(e, i) {
                        t.success.call(t.scope || window);
                    },
                    failure: function() {
                        t.failure.call(t.scope || window);
                    }
                });
            }.bind(this));
        }
    },
    _processUserDetails: {
        load: function(e, t) {
            var i = this;
            kerio.api.Session.whoAmI({
                success: function(e) {
                    i._settings.userDetails = {
                        preferredAddress: e.userDetails.preferredAddress,
                        replyToAddress: e.userDetails.replyToAddress
                    };
                    t.success.call(t.scope || window);
                },
                failure: function() {
                    t.failure.call(t.scope || window);
                }
            });
        },
        save: function(e, t) {
            var i, s, n = null;
            for (i = 0; i < e.length; i++) {
                s = this._clone(e[i]);
                if (null !== s) {
                    n = Ext.merge({}, n, s);
                }
            }
            kerio.api.Session.setUserInfo(n, {
                success: function(e) {
                    t.success.call(t.scope || window);
                },
                failure: function() {
                    t.failure.call(t.scope || window);
                }
            });
        }
    },
    _processOutOfOffice: {
        load: function(e, t) {
            var i = this;
            kerio.api.Session.getOutOfOffice({
                success: function(e) {
                    i._settings = Ext.Object.merge(i._settings, {
                        outOfOffice: e.settings
                    });
                    t.success.call(t.scope || window);
                },
                failure: function() {
                    t.failure.call(t.scope || window);
                }
            });
        },
        save: function(e, t) {
            var i = this;
            kerio.api.Session.setOutOfOffice({
                settings: i._settings.outOfOffice
            }, {
                success: function(e) {
                    t.success.call(t.scope || window);
                },
                failure: function() {
                    t.failure.call(t.scope || window);
                }
            });
        }
    }
});

Ext.define("kerio.wm.utils.MailUtils", {
    singleton: !0,
    requires: [ "kerio.wm.Constants", "kerio.wm.utils.MailAddressParser" ],
    uses: [ "kerio.wm.AppInterface" ],
    formatEmail: function(e, t, i) {
        var s, n = i ? ' class="' + i + '" ' : " ", o = Ext.String.trim(e.address), r = Ext.String.trim(e.name);
        if (Ext.isEmpty(r)) {
            if (Ext.isEmpty(o)) {
                o = k_tr("Unknown", "mail");
            }
            s = Ext.String.format("<span{1}>{0}</span>", o, n);
        } else {
            if (t) {
                s = Ext.String.format('<span{2}title="{0}">{1}</span><span class="detail"> &lt;{0}&gt;</span>', o, r, n);
            } else {
                s = Ext.String.format('<span{2}title="{0}">{1}</span>', o, r, n);
            }
        }
        if (!t) {
            return s;
        }
        return '<span data-mailaddress="' + o + '" data-contactname="' + (r || "") + '" class="clickable">' + s + "</span>";
    },
    formatPriority: function(e) {
        return "High" === e ? '<div class="mailHighPriority" title="' + k_tr("High Priority", "mail") + '"></div>' : "";
    },
    formatAttachmentUrl: function(e, t, i) {
        if (e && e.id && (e.name || i)) {
            return kerio.wm.AppInterface.getInlineAttachmentPath("/webmail/api/download/tmp/" + e.id + "/" + encodeURI(i || e.name) + "?target-user=" + encodeURIComponent(t));
        } else {
            return;
        }
    },
    formatSubject: function(e) {
        e = Ext.String.trim(e);
        return "" === e ? kerio.wm.Constants.noSubject : e;
    },
    createEmailsString: function(e) {
        var t, i = "";
        if (e) {
            for (t = 0; t < e.length; t++) {
                if (t > 0) {
                    i += ", ";
                }
                i += kerio.wm.utils.MailUtils.createEmailString(e[t]);
            }
        }
        return i;
    },
    parseEmailAddresses: function(e) {
        var t, i, s = [], n = 0, o = kerio.wm.utils.MailAddressParser.parseAddresses(e);
        while (o[n]) {
            t = o[n];
            i = "";
            if (t.mailbox) {
                i += t.mailbox + (t.domain ? "@" : "");
            }
            i += t.domain || "";
            s.push({
                address: i,
                name: t.name
            });
            n++;
        }
        return s;
    },
    createEmailString: function(e) {
        return kerio.wm.utils.MailAddressParser.formatAddress(e.name, e.address);
    }
});

Ext.define("kerio.wm.view.LinkTooltip", {
    extend: "kerio.wm.view.FloatingPanel",
    cls: "linkTooltip",
    alias: "widget.linkTooltip",
    MAX_LINK_VISIBLE_LENGTH: 50,
    styles: !0,
    autoHide: !0,
    closeAction: "hide",
    disablePositionAdjusting: !0,
    html: k_tr("Visit URL: ", "mail") + '<a id="__wm_visitLink" href="">empty</a> - <a id="__wm_editLink" href="">' + k_tr("Change", "mail") + "</a>",
    constructor: function(e) {
        this.handleKeys = [ Ext.EventObject.ESC ];
        this.callParent(arguments);
        this._htmlEditor = e.htmlEditor;
    },
    setLink: function(e) {
        this._outerLink = e;
    },
    setLinkHref: function(e) {
        this._outerLinkHref = e;
    },
    beforeShow: function() {
        var e = this.getEl().query("#__wm_visitLink")[0];
        e.href = this._outerLinkHref;
        e.title = this._outerLinkHref;
        e.innerHTML = encodeURI(Ext.util.Format.ellipsis(this._outerLinkHref, this.MAX_LINK_VISIBLE_LENGTH));
        this.doLayout();
        return this.callParent();
    },
    afterRender: function() {
        var e = this.getEl().query("#__wm_visitLink")[0], t = this.getEl().query("#__wm_editLink")[0];
        Ext.fly(e).on("click", function(e, t) {
            kerio.wm.AppInterface.openLinkFromTooltip({
                scope: this,
                defaultFn: function(e, t) {
                    var i = this._htmlEditor.getAnchorHref(t);
                    if (!t || "A" !== t.tagName.toUpperCase() || !i) {
                        return;
                    }
                    kerio.wm.Locations.openInNewWindow(i);
                    this.hide();
                },
                args: [ e, t ]
            });
        }, this, {
            stopEvent: !0
        });
        Ext.fly(t).on("click", function() {
            Ext.defer(function() {
                this._htmlEditor.openLinkEditor(this._outerLink);
            }, 100, this);
            this.hide();
        }, this, {
            stopEvent: !0
        });
        return this.callParent();
    },
    initComponent: function() {
        this.callParent(arguments);
        this.hideTask = new Ext.util.DelayedTask(function() {
            this.hide();
        }, this);
    },
    _onEscKey: function() {
        this.close();
    },
    focus: function() {
        this.callParent(arguments);
        this.hideTask.cancel();
    },
    _onBlur: function() {
        this.hideTask.delay(200);
    },
    close: function() {
        Ext.defer(function() {
            this._htmlEditor.getFocusEl().focus();
        }, 100, this);
        this.callParent(arguments);
    }
});

Ext.define("kerio.wm.utils.TemporaryStorage", {
    constructor: function(e) {
        e = e || {};
        this.data = {};
        this.defaultTimeout = e.timeout || 1e4;
    },
    put: function(e, t, i) {
        var s = kerio.wm.getCurrentDate().getTime();
        this._removeOldRecords();
        i = i ? s + i : s + this.defaultTimeout;
        this.data[e] = {
            value: t,
            timeout: i
        };
        if (!this.nextTimeout || i < this.nextTimeout) {
            this.nextTimeout = i;
        }
    },
    get: function(e) {
        var t = kerio.wm.getCurrentDate().getTime(), i = this.data[e];
        if (i) {
            if (i.timeout < t) {
                delete this.data[e];
                return;
            } else {
                return i.value;
            }
        } else {
            return;
        }
    },
    _removeOldRecords: function() {
        var e, t, i = kerio.wm.getCurrentDate().getTime(), s = [];
        if (this.nextTimeout && this.nextTimeout < i) {
            delete this.nextTimeout;
            for (t in this.data) {
                if (this.data.hasOwnProperty(t)) {
                    if (this.data[t].timeout < i) {
                        s.push(t);
                    } else {
                        if (!e || this.data[t].timeout < e) {
                            e = this.data[t].timeout;
                        }
                    }
                }
            }
            for (t = 0; t < s.length; t++) {
                delete this.data[s[t]];
            }
            if (e) {
                this.nextTimeout = e;
            }
        }
    }
});

Ext.define("kerio.wm.proxy.Mapping", {
    setFieldValue: function(e, t, i) {
        var s, n, o, r;
        if (!Ext.Array.contains(t, ".")) {
            if (void 0 === i) {
                delete e[t];
            } else {
                e[t] = i;
            }
        } else {
            n = t.split(".");
            s = e;
            for (o = 0; o < n.length - 1; o++) {
                r = n[o];
                if (void 0 === s[r] || "object" != typeof s[r]) {
                    if (void 0 === i) {
                        return;
                    }
                    s[r] = {};
                }
                s = s[r];
            }
            if (void 0 === i) {
                delete s[n[n.length - 1]];
            } else {
                s[n[n.length - 1]] = i;
            }
        }
    },
    getFieldValue: function(e, t) {
        if (!Ext.Array.contains(t, ".")) {
            return e[t];
        } else {
            var i, s = t.split("."), n = e;
            for (i = 0; i < s.length; i++) {
                n = n[s[i]];
                if (void 0 === n) {
                    return n;
                }
            }
            return n;
        }
    },
    applyFieldMapping: function(e, t) {
        if (void 0 === e) {
            return;
        }
        var i, s, n;
        for (n in e) {
            if (e.hasOwnProperty(n)) {
                i = e[n];
                s = Ext.Array.indexOf(n, "#");
                if (-1 !== s) {
                    n = n.substring(0, s);
                }
                if (void 0 === i) {
                    this.setFieldValue(t, n, void 0);
                } else {
                    if ("function" == typeof i) {
                        this.setFieldValue(t, n, i.call(this, this.getFieldValue(t, n)));
                    } else {
                        this.setFieldValue(t, n, this.getFieldValue(t, i));
                    }
                }
            }
        }
    },
    applyMappingOnRecords: function(e, t, i) {
        if (i !== !0 && (void 0 === e || e === kerio.wm.Constants.EMPTY_OBJECT)) {
            return t;
        }
        var s, n, o, r, a = [], l = e && "function" == typeof e;
        for (s = 0; s < t.length; s++) {
            if (i === !0) {
                n = Ext.clone(t[s]);
            } else {
                n = t[s];
            }
            if (l) {
                o = e.call(this, n);
                if (o) {
                    if (o instanceof Array) {
                        for (r = 0; r < o.length; r++) {
                            a.push(o[r]);
                        }
                    } else {
                        a.push(o);
                    }
                }
            } else {
                if (e) {
                    this.applyFieldMapping(e, n);
                    a.push(n);
                } else {
                    a.push(n);
                }
            }
        }
        return a;
    }
});

Ext.define("kerio.wm.utils.HttpsDetector", {
    isUsedHttps: function() {
        var e = 0 === kerio.api.settings.HOST_NAME.indexOf("https");
        return Ext.isSecure && (!kerio.api.settings.HOST_NAME || e);
    },
    isHttpsSupported: function() {
        return !!kerio.wm.Constants.IS_RUNNING_HTTPS;
    },
    useHttps: function() {
        return this.isUsedHttps() || !this.isHttpsSupported();
    },
    _switchSecureConnection: function(e) {
        var t = window.location, i = "https://";
        if (kerio.wm.isInWindow) {
            try {
                window.name = "";
                delete window.opener;
            } catch (s) {}
        }
        if (/\/webmail2\//gi.test(t.pathname)) {
            i += t.hostname + t.pathname;
        } else {
            i += t.hostname + "/webmail/login/";
        }
        i += e || "#settings";
        kerio.wm.utils.ChangeDistributor.killRunningRequest(function() {
            window.location.href = this.loginUrl;
        }, {
            loginUrl: i
        });
    }
});

Ext.define("kerio.wm.utils.GlobalKeyMap", {
    extend: "Ext.util.KeyMap",
    constructor: function(e, t) {
        if (Ext.isArray(t)) {
            var i;
            for (i = 0; i < t.length; i++) {
                t[i].fn = this._wrapCallbackFn(t[i].fn, t[i].scope, e);
            }
        } else {
            t.fn = this._wrapCallbackFn(t.fn, t.scope, e);
        }
        this.callParent([ Ext.getBody(), t ]);
    },
    _wrapCallbackFn: function(e, t, i) {
        return function(s, n) {
            var o = n.target, r = i.dom;
            while (o && o !== r) {
                o = o.parentNode;
            }
            if (o) {
                e.call(t || this, s, n);
            }
        };
    }
});

Ext.define("kerio.wm.view.LinkEditor", {
    extend: "kerio.wm.view.FloatingPanel",
    requires: [ "kerio.wm.view.WebmailButton" ],
    cls: "linkEditor",
    styles: !0,
    layout: {
        type: "hbox",
        align: "stretchmax"
    },
    width: 350,
    autoHide: !0,
    closeAction: "hide",
    disablePositionAdjusting: !0,
    constructor: function() {
        this.handleKeys = [ Ext.EventObject.ENTER, Ext.EventObject.ESC ];
        this.items = [ {
            xtype: "triggerfield",
            itemId: "linkHref",
            cls: "linkHref",
            focusCls: "",
            flex: 1,
            emptyText: k_tr("Enter link location", "mail"),
            tooltip: k_tr("Enter link location", "mail"),
            onTriggerClick: Ext.bind(this._onTriggerClick, this)
        }, {
            xtype: "webmailbutton",
            itemId: "btnLinkOk",
            isDefault: !0,
            cls: "btnLinkOk",
            minWidth: 65,
            text: k_tr("OK", "common")
        } ];
        this.addEvents({
            insertLink: !0,
            removeLink: !0
        });
        this.callParent(arguments);
    },
    initComponent: function() {
        this.callParent(arguments);
        this._linkHrefField = this.down("#linkHref");
        this._linkHrefField.on("blur", this._onBlur, this);
        this._linkHrefField.on("change", this._onChange, this);
        this.hideTask = new Ext.util.DelayedTask(function() {
            this.hide();
        }, this);
        this.query("#btnLinkOk")[0].on("click", this._onConfirmLink, this);
        this.on("afterrender", this._onAfterRender, this);
    },
    _onEscKey: function() {
        this._cancelEditing();
    },
    focus: function() {
        this.callParent(arguments);
        this.hideTask.cancel();
    },
    _onBlur: function() {},
    _onConfirmLink: function() {
        var e = this._linkHrefField.getValue();
        e = encodeURI(e);
        if ("" === e && !this._removeClicked) {
            this.close();
            return;
        }
        if (this._removeClicked) {
            this.fireEvent("removeLink", this._params);
        } else {
            this.fireEvent("insertLink", Ext.apply(this._params, {
                href: this._getLinkHref(),
                text: e
            }));
        }
        this.close();
    },
    _cancelEditing: function() {
        this._linkText = "";
        this.close();
    },
    _getLinkHref: function() {
        var e = this._linkHrefField.getValue();
        if (e && 0 !== e.indexOf("mailto:") && kerio.wm.Constants.URL_PREFIX_REGEXP.test(e) === !1 && "#" !== e[0]) {
            e = kerio.wm.Constants.URL_PREFIX + e;
        }
        return e;
    },
    _onTriggerClick: function() {
        this._linkHrefField.setValue("");
        this._linkHrefField.focus();
        this._removeClicked = !0;
        this._setEmptyText(kerio.lib.k_tr("Enter link location", "mail"));
    },
    setParams: function(e) {
        this._multiEdit = e.multiEdit || !1;
        var t = e.multiEdit ? kerio.lib.k_tr("Multiple links", "mail") : kerio.lib.k_tr("Enter link location", "mail");
        this._setEmptyText(t);
        this._linkText = e.text || "";
        this._params = e;
    },
    _setEmptyText: function(e) {
        if (e !== this._linkHrefField.emptyText) {
            this._linkHrefField.emptyText = e;
            this._linkHrefField.applyEmptyText();
        }
        if (Ext.isIE || Ext.isIE11) {
            if (this.inputEl) {
                this._linkHrefField.inputEl.dom.title = e;
            } else {
                this._inputTooltip = e;
            }
        }
    },
    show: function() {
        this._removeClicked = !1;
        this._linkText = this._linkText || "";
        this._linkHrefField.setValue(this._linkText);
        this.callParent(arguments);
        this._linkHrefField.focus();
        this._linkHrefField.selectText();
        this._updateTriggerVisibility();
    },
    _updateTriggerVisibility: function() {
        var e = this._linkHrefField.triggerEl.elements[0], t = "" !== this._linkHrefField.getValue() || this._multiEdit, i = k_tr("Remove [link|links]", "mail", {
            k_pluralityBy: this._multiEdit ? 2 : 1
        });
        if (t) {
            e.replaceCls("removeBtnHidden", "removeBtn");
        } else {
            e.replaceCls("removeBtn", "removeBtnHidden");
        }
        if (e.dom.title !== i) {
            e.dom.title = i;
        }
    },
    _onChange: function() {
        this._updateTriggerVisibility();
    },
    _onAfterRender: function() {
        if (this._inputTooltip) {
            this._linkHrefField.inputEl.dom.title = this._inputTooltip;
        }
        this.updateHeader();
        this._updateTriggerVisibility();
    }
});

Ext.define("kerio.wm.utils.TextSelection", {
    singleton: !0,
    _rectMethods: {
        add: function(e, t) {
            this.x += e;
            this.y += t;
            this.left += e;
            this.right += e;
            this.top += t;
            this.bottom += t;
        },
        setSize: function(e, t) {
            e = void 0 === e ? this.width : e;
            t = void 0 === t ? this.height : t;
            this.right = this.left + e;
            this.bottom = this.top + t;
            this.width = e;
            this.height = t;
        },
        getSize: function() {
            return {
                width: this.width,
                height: this.height
            };
        }
    },
    getSelectedText: function() {
        if (window.document.selection) {
            return function(e) {
                e = e || window.document;
                return e.selection.createRange().text;
            };
        }
        return function(e) {
            e = e || window.document;
            var t = e.getSelection();
            if (!t.rangeCount) {
                return "";
            }
            return t.getRangeAt(0).toString();
        };
    }(),
    getRangeClientRect: function() {
        if (window.document.selection) {
            return function(e) {
                e = e || window.document;
                var t = e.selection.createRange();
                return Ext.apply({
                    left: t.boundingLeft,
                    top: t.boundingTop,
                    x: t.boundingLeft,
                    y: t.boundingTop,
                    right: t.boundingWidth + t.boundingLeft,
                    width: t.boundingWidth,
                    height: t.boundingHeight
                }, this._rectMethods);
            };
        }
        return function(e, t) {
            e = e || window.document;
            var i, s, n, o = e.getSelection();
            if (!o.rangeCount) {
                return null;
            }
            i = o.getRangeAt(0).getClientRects();
            if (!i.length) {
                s = o.anchorNode;
                if (!t && s) {
                    n = e.createRange();
                    n.selectNode(s);
                    i = n.getClientRects();
                }
                if (!i.length) {
                    return null;
                }
            }
            i = i.item(0);
            return Ext.apply({
                x: i.left,
                y: i.top,
                left: i.left,
                right: i.right,
                top: i.top,
                bottom: i.bottom,
                width: i.right - i.left,
                height: i.bottom - i.top
            }, this._rectMethods);
        };
    }(),
    getSelectedEl: function() {
        if (window.document.getSelection) {
            return function(e) {
                e = e || window.document;
                var t = e.getSelection();
                return t.anchorNode || t.focusNode;
            };
        }
        return function(e) {
            e = e || window.document;
            return e.selection.createRange().parentElement();
        };
    }(),
    selectElement: function() {
        if (window.document.getSelection) {
            return function(e, t) {
                t = t || window.document;
                var i = t.getSelection(), s = t.createRange();
                i.removeAllRanges();
                s.selectNode(e);
                i.addRange(s);
            };
        }
        return function(e, t) {
            t = t || window.document;
            var i = t.body.createTextRange();
            i.moveToElementText(e);
            i.select();
        };
    }(),
    getRectForElement: function(e) {
        var t = e.getBoundingClientRect();
        return Ext.apply({
            x: t.left,
            y: t.top,
            left: t.left,
            right: t.right,
            top: t.top,
            bottom: t.bottom,
            width: t.right - t.left,
            height: t.bottom - t.top
        }, this._rectMethods);
    },
    getSelectedHtml: function(e) {
        if (window.document.getSelection) {
            return function(e) {
                e = e || window.document;
                var t = e.getSelection().getRangeAt(0), i = t.cloneContents(), s = e.createElement("SPAN");
                s.appendChild(i);
                return s.innerHTML;
            };
        }
        return function(e) {
            e = e || window.document;
            return e.selection.createRange().htmlText;
        };
    }()
});

Ext.define("kerio.wm.view.htmlEditor.MenuButton", {
    extend: "kerio.wm.view.WebmailButton",
    alias: "widget.htmleditormenubutton",
    constructor: function(e) {
        e = e || {};
        e.enableToggle = !1;
        e.doNotStealFocus = !1;
        e.hideTrigger = !0;
        this.callParent(arguments);
        this.addCls("menuButton");
        this.menu.addCls("menuButtonMenu withIcons");
        this.menu.on("click", this._onMenuClick, this);
    },
    _onMenuClick: function(e, t) {
        if (t) {
            this.fireEvent("select", t, t.value);
        }
    },
    showMenu: function() {
        this.menu.showBy(this);
    },
    setDefaultItem: function(e) {
        var t;
        t = this.menu.insert(0, Ext.apply({
            xtype: "menucheckitem"
        }, e));
        t.isDefault = !0;
        return t;
    },
    reset: function() {
        var e, t = this.menu.initialConfig.items;
        if (this.menu.items.getAt(0).isDefault) {
            this.menu.items.getAt(0).setChecked(!0);
        } else {
            for (e = 0; e < t.length; e++) {
                if (t[e].checked) {
                    this.setValue(t[e].value);
                    break;
                }
            }
        }
    },
    setValue: function(e) {
        var t, i = this.menu.items, s = !1;
        e = String(e).toLowerCase();
        e = e.replace(/^["']+|["']+$/g, "");
        for (t = 0; t < i.getCount(); t++) {
            if (-1 !== String(i.getAt(t).value).toLowerCase().indexOf(e)) {
                i.getAt(t).setChecked(!0);
                s = !0;
                break;
            }
        }
        if (!s) {
            for (t = 0; t < i.getCount(); t++) {
                if (i.getAt(t).checked) {
                    i.getAt(t).setChecked(!1);
                    break;
                }
            }
        }
    }
});

Ext.define("kerio.wm.view.htmlEditor.HtmlToolbarComboBox", {
    extend: "Ext.form.field.ComboBox",
    alias: "widget.htmlToolbarComboBox",
    componentCls: "x-form-combobox",
    cls: "htmlToolbarComboBox",
    tpl: '<tpl for="."><li role="option" class="x-boundlist-item {cls}">{text}</li></tpl>',
    fieldSubTpl: [ '<div contenteditable="' + (Ext.isIE11 ? "false" : "true") + '" id="{id}" type="{type}" class="{fieldCls} {typeCls} comboBoxField" style="height: 30px" tabindex="-1"></div>', '<div id="{cmpId}-triggerWrap" class="{triggerWrapCls}" role="presentation">', "{triggerEl}", '<div class="{clearCls}" role="presentation"></div>', "</div>" ],
    constructor: function() {
        this.callParent(arguments);
        this.on({
            afterrender: function() {
                this.reset();
                this.el.down(".comboBoxField").on({
                    keydown: function(e) {
                        e.stopEvent();
                    }
                });
            }
        });
        if (Ext.isIE10 || Ext.isIE11 || Ext.isMSEdge) {
            this.on({
                expand: {
                    fn: function() {
                        this.picker.on({
                            beforeitemmousedown: function(e, t, i, s, n) {
                                n.stopEvent();
                            }
                        });
                    },
                    single: !0
                },
                afterrender: function() {
                    this.el.down(".comboBoxField").on({
                        mousedown: function(e) {
                            e.stopEvent();
                        }
                    });
                    this.el.down(".x-form-trigger-wrap").on({
                        mousedown: function(e) {
                            e.stopEvent();
                        }
                    });
                }
            });
        }
    },
    createPicker: function() {
        var e = this.callParent(arguments);
        e.on({
            viewready: function(e) {
                if (0 === e.selModel.getCount()) {
                    this.comboBoxField = this.comboBoxField || this.el.down(".comboBoxField");
                    e.select(e.store.findRecord(this.displayField, this.comboBoxField.getHTML()), !0, !0);
                    e.highlightItem(e.getSelectedNodes()[0]);
                }
            },
            scope: this
        });
        return e;
    },
    setValue: function(e, t) {
        var i, s;
        if (this.el) {
            this.comboBoxField = this.comboBoxField || this.el.down(".comboBoxField");
            if ("string" == typeof e) {
                this.comboBoxField.dom.innerHTML = e;
                s = this.store.findRecord(this.displayField, e);
                i = s && s.get("cls");
                if (i) {
                    this.inputEl.replaceCls(this._lastAddedClass, i);
                    this._lastAddedClass = i;
                } else {
                    this.inputEl.removeCls(this._lastAddedClass);
                }
            } else {
                if ("number" == typeof e) {
                    this.comboBoxField.dom.innerHTML = this.store.findRecord(this.valueField, e).get(this.displayField);
                }
            }
        }
    },
    getErrors: function() {
        return [];
    }
});

Ext.define("kerio.wm.view.file._Button", {
    extend: "kerio.wm.view.WebmailButton",
    childEls: [ "btnEl", "btnWrap", "btnInnerEl", "btnIconEl", "fileInputEl" ],
    inputCls: Ext.baseCSSPrefix + "form-file-input",
    cls: Ext.baseCSSPrefix + "form-file-btn",
    preventDefault: !1,
    getTemplateArgs: function() {
        var e = this.callParent();
        e.inputCls = this.inputCls;
        e.inputName = this.inputName;
        return e;
    },
    afterRender: function() {
        var e = this;
        e.callParent(arguments);
        e.createFileInput();
        e.fileInputEl.dom.multiple = !0;
        e.fileInputEl.on("change", e.fireChange, e);
        this.fileInputEl.dom.title = Ext.isIE11 || Ext.isMSEdge ? "" : " ";
    },
    fireChange: function(e) {
        this.fireEvent("change", this, e, this.fileInputEl.dom.value);
    },
    createFileInput: function() {
        var e = this;
        e.fileInputEl = e.el.createChild({
            name: e.inputName,
            id: e.id + "-fileInputEl",
            cls: e.inputCls,
            tag: "input",
            type: "file",
            size: 1,
            tabIndex: -1,
            accept: this._getAllowedTypes()
        });
        e.fileInputEl.on("change", e.fireChange, e);
    },
    _getAllowedTypes: function() {
        var e, t = "";
        for (e = 0; e < this.allowedMimeTypes.length; e++) {
            t += this.allowedMimeTypes[e] + "|";
        }
        if (t.length > 1) {
            t = t.substring(0, t.length - 1);
        }
        return t;
    },
    reset: function() {
        this.fileInputEl.remove();
        this.createFileInput();
        this.fileInputEl.dom.multiple = !0;
    },
    onEnable: function() {
        this.callParent();
        this.fileInputEl.dom.disabled = !1;
    },
    onDisable: function() {
        this.callParent();
        this.fileInputEl.dom.disabled = !0;
    }
});

Ext.define("kerio.wm.data.MemoryFolderReader", {
    extend: "Ext.data.reader.Json",
    alias: "reader.memoryfolderreader",
    totalProperty: "length",
    root: "list",
    constructor: function(e) {
        this.callParent(arguments);
    },
    _globalLoadCallback: function() {
        if (this._onLoadCallback) {
            this._onLoadCallback.apply(this, arguments);
        }
    },
    readRecords: function(e) {
        var t = this.callParent([ e.list || e ]);
        return t;
    },
    statics: {
        placeTypeFolderOrder: [ "FPlaceMailbox", "FakeIcal", "FakeDelegation", "FPlacePeople", "FPlaceResources", "FPlaceLocations", "FPlacePublic", "FPlaceArchive" ],
        typeFolderOrder: [ "FMail", "FRoot" ],
        subTypeFolderOrder: [ "FSubInbox", "FSubSentItems", "FSubDrafts", "FSubJunkEmail", "FSubDeletedItems", "FSubDefault", "FakeSubType", "FSubNone" ],
        initOrders: function() {
            var e, t = kerio.wm.data.MemoryFolderReader;
            t.subTypeOrder = {};
            for (e = 0; e < t.subTypeFolderOrder.length; e++) {
                t.subTypeOrder[t.subTypeFolderOrder[e]] = e;
            }
            t.typeOrder = {};
            for (e = 0; e < t.typeFolderOrder.length; e++) {
                t.typeOrder[t.typeFolderOrder[e]] = e;
            }
            t.placeTypeOrder = {};
            for (e = 0; e < t.placeTypeFolderOrder.length; e++) {
                t.placeTypeOrder[t.placeTypeFolderOrder[e]] = e;
            }
        },
        sortFunction: function(e, t) {
            var i = kerio.wm.data.MemoryFolderReader;
            if (!i.subTypeOrder) {
                i.initOrders();
            }
            e = e[e.persistenceProperty];
            t = t[t.persistenceProperty];
            if (i.placeTypeOrder[e.placeType] !== i.placeTypeOrder[t.placeType]) {
                return i.placeTypeOrder[e.placeType] - i.placeTypeOrder[t.placeType];
            }
            if (i.typeOrder[e.type] !== i.typeOrder[t.type]) {
                return i.typeOrder[e.type] - i.typeOrder[t.type];
            }
            if (i.subTypeOrder[e.subType] === i.subTypeOrder[t.subType]) {
                return e.name.toUpperCase().localeCompare(t.name.toUpperCase());
            }
            return i.subTypeOrder[e.subType] - i.subTypeOrder[t.subType];
        }
    },
    LastIdx: function() {
        var e;
        e = function(e, t) {
            this.idx = e;
            this.prev = t;
            if (this.prev) {
                this.prevIdx = this.prev.idx;
            }
        };
        e.prototype.refreshCounters = function() {
            if (this.prev) {
                this.prev.refreshCounters();
                this.idx += this.prev.idx - this.prevIdx;
                this.prevIdx = this.prev.idx;
            }
        };
        return e;
    }(),
    filterRecords: function(e, t, i, s) {
        var n, o, r, a = {};
        a[t] = !0;
        if (s) {
            a.FRoot = !0;
        }
        for (n = 0; n < e.length; n++) {
            o = e[n];
            if (i) {
                if ("FSubDeletedItems" === o.subType) {
                    r = o.nestingLevel;
                } else {
                    if (r && o.nestingLevel <= r) {
                        r = !1;
                    }
                }
            }
            if (!r && a[o.type]) {
                o.leaf = !1;
                o.loaded = !0;
            } else {
                e.splice(n, 1);
                n--;
            }
        }
    },
    sortChildNodes: function(e) {
        var t, i, s;
        if (!(e && e.childNodes.length > 0)) {
            return;
        }
        s = e.childNodes;
        if ("PEOPLE" === e.internalId) {
            s.sort(kerio.wm.data.CalendarTreeReader.sortFunction);
        } else {
            s.sort(kerio.wm.data.MemoryFolderReader.sortFunction);
        }
        i = s[s.length - 1];
        if (i && e.lastChild !== i) {
            e.setLastChild(i);
        }
        for (t = 0; t < s.length; t++) {
            if (s[t].childNodes) {
                this.sortChildNodes(s[t]);
            }
        }
    },
    read: function(e) {
        if (Ext.isArray(e)) {
            return this.callParent(arguments);
        }
        var t, i, s, n, o, r = {};
        if (this.beforeCreateRecords) {
            this.beforeCreateRecords(e.list);
        }
        o = this.callParent(arguments);
        if (!o || 0 === o.records.length) {
            return o;
        }
        i = o.records;
        i[0].root = !0;
        if (this.applyOnRecords) {
            this.applyOnRecords(i);
        }
        for (t = 0; t < i.length; t++) {
            s = i[t];
            n = r[s.raw.nestingLevel - 1];
            if (n) {
                n.childNodes = n.childNodes || [];
                if (n.root) {
                    n.childNodes.push(s);
                } else {
                    if ("FMail" === s.get("type")) {
                        if ("FakeSubType" !== n.get("subType") && "FSubNone" !== n.get("subType")) {
                            s.set("subType", n.data.subType);
                        }
                    }
                    n.appendChild(s, !0, !0);
                }
            }
            r[s.raw.nestingLevel] = s;
        }
        this.sortChildNodes(i[0]);
        o.records = i[0].childNodes;
        o.count = o.records.length;
        o.total = o.count;
        o.totalRecords = o.count;
        return o;
    },
    _isMyDefaultFolder: function(e) {
        return "FPlaceMailbox" === e.placeType && "FSubDefault" === e.subType;
    },
    _isPeopleFolder: function(e) {
        return "FPlacePeople" === e.placeType;
    },
    _isResouceFolder: function(e) {
        var t = e.placeType;
        return "FPlaceResources" === t || "FPlaceLocations" === t;
    },
    _isPublicFolder: function(e) {
        return "FPlacePublic" === e.placeType;
    },
    _isMyNonDefaultFolder: function(e) {
        return "FPlaceMailbox" === e.placeType && "FSubDefault" !== e.subType;
    },
    _isMyFolder: function(e) {
        return "FPlaceMailbox" === e.placeType;
    },
    _isSharedFolder: function(e) {
        return this._isResouceFolder(e) || this._isPeopleFolder(e);
    },
    _isArchiveFolder: function(e) {
        return "FPlaceArchive" === e.placeType;
    },
    _isRootFolder: function(e) {
        return "FRoot" === e.type;
    },
    _createFakeFolder: function(e, t, i, s, n) {
        var o = {
            id: e,
            allowDrag: !1,
            leaf: !1,
            loaded: !0,
            expanded: !0,
            name: t,
            type: i.type,
            access: !Ext.isEmpty(s) ? s : "FAccessAdmin",
            subType: "FakeSubType",
            placeType: n || i.placeType,
            nestingLevel: 1,
            expandable: "FMail" === i.type
        };
        if (i.rootId) {
            o.fakeParentId = i.rootId;
        }
        return o;
    }
});

Ext.define("kerio.wm.store.SubscribedFoldersLoader", {
    allMailboxes: void 0,
    subscribedMailboxes: void 0,
    _modeLoadSubscribedOnly: void 0,
    constructor: function(e) {
        this.store = e.store;
    },
    loadSharedFolders: function(e) {
        this._modeLoadSubscribedOnly = !0;
        kerio.api.Folders.getSubscribed({
            originalSettings: e
        }).then(this._onSubscribedMailboxesLoad.bind(this))["catch"](this._onLoadingFailed.bind(this));
    },
    _onLoadingFailed: function(e) {
        var t = e.settings.originalSettings;
        kerio.wm.view.Msg.showServerError(k_tr("Failed to load shared folders", "folders"));
        this._subscribedFoldersCache = [];
        Ext.callback(t.success || t.callback, t.scope, [ this._subscribedFoldersCache, t ]);
    },
    _onSubscribedMailboxesLoad: function(e) {
        var t = e.result.list, i = e.settings;
        this.subscribedMailboxes = t;
        this._loadMailboxesFromOtherServers(this.subscribedMailboxes, i.originalSettings);
    },
    _onSharedFoldersLoaded: function(e, t) {
        var i, s, n = this.store.model, o = [], r = [];
        this._allSubscribedMailboxes = e;
        for (i = 0; i < e.length; i++) {
            this._processMailbox(o, e[i], e[i].subscribedFolderIds);
        }
        for (i = 0; i < o.length; i++) {
            s = new n(o[i], o[i].id, o[i]);
            r.push(s);
        }
        this._subscribedFoldersCache = r;
        this._loaded = !0;
        Ext.callback(t.callback || t.success, t.scope, [ o, t ]);
    },
    _loadMailboxesFromOtherServers: function(e, t) {
        var i, s = 0;
        for (i = 0; i < e.length; i++) {
            if (!e[i].isLoaded) {
                s++;
            }
        }
        this._totalMailboxesToBeLoaded = s;
        this._mailboxesLoadedCount = 0;
        if (0 === this._totalMailboxesToBeLoaded) {
            this._onSharedFoldersLoaded(e, t);
            return;
        }
        for (i = 0; i < e.length; i++) {
            if (!e[i].isLoaded) {
                this._loadMailbox(e[i], t);
            }
        }
    },
    _loadMailbox: function(e, t) {
        kerio.api.Folders.getShared({
            mailboxId: e.mailboxId
        }, {
            success: this._onLoadMailboxSucces,
            failure: this._onLoadMailboxFailed,
            scope: this,
            mailbox: e,
            originalSettings: t
        });
    },
    _onMailboxLoaded: function(e, t, i) {
        t.folders = e;
        this._mailboxesLoadedCount++;
        if (this._mailboxesLoadedCount === this._totalMailboxesToBeLoaded) {
            delete this._getSharedErrorDisplayed;
            this._onSharedFoldersLoaded(this.subscribedMailboxes, i);
        }
    },
    _onLoadMailboxSucces: function(e, t) {
        this._onMailboxLoaded(e.list, t.settings.mailbox, t.settings.originalSettings);
    },
    _onLoadMailboxFailed: function(e, t) {
        t.response.stopErrorProcessing();
        if (!this._getSharedErrorDisplayed) {
            this._getSharedErrorDisplayed = !0;
            kerio.wm.view.Msg.showServerError(k_tr("Failed to load shared folders", "folders"));
        }
        this._onMailboxLoaded([], t.settings.mailbox, t.settings.originalSettings);
    },
    _processMailbox: function(e, t, i) {
        var s, n;
        for (s = 0; s < t.folders.length; s++) {
            n = t.folders[s];
            n.nestingLevel++;
            n.isSubscribed = Ext.Array.contains(i, n.id);
            e.push(n);
        }
    },
    getAllFlatFolderList: function() {
        var e, t, i, s, n = Ext.clone(this.allMailboxes);
        s = [];
        for (e = 0; e < n.length; e++) {
            i = n[e];
            for (t = 0; t < i.folders.length; t++) {
                s.push(i.folders[t]);
            }
        }
        return s;
    },
    getSubscribedFolders: function() {
        return this._subscribedFoldersCache;
    },
    _loadPartialMailboxes: function(e) {
        if (e.forceLoad) {
            delete this.partialMailboxes;
        }
        if (this.partialMailboxes) {
            Ext.defer(e.callback, 1, e.scope, [ this.partialMailboxes, e ]);
            return;
        }
        kerio.api.Folders.getSharedMailboxList({
            originalSettings: e
        }).then(function(e) {
            var t = e.settings.originalSettings;
            this.partialMailboxes = e.result.mailboxes;
            Ext.callback(t.callback, t.scope, [ this.partialMailboxes, t ]);
        }.bind(this))["catch"](this._onLoadingFailed.bind(this));
    },
    loadSharedMailboxes: function(e) {
        this._modeLoadSubscribedOnly = !1;
        this._loadPartialMailboxes({
            forceLoad: e.forceLoad || !1,
            callback: function(e, t) {
                this._sharedFoldersLoadSettings = t.originalSettings;
                this.allMailboxes = e;
                this._loadMailboxesFromOtherServers(this.allMailboxes, {
                    callback: function(e, t) {
                        var i = t.originalSettings;
                        Ext.callback(i.callback, i.scope, [ Ext.clone(this.allMailboxes), i ]);
                    },
                    scope: this,
                    originalSettings: t.originalSettings,
                    mailboxes: e
                });
            },
            scope: this,
            originalSettings: e
        });
    }
});

Ext.define("kerio.wm.view.mail.mailAddressField.Item", {
    extend: "Ext.container.Container",
    layout: "table",
    columns: 2,
    baseCls: "mailitempanel",
    selectedCls: "selected",
    valid: !0,
    _hasCertCls: "hasValidCertificate",
    _hasNotCertCls: "hasNotCertificate",
    constructor: function(e) {
        var t = Boolean(e.hasValidCertificate);
        delete e.hasValidCertificate;
        this.cursorField = Ext.create("Ext.form.Text", {
            xtype: "textfield",
            name: e.name,
            allowBlank: !0,
            width: 3,
            fieldCls: "mailaddressfield-text",
            enableKeyEvents: !0,
            isFormField: !1
        });
        this._redirectEvents([ "keydown", "focus", "blur" ], e, this.cursorField);
        this.cursorField.on({
            keyup: this.textKeyPrevent,
            keypress: this.textKeyPrevent,
            scope: this
        });
        this.labelField = Ext.create("Ext.form.Label", {
            html: e.fieldText,
            baseCls: "mailaddressfield-label"
        });
        this.labelField.on("afterrender", function(e) {
            var t = Ext.fly(document.createElement("span"));
            t.addCls("removeBtn");
            t.dom.title = k_tr("Remove", "mail");
            e.el.appendChild(t);
        }, this);
        this.callParent(arguments);
        this.valid = e.valid !== !1;
        this.sethasValidCertificate(t);
        this.add(this.cursorField);
        this.add(this.labelField);
        if (!this.valid) {
            this.addCls("invalid");
        }
    },
    destroy: function() {
        if (this.tip && this.tip.isVisible()) {
            this.tip.hide();
        }
        this.callParent(arguments);
    },
    getValue: function() {
        return this.fieldValue;
    },
    sethasValidCertificate: function(e, t) {
        var i, s, n = this.fieldValue.address;
        this._hasValidCertificate = e;
        if (e) {
            i = this._hasCertCls;
            s = this._hasNotCertCls;
        } else {
            i = this._hasNotCertCls;
            s = this._hasCertCls;
        }
        this.addCls(i);
        this.removeCls(s);
        if (t) {
            if (n) {
                n += "\n";
            }
            n += e ? k_tr("Certificate is valid", "mail") : k_tr("No valid certificate available", "mail");
            this.el.set({
                "data-tip": n
            });
        }
    },
    hasValidCertificate: function() {
        return this._hasValidCertificate;
    },
    textKeyPrevent: function(e, t, i) {
        t.stopEvent();
    },
    focus: function() {
        this.cursorField.focus.apply(this.cursorField, arguments);
    },
    select: function() {
        this._setSelected(!0);
    },
    unselect: function() {
        this._setSelected(!1);
    },
    isSelected: function() {
        return this._selected;
    },
    _setSelected: function(e) {
        var t = this.getEl(), i = this.selectedCls;
        if (t) {
            this._selected = e;
            if (e && !t.hasCls(i)) {
                this.getEl().addCls(i);
            } else {
                if (!e && t.hasCls(i)) {
                    this.getEl().removeCls(i);
                }
            }
        }
    },
    _redirectEvents: function(e, t, i) {
        var s, n;
        for (s = 0; s < e.length; s++) {
            n = e[s];
            this._redirectEvent(n, t, i);
        }
    },
    _redirectEvent: function(e, t, i) {
        var s, n = this;
        if (t.listeners[e]) {
            s = t.listeners[e];
            delete t.listeners[e];
            if (t.listeners.scope) {
                n = t.listeners.scope;
            }
            i.on(e, s, n);
        }
    }
});

Ext.define("kerio.wm.view.mail.MailAddressInputDrag", {
    extend: "Ext.dd.DragZone",
    requires: [ "Ext.DomHelper", "Ext.Element" ],
    constructor: function(e) {
        Ext.apply(this, e);
        this.callParent([ this.view.el ]);
    },
    afterInvalidDrop: function(e, t, i) {
        if (Ext.isIE || Ext.isIE11) {
            this.view._selectedItemsBeforeDrag = null;
        }
        this.view.unselectAllItems();
        this.view.focus();
        this._allowDragDropIntoIFrames(!1);
    },
    afterValidDrop: function(e, t, i) {
        var s, n, o;
        if (Ext.isIE || Ext.isIE11) {
            s = this.view._selectedItemsBeforeDrag;
            this.view._selectedItemsBeforeDrag = null;
        } else {
            s = this.view.getSelectedItems();
        }
        for (n = 0; n < s.length; n++) {
            o = s[n];
            this.view.remove(o);
            e.view.cloneAndAddItem(o);
        }
        this.view.unselectAllItems();
        e.view.focus();
        this._allowDragDropIntoIFrames(!1);
    },
    onStartDrag: function(e, t) {
        this._allowDragDropIntoIFrames(!0);
    },
    getDragData: function(e) {
        if (this.view.hasSelectedItems()) {
            var t, i, s = this._createDragDropContainer(), n = this.view.getSelectedItems();
            for (t = 0; t < n.length; t++) {
                i = n[t];
                this._appendItemToContainer(s, i);
            }
            this._appendCleanerToContainer(s);
            if (Ext.isIE || Ext.isIE11) {
                this.view._selectedItemsBeforeDrag = n;
            }
            return {
                ddel: s,
                sourceInputId: this.view.id
            };
        }
    },
    _allowDragDropIntoIFrames: function(e) {
        var t, i, s, n;
        t = document.getElementsByTagName("iframe");
        n = t.length;
        for (s = 0; n > s; s++) {
            i = Ext.fly(t[s]);
            if (e) {
                if (!i.hasCls("x-drag-drop-fix")) {
                    i.addCls("x-drag-drop-fix");
                }
            } else {
                if (i.hasCls("x-drag-drop-fix")) {
                    i.removeCls("x-drag-drop-fix");
                }
            }
        }
    },
    _createDragDropContainer: function() {
        return Ext.DomHelper.createDom({
            tag: "div",
            id: Ext.id(),
            style: "max-width: 400px"
        });
    },
    _appendItemToContainer: function(e, t) {
        var i = t.labelField.getEl();
        i = i.dom.cloneNode(!0);
        i.id = Ext.id();
        i = Ext.create("Ext.Element", i);
        i.setStyle("float", "left");
        e.appendChild(i.dom);
    },
    _appendCleanerToContainer: function(e) {
        e.appendChild(Ext.DomHelper.createDom({
            tag: "div",
            style: "clear: both"
        }));
    }
});

Ext.define("kerio.wm.view.mail.MailAddressInputDrop", {
    extend: "Ext.dd.DropZone",
    constructor: function(e) {
        Ext.apply(this, e);
        this.callParent([ this.view.el ]);
    },
    getTargetFromEvent: function(e) {
        var t = this.view.el;
        return t;
    },
    onNodeEnter: function(e, t, i, s) {
        Ext.fly(e).addCls("prepared-for-drop");
    },
    onNodeOut: function(e, t, i, s) {
        Ext.fly(e).removeCls([ "prepared-for-drop", "not-allowed" ]);
    },
    onNodeOver: function(e, t, i, s) {
        var n, o;
        n = Ext.dd.DropZone.prototype.dropAllowed;
        if (e.id === s.sourceInputId) {
            o = Ext.fly(e);
            if (!o.hasCls("not-allowed")) {
                o.addCls("not-allowed");
            }
            n = Ext.dd.DropZone.prototype.dropNotAllowed;
        }
        return n;
    },
    onNodeDrop: function(e, t, i, s) {
        return e.id !== s.sourceInputId;
    }
});

Ext.define("kerio.wm.view.HiddenSelectionField", {
    extend: "Ext.form.Text",
    singleton: !0,
    name: "hiddenSelection",
    allowBlank: !0,
    width: 20,
    fieldCls: "hiddenselectionfield",
    enableKeyEvents: !0,
    isFormField: !1,
    tabIndex: -1,
    styles: !0,
    listeners: {
        blur: function(e, t) {
            if (!t || !t.insideJob) {
                this._isFocused = !1;
            }
        }
    },
    constructor: function(e) {
        e = e || {};
        this._isFocused = !1;
        this._isRendered = !1;
        this.callParent([ e ]);
    },
    set: function(e, t) {
        if (!this._render()) {
            return;
        }
        if (t !== this._lastListeners) {
            this.fireEvent("blur", this, {
                insideJob: !0
            });
            this._removeLastListeners();
            this._addNewListeners(t);
            if (this._isFocused) {
                this.fireEvent("focus", this);
            }
        }
        this.setValue(e);
        this.selectText();
        if (!this._isFocused) {
            this.focus();
            this._isFocused = !0;
        }
    },
    reset: function() {
        this.fireEvent("blur", this, {
            insideJob: !0
        });
        this._removeLastListeners();
        this.setValue("");
    },
    _removeLastListeners: function() {
        if (this._lastListeners) {
            this.removeListener(this._lastListeners);
            this._lastListeners = null;
        }
    },
    _addNewListeners: function(e) {
        if (e) {
            this._lastListeners = e;
            this.on(e);
        }
    },
    _render: function() {
        var e;
        if (!this._isRendered) {
            e = Ext.getBody();
            if (e) {
                this.render(e);
                this._isRendered = !0;
            }
        }
        return this._isRendered;
    }
});

Ext.define("kerio.wm.utils.Input", {
    singleton: !0,
    getSelectionLength: function(e) {
        if (Ext.isIE) {
            var t = document.selection.createRange().getBookmark(), i = e.dom.createTextRange();
            i.moveToBookmark(t);
            return i.text.length;
        } else {
            return e.dom.selectionEnd - e.dom.selectionStart;
        }
    },
    setCaretPosition: function(e, t) {
        if (e.createTextRange) {
            var i = e.createTextRange();
            i.move("character", t);
            i.select();
        } else {
            if (e.selectionStart) {
                e.focus();
                e.setSelectionRange(t, t);
            } else {
                e.focus();
            }
        }
    },
    getCaretPosition: function(e) {
        if (Ext.isIE) {
            var t, i = document.selection.createRange().getBookmark(), s = e.dom.createTextRange();
            s.moveToBookmark(i);
            t = e.dom.createTextRange();
            t.collapse(!0);
            t.setEndPoint("EndToStart", s);
            return t.text.length;
        } else {
            return e.dom.selectionStart;
        }
    }
});

Ext.define("kerio.wm.utils.ContactsUtils", {
    singleton: !0,
    requires: [ "kerio.wm.Constants" ],
    NUMBER_GROUP: "ꮾ",
    SYMBOL_GROUP: "ꮿ",
    ALPHA_REGEXP: /[a-zA-Z]/,
    SYMBOL_REGEXP: /[\u0020-\u00bf\u00d7\u00f7\u20ac]/,
    constructor: function() {
        this._contactTypes = {};
        this._contactTypes.TypeAssistant = k_tr("Assistant", "contacts");
        this._contactTypes.TypeWorkVoice = k_tr("Work phone", "contacts");
        this._contactTypes.TypeWorkFax = k_tr("Work fax", "contacts");
        this._contactTypes.TypeCallback = k_tr("Callback", "contacts");
        this._contactTypes.TypeCar = k_tr("Car", "contacts");
        this._contactTypes.TypeCompany = k_tr("Company", "contacts");
        this._contactTypes.TypeHomeVoice = k_tr("Home phone", "contacts");
        this._contactTypes.TypeHomeFax = k_tr("Home fax", "contacts");
        this._contactTypes.TypeIsdn = k_tr("ISDN", "contacts");
        this._contactTypes.TypeMobile = k_tr("Mobile", "contacts");
        this._contactTypes.TypeOtherVoice = k_tr("Other", "contacts");
        this._contactTypes.TypeOtherFax = k_tr("Other fax", "contacts");
        this._contactTypes.TypePager = k_tr("Pager", "contacts");
        this._contactTypes.TypePrimary = k_tr("Primary", "contacts");
        this._contactTypes.TypeRadio = k_tr("Radio", "contacts");
        this._contactTypes.TypeTelex = k_tr("Telex", "contacts");
        this._contactTypes.TypeTtyTdd = k_tr("TTY/TDD", "contacts");
        this._contactTypes.TypePager = k_tr("Pager", "contacts");
        this._contactTypes.EmailHome = k_tr("Home email", "contacts");
        this._contactTypes.EmailOther = k_tr("Other email", "contacts");
        this._contactTypes.EmailWork = k_tr("Work email", "contacts");
        this._contactTypes.AddressHome = k_tr("Home address", "contacts");
        this._contactTypes.AddressOther = k_tr("Other address", "contacts");
        this._contactTypes.AddressWork = k_tr("Work address", "contacts");
        this._contactTypes.UrlHome = k_tr("Home web", "contacts");
        this._contactTypes.UrlOther = k_tr("Other web", "contacts");
        this._contactTypes.UrlWork = k_tr("Work web", "contacts");
        this._contactTypes.UrlCustom = k_tr("Web", "contacts");
    },
    getNameByType: function(e) {
        return this._contactTypes[e];
    },
    getTypeByName: function(e) {
        return Ext.Object.getKey(this._contactTypes, e);
    },
    addToModelItemLabelName: function(e, t) {
        var i, s = e.length;
        if (s) {
            for (i = 0; s > i; i++) {
                if (e[i].type === t) {
                    if (e[i].extension.label !== Ext.htmlEncode(e[i].extension.label)) {
                        e[i].labelName = kerio.wm.utils.ContactsUtils.getNameByType(e[i].type);
                    } else {
                        e[i].labelName = e[i].extension.label;
                    }
                } else {
                    e[i].labelName = kerio.wm.utils.ContactsUtils.getNameByType(e[i].type);
                }
            }
        }
        return e;
    },
    removeToModelItemLabelName: function(e) {
        var t, i = e.length;
        if (i) {
            for (t = 0; i > t; t++) {
                delete e[t].labelName;
            }
        }
        return e;
    },
    getUserName: function(e) {
        return e.split("@")[0];
    },
    getFirstName: function(e) {
        var t = Ext.Array.indexOf(e, " ");
        if (t > 0) {
            return e.substring(0, t);
        }
        return "";
    },
    getLastName: function(e) {
        var t = Ext.Array.indexOf(e, " ");
        if (t > 0) {
            return e.substring(t + 1);
        }
        return e;
    },
    getFirstLetterDisplayName: function(e) {
        var t, i = "", s = "", n = this.SYMBOL_GROUP, o = this.NUMBER_GROUP;
        if ("ctDistributionList" === e.type) {
            return k_tr("GROUPS", "contacts");
        }
        t = e.displayName || kerio.wm.utils.ContactsUtils.getDisplayName(e);
        if (e.surName) {
            i = e.surName.trim();
        }
        if (i && i.length > 0) {
            s = i.charAt(0);
        } else {
            if (t && t.length > 0) {
                s = t.charAt(0);
            }
        }
        if (s.match(this.ALPHA_REGEXP)) {
            return s;
        }
        if (Ext.isNumeric(s)) {
            return o;
        }
        if (s.match(this.SYMBOL_REGEXP) || t === k_tr("No name specified", "contacts")) {
            return n;
        }
        return s;
    },
    getDisplayName: function(e) {
        var t, i = [];
        if ("ctDistributionList" === e.type) {
            if (!Ext.isEmpty(e.commonName)) {
                t = e.commonName;
            }
        } else {
            if (e.surName && e.surName.length > 0 || e.firstName && e.firstName.length > 0 || e.middleName && e.middleName.length > 0) {
                if (e.firstName && "" !== e.firstName) {
                    i.push(e.firstName.trim());
                }
                if (e.middleName && "" !== e.middleName) {
                    i.push(e.middleName.trim());
                }
                if (e.surName && "" !== e.surName) {
                    i.push(e.surName.trim());
                }
                t = i.join(" ");
            } else {
                if (e.companyName && e.companyName.length > 0) {
                    t = e.companyName.trim();
                } else {
                    if (e.emailAddresses && e.emailAddresses[0] && e.emailAddresses[0].address) {
                        t = e.emailAddresses[0].address.trim();
                    } else {
                        if (e.nickName) {
                            t = e.nickName.trim();
                        }
                    }
                }
            }
        }
        if (Ext.isEmpty(t)) {
            t = k_tr("No name specified", "contacts");
        }
        return t.trim();
    },
    getCommonName: function(e, t) {
        var i, s, n, o, r, a = [];
        i = Ext.isDefined(e.titleBefore) ? e.titleBefore : t.titleBefore;
        if (i) {
            a.push(i);
        }
        s = Ext.isDefined(e.firstName) ? e.firstName : t.firstName;
        if (s) {
            a.push(s);
        }
        n = Ext.isDefined(e.middleName) ? e.middleName : t.middleName;
        if (n) {
            a.push(n);
        }
        o = Ext.isDefined(e.surName) ? e.surName : t.surName;
        if (o) {
            a.push(o);
        }
        r = Ext.isDefined(e.titleAfter) ? e.titleAfter : t.titleAfter;
        if (r) {
            a.push(r);
        }
        return a.join(" ");
    },
    getAdjustedImageSize: function(e, t, i) {
        var s, n, o;
        if (i > e && i > t || e > i && t > i || e === i || t === i) {
            s = Math.min(e, t);
            if (s === e) {
                n = i;
            }
            if (s === t) {
                o = i;
            }
        } else {
            if (i > e) {
                n = i;
            } else {
                if (i > t) {
                    o = i;
                }
            }
        }
        return {
            width: n,
            height: o
        };
    },
    adjustImageSize: function(e, t) {
        var i;
        if (Ext.isEmpty(e)) {
            return;
        }
        e.removeAllListeners();
        e.setSize(void 0, void 0);
        i = void 0 !== e.dom.complete;
        if (i) {
            if (e.dom.complete) {
                e.removeCls("hidden");
                e.setSize(kerio.wm.utils.ContactsUtils.getAdjustedImageSize(e.getWidth(), e.getHeight(), t));
            } else {
                kerio.wm.utils.ContactsUtils._setOnLoadHandler(e, t);
            }
        } else {
            kerio.wm.utils.ContactsUtils._setOnLoadHandler(e, t);
            e.removeCls("hidden");
            if (e.getWidth() > 0 && e.getHeight() > 0) {
                e.setSize(kerio.wm.utils.ContactsUtils.getAdjustedImageSize(e.getWidth(), e.getHeight(), t));
            }
        }
    },
    _setOnLoadHandler: function(e, t) {
        e.on({
            load: kerio.wm.utils.ContactsUtils._setSizeOnImgLoad,
            scope: {
                imageEl: e,
                requestedSize: t
            }
        });
    },
    _setSizeOnImgLoad: function() {
        var e, t, i = this.imageEl;
        i.removeCls("hidden");
        e = i.getWidth();
        t = i.getHeight();
        if (0 === e || 0 === t) {
            return;
        }
        i.setSize(kerio.wm.utils.ContactsUtils.getAdjustedImageSize(e, t, this.requestedSize));
    },
    isAddressEmpty: function(e) {
        return Ext.isEmpty(e.street) && Ext.isEmpty(e.locality) && Ext.isEmpty(e.state) && Ext.isEmpty(e.zip) && Ext.isEmpty(e.country);
    },
    getOfficeNumber: function(e) {
        var t, i = e.length, s = "";
        for (t = 0; i > t; t++) {
            if ("AddressWork" === e[t].type && !Ext.isEmpty(e[t].extendedAddress)) {
                return e[t].extendedAddress;
            }
        }
        return s;
    },
    allPostalAddressesEmpty: function(e) {
        var t, i = e.length;
        for (t = 0; i > t; t++) {
            if (!kerio.wm.utils.ContactsUtils.isAddressEmpty(e[t])) {
                return !1;
            }
        }
        return !0;
    },
    parseDate: function(e) {
        if (Ext.isEmpty(e)) {
            return "";
        } else {
            if (e instanceof Date) {
                return e;
            } else {
                return Ext.Date.parse(e, "Ymd");
            }
        }
    },
    formatDate: function(e) {
        if (Ext.isEmpty(e)) {
            return e;
        } else {
            return Ext.Date.format(e, "Ymd");
        }
    }
});

Ext.define("kerio.wm.selection.RowSelectionModel", {
    extend: "Ext.selection.RowModel",
    alias: "selection.rowselmodel",
    ignoreRightMouseSelection: !0,
    refresh: function() {
        var e, t, i, s, n = this, o = [], r = n.getSelection(), a = r.length, l = this.getLastFocused(), d = (this.store.currentPage - 1) * this.store.pageSize;
        for (e = 0; a > e; e++) {
            s = r[e];
            if (void 0 === i && this.isRecordInStoreFolder(s.get("folderId")) && this.isRecordOnCurrentPage(s)) {
                i = s.index - d;
            }
            s = this._findInStoreData(s);
            if (!this.pruneRemoved && s) {
                o.push(s);
            }
        }
        n.clearSelections();
        if (l) {
            l = this._findInStoreData(l);
            if (!l && 0 === o.length && this.autoselect) {
                if (i >= this._storeData().getCount()) {
                    i = this._storeData().getCount() - 1;
                }
                l = this._storeData().getAt(i || 0);
            }
            if (l) {
                t = t || 0 === o.length;
                this.setLastFocused(l, !0);
                o.push(l);
            }
        }
        if (0 === o.length && this.autoselect && this.store.getCount() > 0) {
            o.push(this._storeData().getAt(0));
            t = !0;
        }
        t = t || this._isSelectionChanged(r, o);
        if (o.length) {
            n.doSelect(o, !1, !0);
        }
        n.maybeFireSelectionChange(t);
    },
    _isSelectionChanged: function(e, t) {
        var i;
        if (t.length !== e.length) {
            return !0;
        }
        for (i = 0; i < t.length; i++) {
            if (-1 === t.indexOf(e[i])) {
                return !0;
            }
        }
        return !1;
    },
    setSelection: function(e) {
        this.selected.clear();
        this.selected.addAll(e);
    },
    isRecordInStoreFolder: function(e) {
        var t;
        if (this.store && this.store.getFolder && this.store.getFolder()) {
            t = this.store.getFolder().get("id");
        }
        return t === e;
    },
    isRecordOnCurrentPage: function(e) {
        var t = -1 === this.store.pageSize ? 1 : Math.floor(e.index / this.store.pageSize) + 1 || 1;
        return this.store.currentPage === t;
    },
    onStoreAdd: function(e, t) {
        if (this.isLocked()) {
            return;
        }
        if (t && t.length > 0) {
            this.doDeselect(this.getSelection(), !0);
            this.clearSelections();
            this.doSelect(t[0], !1, !0);
        }
    },
    onStoreUpdate: function(e, t) {
        if (this.isLocked()) {
            return;
        }
        if (t && t.length > 0) {
            this.clearSelections();
            this.setLastFocused(t[0]);
        }
    },
    selectRange: function(e, t, i, s) {
        if (this.lastFocused === e && this.rangeCenter && -1 !== this.store.indexOf(this.rangeCenter)) {
            this.callParent([ this.rangeCenter, t, i, s ]);
        } else {
            this.rangeCenter = e.isModel ? e : void 0;
            this.callParent(arguments);
        }
    },
    doMultiSelect: function(e, t, i) {
        if (this.rangeCenter && (!Ext.isArray(e) || -1 === Ext.Array.indexOf(e, this.rangeCenter))) {
            delete this.rangeCenter;
        }
        if (Ext.isArray(e) && this.rangeCenter && this.rangeCenter.index === e[e.length - 1].index) {
            e.reverse();
        }
        this.callParent(arguments);
    },
    _getOnePageIndex: function(e, t) {
        var i, s, n, o, r = this.views[0], a = e > t;
        if (Math.abs(t - e) <= 1) {
            return t;
        }
        s = r.panel && r.panel.verticalScroller;
        if (s && s.getVisibleTop && s.getVisibleBottom) {
            i = r.el.getHeight();
            n = a ? s.getVisibleBottom(e) : s.getVisibleTop(e);
            if (a) {
                for (o = t; e > o; ++o) {
                    if (n - s.getVisibleTop(o) <= i) {
                        break;
                    }
                }
                t = e > o ? o : e - 1;
            } else {
                for (o = t; o > e; --o) {
                    if (s.getVisibleBottom(o) - n <= i) {
                        break;
                    }
                }
                t = o > e ? o : e + 1;
            }
        }
        return t;
    },
    onKeyPageUp: function(e, t) {
        var i, s, n, o, r = this, a = r.getRowsVisible();
        if (a) {
            i = r.lastFocused ? r.store.indexOf(r.lastFocused) : 0;
            s = i - a;
            if (0 > s) {
                s = 0;
            }
            s = this._getOnePageIndex(i, s);
            n = r.store.getAt(s);
            if (e.shiftKey) {
                o = r.store.getAt(i);
                r.selectRange(n, o, e.ctrlKey, "up");
                r.setLastFocused(n);
            } else {
                if (e.ctrlKey) {
                    e.preventDefault();
                    r.setLastFocused(n);
                } else {
                    r.doSelect(n);
                }
            }
        }
    },
    onKeyPageDown: function(e, t) {
        var i, s, n, o, r = this, a = r.getRowsVisible();
        if (a) {
            i = r.lastFocused ? r.store.indexOf(r.lastFocused) : 0;
            s = i + a;
            if (s >= r.store.getCount()) {
                s = r.store.getCount() - 1;
            }
            s = this._getOnePageIndex(i, s);
            n = r.store.getAt(s);
            if (e.shiftKey) {
                o = r.store.getAt(i);
                r.selectRange(n, o, e.ctrlKey, "down");
                r.setLastFocused(n);
            } else {
                if (e.ctrlKey) {
                    e.preventDefault();
                    r.setLastFocused(n);
                } else {
                    r.doSelect(n);
                }
            }
        }
    },
    _storeData: function() {
        return this.store;
    },
    _findInStoreData: function(e) {
        return this.store.data.get(e.getId());
    },
    onStoreRemove: function(e, t, i) {
        if (this.locked) {
            return;
        } else {
            if (this.pruneRemoved) {
                this.callParent(arguments);
            } else {
                this.refresh();
            }
        }
    }
});

Ext.define("kerio.wm.view.mail.addressBook.PagingStoreLoaded", {
    extend: "Ext.data.Store",
    autoLoad: !0,
    pageSize: 50,
    _delegatedFns: [ "clearFilter", "filter", "removeAutocreatedContacts", "getById", "_sorterFn" ],
    constructor: function(e) {
        this._store = e.parentStore;
        this.model = this._store.model;
        delete e.parentStore;
        this.callParent(arguments);
        var t, i;
        for (t = 0; t < this._delegatedFns.length; t++) {
            i = this._delegatedFns[t];
            this[i] = Ext.bind(this._store[i], this._store);
        }
    },
    getDataAll: function() {
        return this._store.data;
    },
    load: function(e) {
        var t, i = this;
        e = e || {};
        Ext.applyIf(e, {
            action: "read",
            filters: i.filters.items,
            sorters: i.getSorters(),
            start: 0,
            limit: this.pageSize
        });
        t = Ext.create("Ext.data.Operation", e);
        if (i.fireEvent("beforeload", i, t) !== !1) {
            i.loading = !0;
            this.operation = t;
            this.options = e;
            if (this._store.isLoading()) {
                this._store.on("load", this._onDataLoaded, this);
            } else {
                Ext.defer(function() {
                    this._onDataLoaded();
                }, 10, this);
            }
        }
    },
    _onDataLoaded: function() {
        var e = this.options, t = this.operation;
        this._store.data.sortBy(this._store._sorterFn);
        t.records = this._loadRange(e, !0);
        t.setSuccessful();
        t.setCompleted();
        this.onProxyLoad(t);
    },
    onProxyLoad: function() {
        this.loading = !1;
        this.callParent(arguments);
    },
    _loadRange: function(e) {
        var t, i, s = {};
        if (this._store.getCount() < e.start) {
            e.currentPage = 1;
            e.start = 0;
            e.limit = this.pageSize;
        }
        t = this._store.data.getRange(e.start, e.start + (e.limit - 1));
        this.currentPage = e.page || this.currentPage;
        this.data.clear();
        for (i = 0; i < t.length; i++) {
            s[t[i].internalId] = t[i];
        }
        this.data.addAll(s);
        return t;
    },
    getTotalCount: function() {
        return this._store.getCount();
    },
    resetPaging: function() {
        this.loadPage(1);
    },
    reloadCurrentPage: function() {
        var e = Math.ceil(this._store.getCount() / this.pageSize);
        e = Math.min(this.currentPage || 1, e);
        this.loadPage(e);
    }
});

Ext.define("kerio.wm.view.mail.addressBook.SearchAddressBook", {
    extend: "Ext.form.field.Text",
    alias: "widget.searchAddressBook",
    fieldSubTpl: [ "<table><tr>", '<td class="searchIcon"><div class="searchIcon"></div></td>', '<td class="searchField"><input class="searchInput x-form-text" /></td>', '<td class="removeBtn hidden"> </td>', "</tr><table>" ].join(""),
    constructor: function() {
        this.callParent(arguments);
    },
    afterRender: function() {
        this.searchIcon = this.el.down(".searchIcon");
        this.searchIcon.on("click", this.focus, this);
        this.inputEl = this.el.down(".searchInput");
        this.field = this.el.down(".searchField");
        this.field.dom.style.width = "430px";
        this.trigger = this.el.down(".removeBtn");
        this.trigger.on("click", this.onTriggerClick, this);
    },
    onTriggerClick: Ext.emptyFn,
    doComponentLayout: Ext.emptyFn,
    setSize: Ext.emptyFn,
    onFocus: Ext.emptyFn,
    focus: function() {
        Ext.defer(function() {
            this.inputEl.focus();
        }, 1, this);
    }
});

Ext.define("kerio.wm.model.GlobalContact", {
    extend: "kerio.wm.model.Model",
    requires: [ "kerio.wm.utils.ContactsUtils" ],
    statics: {
        getEngineValues: function(e, t) {
            var i, s, n, o = [ "id", "folderId", "watermark", "type", "commonName", "firstName", "middleName", "surName", "titleBefore", "titleAfter", "nickName", "phoneNumbers", "emailAddresses", "postalAddresses", "urls", "birthDay", "anniversary", "companyName", "departmentName", "profession", "managerName", "assistantName", "comment", "IMAddress", "photo", "categories", "certSourceId", "isGalContact" ], r = e.fields, a = {};
            for (n = 0; n < o.length; n++) {
                i = r.getByKey(o[n]);
                if (i && !1 !== i.persist) {
                    s = e.get(i.name);
                    if (t && i.defaultValue === s) {
                        continue;
                    }
                    s = Ext.clone(s);
                    a[i.name] = i.deconvert ? i.deconvert(s) : s;
                }
            }
            return a;
        }
    },
    inheritableStatics: {
        FIELD_FIRST_LETTER_SURNAME: "firstLetterSurName",
        FIELD_IS_WRITEABLE: "isWriteable",
        FIELD_DISPLAY_NAME: "displayName"
    },
    fields: [ {
        name: "isFullyLoaded",
        defaultValue: !1,
        persist: !1
    }, {
        name: "isGalContact",
        defaultValue: !1
    }, {
        name: "certSourceId",
        defaultValue: ""
    }, {
        name: "id",
        defaultValue: ""
    }, {
        name: "folderId",
        defaultValue: ""
    }, {
        name: "type",
        defaultValue: "ctContact"
    }, {
        name: "commonName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "firstName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "middleName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "surName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "titleBefore",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "titleAfter",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "nickName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "phoneNumbers",
        defaultValue: [],
        convert: function(e) {
            return kerio.wm.utils.ContactsUtils.addToModelItemLabelName(e, "TypeCustom");
        },
        deconvert: function(e) {
            return kerio.wm.utils.ContactsUtils.removeToModelItemLabelName(e);
        }
    }, {
        name: "emailAddresses",
        defaultValue: [],
        convert: function(e) {
            return kerio.wm.utils.ContactsUtils.addToModelItemLabelName(e, "EmailCustom");
        },
        deconvert: function(e) {
            return kerio.wm.utils.ContactsUtils.removeToModelItemLabelName(e);
        }
    }, {
        name: "postalAddresses",
        defaultValue: [],
        convert: function(e) {
            return kerio.wm.utils.ContactsUtils.addToModelItemLabelName(e, "AddressCustom");
        },
        deconvert: function(e) {
            return kerio.wm.utils.ContactsUtils.removeToModelItemLabelName(e);
        }
    }, {
        name: "urls",
        defaultValue: [],
        convert: function(e) {
            return kerio.wm.utils.ContactsUtils.addToModelItemLabelName(e, "UrlCustom");
        },
        deconvert: function(e) {
            return kerio.wm.utils.ContactsUtils.removeToModelItemLabelName(e);
        }
    }, {
        name: "birthDay",
        defaultValue: "",
        toDisplay: !0,
        convert: function(e) {
            return kerio.wm.utils.ContactsUtils.parseDate(e);
        },
        deconvert: function(e) {
            return kerio.wm.utils.ContactsUtils.formatDate(e);
        }
    }, {
        name: "anniversary",
        defaultValue: "",
        toDisplay: !0,
        convert: function(e) {
            return kerio.wm.utils.ContactsUtils.parseDate(e);
        },
        deconvert: function(e) {
            return kerio.wm.utils.ContactsUtils.formatDate(e);
        }
    }, {
        name: "companyName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "departmentName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "profession",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "managerName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "assistantName",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "comment",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "IMAddress",
        defaultValue: "",
        toDisplay: !0
    }, {
        name: "photo",
        defaultValue: {},
        weakDependencies: !0,
        convert: function(e, t) {
            if (e.url) {
                e.url = kerio.wm.Utils.getPhotoUrl(t.get("id"), e.url);
            }
            return e;
        }
    }, {
        name: "categories",
        persist: !1
    }, {
        name: "searchList",
        defaultValue: [],
        persist: !1
    }, {
        name: "firstLetterSurName",
        persist: !1,
        weakDependencies: !0,
        convert: function(e, t) {
            if (t.k_isContact()) {
                return kerio.wm.utils.ContactsUtils.getFirstLetterDisplayName(t.data).toUpperCase();
            } else {
                return k_tr("CONTACT GROUPS", "contacts");
            }
        }
    }, {
        name: "isWriteable",
        defaultValue: !1,
        persist: !1
    }, {
        name: "displayName",
        toDisplay: !0,
        defaultValue: "",
        persist: !1,
        weakDependencies: !0,
        convert: function(e, t) {
            return kerio.wm.utils.ContactsUtils.getDisplayName(t.data);
        }
    }, {
        name: "officeNumber",
        defaultValue: "",
        persist: !1,
        convert: function(e, t) {
            return kerio.wm.utils.ContactsUtils.getOfficeNumber(t.get("postalAddresses"));
        }
    }, {
        name: "watermark",
        type: "number"
    } ],
    k_getFolderStore: function() {
        return Ext.getStore("contacts.ContactFoldersStore");
    },
    getPreferredEmailAddress: function() {
        var e, t, i = this.get("emailAddresses");
        e = Ext.Array.filter(i, function(e) {
            return e.preferred;
        });
        if (e.length > 0) {
            return e[0];
        } else {
            t = Ext.Array.filter(i, function(e) {
                return "TypeWorkVoice" === e.type;
            });
            if (t.length > 0) {
                return t[0];
            } else {
                if (i.length > 0) {
                    return i[0];
                } else {
                    return {
                        address: ""
                    };
                }
            }
        }
    },
    k_isDistributionList: function() {
        return "ctDistributionList" === this.get("type");
    },
    k_isContact: function() {
        return "ctContact" === this.get("type");
    },
    getFullName: function() {
        var e, t = [];
        e = this.getDisplay("titleBefore");
        if (e && "" !== e) {
            t.push(e);
        }
        e = this.getDisplay("firstName");
        if (e && "" !== e) {
            t.push(e);
        }
        e = this.getDisplay("middleName");
        if (e && "" !== e) {
            t.push(e);
        }
        e = this.getDisplay("surName");
        if (e && "" !== e) {
            t.push(e);
        }
        e = this.getDisplay("titleAfter");
        if (e && "" !== e) {
            t.push(e);
        }
        return t.join(" ");
    },
    load: function(e) {
        if (this.get("isFullyLoaded")) {
            if (e.success) {
                Ext.defer(e.success, 1, e.scope || this, [ this ]);
            }
        } else {
            e.scope = {
                options: {
                    success: e.success,
                    failure: e.failure,
                    scope: e.scope
                },
                me: this
            };
            e.success = this._onLoadSuccess;
            e.failure = this._onLoadFailure;
            kerio.api.Contacts.getById({
                ids: [ this.get("id") ]
            }, e);
        }
    },
    _onLoadSuccess: function(e) {
        this.me.beginEdit();
        this.me.set(Ext.apply(e.getResult()[0], {
            isFullyLoaded: !0
        }));
        this.me.endEdit(!0);
        if (this.options.success) {
            this.options.success.call(this.options.scope || this.me, this.me);
        }
    },
    _onLoadFailure: function(e) {
        if (this.options.failure) {
            this.options.failure.call(this.options.scope || this.me, this.me);
        }
    },
    getEngineValues: function(e) {
        return this.self.getEngineValues(this, e);
    }
});

Ext.define("kerio.wm.view.mail.AbstractCertStoreDialog", {
    extend: "Ext.window.Window",
    require: [ "kerio.wm.utils.CertStoreStatus" ],
    closeAction: "destroy",
    width: 350,
    height: 230,
    modal: !0,
    resizable: !1,
    layout: "anchor",
    defaults: {
        anchor: "0"
    },
    actionButtonText: null,
    constructor: function(e) {
        var t = e.msg, i = e.actionButtonText || this.actionButtonText;
        this.items = this.items || [];
        this.items.unshift({
            xtype: "displayfield",
            itemId: "infoMsg",
            cls: "infoMsg"
        });
        this.buttons = [ {
            xtype: "webmailbutton",
            itemId: "btnAction",
            isDefault: !0,
            text: i
        }, {
            xtype: "webmailbutton",
            itemId: "btnClose",
            isCancel: !0,
            text: k_tr("Cancel", "common")
        } ];
        delete e.msg;
        this.callParent(arguments);
        this.query("#infoMsg")[0].setValue(t);
        this.query("#btnAction")[0].on("click", this._onActionBtnClick, this);
        this.query("#btnClose")[0].on("click", this._onCloseBtnClick, this);
    },
    _onActionBtnClick: function() {
        throw new Error(this.$className + "._onActionBtnClick has to be implemented!");
    },
    _onCloseBtnClick: function() {
        this.close();
    }
});

Ext.define("kerio.wm.view.mail.EncryptedEmailBodyBuilder", {
    extend: "Ext.util.Observable",
    mixins: [ "kerio.wm.utils.HttpsDetector" ],
    styles: !0,
    _messagesType: null,
    statics: {
        MSG_TYPES: {
            INCOMMING_ITEMS: "INCOMMING_ITEMS",
            DELETED_ITEMS: "DELETED_ITEMS",
            SENT_ITEMS: "SENT_ITEMS",
            DRAFTS: "DRAFTS",
            EDIT_AS_NEW: "EDIT_AS_NEW"
        },
        svg: {
            LOCK: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 300 300"><path d="M251.2 112.7h-34.9V81.9c0-38.1-29.5-69.2-65.8-69.2 -36.3 0-65.8 31-65.8 69.2v30.8H49.7c-13.4 0-24.2 10.9-24.2 24.2v128.8c0 13.4 10.9 24.2 24.2 24.2h201.5c13.4 0 24.2-10.9 24.2-24.2V136.9C275.5 123.5 264.6 112.7 251.2 112.7zM102.5 81.9c0-28.3 21.5-51.3 48-51.3 26.4 0 48 23 48 51.3v30.8h-95.9V81.9zM257.1 265.7c0 3.2-2.7 5.8-5.8 5.8H49.7c-3.2 0-5.8-2.7-5.8-5.8V136.9c0-3.2 2.7-5.8 5.8-5.8h201.5c3.2 0 5.8 2.7 5.8 5.8V265.7z"/><path class="st0" d="M150.5 157.7c-15.7 0-28.5 12.8-28.5 28.5 0 9.3 4.5 17.9 11.9 23.2l-3.4 35.7c-0.1 1.5 0.4 3.1 1.4 4.2 1 1.2 2.5 1.8 4.1 1.8h29c1.6 0 3-0.7 4.1-1.8 1-1.2 1.6-2.7 1.4-4.2l-3.4-35.7c7.4-5.3 11.9-13.9 11.9-23.2C179 170.4 166.2 157.7 150.5 157.7zM158.6 201.6c-2 1-3.1 3.2-2.9 5.4l3.2 33h-16.8l3.2-33c0.2-2.2-0.9-4.4-2.9-5.4 -5.7-3-9.3-8.9-9.3-15.4 0-9.6 7.8-17.4 17.4-17.4 9.6 0 17.4 7.8 17.4 17.4C167.9 192.6 164.4 198.5 158.6 201.6z"/></svg>',
            BROKEN_ENVELOPE: '<svg xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 300 300"><path d="M104.2 216.7l5.7-10.2H53.5c-0.9 0-1.9 0-1.9-0.9 -0.9-0.9-0.9-0.9-0.9-1.9V95.4v-0.9l81.2 70c0.3 0.3 0.7 0.5 1 0.8l11.1-20 -4.5-10.4L93.6 96.3c-0.9-0.9-0.9-1.9 0.9-1.9h27.3l-5.8-13.2 9.1-12H53.5c-7.5 0-14 2.8-19.6 7.5 -4.7 4.7-8.4 11.2-8.4 18.7v109.2c0 7.5 2.8 14 8.4 18.7 4.7 4.7 12.1 7.5 19.6 7.5h69L104.2 216.7zM266.1 76.8c-4.7-4.7-12.1-7.5-19.6-7.5h-97.1L139.8 82l5.4 12.4h64c1.9 0 1.9 0.9 0.9 1.9L163 135.2l4.5 10.4 -12.4 22.2c4.6 1.5 9 0 13-3.3l81.2-70v0.9 108.2c0 0.9 0 1.9-0.9 1.9 -0.9 0.9-0.9 0.9-1.9 0.9H133.6l-4.9 8.8 20.1 15.4h97.8c7.5 0 14-2.8 19.6-7.5 4.7-4.7 8.4-11.2 8.4-18.7V95.4C273.6 88 270.8 82.4 266.1 76.8z"/></svg>'
        },
        tr: {
            TIT_MSG_NOT_DISPLAYED: k_tr("Message cannot be displayed", "secureMessages"),
            TIT_MSG_ENCRYPTED: k_tr("Message is encrypted", "secureMessages"),
            BTN_LOGIN_HTTPS: k_tr("Login securely", "secureMessages"),
            BTN_INIT_STORE: k_tr("Initialize certificate store", "secureMessages"),
            BTN_GOTO_STORE: k_tr("Go to certificate store", "secureMessages"),
            BTN_VERIFY: k_tr("Verify", "secureMessages"),
            BTN_DISPLAY: k_tr("Display", "secureMessages"),
            TXT_PRIVATE_KEY_MISSING: k_tr("You don't have a private key to this message. To display this message, import the private key to your certificate store.", "secureMessages")
        }
    },
    constructor: function() {
        this.callParent(arguments);
        this.addEvents("loginsecurelyclick", "gotocertstore", "decryptemail", "initcertstore", "opencertstore", "opencertstoreoldpwd");
    },
    getEncryptedMailInfoBody: function(e, t) {
        this._messagesType = t;
        var i, s, n, o = e.from, r = e.encryptInfo, a = r.result, l = {};
        l.showActionButton = !0;
        n = new Ext.XTemplate('<div class="encodedMailInformation">', '<div class="encMailIcon">{icon}</div>', '<div class="encMailTitle">{title}</div>', '<div class="encMailBodyContainer">', '<div class="encMailBody"><div class="errorMessage">{body}</div></div>', '<tpl if="showActionButton">', '<div class="encMailButtonContainer">', '<button hidefocus="true" role="button" autocomplete="off" class="encodedMail-action-btn" data-fires="{buttonFires}">{buttonText}</button>', "</div>", "</tpl>", "</div>", "</div>", {
            disableFormats: !0
        });
        s = o.name || o.address;
        l.title = this.self.tr.TIT_MSG_NOT_DISPLAYED;
        l.icon = this.self.svg.LOCK;
        if (!this.isUsedHttps()) {
            l.body = this._getNonSecureConnectionMsg(s);
            l.buttonText = this.self.tr.BTN_LOGIN_HTTPS;
            l.buttonFires = "loginsecurelyclick";
        } else {
            if (!kerio.wm.utils.CertStoreStatus.isInitialized()) {
                l.body = this._getUninitializedStoreMsg(s);
                l.buttonText = this.self.tr.BTN_INIT_STORE;
                l.buttonFires = "gotocertstore";
            } else {
                if (kerio.wm.utils.CertStoreStatus.isClosed() || kerio.wm.utils.CertStoreStatus.isFailedToOpen()) {
                    i = kerio.wm.utils.CertStoreStatus.isFailedToOpen();
                    l.body = i ? this._getChangedPwdMsg() : this._getLockedStoreMsg();
                    l.buttonText = i ? this.self.tr.BTN_VERIFY : this.self.tr.BTN_DISPLAY;
                    l.buttonFires = i ? "opencertstoreoldpwd" : "opencertstore";
                } else {
                    if ("DecryptSuccesful" === a) {
                        l.title = this.self.tr.TIT_MSG_ENCRYPTED;
                        l.body = this._getDisplayMessageMsg(s);
                        l.buttonText = this.self.tr.BTN_DISPLAY;
                        l.buttonFires = "decryptemail";
                    } else {
                        if ("DecryptNoKey" === a) {
                            l.body = this.self.tr.TXT_PRIVATE_KEY_MISSING;
                            l.buttonText = this.self.tr.BTN_GOTO_STORE;
                            l.buttonFires = "gotocertstore";
                        } else {
                            l.body = kerio.wm.utils.Utils.translateError(r.error);
                            l.showActionButton = !1;
                            l.icon = this.self.svg.BROKEN_ENVELOPE;
                        }
                    }
                }
            }
        }
        this._messagesType = null;
        return n.apply(l);
    },
    _getNonSecureConnectionMsg: function(e) {
        var t = this.self.MSG_TYPES;
        switch (this._messagesType) {
          case t.INCOMMING_ITEMS:
            return k_tr("%1 has sent you an encrypted message. Use secure HTTPS connection to display the message.", "secureMessages", {
                k_args: [ e ],
                k_isSecure: !0
            });

          case t.DRAFTS:
          case t.SENT_ITEMS:
          case t.DELETED_ITEMS:
            return k_tr("This message is encrypted. Use secure HTTPS connection to display the message.", "secureMessages");

          case t.EDIT_AS_NEW:
            return k_tr("The original message is encrypted. Use secure HTTPS connection to edit the message.", "secureMessages");
        }
    },
    _getLockedStoreMsg: function() {
        var e = this.self.MSG_TYPES;
        switch (this._messagesType) {
          case e.INCOMMING_ITEMS:
            return k_tr("Certificate store is locked. Login to your certificate store to display the message.", "secureMessages");

          case e.DRAFTS:
          case e.SENT_ITEMS:
          case e.DELETED_ITEMS:
            return k_tr("This message is encrypted. Certificate store is locked. Login to your certificate store to display the message.", "secureMessages");

          case e.EDIT_AS_NEW:
            return k_tr("The original message is encrypted. Certificate store is locked. Login to your certificate store to edit the message.", "secureMessages");
        }
    },
    _getChangedPwdMsg: function() {
        return k_tr("After your last login to Kerio Connect Client, you changed your password. To read encrypted messages, you must verify your identity.", "secureMessages");
    },
    _getUninitializedStoreMsg: function(e) {
        var t = this.self.MSG_TYPES;
        switch (this._messagesType) {
          case t.INCOMMING_ITEMS:
            return k_tr("%1 has sent you an encrypted message. To display this encrypted message initialize your certificate store and import an appropriate private key.", "secureMessages", {
                k_args: [ e ],
                k_isSecure: !0
            });

          case t.DRAFTS:
          case t.SENT_ITEMS:
          case t.DELETED_ITEMS:
            return k_tr("This message is encrypted. To display this encrypted message initialize your certificate store and import an appropriate private key.", "secureMessages");

          case t.EDIT_AS_NEW:
            return k_tr("The original message is encrypted. To edit this encrypted message initialize your certificate store and import an appropriate private key.", "secureMessages");
        }
    },
    _getDisplayMessageMsg: function(e) {
        var t = this.self.MSG_TYPES;
        switch (this._messagesType) {
          case t.INCOMMING_ITEMS:
            return k_tr("%1 has sent you an encrypted message.", "secureMessages", {
                k_args: [ e ],
                k_isSecure: !0
            });

          case t.DRAFTS:
          case t.SENT_ITEMS:
          case t.DELETED_ITEMS:
            return k_tr("This message is encrypted.", "secureMessages");

          case t.EDIT_AS_NEW:
            return k_tr("The original message is encrypted.", "secureMessages");
        }
    },
    onEncMailActionButtonClick: function(e) {
        this.fireEvent(e.getAttribute("data-fires"));
    }
});

Ext.define("kerio.wm.view.settings.spam.SpamWhitelistHelper", {
    singleton: !0,
    addSpamRules: function(e, t) {
        this._stashedNewSpamRules = e;
        this._callbackSettings = t;
        this._loadSpamRules();
    },
    saveSettings: function(e, t) {
        e.whiteList = this._insensitiveUniqueArray(e.whiteList);
        kerio.api.Session.setSpamSettings({
            settings: e
        }, t);
    },
    _loadSpamRules: function() {
        kerio.api.Session.getSpamSettings({
            success: this._onSpamRulesLoaded,
            scope: this
        });
    },
    _onSpamRulesLoaded: function(e, t) {
        var i = e.getSettings(), s = this._callbackSettings && this._callbackSettings.autoWhiteList;
        if (!s || i.getAutoupdateWhiteList()) {
            this._spamSettings = i;
            this._saveSpamRules(this._stashedNewSpamRules);
        }
        delete this._stashedNewSpamRules;
    },
    _saveSpamRules: function(e) {
        var t = this._spamSettings.getWhiteList().concat(e), i = this._callbackSettings || {};
        t = this._insensitiveUniqueArray(t);
        this._spamSettings.setWhiteList(t);
        kerio.api.Session.setSpamSettings({
            settings: this._spamSettings
        }, i);
    },
    _insensitiveUniqueArray: function(e) {
        var t, i, s, n = [], o = [], r = e.length;
        for (t = 0; r > t; t++) {
            i = e[t];
            s = i.toLowerCase();
            if (-1 === Ext.Array.indexOf(o, s)) {
                n.push(i);
                o.push(s);
            }
        }
        return n;
    }
});

Ext.define("kerio.wm.view.module.EditorPanel", {
    extend: "Ext.container.Container",
    styles: !0,
    componentCls: "editorPanel",
    toolbar: null,
    form: null,
    layout: {
        type: "vbox",
        align: "stretch",
        pack: "start"
    },
    constructor: function(e) {
        e.items = [ this.toolbar, Ext.apply(this.form, {
            flex: 1
        }) ];
        this.callParent(arguments);
        this.toolbar = this.items.getAt(0);
        this.form = this.items.getAt(1);
        this.form.addCls("editorPanelFormCt");
        this.setData = Ext.Function.createSequence(this.setData, this._focusItem, this);
    },
    onShow: function() {
        this.callParent(arguments);
        this._focusItem();
    },
    _focusItem: function() {
        var e, t, i = Ext.ComponentQuery.query("textfield", this.form), s = i.length;
        for (t = 0; s > t; t++) {
            e = i[t];
            if (!(e instanceof Ext.form.field.File) && e.isVisible(!0) && !e.isDisabled() && e.focus) {
                e.focus(!1, 250);
                break;
            }
        }
    },
    setData: kerio.wm.abstractMethodNotImplemented,
    isChanged: kerio.wm.abstractMethodNotImplemented,
    reset: kerio.wm.abstractMethodNotImplemented
});

Ext.define("kerio.wm.ExtJsTranslations", {
    singleton: !0,
    constructor: function() {
        if (Ext.view.AbstractView) {
            Ext.override(Ext.view.AbstractView, {
                loadingText: k_tr("Getting data for you…", "loadingMask")
            });
        }
    }
});

Ext.define("kerio.wm.StatusNotifier", {
    singleton: !0,
    hiddenOpacity: 0,
    shownOpacity: 1,
    transitionOpacity: .8,
    hiddenYPosition: 0,
    shownYPosition: 50,
    duration: 500,
    transitionDuration: 200,
    easingToHide: "easeIn",
    easingToShow: "easeOut",
    minShowDelay: 2e3,
    maxShowDelay: 15e3,
    showDelayLengthCoef: 50,
    initialPositions: null,
    constructor: function() {
        this.queue = [];
    },
    init: function() {
        this.initialPositions = {
            hiddenY: this.hiddenYPosition,
            shownY: this.shownYPosition
        };
        this.component = Ext.DomHelper.append(Ext.getBody(), {
            tag: "div",
            id: "statusNotifier",
            style: this._getStyles(),
            children: [ {
                tag: "div",
                cls: "statusContent"
            } ]
        }, !0);
        this.component.setDisplayed(!1);
        this._zIndex = this.component.getStyle("z-index");
        this._navigationBar = kerio.wm.isInWindow ? Ext.ComponentQuery.query("moduletoolbar")[0] : Ext.ComponentQuery.query("navigationbar")[0];
        this._navBarZIndex = this._navigationBar.getEl().getStyle("z-index");
        this.contentEl = this.component.query(".statusContent")[0];
        this.shown = !1;
        this.planNextTask = new Ext.util.DelayedTask(this._planNext, this, [ !0 ]);
    },
    _getStyles: function() {
        return "opacity: " + this.hiddenOpacity + "; top: " + this.hiddenYPosition + "px";
    },
    notify: function(e) {
        if (!e) {
            return;
        }
        if (!this.component) {
            kerio.wm.StatusNotifier.init();
        }
        var t = this.hiddenYPosition, i = Ext.ComponentQuery.query("toaster");
        if (i && i.length && 0 !== i[0].getHeight()) {
            i = i[0];
            this.hiddenYPosition = i.getHeight();
            this.shownYPosition = this.initialPositions.shownY + i.getHeight();
        } else {
            this.hiddenYPosition = this.initialPositions.hiddenY;
            this.shownYPosition = this.initialPositions.shownY;
        }
        if (t !== this.hiddenYPosition) {
            this.component.setStyle({
                top: this.hiddenYPosition
            });
            this.component.dom.style.top = this.hiddenYPosition + "px";
        }
        if (0 === this.queue.length && this._shownMessage === e) {
            return;
        } else {
            if (this.queue.length > 0 && this.queue[this.queue.length - 1] === e) {
                return;
            }
        }
        this.queue.unshift(e);
        if (!this.shown) {
            this._show();
            this._planNext(!1);
        }
    },
    _planNext: function(e) {
        var t, i;
        if (0 !== this.queue.length) {
            if (e) {
                this._transition();
            }
            t = this.queue.pop();
            this._shownMessage = t;
            this._setContent(t);
            i = t.length * this.showDelayLengthCoef + this.minShowDelay;
            i = i > this.maxShowDelay ? this.maxShowDelay : i;
            this.planNextTask.delay(i);
        } else {
            this._hide();
        }
    },
    _transition: function() {
        this.component.animate({
            duration: this.transitionDuration,
            keyframes: {
                0: {
                    opacity: this.shownOpacity
                },
                50: {
                    opacity: this.transitionOpacity
                },
                100: {
                    opacity: this.shownOpacity
                }
            }
        });
    },
    _show: function() {
        this.shown = !0;
        this._animateShowHide(this.shownYPosition, this.shownOpacity, this.easingToShow);
    },
    _hide: function() {
        this.shown = !1;
        delete this._shownMessage;
        this._animateShowHide(this.hiddenYPosition, this.hiddenOpacity, this.easingToHide);
    },
    _getElTop: function(e) {
        return e.getTop() + this.hiddenYPosition;
    },
    _animateShowHide: function(e, t, i) {
        var s, n, o, r, a = this.component;
        a.stopAnimation();
        o = this._getElTop(a);
        s = this.shownYPosition - this.hiddenYPosition;
        n = Math.abs(e - o) / s;
        r = n * this.duration;
        a.animate({
            duration: r,
            to: {
                opacity: t,
                top: e
            },
            easing: i,
            listeners: {
                beforeanimate: function() {
                    if (!this.isHide) {
                        this.me.component.setDisplayed(!0);
                        this.me._align();
                        this.me._navigationBar.getEl().setStyle({
                            "z-index": this.me._zIndex + 1
                        });
                        this.me._navigationBar.isZIndexChanged = !0;
                    }
                },
                afteranimate: function() {
                    var e;
                    if (this.isHide) {
                        this.me._navigationBar.getEl().setStyle({
                            "z-index": this.me._navBarZIndex
                        });
                        this.me.component.setDisplayed(!1);
                        delete this.me._navigationBar.isZIndexChanged;
                        e = Ext.ComponentQuery.query("#userMenu")[0];
                        if (e && e.menu && e.menu.defaultZIndex) {
                            e.menu.el.setStyle({
                                "z-index": e.menu.defaultZIndex
                            });
                            delete e.menu.defaultZIndex;
                        }
                    }
                },
                scope: {
                    me: this,
                    isHide: t === this.hiddenOpacity
                }
            }
        });
    },
    _setContent: function(e) {
        this.contentEl.innerHTML = e;
    },
    _align: function() {
        var e = this.component.getWidth(), t = Ext.getBody().getWidth();
        this.component.setLeft(Math.round(t / 2) - Math.round(e / 2));
    }
});

Ext.define("kerio.wm.view.Feedback", {
    singleton: !0,
    _showFeedback: function() {
        kerio.wm.AppInterface.showFeedbackWindow({
            scope: this,
            defaultFn: function() {
                this._k_feedbackWindow = kerio.wm.Locations.openInNewWindow("#feedback", "feedback", "1", {
                    top: 0,
                    left: 0,
                    width: 1024,
                    height: 700,
                    toolbar: !0,
                    location: !0,
                    menubar: !0
                });
                if (this._k_feedbackWindow) {
                    this._k_feedbackWindow.document.write(k_tr("Loading feedback…", "common"));
                    kerio.api.Session.getUserVoiceUrl({
                        success: this._getUserVoiceUrlSuccess,
                        failure: this._getUserVoiceUrlFailure,
                        scope: this
                    });
                }
            }
        });
    },
    showFeedback: function() {
        if (this._k_feedbackWindow && !this._k_feedbackWindow.closed) {
            this._k_feedbackWindow.focus();
            delete this._feedbackRecovery;
            return;
        }
        try {
            this._showFeedback();
        } catch (e) {
            try {
                this._k_feedbackWindow.close();
                this._showFeedback();
            } catch (t) {}
        }
    },
    _getUserVoiceUrlSuccess: function(e) {
        kerio.wm.AppInterface.onUserVoiceUrlSuccess({
            scope: this,
            defaultFn: function(e) {
                try {
                    this._k_feedbackWindow.location.href = e.accessUrl;
                } catch (t) {
                    this._k_feedbackWindow.close();
                }
            },
            args: [ e ]
        });
    },
    _getUserVoiceUrlFailure: function() {
        kerio.wm.AppInterface.onUserVoiceUrlFailure({
            scope: this,
            defaultFn: function() {
                this._k_feedbackWindow.close();
            }
        });
    }
});

Ext.define("kerio.wm.AppUnloadHandler", {
    singleton: !0,
    _defaultUnloadMessage: k_tr("The changes performed in this window have not been saved yet.", "mail"),
    _originalOnBeforeUnloadFn: Ext.emptyFn,
    constructor: function() {
        this._beforeUnloadHandlerFn = Ext.bind(this._onBeforeUnload, this);
        this._originalOnBeforeUnloadFn = window.onbeforeunload || Ext.emptyFn;
        window.onbeforeunload = this._beforeUnloadHandlerFn;
        this._unloadHandlerFn = Ext.bind(this._onUnload, this);
        window.onunload = this._unloadHandlerFn;
        this._listeners = [];
    },
    _correctUsageChecker: function() {
        var e = new Ext.util.DelayedTask();
        e.delay(500, this._correctUsageCheckerTask, this, [ e ]);
    },
    _correctUsageCheckerTask: function(e) {
        if (window.onbeforeunload !== this._beforeUnloadHandlerFn) {}
        if (window.onunload !== this._unloadHandlerFn) {}
        e.delay(5e3);
    },
    addListener: function(e) {
        if (kerio.wm.AppInterface.closeOnUnload()) {
            if (e.onClose) {
                this._listeners.push(e);
            }
        } else {
            if (e.onBeforeUnload) {
                this._listeners.push(e);
            }
        }
    },
    removeListener: function(e) {
        Ext.Array.remove(this._listeners, e);
    },
    _onBeforeUnload: function(e) {
        if (kerio.wm.AppInterface.closeOnUnload()) {
            return this._callListeners("onClose", function(e) {
                return !1;
            }.bind(this));
        } else {
            return this._callListeners("onBeforeUnload", function(t) {
                e = e || window.event;
                e.returnValue = t;
                if (!t) {
                    this._originalOnBeforeUnloadFn();
                }
                return t;
            }.bind(this));
        }
    },
    _callListeners: function(e, t) {
        var i, s, n, o = this._listeners, r = o.length, a = !0;
        for (i = 0; r > i; i++) {
            if (o[i][e]) {
                s = o[i][e]();
                if (s === !1 || "string" == typeof s) {
                    a = !1;
                    n = "string" == typeof s ? s : this._defaultUnloadMessage;
                    break;
                }
            }
        }
        if (a) {
            this._originalOnBeforeUnloadFn();
            return;
        } else {
            return t(n);
        }
    },
    _onUnload: function() {
        var e;
        for (e = this._listeners.length - 1; e >= 0; e--) {
            if (this._listeners[e].onUnload) {
                this._listeners[e].onUnload();
            }
        }
    }
});

Ext.define("kerio.wm.view.notes.NoteListDrag", {
    extend: "Ext.view.DragZone",
    getDragText: function() {
        var e, t, i, s, n, o = this.dragData.records.length;
        if (o > 1) {
            return k_tr("%1 [note|notes]", "notes", {
                k_args: [ o ],
                k_pluralityBy: o
            });
        } else {
            n = this.dragData.records[0].getDisplay("text");
            e = n.split(/\n/);
            i = e.length;
            t = n;
            for (s = 0; i > s; s++) {
                if ("" !== e[s]) {
                    t = e[s];
                    break;
                }
            }
            return t.length < 200 ? t : t.substring(0, 200);
        }
    },
    afterValidDrop: function(e, t, i) {
        if (!this.dragData.copy) {
            var s = this.view.getStore(), n = this.dragData.records;
            s.remove(n, !0);
        }
    }
});

Ext.define("kerio.wm.view.ColorPicker", {
    extend: "Ext.picker.Color",
    alias: "widget.keriocolorpicker",
    styles: !0,
    cls: "kerioColorPicker",
    _getColorEl: function(e) {
        return this.el.down("a.color-" + e);
    },
    select: function(e, t) {
        var i, s = this, n = s.selectedCls, o = s.value;
        e = e.replace("#", "");
        if (!s.rendered) {
            s.value = e;
            return;
        }
        if (e !== o || s.allowReselect) {
            if (s.value) {
                i = s._getColorEl(o);
                if (i) {
                    i.removeCls(n);
                }
            }
            i = s._getColorEl(e);
            if (i) {
                i.addCls(n);
            }
            s.value = e;
            if (t !== !0) {
                s.fireEvent("select", s, e);
            }
        }
    },
    renderTpl: [ '<tpl for="colors">', '<a href="#" class="colorPickerLink color-{.}" hidefocus="on">', '<em class="colorPickerWrap"><span style="background:#{.}; border-color: {[this._getNoteBorder(values)]}" unselectable="on" class="colorPickerColor">&#160;</span></em>', "</a>", "</tpl>", {
        _getNoteBorder: function(e) {
            return kerio.wm.Utils.darkenColor(e, .2);
        }
    } ]
});

Ext.define("kerio.wm.view.AbstractItemListHandler", {
    _relayEvent: function(e, t, i) {
        this.fireEvent(e.type, e, e.getCharCode());
    },
    addRelayListener: function(e, t) {
        var i, s = {
            scope: this
        };
        if (!t || !t.length) {
            t = [ "keydown", "keyup" ];
        }
        for (i = 0; i < t.length; ++i) {
            s[t[i]] = this._relayEvent;
        }
        e.addListener(s);
    }
});

Ext.define("kerio.wm.view.ForeignHtmlDialog", {
    id: "foreignHtmlDialog",
    extend: "Ext.window.Window",
    require: "kerio.wm.utils.OldHTMLFilter",
    styles: !0,
    cls: "foreignHtmlDialog",
    title: k_tr("Unexpected response", "common"),
    iconCls: "title",
    width: 580,
    height: 360,
    layout: "fit",
    modal: !0,
    closable: !0,
    closeAction: "destroy",
    buttons: [ {
        text: k_tr("OK", "common"),
        handler: function() {
            document.location.reload();
        }
    } ],
    constructor: function(e) {
        var t = e.responseText || "";
        this.items = {
            xtype: "container",
            layout: {
                type: "vbox",
                align: "stretch"
            },
            items: [ {
                xtype: "component",
                html: '<div class="infoText">' + k_tr("Kerio Connect Client has received an unexpected response (see the preview below).", "common") + " " + k_tr("It could be caused by a network issue. Kerio Connect Client will be reloaded.", "common") + '<br/><div class="spacer"></div>' + k_tr("Please contact the server administrator if the problem persists.", "common") + "</div>"
            }, {
                xtype: "component",
                flex: 1,
                autoEl: {
                    tag: "div",
                    "class": "content"
                }
            } ]
        };
        this.callParent();
        if ("" === Ext.String.trim(t)) {
            t = this._printResponseHeaders(e);
        }
        this._setContent(e.status, e.statusText, t);
    },
    listeners: {
        resize: function() {
            var e = this.items.items[0], t = e.items.items[0].el.dom, i = t.firstChild.clientHeight;
            if (i !== t.clientHeight) {
                t.style.height = i + "px";
                e.doLayout();
            }
        }
    },
    _printResponseHeaders: function(e) {
        var t, i = e.getAllResponseHeaders(), s = [];
        for (t in i) {
            if (i.hasOwnProperty(t)) {
                s.push(t + ": " + i[t]);
            }
        }
        if (0 === s.length) {
            return "";
        }
        return "<b>Response headers:</b><br>" + s.join("<br>");
    },
    _setContent: function(e, t, i) {
        var s, n, o = /<title>(.*?)<\/title>/i;
        this.show();
        n = this.items.items[0].items.items[1];
        n.el.dom.innerHTML = '<div class="pageTitle"></div>' + kerio.wm.utils.OldHTMLFilter.filterHtml(i, void 0, ".mcnt", "mcnt", !0).html;
        s = n.el.dom.firstChild;
        if (e) {
            s.innerHTML = e + ": " + t;
        }
        if (i.match(o)) {
            if (e) {
                s.appendChild(document.createElement("br"));
            }
            s.appendChild(document.createTextNode(RegExp.$1));
        }
        if (!s.hasChildNodes()) {
            s.style.display = "none";
        }
    }
});

Ext.define("kerio.wm.utils.AggregatedRequest", {
    _counter: 0,
    send: function(e, t) {
        var i, s, n, o, r = "api";
        if (0 !== this._counter) {
            throw new Error("Can't send new requests because there are previous running.");
        }
        this._results = new Array(e.length);
        this._failedIdxs = [];
        this._options = t;
        for (o = 0; o < e.length; o++) {
            i = e[o];
            n = [];
            s = i.apiFnName.split(".");
            if (i.params) {
                n.push(i.params);
            }
            n.push({
                scope: {
                    me: this,
                    request: i,
                    index: o
                },
                success: this._onSuccess,
                failure: this._onFailure
            });
            kerio[r][s[0]][s[1]].apply(kerio[r][s[0]], n);
            this._counter++;
        }
    },
    _onSuccess: function(e, t) {
        this.me._callback(e, null, t, this);
    },
    _onFailure: function(e, t) {
        this.me._callback(null, e, t, this);
    },
    _callback: function(e, t, i, s) {
        var n = this;
        delete s.me;
        n._results[s.index] = {
            result: e || null,
            error: t || null,
            options: i
        };
        if (t) {
            n._failedIdxs.push(s.index);
        }
        this._counter--;
        this._globalCallback();
    },
    _globalCallback: function() {
        var e = this._options[this._failedIdxs.length ? "failure" : "success"];
        if (0 === this._counter && e) {
            e.call(this._options.scope || this, this._results, this._failedIdxs);
        }
    }
});

Ext.define("kerio.wm.lib.toaster.View", {
    extend: "kerio.wm.lib.view.SingleView",
    alias: "widget.toaster",
    styles: !0,
    componentCls: "toaster",
    itemSelector: "div.toastMsg",
    initComponent: function() {
        this.tpl = Ext.create("Ext.XTemplate", [ '<tpl for=".">', '<div class="toastMsg {[this.getCls(values)]}">', '<div class="messageCt">', '<span class="message">{[this.getMessage(values)]}</span>', '<tpl if="this.isButtonDefined(values)">', '<div class="actionButton">{buttonText}</div>', "</tpl>", "</div>", '<tpl if="true==hasDismissBtn">', '<div class="dismissBtn">&times;</div>', "</tpl>", "</div>", "</tpl>", {
            getMessage: function(e) {
                return e.isSecure ? e.msg : Ext.htmlEncode(e.msg);
            },
            getCls: function(e) {
                var t = [ e.type ];
                if (e.icon) {
                    t.push("hasIcon");
                    if (Ext.isString(e.icon)) {
                        t.push(e.icon);
                    } else {
                        t.push("defaultIcon");
                    }
                }
                return t.join(" ");
            },
            isButtonDefined: function(e) {
                return !!e.buttonText;
            }
        } ]);
        this.callParent(arguments);
    },
    setModel: function(e) {
        var t, i = this.getModel();
        if (i && e) {
            if (i.getId() !== e.getId()) {
                t = this.getNode(0);
                var s = function() {
                    var t;
                    this.getEl().setStyle({
                        visibility: "hidden"
                    });
                    this.self.superclass.setModel.call(this, e);
                    t = this.getNode(0);
                    this._setAnimationStyle(t, "animationName", "changeToast");
                    this.getEl().setStyle({
                        visibility: "visible"
                    });
                    Ext.get(t).setHeight("100%");
                };
                if (Ext.isWebKit && "WebkitAnimationName" in document.body.style) {
                    Ext.get(t).on("webkitAnimationEnd", s, this, {
                        single: !0
                    });
                }
                Ext.get(t).on("animationend", s, this, {
                    single: !0
                });
                this._setAnimationStyle(t, "animationName", "changeToastReverse");
                Ext.get(t).setHeight(0);
            }
        } else {
            this.callParent(arguments);
        }
    },
    onItemClick: function(e, t, i, s) {
        if (s.getTarget(".dismissBtn")) {
            this.fireEvent("dismiss", this, e);
        } else {
            if (s.getTarget(".actionButton")) {
                this.fireEvent("actionclick", this, e);
            }
        }
    },
    _setAnimationStyle: function(e, t, i) {
        if (Ext.isWebKit && "WebkitAnimationName" in document.body.style) {
            t = "Webkit" + t.charAt(0).toUpperCase() + t.substr(1);
        }
        e.style[t] = i;
    }
});

Ext.define("kerio.wm.lib.toaster.Model", {
    extend: "kerio.wm.model.Model",
    statics: {
        typeMap: {
            error: 4,
            warning: 2,
            info: 0
        }
    },
    idProperty: "id",
    fields: [ {
        name: "id",
        defaultValue: ""
    }, {
        name: "msg",
        defaultValue: ""
    }, {
        name: "type",
        defaultValue: "info"
    }, {
        name: "groupType",
        defaultValue: 0,
        convert: function(e, t) {
            var i = t.get("type");
            return t.self.typeMap[i];
        }
    }, {
        name: "priority",
        convert: function() {
            return +new Date();
        }
    }, {
        name: "icon",
        defaultValue: !0
    }, {
        name: "hasDismissBtn",
        defaultValue: !0
    }, {
        name: "isSecure",
        defaultValue: !1
    }, {
        name: "buttonText"
    } ]
});

Ext.define("kerio.wm.AppActions", {
    singleton: !0,
    MAIL_READ: "mailRead",
    CONVERSATION_READ: "conversationRead",
    EVENT_INVITATION_REMOVED: "eventInvitationRemoved",
    REMINDER_DISSMISED: "reminderDissmised",
    REMINDER_CLOSED: "reminderClosed",
    TASK_DONE: "taskDone",
    mailRead: function(e) {
        return {
            type: this.MAIL_READ,
            recordId: e
        };
    },
    conversationRead: function(e) {
        return {
            type: this.CONVERSATION_READ,
            recordId: e
        };
    },
    eventInvitationRemoved: function(e) {
        return {
            type: this.EVENT_INVITATION_REMOVED,
            recordId: e
        };
    },
    reminderDissmised: function(e) {
        return {
            type: this.REMINDER_DISSMISED,
            recordId: e
        };
    },
    reminderClosed: function(e) {
        return {
            type: this.REMINDER_CLOSED,
            recordId: e
        };
    },
    taskDone: function(e) {
        return {
            type: this.TASK_DONE,
            recordId: e
        };
    },
    SETTINGS_SAVE: "settingsSave",
    settingsSave: function(e, t) {
        return {
            type: this.SETTINGS_SAVE,
            panelAliases: e,
            fieldValueMap: t
        };
    },
    SETTINGS_PANEL_INITIALIZED: "settingsPanelInitialized",
    settingsPanelInitialized: function(e) {
        return {
            type: this.SETTINGS_PANEL_INITIALIZED,
            panelAliases: e
        };
    },
    LOCATION_CHANGE: "locationChange",
    locationChange: function(e) {
        return {
            type: this.LOCATION_CHANGE,
            newLocationParts: (e.newLocationParts || []).slice(0),
            oldLocationParts: (e.oldLocationParts || []).slice(0)
        };
    },
    MY_STATUS_CHANGED: "myStatusChanged",
    myStatusChanged: function(e) {
        return {
            type: this.MY_STATUS_CHANGED,
            newStatus: e
        };
    },
    MAIL_LIST_SELECTION_CHANGE: "mailListSelectionChange",
    mailListSelectionChange: function(e) {
        return {
            type: this.MAIL_LIST_SELECTION_CHANGE,
            selectedIds: e
        };
    },
    REMINDER_COUNT_CHANGED: "reminderCountChanged",
    reminderCountChanged: function(e) {
        return {
            type: this.REMINDER_COUNT_CHANGED,
            count: e
        };
    },
    EDITOR_STATE_CHANGED: "editorStateChanged",
    editorStateChanged: function(e, t) {
        return {
            type: this.EDITOR_STATE_CHANGED,
            opened: e,
            inWindow: t
        };
    }
});

Ext.define("kerio.wm.TimezonesManager", {
    singleton: !0,
    requires: [],
    _settingNames: [ "webmail.timeZone" ],
    constructor: function() {},
    check: function() {
        kerio.wm.SettingsManager.load(this._settingNames, {
            success: function(e) {
                if (!e) {
                    this.detectAndSetBrowserTimezone();
                }
            },
            scope: this
        });
    },
    detectAndSetBrowserTimezone: function() {},
    _matchTimeZone: function(e, t) {
        var s = e.length;
        var n = "";
        for (i = 0; i < s; i++) {
            if (e[i].indexOf(t) > -1) {
                n = e[i];
                break;
            }
        }
        return n;
    },
    _saveSuccess: function() {
        window.setTimeout(function() {
            document.location.reload(!1);
        }, 200);
    },
    _getAvailableTimeZones: function(e) {
        kerio.api.Session.getAvailableTimeZonesIncludeUnixZones({
            success: function(t) {
                var i = t.getZones();
                i.length;
                e.call(this, i);
            },
            scope: this
        });
    },
    _getBrowserTimeOffset: function() {
        var e = new Date().toString().match(/GMT(([+-])(\d{2})(\d{2}))/), t = e[2], i = e[3], s = e[4];
        return "(GMT " + t + i + ":" + s + ")";
    },
    _getBrowserTimezone: function() {
        return Intl.DateTimeFormat().resolvedOptions().timeZone;
    },
    _getBrowserTimezoneFromDate: function() {
        var e = new Date().toString().match(/\(([^)]+)\)/);
        return e[1];
    }
});

Ext.define("kerio.wm.utils.ModuleLoader", {
    loadModule: function(e) {
        if (!this.modules[e]) {
            return !1;
        }
        var t, i, s, n, o, r, a = this, l = [], d = e.charAt(0).toUpperCase() + e.substring(1);
        r = this.application.getController((this.modulesNs ? this.modulesNs + "." : "") + d + "Controller");
        r.getBubbleTarget = function() {
            return a;
        };
        r.doInit();
        l.push(r);
        o = r.controllers;
        if (o) {
            for (t = 0; t < o.length; t++) {
                n = this.application.getController(o[t]);
                n.doInit();
                l.push(n);
            }
        }
        if (r.viewport) {
            i = Ext.create(r.viewport, {
                itemId: e
            });
            r.viewport = i;
        }
        s = Ext.ComponentQuery.query(this.mainView);
        if (s && 1 === s.length) {
            s = s[0];
            s.add(i);
        }
        for (t = 0; t < l.length; t++) {
            l[t].onLaunch(this.application);
        }
        this.modules[e] = r;
        return !0;
    },
    setActiveModule: function(e, t) {
        var i, s, n = this.modules[e];
        t = Ext.isBoolean(t) && t;
        if (e === this.activeModule && !t) {
            return;
        }
        if (!n) {}
        if (this.activeModule && e !== this.activeModule) {
            i = this.modules[this.activeModule];
            if (i.deactivate) {
                i.deactivate();
            }
            i.isActive = !1;
        }
        if ("object" != typeof n) {
            if (i && i.itemListPanel) {
                i.itemListPanel.hide();
                s = !0;
            }
            this.loadModule(e);
            n = this.modules[e];
        }
        if (n) {
            if (n.activate) {
                n.activate();
            }
            this.activateModule(e, n);
            n.isActive = !0;
            this.activeModule = e;
            if (s) {
                i.itemListPanel.show();
            }
        }
    },
    activateModule: function(e, t) {}
});

Ext.define("kerio.wm.controller.AppMixin", {
    _onLaunchInit: function() {
        if (kerio.wm.Constants.IS_MULTI_SERVER) {
            kerio.wm.utils.multiServer.Ajax.init();
        }
    },
    _initWebassist: function() {
        if (window.k_webAssist && kerio.wm.Constants.IS_WEBASSIST_ENABLED) {
            window.k_webAssist.afterLoad({
                token: kerio.api.impl.Ajax.getToken(),
                url: kerio.api.settings.API_PATH,
                isSwitchOffPossible: !kerio.wm.Constants.IS_WEBASSIST_FORCED
            });
        }
    }
});

Ext.define("kerio.wm.view.Tooltip", {
    extend: "Ext.tip.ToolTip",
    singleton: !0,
    k_delay: 750,
    maxWidth: 500,
    constructor: function() {
        Ext.apply(this, {
            constrainPosition: !0,
            anchor: "left",
            dismissDelay: 0,
            hideDelay: 0,
            showDelay: this.k_delay,
            quickShowInterval: 0,
            trackMouse: !1
        });
        this.callParent(arguments);
    },
    hide: function() {
        this.clearTimer("show");
        this.callParent();
    },
    k_setQuick: function(e) {
        if (e) {
            Ext.apply(this, {
                showDelay: 0,
                trackMouse: !0
            });
        } else {
            Ext.apply(this, {
                showDelay: this.k_delay,
                trackMouse: !1
            });
        }
    },
    k_setPosition: function(e) {
        if ("bottom" === e) {
            this._k_setBottomPosition();
        } else {
            if ("no" === e) {
                this._k_setNoPosition();
            } else {
                this._k_setRightPosition();
            }
        }
    },
    _k_setBottomPosition: function() {
        Ext.apply(this, {
            origAnchor: "top",
            anchor: "top"
        });
    },
    _k_setRightPosition: function() {
        Ext.apply(this, {
            origAnchor: "left",
            anchor: "left"
        });
    },
    _k_setNoPosition: function() {
        Ext.apply(this, {
            origAnchor: "",
            anchor: ""
        });
    },
    k_setConstrain: function(e) {
        this.constrainTo = e;
    },
    _setAnchorOffset: function(e) {
        this.anchorOffset = e || 0;
    },
    k_setContent: function(e, t) {
        var i = t.k_html || "", s = Ext.supports.Direct2DBug;
        if (t.k_title) {
            i = '<span class="x-tip-header-text">' + t.k_title + "</span>" + ("" !== i ? "<br>" + i : "");
        }
        this._checkVisibility = t.checkVisibility;
        if (t.k_quick) {
            this.k_setQuick(!0);
            t.k_position = "no";
        } else {
            this.k_setQuick(!1);
        }
        this.k_setPosition(t.k_position || "right");
        this.target = t.k_target;
        this.setTarget(t.k_target);
        this._setFixedOffsets(t);
        Ext.supports.Direct2DBug = !1;
        this.update(i);
        if (e) {
            this.k_setConstrain(t.k_constrain);
            this._setAnchorOffset(t.anchorOffset);
            this.onMouseMove(e);
            this.onTargetOver(e);
            this.k_hideTooltip(e, t.k_target);
            this.delayShow(t.k_target);
        }
        Ext.supports.Direct2DBug = s;
    },
    k_hideTooltip: function(e, t) {
        if (!t || !e.within(t, !0)) {
            this.hide();
        }
    },
    show: function() {
        var e, t = Ext.supports.Direct2DBug;
        if (this._checkVisibility && this.target) {
            e = this.target.getViewSize();
            if (!e.width && !e.height) {
                return;
            }
        }
        Ext.supports.Direct2DBug = !1;
        this.callParent(arguments);
        Ext.supports.Direct2DBug = t;
    },
    getOffsets: function() {
        if (this._fixedOffsets) {
            return this._getFixedOffsets();
        } else {
            return this.callParent();
        }
    },
    _setFixedOffsets: function(e) {
        if (this.anchorToTarget && !this.trackMouse && e.fixedOffsets) {
            this._fixedOffsets = 2 === e.fixedOffsets.length ? e.fixedOffsets : [ e.fixedOffsets, e.fixedOffsets ];
        } else {
            this._fixedOffsets = void 0;
        }
    },
    _getFixedOffsets: function() {
        var e;
        switch (this.getAnchorPosition().charAt(0)) {
          case "t":
            e = [ this._fixedOffsets[0], this._fixedOffsets[1] + 2 ];
            break;

          case "b":
            e = [ this._fixedOffsets[0], -this._fixedOffsets[1] ];
            break;

          case "r":
            e = [ -this._fixedOffsets[0], this._fixedOffsets[1] ];
            break;

          default:
            e = [ this._fixedOffsets[0], this._fixedOffsets[1] ];
        }
        return e;
    }
});

Ext.define("kerio.wm.view.FormMsg", {
    singleton: !0,
    showInvalidFieldWarning: function(e) {
        kerio.wm.view.Msg.alert(k_tr("Validation Warning", "common"), k_tr("The highlighted [field is|fields are] incorrect.", "common", {
            k_pluralityBy: e
        }));
    },
    showFinishChangesMsg: function(e) {
        if (Ext.isEmpty(e)) {
            kerio.wm.view.Msg.alert(k_tr("Finish your changes to continue.", "contacts"), "");
        } else {
            e = Ext.String.ellipsis(e, 30);
            kerio.wm.view.Msg.alert(Ext.htmlEncode(e), k_tr('Finish your changes to "%1" to continue.', "calendar", {
                k_args: [ e ]
            }));
        }
    },
    showChangesWillBeLostConfirm: function(e, t) {
        kerio.wm.view.Msg.show({
            title: k_tr("Discard changes?", "module"),
            msg: k_tr("If you leave now, your changes will be lost.", "module"),
            buttons: kerio.wm.view.Msg.YESNO,
            buttonText: {
                yes: k_tr("Close Anyway", "calendarEditPanel"),
                no: k_tr("Continue Editing", "calendarEditPanel")
            },
            fn: e,
            scope: t
        });
    }
});

Ext.define("kerio.wm.view.reminder.Item", {
    extend: "Ext.container.Container",
    alias: "widget.reminderitem",
    cls: "reminderItem",
    styles: !0,
    height: 97,
    overCls: "reminderOver",
    bodyCls: "reminderItemBody",
    layout: {
        type: "hbox",
        pack: "start",
        align: "stretch"
    },
    _reminderTypes: {
        MINUTES_BEFORE_START: "MINUTES_BEFORE_START",
        IN_MINUTES: "IN_MINUTES",
        AT_TIME: "AT_TIME"
    },
    statics: {
        getFormattedTime: function(e) {
            var t, i, s, n, o, r, a, l, d, c = e.start, h = !1, u = !1, f = !1, m = kerio.wm.getCurrentDate();
            a = kerio.wm.view.calendar.viewPanel.EventOperations.k_getEvents(c, r);
            for (d = 0; d < a.length; d++) {
                if (a[d].getId() === e.itemId) {
                    l = a[d];
                    break;
                }
            }
            if (l) {}
            if ("itTask" === e.type) {
                r = e.due;
                if (r) {
                    if (kerio.wm.utils.Utils.isToday(r)) {
                        n = k_tr("Today", "calendar");
                    } else {
                        if (kerio.wm.utils.Utils.isTomorrow(r)) {
                            n = k_tr("Tomorrow", "calendar");
                        } else {
                            if (kerio.wm.utils.Utils.isYesterday(r)) {
                                n = k_tr("Yesterday", "calendar");
                            } else {
                                n = Ext.Date.format(r, r.getYear() !== m.getYear() ? "dateFullMonthYear" : "dateFullMonth");
                            }
                        }
                    }
                } else {
                    n = "";
                }
                return n;
            }
            r = e.end;
            if (c) {
                h = kerio.wm.utils.Utils.isToday(c);
                u = kerio.wm.utils.Utils.isTomorrow(c);
                f = kerio.wm.utils.Utils.isYesterday(c);
                s = kerio.wm.utils.Utils.getDifferenceInMinutes(m, c);
            }
            if (e.isAllDay) {
                r = Ext.Date.add(Ext.Date.add(r, Ext.Date.DAY, 1), Ext.Date.MILLI, -1);
                if (h) {
                    n = k_tr("Today", "calendar");
                } else {
                    t = Ext.Date.between(m, c, r);
                    if (u) {
                        n = k_tr("Tomorrow", "calendar");
                    } else {
                        if (f) {
                            if (t) {
                                n = k_tr("Started yesterday", "calendar");
                            } else {
                                n = k_tr("Yesterday", "calendar");
                            }
                        } else {
                            n = Ext.Date.format(c, c.getYear() !== m.getYear() ? "dateFullMonthYear" : "dateFullMonth");
                        }
                    }
                }
            } else {
                if (h) {
                    if (r && Ext.Date.clearTime(c, !0) < Ext.Date.clearTime(r, !0)) {
                        i = Ext.Date.format(c, "dateAndTime") + " - " + Ext.Date.format(r, "dateAndTime");
                    } else {
                        i = Ext.Date.format(c, "time") + (r && c !== r ? " - " + Ext.Date.format(r, "time") : "");
                    }
                }
                if (c && r) {
                    t = Ext.Date.between(m, c, r);
                }
                if (s >= 0) {
                    if (1 >= s) {
                        n = k_tr("Now", "calendar");
                    } else {
                        if (15 >= s) {
                            o = parseInt(s, 10);
                            n = k_tr("In %1 [minute|minutes]", "calendar", {
                                k_args: [ o ],
                                k_pluralityBy: o
                            });
                        } else {
                            if (h) {
                                n = i;
                            } else {
                                if (u) {
                                    n = k_tr("Tomorrow", "calendar");
                                } else {
                                    n = Ext.Date.format(c, c.getYear() !== m.getYear() ? "dateFullMonthYear" : "dateTimeFullMonth");
                                }
                            }
                        }
                    }
                } else {
                    if (h) {
                        s = Math.abs(s);
                        if (59 >= s && r > m) {
                            n = k_tr("%1 [minute|minutes] ago", "calendar", {
                                k_args: [ s ],
                                k_pluralityBy: s
                            });
                        } else {
                            n = i;
                        }
                    } else {
                        if (f) {
                            if (t) {
                                n = k_tr("Started yesterday", "calendar");
                            } else {
                                n = k_tr("Yesterday", "calendar");
                            }
                        } else {
                            if (c) {
                                n = Ext.Date.format(c, c.getYear() !== m.getYear() ? "dateFullMonthYear" : "dateFullMonth");
                            }
                        }
                    }
                }
            }
            return n;
        }
    },
    constructor: function(e) {
        var t;
        if (e.record) {
            this.setRecord(e.record);
            delete e.record;
        }
        this.items = [ {
            xtype: "component",
            flex: 1,
            itemId: "reminderDetail",
            tpl: Ext.create("Ext.XTemplate", '<table class="itemCt" cellspacing="0" cellpadding="0" >', "<tbody>", "<tr>", '<td class="eventIcon" style="width:25px;">', '<div class="eventIconInner {[this.getItemCls(values)]}"></div>', '<div class="eventIconAlarmClock"></div>', "</td>", '<td class="eventDetails">', '<div class="eventDetail eventSummary">{summary:htmlEncode}</div>', '<div class="eventDetail eventStart">{[ this.getFormattedTime(values) ]}</div>', '<div class="eventDetail eventLocation">{location:htmlEncode}</div>', "</td>", "</tr>", "</tbody>", "</table>", {
                getFormattedTime: kerio.wm.view.reminder.Item.getFormattedTime,
                getItemCls: this._getItemCls
            })
        }, this._getToolbarCfg() ];
        this.callParent([ e ]);
        this._reminderDetail = this.down("#reminderDetail");
        this.addCls(kerio.wm.isTouchDevice ? "touchDevice" : "defaultDevice");
        t = this.down("#remindBtn").menu;
        t.isReminderMenu = !0;
        t.on({
            show: function() {
                this.down("#btnToolbar").addCls("menuOpened");
            },
            hide: function() {
                this.down("#btnToolbar").removeCls("menuOpened");
            },
            scope: this
        });
    },
    _getItemCls: function(e) {
        var t;
        if ("itCalendar" === e.type) {
            t = "calendar";
        } else {
            if ("itTask" === e.type) {
                t = "task";
            } else {
                t = "unknowItem";
            }
        }
        return t;
    },
    setRecord: function(e) {
        this._record = e;
        this.itemId = e.getItemId();
        this._applyRecord();
    },
    getRecord: function() {
        return this._record;
    },
    _applyRecord: function() {
        if (this.rendered && this._record) {
            this._reminderDetail.tpl[this._reminderDetail.tplWriteMode](this._reminderDetail.getTargetEl(), this._record.data);
        }
    },
    afterRender: function(e) {
        this.callParent(arguments);
        this.getEl().on({
            click: this._fireClick,
            scope: this
        });
        this._applyRecord();
    },
    _getDismissBtnCfg: function() {
        return {
            text: k_tr("Dismiss", "calendar"),
            cls: "dismissBtn",
            isLight: !0,
            width: 100,
            itemId: "dismissBtn",
            listeners: {
                click: this._onDismissBtnClick,
                scope: this
            }
        };
    },
    _onDismissBtnClick: function() {
        this.fireEvent("dismiss", this.getRecord());
    },
    _onRemindClick: function(e) {
        var t = this._getNextTime(e.reminderType, e.reminderValue);
        this.fireEvent("remind", this.getRecord(), t);
    },
    _getNextTime: function(e, t) {
        var i, s = kerio.wm.getCurrentDate(), n = this.getRecord();
        switch (e) {
          case this._reminderTypes.MINUTES_BEFORE_START:
            i = Ext.Date.add(n.get("start"), Ext.Date.MINUTE, -t);
            break;

          case this._reminderTypes.IN_MINUTES:
            i = Ext.Date.add(s, Ext.Date.MINUTE, t);
            break;

          case this._reminderTypes.AT_TIME:
            i = Ext.Date.add(Ext.Date.add(Ext.Date.clearTime(s), Ext.Date.DAY, 1), Ext.Date.HOUR, 9);
        }
        return i;
    },
    _getToolbarCfg: function() {
        return {
            itemId: "btnToolbar",
            xtype: "toolbar",
            cls: "itemToolbar",
            vertical: !0,
            items: [ Ext.widget("webmailbutton", this._getDismissBtnCfg()), Ext.widget("webmailbutton", this._getRemindAgainBtnCfg()) ]
        };
    },
    _getRemindAgainBtnCfg: function() {
        return {
            isLight: !0,
            text: k_tr("Remind", "calendar"),
            cls: "remindBtn",
            itemId: "remindBtn",
            menu: this._getRemindAgainMenuItemsCfg(),
            listeners: {
                click: function(e, t) {
                    t.stopEvent();
                }
            }
        };
    },
    _getRemindAgainMenuItemsCfg: function() {
        var e, t = Ext.Date.format(Ext.Date.add(Ext.Date.clearTime(kerio.wm.getCurrentDate()), Ext.Date.HOUR, 9), "time");
        e = {
            click: this._onRemindClick,
            scope: this
        };
        return {
            plain: !0,
            items: [ {
                text: k_tr("5 minutes", "calendar"),
                reminderType: this._reminderTypes.IN_MINUTES,
                reminderValue: 5,
                listeners: e
            }, {
                text: k_tr("10 minutes", "calendar"),
                reminderType: this._reminderTypes.IN_MINUTES,
                reminderValue: 10,
                listeners: e
            }, {
                text: k_tr("15 minutes", "calendar"),
                reminderType: this._reminderTypes.IN_MINUTES,
                reminderValue: 15,
                listeners: e
            }, {
                text: k_tr("1 hour", "calendar"),
                reminderType: this._reminderTypes.IN_MINUTES,
                reminderValue: 60,
                listeners: e
            }, {
                text: k_tr("2 hours", "calendar"),
                reminderType: this._reminderTypes.IN_MINUTES,
                reminderValue: 120,
                listeners: e
            }, {
                xtype: "menuseparator"
            }, {
                text: k_tr("Tomorrow at %1", "calendar", {
                    k_args: [ t ]
                }),
                reminderType: this._reminderTypes.AT_TIME,
                reminderValue: -1,
                listeners: e
            }, {
                text: k_tr("1 day", "calendar"),
                reminderType: this._reminderTypes.IN_MINUTES,
                reminderValue: 1440,
                listeners: e
            } ]
        };
    },
    _fireClick: function(e) {
        e.stopEvent();
        this.fireEvent("click", this, e);
    }
});

Ext.define("kerio.wm.view.reminder.MissedItem", {
    extend: "kerio.wm.view.reminder.Item",
    alias: "widget.remindermisseditem",
    styles: !0,
    constructor: function() {
        this.callParent(arguments);
        this.addCls("missed");
    }
});

Ext.define("kerio.wm.view.NavigationButton", {
    extend: "kerio.wm.view.WebmailButton",
    alias: "widget.navigationbutton",
    styles: !0,
    height: 33,
    hasCounter: void 0,
    enableToggle: !0,
    allowDepress: !1,
    isResponsive: !1,
    margin: "0 0 0 10",
    iconWidth: 0,
    renderTpl: function() {
        var e = Ext && Ext.button && Ext.button.Button && Ext.button.Button.prototype && Ext.button.Button.prototype.renderTpl ? Ext.button.Button.prototype.renderTpl.join("") : "";
        return [ e, '<tpl if="hasCounter">', '<div id="{id}-buttonCount" class="buttonCount redDotCount"></div>', "</tpl>" ].join("");
    }(),
    constructor: function() {
        this.callParent(arguments);
        this.addCls("navigationButton");
    },
    initRenderData: function() {
        var e = this;
        return Ext.applyIf(this.callParent(arguments), {
            id: e.id,
            iconCls: e.iconCls,
            hasCounter: e.hasCounter
        });
    },
    setCount: function(e) {
        var t = this;
        if (!t.buttonCount) {
            return t;
        }
        e = 0 > e ? 0 : e;
        t._count = e;
        if (t.rendered) {
            if (e) {
                t.buttonCount.update(e);
                t.buttonCount.addCls("visible");
            } else {
                t.buttonCount.removeCls("visible");
            }
            t.doComponentLayout();
        }
        return t;
    },
    beforeRender: function() {
        this.addChildEls("buttonCount");
        this.callParent(arguments);
        if (this.buttonCount) {
            this.mon(this.buttonCount, {
                scope: this,
                mousedown: this.onMouseDown,
                mouseup: this.onMouseUp,
                mousemove: this.onMouseMove,
                click: this.onClick
            });
            this.addListener({
                press: function() {
                    this.buttonCount.addCls(this.pressedCls);
                },
                unpress: function() {
                    this.buttonCount.removeCls(this.pressedCls);
                },
                scope: this
            });
            this.setCount(this._count || 0);
        }
    },
    addRoundedCorners: Ext.emptyFn
});

Ext.define("kerio.wm.view.quicksearch.ComboSelect", {
    extend: "Ext.grid.Panel",
    styles: !0,
    floating: !0,
    hidden: !0,
    hideHeaders: !0,
    width: 150,
    shadow: !1,
    cls: "comboSelect",
    columns: [ {
        xtype: "gridcolumn",
        dataIndex: "name",
        flex: 1,
        tpl: Ext.create("Ext.XTemplate", "{value}")
    } ],
    constructor: function() {
        this.renderTo = Ext.getBody();
        this.callParent(arguments);
    },
    initComponent: function() {
        this.callParent(arguments);
        this.view.on("render", function() {
            this.view.el.on("blur", function() {
                Ext.defer(function() {
                    this.fireEvent("blur");
                }, 100, this);
            }, this);
        }, this);
    },
    alignToField: function() {
        this.alignTo(this.targetEl, "bl");
    }
});

Ext.define("kerio.wm.PopUpNotification", {
    singleton: !0,
    statics: {
        POP_UP_BODY_HEIGHT: 100,
        POP_UP_BORDER_HEIGHT: 50,
        POP_UP_TOTAL_WIDTH: 300,
        MAX_DISPLAYED_POP_UPS: 3
    },
    constructor: function() {
        this.notifSlots = [];
        this.notificationsQueue = [];
        this._computePopUpSlotsPositions();
    },
    show: function(e) {
        var t = this._getFreeSlot();
        if (0 > t) {
            this.notificationsQueue.push(e);
            return;
        } else {
            this._showAtSlot(t, e);
        }
    },
    _computePopUpSlotsPositions: function() {
        var e, t, i = this.self.POP_UP_BODY_HEIGHT, s = this.self.POP_UP_BORDER_HEIGHT, n = i + s, o = this.self.POP_UP_TOTAL_WIDTH, r = 60, a = 30;
        if (Ext.isIE8) {
            n += 20;
        }
        for (t = 1; t <= this.self.MAX_DISPLAYED_POP_UPS; t++) {
            e = {
                x: screen.width - o - a,
                y: screen.height - t * n - t * a - r,
                win: void 0,
                free: !0,
                dataId: void 0
            };
            this.notifSlots.push(e);
        }
    },
    isNotificationOpen: function(e) {
        var t;
        for (t = 0; t < this.notifSlots.length; t++) {
            if (this.notifSlots[t].dataId === e) {
                return !0;
            }
        }
        for (t = 0; t < this.notificationsQueue.length; t++) {
            if (this.notificationsQueue[t]._nid === e) {
                return !0;
            }
        }
        return !1;
    },
    closeNotification: function(e, t) {
        var i;
        for (i = 0; i < this.notificationsQueue.length; i++) {
            if (this.notificationsQueue[i]._nid === e) {
                Ext.Array.remove(this.notificationsQueue, this.notificationsQueue[i]);
                return;
            }
        }
        for (i = 0; i < this.notifSlots.length; i++) {
            if (this.notifSlots[i].dataId === e) {
                this.forceCloseNotification(this.notifSlots[i], t);
                this.notifSlots[i].free = !0;
                this.notifSlots[i].dataId = void 0;
                break;
            }
        }
    },
    closeAllNotifications: function() {
        this.notificationsQueue = [];
        Ext.Array.forEach(this.notifSlots, function(e) {
            if (!e.free) {
                this.forceCloseNotification(e, !0);
                e.free = !0;
            }
        }, this);
    },
    forceCloseNotification: function(e, t) {
        var i = e.win;
        if (i) {
            if (t === !0) {
                delete e.data.onClose;
            }
            i.close();
        }
    },
    freeCallback: function(e) {
        var t;
        for (t = 0; t < this.notifSlots.length; t++) {
            if (this.notifSlots[t].win === e) {
                this.notifSlots[t].win = void 0;
                this.notifSlots[t].dataId = void 0;
                this.notifSlots[t].free = !0;
                this._refillFromQueue(t);
                return;
            }
        }
        Ext.Array.remove(this.notificationsQueue, e);
    },
    _refillFromQueue: function(e) {
        var t;
        if (this.notificationsQueue.length > 0) {
            t = this.notificationsQueue.pop();
            this.notifSlots[e].free = !1;
            Ext.defer(function(e, t) {
                this._showAtSlot(e, t);
            }, 1e3, this, [ e, t ]);
        }
    },
    _getFreeSlot: function() {
        var e;
        for (e = 0; e < this.notifSlots.length; e++) {
            if (this.notifSlots[e].free === !0) {
                this.notifSlots[e].free = !1;
                return e;
            }
        }
        return -1;
    },
    _deferedIE8NotifiContent: function(e, t) {
        Ext.defer(function(e, t) {
            if (t.iAmReady) {
                this._modifyNotificationContent(e, t);
                t.focus();
            } else {
                this.freeCallback(t);
                t.close();
            }
        }, 1500, this, [ e, t ]);
    },
    _showAtSlot: function(e, t) {
        var i, s, n = this, o = n.notifSlots[e];
        if (t.id) {
            if ("object" == typeof t.id) {
                s = t.id.id;
            } else {
                s = t.id;
            }
        }
        s = s || t._nid;
        i = kerio.wm.Locations.openInNewWindow("/webmail/notification.html?v=38d8dd44fb716e4a0925bd5fe75aa72b", "notification", s, {
            width: n.self.POP_UP_TOTAL_WIDTH,
            height: n.self.POP_UP_BODY_HEIGHT,
            left: o.x,
            top: o.y,
            scrollbars: !1
        });
        if (i) {
            o.free = !1;
            o.win = i;
            o.dataId = t._nid;
            o.data = t;
            if (Ext.isSafari) {
                i.resizeTo(n.self.POP_UP_TOTAL_WIDTH + 20, n.self.POP_UP_BODY_HEIGHT + n.self.POP_UP_BORDER_HEIGHT);
            }
            i.closeHandler = function() {
                if (t.onClose) {
                    if (t.scope) {
                        t.onClose.call(t.scope, t.id);
                    } else {
                        t.onClose(t.id);
                    }
                }
                n.freeCallback(i);
            };
            if (!i.iAmReady) {
                i.notificationListener = function() {
                    n._modifyNotificationContent(o, i);
                    i.focus();
                };
                if (Ext.isIE8) {
                    this._deferedIE8NotifiContent(o, i);
                }
            } else {
                n._modifyNotificationContent(o, i);
                i.focus();
            }
            if (t.category === kerio.wm.NotificationsProvider.MAILS_NOTIFICATIONS_CATEGORY) {
                i.onmouseover = Ext.bind(function() {
                    window.clearTimeout(this.closeTimerId);
                    if (!this._mouseOverTime) {
                        this._mouseOverTime = new Date();
                    }
                }, o);
                i.onmouseout = Ext.bind(function(e) {
                    var t, i = this.scope, s = this.slot;
                    t = new Date() - s._mouseOverTime > 1e3;
                    window.clearTimeout(s.closeTimerId);
                    s.closeTimerId = Ext.defer(i.forceCloseNotification, t ? 200 : kerio.wm.NotificationsProvider.MAIL_NOTIFICATION_DURATION, i, [ s ]);
                }, {
                    slot: o,
                    scope: this
                });
                o.closeTimerId = Ext.defer(n.forceCloseNotification, kerio.wm.NotificationsProvider.MAIL_NOTIFICATION_DURATION, n, [ o ]);
            }
        }
    },
    _modifyNotificationContent: function(e, t) {
        var i = e.data, s = t.document.getElementById("notification-button");
        Ext.get(s).on("click", function(e) {
            var t = this.slot.data;
            this.scope.forceCloseNotification(this.slot, !0);
            if (t.onClick) {
                if (t.scope) {
                    t.onClick.call(t.scope, t.id);
                } else {
                    t.onClick(t.id);
                }
            }
            if (!Ext.isIE8) {
                e.preventDefault();
            }
            return !1;
        }, {
            scope: this,
            slot: e
        });
        if (i.category === kerio.wm.NotificationsProvider.MAILS_NOTIFICATIONS_CATEGORY) {
            s.innerHTML = k_tr("Show", "notification");
            t.document.title = "Kerio Connect new mail";
        } else {
            if (i.category === kerio.wm.NotificationsProvider.REMINDER_NOTIFICATIONS_CATEGORY) {
                s.innerHTML = k_tr("Show", "notification");
                t.document.title = "Kerio Connect reminder";
            } else {
                s.innerHTML = k_tr("Close", "common");
                t.document.title = "Kerio Connect";
            }
        }
        s.style.display = "inline";
        t.document.getElementById("notification-title").innerHTML = i.title;
        t.document.getElementById("notification-message").innerHTML = i.body;
        if (!Ext.isIE && !Ext.isIE11 && !Ext.isMSEdge) {
            Ext.defer(function() {
                Ext.get(t.document.body).highlight("F6F052", {
                    duration: 1e3,
                    endColor: "f5f5f5"
                });
            }, 1e3);
        }
    }
});

Ext.define("kerio.wm.Notification", {
    extend: "Ext.util.Observable",
    statics: {
        PERMISSION_GRANTED: "granted",
        PERMISSION_DENIED: "denied",
        PERMISSION_DEFAULT: "default",
        _nativeNotification: function() {
            return window.Notification || null;
        }(),
        _webkitNotification: function() {
            return window.webkitNotifications || null;
        }(),
        isNativeSupported: function() {
            return null !== this._nativeNotification;
        },
        isWebkitSupported: function() {
            return null !== this._webkitNotification;
        },
        isSupported: function() {
            return this.isNativeSupported() || this.isWebkitSupported();
        },
        _getNotificatonCls: function() {
            if (this.isNativeSupported()) {
                return this._nativeNotification;
            }
            if (this.isWebkitSupported()) {
                return this._webkitNotification;
            }
            return null;
        },
        isPermissionGranted: function() {
            return this.getPermission() === this.PERMISSION_GRANTED;
        },
        getPermission: function() {
            var e = this._getNotificatonCls();
            if (this.isNativeSupported()) {
                if (e.permission) {
                    return e.permission;
                }
                if (Ext.isFunction(e.permissionLevel)) {
                    return e.permissionLevel();
                }
            } else {
                if (this.isWebkitSupported() && Ext.isFunction(e.checkPermission)) {
                    switch (e.checkPermission()) {
                      case 0:
                        return this.PERMISSION_GRANTED;

                      case 1:
                        return this.PERMISSION_DEFAULT;

                      case 2:
                        return this.PERMISSION_DENIED;
                    }
                }
            }
            return this.PERMISSION_DEFAULT;
        },
        requestPermission: function(e, t) {
            var i, s = this._getNotificatonCls();
            if (e) {
                t = t || this;
                i = function() {
                    e.call(t);
                };
            }
            if (s && Ext.isFunction(s.requestPermission)) {
                s.requestPermission(i);
            } else {
                i();
            }
        }
    },
    _notification: null,
    constructor: function(e) {
        if (!this.self.isNativeSupported() && !this.self.isWebkitSupported()) {
            throw new Error("Notifications are not supported.");
        }
        this.addEvents({
            click: !0,
            show: !0,
            error: !0,
            close: !0
        });
        this.callParent([ {
            listeners: e.listeners
        } ]);
        this.id = e.id;
        this._notification = this._createNotification(e);
    },
    _createNotification: function(e) {
        var t;
        if (this.self.isNativeSupported()) {
            t = new this.self._nativeNotification(Ext.htmlDecode(e.title || ""), {
                dir: "auto",
                body: Ext.htmlDecode(e.body || ""),
                tag: e.id,
                icon: e.icon || "",
                requireInteraction: !0
            });
        } else {
            t = this.self._webkitNotification.createNotification(e.icon || "", Ext.htmlDecode(e.title || ""), Ext.htmlDecode(e.body || ""));
            t.replaceId = e.id;
        }
        t.onclick = Ext.Function.bind(this._onClick, this);
        t[!this.self.isNativeSupported() ? "ondisplay" : "onshow"] = Ext.Function.bind(this._onShow, this);
        t.onerror = Ext.Function.bind(this._onError, this);
        t.onclose = Ext.Function.bind(this._onClose, this);
        if (!this.self.isNativeSupported()) {
            t.show();
        }
        return t;
    },
    close: function() {
        if (this.self.isNativeSupported()) {
            this._notification.close();
        } else {
            if (this.self.isWebkitSupported()) {
                this._notification.cancel();
            }
        }
    },
    _onClick: function() {
        this.fireEvent("click", this);
    },
    _onShow: function() {
        this.fireEvent("show", this);
    },
    _onError: function() {
        this.fireEvent("error", this);
    },
    _onClose: function() {
        this.fireEvent("close", this);
    }
});

Ext.define("kerio.wm.store.NotificationStore", {
    singleton: !0,
    _storage: window.localStorage,
    _shownNotificationMap: {},
    constructor: function() {
        this._updateStorage();
    },
    _updateStorage: function() {
        if (this._storage) {
            this._storage.setItem("_shownNotificationMap", JSON.stringify(this._shownNotificationMap));
        }
    },
    _updateMap: function() {
        this._shownNotificationMap = JSON.parse(this._storage.getItem("_shownNotificationMap") || null) || {};
    },
    _getKeyForRecord: function(e) {
        return e.getId() + "_" + e.getConversation().receivedLastReadId + "_" + e.get("unreadCount");
    },
    isNotificationShown: function(e) {
        var t = this._getKeyForRecord(e);
        this._updateMap();
        return !!this._shownNotificationMap[t];
    },
    set: function(e) {
        var t = this._getKeyForRecord(e);
        this._shownNotificationMap[t] = !0;
        this._updateStorage();
    }
});

Ext.define("kerio.wm.utils.ToggleGroupWorker", {
    _initToggleButtons: function(e) {
        var t, i;
        e = e || this;
        t = e.query("webmailbutton[enableToggle=true][toggleGroup]");
        for (i = 0; i < t.length; i++) {
            t[i].addListener("beforepress", this._onBeforePress, this, e);
        }
    },
    _onBeforePress: function(e, t) {
        if (e.enableToggle && e.toggleGroup) {
            this._unpressButton(e.toggleGroup, t);
        }
    },
    _unpressButton: function(e, t) {
        var i = t.query('webmailbutton[pressed=true][toggleGroup="' + e + '"]');
        if (i && i.length > 0) {
            i[0].unpress();
        }
    }
});

Ext.define("kerio.wm.touchDevice.TouchController", {
    constructor: function(e, t) {
        var i = new kerio.lib.K_TouchController(e);
        i._options = t;
        i._k_updateStatus = this._k_updateStatus;
        return i;
    },
    _k_updateStatus: function() {
        kerio.lib.K_TouchController.prototype._k_updateStatus.apply(this, arguments);
        this.k_status.k_hostOptions = this._options;
    }
});

Ext.define("kerio.wm.model.FolderModel", {
    extend: "kerio.wm.model.Model",
    isFolder: !0,
    isNewFolder: !1,
    fields: [ "id", {
        name: "name",
        toDisplay: !0
    }, "type", "placeType", "access", "ownerName", "subType", {
        name: "nestingLevel",
        persist: !1
    }, {
        name: "messageCount",
        persist: !1
    }, {
        name: "messageUnread",
        persist: !1
    }, "emailAddress", {
        name: "checked",
        persist: !1
    }, {
        name: "allowDrag",
        persist: !1,
        defaultValue: !1
    }, {
        name: "children",
        persist: !1
    }, "parentFolderId", {
        name: "isShared",
        persist: !1
    }, {
        name: "isDelegated",
        persist: !1
    }, {
        name: "color",
        persist: !1
    }, {
        name: "fakeParentId",
        persist: !1
    }, {
        name: "leaf",
        persist: !1
    }, {
        name: "published",
        persist: !1
    }, {
        name: "messageSize",
        persist: !1
    }, {
        name: "text",
        persist: !1
    }, {
        name: "parentId",
        persist: !1
    }, {
        name: "expandable",
        persist: !1,
        defaultValue: !0
    }, {
        name: "isSubscribed",
        persist: !1
    }, {
        name: "expand",
        persist: !1
    }, {
        name: "index",
        persist: !1
    }, {
        name: "depth",
        persist: !1
    }, {
        name: "expanded",
        persist: !1
    }, {
        name: "expandedOriginal",
        persist: !1
    }, {
        name: "cls",
        persist: !1
    }, {
        name: "iconCls",
        persist: !1
    }, {
        name: "icon",
        persist: !1
    }, {
        name: "root",
        persist: !1
    }, {
        name: "isLast",
        persist: !1
    }, {
        name: "isFirst",
        persist: !1
    }, {
        name: "allowDrop",
        persist: !1
    }, {
        name: "loaded",
        persist: !1
    }, {
        name: "loading",
        persist: !1
    }, {
        name: "href",
        persist: !1
    }, {
        name: "hrefTarget",
        persist: !1
    }, {
        name: "qtip",
        persist: !1
    }, {
        name: "qtitle",
        persist: !1
    }, {
        name: "borderColor",
        persist: !1
    }, {
        name: "boxColor",
        persist: !1
    }, {
        name: "calendarName",
        persist: !1
    }, {
        name: "path",
        persist: !1
    }, {
        name: "realPath",
        persist: !1
    }, {
        name: "fullRealPath",
        persist: !1
    } ],
    setParentFolderId: function(e) {
        this.set("parentFolderId", e);
    },
    isMailboxRoot: function(e) {
        return "FakeSubType" === this[e || this.persistenceProperty].subType || "root" === this[e || this.persistenceProperty].id;
    },
    isFoldersRoot: function() {
        return "FRoot" === this[this.persistenceProperty].type || "FakeSubType" === this[this.persistenceProperty].subType;
    },
    isSharedRootFolder: function() {
        return "SHARED_FOLDERS" === this[this.persistenceProperty].id && "FakeSubType" === this[this.persistenceProperty].subType;
    },
    isGroupsRoot: function() {
        return "CONTACT_GROUPS" === this.get("id");
    },
    isSelectable: function() {
        return !this.isFoldersRoot() && !this.isAccessListingOnly();
    },
    insertFolder: function(e, t, i, s, n) {
        var o;
        if (!n) {
            n = 0;
        }
        o = function() {
            this.insertChild(n, e);
            if (!0 === t) {
                this.sortChildern();
            }
            if (i) {
                i.apply(s || this);
            }
        };
        if (this.isExpanded()) {
            o.apply(this);
        } else {
            this.expand(!1, o, this);
        }
    },
    sortChildern: function() {
        if (!this.childNodes || 0 === this.childNodes.length) {
            return;
        }
        this.sort(kerio.wm.data.MemoryFolderReader.sortFunction);
        this.updateInfo(!0);
    },
    childByName: function(e, t) {
        if (!this.childNodes || 0 === this.childNodes.length) {
            return !1;
        }
        var i;
        for (i = 0; i < this.childNodes.length; i++) {
            if (t !== this.childNodes[i] && e === this.childNodes[i].get("name")) {
                return this.childNodes[i];
            }
        }
        return !1;
    },
    getChildern: function() {
        return this.childNodes || [];
    },
    isDeletedFolder: function() {
        var e = this;
        if ("FSubDeletedItems" === this[this.persistenceProperty].subType) {
            return !0;
        }
        while (e.parentNode) {
            e = e.parentNode;
            if ("FSubDeletedItems" === e[this.persistenceProperty].subType) {
                return !0;
            }
        }
        return !1;
    },
    isSharedFolder: function() {
        var e = this[this.persistenceProperty].id, t = this;
        if ("SHARED_FOLDERS" === e || "PEOPLE" === e || "RESOURCES" === e) {
            return !0;
        }
        while (t.parentNode) {
            t = t.parentNode;
            e = t[this.persistenceProperty].id;
            if ("SHARED_FOLDERS" === e || "PEOPLE" === e || "RESOURCES" === e) {
                return !0;
            }
        }
        return !1;
    },
    isClickableSharedFolder: function() {
        return this.isSharedFolder() && this.get("nestingLevel") > 2 && !this.isAccessListingOnly();
    },
    isSentItems: function() {
        return "FSubSentItems" === this[this.persistenceProperty].subType;
    },
    isDraftFolder: function() {
        var e = this;
        if ("FSubDrafts" === e.data.subType) {
            return !0;
        }
        while (e.parentNode) {
            e = e.parentNode;
            if ("FSubDrafts" === e.data.subType) {
                return !0;
            }
        }
        return !1;
    },
    isReadOnlyFolder: function() {
        var e = this.get("access");
        return "FAccessReadOnly" === e || "FAccessListingOnly" === e;
    },
    isWriteableFolder: function() {
        var e = this.get("access");
        return "FAccessAdmin" === e || "FAccessReadWrite" === e;
    },
    isSpamFolder: function() {
        var e = this;
        if ("FSubJunkEmail" === e.data.subType) {
            return !0;
        }
        while (e.parentNode) {
            e = e.parentNode;
            if ("FSubJunkEmail" === e.data.subType) {
                return !0;
            }
        }
        return !1;
    },
    save: function(e) {
        e = Ext.apply({}, e);
        var t, i, s = this, n = s.isNewFolder ? "create" : "update", o = null, r = e.scope || s;
        Ext.apply(e, {
            records: [ s ],
            action: n
        });
        t = Ext.create("Ext.data.Operation", e);
        i = function(t) {
            if (t.wasSuccessful()) {
                o = t.records[0];
                if (this.isNewFolder) {
                    this.parentNode.replaceChild(o, this);
                    o.isNewFolder = !0;
                }
                Ext.callback(e.success, r, [ o, t ]);
            } else {
                Ext.callback(e.failure, r, [ o, t ]);
            }
            Ext.callback(e.callback, r, [ o, t ]);
        };
        s.getProxy()[n](t, i, s);
        return s;
    },
    getDeleteItemsModel: function() {
        var e, t = this.parentNode;
        while (t && null !== t.parentNode) {
            t = t.parentNode;
        }
        if (t) {
            for (e = 0; e < t.childNodes.length; e++) {
                if (t.childNodes[e].isDeletedFolder()) {
                    return t.childNodes[e];
                }
            }
        }
        return;
    },
    removeAllSubfolders: function(e) {
        var t, i, s = this, n = "destroy", o = s, r = e.scope || s, a = {};
        a.recursive = !0;
        e = Ext.apply({}, {
            action: n,
            params: a,
            scope: s
        }, e);
        t = Ext.create("Ext.data.Operation", e);
        i = function(t) {
            if (t.wasSuccessful()) {
                Ext.callback(e.success, r, [ o, t ]);
            } else {
                Ext.callback(e.failure, r, [ o, t ]);
            }
        };
        s.getProxy()[n](t, i, s);
        return s;
    },
    k_isSubtypeDefault: function() {
        return "FSubDefault" === this.get("subType");
    },
    k_isPlacePublic: function() {
        return "FPlacePublic" === this.get("placeType");
    },
    isPlaceMailbox: function() {
        return "FPlaceMailbox" === this.get("placeType");
    },
    isPlaceArchive: function() {
        return "FPlaceArchive" === this.get("placeType");
    },
    isDefaultMailbox: function() {
        return this.k_isSubtypeDefault() && this.isPlaceMailbox();
    },
    k_isPlacePeople: function() {
        return "FPlacePeople" === this.get("placeType");
    },
    k_isPlaceResource: function() {
        var e = this.get("placeType");
        return "FPlaceLocations" === e || "FPlaceResources" === e;
    },
    k_isPlaceSubscribed: function() {
        return this.k_isPlacePeople() || this.k_isPlaceResource();
    },
    k_isAccessAdmin: function() {
        return "FAccessAdmin" === this.get("access");
    },
    isAccessReadWrite: function() {
        return "FAccessReadWrite" === this.get("access");
    },
    isAccessReadOnly: function() {
        return "FAccessReadOnly" === this.get("access");
    },
    isAccessListingOnly: function() {
        return "FAccessListingOnly" === this.get("access");
    },
    k_isTypeCalendar: function() {
        return "FCalendar" === this.get("type");
    },
    isTypeContact: function() {
        return "FContact" === this.get("type");
    },
    isTypeMail: function() {
        return "FMail" === this.get("type");
    },
    k_isTypeTask: function() {
        return "FTask" === this.get("type");
    },
    isChecked: function() {
        return this.get("checked");
    },
    getOwnerName: function() {
        return this.get("ownerName");
    },
    isFakeFolder: function() {
        return "FakeSubType" === this.get("subType");
    },
    getName: function() {
        return this.get("name");
    },
    isDelegated: function() {
        return !0 === this.get("isDelegated");
    },
    isSharedByMe: function() {
        return !0 === this.get("isShared");
    }
});

Ext.define("kerio.wm.data.FolderTranslations", {
    singleton: !0,
    requires: [ "kerio.wm.Constants" ],
    constructor: function() {
        this.rootFoldersByPlaceType = {};
        this.rootFoldersByPlaceType.FPlacePublic = k_tr("PUBLIC FOLDERS", "folders");
        this.rootFoldersByPlaceType.FPlaceArchive = k_tr("ARCHIVE FOLDERS", "folders");
        this.rootFoldersByPlaceType.FPlacePeople = k_tr("SHARED FOLDERS", "folders");
        this.mailFoldersBySubType = {};
        this.mailFoldersBySubType.FSubInbox = k_tr("Inbox", "mail");
        this.mailFoldersBySubType.FSubSentItems = k_tr("Sent", "mail");
        this.mailFoldersBySubType.FSubDrafts = k_tr("Drafts", "mail");
        this.mailFoldersBySubType.FSubJunkEmail = k_tr("Spam", "mail");
        this.mailFoldersBySubType.FSubDeletedItems = k_tr("Trash", "mail");
        this.mailFoldersBySubType.FSubGalResources = k_tr("Resources", "folders");
        this.mailFoldersBySubType.FSubGalContacts = k_tr("Contacts", "contacts");
        this.rootFoldersByName = {};
        this.rootFoldersByName[kerio.wm.Constants.rootFolders.publicFolders] = k_tr("PUBLIC FOLDERS", "folders");
        this.rootFoldersByName[kerio.wm.Constants.rootFolders.archiveFolders] = k_tr("ARCHIVE FOLDERS", "folders");
        this.mailFoldersByName = {};
        this.mailFoldersByName[kerio.wm.Constants.baseFolders.inbox] = k_tr("Inbox", "mail");
        this.mailFoldersByName[kerio.wm.Constants.baseFolders.sentItems] = k_tr("Sent", "mail");
        this.mailFoldersByName[kerio.wm.Constants.baseFolders.drafts] = k_tr("Drafts", "mail");
        this.mailFoldersByName[kerio.wm.Constants.baseFolders.junkEmail] = k_tr("Spam", "mail");
        this.mailFoldersByName[kerio.wm.Constants.baseFolders.deleteItems] = k_tr("Trash", "mail");
        this.mailFoldersByName[this._normalizeName(kerio.wm.Constants.baseFolders.inbox)] = k_tr("Inbox", "mail");
    },
    normalizePath: function(e) {
        var t;
        if (e && 0 !== e.indexOf("~")) {
            t = "~" + kerio.wm.Constants.loginName + "/" + e;
        } else {
            t = e;
        }
        return t;
    },
    folderPathToName: function(e) {
        var t, i = e, s = i.split("/");
        if (0 === e.indexOf("~")) {
            Ext.Array.splice(s, 0, 1);
        }
        t = s[0];
        t = this.rootFoldersByName[t] || this.mailFoldersByName[t] || t;
        s[0] = t;
        i = s.join("/");
        return i;
    },
    _normalizeName: function(e) {
        var t;
        if (e) {
            t = e.substring(0, 1).toUpperCase();
            t += e.substring(1, e.length).toLowerCase();
        } else {
            t = e;
        }
        return t;
    }
});

Ext.define("kerio.wm.view.mail.FolderContextMenu", {
    extend: "Ext.menu.Menu",
    alias: "widget.mailfoldercontextmenu",
    mixins: [ "kerio.wm.utils.ItemState" ],
    defaults: {
        scope: this
    },
    showAtModel: function(e, t, i) {
        var s = t.get("subType");
        var n = t.get("nestingLevel") <= 1;
        this.targetRecord = t;
        this._parentView = i;
        this.setState({
            isReadOnly: t.isReadOnlyFolder(),
            isDeleteItems: "FSubDeletedItems" === s && n,
            isInbox: "FSubInbox" === s && n,
            isDraft: "FSubDrafts" === s && n,
            isSpam: "FSubJunkEmail" === s && n,
            isSent: "FSubSentItems" === s && n,
            isRoot: t.isFoldersRoot(),
            isMyFolder: t.isPlaceMailbox(),
            isPublic: t.k_isPlacePublic(),
            isAdmin: t.k_isAccessAdmin(),
            isArchive: t.isPlaceArchive(),
            isFake: t.isFakeFolder(),
            isDeleted: t.isDeletedFolder(),
            isShared: t.k_isPlaceSubscribed(),
            isListingOnly: t.isAccessListingOnly()
        });
        if (this.hasVisibleButton()) {
            this.showAt(e);
            return !0;
        }
        return !1;
    },
    hasVisibleButton: function() {
        var e, t = this.items.items;
        for (e = 0; e < t.length; e++) {
            if (t[e].hidden === !1) {
                return !0;
            }
        }
        return !1;
    },
    itemStateSettings: {
        defaultState: {
            visible: !1
        }
    },
    items: [ {
        text: k_tr("New Folder", "folders"),
        itemId: "btnNewFolder",
        states: [ {
            settings: {
                isMyFolder: !0,
                isReadOnly: !1
            },
            state: {
                visible: !0
            }
        }, {
            settings: {
                isPublic: !0,
                isAdmin: !0
            },
            state: {
                visible: !0
            }
        }, {
            settings: {
                isShared: !0,
                isAdmin: !0,
                isRoot: !1
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        xtype: "menuseparator"
    }, {
        text: k_tr("Rename", "folders"),
        itemId: "btnRename",
        states: [ {
            settings: {
                isMyFolder: !0,
                isReadOnly: !1,
                isInbox: !1,
                isDeleteItems: !1,
                isSpam: !1,
                isSent: !1,
                isDraft: !1,
                isRoot: !1
            },
            state: {
                visible: !0
            }
        }, {
            settings: {
                isPublic: !0,
                isFake: !1,
                isAdmin: !0
            },
            state: {
                visible: !0
            }
        }, {
            settings: {
                isShared: !0
            },
            state: {
                visible: !1
            }
        }, {
            settings: {
                isArchive: !0,
                isRoot: !1,
                isFake: !1,
                isAdmin: !0
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        text: k_tr("Delete", "common"),
        itemId: "btnDelete",
        states: [ {
            settings: {
                isMyFolder: !0,
                isReadOnly: !1,
                isInbox: !1,
                isDeleteItems: !1,
                isSpam: !1,
                isSent: !1,
                isDraft: !1,
                isRoot: !1
            },
            state: {
                visible: !0
            }
        }, {
            settings: {
                isPublic: !0,
                isFake: !1,
                isAdmin: !0
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        xtype: "menuseparator"
    }, {
        text: k_tr("Mark All as Read", "folders"),
        itemId: "mailBtnMarkAllAsRead",
        states: [ {
            settings: {
                isReadOnly: !1,
                isRoot: !1
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        text: k_tr("Copy All Messages", "folders"),
        itemId: "mailBtnCopyAllMessages",
        states: [ {
            settings: {
                isListingOnly: !1,
                isRoot: !1
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        text: k_tr("Move All Messages", "folders"),
        itemId: "mailBtnMoveAllMessages",
        states: [ {
            settings: {
                isReadOnly: !1,
                isRoot: !1
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        text: k_tr("Delete All Messages", "folders"),
        itemId: "mailBtnClear",
        states: [ {
            settings: {
                isReadOnly: !1,
                isRoot: !1,
                isDeleteItems: !1
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        text: k_tr("Empty Trash", "folders"),
        itemId: "mailBtnEmpty",
        states: [ {
            settings: {
                isReadOnly: !1,
                isDeleteItems: !0
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        xtype: "menuseparator"
    }, {
        text: k_tr("Sharing", "folders"),
        itemId: "btnShare",
        states: [ {
            settings: {
                isMyFolder: !0,
                isRoot: !1,
                isListingOnly: !1
            },
            state: {
                visible: !0
            }
        }, {
            settings: {
                isPublic: !0,
                isAdmin: !0
            },
            state: {
                visible: !0
            }
        }, {
            settings: {
                isArchive: !0,
                isAdmin: !0,
                isFake: !0
            },
            state: {
                visible: !0
            }
        }, {
            settings: {
                isShared: !0,
                isFake: !1,
                isAdmin: !0
            },
            state: {
                visible: !0
            }
        } ]
    }, {
        text: k_tr("Hide", "folders"),
        itemId: "mailBtnHide",
        listeners: {
            click: function() {
                this.parentMenu.fireEvent("unsubscribe", this.parentMenu.targetRecord.data, this.parentMenu._parentView);
            }
        },
        states: [ {
            settings: {
                isShared: !0,
                isFake: !1,
                isListingOnly: !1
            },
            state: {
                visible: !0
            }
        } ]
    } ]
});

Ext.define("kerio.wm.selection.TreeSelectionModel", {
    extend: "Ext.selection.TreeModel",
    alias: "selection.treeselmodel",
    refresh: function() {
        this.autoselected = !1;
        this.callParent(arguments);
    },
    _findProximateNode: function(e) {
        var t, i, s, n = [], o = null, r = e.getId(), a = e.parentNode;
        if (!a) {
            return null;
        }
        s = a.getChildern();
        if (s.length > 1) {
            i = e.get("index");
            for (t = 0; t < s.length; t++) {
                if (s[t].getId() !== r) {
                    n.push(s[t]);
                }
            }
            i = i < n.length ? i : n.length - 1;
            o = this._findRecord(n[i]);
        }
        if (!o) {
            o = this._findRecord(a);
        }
        return o;
    },
    _findRecord: function(e) {
        if (e) {
            e = this.store.getById(e.getId());
            return e && e.isSelectable() ? e : null;
        } else {
            return null;
        }
    },
    selectByIdOrAuto: function(e) {
        var t = e ? this.store.getById(e) : void 0;
        if (t && t.isSelectable()) {
            this.select(t);
        } else {
            this.autoselect();
        }
    },
    autoselect: function(e) {
        var t, i = this.getLastSelected();
        this.autoselected = !0;
        if (i) {
            t = this._findRecord(i);
            if (!t) {
                t = this._findProximateNode(i);
            }
        }
        if (!t) {
            t = e || this.store.getAt(0);
        }
        this.select(t);
    },
    onUpdate: function(e) {
        var t, i = this, s = i.view;
        if (s && i.isSelected(e)) {
            t = i.store.indexOf(e);
            s.onRowSelect(t);
        }
    }
});

Ext.define("kerio.wm.view.FolderEditor", {
    alias: "widget.foldereditor",
    extend: "Ext.Editor",
    alignment: "tl-tl",
    shadow: !1,
    allowBlur: !1,
    completeOnEnter: !0,
    cancelOnEsc: !0,
    updateEl: !1,
    styles: !0,
    height: 18,
    field: {
        cls: "folderEditor",
        xtype: "textfield",
        maxLength: 96,
        enforceMaxLength: !0,
        selectOnFocus: !0
    }
});

Ext.define("kerio.wm.touchDevice.TouchAndHoldController", {
    requires: [ "kerio.wm.touchDevice.TouchController" ],
    constructor: function(e) {
        var t, i = e instanceof kerio.wm.view.mail.MailList || e instanceof kerio.wm.view.mail.SimpleMailList, s = e instanceof kerio.wm.view.FolderTree, n = e instanceof kerio.wm.view.calendar.RangeViewPanel;
        if (i || s) {
            t = e.getView().el.dom;
            this._touchAndHoldHandler = this._touchAndHoldFolderOrMail;
            this._showContextMenu = (s ? e.showContextMenu : this._fireItemContextMenu) || Ext.emptyFn;
        } else {
            if (n) {
                t = e.el.dom;
                this._touchAndHoldHandler = this._touchAndHoldCalendarContent;
            } else {
                return;
            }
        }
        e._touchAndHoldController = this;
        Ext.create("kerio.wm.touchDevice.TouchController", {
            k_element: t,
            k_onTouchStart: function(e) {
                e.k_deferId = Ext.Function.defer(this._touchAndHoldController._touchAndHoldHandler, 800, this, [ e ]);
            },
            k_onTouchMove: function(e) {
                clearTimeout(e.k_deferId);
            },
            k_onTouchEnd: function(e) {
                clearTimeout(e.k_deferId);
            },
            k_scope: e,
            k_preventDefault: !1
        });
    },
    _touchAndHoldFolderOrMail: function(e) {
        var t, i, s, n, o, r = 10;
        e.k_event.preventDefault();
        i = e.k_event.target;
        t = this.getView();
        while (i && "TR" !== i.tagName && r > 0) {
            r--;
            i = i.parentNode;
        }
        if (i && void 0 !== i.viewIndex) {
            s = i.viewIndex;
            n = t.getRecord(i);
            o = e.k_createExtEventFromTouch("click", !0);
            this._touchAndHoldController._showContextMenu.call(this, t, n, i, s, o);
        }
    },
    _touchAndHoldCalendarContent: function(e) {
        var t, i = e.k_createExtEventFromTouch("mousedown", !0), s = Ext.fly(e.k_event.target);
        i.button = 1;
        s = s.up(".calEvent");
        if (s) {
            t = s.$cache.events;
            if (t && t.contextmenu && t.contextmenu.length) {
                t = t.contextmenu[0];
                t.fn.call(t.scope, i);
            }
        } else {
            this._k_viewCls._k_onPanelMouseDown(i, e.k_event.target);
            i.type = "contextmenu";
            this._k_viewCls._k_openPanelContextMenu(i);
        }
    },
    _fireItemContextMenu: function(e, t, i, s, n) {
        if (e.onBeforeItemClick(t, i, s, n) === !1 || e.fireEvent("beforeitemclick", e, t, i, s, n) === !1 || e.onItemClick(t, i, s, n) === !1) {
            return !1;
        }
        this.fireEvent("itemcontextmenu", e, t, i, s, n);
    }
});

Ext.define("kerio.wm.view.TreeView", {
    extend: "Ext.tree.View",
    alias: "widget.wmtreeview",
    blockInitAdd: !0,
    rootVisible: !1,
    constructor: function(e) {
        this.addEvents("afteritemexpand");
        e = Ext.apply(e || {}, {
            toggleOnDblClick: !1,
            animate: !1,
            loadMask: !1
        });
        this.callParent(arguments);
        this.on({
            resize: this._onResize,
            refresh: this._onRefresh,
            itemupdate: this._onItemUpdate,
            scope: this
        });
    },
    _onResize: function(e, t, i, s) {
        this._adjustNodesWidth(t);
    },
    _onRefresh: function() {
        this._adjustNodesWidth(this.getWidth());
    },
    _adjustNodesWidth: function(e) {
        var t, i = this.getEl().query(".x-grid-row .x-grid-cell-first");
        for (t = 0; t < i.length; t++) {
            this._adjustNodeWidth(i[t], e);
        }
    },
    _adjustNodeWidth: function(e, t) {
        var i, s, n, o, r = this, a = 34, l = 3, d = 1, c = this.el.getHeight() < this.el.dom.scrollHeight, h = c ? Ext.getScrollbarSize().width : 0, u = r.panel && r.panel.columns && r.panel.columns[0].adjustMaxTextWidth;
        e = Ext.fly(e);
        n = e.down(".folderIndent").dom.clientWidth;
        o = e.down(".iconContainer").dom.clientWidth;
        i = e.down(".folderItem");
        s = t - a - n - o - l - d;
        s = u && u(s) || s;
        i.setStyle({
            "max-width": s - h + "px"
        });
    },
    onAdd: function(e, t, i) {
        if (!0 !== this.blockInitAdd) {
            this.callParent(arguments);
        }
        this._onResize(this, this.getWidth(), this.getHeight());
    },
    onUpdate: function(e, t, i) {
        var s = this.getNode(t);
        if (!0 !== this.blockInitAdd) {
            this.callParent(arguments);
            if (s) {
                this._adjustNodeWidth(Ext.fly(s).down(".x-grid-cell-first"), this.getWidth());
            }
        }
    },
    bindStore: function(e, t) {
        this.callParent(arguments);
        if (this.panel.store) {
            if (this.store && !this._eventAdded) {
                this._eventAdded = !0;
                this.panel.store.on({
                    beforeload: this.showLoading,
                    beforefillnode: this._onBeforeFillNode,
                    fillnode: this._onFillNode,
                    load: this.hideLoading,
                    scope: this
                });
            } else {
                if (!this.store && this._eventAdded) {
                    this.panel.store.un({
                        beforeload: this.showLoading,
                        beforefillnode: this._onBeforeFillNode,
                        fillnode: this._onFillNode,
                        load: this.hideLoading,
                        scope: this
                    });
                }
            }
        }
    },
    showLoading: function() {
        this.loadMask && this.loadMask.show();
    },
    hideLoading: function() {
        this.loadMask.hide();
    },
    _onBeforeFillNode: function() {
        this.blockInitAdd = !0;
    },
    _onFillNode: function() {
        this.blockInitAdd = !1;
        this.refresh();
    },
    getRowClass: function(e, t, i, s) {
        var n = [];
        if (e.isFakeFolder() && e.isPlaceMailbox() && 0 === t) {
            n.push("firstFolder");
        }
        if (e.isAccessListingOnly()) {
            n.push("listingOnly");
        }
        if (e.isFakeFolder()) {
            n.push("rootFolder");
            if ((e.k_isPlacePublic() || e.isPlaceArchive()) && !e.isAccessListingOnly()) {
                n.push("downIcon");
            }
        } else {
            if (e.isPlaceMailbox()) {
                if (e.isSharedByMe()) {
                    n.push("sharedByMe");
                }
            } else {
                if (e.k_isPlacePublic()) {
                    if (2 === e.get("depth")) {
                        n.push("rootPublicFolder");
                    } else {
                        n.push("publicFolder");
                    }
                }
                if (e.isAccessReadOnly()) {
                    n.push("readOnly");
                } else {
                    if (e.isAccessListingOnly()) {
                        n.push("subscribedRoot");
                        if (e.get("nestingLevel") > 2) {
                            n.push("unselectableSubFolder");
                        }
                    }
                }
            }
        }
        return n.join(" ");
    },
    afterRender: function() {
        this.callParent(arguments);
        this.loadMask = new Ext.LoadMask(this);
        if (this.panel.store && this.panel.store.isLoading()) {
            this.showLoading();
        }
    },
    onExpand: function(e) {
        var t, i, s, n = this, o = n.animQueue, r = e.getId();
        if (n.singleExpand) {
            n.ensureSingleExpand(e);
        }
        t = n.getAnimWrap(e);
        if (!t) {
            n.fireEvent("afteritemexpand", e);
            return;
        }
        i = t.animateEl;
        s = t.targetEl;
        i.stopAnimation();
        o[r] = !0;
        i.slideIn("t", {
            duration: n.expandDuration,
            listeners: {
                scope: n,
                lastframe: function() {
                    t.el.insertSibling(s.query(n.itemSelector), "before");
                    t.el.remove();
                    n.resetScrollers();
                    delete t.record.animWrap;
                    delete o[r];
                }
            }
        });
        t.isAnimating = !0;
    },
    collectData: function(e, t) {
        var i = this.callParent(arguments);
        i.fullWidth = this.panel.getWidth();
        return i;
    },
    _onItemUpdate: function(e, t, i) {
        this._adjustNodeWidth(i, this.getWidth());
    }
});

Ext.define("kerio.wm.view.FolderTreeColumn", {
    extend: "Ext.grid.column.Column",
    alias: "widget.foldertreecolumn",
    fixedIndent: 0,
    initComponent: function() {
        var e = this.renderer || this.defaultRenderer, t = this.scope || window, i = this;
        this.renderer = function(s, n, o, r, a, l, d) {
            var c, h, u, f, m, p, g = [], _ = Ext.String.format, k = o, v = Ext.baseCSSPrefix + "tree-", y = v + "expander", w = '<img src="{1}" class="{0}" style="{2}" />', E = "", x = v + "elbow-", b = e.apply(t, arguments), C = o.get("cls"), S = 34, I = 3, D = {};
            h = o.getDepth();
            D.FSubInbox = 1;
            D.FSubDeletedItems = 1;
            D.FSubDrafts = 1;
            D.FSubJunkEmail = 1;
            D.FSubSentItems = 1;
            while (k) {
                if (D[k.get("subType")] && 1 === k.getDepth()) {
                    u = !0;
                    break;
                }
                k = k.parentNode;
            }
            if (C) {
                n.tdCls += " " + C;
            }
            if (!u && h >= 2) {
                h--;
            }
            if (0 === h) {
                h++;
            }
            f = 10 * (h - 1) + 26;
            if (this.fixedIndent) {
                f = this.fixedIndent;
            }
            if (o.isExpandable() && !this.fixedIndent) {
                E = _(w, x + "end-plus " + y, Ext.BLANK_IMAGE_URL, "margin-left: " + (f - 21) + "px");
            }
            g[0] = b;
            g.unshift('<span class="folderIndent" style="width: ' + f + 'px;">' + E + "</span>");
            if (g[1]) {
                m = (g[1].match(/folderIcon visible/g) || []).length;
                p = d.getWidth() - S - f - 21 * m + (m > 1 ? 2 * (m - 1) : 0) - I;
                p = i.adjustMaxTextWidth && i.adjustMaxTextWidth(p) || p;
                c = g[1].indexOf('class="folderItem"') + 'class="folderItem"'.length;
                g[1] = [ g[1].slice(0, c), ' style="max-width: ' + p + 'px"', g[1].slice(c) ].join("");
            }
            return g.join("");
        };
        this.callParent(arguments);
    },
    defaultRenderer: function(e) {
        return e;
    }
});

Ext.define("kerio.wm.utils.PointingDevice", {
    singleton: !0,
    delayAfterScroll: 200,
    maxWheelDelta: 16,
    standardWheelDelta: 12,
    isResponsiveScrolling: !1,
    isScrollFiredByUser: !0,
    eventCounter: 0,
    constructor: function() {
        this._afterScrollTask = new Ext.util.DelayedTask(function() {
            this.isScrollFiredByUser = !0;
            this.eventCounter = 0;
        }, this);
    },
    _afterScrollTaskDelayed: function() {
        this._afterScrollTask.delay(this.delayAfterScroll);
    },
    _checkWheelDelta: function(e) {
        var t = e && e.browserEvent;
        if (this.isScrollFiredByUser && t) {
            this.isResponsiveScrolling = t.wheelDeltaX && Math.abs(t.wheelDeltaX) < this.standardWheelDelta || t.wheelDeltaY && Math.abs(t.wheelDeltaY) < this.standardWheelDelta;
        }
        this.eventCounter++;
        this.isScrollFiredByUser = !1;
        if (this.eventCounter > 1e4) {
            this._afterScrollTask();
        }
    },
    registerWheelScroller: function(e, t) {
        if (t && t.browserEvent) {
            this._checkWheelDelta(t);
        }
        e.on("mousewheel", this._checkWheelDelta, this);
        e.on("mousewheel", this._afterScrollTaskDelayed, this);
    }
});

Ext.define("kerio.wm.view.mail.MailListColumn", {
    extend: "Ext.grid.column.Column",
    alias: "widget.maillistcolumn",
    menuDisabled: !1,
    isOnlyIconColumn: !1,
    defaultWidth: 26,
    headerTooltip: !1,
    headerCls: !1,
    isDefaultDesc: !1,
    renderTpl: '<div id="{id}-titleEl" class="{headerCls}" <tpl if="values.headerTooltip">title="{headerTooltip}"</tpl>><span id="{id}-textEl" class="' + Ext.baseCSSPrefix + 'column-header-text">{text}</span></div>',
    constructor: function(e) {
        var t = Ext.baseCSSPrefix + "column-header-sort-", i = this;
        if (e.isDefaultDesc) {
            i.possibleSortStates = [ "Desc", "Asc" ];
        } else {
            i.possibleSortStates = [ "Asc", "Desc" ];
        }
        if (e.isOnlyIconColumn) {
            e.tdCls = e.cls = "onlyIconColumn";
        }
        if (!e.width && !e.flex) {
            e.width = this.defaultWidth;
        }
        if (!e.minWidth) {
            e.minWidth = this.defaultWidth;
        }
        i.callParent(arguments);
        i.setDataIndex(e.dataIndex);
        i.rendererFunction = i.renderer || i.defaultRenderer;
        i.tpl = Ext.create("Ext.XTemplate", "{[this.fn(out, values)]}", {
            fn: function(e, t) {
                e.push(i.rendererFunction(t));
                return e;
            },
            column: i
        });
        i.renderer = function(e, t, s) {
            return i.tpl.apply(Ext.apply({}, s.data, s.getAssociatedData()));
        };
        this.ascCls = t + "ASC";
        this.descCls = t + "DESC";
        this.nullCls = t + "null";
    },
    afterRender: function() {
        this.callParent(arguments);
        var e = this.getOwnerHeaderCt();
        if (!e.headerIsPrepare) {
            e.headerIsPrepare = !0;
            e.addListener("menucreate", function(e, t) {
                t.query(t.xtype)[0].addCls("withIcons");
                t.addCls("sortMenu withIcons");
            }, this);
        }
        this.on({
            element: "el",
            contextmenu: function(e, t) {
                this._showMenu(e);
            },
            scope: this
        });
    },
    _showMenu: function(e) {
        var t, i = this.getOwnerHeaderCt().getMenu(), s = i.down("#ascItem"), n = i.down("#descItem");
        i.activeHeader = this;
        t = this.sortable ? "enable" : "disable";
        if (s) {
            s[t]();
        }
        if (n) {
            n[t]();
        }
        i.showAt(e.getXY());
    },
    onElClick: function(e, t) {
        this.fireEvent("beforesort", this);
        this.callParent(arguments);
    },
    initRenderData: function() {
        var e = this, t = Ext.baseCSSPrefix + "column-header-inner";
        if (e.headerCls) {
            t = e.headerCls + " " + t;
        }
        Ext.applyIf(e.renderData, {
            text: e.text,
            menuDisabled: e.menuDisabled,
            headerCls: t,
            headerTooltip: e.headerTooltip
        });
        return e.callParent(arguments);
    },
    setSortState: function(e, t, i) {
        var s = this.getOwnerHeaderCt(), n = this.getSortParam(), o = this.sortState;
        if (o !== e && n) {
            if (e && !i) {
                this.fireEvent("changesort", this, n, e);
            }
            if (null === e) {
                this.removeCls([ this.ascCls, this.descCls ]);
                this.addCls(this.nullCls);
            } else {
                if ("DESC" === e || "Desc" === e) {
                    this.removeCls([ this.ascCls, this.nullCls ]);
                    this.addCls(this.descCls);
                } else {
                    if ("ASC" === e || "Asc" === e) {
                        this.removeCls([ this.descCls, this.nullCls ]);
                        this.addCls(this.ascCls);
                    }
                }
            }
            if (s && !this.triStateSort && !t) {
                s.clearOtherSortStates(this);
            }
            this.sortState = e;
            s.fireEvent("sortchange", s, this, e);
        }
    },
    getSortParam: function() {
        return this.sortIndex || this.dataIndex;
    },
    defaultRenderer: function(e) {
        return e[this.dataIndex];
    },
    setDataIndex: function(e) {
        this.dataIndex = e;
        if (this.dataIndexMap) {
            this._setCfg(this.dataIndexMap[e]);
        }
    },
    _setCfg: function(e) {
        if (e.sortIndex) {
            this.sortIndex = e.sortIndex;
        }
        if (e.headerText) {
            this.setText(e.headerText);
        }
    }
});

Ext.define("kerio.wm.view.sorting.SortProvider", {
    requires: [ "kerio.wm.SettingsManager" ],
    singleton: !0,
    _folderSorting: {},
    _settingsLoaded: !1,
    _defaultSorting: {},
    SETTINGS_SORT_KEY: "webmail.mailFoldersSort",
    constructor: function() {
        this._defaultSorting.FMail = {
            defaults: {
                property: "receiveDate",
                direction: "Desc",
                columnList: [ "to" ],
                address: "from"
            },
            drafts: {
                property: "modifiedDate",
                direction: "Desc",
                columnList: [ "from" ],
                address: "to"
            },
            sentItems: {
                property: "sendDate",
                direction: "Desc",
                columnList: [ "from" ],
                address: "to"
            }
        };
        this._defaultSorting.FNote = {
            defaults: {
                property: "createDate",
                direction: "Desc"
            }
        };
    },
    getSort: function(e, t) {
        var i, s;
        if (!this._settingsLoaded) {
            this._loadSortingFromSettings();
        }
        s = this._folderSorting[e.get("id")];
        if (s) {
            i = this.getDefaultSort(e, t);
            if (!s.columnList) {
                s.columnList = i.columnList;
            }
            if (!s.address) {
                s.address = i.address;
            }
        } else {
            s = this.getDefaultSort(e, t);
        }
        return s;
    },
    setSort: function(e, t, i) {
        var s = this.getSort(e, i), n = e.get("id");
        if (!t.property) {
            t.property = s.property;
        }
        if (!t.direction) {
            t.direction = s.direction;
        }
        if (!t.columnList) {
            t.columnList = s.columnList;
        }
        if (this.isSame(t, this.getDefaultSort(e, i))) {
            delete this._folderSorting[n];
        } else {
            this._folderSorting[n] = t;
        }
        this._saveSortingToSettings();
    },
    isSame: function(e, t) {
        var i;
        if (t.property === e.property && t.direction === e.direction && t.address === e.address) {
            if (!t.columnList && !e.columnList) {
                return !0;
            }
            if (t.columnList.length === e.columnList.length) {
                for (i = 0; i < e.columnList.length; i++) {
                    if (-1 === t.columnList.indexOf(e.columnList[i])) {
                        return !1;
                    }
                }
                return !0;
            }
        }
        return !1;
    },
    getDefaultSort: function(e, t) {
        t = t || "FMail";
        if (!e) {
            return this._defaultSorting[t].defaults;
        }
        if (e.isDraftFolder()) {
            return this._defaultSorting[t].drafts;
        }
        if (e.isSentItems()) {
            return this._defaultSorting[t].sentItems;
        }
        if ("FNote" === t) {
            return this._defaultSorting[t].defaults;
        }
        return this._defaultSorting[t].defaults;
    },
    getDateSortBy: function(e) {
        var t;
        if (e.isDraftFolder()) {
            t = "modifiedDate";
        } else {
            if (e.isSentItems()) {
                t = "sendDate";
            } else {
                t = "receiveDate";
            }
        }
        return t;
    },
    _loadSortingFromSettings: function() {
        var e, t, i, s = kerio.wm.SettingsManager.get(this.SETTINGS_SORT_KEY) || [];
        for (t = 0, i = s.length; i > t; t++) {
            e = s[t];
            this._folderSorting[e.id] = {
                property: e.columnName,
                direction: e.direction,
                columnList: e.columnList,
                address: e.address
            };
        }
        this._settingsLoaded = !0;
    },
    _saveSortingToSettings: function() {
        var e, t = this._folderSorting, i = [];
        for (e in t) {
            if (t.hasOwnProperty(e)) {
                i.push({
                    id: e,
                    columnName: t[e].property,
                    direction: t[e].direction,
                    address: t[e].address,
                    columnList: t[e].columnList
                });
            }
        }
        kerio.wm.SettingsManager.set(this.SETTINGS_SORT_KEY, i);
        kerio.wm.SettingsManager.save([ this.SETTINGS_SORT_KEY ]);
    }
});

Ext.define("kerio.wm.view.mail.MailListDrag", {
    extend: "Ext.view.DragZone",
    getDragText: function() {
        var e, t = this.dragData.records.length;
        if (t > 1) {
            return k_tr(" %1 [message|messages]", "mail", {
                k_args: [ t ],
                k_pluralityBy: t
            });
        } else {
            e = this.dragData.records[0].getDisplay("subject");
            if (0 === e.trim().length) {
                return kerio.wm.Constants.noSubject;
            } else {
                return e.length < 200 ? e : e.substring(0, 200);
            }
        }
    }
});

Ext.define("kerio.wm.selection.mail.RowSelectionModel", {
    extend: "kerio.wm.selection.RowSelectionModel",
    alias: "selection.mailrowselmodel",
    showFirst: !1,
    refresh: function() {
        var e, t, i, s, n = this, o = [], r = n.getSelection(), a = r.length, l = this.getLastFocused(), d = (this.store.currentPage - 1) * this.store.pageSize;
        for (e = 0; a > e; e++) {
            s = r[e];
            if (void 0 === i && this.isRecordInStoreFolder(s.get("folderId")) && this.isRecordOnCurrentPage(s)) {
                i = s.index - d;
            }
            s = this._findInStoreData(s);
            if (!this.pruneRemoved && s) {
                o.push(s);
            }
        }
        n.clearSelections();
        if (l) {
            l = this._findInStoreData(l);
            if (!l && 0 === o.length && this.autoselect) {
                if (i >= this._storeData().getCount()) {
                    i = this._storeData().getCount() - 1;
                }
                l = this._storeData().getAt(i);
            }
            if (l) {
                t = t || 0 === o.length;
                this.setLastFocused(l, !0);
                o.push(l);
            }
        }
        if (this.showFirst && 0 === o.length && this.store.getCount() > 0) {
            o.push(this._storeData().getAt(0));
            t = !0;
        }
        t = t || this._isSelectionChanged(r, o);
        if (o.length) {
            n.doSelect(o, !1, !0);
        }
        n.maybeFireSelectionChange(t);
    },
    setShowFirst: function(e) {
        this.showFirst = e;
    },
    onUpdate: function(e) {
        var t, i = this, s = i.view;
        if (s && i.isSelected(e)) {
            t = i.store.indexOf(e);
            s.onRowSelect(t);
            if (e === i.lastFocused) {
                s.onRowFocus(t, !0, !0);
            }
        }
    }
});

Ext.define("kerio.wm.view.mail.PagingToolbar", {
    extend: "Ext.toolbar.Paging",
    alias: "widget.mailpagingtoolbar",
    styles: !0,
    cls: "mailListPagingToolbar",
    displayInfo: !1,
    emptyMsg: k_tr("No messages", "mail"),
    nextText: !1,
    prevText: !1,
    lastText: !1,
    firstText: !1,
    beforePageText: k_tr("Displaying", "pagingToolbar"),
    addSortField: !0,
    onLoad: function() {
        var e, t, i, s = this;
        if (!s.rendered) {
            return;
        }
        e = s.getPageData();
        t = e.currentPage;
        i = e.pageCount;
        s.child("#first").setDisabled(1 === t);
        s.child("#prev").setDisabled(1 === t);
        s.child("#next").setDisabled(t === i || !i);
        s.child("#last").setDisabled(t === i || !i);
        s.updateInfo();
        s.fireEvent("change", s, e);
    },
    updateInfo: function() {
        var e, t, i = this, s = i._displayItem, n = i.store, o = i.getPageData();
        if (s) {
            e = n.getCount();
            if (0 === e) {
                t = i.emptyMsg;
            } else {
                t = k_tr("%1 - %2 of %3", "mailPagingToolbar", {
                    k_args: [ o.fromRecord, o.toRecord, o.total ]
                });
            }
            if (0 === e) {
                this._displayItem.addCls("noItems");
            } else {
                this._displayItem.removeCls("noItems");
            }
            s.setText(t);
        }
    },
    getPagingItems: function() {
        var e = this, t = [ "->", {
            itemId: "first",
            tooltip: e.firstText,
            overflowText: e.firstText,
            iconCls: Ext.baseCSSPrefix + "tbar-page-first",
            cls: "firstPageBtn",
            disabled: !0,
            handler: e.moveFirst,
            scope: e
        }, {
            itemId: "prev",
            tooltip: e.prevText,
            overflowText: e.prevText,
            iconCls: Ext.baseCSSPrefix + "tbar-page-prev",
            disabled: !0,
            handler: e.movePrevious,
            scope: e
        }, {
            xtype: "linkbutton",
            itemId: "displayItem",
            width: 190,
            listeners: {
                afterrender: function(e) {
                    e.btnEl.dom.removeAttribute("href");
                }
            }
        }, {
            itemId: "next",
            tooltip: e.nextText,
            overflowText: e.nextText,
            iconCls: Ext.baseCSSPrefix + "tbar-page-next",
            disabled: !0,
            handler: e.moveNext,
            scope: e
        }, {
            itemId: "last",
            tooltip: e.lastText,
            overflowText: e.lastText,
            iconCls: Ext.baseCSSPrefix + "tbar-page-last",
            cls: "lastPageBtn",
            disabled: !0,
            handler: e.moveLast,
            scope: e
        }, "->" ];
        if (this.addSortField) {
            t.push({
                xtype: "sortByField",
                itemId: "sortByField",
                hideLabel: !0,
                iconOnly: !0,
                menuModule: "mail",
                width: 20,
                height: 20,
                sortByText: k_tr("Sort by:", "mail")
            });
        }
        return t;
    },
    initComponent: function() {
        this.callParent(arguments);
        this._displayItem = this.query("#displayItem")[0];
        this._displayItem.on("click", this._onDisplayInfoClick, this);
    },
    _onDisplayInfoClick: function() {
        var e, t, i, s, n = this.getPageData(), o = n.pageCount, r = this.store.pageSize, a = n.total, l = n.currentPage, d = [];
        if (0 === a) {
            return;
        }
        for (s = 0; o > s; s++) {
            t = s + 1;
            d.push({
                text: s * r + 1 + " - " + Math.min(t * r, a),
                pageNum: t
            });
        }
        i = Ext.create("Ext.menu.Menu", {
            maxHeight: 196,
            items: d,
            layout: "auto",
            cls: "mailListPagingToolbarMenu",
            getLayout: function() {
                var e = this;
                if (!e.layout || !e.layout.isLayout) {
                    e.layout.overflowHandler = "None";
                    e.setLayout(Ext.layout.Layout.create(e.layout, "autocontainer"));
                }
                return e.layout;
            },
            listeners: {
                click: this._onGoToPageClick,
                hide: function(e) {
                    Ext.destroy(e);
                },
                afterrender: {
                    fn: function(e) {
                        e.body.scrollChildIntoView(e.items.getAt(e.items.getCount() - 1).getEl(), !1);
                        e.body.scrollChildIntoView(e.items.getAt(this.currentPage - 1).getEl());
                    },
                    scope: {
                        me: this,
                        currentPage: l
                    }
                },
                scope: this
            }
        });
        d = i.items;
        e = function(e) {
            if (e.activated && this.rendered) {
                this.body.scrollChildIntoView(e.getEl());
            }
        };
        for (s = 0; s < d.getCount(); s++) {
            d.getAt(s).on("activate", e, i);
        }
        i.items.getAt(l - 1).on("afterrender", function() {
            this.activate();
        }, i.items.getAt(l - 1));
        i.focusedItem = i.items.getAt(l - 1);
        i.activeItem = i.focusedItem;
        i.showBy(this._displayItem.getEl().down(".linkButton-inner"), "b-c", [ 0, -10 ]);
    },
    _onGoToPageClick: function(e, t) {
        var i = t.pageNum;
        if (this.fireEvent("beforechange", this, i) !== !1) {
            this.store.loadPage(i);
        }
        this.fireEvent("gotopageitemclick", this, e, t);
    },
    bindStore: function(e, t) {
        var i = this;
        if (!t && i.store) {
            if (e === i.store || !i.store.autoDestroy) {
                i.store.un("clear", i.onLoad, i);
                i.store.un("localremove", i.onLoad, i);
            }
        }
        if (e) {
            e = Ext.data.StoreManager.lookup(e);
            e.on({
                scope: i,
                clear: i.onLoad,
                localremove: i.onLoad
            });
        }
        i.callParent(arguments);
    }
});

Ext.define("kerio.wm.view.mail.MailListView", {
    extend: "Ext.view.View",
    alias: "widget.maillistview",
    itemSelector: "div.simple-item-list-row",
    overItemCls: "simple-item-list-row-over",
    selectedItemCls: "simple-item-list-row-selected",
    focusedItemCls: "simple-item-list-row-focused",
    trackOver: !0,
    hasFocusCls: "ownsFocus",
    constructor: function() {
        this.callParent(arguments);
        this._initUIUpdatesCache();
    },
    focusRow: function() {
        var e = this._uiUpdatesCache.focusRow;
        e.args = arguments;
        this._setTimeout(arguments.callee.$name, this._focusRowDelayed);
    },
    onUpdate: function(e, t, i, s) {
        var n, o;
        if (this.viewReady) {
            n = this._uiUpdatesCache.onUpdate;
            o = t.getId();
            if (n.idx.hasOwnProperty(o)) {
                n.args[n.args.length] = this._mergeUpdateArgs(n.args[n.idx[o]], arguments);
                n.args[n.idx[o]] = null;
            } else {
                n.args[n.args.length] = arguments;
            }
            n.idx[o] = n.args.length - 1;
            this._setTimeout(arguments.callee.$name, this._onUpdateUiDelayed);
        }
    },
    _focusRowDelayed: function() {
        var e = this._uiUpdatesCache.focusRow, t = Ext.view.Table.prototype.__focusRow || Ext.view.Table.prototype.focusRow;
        t.apply(this, e.args);
        this._clearCache("focusRow");
    },
    _onUpdateUiDelayed: function() {
        var e, t = this._uiUpdatesCache.onUpdate, i = t.args, s = new Array(i.length), n = 0, o = Ext.view.View.prototype.onUpdate;
        for (e = 0; e < i.length; e++) {
            if (null !== i[e]) {
                s[n] = i[e];
                n++;
            }
        }
        if (this.repaintView(n) && !0 !== this.blockRefresh) {
            this.onDataRefresh();
        } else {
            for (e = 0; n > e; e++) {
                o.apply(this, s[e]);
            }
        }
        this._clearCache("onUpdate");
    },
    _initUIUpdatesCache: function() {
        this._uiUpdatesCache = {
            onUpdate: this._getCacheDef(),
            focusRow: this._getCacheDef()
        };
    },
    _getCacheDef: function() {
        return {
            idx: {},
            args: [],
            tId: null
        };
    },
    _setTimeout: function(e, t, i) {
        var s = this._uiUpdatesCache[e];
        if (!s.tId) {
            s.tId = window.setTimeout(Ext.Function.bind(t, this, i || []), 1);
        }
    },
    _clearCache: function(e) {
        var t = this._uiUpdatesCache[e];
        window.clearTimeout(t.tId);
        t.idx = {};
        t.args = [];
        t.tId = null;
    },
    _mergeArray: function() {
        var e, t, i, s, n, o, r = [], a = {}, l = arguments.length, d = 0;
        for (e = 0; l > e; e++) {
            r = arguments[e];
            if (!Ext.isArray(r)) {
                continue;
            }
            for (o = 0, n = r.length; n > o; o++) {
                i = r[o];
                if (!a[i]) {
                    a[i] = d++;
                }
            }
        }
        s = new Array(d);
        for (t in a) {
            if (a.hasOwnProperty(t)) {
                d = a[t];
                s[d] = t;
            }
        }
        return s;
    },
    _mergeUpdateArgs: function(e, t) {
        t[3] = this._mergeArray(e[3], t[3]);
        return t;
    },
    repaintView: function(e) {
        return e > Math.max(this.getStore().getCount() / 3, 1);
    },
    onRowSelect: function() {
        Ext.view.Table.prototype.onRowSelect.apply(this, arguments);
    },
    onRowDeselect: function() {
        Ext.view.Table.prototype.onRowDeselect.apply(this, arguments);
    },
    onRowFocus: function() {
        Ext.view.Table.prototype.onRowFocus.apply(this, arguments);
    },
    addRowCls: function() {
        Ext.view.Table.prototype.addRowCls.apply(this, arguments);
    },
    removeRowCls: function() {
        Ext.view.Table.prototype.removeRowCls.apply(this, arguments);
    },
    afterRender: function() {
        this.callParent(arguments);
        this.getEl().addClsOnFocus(this.hasFocusCls);
        this._keyMap = new Ext.util.KeyMap({
            target: this.getEl(),
            binding: [ {
                key: "aA",
                ctrl: !0,
                fn: function(e, t) {
                    t.stopEvent();
                    this.selModel.selectAll();
                },
                scope: this
            } ]
        });
    },
    refresh: function() {
        var e, t = this.viewReady && this.getEl().hasCls(this.hasFocusCls);
        e = this.callParent(arguments);
        if (t) {
            this.focus();
        }
        return e;
    }
});

Ext.define("kerio.wm.model.SearchHintsModel", {
    extend: "kerio.wm.model.Model",
    fields: [ "id", "category", "display", {
        name: "cls",
        defaultValue: void 0
    }, "search" ]
});

Ext.define("kerio.wm.view.mail.PrintPreview", {
    singleton: !0,
    constructor: function() {
        this._printTpl = Ext.create("Ext.XTemplate", '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">', "<html>", "<style>{styleTag}</style>", "<style>", "body {margin: 0px; padding: 10px; font-size: 10pt; line-height: 1.4; background-color:white;}", ".printPreview .mailAttachments, .printPreview .mailDetailed * { font-size: 9pt;}", ".printPreview h1.mailSubject {font-size: 19pt;}", ".printPreview .mailBody {border-top: 1px solid gray; padding: 20px 0; margin: 20px 0;}", ".printPreview .mailFileText div {display: inline;	padding-right: 10px;}", ".printPreview a:hover,.printPreview a:visited,.printPreview a { color: black; text-decoration: none;}", "</style>", '<body class="printPreview">', '<h1 class="mailSubject">{[kerio.wm.utils.MailUtils.formatSubject(values._display_subject)]}</h1>', '<table class="mailDetailed">', "<tr><td>" + k_tr("From:", "mail") + '</td><td class="value">{[this.tpl.formatEmails(values._display_from)]}</td></tr>', '<tpl if="values.to.length &gt; 0">', "<tr><td>" + k_tr("To:", "mail") + '</td><td class="value">{[this.tpl.formatEmails(values._display_to)]}</td></tr>', "</tpl>", '<tpl if="values.cc.length &gt; 0">', "<tr><td>" + k_tr("Cc:", "mail") + '</td><td class="value">{[this.tpl.formatEmails(values._display_cc)]}</td></tr>', "</tpl>", '<tpl if="values.bcc.length &gt; 0">', "<tr><td>" + k_tr("Bcc:", "mail") + '</td><td class="value">{[this.tpl.formatEmails(values._display_bcc)]}</td></tr>', "</tpl>", "<tr><td>" + k_tr("Date:", "mail") + '</td><td class="value">{[this.tpl.formatDate(values.printDate)]}</td></tr>', "</table>", '<div class="mailBody">', "{body}", "</div>", '<div class="mailAttachments">{[this.tpl.formatAttachments(values._display_attachments)]}</div>', "</body>", "</html>", this);
    },
    tpl: {
        formatEmails: function(e) {
            if (!e || 0 === e.length) {
                return "";
            }
            var t, i, s = "";
            if (Ext.isEmpty(e)) {
                return kerio.wm.Constants.noRecipient;
            }
            if (Ext.isArray(e)) {
                i = e.length;
                for (t = 0; i > t; t++) {
                    if (t > 0) {
                        s += ", ";
                    }
                    s += kerio.wm.utils.MailUtils.formatEmail(e[t], !0);
                }
                return s;
            }
            if (Ext.isObject(e)) {
                return kerio.wm.utils.MailUtils.formatEmail(e, !0);
            }
            return e;
        },
        formatAttachments: function(e) {
            var t, i = "";
            if (e && e.length > 0) {
                i += "<div><strong>" + k_tr("Attachments:", "mail") + "</strong></div>";
                i += "<ul>";
                for (t = 0; t < e.length; t++) {
                    i += "<li>" + e[t].name + "</li>";
                }
                i += "</ul>";
            }
            return i;
        },
        formatDate: function(e) {
            return Ext.Date.format(e, Ext.Date.patterns.dateAndTime);
        }
    },
    open: function(e) {
        var t = kerio.wm.Locations.openInNewWindow("", "printPreview");
        this.showLoading();
        kerio.wm.model.mail.MailModel.load(e, {
            scope: {
                me: this,
                printWindow: t
            },
            success: this._doOpenPrint,
            failure: function() {
                this.printWindow.close();
            }
        });
    },
    openWithModel: function(e, t) {
        this._doOpenPrint(e, t);
    },
    showLoading: function() {
        if (!this.loadingMask) {
            this.loadingMask = kerio.wm.view.LoadMask.makeMask(k_tr("Loading…", "common"), "mailPrintMask");
        }
        this.loadingMask.show();
    },
    hideLoading: function() {
        kerio.wm.view.LoadMask.hideMask(this.loadingMask);
    },
    _doOpenPrint: function(e, t) {
        var i, s = this.me, n = e.data, o = this.printWindow;
        s.hideLoading();
        if (t && t.innerHTML) {
            n.styleTag = t.innerHTML;
        } else {
            if (n.css && n.css.length) {
                n.styleTag = n.css;
            } else {
                n.styleTag = "";
            }
        }
        i = kerio.wm.store.GlobalFolderStore.guidToFolderDataMapping[n.folderId];
        if (i && "FSubSentItems" === i.subType) {
            n.printDate = n.sendDate;
        } else {
            n.printDate = n.receiveDate;
        }
        if (o) {
            kerio.wm.AppInterface.openMailPrintWindow({
                defaultFn: function(e, t) {
                    try {
                        e.document.open();
                        e.document.write(this.me._printTpl.apply(t));
                        e.document.close();
                        Ext.defer(function() {
                            this.print();
                        }, 100, e);
                    } catch (i) {}
                },
                scope: this,
                args: [ o, n ]
            });
        }
    }
});

Ext.define("kerio.wm.view.mail.MailContextMenu", {
    extend: "Ext.menu.Menu",
    alias: "widget.mailMenu",
    mixins: [ "kerio.wm.utils.ItemState" ],
    itemStateSettings: {
        defaultState: {
            visible: !1,
            isChatUser: !1
        },
        alternativeState: {
            visible: !0
        }
    },
    constructor: function() {
        this.items = [ {
            text: k_tr("Reply", "mail"),
            itemId: "btnReply",
            states: [ {
                settings: {
                    containsDraft: !1,
                    multiselect: !1
                }
            } ]
        }, {
            text: k_tr("Reply All", "mail"),
            itemId: "btnReplyAll",
            states: [ {
                settings: {
                    containsDraft: !1,
                    multiselect: !1
                }
            } ]
        }, {
            text: k_tr("Reply in chat", "mail", {
                k_comment: ""
            }),
            itemId: "btnReplyByMessage",
            states: [ {
                settings: {
                    containsDraft: !1,
                    multiselect: !1,
                    isChatUser: !0
                }
            } ]
        }, {
            text: k_tr("Forward", "mail"),
            itemId: "btnForward",
            states: [ {
                settings: {
                    containsDraft: !1,
                    multiselect: !1
                }
            } ]
        }, {
            text: k_tr("Forward as Attachment", "mail"),
            itemId: "btnSendSourceAsAttachment"
        }, {
            text: k_tr("Open", "mail"),
            itemId: "btnOpen",
            states: [ {
                settings: {
                    containsDraft: !0,
                    containsReadOnly: !1,
                    multiselect: !1
                }
            } ]
        }, {
            text: k_tr("Edit as New", "mail"),
            itemId: "btnEditItem",
            states: [ {
                settings: {
                    multiselect: !1
                }
            } ]
        }, {
            text: k_tr("Print", "mail"),
            itemId: "btnPrint",
            states: [ {
                settings: {
                    multiselect: !1
                }
            } ]
        }, {
            xtype: "menuseparator",
            states: [ {
                settings: {
                    multiselect: !1
                }
            } ]
        }, {
            text: k_tr("Mark as Read", "mail"),
            itemId: "btnMarkAsRead",
            states: [ {
                settings: {
                    containsUnseen: !0,
                    containsReadOnly: !1
                }
            } ]
        }, {
            text: k_tr("Mark as Unread", "mail"),
            itemId: "btnMarkAsUnread",
            states: [ {
                settings: {
                    containsSeen: !0,
                    containsReadOnly: !1
                }
            } ]
        }, {
            text: k_tr("Flag", "mail"),
            itemId: "btnMarkAsFlagged",
            states: [ {
                settings: {
                    containsUnflagged: !0,
                    containsReadOnly: !1
                }
            } ]
        }, {
            text: k_tr("Unflag", "mail"),
            itemId: "btnUnmarkAsFlagged",
            states: [ {
                settings: {
                    containsFlagged: !0,
                    containsReadOnly: !1
                }
            } ]
        }, {
            text: k_tr("Spam", "mail"),
            itemId: "btnSpam",
            states: [ {
                settings: {
                    containsDraft: !1,
                    containsNotSpam: !0,
                    containsReadOnly: !1
                },
                state: {
                    visible: kerio.wm.Constants.IS_SPAM_LERNING_ENABLED
                }
            } ]
        }, {
            text: k_tr("Not Spam", "mail"),
            itemId: "btnNotSpam",
            states: [ {
                settings: {
                    containsDraft: !1,
                    containsSpam: !0,
                    containsReadOnly: !1
                },
                state: {
                    visible: kerio.wm.Constants.IS_SPAM_LERNING_ENABLED
                }
            } ]
        }, {
            text: k_tr("Delete", "common"),
            itemId: "btnRemoveItem",
            states: [ {
                settings: {
                    containsReadOnly: !1
                }
            } ]
        }, {
            text: k_tr("Move", "mail"),
            itemId: "btnMove",
            states: [ {
                settings: {
                    containsReadOnly: !1,
                    singleFolder: !0
                }
            } ]
        }, {
            xtype: "menuseparator",
            states: [ {
                settings: {
                    multiselect: !1,
                    containsReadOnly: !1
                }
            } ]
        }, {
            text: k_tr("View Source", "common"),
            itemId: "btnViewSource",
            states: [ {
                settings: {
                    multiselect: !1
                }
            } ]
        } ];
        this.callParent(arguments);
    }
});

Ext.define("kerio.wm.view.settings.filtersNew.FilterSaveHelper", {
    singleton: !0,
    loadFilters: function(e) {
        e.success = Ext.Function.createInterceptor(e.success, function(e, t) {
            if (e.filters.length) {
                this._firstFilterId = e.filters[0].id;
            }
        }, this);
        kerio.api.Filters.get(e);
    },
    saveAllFilters: function(e, t, i) {
        kerio.api.Filters.set({
            currentDataStamp: e,
            filters: t
        }, this._getSaveSettings(i));
    },
    saveSimpleFilter: function(e, t, i, s) {
        if (!s) {
            this.loadFilters({
                success: function(e, i) {
                    var s = i.settings.settings, n = e.dataStamp;
                    this._onSaveSimpleFilter(n, t, s, e.filters);
                },
                scope: this,
                settings: i
            });
        } else {
            this._onSaveSimpleFilter(e, t, i, s);
        }
    },
    _onSaveSimpleFilter: function(e, t, i, s) {
        var n;
        if (!t.id || "" === s[0].id) {
            delete t.isNew;
            s.unshift(t);
        } else {
            for (n = 0; n < s.length; n++) {
                if (s[n].id === t.id) {
                    s[n] = t;
                    break;
                }
            }
        }
        this._fixEmptyDescription(t);
        kerio.api.Filters.set({
            currentDataStamp: e,
            filters: s
        }, this._getSaveSettings(i));
    },
    saveSieveFilter: function(e, t, i) {
        this._fixEmptyDescription(t);
        kerio.api.Filters.setById({
            currentDataStamp: e,
            rule: t
        }, i);
    },
    _fixEmptyDescription: function(e) {
        if (!e.description || "" === e.description.trim()) {
            e.description = k_tr("Unnamed rule", "Filters");
        }
    },
    getFirstFilterId: function() {
        return this._firstFilterId;
    },
    _getSaveSettings: function(e) {
        if (void 0 !== this._firstFilterId) {
            return e;
        }
        this._settings = e;
        e._successBackup = e.success;
        e.success = Ext.bind(function(e, t) {
            var i = this._settings;
            this._args = arguments;
            i.success = i._successBackup;
            delete i._successBackup;
            this.loadFilters({
                success: function() {
                    var e = this._settings, t = this._args;
                    delete this._settings;
                    delete this._args;
                    Ext.callback(e.success, e.scope, t);
                },
                failure: function() {
                    var e = this._settings, t = this._args;
                    delete this._settings;
                    delete this._args;
                    Ext.callback(e.failure, e.scope, t);
                },
                scope: this
            });
        }, this);
        return e;
    },
    processEmailValue: function(e) {
        return this.splitByCommaAndTrim(e.replace(/;/g, ","));
    },
    processSubjectValue: function(e) {
        return this.splitByCommaAndTrim(e);
    },
    splitByCommaAndTrim: function(e) {
        var t, i;
        i = e.split(",");
        for (t = 0; t < i.length; t++) {
            i[t] = i[t].trim();
        }
        return i;
    }
});

Ext.define("kerio.wm.utils.MailtoParser", {
    singleton: !0,
    parse: function(e) {
        if (e.length < 8 || "mailto:" !== e.substring(0, 7)) {
            return !1;
        }
        e = e.substring(7);
        var t, i, s, n, o, r = {};
        i = e;
        o = i.indexOf("?");
        if (-1 !== o) {
            if (o > 0) {
                r.to = i.substring(0, o);
            }
            i = i.substring(o + 1);
            s = i.split(/&amp;|&/);
            for (t = 0; t < s.length; t++) {
                o = s[t].indexOf("=");
                if (-1 !== o) {
                    n = s[t].substring(0, o);
                    if ("to" === n && r.to && r.to.length > 0) {
                        r.to += ", " + s[t].substring(o + 1);
                    } else {
                        r[n] = s[t].substring(o + 1);
                    }
                }
            }
        } else {
            r.to = e;
        }
        for (t in r) {
            if (r.hasOwnProperty(t)) {
                try {
                    r[t] = window.decodeURIComponent(r[t]);
                } catch (a) {}
            }
        }
        return r;
    }
});

Ext.define("kerio.wm.view.LoadMask", {
    singleton: !0,
    show: function(e) {
        if (!this.mask || this.mask.msg !== e) {
            this.mask = this.makeMask(e);
        }
        this.mask.show();
    },
    hide: function() {
        this.hideMask(this.mask);
    },
    makeMask: function(e, t) {
        return new Ext.LoadMask(Ext.ComponentQuery.query("#mainView")[0], {
            msg: e,
            cls: "fullscreen-mask " + t
        });
    },
    hideMask: function(e) {
        if (e && e.isVisible()) {
            e.hide();
        }
    }
});

Ext.define("kerio.wm.utils.AggregateOperation", {
    constructor: function(e) {
        this.config = e;
        this.timeout = e.timeout || 100;
        this.maxTimeout = e.maxTimeout || 1e3;
        this.runTask = new Ext.util.DelayedTask(this._run, this);
    },
    _createOperation: function() {
        return {
            add: this.config.add,
            run: this.config.run,
            hasOperations: this.config.hasOperations
        };
    },
    enforceSend: function() {
        this.runTask.cancel();
        if (this.initialized) {
            this.operation.run();
        }
        this.initialized = !1;
    },
    hasOperations: function() {
        return this.operation.hasOperations();
    },
    add: function() {
        var e = kerio.wm.getCurrentDate().getTime();
        if (!this.initialized) {
            this.operation = this._createOperation();
            this.initTime = e;
            this.initialized = !0;
        }
        this.operation.add.apply(this.operation, arguments);
        this.lastTime = e;
        if (kerio.wm.isInWindow) {
            this.operation.run();
            this.initialized = !1;
        } else {
            this.runTask.delay(this.timeout);
        }
    },
    _run: function() {
        var e = kerio.wm.getCurrentDate().getTime();
        if (e > this.lastTime + this.timeout || e > this.initTime + this.maxTimeout) {
            this.operation.run();
            this.initialized = !1;
        } else {
            this.runTask.delay(this.timeout);
        }
    }
});

Ext.define("kerio.wm.utils.HTMLParser", {
    singleton: !0,
    URL_REGEX: new RegExp("(?:(?:(?:(?:http)|(?:https)|(?:ftp)|(?:m-files)):\\/\\/(?:(?:[a-zA-Z0-9][a-zA-Z0-9-:@]*(?:\\.[a-zA-Z0-9][a-zA-Z0-9-]*)*)|(?:[1-9][0-9]{0,2}(\\.[1-9][0-9]{0,2}){3})))|(?:www\\.(?:[a-zA-Z][a-zA-Z0-9-]*(?:\\.[a-zA-Z][a-zA-Z0-9-]*)+)))(?::[0-9]+)?(?:(?:\\/(?:[a-Ž0-9\\-\\._~:@!$&\\'\\*\\+,;=]|(?:%[0-9A-F]{2}))*(?:\\((?:[a-Ž0-9\\-\\._~:@!$&\\'\\*\\+,;=]|(?:%[0-9A-F]{2}))*\\))*(?:[a-Ž0-9\\-\\._~:@!$&\\'\\*\\+,;=]|(?:%[0-9A-F]{2}))*)*(?:\\?(?:(?:[a-Ž0-9\\-\\._~:@!$&\\'\\(\\)*+,;=\\/]|(?:%[0-9A-F]{2})))*)?(?:#(?:(?:[a-Ž0-9\\-\\._~:@!$&\\'\\(\\)*+,;=\\/?]|(?:%[0-9A-F]{2})))*)?)?", "gm"),
    LOCAL_PART_CHARS: new RegExp('[^()<>@,;:\\\\/"\\[\\]\\s\\x00-\\x25]', "gm"),
    DOMAIN_REGEX: new RegExp("(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]?[a-zA-Z0-9])*(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]?[a-zA-Z0-9])*)*)|(?:[1-9][0-9]{0,2}(?:\\.[1-9][0-9]{0,2}){3}))[A-Za-z0-9]", "gm"),
    ATTRIBUTES_REGEX: new RegExp("([^\\s>=]+)(?:\\s*=\\s*(?:(?:\"([^\"]+)\")|(?:'([^']+)')|(?:([^\"'][^\\s>]*)[\\s>])))?", "gm"),
    isWhitespace: function(e) {
        return " " === e || "	" === e || "\n" === e || "	" === e || "\x0B" === e || "\f" === e || "\r" === e;
    },
    parseTagAttributes: function(e) {
        var t, i, s, n, o = 0, r = {};
        if ("<" === e.charAt(0)) {
            o++;
        }
        while (o < e.length && !kerio.wm.utils.HTMLParser.isWhitespace(e.charAt(o))) {
            o++;
        }
        if (o >= e.length) {
            return r;
        }
        t = e.length - 1;
        if (">" === e.charAt(t)) {
            t--;
        }
        if ("/" === e.charAt(t)) {
            t--;
        }
        while (t > 0 && kerio.wm.utils.HTMLParser.isWhitespace(e.charAt(t))) {
            t--;
        }
        if (0 === t) {
            return r;
        }
        t++;
        this.ATTRIBUTES_REGEX.lastIndex = o;
        while (null !== (i = this.ATTRIBUTES_REGEX.exec(e))) {
            if (i.index >= t) {
                break;
            }
            s = !1;
            for (n = 2; n < i.length; n++) {
                if (i[n]) {
                    r[i[1].toLowerCase()] = i[n];
                    s = !0;
                    break;
                }
            }
            if (!s) {
                r[i[1].toLowerCase()] = null;
            }
        }
        return r;
    },
    parseUrl: function(e) {
        this.URL_REGEX.lastIndex = 0;
        var t, i = [];
        e = e.replace(/&gt;/g, ">   ");
        e = e.replace(/&lt;/g, "   <");
        while (null !== (t = this.URL_REGEX.exec(e))) {
            i.push({
                type: "url",
                index: t.index,
                str: t[0]
            });
        }
        return i;
    },
    parseMailAddress: function(e) {
        var t, i, s = 0, n = 0, o = [];
        while (-1 !== (s = e.indexOf("@", s))) {
            if (s > n && s + 1 < e.length && "." !== e.charAt(s - 1)) {
                t = s - 1;
                while (t >= n && this.LOCAL_PART_CHARS.test(e.charAt(t))) {
                    t--;
                    this.LOCAL_PART_CHARS.lastIndex = 0;
                }
                t++;
                if (s > t) {
                    this.DOMAIN_REGEX.lastIndex = s + 1;
                    i = this.DOMAIN_REGEX.exec(e);
                    if (i && i[0] === e.substring(s + 1, s + 1 + i[0].length)) {
                        o.push({
                            type: "mail",
                            index: t,
                            str: e.substring(t, s) + "@" + i[0]
                        });
                        s += i[0].length;
                    }
                }
            }
            s++;
            n = s;
        }
        return o;
    }
});

Ext.define("kerio.wm.utils.HTMLConstants", {
    singleton: !0,
    ALLOWED_ELEMENTS: {
        blockquote: 1,
        center: 1,
        dir: 1,
        div: 1,
        dl: 1,
        fieldset: 1,
        form: 1,
        h1: 1,
        h2: 1,
        h3: 1,
        h4: 1,
        h5: 1,
        h6: 1,
        hr: 1,
        isindex: 1,
        ol: 1,
        p: 1,
        pre: 1,
        table: 1,
        ul: 1,
        a: 1,
        abbr: 1,
        acronym: 1,
        address: 1,
        area: 1,
        b: 1,
        bdo: 1,
        big: 1,
        br: 1,
        caption: 1,
        cite: 1,
        code: 1,
        col: 1,
        colgroup: 1,
        dd: 1,
        dfn: 1,
        em: 1,
        i: 1,
        img: 1,
        label: 1,
        legend: 1,
        li: 1,
        map: 1,
        q: 1,
        small: 1,
        span: 1,
        strong: 1,
        strike: 1,
        s: 1,
        sub: 1,
        sup: 1,
        tbody: 1,
        td: 1,
        tfoot: 1,
        th: 1,
        thead: 1,
        tr: 1,
        tt: 1,
        u: 1
    },
    BLOK_ELEMENTS: {
        address: 1,
        blockquote: 1,
        center: 1,
        dir: 1,
        div: 1,
        dl: 1,
        fieldset: 1,
        form: 1,
        h1: 1,
        h2: 1,
        h3: 1,
        h4: 1,
        h5: 1,
        h6: 1,
        hr: 1,
        isindex: 1,
        ol: 1,
        p: 1,
        pre: 1,
        table: 1,
        ul: 1
    },
    SELF_VISIBLE_ELEMENTS: {
        img: 1,
        hr: 1
    },
    SELF_CONTENT_ELEMENTS: {
        br: 1,
        img: 1,
        hr: 1,
        td: 1,
        th: 1,
        area: 1,
        col: 1
    },
    ALLOWED_ATTRIBUTES: {
        align: 1,
        alt: 1,
        background: 1,
        bgcolor: 1,
        border: 1,
        cellspacing: 1,
        cellpadding: 1,
        "class": 1,
        clear: 1,
        color: 1,
        colspan: 1,
        content: 1,
        face: 1,
        height: 1,
        hspace: 1,
        href: 1,
        "http-equiv": 1,
        id: 1,
        leftmargin: 1,
        name: 1,
        nowrap: 1,
        rowspan: 1,
        size: 1,
        src: 1,
        style: 1,
        text: 1,
        title: 1,
        topmargin: 1,
        type: 1,
        valign: 1,
        vspace: 1,
        width: 1,
        shape: 1,
        target: 1,
        coords: 1,
        usemap: 1
    },
    IGNORE_CONTENT_ELEMENTS: {
        style: 1,
        script: 1
    },
    IGNORE_TEXT_CONTENT_ELEMENTS: {
        title: 1
    },
    SELF_CLOSING_TAGS: {
        area: 1,
        base: 1,
        br: 1,
        col: 1,
        hr: 1,
        img: 1,
        input: 1,
        link: 1,
        meta: 1,
        param: 1
    },
    DO_NOT_CLOSE_WITH_OTHER_ELEMENT: {
        table: 1
    },
    URL_PATTERN: new RegExp("^(http|ftp|https|m-files)://", "i"),
    URL_WITH_DOMAIN: new RegExp("^(?:http|ftp|https|m-files)://[^/]+", "i"),
    DATA_IMAGE_PATTERN: new RegExp("^data:image", "i"),
    SCRPIT_IN_URL_REPLACE_PATTERN: new RegExp("S\\s*C\\s*R\\s*I\\s*P\\s*T\\s*:", "i")
});

Ext.define("kerio.wm.utils.URLFilter", {
    singleton: !0,
    requires: [ "kerio.wm.utils.HTMLConstants" ],
    decodeEntities: function(e) {
        return e.replace(/&#58;/gm, ":").replace(/&#47;/gm, "/");
    },
    filter: function(e, t, i) {
        e = this.decodeEntities(e);
        if (i && i.map[e]) {
            i.used[e] = 1;
            return i.map[e];
        }
        kerio.wm.utils.HTMLConstants.URL_PATTERN.lastIndex = 0;
        kerio.wm.utils.HTMLConstants.DATA_IMAGE_PATTERN.lastIndex = 0;
        kerio.wm.utils.HTMLConstants.SCRPIT_IN_URL_REPLACE_PATTERN.lastIndex = 0;
        if (t && t.length > 0 && e.length > 0 && !kerio.wm.utils.HTMLConstants.DATA_IMAGE_PATTERN.test(e) && !kerio.wm.utils.HTMLConstants.URL_PATTERN.test(e) && "MAILTO:" !== e.substring(0, 7).toUpperCase()) {
            if ("/" === e.charAt(0)) {
                kerio.wm.utils.HTMLConstants.URL_WITH_DOMAIN.lastIndex = 0;
                var s = kerio.wm.utils.HTMLConstants.URL_WITH_DOMAIN.exec(t);
                if (s) {
                    e = s[0] + e;
                }
            } else {
                if ("/" === t.charAt(t.length - 1)) {
                    e = t + e;
                } else {
                    e = t + "/" + e;
                }
            }
        }
        if (kerio.wm.Constants.URL_PREFIX_REGEXP.test(e) === !1 && "#" !== e[0]) {
            e = kerio.wm.Constants.URL_PREFIX + e;
        }
        return e.replace(kerio.wm.utils.HTMLConstants.SCRPIT_IN_URL_REPLACE_PATTERN, "*Removed*By*KCc*");
    },
    isExternal: function(e) {
        kerio.wm.utils.HTMLConstants.URL_PATTERN.lastIndex = 0;
        return kerio.wm.utils.HTMLConstants.URL_PATTERN.test(e);
    }
});

Ext.define("kerio.wm.utils.CSSProcessor", {
    requires: [ "kerio.wm.utils.URLFilter" ],
    statics: {
        CSS_URL_REGEX: new RegExp("url\\((?:(?:\"([^\"]+)\")|(?:'([^']+)')|(?:([^\"'][^\\s>]*)))\\)", "gm"),
        CSS_PROPERTY_NAME_REGEX: new RegExp("^\\-?[_a-z][_a-z0-9\\-]*", "gmi"),
        QUOTATION_REGEX: new RegExp("^&quot;.+&quot;$"),
        APOSTROF_REGEX: new RegExp("^&#39;.+&#39;$"),
        BANED_CSS_DEFINITINS: {
            position: "absolute"
        },
        BANED_CSS_DEFINITINS_FOR_BODY: {
            position: "absolute",
            height: null
        },
        parseUrl: function(e) {
            this.CSS_URL_REGEX.lastIndex = 0;
            var t, i, s, n = [];
            while (null !== (t = this.CSS_URL_REGEX.exec(e))) {
                for (i = 1; i < t.length; i++) {
                    if (t[i]) {
                        s = t[i];
                        if (this.QUOTATION_REGEX.test(s)) {
                            s = s.substring(6, s.length - 6);
                        }
                        if (this.APOSTROF_REGEX.test(s)) {
                            s = s.substring(5, s.length - 5);
                        }
                        n.push(s);
                        break;
                    }
                }
            }
            if (n.length > 0) {
                return n;
            } else {
                return !1;
            }
        },
        applyUrlRemap: function(e, t, i) {
            var s, n, o, r = kerio.wm.utils.CSSProcessor.parseUrl(e), a = 0;
            if (r) {
                for (n = 0; n < r.length; n++) {
                    s = kerio.wm.utils.URLFilter.filter(r[n], t, i);
                    if (s && -1 !== (o = e.indexOf(r[n], a))) {
                        e = e.substring(0, o) + s + e.substring(o + r[n].length);
                    }
                    a = o + r[n].length;
                }
            }
            return e;
        },
        _isBanedStyle: function(e, t, i) {
            var s = i ? this.BANED_CSS_DEFINITINS_FOR_BODY : this.BANED_CSS_DEFINITINS;
            e = e.toLowerCase();
            if (void 0 !== s[e]) {
                t = t.toLowerCase();
                if (null === s[e] || s[e] === t) {
                    return !0;
                }
            }
            return !1;
        },
        filterCssDefinitions: function(e, t) {
            var i, s, n = 0, o = "", r = this.CSS_PROPERTY_NAME_REGEX, a = function() {
                while (n < e.length && /\s/.test(e.charAt(n))) {
                    n++;
                }
            }, l = function() {
                var t = r.exec(e.substring(n));
                r.lastIndex = 0;
                if (t && t.length > 0) {
                    n += t[0].length;
                    return t[0];
                } else {
                    return !1;
                }
            }, d = function() {
                var t, i = n;
                while (i < e.length && ";" !== e.charAt(i)) {
                    if ("&" === e.charAt(i)) {
                        while (i < e.length && ";" !== e.charAt(i)) {
                            i++;
                        }
                    }
                    i++;
                }
                if (i > n) {
                    t = e.substring(n, i);
                    n = i;
                    return t;
                } else {
                    return !1;
                }
            };
            while (n < e.length) {
                a();
                i = l();
                if (i !== !1) {
                    a();
                    if (":" === e.charAt(n)) {
                        n++;
                        a();
                        s = d();
                        if (s !== !1) {
                            if (!this._isBanedStyle(i, s, t)) {
                                o += i + ":" + s + ";";
                            }
                        }
                        a();
                        if (";" === e.charAt(n)) {
                            n++;
                        }
                    }
                } else {
                    n++;
                }
            }
            return o;
        }
    },
    constructor: function() {
        this.definitions = [];
    },
    getAll: function() {
        return this.definitions;
    },
    filterComments: function(e) {
        var t, i, s = 0, n = "";
        while (s < e.length) {
            t = e.indexOf("//", s);
            i = e.indexOf("/*", s);
            if (-1 !== t && (-1 === i || i > t)) {
                n += e.substring(s, t);
                s = e.indexOf("\n", t);
                if (-1 === s) {
                    break;
                }
                s++;
            } else {
                if (-1 !== i) {
                    n += e.substring(s, i);
                    s = e.indexOf("*/", i + 2);
                    if (-1 === s) {
                        break;
                    }
                    s += 2;
                } else {
                    n += e.substring(s);
                    break;
                }
            }
        }
        return n.replace(/(<!--)|(-->)/gm, "");
    },
    processSelectors: function(e) {
        var t, i, s = [];
        e = e.split(",");
        for (i = 0; i < e.length; i++) {
            t = e[i];
            t = t.trim();
            if (t.length > 0 && "@" !== t.charAt(0)) {
                s.push(t);
            }
        }
        return s;
    },
    addGeneratedStyle: function(e, t) {
        this.generatedSelectors = this.generatedSelectors || {};
        if (!this.generatedSelectors[e]) {
            this.generatedSelectors[e] = !0;
            this.addCssText(e + " {" + t + "}");
        }
    },
    findEndOfCss: function(e, t) {
        return kerio.wm.utils.Utils.findEndCharInString(e, t, "{", "}");
    },
    addCssText: function(e, t, i, s) {
        var n, o, r, a, l = 0;
        e = this.filterComments(e);
        while (-1 !== (n = e.indexOf("{", l))) {
            r = this.processSelectors(e.substring(l, n));
            o = this.findEndOfCss(e, n);
            if (-1 === o) {
                break;
            }
            l = o + 1;
            if (r && r.length > 0) {
                a = e.substring(n + 1, o);
                a = kerio.wm.utils.CSSProcessor.filterCssDefinitions(a, s);
                if (a.length > 0) {
                    this.definitions.push({
                        selectors: r,
                        definition: kerio.wm.utils.CSSProcessor.applyUrlRemap(a, t, i)
                    });
                }
            }
        }
    },
    addPrefix: function(e) {
        var t, i, s;
        for (i = 0; i < this.definitions.length; i++) {
            t = this.definitions[i];
            for (s = 0; s < t.selectors.length; s++) {
                t.selectors[s] = t.selectors[s].replace(/\./gm, "." + e).replace(/#/, "#" + e);
            }
        }
    },
    addBeforeAllPaths: function(e) {
        var t, i, s;
        for (i = 0; i < this.definitions.length; i++) {
            t = this.definitions[i];
            for (s = 0; s < t.selectors.length; s++) {
                if ("BODY" === t.selectors[s].toUpperCase() || "*" === t.selectors[s]) {
                    t.selectors[s] = e;
                } else {
                    t.selectors[s] = e + " " + t.selectors[s];
                }
            }
        }
    },
    toString: function() {
        var e, t, i, s = "";
        for (t = 0; t < this.definitions.length; t++) {
            e = this.definitions[t];
            for (i = 0; i < e.selectors.length; i++) {
                if (i > 0) {
                    s += ", ";
                }
                s += e.selectors[i];
            }
            s += " {" + e.definition + "}\n";
        }
        return s;
    }
});

Ext.define("kerio.wm.view.tasks.TaskListDrag", {
    extend: "Ext.view.DragZone",
    getDragText: function() {
        var e, t = this.dragData.records.length;
        if (t > 1) {
            return " " + t + " " + k_tr("tasks", "tasks");
        } else {
            e = this.dragData.records[0].getDisplay("summary");
            return e.length < 200 ? e : e.substring(0, 200);
        }
    },
    afterValidDrop: function(e, t, i) {
        if (!this.dragData.copy) {
            var s = this.dragData.records, n = e.overRecord, o = e.currentPosition, r = this.dragData.view.store;
            if ("gridview" === e.view.getXType()) {
                r.updateSortOrder(n, o, s);
            } else {
                r.remove(s, !0);
            }
        }
    }
});

Ext.define("kerio.wm.view.module.PreviewPanel", {
    extend: "Ext.container.Container",
    styles: !0,
    componentCls: "previewPanel",
    constructor: function() {
        this.callParent(arguments);
        this.addCls("selectable");
    },
    setData: function(e) {}
});

Ext.define("kerio.wm.LocalesProvider", {
    singleton: !0,
    LANG_CS: "cs",
    LANG_DE: "de",
    LANG_EN_US: "en-us",
    LANG_EN_GB: "en-gb",
    LANG_ES: "es",
    LANG_FR: "fr",
    LANG_HR: "hr",
    LANG_HU: "hu",
    LANG_IT: "it",
    LANG_JA: "ja",
    LANG_NL: "nl",
    LANG_PL: "pl",
    LANG_PT: "pt",
    LANG_RU: "ru",
    LANG_SK: "sk",
    LANG_SV: "sv",
    LANG_ZH: "zh",
    FIRST_DAY_MONDAY: 1,
    FIRST_DAY_SUNDAY: 0,
    requires: [ "kerio.wm.SettingsManager", "kerio.wm.Constants" ],
    constructor: function() {
        this._timeFormat = kerio.wm.SettingsManager.get("webmail.timeFormat");
        this._dateFormat = kerio.wm.SettingsManager.get("webmail.dateFormat");
        this._langExtension = kerio.wm.SettingsManager.get("webmail.langExtension");
        this._firstWeekDay = kerio.wm.SettingsManager.get("webmail.firstWeekDay");
        if (!this._langExtension || "default" === this._langExtension) {
            this._langExtension = kerio.wm.Constants.DETECTED_LOCALES;
            if ("en-us" === this._langExtension) {
                this._firstWeekDay = 0;
            }
        }
        if (this._firstWeekDay !== this.FIRST_DAY_MONDAY && this._firstWeekDay !== this.FIRST_DAY_SUNDAY) {
            this._firstWeekDay = this.getFirstWeekDayForLocales(this._langExtension);
        }
        if (!this._timeFormat) {
            this._timeFormat = this._langExtension;
        }
        if (!this._dateFormat) {
            this._dateFormat = this._langExtension;
        }
    },
    is24hTimeFormat: function() {
        return "en-us" !== this._timeFormat && "en-gb" !== this._timeFormat;
    },
    getFirstWeekDay: function() {
        return this._firstWeekDay;
    },
    getFirstWeekDayForLocales: function(e) {
        if (e === this.LANG_EN_US) {
            return this.FIRST_DAY_SUNDAY;
        } else {
            return this.FIRST_DAY_MONDAY;
        }
    },
    getHumanReadablePattern: function(e) {
        e = e.replace("Y", "yyyy");
        e = e.replace("d", "dd");
        e = e.replace("j", "d");
        e = e.replace("m", "MM");
        e = e.replace("n", "M");
        e = e.replace("h", "hh").replace("H", "HH");
        e = e.replace("g", "h").replace("G", "H");
        e = e.replace("i", "mm");
        e = e.replace("A", "tt");
        return Ext.String.trim(e.toUpperCase());
    },
    getDatePatternsForLocales: function() {
        var e = {
            iso: "Ymd\\THisO",
            time: this.getTimeFormat(this._timeFormat),
            date: this.getDateFormat(this._dateFormat),
            dayHeader: this.getDayHeaderFormat(this._dateFormat),
            dayHeaderYear: this.getDayHeaderYearFormat(this._dateFormat),
            weekHeader: this.getWeekHeaderFormat(this._dateFormat),
            weekDayHeader: this.getWeekDayHeaderFormat(this._dateFormat),
            dateAndTime: this.getDateAndTimeFormat(this._dateFormat, this._timeFormat),
            multiDay: this.getMultiDayFormat(this._dateFormat, this._timeFormat),
            timeBar: this.getTimeBarFormat(this._timeFormat),
            dateTimeFullMonth: this.getDateTimeFullMonthFormat(this._dateFormat),
            dateFullMonth: this.getDateFullMonthFormat(this._dateFormat),
            dateFullMonthYear: this.getDateFullMonthYearFormat(this._dateFormat)
        };
        return e;
    },
    getTimeFormat: function(e) {
        switch (e) {
          case this.LANG_EN_US:
          case this.LANG_EN_GB:
            return "g:i A";

          default:
            return "G:i";
        }
    },
    getDateFormat: function(e) {
        switch (e) {
          case this.LANG_CS:
            return "j.n.Y";

          case this.LANG_DE:
            return "d.m.Y";

          case this.LANG_EN_US:
            return "n/j/Y";

          case this.LANG_EN_GB:
            return "d/m/Y";

          case this.LANG_ES:
            return "d/m/Y";

          case this.LANG_FR:
            return "d/m/Y";

          case this.LANG_HR:
            return "j.n.Y";

          case this.LANG_HU:
            return "Y.m.d";

          case this.LANG_IT:
            return "d/m/Y";

          case this.LANG_JA:
            return "Y/m/d";

          case this.LANG_NL:
            return "j-n-Y";

          case this.LANG_PL:
            return "Y-m-d";

          case this.LANG_PT:
            return "d/m/Y";

          case this.LANG_RU:
            return "d.m.Y";

          case this.LANG_SK:
            return "j.n.Y";

          case this.LANG_SV:
            return "Y-m-d";

          case this.LANG_ZH:
            return "Y/n/j";

          default:
            return "n/j/Y";
        }
    },
    getDayHeaderFormat: function(e) {
        return "l, " + this.getDateFullMonthFormat(e);
    },
    getDayHeaderYearFormat: function(e) {
        return "l, " + this.getDateFullMonthYearFormat(e);
    },
    getWeekHeaderFormat: function(e) {
        if (e === this.LANG_HU || e === this.LANG_JA || e === this.LANG_ZH) {
            return "Y F";
        } else {
            return "F Y";
        }
    },
    getWeekDayHeaderFormat: function(e) {
        return "j l";
    },
    getDateAndTimeFormat: function(e, t) {
        return this.getDateFormat(e) + " " + this.getTimeFormat(t || e);
    },
    getMultiDayFormat: function(e, t) {
        var i;
        switch (e) {
          case this.LANG_CS:
            i = "j.n.";
            break;

          case this.LANG_DE:
            i = "j.n.";
            break;

          case this.LANG_EN_US:
            i = "n/j";
            break;

          case this.LANG_EN_GB:
            i = "j/n";
            break;

          case this.LANG_ES:
            i = "j/n";
            break;

          case this.LANG_FR:
            i = "j/n";
            break;

          case this.LANG_HR:
            i = "j.n.";
            break;

          case this.LANG_HU:
            i = "n-j";
            break;

          case this.LANG_IT:
            i = "j/n";
            break;

          case this.LANG_JA:
            i = "n-j";
            break;

          case this.LANG_NL:
            i = "j-n";
            break;

          case this.LANG_PL:
            i = "j.n.";
            break;

          case this.LANG_PT:
            i = "j/n";
            break;

          case this.LANG_RU:
            i = "j.n.";
            break;

          case this.LANG_SK:
            i = "j.n.";
            break;

          case this.LANG_SV:
            i = "j.n.";
            break;

          case this.LANG_ZH:
            i = "n-j";
            break;

          default:
            i = "n/j";
        }
        return "l " + i + " " + this.getTimeFormat(t || e);
    },
    getTimeBarFormat: function(e) {
        if (e === this.LANG_EN_US || e === this.LANG_EN_GB) {
            return "g A";
        }
        return "G:i";
    },
    getDateTimeFullMonthFormat: function(e) {
        return this.getDateFullMonthFormat(e) + " " + this.getTimeFormat(e);
    },
    getDateFullMonthFormat: function(e) {
        var t;
        switch (e) {
          case this.LANG_CS:
            t = "j. F";
            break;

          case this.LANG_DE:
            t = "j. F";
            break;

          case this.LANG_EN_US:
            t = "F d";
            break;

          case this.LANG_EN_GB:
            t = "d F";
            break;

          case this.LANG_ES:
            t = "d F";
            break;

          case this.LANG_FR:
            t = "j F";
            break;

          case this.LANG_HR:
            t = "j. F";
            break;

          case this.LANG_HU:
            t = "F j.";
            break;

          case this.LANG_IT:
            t = "j F";
            break;

          case this.LANG_JA:
            t = "F j";
            break;

          case this.LANG_NL:
            t = "j F";
            break;

          case this.LANG_PL:
            t = "j F";
            break;

          case this.LANG_PT:
            t = "j F";
            break;

          case this.LANG_RU:
            t = "j F";
            break;

          case this.LANG_SK:
            t = "j. F";
            break;

          case this.LANG_SV:
            t = "j F";
            break;

          case this.LANG_ZH:
            t = "F j";
            break;

          default:
            t = "F d";
        }
        return this._resolveZeroPrefixing(t);
    },
    getDateFullMonthYearFormat: function(e) {
        var t;
        switch (e || this._timeFormat) {
          case this.LANG_CS:
            t = "j. F Y";
            break;

          case this.LANG_DE:
            t = "j. F Y";
            break;

          case this.LANG_EN_US:
            t = "F d, Y";
            break;

          case this.LANG_EN_GB:
            t = "d F Y";
            break;

          case this.LANG_ES:
            t = "d F Y";
            break;

          case this.LANG_FR:
            t = "j F Y";
            break;

          case this.LANG_HR:
            t = "j. F Y";
            break;

          case this.LANG_HU:
            t = "Y. F j.";
            break;

          case this.LANG_IT:
            t = "j F Y";
            break;

          case this.LANG_JA:
            t = "Y F j";
            break;

          case this.LANG_NL:
            t = "j F Y";
            break;

          case this.LANG_PL:
            t = "j F Y";
            break;

          case this.LANG_PT:
            t = "j F Y";
            break;

          case this.LANG_RU:
            t = "j F Y г.";
            break;

          case this.LANG_SK:
            t = "j. F Y";
            break;

          case this.LANG_SV:
            t = "j F Y";
            break;

          case this.LANG_ZH:
            t = "Y F j";
            break;

          default:
            t = "F d, Y";
        }
        return this._resolveZeroPrefixing(t);
    },
    _resolveZeroPrefixing: function(e) {
        var t = this.getDateFormat(this._dateFormat);
        if (t.indexOf("d") >= 0) {
            e = e.replace("j", "d");
        } else {
            if (t.indexOf("j") >= 0) {
                e = e.replace("d", "j");
            }
        }
        return e;
    }
});

Ext.define("kerio.ext.ux.DateTime", {
    extend: "Ext.form.FieldContainer",
    alias: "widget.k_datetime",
    styles: !0,
    mixins: {
        fields: "Ext.form.Field"
    },
    dateTimeFormat: "m/d/Y g:i A",
    defaultTimeValue: "9:00 AM",
    dateFormat: "m/d/Y",
    timeFormat: "g:i A",
    timeWidth: 90,
    initComponent: function() {
        this.callParent(arguments);
        this.addEvents("change");
        this.addEvents("validitychange");
    },
    constructor: function(e) {
        var t;
        if (Ext.Date.patterns) {
            this.dateFormat = Ext.Date.patterns.date;
            this.timeFormat = Ext.Date.patterns.time;
        }
        if (kerio.wm && kerio.wm.LocalesProvider) {
            t = kerio.wm.LocalesProvider.getFirstWeekDay();
        } else {
            t = 0;
        }
        Ext.apply(e, {
            name: e.name,
            layout: {
                type: "hbox"
            },
            items: [ {
                xtype: "datefield",
                flex: 1,
                format: this.dateFormat,
                startDay: t,
                itemId: e.itemId + "-date",
                emptyText: e.dateEmptyText,
                enableKeyEvents: e.enableKeyEvents,
                isFormField: !1,
                value: e.value,
                msgTarget: e.msgTarget || "qtip",
                allowBlank: !!e.allowBlank,
                maskRe: e.dateMaskRe,
                minValue: e.minDate || new Date(1601, 0, 2),
                maxValue: e.maxDate || new Date(9999, 11, 31),
                editable: void 0 === e.editable ? !0 : e.editable,
                tabIndex: e.tabIndex,
                trimValue: e.trimValue,
                listeners: {
                    select: this._k_onSelect,
                    blur: this._k_onBlur,
                    validitychange: this._k_onValidityChange,
                    scope: this
                },
                getTriggerWidth: function() {
                    return 17;
                }
            }, {
                xtype: "timefield",
                width: this.timeWidth,
                format: this.timeFormat,
                altFormats: "gi A|giA|Gi|gA|G|g:i A|g:iA|G:i|gA|G",
                isFormField: !1,
                itemId: e.itemId + "-time",
                emptyText: e.timeEmptyText,
                value: e.value,
                enableKeyEvents: e.enableKeyEvents,
                increment: 30,
                msgTarget: e.msgTarget || "qtip",
                allowBlank: !!e.allowBlank,
                maskRe: e.timeMaskRe,
                minValue: e.minTime,
                maxValue: e.maxTime,
                editable: void 0 === e.editable ? !0 : e.editable,
                tabIndex: e.tabIndex,
                margin: "0 0 0 4",
                trimValue: e.trimValue,
                listeners: {
                    select: this._k_onSelect,
                    blur: this._k_onBlur,
                    focus: this._k_onFocus,
                    validitychange: this._k_onValidityChange,
                    scope: this
                },
                getTriggerWidth: function() {
                    return 17;
                }
            } ]
        });
        this.callParent(arguments);
        this.dateField = this.query("datefield")[0];
        this.timeField = this.query("timefield")[0];
        this.dateField.onTriggerClick = Ext.Function.createSequence(this.dateField.onTriggerClick, function() {
            var e, t, i = this.dateField.picker.textNodes, s = i.length;
            for (e = 0; s > e; e++) {
                t = Ext.fly(i[e]);
                t.removeCls("oneNumber");
                if (1 === Ext.String.trim(t.dom.innerHTML).length) {
                    t.addCls("oneNumber");
                }
            }
        }, this);
        this.timeField.onTriggerClick = Ext.Function.createSequence(this.timeField.onTriggerClick, function() {
            var e = this.timeField.picker;
            if (!e._fixedFocusedRow) {
                if (e.viewReady) {
                    this._k_doAutoSelect();
                } else {
                    e._fixedFocusedRow = !0;
                    this.timeField.picker.doComponentLayout = Ext.Function.createSequence(this.timeField.picker.doComponentLayout, function() {
                        this._k_doAutoSelect();
                    }, this);
                }
            }
            e.on("beforeitemclick", function() {
                this.picker.getSelectionModel().clearSelections();
            }, this.timeField);
            this.timeField.picker.getSelectionModel().deselectOnContainerClick = !1;
        }, this);
        this.subfields = [ this.dateField, this.timeField ];
        this.relayEvents(this.dateField, [ "keydown" ]);
        this.relayEvents(this.timeField, [ "keydown" ]);
    },
    getValue: function() {
        var e = this.dateField.getValue(), t = this.timeField.getValue();
        if (this.isValid() && e && t) {
            return kerio.wm.Utils.combineDateAndTime(e, t);
        } else {
            return;
        }
    },
    setValue: function(e) {
        if ("number" == typeof e) {
            e = new Date(e);
        } else {
            if ("string" == typeof e && this.dateTimeFormat) {
                e = Ext.Date.parse(e, this.dateTimeFormat);
            }
        }
        this.setTime(e);
        this.setDate(e);
        return this;
    },
    resetMin: function() {
        this.setMinTime(this.minDate);
        this.setMinDate(this.minDate);
    },
    _k_doAutoSelect: function() {
        var e = this.timeField.getPicker(), t = e.getStore(), i = e.getNode(t.find("disp", this.timeField.getRawValue()));
        if (i) {
            e.select(e.getRecord(i), !1, !0);
            e.highlightItem(i);
            e.listEl.scrollChildIntoView(i, !1);
        }
    },
    setDate: function(e) {
        this.dateField.setValue(e);
    },
    setTime: function(e) {
        this.timeField.setValue(e);
    },
    suspendEvents: function() {
        this.dateField.suspendEvents();
        this.timeField.suspendEvents();
    },
    resumeEvents: function() {
        this.dateField.resumeEvents();
        this.timeField.resumeEvents();
    },
    clearInvalid: function() {
        this.dateField.clearInvalid();
        this.timeField.clearInvalid();
    },
    validate: function() {
        return this.dateField.validate() && this.timeField.validate();
    },
    markInvalid: function(e) {
        this.dateField.markInvalid(e);
        this.timeField.markInvalid(e);
    },
    focus: function() {
        this.dateField.focus();
    },
    isValid: function() {
        return this.dateField.isValid() && this.timeField.isValid();
    },
    _k_onSelect: function(e) {
        this._k_synchronizeFields(e);
        this.fireEvent("change", this, this.getValue());
    },
    _k_synchronizeFields: function(e) {
        if (!e.getValue()) {
            return;
        }
        if (!this.timeField.getValue()) {
            this.timeField.setValue(this.timeField.valueToRaw(this.defaultTimeValue));
        }
        if (!this.dateField.getValue()) {
            this.dateField.setValue(kerio.wm.getCurrentDate());
        }
    },
    _k_onBlur: function(e) {
        this._k_synchronizeFields(e);
        if (!this.dateField.getValue() || !this.timeField.getValue() || !this.isValid()) {
            return;
        }
        this.fireEvent("change", this, this.getValue());
    },
    _k_onFocus: function() {
        if (!this.hasFocus) {
            this._k_doAutoSelect();
        }
    },
    _k_onValidityChange: function(e, t, i) {
        if (!this._previousIsValidMerged || !t) {
            var s = this.isValid();
            this.fireEvent("validitychange", this, s, i);
            this._previousIsValidMerged = s;
        }
    },
    isDirty: function() {
        return this.dateField.isDirty() || this.timeField.isDirty();
    },
    setReadOnly: function(e) {
        this.dateField.setReadOnly(e);
        this.timeField.setReadOnly(e);
        if (e) {
            this.dateField.addCls("x-form-readonly");
            this.timeField.addCls("x-form-readonly");
        } else {
            this.dateField.removeCls("x-form-readonly");
            this.timeField.removeCls("x-form-readonly");
        }
        return;
    },
    resetOriginalValue: function() {
        this.originalValue = this.getValue();
        this._k_callFunctionOnSubfields("resetOriginalValue");
        this.checkDirty();
    },
    disable: function() {
        this.disabled = !0;
        this._k_callFunctionOnSubfields("disable");
    },
    enable: function() {
        this.disabled = !1;
        this._k_callFunctionOnSubfields("enable");
    },
    _k_callFunctionOnSubfields: function(e) {
        var t, i;
        if (this.subfields) {
            for (t = 0; t < this.subfields.length; t++) {
                i = this.subfields[t];
                i[e]();
            }
        }
    },
    setMinDate: function(e) {
        this.dateField.setMinValue(e);
    },
    setMaxDate: function(e) {
        this.dateField.setMaxValue(e);
    },
    setMinTime: function(e) {
        this.timeField.setMinValue(e);
    },
    setMaxTime: function(e) {
        this.timeField.setMaxValue(e);
    }
});

Ext.define("kerio.wm.model.tasks.TaskModel", {
    extend: "kerio.wm.model.Model",
    fields: [ "folderId", {
        name: "id",
        defaultValue: ""
    }, {
        name: "access",
        defaultValue: "EAccessCreator"
    }, {
        name: "done",
        defaultValue: 0,
        convert: function(e) {
            if (100 > e) {
                e = 0;
            }
            return e;
        }
    }, {
        name: "status",
        defaultValue: "tsNotStarted"
    }, {
        name: "summary",
        toDisplay: !0,
        defaultValue: ""
    }, {
        name: "description",
        toDisplay: !0,
        defaultValue: ""
    }, {
        name: "due",
        defaultValue: "",
        type: "date",
        dateFormat: "iso"
    }, {
        name: "reminder",
        defaultValue: {
            isSet: !1
        },
        convert: function(e) {
            if (e.isSet && e.date && "string" == typeof e.date) {
                e.date = Ext.Date.parseDate(e.date, "iso");
            }
            return e;
        },
        deconvert: function(e) {
            if (e.isSet && e.date) {
                e.date = Ext.Date.format(e.date, "iso");
            }
            return e;
        }
    }, {
        name: "sortOrder",
        defaultValue: 0
    }, "watermark", "location", "priority", "role", "attendees", "rule", "isCancelled", "isPrivate", {
        name: "end",
        defaultValue: "",
        type: "date",
        dateFormat: "iso"
    }, {
        name: "start",
        defaultValue: "",
        type: "date",
        dateFormat: "iso"
    } ],
    k_getFolderStore: function() {
        return Ext.getStore("tasks.TaskFoldersStore");
    },
    k_isDone: function() {
        return 100 === this.get("done");
    },
    k_getStatus: function(e) {
        return 100 === e ? "tsCompleted" : "tsNotStarted";
    },
    k_getDone: function(e) {
        return "tsCompleted" === e ? 100 : 0;
    }
});

Ext.define("kerio.wm.store.QuickSearchMixin", {
    recordContainText: function(e, t, i) {
        var s, n, o, r, a, l, d, c;
        i = kerio.wm.utils.Utils.getStandardizedString(i);
        if (i) {
            c = i.split(" ");
        }
        if (c) {
            for (s = 0, o = t.length; o > s; s++) {
                if (t[s].getParams) {
                    l = e.get(t[s].name);
                    d = t[s].getParams(l);
                    for (n = 0, r = d.length; r > n; n++) {
                        c = this._checkMatches(d[n], c).unmatched;
                        if (0 === c.length) {
                            return !0;
                        }
                    }
                } else {
                    a = e.get(t[s].name);
                    c = this._checkMatches(a, c).unmatched;
                    if (0 === c.length) {
                        return !0;
                    }
                }
            }
        }
        return !1;
    },
    _quickSearchFilterFn: function(e) {
        return this.recordContainText(e, this._searchFields, this.searchText);
    },
    _checkMatches: function(e, t) {
        return kerio.wm.utils.Utils.checkMatches(kerio.wm.utils.Utils.getStandardizedString(e), t);
    }
});

Ext.define("kerio.wm.data.TasksTreeReader", {
    extend: "kerio.wm.data.MemoryFolderReader",
    alias: "reader.taskstreereader",
    beforeCreateRecords: function(e) {
        if (0 === e.length || "FRoot" !== e[0].type) {
            return;
        }
        var t, i, s, n, o, r, a, l, d, c = [];
        i = new this.LastIdx(2);
        s = i;
        c.push(e[0]);
        c.push(this._createFakeFolder("", k_tr("FOLDERS", "folders"), {
            placeType: "FPlaceMailbox",
            type: "FTask",
            access: "FAccessAdmin"
        }));
        this.filterRecords(e, "FTask", !0, !0);
        for (t = 0; t < e.length; t++) {
            l = e[t];
            if (this._isRootFolder(l)) {
                if (this._isPublicFolder(l)) {
                    r = l;
                } else {
                    continue;
                }
            }
            d = 2;
            if (this._isMyDefaultFolder(l)) {
                l.name = k_tr("My tasks", "tasks");
                l.allowDrag = !1;
                d = 1;
                a = new this.LastIdx(0);
            } else {
                if (this._isMyFolder(l)) {
                    a = i;
                } else {
                    if (this._isPeopleFolder(l) || this._isResouceFolder(l)) {
                        if (this._isPeopleFolder(l) && !l.isSubscribed) {
                            continue;
                        }
                        if (!n) {
                            n = new this.LastIdx(c.length, s);
                            s = n;
                            l.type = "FTask";
                            c.push(this._createFakeFolder("SHARED_FOLDERS", k_tr("SHARED FOLDERS", "folders"), l));
                        }
                        a = n;
                    } else {
                        if (this._isPublicFolder(l)) {
                            if (!o) {
                                if (this._isRootFolder(l)) {
                                    if ("FAccessAdmin" === l.access) {
                                        o = new this.LastIdx(c.length, s);
                                        s = o;
                                        c.push(this._createFakeFolder(r.id, k_tr("PUBLIC FOLDERS", "folders"), r, r.access));
                                    }
                                    continue;
                                } else {
                                    o = new this.LastIdx(c.length, s);
                                    s = o;
                                    c.push(this._createFakeFolder(r.id, k_tr("PUBLIC FOLDERS", "folders"), r, r.access));
                                }
                            }
                            a = o;
                        } else {
                            if (this._isArchiveFolder(l)) {
                                continue;
                            } else {}
                        }
                    }
                }
            }
            c.splice(++a.idx, 0, l);
            l.nestingLevel = d;
            l.leaf = !0;
            s.refreshCounters();
        }
        e.splice(0, e.length);
        for (t = 0; t < c.length; t++) {
            e.push(c[t]);
        }
    },
    applyOnRecords: function(e) {
        var t, i;
        for (t = 0; t < e.length; t++) {
            i = e[t];
            if ("FakeSubType" === i.data.subType) {
                i.data.checked = null;
            }
        }
    }
});

Ext.define("kerio.wm.view.AbstractFolderViewDragDrop", {
    extend: "Ext.tree.plugin.TreeViewDragDrop",
    enable: function() {
        var e = this;
        if (e.dragZone) {
            e.dragZone.unlock();
        }
        if (e.dropZone) {
            e.dropZone.unlock();
        }
        e.callParent();
    },
    disable: function() {
        var e = this;
        if (e.dragZone) {
            e.dragZone.lock();
        }
        if (e.dropZone) {
            e.dropZone.lock();
        }
        e.callParent();
    }
});

Ext.define("kerio.wm.data.NotesTreeReader", {
    extend: "kerio.wm.data.MemoryFolderReader",
    alias: "reader.notestreereader",
    beforeCreateRecords: function(e) {
        if (0 === e.length || "FRoot" !== e[0].type) {
            return;
        }
        var t, i, s, n, o, r, a, l, d, c = [];
        i = new this.LastIdx(2);
        s = i;
        c.push(e[0]);
        c.push(this._createFakeFolder("", k_tr("FOLDERS", "folders"), {
            placeType: "FPlaceMailbox",
            type: "FNote",
            access: "FAccessAdmin"
        }));
        this.filterRecords(e, "FNote", !0, !0);
        for (t = 0; t < e.length; t++) {
            l = e[t];
            if (this._isRootFolder(l)) {
                if (this._isPublicFolder(l)) {
                    r = l;
                } else {
                    continue;
                }
            }
            d = 2;
            if (this._isMyDefaultFolder(l)) {
                l.name = k_tr("My notes", "notes");
                d = 1;
                l.allowDrag = !1;
                a = new this.LastIdx(0);
            } else {
                if (this._isMyFolder(l)) {
                    a = i;
                } else {
                    if (this._isPeopleFolder(l) || this._isResouceFolder(l)) {
                        if (this._isPeopleFolder(l) && !l.isSubscribed) {
                            continue;
                        }
                        if (!n) {
                            n = new this.LastIdx(c.length, s);
                            s = n;
                            l.type = "FNote";
                            c.push(this._createFakeFolder("SHARED_FOLDERS", k_tr("SHARED FOLDERS", "folders"), l));
                        }
                        a = n;
                    } else {
                        if (this._isPublicFolder(l)) {
                            if (!o) {
                                if (this._isRootFolder(l)) {
                                    if ("FAccessAdmin" === l.access) {
                                        o = new this.LastIdx(c.length, s);
                                        s = o;
                                        c.push(this._createFakeFolder(r.id, k_tr("PUBLIC FOLDERS", "folders"), r, r.access));
                                    }
                                    continue;
                                } else {
                                    o = new this.LastIdx(c.length, s);
                                    s = o;
                                    c.push(this._createFakeFolder(r.id, k_tr("PUBLIC FOLDERS", "folders"), r, r.access));
                                }
                            }
                            a = o;
                        } else {
                            if (this._isArchiveFolder(l)) {
                                continue;
                            } else {}
                        }
                    }
                }
            }
            c.splice(++a.idx, 0, l);
            l.nestingLevel = d;
            l.leaf = !0;
            s.refreshCounters();
        }
        e.splice(0, e.length);
        for (t = 0; t < c.length; t++) {
            e.push(c[t]);
        }
    },
    applyOnRecords: function(e) {
        var t, i;
        for (t = 0; t < e.length; t++) {
            i = e[t];
            if ("FakeSubType" === i.data.subType) {
                i.data.checked = null;
            }
        }
    }
});

Ext.define("kerio.wm.view.notes.EditorPanel", {
    extend: "kerio.wm.view.module.EditorPanel",
    alias: "widget.noteseditorpanel",
    styles: !0,
    toolbar: {
        xtype: "moduleeditortoolbar",
        cls: "notesEditorToolbar",
        itemId: "notesEditorToolbar",
        items: [ "->", {
            xtype: "keriocolorpicker",
            cls: "kerioColorPicker",
            itemId: "noteColorPicker",
            name: "color",
            width: 124,
            height: 20,
            colors: Ext.Object.getValues(kerio.wm.Constants.noteColors),
            states: [ {
                settings: {
                    isSelected: !0
                },
                state: {
                    enabled: !0
                }
            } ]
        } ]
    },
    form: {
        itemId: "noteEditorText",
        cls: "noteEditorText",
        fieldStyle: {
            border: "none"
        },
        name: "text",
        xtype: "textarea",
        enableKeyEvents: !0
    },
    constructor: function() {
        this.callParent(arguments);
        this._noteColors = kerio.wm.Constants.noteColors;
        this._defaultColor = Ext.Object.getValues(this._noteColors)[1];
        this._noteEditorText = this.query("#noteEditorText")[0];
        this._colorPicker = Ext.ComponentQuery.query("#noteColorPicker", this._toolbar)[0];
        this._noteEditorText.on({
            render: function() {
                this.setBorderColor(this._defaultColor);
            },
            scope: this
        });
        this._colorPicker.on({
            select: function(e) {
                if (e.value) {
                    this.setBorderColor(e.value);
                }
            },
            scope: this
        });
    },
    setBorderColor: function(e) {
        if (this._noteEditorText.rendered) {
            this._noteEditorText.el.setStyle({
                "border-top-color": "#" + e
            });
        }
    },
    setData: function(e, t) {
        var i = e.data || e, s = i.text || "";
        this._noteEditorText.setValue(s);
        this._editedNoteId = e ? e.getId() : !1;
        this._noteEditorText.resetOriginalValue();
        if ((Ext.isIE || Ext.isIE11) && this._noteEditorText.inputEl) {
            this._noteEditorText.inputEl.dom.setSelectionRange(s.length, s.length);
        }
        this.setFocus();
    },
    setFocus: function() {
        this._noteEditorText.focus();
    },
    getData: function() {
        return {
            color: Ext.Object.getKey(this._noteColors, this._colorPicker.getValue()),
            text: this._noteEditorText.getValue(),
            editedId: this._editedNoteId
        };
    },
    isEdited: function() {
        return !!this._editedNoteId;
    },
    setColor: function(e) {
        this.setBorderColor(e);
        this._colorPicker.select(e);
        this._previousColor = e;
    },
    isChanged: function() {
        return this._noteEditorText.isDirty() || this._previousColor !== this._colorPicker.getValue();
    },
    reset: function() {
        this.setData("");
        this.setColor(this._defaultColor);
    }
});

Ext.define("kerio.wm.view.notes.PreviewPanel", {
    extend: "kerio.wm.view.module.PreviewPanel",
    alias: "widget.notespreviewpanel",
    styles: !0,
    itemId: "detailCt",
    flex: 1,
    constructor: function() {
        var e = Ext.Object.getValues(kerio.wm.Constants.noteColors);
        this._noteColors = kerio.wm.Constants.noteColors;
        this._defaultColor = e[1];
        this.items = [ {
            xtype: "component",
            itemId: "notesPreview"
        } ];
        this.callParent(arguments);
        this.addCls("notesPreview");
        this._textarea = this.query("#notesPreview")[0];
    },
    setData: function(e) {
        var t = e.data || e, i = "" !== t.color && void 0 !== t.color ? this._noteColors[t.color] : this._defaultColor, s = t.text || "";
        s = Ext.htmlEncode(s);
        s = s.replace(/\n/gi, "<br>");
        this._textarea.getEl().update(s);
        this.changeNoteColor(i);
    },
    changeNoteColor: function(e) {
        this._selectedColor = e;
        if (this.rendered) {
            this.el.setStyle({
                "border-top-color": "#" + e
            });
        }
    }
});

Ext.define("kerio.wm.messages.message.InfoDialog", {
    extend: "Ext.container.Container",
    alias: "widget.chatinfomsgdialog",
    styles: !0,
    cls: "chatInfoDlg",
    header: !1,
    modal: !0,
    resizable: !0,
    autoScroll: !0,
    floating: !0,
    constructor: function(e) {
        this.items = [ {
            xtype: "component",
            itemId: "content",
            cls: "content",
            html: [ '<div class="imgCt">', '<div class="img">', '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 510.2 510.2"><style>.st0{fill:#f5f6f6}.st1{fill:#fff}.st2{fill:#d3d3d3}</style><circle class="st0" cx="255.1" cy="255.1" r="249.3"/><path class="st1" d="M351.6 468.1c-1 0-2.1-.4-2.8-1.2L324.9 443H81.5c-6.5 0-11.8-5.3-11.8-11.8V347c0-6.5 5.3-11.8 11.8-11.8h286.1c6.5 0 11.8 5.3 11.8 11.8v84.2c0 6.5-5.3 11.8-11.8 11.8h-11.9v21c0 1.6-1 3.1-2.5 3.7-.5.3-1 .4-1.6.4z"/><path class="st2" d="M351.6 468.1c-1 0-2.1-.4-2.8-1.2L324.9 443H81.5c-6.5 0-11.8-5.3-11.8-11.8V347c0-6.5 5.3-11.8 11.8-11.8h286.1c6.5 0 11.8 5.3 11.8 11.8v84.2c0 6.5-5.3 11.8-11.8 11.8h-11.9v21c0 1.6-1 3.1-2.5 3.7-.5.3-1 .4-1.6.4zM81.5 343.2c-2.1 0-3.8 1.7-3.8 3.8v84.2c0 2.1 1.7 3.8 3.8 3.8h245.1c1.1 0 2.1.4 2.8 1.2l18.2 18.2V439c0-2.2 1.8-4 4-4h15.9c2.1 0 3.8-1.7 3.8-3.8V347c0-2.1-1.7-3.8-3.8-3.8h-286z"/><path class="st2" d="M123.3 356.5c-18 0-32.6 14.6-32.6 32.6s14.6 32.6 32.6 32.6 32.6-14.6 32.6-32.6-14.6-32.6-32.6-32.6zm0 13c5.8 0 10.4 4.7 10.4 10.4 0 5.8-4.7 10.4-10.4 10.4-5.8 0-10.4-4.7-10.4-10.4 0-5.8 4.7-10.4 10.4-10.4zm14.2 39.2h-28.4v-7.8c0-4.8 2.4-9.1 6.1-11.7 2.2 1.8 5 2.9 8.1 2.9s5.9-1.1 8.1-2.9c3.7 2.6 6.1 6.8 6.1 11.7v7.8zM298.9 370.8H187.8c-2.2 0-4-1.8-4-4s1.8-4 4-4h111.1c2.2 0 4 1.8 4 4s-1.8 4-4 4zM338.7 393.1H187.8c-2.2 0-4-1.8-4-4s1.8-4 4-4h150.9c2.2 0 4 1.8 4 4s-1.8 4-4 4zM258.6 415.3h-70.8c-2.2 0-4-1.8-4-4s1.8-4 4-4h70.7c2.2 0 4 1.8 4 4s-1.7 4-3.9 4z"/><g><path class="st1" d="M339.5 175c-1 0-2.1-.4-2.8-1.2l-23.9-23.9H49.7c-6.7 0-12.1-5.5-12.1-12.1V54.3c0-6.7 5.5-12.1 12.1-12.1h310c6.7 0 12.1 5.5 12.1 12.1v83.6c0 6.7-5.5 12.1-12.1 12.1h-16.2v21c0 1.6-1 3.1-2.5 3.7-.4.2-.9.3-1.5.3z"/><path class="st2" d="M339.5 175c-1 0-2.1-.4-2.8-1.2l-23.9-23.9H49.7c-6.7 0-12.1-5.5-12.1-12.1V54.3c0-6.7 5.5-12.1 12.1-12.1h310c6.7 0 12.1 5.5 12.1 12.1v83.6c0 6.7-5.5 12.1-12.1 12.1h-16.2v21c0 1.6-1 3.1-2.5 3.7-.4.2-.9.3-1.5.3zM49.7 50.1c-2.3 0-4.1 1.9-4.1 4.1v83.6c0 2.3 1.9 4.1 4.1 4.1h264.8c1.1 0 2.1.4 2.8 1.2l18.2 18.2v-15.4c0-2.2 1.8-4 4-4h20.2c2.3 0 4.1-1.9 4.1-4.1V54.3c0-2.3-1.9-4.1-4.1-4.1h-310v-.1z"/><path class="st2" d="M91.7 63.7c-18 0-32.6 14.6-32.6 32.6s14.6 32.6 32.6 32.6 32.6-14.6 32.6-32.6-14.6-32.6-32.6-32.6zm0 12.9c5.8 0 10.4 4.7 10.4 10.4 0 5.8-4.7 10.4-10.4 10.4S81.3 92.7 81.3 87 86 76.6 91.7 76.6zm14.2 39.3H77.5v-7.8c0-4.8 2.4-9.1 6.1-11.7 2.2 1.8 5 2.9 8.1 2.9s5.9-1.1 8.1-2.9c3.7 2.6 6.1 6.8 6.1 11.7v7.8zM331.9 78H156.1c-2.2 0-4-1.8-4-4s1.8-4 4-4h175.8c2.2 0 4 1.8 4 4s-1.8 4-4 4zM234.2 100.3h-78.1c-2.2 0-4-1.8-4-4s1.8-4 4-4h78.1c2.2 0 4 1.8 4 4s-1.7 4-4 4zM292.9 122.5H156.1c-2.2 0-4-1.8-4-4s1.8-4 4-4h136.8c2.2 0 4 1.8 4 4s-1.7 4-4 4z"/></g><g><path class="st1" d="M207.1 321.6a4.025 4.025 0 0 1-4-4v-21h-10.9c-6.4 0-11.6-5.2-11.6-11.6v-84.7c0-6.4 5.2-11.6 11.6-11.6H461c6.4 0 11.6 5.2 11.6 11.6V285c0 6.4-5.2 11.6-11.6 11.6H233.8l-23.9 23.9c-.7.7-1.7 1.1-2.8 1.1z"/><path class="st2" d="M207.1 321.6a4.025 4.025 0 0 1-4-4v-21h-10.9c-6.4 0-11.6-5.2-11.6-11.6v-84.7c0-6.4 5.2-11.6 11.6-11.6H461c6.4 0 11.6 5.2 11.6 11.6V285c0 6.4-5.2 11.6-11.6 11.6H233.8l-23.9 23.9c-.7.7-1.7 1.1-2.8 1.1zm-14.8-124.9c-2 0-3.6 1.6-3.6 3.6V285c0 2 1.6 3.6 3.6 3.6h14.9c2.2 0 4 1.8 4 4V308l18.2-18.2c.8-.8 1.8-1.2 2.8-1.2h228.9c2 0 3.6-1.6 3.6-3.6v-84.7c0-2-1.6-3.6-3.6-3.6H192.3z"/><path class="st2" d="M234.9 209.9c-18 0-32.6 14.6-32.6 32.6s14.6 32.6 32.6 32.6 32.6-14.6 32.6-32.6-14.5-32.6-32.6-32.6zm0 13c5.8 0 10.4 4.7 10.4 10.4 0 5.8-4.7 10.4-10.4 10.4s-10.4-4.7-10.4-10.4c0-5.8 4.7-10.4 10.4-10.4zm14.3 39.2h-28.4v-7.8c0-4.8 2.4-9.1 6.1-11.7 2.2 1.8 5 2.9 8.1 2.9s5.9-1.1 8.1-2.9c3.7 2.6 6.1 6.8 6.1 11.7v7.8zM331.7 224.2h-31.9c-2.2 0-4-1.8-4-4s1.8-4 4-4h31.9c2.2 0 4 1.8 4 4s-1.8 4-4 4zM389.5 246.5h-89.7c-2.2 0-4-1.8-4-4s1.8-4 4-4h89.7c2.2 0 4 1.8 4 4s-1.8 4-4 4zM429.2 268.7H299.8c-2.2 0-4-1.8-4-4s1.8-4 4-4h129.5c2.2 0 4 1.8 4 4s-1.9 4-4.1 4z"/></g></svg>', "</div>", "</div>", '<div class="msgCt">', '<div class="title">', k_tr("Welcome to Chat!", "messaging"), "</div>", '<div class="msg">', k_tr("Now you can chat with all your colleagues (company contacts only for now) directly from Kerio Connect Client.", "messaging"), "</div>", "</div>" ].join("")
        }, {
            xtype: "container",
            layout: "auto",
            cls: "btnCt",
            items: {
                xtype: "webmailbutton",
                text: k_tr("OK, got it", "messaging", {
                    k_comment: ""
                }),
                itemId: "btnOk",
                height: 40,
                isDefault: !0
            }
        }, {
            xtype: "container",
            layout: "auto",
            cls: "linkCt",
            items: [ {
                xtype: "linkbutton",
                href: "http://kb.kerio.com/" + e.kbArticle,
                text: k_tr("More about Chat", "messaging"),
                itemId: "learnMore",
                cls: "learnMore"
            }, {
                xtype: "linkbutton",
                text: k_tr("Show me later", "messaging"),
                itemId: "showMeLater"
            } ]
        } ];
        this.callParent(arguments);
        this.down("#btnOk").on({
            click: this.onOkClick,
            scope: this
        });
        this.down("#learnMore").preventDefault = !1;
        this.down("#showMeLater").on({
            click: this.onShowMeLaterClick,
            scope: this
        });
    },
    onOkClick: function() {
        kerio.wm.SettingsManager.set(this.settingsProperty, !1);
        kerio.wm.SettingsManager.save([ this.settingsProperty ]);
        this.close();
    },
    onShowMeLaterClick: function() {
        this.close();
    },
    close: function() {
        this.hide();
    },
    maybeShow: function() {
        return new Promise(function(e, t) {
            kerio.wm.SettingsManager.load([ "webmail.im.infoMessage" ], {
                success: function(i) {
                    if (!0 === i) {
                        if (this.ownerCt && this.ownerCt.isVisible()) {
                            this.show();
                            e(this.isVisible());
                            return;
                        }
                    }
                    t();
                },
                failure: function(e, i) {
                    i.response.stopErrorProcessing();
                    t();
                },
                scope: this
            });
        }.bind(this));
    }
});

Ext.define("kerio.wm.messages.contacts.ChainedStore", {
    extend: "Ext.data.Store",
    alias: "store.chained",
    autoLoad: !0,
    _delegatedFns: [],
    reapplyFiltersOnChange: !1,
    _delegatedEvents: {
        datachanged: function() {},
        datachangedBuffered: function() {
            this.reapplyFilters();
            this.fireEvent("datachanged", [].slice.call(arguments));
        },
        refresh: function() {},
        refreshBuffered: function() {
            this.reapplyFilters();
            this.fireEvent("refresh", [].slice.call(arguments));
        },
        add: function(e, t, i, s) {
            if (t.length) {
                this.fireEvent("add", e, t, i, s);
            }
        },
        addBuffered: function() {
            this.reapplyFilters();
        },
        remove: function(e, t, i, s) {
            if (this.getById(t.getId())) {
                this.fireEvent("remove", [].slice.call(arguments));
            }
        },
        removeBuffered: function() {
            this.reapplyFilters();
        },
        update: function(e, t, i, s) {
            if (this.getById(t.getId())) {
                this.fireEvent("update", [].slice.call(arguments));
            }
        },
        updateBuffered: function() {
            this.reapplyFilters();
        },
        clear: function() {},
        clearBuffered: function() {
            this.fireEvent("clear", [].slice.call(arguments));
        }
    },
    constructor: function(e) {
        this._store = e.parentStore;
        this.model = this._store.model;
        delete e.parentStore;
        this.callParent(arguments);
        var t, i, s;
        for (t = 0; t < this._delegatedFns.length; t++) {
            i = this._delegatedFns[t];
            this[i] = Ext.bind(this._store[i], this._store);
        }
        this._store.on("datachanged", function() {});
        this._store.on("update", function() {});
        for (s in this._delegatedEvents) {
            if (this._delegatedEvents.hasOwnProperty(s)) {
                this._store.on(s, function() {
                    var e = this.scope, t = this.eventName;
                    return e._delegatedEvents[t].apply(e, [].slice.call(arguments));
                }, {
                    scope: this,
                    eventName: s
                });
                this._store.on(s, function() {
                    var e = this.scope, t = this.eventName;
                    if (e._delegatedEvents[t + "Buffered"]) {
                        return e._delegatedEvents[t + "Buffered"].apply(e, [].slice.call(arguments));
                    }
                }, {
                    scope: this,
                    eventName: s
                }, {
                    buffer: !0
                });
            }
        }
    },
    load: function(e) {
        var t, i = this;
        e = e || {};
        this.pageSize = this._store.getCount();
        Ext.applyIf(e, {
            action: "read",
            filters: i.filters.items,
            sorters: i.getSorters(),
            start: 0,
            limit: this.pageSize
        });
        t = Ext.create("Ext.data.Operation", e);
        if (i.fireEvent("beforeload", i, t) !== !1) {
            i.loading = !0;
            this.operation = t;
            this.options = e;
            if (this._store.isLoading()) {
                this._store.on("load", this._onDataLoaded, this);
            } else {
                Ext.defer(function() {
                    this._onDataLoaded();
                }, 10, this);
            }
        }
    },
    _onDataLoaded: function() {
        var e = this.options, t = this.operation;
        t.records = this._loadRange(e, !0);
        t.setSuccessful();
        t.setCompleted();
        this.onProxyLoad(t);
    },
    onProxyLoad: function() {
        this.loading = !1;
        this.callParent(arguments);
    },
    _loadRange: function(e) {
        var t, i, s = {};
        if (this._store.getCount() < e.start) {
            e.currentPage = 1;
            e.start = 0;
            e.limit = this.pageSize;
        }
        t = this._store.data.getRange(e.start, Math.max(e.start + (e.limit - 1), 0));
        this.currentPage = e.page || this.currentPage;
        this.data.clear();
        for (i = 0; i < t.length; i++) {
            s[t[i].internalId] = t[i];
        }
        this.data.addAll(s);
        return t;
    },
    reapplyFilters: function() {
        var e = this, t = e.sorters.length && e.sortOnFilter && !e.remoteSort;
        if (e.filters.getCount()) {
            e.snapshot = e.snapshot || e.data.clone();
            e.data = e.data.filter(e.filters.items);
            if (t) {
                e.sort();
            } else {
                e.fireEvent("datachanged", e);
                e.fireEvent("refresh", e);
            }
        }
    }
});

Ext.define("kerio.wm.messages.BindedTemplate", {
    extend: "Ext.XTemplate",
    alias: "widget.bindedtemplate",
    constructor: function(e, t, i) {
        var s, n, o;
        for (n in t) {
            if (t.hasOwnProperty(n)) {
                s = t[n];
                if (Ext.isFunction(s)) {
                    o = s;
                    t[n] = Ext.bind(function(e) {
                        var t = i.store.model && i.store.model.prototype.idProperty, s = i.store.getById(e[t || "id"]);
                        return o.apply(i, [ e, s ]);
                    }, i);
                }
            }
        }
        this.callParent(arguments);
    }
});

Ext.define("kerio.wm.messages.contacts.SearchField", {
    extend: "Ext.form.field.Base",
    alias: "widget.searchfield",
    componentCls: "searchFieldWithRemove",
    inputType: "searchInput",
    styles: !0,
    fieldSubTpl: [ '<table class="searchContainer" style="height: 28px;"><tr>', '<td class="searchIcon">&nbsp;</td>', '<td class="inputContainer"><input class="searchInput x-form-text" placeholder="" /></td>', '<td class="removeBtn empty">&nbsp;</td>', "</tr><table>" ].join(""),
    constructor: function(e) {
        this.fieldSubTpl = this.fieldSubTpl.replace('placeholder=""', 'placeholder="' + (e.emptyText || "") + '"');
        this.callParent(arguments);
    },
    afterRender: function() {
        this.searchIcon = this.el.down(".searchIcon");
        this.searchIcon.on("click", function() {
            this.focus();
            this.onSearchClick();
        }, this);
        this.inputEl = this.el.down(".searchInput");
        this.field = this.el.down(".searchField");
        this.removeEl = this.el.down(".removeBtn");
        this.removeEl.on("click", this.onRemoveClick, this);
        this.on("change", function(e, t, i, s) {
            if (t) {
                this.removeEl.removeCls("empty");
            } else {
                this.removeEl.addCls("empty");
            }
        }, this);
        this.inputEl.on("focus", function() {
            this.el.addCls("hasFocus");
        }, this);
        this.inputEl.on("click", function() {
            this.fireEvent("click");
        }, this);
        this.inputEl.on("blur", function() {
            this.el.removeCls("hasFocus");
        }, this);
    },
    onRemoveClick: function() {
        this.setValue("");
        this.focus();
    },
    onSearchClick: Ext.emptyFn
});

Ext.define("kerio.wm.messages.message.data.MessageModel", {
    extend: "kerio.wm.model.Model",
    fields: [ "messageId", "text", "event", "to", "from", {
        name: "time",
        convert: function(e) {
            if (e instanceof Date) {
                return e;
            }
            return Ext.Date.parseDate(e, "isoSeconds") || new Date();
        },
        deconvert: function(e) {
            return Ext.Date.format(e, "iso");
        }
    }, {
        name: "isRead",
        defaultValue: !1
    }, {
        name: "status",
        defaultValue: "sent"
    } ],
    statics: {
        status: {
            SENT: "sent",
            SENDING: "sending",
            FAILED: "failed",
            PENDING: "pending"
        }
    },
    idProperty: "messageId",
    constructor: function() {
        this.callParent(arguments);
    },
    isRead: function() {
        return !!this.data.isRead;
    },
    isSent: function() {
        return this.self.status.SENT === this.get("status");
    },
    isSending: function() {
        return this.self.status.SENDING === this.get("status");
    },
    isFailed: function() {
        return this.self.status.FAILED === this.get("status");
    }
});

Ext.define("kerio.wm.messages.ViewController", {
    view: null,
    constructor: function(e) {
        this.view = e.view;
        this.callParent(arguments);
        this.listeners && this.control(this.listeners);
    },
    control: function(e, t) {
        var i, s, n, o, r;
        i = e;
        if (Ext.isString(e)) {
            i = {};
            i[e] = t;
        }
        t = i;
        for (s in t) {
            if (t.hasOwnProperty(s)) {
                r = t[s];
                for (n in r) {
                    if (r.hasOwnProperty(n)) {
                        o = r[n];
                        if ("string" == typeof o) {
                            o = this[o];
                        }
                        this.view.query(s).on(n, o, this);
                    }
                }
            }
        }
    }
});

Ext.define("kerio.wm.view.TextArea", {
    extend: "Ext.form.field.TextArea",
    alias: "widget.textareagrowing",
    constructor: function() {
        this.callParent(arguments);
        if (this.autoHeight) {
            this.on("change", function() {
                Ext.defer(this._adjustEditorHeight, 1, this, Ext.Array.from(arguments));
            }, this, {
                buffer: 200
            });
        }
    },
    afterRender: function() {
        this.callParent(arguments);
        if (!this.autoHeight) {
            return;
        }
        this.sizeEl = Ext.DomHelper.append(Ext.getBody(), '<div class="textAreaTextMeasurement" style="visibility: hidden; position: absolute; top: 0; left: 0; word-break: break-all; white-space: pre-wrap"></div>');
        this.sizeEl.style.paddingTop = this._getInputPaddingPx("t");
        this.sizeEl.style.paddingRight = this._getInputPaddingPx("r");
        this.sizeEl.style.paddingBottom = this._getInputPaddingPx("b");
        this.sizeEl.style.paddingLeft = this._getInputPaddingPx("l");
        this.sizeEl.style.lineHeight = this.inputEl.getStyle("lineHeight");
        this.sizeEl.style.fontSize = this.inputEl.getStyle("fontSize");
        this.sizeEl.style.minHeight = this.minHeight + "px";
    },
    _getInputPaddingPx: function(e) {
        return (this.inputEl.getPadding(e) || 0) + "px";
    },
    _adjustEditorHeight: function(e, t) {
        var i, s = this.inputEl.dom, n = Math.min(this.maxAutoHeight, ~~(Ext.getBody().dom.clientHeight / 3));
        this.onBeforeAdjustHeight();
        this.sizeEl.style.width = s.clientWidth + "px";
        this.sizeEl.innerHTML = "&#x200b;" + Ext.String.htmlEncode(t).replace(/\n/g, "<br>&#x200b;");
        i = this.sizeEl.clientHeight + 2;
        if (i > n) {
            i = n;
        }
        if (i < this.minHeight) {
            i = this.minHeight - this.inputEl.getPadding("tb");
        }
        if (i === this._prevHeight) {
            return;
        }
        this._prevHeight = i;
        this.setSize(void 0, i);
        this.onAdjustHeight(void 0, i);
    },
    onBeforeAdjustHeight: Ext.emptyFn,
    onAdjustHeight: Ext.emptyFn
});

Ext.define("kerio.wm.messages.message.MessagePanel", {
    extend: "Ext.container.Container",
    alias: "widget.messagePanel",
    cls: "messagePanel",
    constructor: function(e) {
        this.items = [ {
            xtype: "messageview",
            itemId: "messageView",
            flex: 1,
            selectedThread: e.selectedThread
        }, {
            xtype: "messageeditor",
            itemId: "messageEditor",
            flex: 0,
            selectedThread: e.selectedThread,
            resizable: {
                handles: "n",
                pinned: !0
            }
        } ];
        this.callParent(arguments);
    }
});

Ext.define("kerio.wm.messages.LoadingMaskMixin", {
    requires: [],
    initLoadingMaskComponent: function(e) {
        this.component = e;
    },
    initLoadingMaskMessage: function(e) {
        this.message = e;
    },
    showLoading: function() {
        this.message = this.message || k_tr("Loading…", "common");
        if (!this.loadingMask) {
            this.loadingMask = new Ext.LoadMask(this.component, {
                msg: this.message
            });
        }
        this.loadingMask.show();
    },
    hideLoading: function() {
        if (!this.loadingMask) {
            return;
        }
        this.loadingMask.hide();
    }
});

Ext.define("kerio.wm.view.calendar.CalendarListPanel", {
    extend: "Ext.container.Container",
    alias: "widget.calendarListPanel",
    componentCls: "calendarListPanel",
    iconCls: void 0,
    border: !1,
    layout: {
        type: "hbox",
        align: "stretch",
        pack: "start"
    },
    constructor: function() {
        this.callParent(arguments);
        this.on("add", this.registerView);
    },
    getSelectionModel: function() {
        return;
    },
    registerView: function(e, t) {
        this.relayEvents(t, [ "selectionchange", "itemdblclick", "keydown", "keyup" ]);
    },
    getView: function() {
        return {
            refresh: Ext.emptyFn,
            focus: function() {
                this.fireEvent("viewfocus");
            }
        };
    }
});

Ext.define("kerio.wm.controller.PopupErrorController", {
    singleton: !0,
    element: null,
    msgElement: null,
    closeBtn: null,
    closeHandler: function(e) {
        this.close();
    },
    open: function(e) {
        if (!this.element) {
            this._create();
        }
        this.msgElement.innerText = e;
    },
    _create: function() {
        this.closeHandler = this.closeHandler.bind(this);
        var e = this.element = document.createElement("DIV");
        e.className = "popup_error-container";
        var t = document.createElement("DIV");
        t.className = "popup-error-inner";
        var i = this.msgElement = document.createElement("DIV");
        i.className = "popup-error";
        var s = document.createElement("DIV");
        s.className = "popup-error-lbl";
        s.innerText = k_tr("error", "common") + ":";
        var n = this.closeBtn = document.createElement("DIV");
        n.className = "popup-error-close";
        n.addEventListener("click", this.closeHandler, !1);
        t.appendChild(s);
        t.appendChild(i);
        t.appendChild(n);
        e.appendChild(t);
        document.body.appendChild(e);
    },
    close: function() {
        if (this.element) {
            this.closeBtn.removeEventListener("click", this.closeHandler, !1);
            this.closeBtn = null;
            document.body.removeChild(this.element);
            this.element = null;
            this.msgElement = null;
        }
    }
});

Ext.define("kerio.wm.controller.EventsOperations", {
    queryEvents: function(e, t, i, s, n, o) {
        var r, a, l, d = this.getStore("calendar.viewPanel.Events"), c = {};
        if (!n) {
            if (o) {
                c[o] = !0;
            } else {
                r = this.getController("CalendarController")._getCheckedFolders() || [];
                for (a = 0, l = r.length; l > a; a++) {
                    c[r[a].get("id")] = !0;
                }
            }
        }
        return d.queryBy(this._eventFilter, {
            scope: this,
            dates: {
                start: e,
                end: t
            },
            notInRange: i,
            forceStart: s,
            ignoreFolder: n,
            validFolders: c
        });
    },
    k_getEventsRange: function(e, t, i, s) {
        return this.queryEvents(e, t, !1, !1, i, s).getRange();
    },
    getEventsOutOfRange: function(e, t, i) {
        return this.queryEvents(e, t, !0, i, !0).getRange();
    },
    _eventFilter: function(e, t) {
        var i = Ext.Date, s = e.data, n = e.data.isLinked && kerio.wm.model.calendar.viewPanel.Event.linkOwner !== e.data.isLinked, o = n && !this.forceStart ? s.parentEnd : s.end, r = n && !this.forceStart ? s.parentStart : s.start, a = this.dates.start, l = this.dates.end;
        if (s.isAllDay && !n) {
            o = i.add(i.add(o, i.DAY, 1), i.MILLI, -1);
        }
        if ((this.ignoreFolder || this.validFolders[s.folderId]) && (o > a && l > r || 0 === e.k_getLength() && o >= a && l > r)) {
            return !this.notInRange;
        }
        return !!this.notInRange;
    },
    k_isEventMultiday: function(e) {
        var t = Ext.Date;
        if (!e.isAllDay && t.format(e.start, "Ymd") !== t.format(e.end, "Ymd") && t.format(e.start, "Ymd") !== t.format(t.add(e.end, t.SECOND, -1), "Ymd")) {
            return !0;
        }
        return !1;
    }
});

Ext.define("kerio.wm.controller.CalendarOperations", {
    getEventById: function(e, t, i, s) {
        Ext.getStore("calendar.viewPanel.Events").k_loadById(e, t, i, s);
    }
});

Ext.define("kerio.wm.controller.calendar.AgendaDays", {
    _getNextStep: function(e, t) {
        var i;
        if (t) {
            switch (e) {
              case 0:
                i = 28;
                break;

              case 1:
                i = 28;
                break;

              case 2:
                i = 84;
                break;

              case 4:
                i = 260;
            }
        } else {
            switch (e) {
              case 0:
                i = 28;
                break;

              case 1:
                i = 84;
                break;

              case 2:
                i = 290;
            }
        }
        return i;
    },
    _isInLoadedRange: function(e, t, i, s) {
        var n, o = this._getLoadedRange(s), r = o && o.start, a = o && o.end;
        if (r && a) {
            n = Ext.Date.between(e, r, a) && (void 0 === t || Ext.Date.between(t, r, a));
            if (n && i) {
                n = !this._isInLoadingRange(e, t);
            }
        }
        return n;
    },
    _isInLoadingRange: function(e, t, i, s) {
        var n, o, r, a = s && this._folderLoad && this._folderLoad[s], l = s ? a && a._loadingRange : this._loadingRange, d = l && l.length;
        for (o = 0; d > o; ++o) {
            n = l[o];
            if (n.start.valueOf() === e.valueOf() && n.end.valueOf() === t.valueOf()) {
                if (i) {
                    l.splice(o, 1);
                }
                r = !0;
                break;
            }
        }
        return r;
    },
    _updateLoadedRange: function(e, t, i, s, n) {
        var o, r, a = this._loadedRange || {}, l = this._oldLoadedRange || {}, d = a.start, c = a.end;
        if (!d || s && e.valueOf() !== d.valueOf() || d > e || e > c) {
            a.start = e;
            o = !0;
        }
        if (!c || s && t.valueOf() !== c.valueOf() || t > c || d > t) {
            a.end = t;
            o = !0;
        }
        if (s) {
            l = a;
        } else {
            if (!l.start || l.start > e) {
                l.start = e;
            }
            if (!l.end || l.end < t) {
                l.end = t;
            }
        }
        this._oldLoadedRange = l;
        if (o || n) {
            this._loadedRange = a;
            r = this.getEventsOutOfRange(l.start, l.end, n);
            if (r.length && this._currentView) {
                this._currentView.removeRedundant(r, n);
            }
            if (i) {
                if (!this._loadingRange) {
                    this._loadingRange = [];
                }
                this._loadingRange.push({
                    start: e,
                    end: t
                });
            }
        }
    },
    _updateFolderLoadedRange: function(e, t, i, s) {
        var n, o = s && this._folderLoad && this._folderLoad[s], r = o ? o._loadedRange : void 0, a = r && r.start, l = r && r.end;
        if (void 0 === r) {
            return;
        }
        if (!a || a > e || e > l) {
            r.start = e;
            n = !0;
        }
        if (!l || t > l || a > t) {
            r.end = t;
            n = !0;
        }
        if (n) {
            o._loadedRange = r;
            if (i) {
                if (!o._loadingRange) {
                    o._loadingRange = [];
                }
                o._loadingRange.push({
                    start: e,
                    end: t
                });
            }
        }
    },
    _getRealEndDay: function(e, t) {
        var i = Ext.Date.add(e, Ext.Date.DAY, t || 0);
        if (i > this._maxBaseDay) {
            i = Ext.Date.clone(this._maxBaseDay);
        }
        return i;
    },
    _getRealStartDay: function(e, t) {
        var i = Ext.Date.add(e, Ext.Date.DAY, t || 0);
        if (i < this._baseDay) {
            i = Ext.Date.clone(this._baseDay);
        }
        return i;
    },
    _getDefaultRangeToLoad: function(e, t, i) {
        var s, n = Ext.Date.add(e, Ext.Date.DAY, 28);
        if (i > n) {
            s = Ext.Date.clone(e);
        } else {
            n = i;
            s = Ext.Date.add(i, Ext.Date.DAY, -28);
        }
        return {
            start: s,
            end: n
        };
    },
    _getNextRangeToLoad: function(e, t, i, s, n) {
        var o, r, a, l, d, c = this._store, h = c.count(), u = this._getDefaultRangeToLoad(e, t, i), f = 0;
        if (!this._isInLoadedRange(u.start, u.end, !0)) {
            return;
        }
        if (this._oldLoadedRange && this._oldLoadedRange.end > this._loadedRange.end) {
            h = c.findDayIndex(this._loadedRange.end) + 1;
        }
        a = c.findDayIndex(e);
        if (n || 20 > h - a || s && !this._isRequiredDayCount(s, e, a)) {
            o = Ext.Date.clone(u.end);
            d = this._getNextStep(f++);
            while (d) {
                r = this._getRealEndDay(o, d);
                if (r > o) {
                    if (this._isInLoadedRange(o, r)) {
                        if (!this._isInLoadingRange(o, r)) {
                            o = r;
                            d = this._getNextStep(f++);
                            continue;
                        }
                    } else {
                        l = {
                            start: o,
                            end: r
                        };
                    }
                }
                d = 0;
            }
        } else {
            if (h - a > 50) {
                this._tryToReduceNextRange(u.start, a);
            }
        }
        return l;
    },
    _tryToReduceNextRange: function(e, t) {
        var i, s = e, n = 28, o = 0, r = this._store, a = t;
        while (n) {
            i = this._getRealEndDay(s, n);
            if (i > s && this._isInLoadedRange(s, i, !0)) {
                a = r.findDayIndex(i, a);
                if (50 >= a - t) {
                    s = i;
                    n = this._getNextStep(o++, !0);
                    continue;
                }
                this._updateLoadedRange(this._loadedRange.start, i, !1, !0);
            }
            n = 0;
        }
    },
    _getNextRangeToLoadFolder: function(e, t, i, s) {
        var n, o = this._getDefaultRangeToLoad(e, t, i);
        if (this._isInLoadedRange(o.start, o.end, !0, s) && this._folderLoad && this._folderLoad[s] && this._loadedRange && this._loadedRange.end && this._folderLoad[s]._loadedRange.end < this._loadedRange.end && o.end < this._loadedRange.end) {
            n = {
                start: o.end,
                end: this._loadedRange.end
            };
        }
        return n;
    },
    _getPrevRangeToLoad: function(e, t, i, s) {
        var n, o, r, a, l, d, c, h = this._store, u = 0;
        o = Ext.Date.clone(e);
        d = this._getNextStep(u++, !0);
        while (d) {
            n = this._getRealStartDay(o, -d);
            if (o > n) {
                if (this._isInLoadedRange(n, o)) {
                    if (!this._isInLoadingRange(n, o)) {
                        r = void 0 !== r ? r : h.findDayIndex(e);
                        if (void 0 === c) {
                            c = this._oldLoadedRange && this._oldLoadedRange.start < this._loadedRange.start ? h.findDayIndex(this._loadedRange.start) : 0;
                        }
                        if (s || 20 > r - c) {
                            o = n;
                            d = this._getNextStep(u++, !0);
                            continue;
                        } else {
                            if (1 === u && r - c > 50) {
                                l = !0;
                            }
                        }
                    }
                } else {
                    a = {
                        start: n,
                        end: o
                    };
                }
            }
            d = 0;
        }
        if (l) {
            this._tryToReducePrevRange(e, r);
        }
        return a;
    },
    _tryToReducePrevRange: function(e, t) {
        var i, s = e, n = t, o = this._store, r = 0, a = this._getNextStep(r++, !0);
        while (a) {
            i = this._getRealStartDay(s, -a);
            if (s > i && this._isInLoadedRange(i, s, !0)) {
                n = o.findDayIndex(i, 0, n);
                if (50 >= t - n) {
                    s = i;
                    a = this._getNextStep(r++, !0);
                    continue;
                }
                this._updateLoadedRange(i, this._loadedRange.end, !1, !0);
            }
            a = 0;
        }
    },
    _getPrevRangeToLoadFolder: function(e, t) {
        var i;
        if (this._folderLoad && this._folderLoad[t] && this._loadedRange && this._loadedRange.start && this._folderLoad[t]._loadedRange && this._folderLoad[t]._loadedRange.start > this._loadedRange.start) {
            i = {
                start: this._loadedRange.start,
                end: e
            };
        }
        return i;
    },
    _getAgendaRangeToLoad: function(e, t, i, s, n) {
        var o, r = Ext.Date.clone(this._baseDay), a = Ext.Date.clone(this._maxBaseDay);
        switch (t) {
          case this.CONST.checkRangeNext:
            if (!n) {
                o = this._getNextRangeToLoad(e, r, a, i, s);
            } else {
                o = this._getNextRangeToLoadFolder(e, r, a, n);
            }
            break;

          case this.CONST.checkRangePrev:
            if (!n) {
                o = this._getPrevRangeToLoad(e, r, a, s);
            } else {
                o = this._getPrevRangeToLoadFolder(e, n);
            }
            break;

          default:
            o = this._getDefaultRangeToLoad(e, r, a);
            if (this._isInLoadedRange(o.start, o.end, void 0, n)) {
                return;
            }
        }
        return o;
    },
    _reduceLoadedRange: function(e) {
        var t, i = this._store;
        if (e) {
            t = this._loadedRangeFromLoadedDays();
        } else {
            if (this._loadedRange && this._loadedRange.start && this._loadedRange.end) {
                t = {
                    start: this._loadedRange.start,
                    end: this._loadedRange.end
                };
            }
        }
        if (t) {
            this._updateLoadedRange(this._getRealStartDay(t.start), this._getRealEndDay(t.end), !1, !0, !0);
        } else {
            this._clearLoadedDates();
            if (i) {
                i.removeAll();
            }
        }
    },
    _loadedRangeFromLoadedDays: function() {
        var e, t, i, s = this._baseDay;
        if (this._loadedDates && this._loadedDates[s.valueOf()]) {
            e = Ext.Date.clone(s);
            t = e;
            s = Ext.Date.add(s, Ext.Date.DAY, 1);
            while (this._loadedDates[s.valueOf()]) {
                t = s;
                s = Ext.Date.add(s, Ext.Date.DAY, 1);
            }
            s = Ext.Date.add(e, Ext.Date.DAY, -1);
            while (this._loadedDates[s.valueOf()]) {
                e = s;
                s = Ext.Date.add(s, Ext.Date.DAY, -1);
            }
        }
        if (e && t) {
            i = {
                start: e,
                end: t
            };
        }
        this._loadedDates = {};
        return i;
    },
    _loadedDaysFromLoadedRange: function() {
        var e = this._loadedRange && this._loadedRange.start, t = this._loadedRange && this._loadedRange.end;
        this._clearLoadedDates();
        if (e && t) {
            this._k_setLoadedDates(e, t);
        }
    },
    _dayIsInAllowedRangeBorder: function(e, t) {
        if (!e) {
            return !1;
        }
        var i = this._store && this._store.getAt(0), s = i && Ext.Date.clearTime(i.data.start, !0), n = this._loadedRange.start.valueOf() === this._baseDay.valueOf(), o = this._loadedRange.end.valueOf() === this._maxBaseDay.valueOf(), r = e.valueOf() === s.valueOf();
        return n && r && "forward" !== t || o && !r && "backward" !== t;
    },
    _isInAllowedRange: function(e) {
        return e >= this._baseDay && e < this._maxBaseDay;
    },
    _isRequiredDayCount: function(e, t, i) {
        var s, n, o = this._store, r = o.count() - 1, a = t, l = 1;
        if (r - i >= e - 1) {
            for (n = i; r >= n && e > l; ++n) {
                s = Ext.Date.clearTime(o.getAt(n).data.start, !0);
                if (s > a) {
                    ++l;
                    a = s;
                }
            }
        }
        return l >= e;
    },
    _removeOldItems: function(e) {
        if (this._oldLoadedRange && this._loadedRange && (!this._loadingRange || 0 === this._loadingRange.length)) {
            if (this._oldLoadedRange.start < this._loadedRange.start || this._oldLoadedRange.end > this._loadedRange.end) {
                this._reduceLoadedRange();
            }
        }
    },
    _getLoadedRange: function(e) {
        if (e) {
            return this._folderLoad && this._folderLoad[e] ? this._folderLoad[e]._loadedRange : void 0;
        } else {
            return this._loadedRange;
        }
    }
});

Ext.define("kerio.wm.model.calendarInbox.CalendarInbox", {
    extend: "Ext.data.Model",
    idProperty: "id",
    fields: [ "id", "eventId", "eventFolderId", "occurrenceId", "isException", "seqNumber", "isObsolete", "deliveryTime", "type", "summary", "location", "start", "end", "totalEnd", "description", "attendee", "actions" ].concat([ {
        name: "sortValue",
        persist: !1
    }, {
        name: "attendees",
        persist: !1,
        defaultValue: []
    }, {
        name: "mailIds",
        persist: !1,
        defaultValue: []
    }, {
        name: "event",
        persist: !1,
        defaultValue: {}
    }, {
        name: "folder",
        persist: !1,
        defaultValue: {}
    }, {
        name: "isDelegated",
        persist: !1,
        defaultValue: !1
    }, {
        name: "replyComment",
        persist: !1,
        defaultValue: ""
    }, {
        name: "isCorrupted",
        persist: !0,
        defaultValue: !1,
        type: "boolean"
    } ]),
    constructor: function(e) {
        this.callParent(arguments);
        this.data.isCorrupted = !this.data.start || !this.data.end;
    },
    eventHasEnded: function() {
        var e;
        e = this.get("totalEnd");
        if ("" === e) {
            e = "99991231";
        }
        return Ext.Date.parseDate(e, "iso").getTime() < kerio.wm.getCurrentDate().getTime();
    },
    isRequest: function() {
        return "EUpdateRequest" === this.get("type");
    },
    isReply: function() {
        return "EUpdateReply" === this.get("type");
    },
    isCancel: function() {
        return "EUpdateCancel" === this.get("type");
    },
    isException: function() {
        return this.get("isException");
    },
    setReplyComment: function(e) {
        this[this.persistenceProperty].replyComment = e;
    },
    getReplyComment: function() {
        return this.get("replyComment") || "";
    }
});

Ext.define("kerio.wm.view.calendar.MeetingReplyField", {
    extend: "Ext.form.field.TextArea",
    alias: "widget.meetingreplyfield",
    emptyText: k_tr("Your reply", "calendar"),
    maxLength: 255,
    enableKeyEvents: !0,
    grow: !0,
    growMin: 30,
    onRender: function() {
        this.callParent(arguments);
        if (void 0 !== this.maxLength) {
            this.inputEl.dom.setAttribute("maxLength", this.maxLength);
        }
    },
    getValue: function() {
        var e = this.callParent(arguments), t = this.maxLength;
        if (void 0 !== t && e.length > t) {
            return e.substring(0, t);
        }
        return e;
    }
});

Ext.define("kerio.wm.view.MenuButton", {
    extend: "kerio.wm.view.WebmailButton",
    alias: "widget.menubutton",
    showMenuArrow: !0,
    constructor: function(e) {
        e = e || {};
        e.split = !1;
        this.callParent(arguments);
    },
    initComponent: function() {
        this.callParent(arguments);
        var e, t = this.menu.items.getRange();
        this.addCls("menuButton");
        for (e = 0; e < t.length; ++e) {
            this.mon(t[e], "click", this._onItemClick, this);
        }
    },
    _onItemClick: function(e) {
        var t = e.itemId;
        this.setValue(t);
    },
    setValue: function(e, t) {
        var i = this.menu.getComponent(e), s = i && i.text || t || e, n = i && i.value || t || e;
        this.setText(s);
        this.value = n;
    },
    getValue: function() {
        return this.value;
    }
});

Ext.define("kerio.wm.utils.ColorProvider", {
    extend: "Ext.util.Observable",
    alias: "widget.k_colorprovider",
    statics: {
        defaultColors: {
            "#E6BE03": "E6BE03",
            "#F52C68": "F52C68",
            "#4BB72E": "4BB72E",
            "#0BA1F2": "0BA1F2",
            "#BF63D9": "BF63D9",
            "#999999": "999999",
            "#F2861B": "F2861B"
        },
        oldDefaultColors: {
            "#A2E3FC": "#8BDCFB",
            "#FCA7B1": "#FF495E",
            "#EBD176": "#E6C554",
            "#8CE773": "#6FE050",
            "#DCA0FF": "#D388FF",
            "#F5BB1E": "#CF9A09",
            "#71BEFA": "#4DAEF9",
            "#B5F93E": "#A3F80E",
            "#24E2B8": "#17B18F",
            "#CCCCCC": "#C6B9B9"
        }
    },
    constructor: function(e) {
        this._k_initColors(e);
        this.callParent(arguments);
    },
    k_getColorName: function(e) {
        return this._k_colors.findKey(e);
    },
    k_getColorCode: function(e) {
        return this._k_colors.get(e);
    },
    k_getColorCodes: function() {
        return this._k_colors.getValues();
    },
    k_getNotUsedColor: function() {
        var e, t, i = this._k_usedColors, s = i.length;
        Ext.Array.sort(i, function(e, t) {
            if (e.count < t.count) {
                return 1;
            }
            if (e.count > t.count) {
                return -1;
            }
            return 0;
        });
        for (e = 1; s > e; e++) {
            if (i[e - 1].count > i[e].count) {
                t = i[e].color;
            }
        }
        if (!t) {
            t = i[0].color;
        }
        this._k_pushColor(t);
        return t;
    },
    k_colorExists: function(e) {
        return this._k_colors.containsKey(e);
    },
    k_changeColor: function(e, t) {
        if (e) {
            this._k_removeColor(e);
        }
        this._k_pushColor(t);
    },
    k_getColor: function(e, t, i) {
        if (t && !e) {
            e = this._k_defaultCalendarColor;
        }
        if (e) {
            var s = this._lightColors[e];
            e = this.self.oldDefaultColors[e] || e;
            if (i) {
                this._k_pushColor(e);
            }
            if (s) {
                e = {
                    normal: e,
                    light: s
                };
            }
        }
        return e;
    },
    _k_initColors: function(e) {
        var t, i, s, n = e && e.k_colors ? e.k_colors : this.self.defaultColors, o = [];
        if (!(n instanceof Ext.util.HashMap)) {
            t = Ext.create("Ext.util.HashMap");
            for (i in n) {
                if (n.hasOwnProperty(i)) {
                    s = n[i];
                    if (Ext.isObject(s) && s.normal) {
                        t.add(i, s.normal);
                        if (s.light) {
                            o[i] = s.light;
                        }
                    } else {
                        t.add(i, s);
                    }
                }
            }
            n = t;
        }
        this._k_colors = n;
        this._lightColors = o;
        this._k_usedColors = [];
        this._k_colors.each(function(e, t, i) {
            this._k_usedColors.push({
                color: e,
                count: 0
            });
        }, this);
        this._k_defaultCalendarColor = this._k_usedColors[0].color;
    },
    _k_pushColor: function(e) {
        var t, i, s = this._k_usedColors, n = s.length;
        if (!this.k_colorExists(e)) {
            return;
        }
        for (t = 0; n > t; t++) {
            i = s[t];
            if (i.color === e) {
                i.count++;
                return;
            }
        }
    },
    _k_removeColor: function(e) {
        var t, i, s = this._k_usedColors, n = s.length;
        for (t = 0; n > t; t++) {
            i = s[t];
            if (i.color === e) {
                i.count--;
                return;
            }
        }
    }
});

Ext.define("kerio.wm.data.CalendarTreeReader", {
    extend: "kerio.wm.data.MemoryFolderReader",
    alias: "reader.calendartreereader",
    statics: {
        sortFunction: function(e, t) {
            e = e[e.persistenceProperty].calendarName.toUpperCase(), t = t[t.persistenceProperty].calendarName.toUpperCase();
            if (kerio.wm.utils.Latinize.isMultibyteString(e) || kerio.wm.utils.Latinize.isMultibyteString(t)) {
                try {
                    return e.localeCompare(t);
                } catch (i) {
                    return 0;
                }
            } else {
                if (e > t) {
                    return 1;
                }
                if (t > e) {
                    return -1;
                }
                return 0;
            }
        }
    },
    beforeCreateRecords: function(e) {
        if (0 === e.length || "FRoot" !== e[0].type) {
            return;
        }
        var t, i, s, n = [], o = [], r = [], a = [], l = [], d = [], c = e[0].id;
        n.push(e[0]);
        n.push(this._createFakeFolder("", k_tr("MY CALENDARS", "calendar"), {
            placeType: "FPlaceMailbox",
            type: "FCalendar",
            access: "FAccessAdmin",
            rootId: c
        }));
        this.filterRecords(e, "FCalendar", !0, !0);
        for (s = 0; s < e.length; s++) {
            i = e[s];
            if (this._isRootFolder(i)) {
                if (this._isPublicFolder(i)) {
                    t = i;
                } else {
                    continue;
                }
            }
            if (this._isMyFolder(i)) {
                if (i.published) {
                    if (!o.length) {
                        i.type = "FCalendar";
                        o.push(this._createIcalFakeFolder(i));
                    }
                    o.push(i);
                } else {
                    i.allowDrag = !1;
                    n.push(i);
                }
            } else {
                if (this._isPeopleFolder(i)) {
                    if (i.isSubscribed) {
                        if (i.isDelegated && "FSubDefault" === i.subType) {
                            if (!l.length) {
                                i.type = "FCalendar";
                                l.push(this._createFakeFolder("DELEGATION", k_tr("DELEGATION", "folders"), i, "FAccessListingOnly", "FakeDelegation"));
                            }
                            l.push(i);
                        } else {
                            if (!a.length) {
                                i.type = "FCalendar";
                                a.push(this._createFakeFolder("PEOPLE", k_tr("PEOPLE", "folders"), i));
                            }
                            a.push(i);
                        }
                    }
                } else {
                    if (this._isResouceFolder(i)) {
                        if (!r.length) {
                            r.push(this._createFakeFolder("RESOURCES", k_tr("RESOURCES", "folders"), i));
                        }
                        r.push(i);
                    } else {
                        if (this._isPublicFolder(i)) {
                            if (i.published) {
                                if (!o.length) {
                                    i.type = "FCalendar";
                                    o.push(this._createIcalFakeFolder(i));
                                }
                                o.push(i);
                            } else {
                                if (!d.length) {
                                    if (this._isRootFolder(i)) {
                                        if ("FAccessAdmin" === i.access) {
                                            d.push(this._createFakeFolder(t.id, k_tr("PUBLIC CALENDARS", "folders", {
                                                k_comment: ""
                                            }), t, t.access));
                                        }
                                        continue;
                                    } else {
                                        d.push(this._createFakeFolder(t.id, k_tr("PUBLIC CALENDARS", "folders", {
                                            k_comment: ""
                                        }), t, t.access));
                                    }
                                }
                                d.push(i);
                            }
                        } else {
                            if (this._isArchiveFolder(i)) {
                                continue;
                            } else {}
                        }
                    }
                }
            }
            i.nestingLevel = 2;
            i.leaf = !0;
        }
        e.splice(0, e.length);
        e.push.apply(e, n.concat(o, a, l, r, d));
    },
    _createIcalFakeFolder: function(e) {
        return this._createFakeFolder("iCal", k_tr("iCal", "folders"), e, "FAccessReadWrite", "FakeIcal");
    },
    applyOnRecords: function(e) {
        var t, i;
        for (t = 0; t < e.length; t++) {
            i = e[t];
            if ("FakeSubType" === i.data.subType) {
                i.data.checked = null;
            }
        }
    }
});

Ext.define("kerio.wm.utils.calendar.EventCollection", {
    extend: "Ext.util.MixedCollection",
    constructor: function() {
        this.callParent(arguments);
        this.addEvents("beforereplace", "afterreplace");
    },
    replace: function(e, t) {
        var i, s, n, o, r, a = this, l = arguments;
        if (1 === l.length) {
            t = l[0];
            e = a.getKey(t);
        }
        n = a.map[e];
        if ("undefined" == typeof e || null === e || "undefined" == typeof n) {
            t.updateTime = +kerio.wm.getCurrentDate();
            return a.add(e, t);
        }
        r = a.indexOfKey(e);
        i = a.items[r];
        s = void 0 !== i.updateTime ? this.requestTime >= i.updateTime : !0;
        if (s && !1 !== this.fireEvent("beforereplace", i)) {
            a.items[r] = t;
            i = a.items[r];
            i.updateTime = +kerio.wm.getCurrentDate();
            o = e;
            e = i.internalId;
            a.keys[r] = e;
            a.map[e] = i;
            if (o !== e) {
                delete a.map[o];
            }
            this.fireEvent("afterreplace", e, n, i);
        }
        return i;
    },
    addAll: function(e, t) {
        var i, s, n, o, r = this;
        if (Ext.isObject(t) || Ext.isArray(e)) {
            s = e.length;
            if (1 === s && t.k_origRecord) {
                o = t.k_origRecord.internalId;
                r.replace(t.forceReplace && void 0 === r.map[o] ? e[0].data.id : o, e[0]);
            } else {
                for (i = 0; s > i; i++) {
                    r.replace(e[i].data.id, e[i]);
                }
            }
        } else {
            for (n in e) {
                if (e.hasOwnProperty(n)) {
                    if (r.allowFunctions || "function" != typeof e[n]) {
                        r.replace(t.k_origRecord ? t.k_origRecord.internalId : n, e[n]);
                    }
                }
            }
        }
    },
    setRequestTime: function(e) {
        this.requestTime = e;
    }
});

Ext.define("kerio.wm.view.calendar.viewPanel.WeekViewConsts", {
    _k_CONST: {
        k_drawAfter: 3,
        k_prevJumperId: "calPrevEvent-",
        k_nextJumperId: "calNextEvent-",
        k_millisInMinute: 6e4,
        k_maxAllDayCount: 4,
        k_separator: "-",
        k_leftBarWidth: 50,
        k_leftBarMaxWidth: 75,
        k_minEventLengthInMillis: 18e5,
        k_scrollerTopIndexMax: 49,
        k_allDayHeaderContentWrapHeight: 28,
        k_afterScroller: 4,
        k_maxAllDayHeaderHeight: 85,
        k_allDayEventHeight: 19,
        k_granularity: 30,
        k_countOfSelectableUnits: 48,
        k_scale: 24
    }
});

Ext.define("kerio.wm.view.calendar.viewPanel.ViewOperations", {
    _k_setViewWidths: function(e, t) {
        if (!this._k_viewPanelCard) {
            return;
        }
        var i, s = this._k_viewPanelCard.getWidth(), n = t || this._k_CONST.k_leftBarWidth, o = this.k_dayColumns, r = e !== !1 ? this._k_CONST.k_scrollbarSize.width : 0;
        if (!s || 10 > s) {
            return;
        }
        i = s - r - n;
        this.k_dayWidth = Math.floor(i / o);
        if (o > 1) {
            this._k_leftBarWidthCounted = (s - r) % this.k_dayWidth;
        } else {
            this._k_leftBarWidthCounted = n;
        }
    },
    _k_setLeftBarWidth: function() {
        if (void 0 !== this._k_leftBarWidthCounted) {
            var e, t = this._getCalHeaders();
            for (e = 0; e < t.length; ++e) {
                t[e].setStyle({
                    left: this._k_leftBarWidthCounted + "px"
                });
            }
            this._k_timebar.setStyle({
                width: this._k_leftBarWidthCounted + "px"
            });
        }
    },
    _k_setColumnWidths: function(e) {
        if (!e || !this.k_dayWidth) {
            return;
        }
        e.each(function(e, t, i) {
            e.setStyle({
                left: i * this.k_dayWidth + "px",
                width: this.k_dayWidth + 1 + "px"
            });
        }, this);
    },
    _k_getTop: function(e) {
        var t = this._k_CONST, i = 60 * e.getHours() + e.getMinutes(), s = i / t.k_granularity;
        return Math.floor(s * t.k_scale) - 1;
    },
    k_addOpacity: function(e) {
        var t = e.k_getParts();
        Ext.Array.each(t, this._k_addOpacity, this);
    },
    _k_addOpacity: function(e) {
        if (e.k_eventBox) {
            e.k_eventBox.k_addOpacityCls();
        }
    },
    k_removeOpacity: function(e) {
        var t = e.k_getParts();
        Ext.Array.each(t, this._k_removeOpacity, this);
    },
    _k_removeOpacity: function(e) {
        if (e.k_eventBox) {
            e.k_eventBox.k_removeOpacityCls();
        }
    }
});

Ext.define("kerio.wm.view.calendar.folderPanel.MiniCalContainer", {
    extend: "Ext.container.Container",
    alias: "widget.k_minicalcontainer",
    requires: [ "kerio.wm.Constants" ],
    height: 208,
    styles: !0,
    layout: "fit",
    anchor: "100%",
    cls: "calMiniCalContainer",
    margin: kerio.wm.Constants.DEFAULT_MARGIN,
    items: {
        xtype: "k_minical"
    }
});

Ext.define("kerio.wm.view.calendar.folderPanel.MiniCal", {
    extend: "Ext.picker.Date",
    requires: [ "kerio.wm.Constants", "kerio.wm.LocalesProvider" ],
    alias: "widget.k_minical",
    cls: "minical",
    styles: !0,
    doCancelFocus: !0,
    k_highlightCls: "calWeekHighlight",
    todayText: k_tr("Today", "calendar"),
    ariaTitle: "",
    monthYearText: k_tr("Choose a month", "calendar"),
    disableAnim: !0,
    dayNames: [ k_tr("Sunday", "calendar"), k_tr("Monday", "calendar"), k_tr("Tuesday", "calendar"), k_tr("Wednesday", "calendar"), k_tr("Thursday", "calendar"), k_tr("Friday", "calendar"), k_tr("Saturday", "calendar") ],
    minDate: new Date(1601, 0, 2),
    maxDate: new Date(9999, 11, 31),
    k_viewPanelDateCls: "calMinicalViewPanelDate",
    k_viewPanelEndDateCls: "calMinicalViewPanelEndDate",
    constructor: function() {
        this.longDayFormat = Ext.Date.patterns.dateFullMonthYear;
        this.startDay = kerio.wm.LocalesProvider.getFirstWeekDay();
        this.callParent(arguments);
    },
    _k_unHighlightAll: function() {
        var e = this.getEl();
        e.select("." + this.k_highlightCls).removeCls(this.k_highlightCls);
        e.select("." + this.k_viewPanelDateCls).removeCls(this.k_viewPanelDateCls);
        e.select("." + this.k_viewPanelEndDateCls).removeCls(this.k_viewPanelEndDateCls);
        e.select(".leftTop").removeCls("leftTop");
        e.select(".leftBottom").removeCls("leftBottom");
        e.select(".rightTop").removeCls("rightTop");
        e.select(".rightBottom").removeCls("rightBottom");
    },
    k_setHighlight: function(e, t, i) {
        if (!i && this._k_dayCountToHighlight === t && this._k_firstDayToHighlight && e && this._k_firstDayToHighlight.valueOf() === e.valueOf()) {
            return;
        }
        var s, n, o, r, a, l, d, c = this.getEl().select("td"), h = 0, u = [], f = [];
        this._k_firstDayToHighlight = e;
        this._k_dayCountToHighlight = t;
        this._k_unHighlightAll();
        this._k_markViewPanelDates();
        s = this.getEl().down("." + this.k_viewPanelDateCls);
        n = this.getEl().down("." + this.k_viewPanelEndDateCls);
        if (!s && !n) {
            return;
        }
        this._k_isStartReached = !1;
        this._k_isEndReached = !1;
        if (!s && n) {
            this._k_isStartReached = !0;
        }
        delete this._k_endIndex;
        c.each(function(e, i, s) {
            if (e.hasCls(this.k_viewPanelDateCls)) {
                this._k_isStartReached = !0;
            }
            if (e.hasCls(this.k_viewPanelEndDateCls)) {
                this._k_isEndReached = !0;
                this._k_endIndex = s;
            }
            if (this._k_isStartReached && !this._k_isEndReached) {
                e.addCls(this.k_highlightCls);
                if (0 === h) {
                    e.addCls("leftTop");
                    r = 6 - s % 7;
                    if (6 !== r) {
                        e.addCls("leftBottom");
                    }
                    if (r + 1 >= t) {
                        u.push(s + t - 1);
                        a = !0;
                    } else {
                        u.push(s + r);
                        if (7 > t - r - 1) {
                            f.push(s + r);
                        }
                    }
                    if (!a && (6 !== r || 7 > t - r - 1)) {
                        o = r + 1;
                    }
                } else {
                    if (h === o) {
                        if (6 !== r) {
                            e.addCls("leftTop");
                        }
                        if (7 > t - r - 1) {
                            u.push(s - r + t - 2);
                        }
                    }
                }
                ++h;
            }
        }, this);
        for (l = 0, d = f.length; d > l; ++l) {
            c.item(f[l]).addCls("rightBottom");
        }
        for (l = 0, d = u.length; d > l; ++l) {
            c.item(u[l]).addCls("rightTop");
        }
        if (void 0 !== this._k_endIndex && 0 !== this._k_endIndex) {
            c.item(this._k_endIndex - (this._k_endIndex - 1) % 7 - 1).addCls("leftBottom");
            c.item(this._k_endIndex - 1).addCls("rightBottom");
        }
        if (!this._k_isEndReached) {
            c.item(c.getCount() - 7).addCls("leftBottom");
            c.last().addCls("rightBottom");
        }
        if (1 === t) {
            s.removeCls(this.k_highlightCls);
        }
    },
    _k_markViewPanelDates: function() {
        if (!this._k_firstDayToHighlight) {
            return;
        }
        var e = this, t = +this._k_firstDayToHighlight, i = +Ext.Date.add(this._k_firstDayToHighlight, Ext.Date.DAY, this._k_dayCountToHighlight || 1), s = e.cells, n = e.k_viewPanelDateCls, o = e.k_viewPanelEndDateCls;
        s.removeCls(n);
        s.each(function(e) {
            if (e.dom.firstChild.dateValue === t) {
                e.addCls(n);
                return !1;
            }
        }, this);
        s.removeCls(o);
        s.each(function(e) {
            if (e.dom.firstChild.dateValue === i) {
                e.addCls(o);
                return !1;
            }
        }, this);
    }
});

Ext.define("kerio.wm.layout.calendar.LeftPanel", {
    extend: "Ext.layout.container.VBox",
    alias: [ "layout.calendarleftpanel" ],
    calculateChildBoxes: function(e, t) {
        var i, s, n, o, r, a, l, d, c, h, u, f, m, p, g, _, k, v, y, w, E, x, b, C, S, I, D, T, A, F, M = this, P = Math, R = P.max, L = 1 / 0, N = M.parallelPrefix, O = M.parallelPrefixCap, B = M.perpendicularPrefix, V = M.perpendicularPrefixCap, H = "min" + O, U = "min" + V, W = "max" + V, q = t[N] - M.scrollOffset, G = t[B], z = M.padding, j = z[M.parallelBefore], Y = j + z[M.parallelAfter], K = z[M.perpendicularLeftTop], Q = K + z[M.perpendicularRightBottom], X = R(0, G - Q), Z = M.innerCt.getBorderWidth(M.perpendicularLT + M.perpendicularRB), J = "start" == M.pack, $ = "center" == M.pack, ee = "end" == M.pack, te = Ext.Number.constrain, ie = e.length, se = 0, ne = 0, oe = 0, re = 0, ae = 0, le = [], de = [];
        for (n = 0; ie > n; n++) {
            o = e[n];
            a = o[B];
            if (!o.flex || "stretch" != M.align && "stretchmax" != M.align) {
                if (o.componentLayout.initialized !== !0) {
                    M.layoutItem(o);
                }
            }
            l = o.margins;
            I = l[M.parallelBefore] + l[M.parallelAfter];
            c = {
                component: o,
                margins: l
            };
            if (o.flex) {
                ne += o.flex;
                r = i;
            } else {
                if (!o[N] || !a) {
                    d = o.getSize();
                }
                r = o[N] || d[N];
                a = a || d[B];
            }
            se += I + (r || 0);
            oe += I + (o.flex ? o[H] || 0 : r);
            re += I + (o[H] || r || 0);
            if ("number" != typeof a) {
                a = o["get" + V]();
            }
            ae = R(ae, R(a, o[U] || 0) + l[M.perpendicularLeftTop] + l[M.perpendicularRightBottom]);
            c[N] = r || i;
            c.dirtySize = o.componentLayout.lastComponentSize ? c[N] !== o.componentLayout.lastComponentSize[N] : !1;
            c[B] = a || i;
            le.push(c);
        }
        if (!M.autoSize) {
            h = oe - q;
            u = re > q;
        }
        f = R(0, q - se - Y - (M.reserveOffset ? M.availableSpaceOffset : 0));
        if (u) {
            for (n = 0; ie > n; n++) {
                k = le[n];
                m = e[n][H] || e[n][N] || k[N];
                k.dirtySize = k.dirtySize || k[N] != m;
                k[N] = m;
            }
        } else {
            if (h > 0) {
                for (n = 0; ie > n; n++) {
                    p = e[n];
                    m = p[H] || 0;
                    if (p.flex) {
                        k = le[n];
                        k.dirtySize = k.dirtySize || k[N] != m;
                        k[N] = m;
                    } else {
                        if (M.shrinkToFit) {
                            de.push({
                                minSize: m,
                                available: le[n][N] - m,
                                index: n
                            });
                        }
                    }
                }
                Ext.Array.sort(de, M.minSizeSortFn);
                for (n = 0, g = de.length; g > n; n++) {
                    _ = de[n].index;
                    if (_ == i) {
                        continue;
                    }
                    p = e[_];
                    m = de[n].minSize;
                    k = le[_];
                    v = k[N];
                    y = R(m, v - P.ceil(h / (g - n)));
                    w = v - y;
                    k.dirtySize = k.dirtySize || k[N] != y;
                    k[N] = y;
                    h -= w;
                }
                u = h > 0;
            } else {
                b = f;
                C = ne;
                x = [];
                for (n = 0; ie > n; n++) {
                    o = e[n];
                    if (J && o.flex) {
                        x.push(le[Ext.Array.indexOf(e, o)]);
                    }
                }
                Ext.Array.sort(x, M.flexSortFn);
                for (n = 0; n < x.length; n++) {
                    D = x[n];
                    o = D.component;
                    l = D.margins;
                    S = P.ceil(o.flex / C * b);
                    F = o.getLayoutSize ? o.getLayoutSize() : {
                        width: 0,
                        height: 0
                    };
                    S = Math.max(o["min" + O] || 0, P.min(o["max" + O] || F[N] || L, S));
                    b -= S;
                    C -= o.flex;
                    D.dirtySize = D.dirtySize || D[N] != S;
                    D[N] = S;
                }
            }
        }
        if ($) {
            j += f / 2;
        } else {
            if (ee) {
                j += f;
            }
        }
        if (M.owner.dock && (Ext.isIE6 || Ext.isIE7 || Ext.isIEQuirks) && !M.owner.width && "vertical" == M.direction) {
            s = ae + M.owner.el.getPadding("lr") + M.owner.el.getBorderWidth("lr");
            if (M.owner.frameSize) {
                s += M.owner.frameSize.left + M.owner.frameSize.right;
            }
            X = Math.min(X, t.width = ae + z.left + z.right);
        }
        for (n = 0; ie > n; n++) {
            o = e[n];
            D = le[n];
            l = D.margins;
            T = l[M.perpendicularLeftTop] + l[M.perpendicularRightBottom];
            j += l[M.parallelBefore];
            D[M.parallelBefore] = j;
            D[M.perpendicularLeftTop] = K + l[M.perpendicularLeftTop];
            if ("stretch" == M.align) {
                A = te(X - T, o[U] || 0, o[W] || L);
                D.dirtySize = D.dirtySize || D[B] != A;
                D[B] = A;
            } else {
                if ("stretchmax" == M.align) {
                    A = te(ae - T, o[U] || 0, o[W] || L);
                    D.dirtySize = D.dirtySize || D[B] != A;
                    D[B] = A;
                } else {
                    if (M.align == M.alignCenteringString) {
                        E = R(X, ae) - Z - D[B];
                        if (E > 0) {
                            D[M.perpendicularLeftTop] = K + Math.round(E / 2);
                        }
                    }
                }
            }
            j += (D[N] || 0) + l[M.parallelAfter];
        }
        return {
            boxes: le,
            meta: {
                calculatedWidth: s,
                maxSize: ae,
                nonFlexSize: se,
                desiredSize: oe,
                minimumSize: re,
                shortfall: h,
                tooNarrow: u
            }
        };
    }
});

Ext.define("kerio.wm.controller.calendar.editPanel.StartEndFields", {
    singleton: !0,
    _startField: null,
    editorController: void 0,
    _endField: null,
    _oldStart: null,
    _oldEnd: null,
    _callback: null,
    _callbackScope: null,
    _startTimeStoreCnt: null,
    _isAlldayOn: !1,
    setStartEndSynchro: function() {
        var e = function(e, t) {
            if (t.getKey() === t.ENTER) {
                t.stopEvent();
                if (!e.isValid()) {
                    return;
                }
                e.setValue(e.getRawValue());
                e.triggerBlur();
                e.blur();
                if (!e.isExpanded) {
                    this.editorController.save();
                }
            }
        };
        this._startField = this.editorController.getSubcomponents("start");
        this._endField = this.editorController.getSubcomponents("end");
        this._startField.dateField.on({
            scope: this,
            select: this._changeEndToKeepDuration,
            blur: this._changeEndToKeepDuration,
            specialkey: e
        });
        this._startField.timeField.on({
            scope: this,
            specialkey: e,
            select: this._startTimeFieldHandler,
            blur: this._startTimeFieldHandler
        });
        this._endField.timeField.on({
            scope: this,
            select: this._endTimeFieldHandler,
            blur: this._endTimeFieldHandler,
            specialkey: e
        });
        this._endField.dateField.on({
            scope: this,
            select: this._endDateFieldHandler,
            blur: this._endDateFieldHandler,
            specialkey: e
        });
    },
    initSynchro: function(e, t) {
        this._changeEndTimeRange(!0);
        this._oldStart = this._startField.getValue();
        this._oldEnd = this._endField.getValue();
        this._callback = e;
        this._callbackScope = t;
    },
    _fireCallback: function() {
        if (this._callback && this._callbackScope) {
            this._callback.call(this._callbackScope, this._startField, this._endField.dateField);
        }
    },
    _startTimeFieldHandler: function() {
        this._changeEndToKeepDuration();
        this._changeEndTimeRange();
    },
    _endTimeFieldHandler: function() {
        if (this._changeEndOverMignight()) {
            this._changeEndTimeRange(!0);
        }
    },
    _endDateFieldHandler: function() {
        if (this._changeStartAfterEnd()) {
            this._changeEndTimeRange(!0);
        }
    },
    _isValid: function() {
        return this._startField.isValid() && this._endField.isValid();
    },
    setAllday: function(e) {
        this._isAlldayOn = e;
        this._startField.timeField.setVisible(!e);
        this._endField.timeField.setVisible(!e);
    },
    _changeEndToKeepDuration: function() {
        if (!this._isValid()) {
            return;
        }
        var e, t, i, s = this._oldStart;
        t = this._startField.getValue();
        if (!s || !t) {
            return;
        }
        if (t.valueOf() !== s.valueOf()) {
            e = this._endField.getValue() - s;
            i = Ext.Date.add(t, Ext.Date.MILLI, e);
            this._endField.setValue(i);
            this._oldStart = t;
            this._oldEnd = i;
            this._fireCallback();
        }
    },
    _changeEndOverMignight: function() {
        if (!this._isValid()) {
            return;
        }
        var e, t = this._oldStart, i = this._oldEnd, s = this._endField.getValue(), n = this._startField.dateField.getValue();
        if (!s || !n) {
            return;
        }
        if (this._endField.dateField.getValue().valueOf() === n.valueOf()) {
            if (t > s) {
                s = Ext.Date.add(s, Ext.Date.DAY, 1);
                e = !0;
            }
        }
        if (!i || s.valueOf() !== i.valueOf()) {
            this._endField.setValue(s);
            this._oldEnd = s;
            this._fireCallback();
        }
        return e;
    },
    _changeStartAfterEnd: function() {
        if (!this._isValid()) {
            return;
        }
        var e, t, i = this._oldStart, s = this._endField.getValue();
        if (!s) {
            return;
        }
        if (i > s) {
            e = kerio.wm.Utils.combineDateAndTime(s, i);
            if (e > s) {
                e = Ext.Date.add(e, Ext.Date.DAY, -1);
            }
            this._startField.setValue(e);
        }
        if (!this._oldEnd || s.valueOf() !== this._oldEnd.valueOf()) {
            t = !0;
            this._oldStart = e || this._oldStart;
            this._oldEnd = s;
            this._fireCallback();
        }
        return t;
    },
    _changeEndTimeRange: function(e) {
        if (!this._isValid() || !this._startField.timeField.rendered || !this._endField.timeField.rendered) {
            return;
        }
        var t, i, s, n, o, r, a, l, d = this._startField.dateField.getValue(), c = this._endField.dateField.getValue(), h = [];
        if (!d || !c) {
            return;
        }
        t = d.valueOf() !== c.valueOf();
        if (t && !e) {
            return;
        }
        s = this._endField.timeField.getValue();
        o = this._endField.timeField.getPicker().getStore();
        if (!this._startTimeStoreCnt) {
            this._startTimeStoreCnt = this._startField.timeField.getPicker().getStore().getCount();
        }
        if (t) {
            i = d;
        } else {
            i = this._startField.timeField.getValue();
        }
        n = i.getMinutes();
        if (n > 0 && 30 >= n) {
            n = 30;
        } else {
            n = 0;
        }
        r = new Date(i.setMinutes(n));
        o.removeAll();
        for (a = 0, l = this._startTimeStoreCnt; l > a; a++) {
            h.push({
                date: r,
                disp: Ext.Date.format(r, this._endField.timeField.format)
            });
            r = Ext.Date.add(r, Ext.Date.MINUTE, 30);
        }
        o.loadData(h);
        this._endField.timeField.setValue(s);
    }
});

Ext.define("kerio.wm.model.calendar.editPanel.RecurrenceRule", {
    extend: "Ext.data.Model",
    fields: [ {
        name: "isSet",
        type: "boolean",
        defaultValue: !1
    }, {
        name: "endBy",
        type: "object",
        defaultValue: {
            date: "",
            type: "ByRecurrenceNever"
        }
    }, {
        name: "preciseBy",
        type: "object",
        defaultValue: {}
    }, {
        name: "frequency",
        type: "String",
        defaultValue: "Daily"
    } ],
    statics: {
        DEFAULTS: {
            endBy: {
                date: "",
                type: "ByRecurrenceNever"
            },
            preciseBy: {
                byDay: [],
                byInterval: 1,
                byMonth: [],
                byMonthDay: [],
                byPosition: []
            },
            isSet: !1,
            frequency: "Daily"
        },
        WORKDAYS: [ 1, 2, 3, 4, 5 ],
        PHRASE: {
            position: [ k_tr("1st", "calendar", {
                k_comment: ""
            }), k_tr("2nd", "calendar", {
                k_comment: ""
            }), k_tr("3rd", "calendar", {
                k_comment: ""
            }), k_tr("4th", "calendar", {
                k_comment: ""
            }), k_tr("last", "calendar", {
                k_comment: ""
            }) ],
            or: k_tr("or", "calendar", {
                k_comment: ""
            }),
            and: k_tr("and", "calendar", {
                k_comment: ""
            }),
            on: k_tr("on", "calendar", {
                k_comment: ""
            }),
            "in": k_tr("in", "calendar", {
                k_comment: ""
            }),
            weekdays: k_tr("on weekdays", "calendar", {
                k_comment: ""
            }),
            until: k_tr("until", "calendar", {
                k_comment: ""
            }),
            incompatible: k_tr("Incompatible repeat rule", "calendar", {
                k_comment: ""
            })
        }
    },
    isCompatible: !0,
    constructor: function(e) {
        Ext.applyIf(e || {}, this.self.DEFAULTS);
        this.callParent(arguments);
        this._checkCompatibility();
    },
    _checkCompatibility: function() {
        var e, t = this.get("preciseBy"), i = !1, s = this.isSet() ? this.get("frequency") : "None";
        if (t && t.byDay) {
            i = this.isOnWorkdays();
        }
        switch (s) {
          case "None":
            break;

          case "Daily":
            if (t.byMonthDay.length || t.byMonth.length || t.byPosition.length || 1 !== t.byInterval || 0 !== t.byDay.length && !i) {
                this.isCompatible = !1;
            }
            break;

          case "Weekly":
            if (t.byMonthDay.length || t.byMonth.length || t.byPosition.length) {
                this.isCompatible = !1;
            }
            break;

          case "Monthly":
            e = t.byPosition[0];
            if (!(1 === t.byMonthDay.length && "-1" === t.byMonthDay.toString() && 0 === t.byDay.length && 0 === t.byMonth.length && 0 === t.byPosition.length || (1 === t.byMonthDay.length || 0 === t.byMonthDay.length) && 0 === t.byDay.length && 0 === t.byMonth.length && 0 === t.byPosition.length || 1 === t.byDay.length && 0 === t.byMonthDay.length && 0 === t.byMonth.length && 1 === t.byPosition.length && (e >= 1 && 4 >= e || -1 === e) || 7 === t.byDay.length && 0 === t.byMonthDay.length && 0 === t.byMonth.length && 1 === t.byPosition.length || 5 === t.byDay.length && i && 0 === t.byMonthDay.length && 0 === t.byMonth.length && 1 === t.byPosition.length)) {
                this.isCompatible = !1;
            }
            break;

          case "Yearly":
            if (t.byDay.length || t.byPosition.length || 1 !== t.byInterval || t.byMonth.length) {
                this.isCompatible = !1;
            }
            break;

          default:
            this.isCompatible = !1;
        }
    },
    _localizeRecurrencyUnit: function(e, t) {
        switch (e) {
          case "Daily":
            return k_tr("[day|days]", "calendar", {
                k_pluralityBy: t,
                k_comment: ""
            });

          case "Weekly":
            return k_tr("[week|weeks]", "calendar", {
                k_pluralityBy: t,
                k_comment: ""
            });

          case "Monthly":
            return k_tr("[month|months]", "calendar", {
                k_pluralityBy: t,
                k_comment: ""
            });

          case "Yearly":
            return k_tr("[year|years]", "calendar", {
                k_pluralityBy: t,
                k_comment: ""
            });
        }
    },
    _concatNames: function(e, t, i, s, n) {
        var o, r, a, l, d = [];
        n = n || ", ";
        for (o = 0, r = e.length; r > o; o++) {
            if (-1 === e[o]) {
                l = t.length - 1;
            } else {
                l = s ? e[o] - 1 : e[o];
            }
            if (t && !t[l]) {
                continue;
            }
            d.push(t ? t[l] : l);
        }
        if (r >= 2 && i) {
            a = d[r - 2] + " " + i + " " + d[r - 1];
            d.splice(-2, 2, a);
        }
        return d.join(n);
    },
    _toDateObject: function(e) {
        if (e instanceof Date) {
            return e;
        } else {
            return Ext.Date.format(Ext.Date.parseDate(e, "iso"), "date");
        }
    },
    humanize: function(e, t, i) {
        i = i || Ext.Date.patterns.date;
        if (!this.isSet()) {
            return null;
        }
        var s, n, o, r, a = this.get("preciseBy"), l = this.get("frequency"), d = this.isOnWorkdays(), c = "Daily" === l, h = "Yearly" === l, u = "Monthly" === l, f = Ext.Date.dayNames, m = Ext.Date.monthNames, p = [], g = !1;
        if (e && 1 === a.byInterval && (!d || !c)) {
            p.push(l);
        }
        if (a.byInterval > 1 || !this.isCompatible || c) {
            n = k_tr("[every|every]", "calendar", {
                k_pluralityBy: a.byInterval,
                k_comment: ""
            }) + (a.byInterval > 1 ? " " + a.byInterval : "");
            if (c) {
                if (d) {
                    p.push(n + " " + k_tr("[weekday|weekdays]", "calendar", {
                        k_pluralityBy: a.byInterval,
                        k_comment: ""
                    }));
                } else {
                    if (a.byInterval > 1) {
                        p.push(n + " " + this._localizeRecurrencyUnit(l, a.byInterval));
                    }
                }
            } else {
                if (!e || a.byInterval > 1) {
                    p.push(n + " " + this._localizeRecurrencyUnit(l, a.byInterval));
                }
            }
        }
        if (a.byDay.length > 0 && !c) {
            r = a.byPosition.length > 0 ? " " + this._concatNames(a.byPosition, this.self.PHRASE.position, this.self.PHRASE.or, !0) : "";
            if (d) {
                o = 0 === a.byPosition.length ? this.self.PHRASE.weekdays : this.self.PHRASE.on + r + " " + k_tr("[weekday|weekdays]", "calendar", {
                    k_pluralityBy: 1,
                    k_comment: ""
                });
            } else {
                if (a.byDay.length < 7) {
                    o = this.self.PHRASE.on + r + " " + this._concatNames(a.byDay, f, h || u ? this.self.PHRASE.or : this.self.PHRASE.and);
                } else {
                    if (7 === a.byDay.length) {
                        if ("" === r) {
                            o = k_tr("[every|every]", "calendar", {
                                k_pluralityBy: 1,
                                k_comment: ""
                            }) + " " + this._localizeRecurrencyUnit("Daily", 1);
                        } else {
                            o = this.self.PHRASE.on + r + " " + k_tr("[day|days]", "calendar", {
                                k_pluralityBy: 1,
                                k_comment: ""
                            });
                        }
                    } else {
                        g = !0;
                    }
                }
            }
            p.push(o);
        }
        if (a.byMonth.length > 0) {
            p.push(this.self.PHRASE["in"] + " " + this._concatNames(a.byMonth, m, h ? this.self.PHRASE.or : this.self.PHRASE.and, !0));
        }
        if (!t && this.get("endBy") && "ByRecurrenceDate" === this.get("endBy").type) {
            s = this._toDateObject(this.get("endBy").date);
            p.push(this.self.PHRASE.until + " " + Ext.Date.format(s, i));
        }
        if (g) {
            return this.self.PHRASE.incompatible;
        } else {
            return p.join(" ");
        }
    },
    reset: function() {
        this.set("preciseBy", this.self.DEFAULTS.preciseBy);
        this.set("endBy", this.self.DEFAULTS.endBy);
        this.set("isSet", this.self.DEFAULTS.isSet);
        this.set("frequency", this.self.DEFAULTS.frequency);
    },
    isChanged: function() {
        return this.dirty;
    },
    isSet: function() {
        return this.data.isSet;
    },
    isOnWorkdays: function() {
        if (this.isSet() && this.get("preciseBy") && this.get("preciseBy").byDay) {
            return this._isEqualArray(this.get("preciseBy").byDay, this.self.WORKDAYS);
        }
        return !1;
    },
    update: function(e) {
        this.set({
            frequency: e.frequency,
            preciseBy: e.preciseBy,
            endBy: e.endBy,
            isSet: e.isSet
        });
    },
    normalize: function() {
        if (!this.get("endBy")) {
            this.set("endBy", this.self.DEFAULTS.endBy);
        } else {
            this.set("endBy", Ext.applyIf(this.get("endBy", this.self.DEFAULTS.endBy)));
        }
        if (!this.get("preciseBy")) {
            this.set("preciseBy", this.self.DEFAULTS.preciseBy);
        } else {
            this.set("preciseBy", Ext.applyIf(this.get("preciseBy"), this.self.DEFAULTS.preciseBy));
        }
    },
    equals: function(e, t) {
        var i, s, n, o, r = this.self.DEFAULTS.preciseBy, a = {}, l = {};
        if (!e) {
            return !1;
        }
        if (!this.isSet() && !e.isSet() || !this.isCompatible && !e.isCompatible) {
            return !0;
        }
        if (this.isSet() !== e.isSet() || this.get("frequency") !== e.get("frequency")) {
            return !1;
        }
        n = this.get("endBy");
        o = e.get("endBy");
        if (n.type !== o.type) {
            return !1;
        }
        i = void 0 !== n.date && "" !== n.date ? this._toDateObject(n.date) : "";
        s = void 0 !== o.date && "" !== o.date ? this._toDateObject(o.date) : "";
        if (i.valueOf() !== s.valueOf()) {
            if (!t || Ext.Date.clearTime(i, !0).valueOf() !== Ext.Date.clearTime(s, !0).valueOf()) {
                return !1;
            }
        }
        Ext.apply(a, this.get("preciseBy"), r);
        Ext.apply(l, e.get("preciseBy"), r);
        if (a.byInterval !== l.byInterval) {
            return !1;
        }
        return this._isEqualArray(a.byDay, l.byDay) && this._isEqualArray(a.byMonth, l.byMonth) && this._isEqualArray(a.byPosition, l.byPosition);
    },
    _isEqualArray: function(e, t) {
        var i, s;
        if (!e || !t || e.length !== t.length) {
            return !1;
        }
        e.sort();
        t.sort();
        for (i = 0, s = e.length; s > i; i++) {
            if (e[i] !== t[i]) {
                return !1;
            }
        }
        return !0;
    },
    asJson: function() {
        var e, t = Ext.clone(this.data);
        if (!1 === t.isSet) {
            delete t.frequency;
            delete t.endBy;
            delete t.preciseBy;
        } else {
            if (!t.frequency) {
                delete t.frequency;
            } else {
                e = t.endBy ? t.endBy.date : void 0;
                if (void 0 !== e && "" !== e) {
                    t.endBy.date = Ext.Date.add(Ext.Date.add(Ext.Date.clearTime(this._toDateObject(e)), Ext.Date.MINUTE, -1), Ext.Date.DAY, 1);
                }
            }
        }
        return t;
    }
});

Ext.define("kerio.wm.view.calendar.viewPanel.ReminderFormatter", {
    DURATION_MINUTE: 60,
    DURATION_MINUTE_MS: 6e4,
    DURATION_DAY: 1440,
    DURATION_WEEK: 10080,
    STORE_REMINDERS: void 0,
    singleton: !0,
    _extraOption: void 0,
    getStoreReminders: function(e) {
        var t, i, s, n;
        if (!this.STORE_REMINDERS) {
            i = Ext.Date.format(Ext.Date.add(Ext.Date.clearTime(kerio.wm.getCurrentDate()), Ext.Date.HOUR, 9), "time");
            this.STORE_REMINDERS = [ [ -1, k_tr("None", "calendar") ], [ -2, k_tr("When I need to leave", "calendar") ], [ 0, k_tr("On event start", "calendar") ], [ 5, k_tr("5 minutes", "calendar") ], [ 15, k_tr("15 minutes", "calendar") ], [ 30, k_tr("30 minutes", "calendar") ], [ 60, k_tr("1 hour", "calendar") ], [ 120, k_tr("2 hours", "calendar") ], [ 240, k_tr("4 hours", "calendar") ], [ -9, k_tr("on the same day at %1", "calendar", {
                k_args: [ i ]
            }) ], [ -10, k_tr("a day before at %1", "calendar", {
                k_args: [ i ]
            }) ], [ -11, k_tr("two days before at %1", "calendar", {
                k_args: [ i ]
            }) ], [ -12, k_tr("a week before at %1", "calendar", {
                k_args: [ i ]
            }) ] ];
        }
        t = Ext.clone(this.STORE_REMINDERS);
        for (s = 0, n = this.STORE_REMINDERS.length; n > s; s++) {
            if (this.STORE_REMINDERS[s][0] > 0) {
                t[s][1] = e ? k_tr("%1 before leaving", "calendar", {
                    k_comment: "",
                    k_args: [ this.STORE_REMINDERS[s][1] ]
                }) : k_tr("%1 before event start", "calendar", {
                    k_comment: "",
                    k_args: [ this.STORE_REMINDERS[s][1] ]
                });
            }
        }
        if (this._extraOption) {
            t.push([ this._extraOption[0], e ? k_tr("%1 before leaving", "calendar", {
                k_comment: "",
                k_args: [ this._extraOption[1] ]
            }) : k_tr("%1 before event start", "calendar", {
                k_comment: "",
                k_args: [ this._extraOption[1] ]
            }) ]);
        }
        return t;
    },
    setExtraOption: function(e) {
        if (!e) {
            this._extraOption = void 0;
        } else {
            this._extraOption = [ e.reminder.minutesBeforeStart, this.getHumanString(e, !0) ];
        }
    },
    getStoreReminderFor: function(e) {
        var t, i = this.getStoreReminders(), s = i.length;
        for (t = 0; s > t; t++) {
            if (i[t][0] === e) {
                return i[t][1];
            }
        }
        return null;
    },
    getHumanString: function(e, t, i) {
        var s, n;
        if (e.reminder.date && "ReminderAbsolute" === e.reminder.type) {
            n = (e.start - e.reminder.date) / this.DURATION_MINUTE_MS;
        } else {
            n = e.reminder.minutesBeforeStart || 0;
        }
        s = this._fitToOneOfAbsolute(n, e);
        if (0 > s) {
            if (t) {
                s = this.getStoreReminderFor(s);
            }
            return s;
        }
        if (0 === n) {
            s = k_tr("On event start", "calendar");
            i = !1;
        } else {
            if (n < this.DURATION_MINUTE || n % this.DURATION_MINUTE !== 0) {
                s = n;
                s = k_tr("%1 [minute|minutes]", "calendar", {
                    k_args: [ s ],
                    k_pluralityBy: s
                });
            } else {
                if (n >= this.DURATION_WEEK && n % this.DURATION_WEEK === 0) {
                    s = Math.round(n / this.DURATION_WEEK);
                    s = k_tr("%1 [week|weeks]", "calendar", {
                        k_args: [ s ],
                        k_pluralityBy: s
                    });
                } else {
                    if (n >= this.DURATION_DAY && n % this.DURATION_DAY === 0) {
                        s = Math.round(n / this.DURATION_DAY);
                        s = k_tr("%1 [day|days]", "calendar", {
                            k_args: [ s ],
                            k_pluralityBy: s
                        });
                    } else {
                        s = Math.round(n / 60);
                        s = k_tr("%1 [hour|hours]", "calendar", {
                            k_args: [ s ],
                            k_pluralityBy: s
                        });
                    }
                }
            }
        }
        if (t && i) {
            s = k_tr("%1 before", "calendar", {
                k_args: [ s ],
                k_comment: ""
            });
        }
        return s;
    },
    _fitToOneOfAbsolute: function(e, t) {
        var i = 0, s = t.start, n = Ext.Date.add(Ext.Date.clearTime(s, !0), Ext.Date.HOUR, 9), o = (s - n) / this.DURATION_MINUTE_MS, r = (s - Ext.Date.add(n, Ext.Date.DAY, -1)) / this.DURATION_MINUTE_MS, a = (s - Ext.Date.add(n, Ext.Date.DAY, -2)) / this.DURATION_MINUTE_MS, l = (s - Ext.Date.add(n, Ext.Date.DAY, -7)) / this.DURATION_MINUTE_MS;
        if (e === o) {
            i = -9;
        }
        if (e === r) {
            i = -10;
        }
        if (e === a) {
            i = -11;
        }
        if (e === l) {
            i = -12;
        }
        return i;
    }
});

Ext.define("kerio.wm.model.calendar.editPanel.Attendee", {
    extend: "Ext.data.Model",
    idProperty: "emailAddress",
    fields: [ {
        name: "displayName",
        type: "string"
    }, {
        name: "emailAddress",
        type: "string"
    }, {
        name: "role",
        type: "string"
    }, {
        name: "creator",
        type: "boolean"
    }, {
        name: "location",
        type: "boolean",
        defaultValue: !1
    }, {
        name: "partStatus",
        type: "string"
    }, {
        name: "freeBusy",
        type: "object"
    }, {
        name: "isNotified",
        type: "boolean"
    } ]
});

Ext.define("kerio.wm.view.calendar.editPanel.IconCombo", {
    extend: "Ext.form.field.ComboBox",
    alias: "widget.k_iconcombo",
    iconWidth: 20,
    isIconVisible: !0,
    styles: !0,
    iconWrapCls: "x-form-text iconWrap",
    iconCls: "icon",
    getSubTplMarkup: function() {
        var e = this, t = Ext.form.field.Text.prototype.getSubTplMarkup.apply(this, arguments);
        t = t.replace("x-form-field", "x-form-field iconInput");
        return '<table id="' + e.id + '-triggerWrap" class="' + Ext.baseCSSPrefix + 'form-trigger-wrap" cellpadding="0" cellspacing="0"><tbody><tr><td class="iconCell"><div class="' + (this.iconWrapCls || "") + '"><div class="' + (this.iconCls || "") + '"></div></div></td><td id="' + e.id + '-inputCell" class="' + Ext.baseCSSPrefix + 'form-trigger-input-cell">' + t + "</td>" + e.getTriggerMarkup() + "</tr></tbody></table>";
    },
    initComponent: function() {
        this.pickerOffset = [ -this.iconWidth, 0 ];
        this.listConfig = Ext.apply(this.listConfig || {}, {
            tpl: '<tpl for="."><div class="x-boundlist-item ' + (this.listItemCls || "") + '"><div style="' + this.listItemStyle + '" class="icon ' + this.listClass + " {" + this.iconClsField + '}"' + (this.iconTooltipField ? " {[kerio.lib.k_buildTooltip(values." + this.iconTooltipField + ")]}" : "") + "></div>" + (this.initialConfig.k_isSecure ? "{" + this.displayField + "}" : "{[fm.htmlEncode(values." + this.displayField + ")]}") + "</div></tpl>"
        });
        this.callParent(arguments);
        this.addCls("iconCombo");
        Ext.applyIf(this.renderSelectors, {
            icon: "." + this.iconCls.split(" ").join("."),
            iconWrap: "." + this.iconWrapCls.split(" ").join(".")
        });
        this.on("focus", function() {
            this.icon.addCls("x-form-focus");
        });
        this.on("blur", function() {
            this.icon.removeCls("x-form-focus");
        });
    },
    onRender: function(e, t) {
        this.callParent(arguments);
        this.iconWrap.on("mousedown", this.k_switchExpand, this);
        this.setIconCls();
        this._setIconStyle();
    },
    createPicker: function() {
        var e;
        this.callParent(arguments);
        e = this.picker;
        this.mon(e.getSelectionModel(), {
            beforeselect: this.onBeforeSelect,
            scope: this
        });
        return e;
    },
    onBeforeSelect: function(e, t) {
        return this.fireEvent("beforeselect", this, t, t.index);
    },
    setIconCls: function() {
        var e = this.k_getIndexByDataValue(this.valueField, this.getValue()), t = null, i = "icon " + this.listClass + " ";
        if (-1 !== e) {
            t = this.store.getAt(e);
        }
        if (this.icon) {
            i += t ? t.get(this.iconClsField) : "empty";
            this.icon.dom.className = i;
        }
    },
    _setIconStyle: function() {
        if (!Ext.isFunction(this.getIconStyle) || !this.icon) {
            return;
        }
        var e = this.k_getIndexByDataValue(this.valueField, this.getValue()), t = null, i = null;
        if (-1 !== e) {
            t = this.store.getAt(e);
        }
        i = this.getIconStyle(this, t || null);
        if (i) {
            this.icon.setStyle(i);
        }
    },
    showIcon: function(e) {
        this.isIconVisible = e !== !1;
        if (this.isIconVisible) {
            this.pickerOffset[0] = -this.iconWidth;
            this.getEl().removeCls("hiddenIcon");
        } else {
            this.pickerOffset[0] = 0;
            this.getEl().addCls("hiddenIcon");
        }
    },
    setValue: function(e) {
        this.callParent([ e ]);
        this.setIconCls();
        this._setIconStyle();
    },
    k_switchExpand: function() {
        var e = Ext.isIE ? 10 : 0;
        this.focus();
        if (this.isExpanded) {
            Ext.Function.defer(this.collapse, e, this);
        } else {
            if (!this.readOnly && !this.isDisabled()) {
                Ext.Function.defer(this.expand, e, this);
            }
        }
    },
    k_getIndexByDataValue: function(e, t) {
        var i, s = this.store.data.items, n = s.length;
        if (n > 0) {
            for (i = 0; n > i; i++) {
                if (s[i].data[e] === t) {
                    return i;
                }
            }
        }
        return -1;
    },
    setReadOnly: function(e) {
        if (e) {
            this.addCls("x-form-readonly");
        } else {
            this.removeCls("x-form-readonly");
        }
        this.callParent(arguments);
    }
});

Ext.define("kerio.wm.view.calendar.editPanel.attachment.Drop", {
    singleton: !0,
    running: !1,
    registred: !1,
    listeners: {},
    init: function() {
        if (!this.registred) {
            this._register();
            this.registred = !0;
        }
    },
    subscribe: function(e, t) {
        this.listeners[e] = t;
        this.init();
        this.running = !0;
    },
    unsubscribe: function(e) {
        delete this.listeners[e];
        this.running = !1;
    },
    registerIframeBody: function(e) {
        this._register(e);
    },
    _findListener: function(e) {
        var t;
        while (e) {
            for (t in this.listeners) {
                if (this.listeners.hasOwnProperty(t) && e === this.listeners[t].dom) {
                    return this.listeners[t];
                }
            }
            e = e.parentNode;
        }
        return;
    },
    _register: function(e) {
        e = e || Ext.getBody().dom;
        if (Ext.isIE7 || Ext.isIE8 || Ext.isIE9) {
            var t = function(e) {
                e = e || window.event;
                if (e) {
                    if (e.preventDefault) {
                        e.preventDefault();
                    }
                    if (e.stopEvent) {
                        e.stopEvent();
                    }
                    if (e.stopPropagation) {
                        e.stopPropagation();
                    }
                    e.returnValue = !1;
                }
                return !1;
            };
            e.ondrop = t;
            e.ondragenter = t;
            e.ondragover = t;
        } else {
            e.ondrop = Ext.bind(this._onDrop, this);
            e.ondragenter = Ext.bind(this._onDragOver, this);
            e.ondragover = Ext.bind(this._onDragOver, this);
            e.ondragleave = Ext.bind(this._onDragLeave, this);
        }
    },
    _onDrop: function(e) {
        if (Ext.isIE) {
            this._nativeStopEvent(e);
        } else {
            this._stopEvent(e);
        }
        e = e && (e.browserEvent || e);
        var t, i = e.dataTransfer;
        if (i && i.files && i.files.length > 0 && void 0 !== (t = this._findListener(e.target))) {
            if (!t.checkFiles || t.checkFiles.apply(t.scope || window, [ i.files ])) {
                t.drop.call(t.scope, e);
            }
        }
    },
    _onDragLeave: function(e) {
        e = e && e.browserEvent ? e.browserEvent : e;
        if (e) {
            var t = this._findListener(e.target);
            if (void 0 !== t) {
                t.dragLeave.call(t.scope, e);
            }
        }
        this._stopEvent(e);
        return !0;
    },
    _onDragOver: function(e) {
        e = e && e.browserEvent ? e.browserEvent : e;
        if (e) {
            var t = this._findListener(e.target);
            if (void 0 !== t) {
                t.dragOver.call(t.scope, e);
            }
        }
        this._stopEvent(e);
        return !0;
    },
    _isValidDropTarget: function(e) {
        return void 0 !== this._findListener(e.target);
    },
    _stopEvent: function(e) {
        if (e.stopEvent) {
            e.stopEvent();
        } else {
            this._nativeStopEvent(e);
        }
    },
    _nativeStopEvent: function(e) {
        if (e.stopPropagation) {
            e.stopPropagation();
        } else {
            e.cancelBubble = !0;
        }
        if (e.preventDefault) {
            e.preventDefault();
        } else {
            e.returnValue = !1;
        }
    }
});

Ext.define("kerio.wm.view.calendar.editPanel.Confirm", {
    extend: "Ext.util.Observable",
    alias: "widget.k_confirm",
    constructor: function(e) {
        this._k_editPanel = e.k_editPanel;
    },
    k_invalidDate: function(e) {
        switch (e) {
          case "start":
            kerio.wm.view.Msg.alert(k_tr("Wrong Date", "calendar"), k_tr("The start date is incorrect", "calendar"), function(e, t, i) {
                this._k_editPanel._k_startField.focus();
            }, this);
            break;

          case "end":
            kerio.wm.view.Msg.alert(k_tr("Wrong Date", "calendar"), k_tr("The end date is incorrect", "calendar"), function(e, t, i) {
                this._k_editPanel._k_endField.focus();
            }, this);
            break;

          default:
            kerio.wm.view.Msg.alert(k_tr("Wrong value", "calendar"), "");
        }
    }
});

Ext.define("kerio.wm.view.RadioButton", {
    extend: "Ext.form.field.Radio",
    styles: !0,
    alias: "widget.radiobutton",
    baseCls: "radiobutton",
    constructor: function() {
        this.renderTpl = [ '<div id="{id}-bodyEl" role="presentation" class="{baseBodyCls} {fieldBodyCls}">', '<input id="{inputId}" name="{name}" type="radio" class="{baseCls}-radio">', '<label class="{baseCls}-label" for="{inputId}">', '<span class="{baseCls}-label-text">{boxLabel}</span>', "</label>", '<div id="{id}-errorEl" class="{errorMsgCls}" style="display:none"></div>', '<div class="{clearCls}" role="presentation"><!-- --></div>', "</div>" ];
        this.callParent(arguments);
    },
    initRenderData: function() {
        return Ext.applyIf(this.callParent(), Ext.apply(this.getLabelableRenderData(), this.subTplData));
    }
});

Ext.ns("kerio.wm.calendar");

Ext.define("kerio.wm.view.calendar.FreeBusyPanelToolTip", {
    extend: "Ext.tip.ToolTip",
    constructor: function(e) {
        Ext.apply(e, {
            trackMouse: !0
        });
        this.callParent(arguments);
    },
    initComponent: function() {
        this.on({
            move: this._k_updateText
        });
        this.callParent();
    },
    _k_updateText: function() {
        var e = Ext.EventObject.getTarget(null, 5, !0), t = "", i = "Free";
        if (e.hasCls("calTooltipElement")) {
            i = e.dom.getAttribute("kerio:fbstatus") || "";
            i = i.trim();
        }
        switch (i) {
          case "Busy":
            t = k_tr("Busy", "freeBusyPanel");
            break;

          case "Tentative":
            t = k_tr("Tentative", "freeBusyPanel");
            break;

          case "OutOfOffice":
            t = k_tr("Out of office", "freeBusyPanel");
            break;

          case "NotAvailable":
            t = k_tr("Availability unknown", "freeBusyPanel");
            break;

          default:
            t = k_tr("Free", "freeBusyPanel");
        }
        this.update(t);
    }
});

Ext.define("kerio.wm.store.calendar.editPanel.Attendees", {
    extend: "Ext.data.Store",
    model: "kerio.wm.model.calendar.editPanel.Attendee",
    requires: [ "kerio.wm.model.calendar.editPanel.Attendee" ],
    loadRecords: function(e) {
        this._updateLocationPropValue(e);
        return this.callParent(arguments);
    },
    insert: function(e, t) {
        this._updateLocationPropValue(t);
        return this.callParent(arguments);
    },
    _updateLocationPropValue: function(e) {
        var t;
        for (t = 0; t < e.length; t++) {
            if (this._isAttendeeALocation(e[t].data)) {
                e[t].data.location = !0;
            }
        }
    },
    k_getValue: function() {
        var e, t = this.data.items, i = t.length, s = new Array(i);
        for (e = 0; i > e; e++) {
            s[e] = t[e].data;
        }
        return s;
    },
    k_getAttendeeCountWithoutCreator: function() {
        var e, t = this.data.items, i = t.length, s = 0;
        for (e = 0; i > e; e++) {
            if ("RoleOrganizer" !== t[e].get("role")) {
                s++;
            }
        }
        return s;
    },
    k_setLocation: function(e) {
        this.location = e.toLowerCase();
    },
    _isAttendeeALocation: function(e) {
        var t, i, s = e.role;
        if ("RoleRoom" === s) {
            t = e.displayName.toLowerCase();
            i = e.emailAddress.toLowerCase();
            return this.location === t || this.location === i;
        }
        return !1;
    }
});

Ext.define("kerio.wm.view.calendar.editPanel.RecurrenceDetailPanel", {
    extend: "kerio.wm.view.FloatingPanel",
    alias: "widget.recurrenceDetailPanel",
    autoScroll: !1,
    closeAction: "hide",
    cls: "recurrenceDetailPanel",
    styles: !0,
    autoHide: !0,
    alignOrder: [ "right" ],
    preventHeader: !0,
    maxWidth: 300,
    autoHideExceptionSelector: [ ".not-close-panel", ".x-message-box", ".x-boundlist" ],
    layout: "auto",
    constructor: function() {
        this.width = this.maxWidth;
        this._initBodyItems();
        this.callParent(arguments);
        this._initItems(this.items);
    },
    _items: {},
    _initialRule: null,
    _componentVisibilityConfig: {
        Daily: {
            weekdaysComposite: !0,
            intervalComposite: !1,
            weeklyByWeekDay: !1,
            monthlyByType: !1,
            endByDateComposite: !0
        },
        Weekly: {
            weekdaysComposite: !1,
            intervalComposite: !0,
            weeklyByWeekDay: !0,
            monthlyByType: !1,
            endByDateComposite: !0
        },
        Monthly: {
            weekdaysComposite: !1,
            intervalComposite: !0,
            weeklyByWeekDay: !1,
            monthlyByType: !0,
            endByDateComposite: !0
        },
        Yearly: {
            weekdaysComposite: !1,
            intervalComposite: !1,
            weeklyByWeekDay: !1,
            monthlyByType: !1,
            endByDateComposite: !0
        }
    },
    _unitsConfig: {
        Weekly: k_tr("week(s)", "calendar"),
        Monthly: k_tr("month(s)", "calendar")
    },
    _initBodyItems: function() {
        var e, t, i = Ext.id();
        e = [ {
            xtype: "checkboxgroup",
            columns: 1,
            listeners: {
                change: this._propagateChange,
                scope: this
            },
            defaults: {
                xtype: "checkbox",
                name: "day"
            },
            items: [ {
                itemId: "day1",
                boxLabel: k_tr("Monday", "calendar"),
                inputValue: 1
            }, {
                itemId: "day2",
                boxLabel: k_tr("Tuesday", "calendar"),
                inputValue: 2
            }, {
                itemId: "day3",
                boxLabel: k_tr("Wednesday", "calendar"),
                inputValue: 3
            }, {
                itemId: "day4",
                boxLabel: k_tr("Thursday", "calendar"),
                inputValue: 4
            }, {
                itemId: "day5",
                boxLabel: k_tr("Friday", "calendar"),
                inputValue: 5
            } ]
        }, {
            xtype: "checkboxgroup",
            columns: 1,
            defaults: {
                xtype: "checkbox",
                name: "day"
            },
            listeners: {
                change: this._propagateChange,
                scope: this
            },
            items: [ {
                itemId: "day6",
                boxLabel: k_tr("Saturday", "calendar"),
                inputValue: 6
            }, {
                itemId: "day0",
                boxLabel: k_tr("Sunday", "calendar"),
                inputValue: 0
            } ]
        } ];
        if (1 === kerio.wm.LocalesProvider.getFirstWeekDay()) {
            t = [ [ 1, k_tr("Monday", "calendar") ], [ 2, k_tr("Tuesday", "calendar") ], [ 3, k_tr("Wednesday", "calendar") ], [ 4, k_tr("Thursday", "calendar") ], [ 5, k_tr("Friday", "calendar") ], [ 6, k_tr("Saturday", "calendar") ], [ 0, k_tr("Sunday", "calendar") ], [ -98, k_tr("Day", "calendar") ], [ -99, k_tr("Weekday", "calendar", {
                k_comment: ""
            }) ] ];
        } else {
            t = [ [ 0, k_tr("Sunday", "calendar") ], [ 1, k_tr("Monday", "calendar") ], [ 2, k_tr("Tuesday", "calendar") ], [ 3, k_tr("Wednesday", "calendar") ], [ 4, k_tr("Thursday", "calendar") ], [ 5, k_tr("Friday", "calendar") ], [ 6, k_tr("Saturday", "calendar") ], [ -98, k_tr("Day", "calendar") ], [ -99, k_tr("Weekday", "calendar", {
                k_comment: ""
            }) ] ];
        }
        this.defaults = {
            labelAlign: "top"
        };
        this.items = [ {
            xtype: "fieldcontainer",
            layout: "column",
            itemId: "intervalComposite",
            hidden: !0,
            width: 260,
            items: [ {
                xtype: "label",
                cls: "x-form-item-label",
                itemId: "intervalLabel",
                text: k_tr("Every", "calendar", {
                    k_comment: ""
                }),
                forId: i
            }, {
                xtype: "numberfield",
                itemId: "interval",
                margin: "0 5",
                id: i,
                value: 1,
                width: 60,
                maxLength: 2,
                maxValue: 99,
                minValue: 1,
                listeners: {
                    change: this._propagateChange,
                    scope: this
                }
            }, {
                xtype: "displayfield",
                itemId: "unit",
                cls: "recurrencyUnit",
                value: k_tr("week(s)", "calendar")
            } ]
        }, {
            xtype: "radiogroup",
            layout: "auto",
            fieldLabel: k_tr("Repeat", "calendar", {
                k_comment: ""
            }),
            cls: "radioCheckboxGroup",
            itemId: "weekdaysComposite",
            items: [ {
                xtype: "radio",
                name: "everyRule",
                inputValue: 0,
                itemId: "dailyByWorkDay",
                boxLabel: k_tr("On weekdays only", "calendar", {
                    k_comment: ""
                })
            }, {
                xtype: "radio",
                name: "everyRule",
                inputValue: 1,
                itemId: "dailyByEvery",
                boxLabel: k_tr("Every day", "calendar", {
                    k_comment: ""
                })
            } ],
            listeners: {
                change: this._propagateChange,
                scope: this
            }
        }, {
            xtype: "checkboxgroup",
            itemId: "weeklyByWeekDay",
            fieldLabel: k_tr("On", "calendar", {
                k_comment: ""
            }),
            width: 260,
            defaults: {
                width: 130,
                cls: "radioCheckboxGroup"
            },
            hidden: !0,
            items: e
        }, {
            fieldLabel: k_tr("On", "calendar", {
                k_comment: ""
            }),
            xtype: "fieldcontainer",
            hidden: !0,
            itemId: "monthlyByType",
            cls: "radioCheckboxGroup",
            items: [ {
                xtype: "radio",
                name: "monthlyType",
                inputValue: "monthlyByMonthDay",
                cls: "calRuleMonthlyByMonthDay",
                boxLabel: " ",
                itemId: "monthlyTypeByMonthDay",
                checked: !0,
                width: 260,
                listeners: {
                    change: this._propagateChange,
                    scope: this
                }
            }, {
                xtype: "fieldcontainer",
                itemId: "monthlyTypeByPositionComposite",
                layout: "hbox",
                width: 260,
                items: [ {
                    xtype: "radio",
                    name: "monthlyType",
                    inputValue: "monthlyByPosition",
                    itemId: "monthlyTypeByPositionAndWeekDay",
                    listeners: {
                        change: function(e, t) {
                            this._propagateChange();
                            if (!this.readOnly) {
                                this._disableMonthlyFields(!t);
                            }
                        },
                        scope: this
                    }
                }, {
                    xtype: "combobox",
                    margin: "0 4",
                    itemId: "monthlyByPosition",
                    editable: !1,
                    width: 100,
                    value: 1,
                    store: [ [ 1, k_tr("1st", "calendar", {
                        k_comment: ""
                    }) ], [ 2, k_tr("2nd", "calendar", {
                        k_comment: ""
                    }) ], [ 3, k_tr("3rd", "calendar", {
                        k_comment: ""
                    }) ], [ 4, k_tr("4th", "calendar", {
                        k_comment: ""
                    }) ], [ -1, k_tr("Last", "calendar", {
                        k_comment: ""
                    }) ] ],
                    listeners: {
                        change: this._propagateChange,
                        scope: this
                    }
                }, {
                    xtype: "combobox",
                    itemId: "monthlyByWeekDay",
                    width: 120,
                    value: 0,
                    editable: !1,
                    store: t,
                    listeners: {
                        change: this._propagateChange,
                        scope: this
                    }
                } ]
            } ]
        }, {
            xtype: "fieldcontainer",
            fieldLabel: k_tr("Ends", "calendar", {
                k_comment: ""
            }),
            itemId: "endByDateComposite",
            cls: "radioCheckboxGroup",
            items: [ {
                xtype: "radio",
                name: "endBy",
                boxLabel: k_tr("Never", "calendar", {
                    k_comment: ""
                }),
                inputValue: "ByRecurrenceNever",
                itemId: "endByNever"
            }, {
                xtype: "fieldcontainer",
                itemId: "endBy",
                width: 260,
                layout: "column",
                items: [ {
                    xtype: "radio",
                    name: "endBy",
                    itemId: "endByDateRadio",
                    listeners: {
                        change: function(e, t) {
                            if (t) {
                                this._items.endByDate.expand();
                            }
                            this._items.endByDate.setDisabled(!t);
                            this._propagateChange();
                        },
                        scope: this
                    }
                }, {
                    xtype: "label",
                    cls: "x-form-cb-label endByLabel",
                    text: k_tr("On", "recurrenceRuleDatePrep", {
                        k_comment: ""
                    }),
                    listeners: {
                        afterrender: function(e) {
                            e.el.on("click", function() {
                                this._items.endByDateRadio.setValue(!0);
                            }, this);
                        },
                        scope: this
                    },
                    margin: "0 5"
                }, {
                    xtype: "datefield",
                    itemId: "endByDate",
                    cls: "endByDate",
                    disabled: !0,
                    width: 110,
                    format: Ext.Date.patterns.date,
                    emptyText: kerio.wm.LocalesProvider.getHumanReadablePattern(Ext.Date.patterns.date),
                    startDay: kerio.wm.LocalesProvider.getFirstWeekDay(),
                    validator: function(e) {
                        if (this.ownerCt.ownerCt.fireEvent("validateendbydate", "" === e ? e : Ext.Date.parseDate(e, this.format)) !== !1) {
                            return !0;
                        } else {
                            return k_tr("%1 is lower than start date or not a valid date - it must follow the pattern %2", "calendar", {
                                k_args: [ e, this.format ]
                            });
                        }
                    },
                    listeners: {
                        afterrender: function(e) {
                            e.getPicker().getEl().addCls("not-close-panel");
                            e.getEl().on("mousedown", function(e) {
                                if (this.readOnly && "" === this.getRawValue()) {
                                    e.stopEvent();
                                }
                            }, e);
                        },
                        select: function() {
                            this._items.endByDateRadio.setValue(!0);
                            this._propagateChange();
                        },
                        blur: this._propagateChange,
                        scope: this
                    }
                } ]
            } ]
        } ];
        this.listeners = {
            render: function() {
                this.body.on("keydown", this._handleKeyEvent, this);
            }
        };
    },
    _handleKeyEvent: function(e) {
        var t = e.getKey();
        if (e.altKey || e.ctrlKey) {
            return !1;
        }
        if (t === e.ESC) {
            this.close(!0);
            return !0;
        }
        if (t === e.ENTER) {
            this.close();
            return !1;
        }
    },
    _initItems: function(e) {
        var t, i, s, n = Ext.ComponentQuery.query("component", this);
        for (t = 0, i = n.length; i > t; t++) {
            s = n[t];
            if (s.itemId) {
                this._items[s.itemId] = s;
            }
        }
    },
    _propagateChange: function() {
        if (this._initialRule && this.isValid()) {
            this.fireEvent("rulechange", this.getValue());
        }
    },
    _updateFieldsVisibility: function() {
        var e, t = this._initialRule.get("frequency"), i = this._componentVisibilityConfig[t], s = this._unitsConfig[t];
        for (e in i) {
            if (!i.hasOwnProperty(e)) {
                continue;
            }
            this._items[e].setVisible(i[e]);
        }
        if (s) {
            this._items.unit.setValue(s);
        }
    },
    _updateMonthlyOptions: function(e) {
        var t, i, s, n = Ext.Date, o = this._initialRule.get("preciseBy");
        if (!e) {
            return;
        }
        t = n.format(e, "j");
        if (!(o.byDay.length > 0 && 0 === o.byMonthDay.length && 1 === o.byPosition.length)) {
            i = Math.ceil(t / 7);
            s = parseInt(n.format(e, "w"), 10);
            this._items.monthlyByPosition.setValue(4 >= i ? i : -1);
            this._items.monthlyByWeekDay.setValue(s);
        }
        this._items.monthlyTypeByMonthDay.boxLabelEl.update(k_tr("Day %1 of each month", "calendar", {
            k_args: [ t ]
        }));
    },
    _setMonthlyValues: function(e, t, i) {
        var s = this._items, n = void 0 === t;
        s.interval.setValue(e);
        s.monthlyTypeByMonthDay.setValue(n);
        s.monthlyTypeByPositionAndWeekDay.setValue(!n);
        if (!this.readOnly) {
            this._disableMonthlyFields(n);
        }
        if (!n) {
            s.monthlyByPosition.setValue(t);
            s.monthlyByWeekDay.setValue(i);
        }
    },
    _disableMonthlyFields: function(e) {
        this._items.monthlyByPosition.setDisabled(e);
        this._items.monthlyByWeekDay.setDisabled(e);
    },
    _applyChanges: function() {
        var e;
        if (this.isValid()) {
            e = this.getValue();
            if (!e.equals(this._initialRule, !0)) {
                this.fireEvent("rulechange", e);
            }
            return !0;
        }
        this.focus();
        this.isModal = !0;
        return !1;
    },
    close: function(e) {
        if (e || this._applyChanges()) {
            this.callParent();
            return !0;
        }
        this.focus();
        return !1;
    },
    isValid: function() {
        var e = this._items.endByDate, t = this._items.interval.isValid();
        if (this._items.endByNever.getValue() && t) {
            return !0;
        }
        return e.isValid() && t;
    },
    getValidationErrors: function() {
        var e = this._items.endByDate, t = this._items.interval, i = [];
        if (!t.isValid()) {
            i.push(k_tr("'%1' is not a valid value for the '%2' field. A number between 1 and 99 is expected.", "calendar", {
                k_args: [ t.getValue(), this._items.intervalLabel.text ],
                k_comment: ""
            }));
        }
        if (!e.isValid()) {
            i.push(k_tr("'%1' is not a valid recurrence end date. Please specify a date following the event start date in format '%2'.", "calendar", {
                k_args: [ e.getValue(), kerio.wm.LocalesProvider.getHumanReadablePattern(e.format) ],
                k_comment: ""
            }));
        }
        return i;
    },
    getValue: function() {
        var e, t, i, s, n = this._items, o = {}, r = this._initialRule.get("frequency"), a = Ext.create("kerio.wm.model.calendar.editPanel.RecurrenceRule", {
            frequency: r,
            isSet: !0
        });
        switch (r) {
          case "Daily":
            if (n.dailyByWorkDay.getValue()) {
                o.byDay = a.self.WORKDAYS;
            }
            break;

          case "Weekly":
            s = n.weeklyByWeekDay.getValue().day;
            if (void 0 !== s) {
                o.byDay = s.length ? s : [ s ];
            }
            o.byInterval = n.interval.getValue();
            break;

          case "Monthly":
            o.byInterval = n.interval.getValue();
            if (!n.monthlyTypeByMonthDay.getValue()) {
                e = n.monthlyByWeekDay.getValue();
                o.byPosition = [ n.monthlyByPosition.getValue() ];
                if (-98 === e) {
                    o.byDay = [ 0, 1, 2, 3, 4, 5, 6 ];
                } else {
                    if (-99 === e) {
                        o.byDay = a.self.WORKDAYS;
                    } else {
                        o.byDay = [ n.monthlyByWeekDay.getValue() ];
                    }
                }
            }
        }
        t = n.endByDate.getValue();
        if (n.endByDateRadio.getValue() && t && Ext.isDate(t)) {
            i = Ext.Date.add(Ext.Date.add(t, Ext.Date.MINUTE, -1), Ext.Date.DAY, 1);
            a.set("endBy", {
                type: "ByRecurrenceDate",
                date: i
            });
        }
        a.set("preciseBy", o);
        a.normalize();
        return a;
    },
    setValue: function(e) {
        var t, i, s, n = this._items, o = e.get("preciseBy"), r = e.isOnWorkdays(), a = e.isSet() ? e.get("frequency") : "None";
        this.suspendEvents();
        switch (a) {
          case "Daily":
            n.dailyByWorkDay.setValue(r);
            n.dailyByEvery.setValue(!r);
            break;

          case "Weekly":
            n.interval.setValue(o.byInterval);
            n.weeklyByWeekDay.setValue({
                day: o.byDay
            });
            break;

          case "Monthly":
            t = o.byPosition[0];
            if (1 === o.byMonthDay.length && "-1" === o.byMonthDay.toString() && 0 === o.byDay.length && 0 === o.byMonth.length && 0 === o.byPosition.length) {
                this._setMonthlyValues(o.byInterval, -1, -98);
            } else {
                if ((1 === o.byMonthDay.length || 0 === o.byMonthDay.length) && 0 === o.byDay.length && 0 === o.byMonth.length && 0 === o.byPosition.length) {
                    this._setMonthlyValues(o.byInterval);
                } else {
                    if (1 === o.byDay.length && 0 === o.byMonthDay.length && 0 === o.byMonth.length && 1 === o.byPosition.length && (t >= 1 && 4 >= t || -1 === t)) {
                        this._setMonthlyValues(o.byInterval, t, o.byDay[0]);
                    } else {
                        if (7 === o.byDay.length && 0 === o.byMonthDay.length && 0 === o.byMonth.length && 1 === o.byPosition.length) {
                            this._setMonthlyValues(o.byInterval, t, -98);
                        } else {
                            if (5 === o.byDay.length && r && 0 === o.byMonthDay.length && 0 === o.byMonth.length && 1 === o.byPosition.length) {
                                this._setMonthlyValues(o.byInterval, t, -99);
                            }
                        }
                    }
                }
            }
        }
        s = e.get("endBy") && "ByRecurrenceNever" === e.get("endBy").type;
        n.endByNever.setValue(s);
        n.endByDateRadio.setValue(!s);
        if (e.get("endBy") && e.get("endBy").date) {
            i = e.get("endBy").date;
            if (!(i instanceof Date)) {
                i = Ext.Date.parse(i, "iso");
            }
            n.endByDate.setValue(i);
        } else {
            n.endByDate.setValue(null);
        }
        this._initialRule = Ext.clone(e);
        this._updateFieldsVisibility();
        this.resumeEvents();
    },
    updateOptions: function(e, t) {
        var i = this._initialRule.get("frequency"), s = this._items.endByDate.getValue();
        if ("Monthly" === i) {
            this._updateMonthlyOptions(e);
        }
        this._items.endByDate.setMinValue(t);
        if (!s || t > s) {
            this._items.endByDate.setValue(t);
        }
    }
});

Ext.define("kerio.wm.view.ExpandDisplayField", {
    extend: "Ext.form.field.Display",
    styles: !0,
    alias: "widget.expanddisplayfield",
    cls: "expandDisplayField",
    maxLines: 3,
    linkLabel: k_tr("Read more", "expanddisplayfield", {
        k_comment: ""
    }),
    detectLinks: !1,
    _textMetrics: void 0,
    _maxHeight: 0,
    _linkEl: void 0,
    _isCollapsed: !1,
    _collapseAfterRender: !1,
    _paddings: void 0,
    _linkCreator: void 0,
    initComponent: function() {
        this.callParent(arguments);
        this._textMetrics = Ext.util.TextMetrics.create(this.getEl());
        this._maxHeight = this._textMetrics.getHeight("X") * this.maxLines;
        this._linkCreator = new kerio.LinkCreator();
    },
    afterComponentLayout: function() {
        if (!this._isCollapsed) {
            this._setCollapsed(!0);
        }
    },
    afterRender: function() {
        this.callParent(arguments);
        var e = window.getComputedStyle(this.inputEl.dom);
        this._paddings = parseInt(e.paddingTop, 10) + parseInt(e.paddingBottom, 10);
        this._linkEl = this.bodyEl.createChild({
            tag: "a",
            href: "#",
            html: this.linkLabel
        }).on("click", this.expand, this).setDisplayed(!1);
        this._setCollapsed(this._collapseAfterRender);
    },
    setValue: function(e) {
        if (this.detectLinks && e) {
            e = Ext.htmlEncode(e);
            e = this._linkCreator.replaceURLs(e);
            if (void 0 !== e.html) {
                e = e.html;
            }
        }
        return this.callParent([ e ]);
    },
    _isContentOverflowed: function() {
        var e = Ext.util.TextMetrics.measure(this.inputEl, this.getValue(), this.inputEl.getWidth()).height;
        return this._maxHeight < e;
    },
    expand: function() {
        return this._setCollapsed(!1);
    },
    collapse: function() {
        return this._setCollapsed(!0);
    },
    _setCollapsed: function(e) {
        if (!this.rendered) {
            this._collapseAfterRender = e;
            return this;
        }
        if (e && this._isContentOverflowed()) {
            this.inputEl.addCls("collapsed");
            this.inputEl.setHeight(this._maxHeight + this._paddings);
            this._linkEl.setDisplayed(!0);
            this._isCollapsed = !0;
        }
        if (e === !1 || !this._isContentOverflowed()) {
            this._linkEl.setDisplayed(!1);
            this.inputEl.setHeight("auto");
            this.inputEl.removeCls("collapsed");
            this.inputEl.setStyle("-webkit-line-clamp", "");
            this._isCollapsed = !1;
        }
        if (this._isCollapsed) {
            Ext.Function.defer(function() {
                this.inputEl.setStyle("-webkit-line-clamp", this.maxLines);
                this.hide();
                this.show();
            }, 100, this);
        }
        return this;
    }
});

Ext.define("kerio.wm.view.IconDisplayField", {
    extend: "Ext.form.field.Display",
    styles: !0,
    alias: "widget.icondisplayfield",
    cls: "iconDisplayField",
    iconHidden: !1,
    iconCls: "",
    _iconEl: void 0,
    initComponent: function() {
        this.callParent(arguments);
        this._iconEl = new Ext.Element(document.createElement("div"));
        this._iconEl.addCls("iconDisplayFieldIcon " + this.iconCls);
    },
    afterRender: function() {
        this.callParent(arguments);
        this._iconEl.insertBefore(this.bodyEl.child(".x-form-display-field"));
        if (this.iconHidden) {
            this._iconEl.hide();
        }
    },
    hideIcon: function() {
        this.setIconVisible(!1);
    },
    showIcon: function() {
        this.setIconVisible(!0);
    },
    setIconVisible: function(e) {
        this._iconEl.setDisplayed(e);
    },
    getIcon: function() {
        return this._iconEl;
    }
});

Ext.define("kerio.wm.controller.calendar.editPanel.Rights", {
    extend: "Ext.util.Observable",
    alias: "widget.k_rights",
    statics: {
        BLOCK_STATE: {
            editable: {
                summaryContainer: 2,
                generalInfoContainer: 2,
                personalizeContainer: 2,
                ruleContainer: 2,
                descriptionContainer: 2,
                responseContainer: 0
            },
            partial: {
                summaryContainer: 1,
                generalInfoContainer: 1,
                personalizeContainer: 2,
                ruleContainer: 0,
                descriptionContainer: 1,
                responseContainer: 2
            },
            readonly: {
                summaryContainer: 1,
                generalInfoContainer: 1,
                personalizeContainer: 1,
                ruleContainer: 0,
                descriptionContainer: 1,
                responseContainer: 0
            }
        }
    },
    _editorWindowController: null,
    constructor: function(e) {
        this._editorWindowController = Ext.ComponentQuery.query("calEditorWindow")[0].controller;
    },
    handleRights: function() {
        var e, t, i, s, n, o = this._editorWindowController, r = o.getSubcomponents(), a = !0, l = !1, d = !0, c = !1, h = !1, u = !d && l, f = o.getEditedRecord(), m = !f, p = !o.getRule().isCompatible;
        if (!m) {
            n = f.k_getFolderRecord();
            t = n.isPlaceMailbox();
            e = n.k_isPlaceResource();
            i = n.get("isDelegated");
            s = n.k_isPlacePublic();
            a = (t || i || s || e || 0 === f.k_getAttendeeCountWithoutCreator()) && f.k_isCreator();
            l = (t || i) && f.k_isInvitee();
            if (l) {
                d = f.k_isResponded();
                if (e) {
                    d = !0;
                    h = !0;
                }
                if (d && !f.k_isCancelled()) {
                    r.myResponse.setValue(f.getMyPartStatus(), !0, !0);
                    r.myResponse.setVisible(!0);
                    r.myResponse.addCls("myReponseSpacer");
                }
            }
            if (n.isPublished()) {
                h = !0;
                a = !1;
            }
            c = f.k_isCancelled();
        }
        u = !d && l;
        this._handleButtons(a, l, d, c, h, m);
        this._handleBlocks(a, l, d, c, h, m, !m && f.data.attendees.length > 1);
        if (a) {
            if (o._view.fireEvent("beforefoldercomboshow") !== !1) {
                r.folderId.setVisible(!1);
            } else {
                r.folderId.setVisible(!0);
            }
            n = r.folderId.getStore().findRecord("id", r.folderId.getValue(), 0, !1, !1, !0);
            if (o._isExceptionEdited) {
                r.isPrivate.disable();
                r.ruleFrequency.disable();
                r.folderId.disable();
            } else {
                r.isPrivate.setDisabled("FPlaceMailbox" !== n.get("placeType"));
                r.ruleFrequency.enable();
                r.folderId.enable();
            }
            o._isPlacePublic = "FPlacePublic" === n.get("placeType");
        }
        r.attendeesContainer.setVisible(r.attendees.hasAttendees() || a);
        r.btnRuleSetting.setDisabled(o._isExceptionEdited || m || !f.get("rule").isSet || p);
        r.attendees.setProperTemplate();
        r.replyComment.setVisible(u && !c);
        r.cancelled.setVisible(c);
        r.summary.setReadOnly(!a);
        r.attendees.setReadOnly(!a);
        r.folderId.setReadOnly(!a);
        r.isPrivate.setVisible(!h);
        r.isAllDay.setVisible(a && !h);
        r.roDescription.setVisible("" !== r.description.getValue() || a);
        r.myResponse.setVisible(d);
        if (!m) {
            r.roWhere.setVisible("" !== f.data.location);
            r.roLabel.setVisible("None" !== f.get("label") || a);
            r.roTravelTime.setVisible(f.get("travelMinutes") > 0 || a);
            r.roReminder.setVisible(f.get("reminder").isSet);
        }
    },
    _handleBlocks: function(e, t, i, s, n, o, r) {
        var a, l = this._editorWindowController.getSubcomponents(), d = e, c = t && !s && !n, h = this.self.BLOCK_STATE[d ? "editable" : c ? "partial" : "readonly"];
        for (a in h) {
            if (!h.hasOwnProperty(a)) {
                continue;
            }
            this._setBlockState(l[a], h[a]);
        }
    },
    _setBlockState: function(e, t) {
        var i = 2 === t ? 0 : 1;
        if (0 === t) {
            e.setVisible(!1);
            return;
        }
        e.setVisible(!0);
        if (e instanceof Ext.container.Container && e.getLayout() instanceof Ext.layout.container.Card) {
            if (e.rendered) {
                e.getLayout().setActiveItem(i);
            } else {
                e.activeItem = i;
            }
        }
    },
    _handleButtons: function(e, t, i, s, n, o) {
        var r, a, l, d = (e || t) && !n, c = !i && t, h = this._editorWindowController.getSubcomponents(), u = this._editorWindowController._view.query("webmailbutton[k_respondButton=true]"), f = h.btnSave, m = h.btnCancel, p = h.btnDelete, g = h.btnPrint;
        l = c && !s;
        for (r = 0, a = u.length; a > r; r++) {
            u[r].setVisible(l);
        }
        f.setVisible(!c && d && !s);
        if (d && !c) {
            m.setText(k_tr("Cancel", "common"));
        } else {
            m.setText(k_tr("Close", "common"));
        }
        m.setVisible(!0);
        p.setVisible(!o && d && (!t || t && s));
        g.setVisible(!o);
    }
});

Ext.define("kerio.wm.view.FolderContextMenu", {
    extend: "Ext.menu.Menu",
    alias: "widget.foldercontextmenu",
    defaults: {
        scope: this,
        width: 170
    },
    constructor: function(e) {
        this.callParent(arguments);
        this._k_menuItems = {
            SHARE: {
                text: k_tr("Sharing", "folders"),
                itemId: "btnShare"
            },
            RENAME: {
                text: k_tr("Rename", "folders"),
                itemId: "btnRename"
            },
            DELETE: {
                text: k_tr("Delete", "common"),
                itemId: "btnDelete"
            },
            HIDE: {
                text: k_tr("Hide", "folders"),
                itemId: "btnHide",
                listeners: {
                    click: function() {
                        this.parentMenu.fireEvent("unsubscribe", this.parentMenu.targetRecord.data, this.parentMenu._parentView);
                    }
                }
            },
            NEW_FOLDER: {
                text: k_tr("New Folder", "folders"),
                itemId: "btnNewFolder"
            }
        };
    },
    showAtModel: function(e, t, i) {
        this._parentView = i;
        this._fillContextMenu(t);
        return this._show(e);
    },
    _fillContextMenu: function(e) {
        this.targetRecord = e;
        var t = e.k_isSubtypeDefault(), i = e.k_isAccessAdmin(), s = e.k_isPlacePublic(), n = e.k_isPlacePeople(), o = e.isPlaceMailbox(), r = e.get("subType"), a = "FSubGalContacts" === r || "FSubGalResources" === r, l = !e.isLeaf() && i && s, d = e.get("isDelegated");
        this.removeAll();
        if (o && t) {
            this.add(this._k_menuItems.SHARE);
        } else {
            if (l) {
                this.add(this._k_menuItems.NEW_FOLDER);
                this.add(this._k_menuItems.SHARE);
            } else {
                if (!e.isFakeFolder()) {
                    if (e.k_isPlaceResource()) {
                        this.add(this._k_menuItems.HIDE);
                    } else {
                        if (i) {
                            if (n) {
                                this.add(this._getOwnerPeopleFolderItems());
                            } else {
                                if (!a) {
                                    this.add(this._k_menuItems.RENAME);
                                    this.add(this._k_menuItems.DELETE);
                                }
                                this.add(this._k_menuItems.SHARE);
                            }
                        } else {
                            if (n && !d) {
                                this.add(this._getSharedFolderMenuItems());
                            }
                        }
                    }
                } else {
                    if (i && o) {
                        this.add(this._k_menuItems.NEW_FOLDER);
                    }
                }
            }
        }
    },
    _getSharedFolderMenuItems: function() {
        return [ this._k_menuItems.HIDE ];
    },
    _getOwnerPeopleFolderItems: function() {
        return [ this._k_menuItems.SHARE, this._k_menuItems.HIDE ];
    },
    _show: function(e) {
        if (this.hasVisibleButton()) {
            this.showAt(e);
            return !0;
        }
        return !1;
    },
    hasVisibleButton: function() {
        var e, t = this.items.items;
        for (e = 0; e < t.length; e++) {
            if (t[e].hidden === !1) {
                return !0;
            }
        }
        return !1;
    }
});

Ext.define("kerio.wm.view.calendar.folderPanel.CalendarTreeColumn", {
    extend: "kerio.wm.view.FolderTreeColumn",
    alias: "widget.calendartreecolumn",
    initComponent: function() {
        var e = this.renderer || this.defaultRenderer, t = this.scope || window, i = this;
        this.renderer = function(s, n, o, r, a, l, d) {
            var c = [], h = Ext.String.format, u = '<input type="button" role="checkbox" class="{0}" {1} {2}/>', f = Ext.baseCSSPrefix + "tree-";
            if (o.get("checked")) {
                n.tdCls += " " + f + "checked";
            }
            if (null !== o.get("checked")) {
                c.unshift(h(u, f + "checkbox" + (o.get("checked") ? " " + f + "checkbox-checked" : ""), o.get("checked") ? 'aria-checked="true"' : "", 'style="' + i.getCbxStyle.apply(this, arguments) + '"'));
                if (o.get("checked")) {
                    n.tdCls += " " + f + "checked";
                }
            }
            return c.join("") + e.apply(t, arguments);
        };
        kerio.wm.view.FolderTreeColumn.prototype.initComponent.apply(this, arguments);
    },
    getCbxStyle: function() {
        return "";
    }
});

Ext.define("kerio.wm.view.calendar.AgendaScroller", {
    alias: "widget.agendascroller",
    constructor: function(e) {
        var t = this;
        Ext.apply(t, e);
        t._indexToStartMap = Ext.create("Ext.util.HashMap");
        t._indexToEndMap = Ext.create("Ext.util.HashMap");
        t.bindView(e.view);
        t.bindStore(t.store);
        this.callParent(arguments);
    },
    bindStore: function(e) {
        e.on("remove", function() {
            this._createIndexMap();
        }, this);
    },
    bindView: function(e) {
        var t = this, i = {
            scroll: {
                fn: t.onViewScroll,
                element: "el",
                scope: t
            },
            render: {
                fn: t.onViewRender,
                scope: t,
                single: !0
            },
            resize: t.onViewResize,
            boxready: {
                fn: t.onViewResize,
                scope: t,
                single: !0
            },
            beforerefresh: t.beforeViewRefresh,
            refresh: t.onViewRefresh,
            scope: t,
            destroyable: !0
        };
        t.rowHeight = 0;
        t._headerHeight = 0;
        t.view = e;
        t.grid = t.view.up("tablepanel");
        t.store = e.store;
        if (e.rendered) {
            delete i.render;
            t.onViewRender();
        }
        t.view.refreshSize = Ext.Function.createInterceptor(t.view.refreshSize, t.beforeViewRefreshSize, t);
        t.position = 0;
        t.lastPosition = 0;
        if (!t.grid) {
            t.view.on({
                added: function() {
                    t.grid = t.view.up("tablepanel");
                    t.panel = t.grid || t.panel;
                },
                single: !0
            });
        }
        t.panel = t.grid || t.panel;
        t.viewListeners = t.view.on(i);
    },
    unbindView: function() {
        var e = this, t = e.view;
        if (t) {
            if (t.el) {
                t.el.un("scroll", e.onViewScroll, e);
            }
        }
        Ext.destroy(e.viewListeners);
    },
    _init: function() {
        var e = this.getPanel(), t = e && e.el;
        this._determineScroller();
        if (t) {
            t.dom.scrollTop = 0;
            this.view.el.dom.scrollTop = 0;
        }
        e.handleEvents();
    },
    scrollToRecord: function(e, t) {
        var i = this.store.indexOf(e);
        this.scrollToIndex(i, t);
    },
    scrollToIndex: function(e, t) {
        if (!this._scrollerActive || 0 > e) {
            return;
        }
        if (e > 0) {
            this._counter = ++this._counter || 1;
        }
        var i, s, n, o, r, a, l = this, d = l.position, c = l.getVisibleTop(e), h = l.view.el, u = l.clientHeight;
        if (d > c) {
            o = e;
        } else {
            i = this.getVisibleIndex(d);
            if (t) {
                if (i != e || d !== (e > 0 ? this._indexToEndMap[e - 1] : 0)) {
                    o = e;
                }
            } else {
                s = this.getVisibleIndex(d + u, i);
                if (e >= s && !t) {
                    r = i + e - s + 1;
                    n = this.getVisibleBottom(e);
                    for (o = r; e > o; ++o) {
                        if (this._indexToEndMap.get(o - 1) + u >= n) {
                            break;
                        }
                    }
                }
            }
        }
        if (void 0 !== o) {
            l.position = Math.min(o > 0 ? this._indexToEndMap.get(o - 1) : 0, l.scrollHeight - l.clientHeight);
            l._scrollingToPosition = !0;
            h.scrollTo("top", l.position);
            a = !0;
        }
        l._pivotRecord = void 0;
        return a;
    },
    getVisibleTop: function(e) {
        return this._indexToStartMap.get(e);
    },
    getVisibleBottom: function(e) {
        return this._indexToEndMap.get(e);
    },
    _getVisibleIndexRecursive: function(e, t, i, s, n, o) {
        var r = Math.ceil((s + n) / 2), a = i.get(r);
        if (a >= e && (r === o || a > t)) {
            if (r === n) {
                return r;
            } else {
                return this._getVisibleIndexRecursive(e, t, i, s, r, o);
            }
        } else {
            if (r !== n) {
                return this._getVisibleIndexRecursive(e, t, i, r, n, o);
            }
        }
    },
    getVisibleIndex: function(e, t, i) {
        var s, n = i ? this._indexToStartMap : this._indexToEndMap, o = n.getCount() - 1, r = e + (i ? 0 : this.rowHeight / 3), a = t || 0;
        if (0 > o) {
            return;
        } else {
            if (1 > o - t) {
                if (i || n.get(o) >= e) {
                    return o;
                }
            } else {
                if (n.get(a) >= r) {
                    return a;
                } else {
                    if (n.get(o) <= r) {
                        return o;
                    } else {
                        s = this._getVisibleIndexRecursive(e, r, n, a, o, o);
                        if (i && s > 0) {
                            --s;
                        }
                        return s;
                    }
                }
            }
        }
    },
    getTopIndex: function() {
        if (!this._scrollerActive) {
            return -1;
        }
        var e = this.getVisibleIndex(this.position);
        if (this._scrolled && e > 0 && e < this._indexToEndMap.getCount() - 1 && this.getVisibleBottom(e - 1) < this.position - this.rowHeight / 3) {
            ++e;
        }
        return e;
    },
    getBottomIndex: function() {
        if (!this._scrollerActive) {
            return -1;
        }
        var e = this.position, t = this.view, i = t.el, s = i.getHeight();
        return this.getVisibleIndex(e + s, 0, !0);
    },
    _determineScroller: function() {
        var e = this, t = e.view, i = t.el, s = i && i.dom;
        this._scrollerActive = !1;
        if (t.viewReady) {
            e.clientHeight = s ? s.clientHeight : 0;
            e.scrollHeight = s ? s.scrollHeight : 0;
            if (e.scrollHeight > e.clientHeight) {
                this._recalculateScroller(e.clientHeight);
                this._scrollerActive = !0;
            }
        }
        return this._scrollerActive;
    },
    _recalculateScroller: function(e) {
        var t = this, i = t.view, s = i.el, n = 1;
        if (!t.rowHeight) {
            t.rowHeight = Math.floor(s.down(i.getItemSelector()).getHeight(!1, !0));
        }
        if (!t._headerHeight) {
            t._headerHeight = Math.floor(s.down(".x-grid-group-hd").getHeight(!1, !0));
        }
        this._createIndexMap();
        n = this._getLastValue();
        if (n && (!this.lastHeight || this.lastHeight < e)) {
            this.getPanel().handleScrollerEnabled();
        }
        this.lastHeight = n;
        if (isNaN(n)) {
            n = 1;
        }
        return n;
    },
    _getLastValue: function() {
        return this._indexToEndMap.get(this._indexToEndMap.getCount() - 1);
    },
    _createIndexMap: function() {
        var e, t, i, s, n = this.store, o = n.data, r = o.getCount(), a = {}, l = 0;
        this._indexToStartMap.clear();
        this._indexToEndMap.clear();
        for (t = 0; r > t; t++) {
            e = o.getAt(t);
            s = this.store.getGroupString(e);
            i = a[s];
            if (void 0 === i) {
                a[s] = s;
                l += this._headerHeight || 0;
                this._indexToStartMap.add(t, l);
                l += this.rowHeight;
                this._indexToEndMap.add(t, l);
            } else {
                this._indexToStartMap.add(t, l);
                l += this.rowHeight;
                this._indexToEndMap.add(t, l);
            }
        }
    },
    getIdPos: function(e) {
        var t = this.store.indexOfId(e);
        if (t >= 0) {
            return this.getVisibleTop(t) - this.position;
        } else {
            return -1;
        }
    },
    invalidate: function() {},
    onViewRender: function() {
        this._init();
    },
    beforeViewRefreshSize: function() {
        var e = this, t = e.view;
        if (!e._scrollingToPosition) {
            e.position = t.el.dom.scrollTop;
        }
        if (e._pivotRecord && this.store.indexOf(e._pivotRecord) >= 0) {
            t.ignoreTopScroll(!0);
        }
    },
    beforeViewRefresh: function() {
        var e, t = this, i = t.view;
        t.focusOnRefresh = Ext.Element.getActiveElement === i.el.dom;
        if (!t._pivotRecord || this.store.indexOf(t._pivotRecord) < 0) {
            e = t.getTopIndex();
            t._pivotRecord = t.store.getAt(e >= 0 ? e : 0);
        }
        if (t._pivotRecord) {
            i.ignoreTopScroll(!0);
        }
    },
    onViewRefresh: function() {
        var e = this, t = e.view, i = t.el, s = i.dom;
        if (e.focusOnRefresh) {
            i.focus();
            e.focusOnRefresh = !1;
        }
        t.ignoreTopScroll(!1);
        e.disabled = !0;
        if (!this._determineScroller()) {
            e._pivotRecord = void 0;
            e.lastPosition = e.position = s.scrollTop = 0;
            e._scrollingPosition = !1;
            e._scrolled = !1;
            return;
        }
        if (!e._scrollingToPosition) {
            e.position = s.scrollTop;
        }
        if (e._pivotRecord) {
            this.scrollToRecord(e._pivotRecord, !0);
        }
        e.disabled = !1;
    },
    onViewScroll: function(e, t) {
        var i = this, s = t.scrollTop, n = !i._scrollingToPosition && s > i.position;
        if (i._scrollingToPosition && i.position !== s) {
            t.scrollTop = i.position;
        } else {
            i._scrollingToPosition = !1;
            i.position = s;
        }
        i._scrolled = !1;
        if (!i.disabled && i.lastPosition !== i.position && !i._scrollingToPosition) {
            i.handleViewScroll(n);
        }
    },
    handleViewScroll: function(e) {
        var t, i, s, n, o, r = this, a = r.clientHeight;
        r._scrolled = e;
        s = this.getTopIndex();
        if (s >= 0) {
            i = s > 0 && this.getVisibleBottom(s - 1);
            t = i > r.position ? i : r.position;
            n = this.getVisibleIndex(a + t, s, !0);
            o = t > r.lastPosition && a + t >= this._indexToEndMap.get(this._indexToStartMap.getCount() - 1);
            this.getPanel().handleScrollChange(s, n, o);
        }
        r.lastPosition = r.position;
    },
    onViewResize: function(e, t, i) {
        var s = this, n = e && e.el;
        s.clientHeight = n ? n.dom.clientHeight : 0;
        s.handleViewScroll(s.lastScrollDirection || 1);
    },
    getPanel: function() {
        return this.grid || this.panel;
    },
    _endScrollerIndex: function() {
        var e, t, i = this;
        if (i._scrollerActive) {
            e = i.scrollHeight - i.clientHeight;
            for (t = i._indexToEndMap.getCount() - 2; t >= 0; --t) {
                if (i._indexToEndMap.get(t) < e) {
                    ++t;
                    break;
                }
            }
            return t;
        } else {
            return 0;
        }
    },
    setPivotRecord: function(e) {
        this._pivotRecord = e;
    },
    destroy: function() {
        this.unbindView();
    }
});

Ext.define("kerio.wm.view.calendar.viewPanel.ContextMenu", {
    extend: "Ext.Component",
    alias: "widget.k_viewpanelcontextmenu",
    singleton: !0,
    styles: !0,
    constructor: function(e) {
        this.mixins.observable.constructor.call(this);
        this.addEvents("newalldayevent", "newpartdayevent", "editevent", "removeevent");
        this._k_emptySpaceContext = Ext.create("Ext.menu.Menu", {
            plain: !0,
            defaults: {
                scope: this
            },
            items: [ {
                text: k_tr("New Event", "calendar"),
                handler: this.k_newPartDayEvent
            }, {
                text: k_tr("New All Day Event", "calendar"),
                handler: this.k_newAllDayEvent
            }, {
                xtype: "menuseparator"
            }, {
                text: k_tr("Print", "calendar"),
                handler: this.printCalendar,
                hidden: Ext.isIE8
            } ]
        });
        this._k_eventContext = Ext.create("Ext.menu.Menu", {
            plain: !0,
            defaults: {
                scope: this
            },
            items: [ {
                text: k_tr("Open", "calendar"),
                handler: this._editEvent,
                k_publicAccessOnly: !0
            }, {
                text: k_tr("Calendar", "calendar"),
                handler: this._k_moveToCalendar,
                scope: this,
                itemId: "moveToCalendar",
                hideOnClick: !1,
                k_writeAccessOnly: !0,
                menu: {
                    bodyCls: "moveToCalendar",
                    plain: !1,
                    items: []
                }
            }, {
                text: k_tr("Send Email to Attendees", "calendar"),
                handler: this._k_sendMailToAttendees,
                scope: this,
                itemId: "sendMailToAttendees"
            }, {
                text: k_tr("Delete", "common"),
                iconCls: "calDeleteIcon",
                handler: this._k_deleteEvent,
                k_writeAccessOnly: !0
            }, {
                text: k_tr("Forward as Attachment", "common"),
                itemId: "btnSendSourceAsAttachment",
                handler: this._sendSourceHandler
            }, {
                xtype: "menuseparator"
            }, {
                text: k_tr("Print Event", "calendar"),
                iconCls: "calPrintIcon",
                handler: this._printEvent
            } ],
            setSelectionContext: this.setSelectionContext,
            getSelectionRecord: this.getSelectionRecord,
            listeners: {
                hide: this.hideMenuHandler
            }
        });
        this._k_eventContextRecurrent = Ext.create("Ext.menu.Menu", {
            plain: !0,
            defaults: {
                scope: this
            },
            items: [ {
                text: k_tr("Open", "calendar"),
                handler: this._editEvent,
                k_publicAccessOnly: !0
            }, {
                text: k_tr("Calendar", "calendar"),
                handler: this._k_moveToCalendar,
                scope: this,
                itemId: "moveToCalendar",
                hideOnClick: !1,
                k_writeAccessOnly: !0,
                menu: {
                    bodyCls: "moveToCalendar",
                    plain: !1,
                    items: []
                }
            }, {
                text: k_tr("Send Email to Attendees", "calendar"),
                handler: this._k_sendMailToAttendees,
                scope: this,
                itemId: "sendMailToAttendees"
            }, {
                text: k_tr("Delete", "common"),
                id: "k_deleteItem",
                k_writeAccessOnly: !0,
                hideOnClick: !1,
                menu: {
                    defaults: {
                        scope: this,
                        handler: this._k_deleteMenuHandler
                    },
                    items: [ {
                        text: k_tr("This Event only", "calendar"),
                        k_modification: "modifyThis"
                    }, {
                        id: "k_future",
                        text: k_tr("Also future events", "calendar"),
                        k_modification: "modifyAllFollowing"
                    }, {
                        id: "k_all",
                        text: k_tr("All Events", "calendar"),
                        k_modification: "modifyAll"
                    } ]
                }
            }, {
                text: k_tr("Forward as Attachment", "common"),
                itemId: "btnSendSourceAsAttachment",
                handler: this._sendSourceHandler
     