#!/bin/bash

# to be run in the the particular domains folder, i.e. store/mail/MYDOMAIN.COM

# Stop Kerio
systemctl stop kerio-connect

# Remove AutoCompleteFolder
find . -type d -name '__wm__autoCompleteContacts' -exec rm -rf {} \;

# Rename all subfolders index.fld to index.bad
find . -type f -name 'index.fld' -exec rename s/index.fld/index.bad/ {} \;

# Rename all subfolders status.fld to status.fld.bad and touch a new blank status.bad
find . -type f -name 'status.fld' -exec rename s/status.fld/status.fld.bad/ {} \; -exec touch {} \;

# Recreate a blank status.fld in the root directory for each user
find . -maxdepth 1 -type d -exec touch "{}/status.fld" \;

# Start Kerio
systemctl start kerio-connect

# done